<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 10.07.2018
 * Time: 22:07
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shortcodes_livelist {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_shortcode( ATKP_LIVELIST_SHORTCODE, array( &$this, 'shortcode' ) );

		$redirectpage = get_option( ATKP_PLUGIN_PREFIX . '_redirectsearchresult', 0 );

		if ( $redirectpage > 0 ) {
			add_action( 'template_redirect', array( &$this, 'nomatch_redirect' ) );
		}
	}

	function nomatch_redirect() {

		$redirectpage     = get_option( ATKP_PLUGIN_PREFIX . '_redirectsearchresulttarget', '' );
		$redirectpagemode = get_option( ATKP_PLUGIN_PREFIX . '_redirectsearchresult', 0 );

		if ( $redirectpage == '' ) {
			return;
		}

		if ( is_search() ) {
			global $wp_query;
			$searchtext = ATKPTools::get_get_parameter( 's', 'string' );

			switch ( $redirectpagemode ) {
				case 1:
					if ( $wp_query->post_count == 0 ) {
						wp_redirect( get_permalink( $redirectpage ) . '?search=' . urlencode( $searchtext ) );
					}
					break;
				case 2:
					wp_redirect( get_permalink( $redirectpage ) . '?search=' . urlencode( $searchtext ) );

					break;

			}
		}


	}


	function shortcode( $atts, $content = "" ) {
		try {

			$a = shortcode_atts( array(
				'shop_ids'     => '',
				'template'     => '',
				'livetemplate' => '',
				'elementcss'   => '',
				'containercss' => '',
				'limit'        => '10',
				'filter'       => '',
			), $atts );

			$template       = 'default_live';
			$livetemplate   = 'wide';
			$elementcss     = '';
			$containercss   = '';
			$hidedisclaimer = false;
			$filter         = '';
			$limit          = '10';
			$shop_ids       = array();

			if ( isset( $a['template'] ) && ! empty( $a['template'] ) ) {
				$template = $a['template'];
			}

			if ( isset( $a['livetemplate'] ) && ! empty( $a['livetemplate'] ) ) {
				$livetemplate = $a['livetemplate'];
			}

			if ( isset( $a['filter'] ) && ! empty( $a['filter'] ) ) {
				$filter = $a['filter'];
			}

			if ( isset( $a['limit'] ) && ! empty( $a['limit'] ) ) {
				$limit = $a['limit'];
			}

			if ( isset( $a['elementcss'] ) && ! empty( $a['elementcss'] ) ) {
				$elementcss = $a['elementcss'];
			}
			if ( isset( $a['containercss'] ) && ! empty( $a['containercss'] ) ) {
				$containercss = $a['containercss'];
			}


			if ( isset( $a['hidedisclaimer'] ) && ! empty( $a['hidedisclaimer'] ) ) {
				if ( $a['hidedisclaimer'] == 'yes' ) {
					$hidedisclaimer = true;
				} else if ( $a['hidedisclaimer'] == 'no' ) {
					$hidedisclaimer = false;
				}
			}

			if ( isset( $a['shop_ids'] ) && ! empty( $a['shop_ids'] ) ) {
				$shop_ids = explode( ',', $a['shop_ids'] );
			}


			$output = new atkp_output();

			return $output->get_livelist_output( $shop_ids, $template, $livetemplate, $content, '', $elementcss, $containercss, $hidedisclaimer, '', $filter, $limit );

		} catch ( Exception $e ) {
			if ( ATKPSettings::$hideerrormessages ) {
				return '';
			} else {
				return 'Exception: ' . $e->getMessage();
			}
		}
	}
}

