<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 27.12.2018
 * Time: 10:19
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_template_parameters {
	public $data = array();

	public function __construct( $content = '', $cssContainerClass = '', $cssElementClass = '', $addtocart = '', $hidedisclaimer = 0, $tracking_id = '', $listid = '', $templateid = '', $offerstemplate = '', $imagetemplate = '' ) {
		$this->content           = $content;
		$this->cssContainerClass = $cssContainerClass;
		$this->cssElementClass   = $cssElementClass;
		$this->addtocart         = $addtocart;
		$this->hidedisclaimer    = $hidedisclaimer;
		$this->trackingid        = $tracking_id;
		$this->listid            = $listid;
		$this->templateid        = $templateid;

		if ( $listid != 0 ) {
			$this->list = atkp_list::load( ( $listid ) );
		}

		$this->offerstemplate = $offerstemplate;
		$this->imagetemplate  = $imagetemplate;

		if ( $this->offerstemplate == '' ) {
			$this->offerstemplate = atkp_options::$loader->get_moreoffers_template();
		}

		if ( $this->templateid != 0 && $this->offerstemplate == '' ) {
			$offerstemplateTemp = ATKPTools::get_post_setting( $this->templateid, ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template' );

			if ( $offerstemplateTemp != '' ) {
				$this->offerstemplate = $offerstemplateTemp;
			}

		}
		if ( $this->offerstemplate == '' ) {
			$this->offerstemplate = 'moreoffers';
		}
	}


	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}

}