<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_tools_woo {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {

	}

	public function woo_configuration_page() {
		$imported = false;

		if ( ATKPTools::exists_post_parameter( 'savewoo' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			$isactive    = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_mode', 'string' );
			$isactivetab = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_activatetab', 'bool' );
			$tabtemplate = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_tab_template', 'string' );


			//$access_key = ATKPTools::get_post_parameter(ATKP_PLUGIN_PREFIX.'_woo_access_key', 'string');
			//$secret_key = ATKPTools::get_post_parameter(ATKP_PLUGIN_PREFIX.'_woo_access_secret_key', 'string');

			$minprice  = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_price_field', 'string' );
			$maxprice  = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_saleprice_field', 'string' );
			$targeturl = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_targeturl', 'string' );
			$eanfield  = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_ean_field', 'string' );

			$keyType    = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'string' );
			$buttontext = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_buttontext', 'string' );


			$update_keys = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_update_keys', 'bool' );


			update_option( ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer', 'bool' ) );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull', 'bool' ) );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_export_productcategory', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_export_productcategory', 'bool' ) );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction', 'bool' ) );





			update_option( ATKP_PLUGIN_PREFIX . '_woo_imagegallery', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_imagegallery', 'int' ) );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_importimage', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_importimage', 'int' ) );

			$woo_exportdescription      = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 'int' );
			$woo_exportshortdescription = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 'int' );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_woo_product_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_product_template', 'html' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate', 'html' ) );


			update_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', $eanfield );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_mode', $isactive );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_activatetab', $isactivetab );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_tab_template', $tabtemplate );

			//update_option(ATKP_PLUGIN_PREFIX.'_woo_access_key', $access_key);
			//update_option(ATKP_PLUGIN_PREFIX.'_woo_access_secret_key', $secret_key);
			update_option( ATKP_PLUGIN_PREFIX . '_woo_price_field', $minprice );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_saleprice_field', $maxprice );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_targeturl', $targeturl );

			update_option( ATKP_PLUGIN_PREFIX . '_woo_buttontext', $buttontext );

			update_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', $keyType );

			update_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', $woo_exportdescription );
			update_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', $woo_exportshortdescription );

			update_option( ATKP_PLUGIN_PREFIX . '_woo_message', '' );

			if ( $isactive != '' ) {
				$export = atkp_export_provider_base::get_provider( 'woo' );

				$message = $export->check();

				update_option( ATKP_PLUGIN_PREFIX . '_woo_message', $message );

				$importresults = array();

				if ( $isactive == 'woo-at' ) {

					array_push( $importresults, '*** import started: ' . date( "Y-m-d H:i:s" ) );

					if ( $message != '' ) {
						array_push( $importresults, '*** import error: ' . $message );
					} else {
						$message = $export->checklogon();

						//importiere alle woo produkte ins at
						$args = array(
							'post_type'      => array( 'product' ),
							'posts_per_page' => - 1
						);

						$the_query = new WP_Query( $args );

						while ( $the_query->have_posts() ) {
							try {
								$the_query->the_post();

								$prdid = $export->import_product( $the_query->post->ID );

								array_push( $importresults, '*** product ' . $the_query->post->ID . ' imported: ' . $the_query->post->ID );
							} catch ( Exception $e ) {
								array_push( $importresults, '*** product ' . $the_query->post->ID . ' exception: ' . $e->getMessage() );
							}
						}
						wp_reset_postdata();
					}

					array_push( $importresults, '*** import finished: ' . date( "Y-m-d H:i:s" ) );
					update_option( ATKP_PLUGIN_PREFIX . '_woo_importresult', implode( "\n", $importresults ) );
				}

				if ( $update_keys ) {
					//lade alle woocommerce produkte
					//lade das ean oder das product id feld
					//suche das produkt im AT
					//wenn gefunden, dann setze die gegenüber ID in das keyfeld


					$args = array(
						'post_type'      => array( 'product' ),
						'posts_per_page' => - 1
					);

					$the_query = new WP_Query( $args );

					while ( $the_query->have_posts() ) {
						try {
							$the_query->the_post();

							$message = $export->update_key_product( $the_query->post->ID );

							array_push( $importresults, '*** product-key ' . $the_query->post->ID . ' updated: ' . $the_query->post->ID . ' ' . $message );
						} catch ( Exception $e ) {
							array_push( $importresults, '*** product-key ' . $the_query->post->ID . ' exception: ' . $e->getMessage() );
						}
					}

					wp_reset_postdata();

					update_option( ATKP_PLUGIN_PREFIX . '_woo_importresult', implode( "\n", $importresults ) );
				}
			}

		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		//$apikey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_key');
		//$apisecretkey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_secret_key');

		$error = get_option( ATKP_PLUGIN_PREFIX . '_woo_message' );

		//if($apikey == '') {
		//    $error =     __('Access data not defined.', ATKP_PLUGIN_PREFIX);
		//}

		if ( ! class_exists( 'WooCommerce' ) ) {
			$access_test = '<span style="color:red">' . __( 'Not connected', ATKP_PLUGIN_PREFIX ) . ' (' . __( 'WooCommmerce Plugin is not installed', ATKP_PLUGIN_PREFIX ) . ')</span>';
		} else {
			if ( ( $error == null || empty( $error ) ) ) {
				$access_test = '<span style="color:green">' . __( 'Connected', ATKP_PLUGIN_PREFIX ) . '</span>';
			} else {
				$access_test = '<span style="color:red">' . __( 'Not connected', ATKP_PLUGIN_PREFIX ) . ' (' . $error . ')</span>';
			}
		}

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="atkp-content wrap">
            <div class="inner">
                <!-- <h2><?php _e( 'Affiliate Toolkit - Woo', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-tools&tab=' . $tab ?>"
                      enctype="multipart/form-data"><!--_affiliate_toolkit-bestseller-->
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">
                        <tr valign="top">
                            <th scope="row">
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_activate' ?>">
									<?php _e( 'WooCommerce mode', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
								<?php echo ATKPHomeLinks::GetHelpIcon( 'setting-woo' ); ?>
                            </th>
                            <td>
                                <select <?php if ( ! class_exists( 'WooCommerce' ) ) {
									echo 'disabled';
								} ?> id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_mode' ?>"
                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_mode' ?>" style="width:300px">
									<?php

									$durations = array(
										''       => __( 'Disabled', ATKP_PLUGIN_PREFIX ),
										'at-woo' => __( 'affiliate-toolkit->WooCommerce', ATKP_PLUGIN_PREFIX ),
										'woo-at' => __( 'WooCommerce->affiliate-toolkit', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Status', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
								<?php echo $access_test; ?>
                            </td>
                        </tr>
						<?php /* ?>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
                                    <?php _e('Consumer Key (API-key)', ATKP_PLUGIN_PREFIX) ?>:
                                </label> 
                            </th>
                            <td>
                                <input  style="width:40%" type="text" id="<?php echo ATKP_PLUGIN_PREFIX.'_woo_access_key' ?>" name="<?php echo ATKP_PLUGIN_PREFIX.'_woo_access_key' ?>" value="<?php echo $apikey; ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
                                    <?php _e('Consumer Secret (API secret)', ATKP_PLUGIN_PREFIX) ?>:
                                </label> 
                            </th>
                            <td>
                                <input  style="width:40%" type="password" id="<?php echo ATKP_PLUGIN_PREFIX.'_woo_access_secret_key' ?>" name="<?php echo ATKP_PLUGIN_PREFIX.'_woo_access_secret_key' ?>" value="<?php echo $apisecretkey; ?>">
                            </td>
                        </tr>
                        <?php */ ?>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_activatetab' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_activatetab' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_woo_activatetab', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_activatetab' ?>">
									<?php _e( 'Activate price comparison tab for WooCommerce', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button text', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input style="width:40%" type="text"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_buttontext' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_buttontext' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_woo_buttontext', '' ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Price comparison tab template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_tab_template' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_tab_template' ?>"
                                        style="width:300px">
									<?php
									$sel = get_option( ATKP_PLUGIN_PREFIX . '_woo_tab_template', '' );

									echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';

									global $post;
									$args        = array(
										'post_type'      => ATKP_TEMPLATE_POSTTYPE,
										'posts_per_page' => 300,
										'post_status'    => 'publish'
									);
									$posts_array = get_posts( $args );
									foreach ( $posts_array as $prd ) {
										echo '<option value="' . $prd->ID . '" ' . selected( $prd->ID, $sel, false ) . '>' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
									};

									?>
                                </select>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Regular Price', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_price_field' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_price_field' ?>"
                                        style="width:300px">
									<?php

									$durations = array(
										'default'   => __( 'Default', ATKP_PLUGIN_PREFIX ),
										'min_price' => __( 'Minimum Price', ATKP_PLUGIN_PREFIX ),
										'max_price' => __( 'Maximum Price', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_woo_price_field', 'default' ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Sale Price', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_saleprice_field' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_saleprice_field' ?>"
                                        style="width:300px">
									<?php

									$durations = array(
										'default'   => __( 'Default', ATKP_PLUGIN_PREFIX ),
										'min_price' => __( 'Minimum Price', ATKP_PLUGIN_PREFIX ),
										'max_price' => __( 'Maximum Price', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_woo_saleprice_field', 'default' ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull' ?>">
									<?php _e( 'Hide product when price is empty and publish product when price exists', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input <?php echo ! get_option( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', false ) ? 'disabled' : '' ?>
                                        type="checkbox"
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_export_productcategory' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_export_productcategory' ?>"
                                        value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', false ) && get_option( ATKP_PLUGIN_PREFIX . '_woo_export_productcategory', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_export_productcategory' ?>">
									<?php _e( 'Export product categories to WooCommerce', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input <?php echo ! get_option( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', false ) ? 'disabled' : '' ?>
                                        type="checkbox"
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction' ?>"
                                        value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', false ) && get_option( ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction' ?>">
				                    <?php _e( 'Use old copy function for categories (Only one category)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Key type', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_keytype' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_keytype' ?>" style="width:300px">
									<?php

									$durations = array(
										'ean' => __( 'EAN', ATKP_PLUGIN_PREFIX ),
										'id'  => __( 'affiliate-toolkit ID (recommended)', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'id' ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                                <br/>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_update_keys' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_update_keys' ?>" value="1">
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_update_keys' ?>">
									<?php _e( 'Replace IDs in WooCommerce product upon saving (EAN with ID resp. vice versa)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Custom EAN field', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input style="width:40%" type="text"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_ean_field' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_ean_field' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' ) ) ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Shop Button Target', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_targeturl' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_targeturl' ?>" style="width:300px">
									<?php

									$durations = array(
										'default'   => __( 'Default', ATKP_PLUGIN_PREFIX ),
										'min_price' => __( 'Minimum Price', ATKP_PLUGIN_PREFIX ),
										'max_price' => __( 'Maximum Price', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_woo_targeturl', 'default' ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Product image', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_importimage' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_importimage' ?>"
                                        style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_woo_importimage', 1 );

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'No image from plugin', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Import main image', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Use external main image', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Image gallery', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_imagegallery' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_imagegallery' ?>"
                                        style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_woo_imagegallery', 0 );

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'No images from plugin', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Use external images (experimental)', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Import images', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="radio" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription' ?>"
                                       value="0" <?php echo checked( 0, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription' ?>">
									<?php _e( 'Don\'t export description', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                                <input type="radio" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription2' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription2' ?>">
									<?php _e( 'Export description', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <input type="radio" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription3' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription' ?>"
                                       value="2" <?php echo checked( 2, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportdescription3' ?>">
									<?php _e( 'Description template', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="">
									<?php _e( 'Description template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>


								<?php
								wp_editor( stripslashes( get_option( ATKP_PLUGIN_PREFIX . '_woo_product_template', __( '
[atkp_product field=\'description_text\'][/atkp_product]
<br /><br />
<h2>Features</h2>
[atkp_product field=\'features_text\'][/atkp_product]
<br /><br />
[atkp_product field=\'shoplogo\'][/atkp_product]
', ATKP_PLUGIN_PREFIX ) ) ), ATKP_PLUGIN_PREFIX . '_woo_product_template', array(
									'media_buttons' => false,
									'textarea_name' => ATKP_PLUGIN_PREFIX . '_woo_product_template',
									'textarea_rows' => 15,
								) );
								?>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="radio"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription' ?>"
                                       value="0" <?php echo checked( 0, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription' ?>">
									<?php _e( 'Don\'t export short description', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                                <input type="radio"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription2' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription2' ?>">
									<?php _e( 'Export short description', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <input type="radio"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription3' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription' ?>"
                                       value="2" <?php echo checked( 2, get_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription3' ?>">
									<?php _e( 'Short description template', ATKP_PLUGIN_PREFIX ) ?>
                                </label>


                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="">
									<?php _e( 'Short description template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>


								<?php
								wp_editor( stripslashes( get_option( ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate', __( '
[atkp_product field=\'shoplogo\'][/atkp_product]
', ATKP_PLUGIN_PREFIX ) ) ), ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate', array(
									'media_buttons' => false,
									'textarea_name' => ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate',
									'textarea_rows' => 10,
								) );
								?>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer' ?>">
									<?php _e( 'Show disclaimer', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


						<?php
						$asa_importresult = get_option( ATKP_PLUGIN_PREFIX . '_woo_importresult' );

						if ( $asa_importresult != '' ) {
							?>
                            <tr>


                                <th scope="row">
                                    <label for="">
										<?php _e( 'Last import result', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>


                                    <textarea readonly style="width:100%;height:400px"
                                              id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_importresult' ?>"
                                              name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_importresult' ?>"><?php echo esc_textarea( $asa_importresult ); ?></textarea>

                                </td>
                            </tr>
						<?php } ?>

						<?php


						?>


                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr valign="top">

                            <td>
								<?php submit_button( '', 'primary', 'savewoo', false ); ?>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>

        </div> <?php
	}
}

if ( class_exists( 'WooCommerce' ) && get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' ) == 'woo-at' ) {
	add_action( 'save_post', 'my_affiliate_toolkit_woo_callback' );
}

function my_affiliate_toolkit_woo_callback( $post_id ) {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	$posttype = ATKPTools::get_post_parameter( 'post_type', 'string' );

	if ( 'product' != $posttype ) {
		return;
	}

	try {
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', __( 'Connecting...', ATKP_PLUGIN_PREFIX ) );


		$export = atkp_export_provider_base::get_provider( 'woo' );

		$message = $export->checklogon();

		if ( $message != '' ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( 'import_product woo message: ' . $message );
			}
		} else {
			$export->import_product( $post_id );
		}

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', null );

	} catch ( Exception $e ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogError( 'import_product woo error: ' . $e->getMessage() );
		}
	}
}


if ( class_exists( 'WooCommerce' ) && get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' ) != '' ) {
	/*
		ATKPTools::add_column( 'product', __( 'affiliate-toolkit', ATKP_PLUGIN_PREFIX ), function ( $woo_id ) {
			affiliate_toolkit_display_woo_link($woo_id);
		}, 3 );
	*/

	/*
	 * Add the extra options to the 'Publish' box
	 */
	add_action( 'post_submitbox_misc_actions', 'my_affiliate_toolkit_add_publish_meta_options' );


	if ( get_option( ATKP_PLUGIN_PREFIX . '_woo_activatetab', 0 ) ) {
		add_filter( 'woocommerce_product_tabs', 'my_affiliate_toolkit_woo_product_tab' );
	}

	if ( get_option( ATKP_PLUGIN_PREFIX . '_woo_showdisclaimer', 0 ) ) {
		add_action( 'woocommerce_after_single_product', 'my_affiliate_toolkit_woo_product_content' );
	}

}



function affiliate_toolkit_display_woo_link( $woo_id ) {
	$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );
	$keytype  = get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'ean' );

	if ( $eanfield == '' || $eanfield == 'sku' ) {
		$ean = ATKPTools::get_post_setting( $woo_id, '_sku' );
	} else {
		$ean = ATKPTools::get_post_setting( $woo_id, $eanfield );
	}

	if ( $keytype == 'id' ) {
		$exists = atkp_product::exists( $ean );

		if ( $exists ) {
			$product = $ean;
		}
	} else {
		$product = atkp_product::idbyean( $ean );
	}



	if ( isset( $product ) && $product != '' && $product != 0 ) {
		$title = __( 'Show AT product', ATKP_PLUGIN_PREFIX );
		echo sprintf( __( '<a href="%s" target="_blank">%s</a> ', ATKP_PLUGIN_PREFIX ), get_edit_post_link( $product ), $title );
	} else {
		echo '-';
	}


	$updatedon = ATKPTools::get_post_setting( $woo_id, ATKP_PLUGIN_PREFIX . '_updatedon');

	if($updatedon != null)
    {
        echo '<br />'. __('Updated on: ', ATKP_PLUGIN_PREFIX) . ATKPTools::get_formatted_date($updatedon) . ' '. ATKPTools::get_formatted_time($updatedon);
    }

}


function my_affiliate_toolkit_add_publish_meta_options( $post_obj ) {

	global $post;
	if ( $post != null && 'product' == $post->post_type ) {

		echo '<div class="misc-pub-section">';
		affiliate_toolkit_display_woo_link( $post_obj->ID );
		echo '</div>';
	}
}

function my_affiliate_toolkit_woo_product_content() {
	$content = '';
	if ( is_single() && get_post_type() == 'product' ) {
		$content .= '<p>[atkp_product field=\'disclaimer\'][/atkp_product]</p>';
	}
	echo do_shortcode( $content );
}

function my_affiliate_toolkit_woo_product_tab( $tabs ) {

	// Adds the new tab

	$tabs['offers'] = array(
		'title'    => __( 'Price Comparison', ATKP_PLUGIN_PREFIX ),
		'priority' => 15,
		'callback' => 'my_affiliate_toolkit_woo_product_tabcontent'
	);

	return $tabs;

}

function my_affiliate_toolkit_woo_product_tabcontent() {

	global $post;

	$product_id = $post->ID;
	$template   = get_option( ATKP_PLUGIN_PREFIX . '_woo_tab_template', 'detailoffers' );

	if ( $template == '' ) {
		$template = 'detailoffers';
	}

	$product = new WC_Product( $product_id );

	$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );
	$keytype  = get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'ean' );
	$ean      = '';

	if ( $eanfield == '' || $eanfield == 'sku' ) {
		$ean = $product->get_sku();
	} else {
		$ean = ATKPTools::get_post_setting( $product_id, $eanfield );
	}

	//echo '<h2>'.__( 'Price Compare', ATKP_PLUGIN_PREFIX ).'</h2>';
	if ( $ean == '' ) {
		echo __( 'Price comparison is not available.', ATKP_PLUGIN_PREFIX );
	} else {
		if ( $keytype == 'id' ) {
			echo do_shortcode( '<p>[atkp_product id=\'' . $ean . '\' template=\'' . $template . '\'][/atkp_product]</p>' );
		} else {
			echo do_shortcode( '<p>[atkp_product ean=\'' . $ean . '\' template=\'' . $template . '\'][/atkp_product]</p>' );
		}
	}

}

?>