<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

// Creating the widget 
class atkp_filterwidget extends WP_Widget {

	function __construct() {
		parent::__construct(
		// Base ID of your widget
			ATKP_FILTER_WIDGET,

			// Widget name will appear in UI
			__( 'affiliate-toolkit filter widget', ATKP_PLUGIN_PREFIX ),

			// Widget description
			array( 'description' => __( 'Shows a searchform.', ATKP_PLUGIN_PREFIX ), )
		);


		//add_action('admin_footer', array($this, 'add_script_footer'));
	}

	function add_script_footer() {
		?>

        <script type="text/javascript">

			<?php $searchnounce = wp_create_nonce( 'atkp-search-nonce' ); ?>

            function formatRepo(value) {
                if (value.loading) return value.text;

                if (value.id == '')
                    return "<?php _e( 'no product', ATKP_PLUGIN_PREFIX ) ?>";

                var outputresult = '<table style="width:100%">';
                outputresult += '<tr style="height:50px;">';
                outputresult += '<td style="margin-left:3px;width:60px;height:50px;text-align:center"><img style="max-width:50px" src="' + value.imageurl + '" /></td>';
                outputresult += '<td><span style="font-size:10px">ID: ' + value.id + ' - ' + value.shop + '</span><br /><b>' + value.title + '</b></td>';
                outputresult += '</tr>';
                outputresult += '</table>';

                return outputresult;
            }

            function formatList(value) {
                if (value.loading) return value.text;

                if (value.id == '')
                    return "<?php _e( 'no list', ATKP_PLUGIN_PREFIX ) ?>";

                var outputresult = '<table style="width:100%">';
                outputresult += '<tr style="height:50px;">';
                outputresult += '<td><span style="font-size:10px">ID: ' + value.id + ' - ' + value.shop + '</span><br /><b>' + value.title + '</b></td>';
                outputresult += '</tr>';
                outputresult += '</table>';

                return outputresult;
            }

            function formatRepoSelection(repo) {
                if (repo.id == '')
                    return "<?php _e( 'no product', ATKP_PLUGIN_PREFIX ) ?>";
                else
                    return (repo.text || (repo.title) + ' (' + repo.id + ')');
            }

            function formatListSelection(repo) {
                if (repo.id == '')
                    return "<?php _e( 'no list', ATKP_PLUGIN_PREFIX ) ?>";
                else
                    return (repo.text || (repo.title) + ' (' + repo.id + ')');
            }

            var $j = jQuery.noConflict();
            $j(document).ready(function ($) {
                //atkp_txt_prdsearch
                //atkp_btn_prdsearch
                //atkp_prdresult
                //atkp_prdloading

				<?php $disable_select2 = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disableselect2', false );

				if(! $disable_select2) {
				?>

                $j("#<?php echo $this->get_field_id( ATKP_WIDGET . '_product' ); ?>").select2({

                    ajax: {
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                action: "atkp_search_local_products",
                                type: "<?php echo ATKP_PRODUCT_POSTTYPE; ?>",
                                request_nonce: "<?php echo $searchnounce; ?>",
                                keyword: params.term
                            };
                        },
                        processResults: function (data, params) {
                            var count = 0;
                            $j.each(data, function (key, value) {
                                count++;
                            });

                            if (count > 0) {

                                if (typeof data[0].error != 'undefined') {
                                    alert(data[0].error + ": " + data[0].message);
                                } else {

                                }

                            }


                            var noselection = {id: "", name: "<?php _e( 'no product', ATKP_PLUGIN_PREFIX ) ?>"};

                            if (count == 0)
                                data = [];

                            data.splice(0, 0, noselection);

                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            return {
                                results: data,
                                pagination: {
                                    more: false
                                }
                            };
                        },
                        cache: true
                    },
                    escapeMarkup: function (markup) {
                        return markup;
                    }, // let our custom formatter work
                    minimumInputLength: 3,
                    templateResult: formatRepo, // omitted for brevity, see the source of this page
                    templateSelection: formatRepoSelection // omitted for brevity, see the source of this page
                });

                $j("#<?php echo $this->get_field_id( ATKP_WIDGET . '_list' ); ?>").select2({

                    ajax: {
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                action: "atkp_search_local_products",
                                type: "<?php echo ATKP_LIST_POSTTYPE; ?>",
                                request_nonce: "<?php echo $searchnounce; ?>",
                                keyword: params.term
                            };
                        },
                        processResults: function (data, params) {
                            var count = 0;
                            $j.each(data, function (key, value) {
                                count++;
                            });

                            if (count > 0) {

                                if (typeof data[0].error != 'undefined') {
                                    alert(data[0].error + ": " + data[0].message);
                                } else {

                                }

                            }


                            var noselection = {id: "", name: "<?php _e( 'no list', ATKP_PLUGIN_PREFIX ) ?>"};

                            if (count == 0)
                                data = [];

                            data.splice(0, 0, noselection);

                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            return {
                                results: data,
                                pagination: {
                                    more: false
                                }
                            };
                        },
                        cache: true
                    },
                    escapeMarkup: function (markup) {
                        return markup;
                    }, // let our custom formatter work
                    minimumInputLength: 3,
                    templateResult: formatList, // omitted for brevity, see the source of this page
                    templateSelection: formatListSelection // omitted for brevity, see the source of this page
                });

				<?php } ?>

            });
        </script>

		<?php
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {

		$title = apply_filters( 'widget_title', isset( $instance[ ATKP_WIDGET . '_title' ] ) ? $instance[ ATKP_WIDGET . '_title' ] : '', $instance );
		// before and after widget arguments are defined by themes

		$targetpage = 0;
		$template   = 'searchbox';
		$content    = '';

		if ( isset( $instance[ ATKP_WIDGET . '_targetpage' ] ) ) {
			$targetpage = intval( $instance[ ATKP_WIDGET . '_targetpage' ] );
		}

		if ( isset( $instance[ ATKP_WIDGET . '_template' ] ) && ! empty( $instance[ ATKP_WIDGET . '_template' ] ) ) {
			$template = $instance[ ATKP_WIDGET . '_template' ];
		}

		if ( isset( $instance[ ATKP_WIDGET . '_content' ] ) && ! empty( $instance[ ATKP_WIDGET . '_content' ] ) ) {
			$content = $instance[ ATKP_WIDGET . '_content' ];
		}


		if ( $template == '' || ATKP_PLUGIN_VERSION < 30 ) {
			$template = 'searchbox';
		}

		require_once ATKP_PLUGIN_DIR . '/includes/atkp_output.php';

		$output = new atkp_output();


		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		try {
			echo $output->get_searchform_output( $template, $targetpage, $content );
		} catch ( Exception $e ) {
			echo 'Exception: ' . $e->getMessage();
		}

		echo $args['after_widget'];


	}

	// Widget Backend
	public function form( $instance ) {

		// Widget admin form
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', ATKP_PLUGIN_PREFIX ); ?></label>:
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
                   name="<?php echo $this->get_field_name( ATKP_WIDGET . '_title' ); ?>" type="text"
                   value="<?php echo isset( $instance[ ATKP_WIDGET . '_title' ] ) ? esc_attr( $instance[ ATKP_WIDGET . '_title' ] ) : ''; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( ATKP_WIDGET . '_targetpage' ); ?>"><?php _e( 'Target page', ATKP_PLUGIN_PREFIX ); ?>
                :</label>
            <select style="width: 100%" class="widefat"
                    id="<?php echo $this->get_field_id( ATKP_WIDGET . '_targetpage' ); ?>"
                    name="<?php echo $this->get_field_name( ATKP_WIDGET . '_targetpage' ); ?>">
				<?php


				global $post;
				$args        = array( 'post_status' => array( 'publish', 'draft' ) );
				$posts_array = get_pages( $args );
				foreach ( $posts_array as $prd ) {

					if ( isset( $instance[ ATKP_WIDGET . '_targetpage' ] ) && $prd->ID == $instance[ ATKP_WIDGET . '_targetpage' ] ) {
						$sel = ' selected';
					} else {
						$sel = '';
					}

					echo '<option value="' . $prd->ID . '"' . $sel . '>' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
				};


				?>
            </select>
        </p>


        <p>
            <label for="<?php echo $this->get_field_id( ATKP_WIDGET . '_template' ); ?>"><?php _e( 'Template', ATKP_PLUGIN_PREFIX ); ?>
                :</label>
            <select class="widefat" <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
				echo 'disabled';
			} ?> id="<?php echo $this->get_field_id( ATKP_WIDGET . '_template' ); ?>"
                    name="<?php echo $this->get_field_name( ATKP_WIDGET . '_template' ); ?>">
				<?php
				echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';

				$templates = atkp_template::get_list( false, true );

				foreach ( $templates as $template => $caption ) {
					if ( isset( $instance[ ATKP_WIDGET . '_template' ] ) && $template == $instance[ ATKP_WIDGET . '_template' ] ) {
						$sel = ' selected';
					} else {
						$sel = '';
					}

					echo '<option value="' . esc_attr( $template ) . '" ' . $sel . '>' . htmlentities( $caption ) . '</option>';
				} ?>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( ATKP_WIDGET . '_content' ); ?>"><?php _e( 'Content', ATKP_PLUGIN_PREFIX ); ?>
                :</label>
            <input class="widefat" <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
				echo 'disabled';
			} ?> id="<?php echo $this->get_field_id( ATKP_WIDGET . '_content' ); ?>"
                   name="<?php echo $this->get_field_name( ATKP_WIDGET . '_content' ); ?>" type="text"
                   value="<?php echo esc_attr( isset( $instance[ ATKP_WIDGET . '_content' ] ) ? $instance[ ATKP_WIDGET . '_content' ] : '' ); ?>"/>
        </p>


		<?php
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance[ ATKP_WIDGET . '_title' ]      = ( ! empty( $new_instance[ ATKP_WIDGET . '_title' ] ) ) ? strip_tags( $new_instance[ ATKP_WIDGET . '_title' ] ) : '';
		$instance[ ATKP_WIDGET . '_targetpage' ] = ( ! empty( $new_instance[ ATKP_WIDGET . '_targetpage' ] ) ) ? $new_instance[ ATKP_WIDGET . '_targetpage' ] : '';
		$instance[ ATKP_WIDGET . '_template' ]   = ( ! empty( $new_instance[ ATKP_WIDGET . '_template' ] ) ) ? $new_instance[ ATKP_WIDGET . '_template' ] : '';
		$instance[ ATKP_WIDGET . '_content' ]    = ( ! empty( $new_instance[ ATKP_WIDGET . '_content' ] ) ) ? $new_instance[ ATKP_WIDGET . '_content' ] : '';

		return $instance;
	}
} // Class wpb_widget ends here

// Register and load the widget
function atkp_load_filter_widget() {
	register_widget( ATKP_FILTER_WIDGET );
}

add_action( 'widgets_init', 'atkp_load_filter_widget' );

?>