<div class="atkp-container {{$parameters->cssContainerClass}}">
    @foreach ($products as $product)
        <div>
            <canvas id="canvas-{{$parameters->templateid}}"></canvas>
        </div>

        <script>

            var lineChartData{{$parameters->templateid}} = {
                {!! $formatter->get_monthly_pricehistory($product, false); !!}
            };

            var currencyprefix = "{!! $formatter->get_currency($product->shopid) == null ? '' : $formatter->get_currency($product->shopid)['prefix'] !!}";
            var currencysuffix = "{!! $formatter->get_currency($product->shopid) == null ? '' : $formatter->get_currency($product->shopid)['suffix'] !!}";

            var $j = jQuery.noConflict();
            $j(document).ready(function () {

                var ctx = document.getElementById('canvas-{{$parameters->templateid}}').getContext('2d');

                Chart.Line(ctx, {
                    data: lineChartData{{$parameters->templateid}},
                    options: {
                        responsive: true,
                        hoverMode: 'index',
                        stacked: false,
                        title: {
                            display: true,
                            text: '{!! $translator->get_monthlypricehistorytitle() !!}'
                        },
                        scales: {
                            yAxes: [{
                                type: 'linear', // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
                                display: true,
                                position: 'left',
                                id: 'y-axis-1',
                                ticks: {
                                    callback: function (nStr) {
                                        return atkp_format_chartnumber(nStr, 2, currencyprefix, currencysuffix);
                                    }
                                }
                            }],
                        },
                        tooltips: {
                            callbacks: {
                                label: function (tooltipItem, chart) {
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ': ' + atkp_format_chartnumber(tooltipItem.yLabel, 2, currencyprefix, currencysuffix);
                                }
                            }
                        },
                        legend: {
                            display: false,
                        }
                    }
                });
            });

        </script>

    @endforeach

</div>