<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_export_provider_woo extends atkp_export_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function check() {

		try { /*
            $apikey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_key');
			$apisecretkey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_secret_key');
            
            $message = '';
            if ($apikey != '' && $apisecretkey != '') {
                
                    if (!class_exists('WC_API_Client'))
                        require_once  ATKP_PLUGIN_DIR.'/lib/woocommerce/woocommerce-api.php';
                    
                    $options = array(
                        'ssl_verify'      => false,
                    );
                    
                    $home = get_option('home');
                    $api = new WC_API_Client($home, $apikey, $apisecretkey, $options );
                                
                    $categories = $api->products->get_categories();
                  
                    if(ATKPLog::$logenabled) {
                        ATKPLog::LogDebug('*** check_configuration woo export ***');
                        ATKPLog::LogDebug(serialize($categories));
                        ATKPLog::LogDebug('*** check_configuration woo export ***');
                    }
            } else {
                //wenn zugangscodes gelöscht werden muss message auch geleert werden
                 $message = 'Credientials are empty';  
            }
            */
			return null;
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
	}

	private $helper = null;

	public function checklogon() {
		/*
		if (!class_exists('WC_API_Client'))
						require_once  ATKP_PLUGIN_DIR.'/lib/woocommerce/woocommerce-api.php';

		$apikey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_key');
$apisecretkey = get_option(ATKP_PLUGIN_PREFIX.'_woo_access_secret_key');


		$options = array(
				'ssl_verify'      => false,
		);

		$home = get_option('home');
		$this->helper = new WC_API_Client($home, $apikey, $apisecretkey, $options );

		if($apikey == '' || $apisecretkey =='') {
				throw new Exception('Credientials are empty');
		}
		*/

	}

	public function update_key_product( $wooproductid ) {
		$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );
		$keytype  = get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'ean' );

		if ( $eanfield == '' || $eanfield == 'sku' ) {
			$ean = ATKPTools::get_post_setting( $wooproductid, '_sku' );
		} else {
			$ean = ATKPTools::get_post_setting( $wooproductid, $eanfield );
		}

		if ( $ean == null || $ean == '' ) {
			return 'ean is null';
		}

		$post_id = null;
		$exists  = true;

		//wenn keytype gleich id dann ist die EAN in den Daten

		if ( $keytype == 'ean' ) {
			//wenn keytype gleich ean dann sind die produkte mit ID des produktes gespeichert
			$exists = atkp_product::exists( $ean );

			if ( $exists ) {
				$post_id = $ean;
			}
		} else if ( $keytype == 'id' ) {
			$post_id = atkp_product::idbyean( $ean );
		}


		//wenn affiliate-toolkit produkt nicht gefunden wurde dann überspringen
		if ( $post_id == null || ! $exists ) {
			return 'AT Produkt not found: ' . $ean;
		}

		$newvalue = null;
		if ( $keytype == 'ean' ) {
			//setze die ean in das woo produkt
			$ean = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_ean' );

			if ( $ean == null || $ean == '' ) {
				return 'ean is empty';
			}

			$eans = explode( ',', $ean );

			$newvalue = $eans[0];

		} else if ( $keytype == 'id' ) {
			//setze die id in das woo produkt
			$newvalue = $post_id;
		}

		if ( $newvalue != null ) {
			if ( $eanfield == '' || $eanfield == 'sku' ) {
				ATKPTools::set_post_setting( $wooproductid, '_sku', $newvalue );
			} else {
				ATKPTools::set_post_setting( $wooproductid, $eanfield, $newvalue );
			}
		}
	}

	public function import_product( $wooproductid ) {
		$WC_Product = wc_get_product( $wooproductid );

		if ( $WC_Product == null ) {
			return;
		}

		$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );
		$keytype  = get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'ean' );

		if ( $eanfield == '' || $eanfield == 'sku' ) {
			$ean = $WC_Product->get_sku();
		} else {
			$ean = ATKPTools::get_post_setting( $wooproductid, $eanfield );
		}

		if ( $ean == null || $ean == '' ) {
			return;
		}

		if ( ( $keytype == 'ean' ) && strlen( $ean ) < 8 ) {
			return;
		}

		$post_id = null;
		$exists  = true;

		if ( $keytype == 'id' ) {
			$exists = atkp_product::exists( $ean );

			if ( $exists ) {
				$post_id = $ean;
			}
		} else {
			$post_id = atkp_product::idbyean( $ean );
		}

		$created = false;

		if ( $post_id == null ) {
			$post_id = ATKPTools::create_product( $WC_Product->get_title(), '', '', 'woo' );
			$created = true;

			if ( ! $exists && $eanfield != '' && $eanfield != 'sku' ) {
				ATKPTools::set_post_setting( $wooproductid, $eanfield, $post_id );
			}
		}

		if ( $keytype == 'ean' ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_ean', $ean );
		}

		$shopid = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shopid' );

		//schreibe die Produktinfos von woo nur rein wenn manuelles produkt
		if ( $shopid == '' ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title', $WC_Product->get_title() );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_producturl', $WC_Product->get_permalink() );

			if ( get_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 0 ) == 1 ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_description', $WC_Product->get_post_data()->post_content );
			}
			if ( get_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 0 ) ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_features', $WC_Product->get_post_data()->post_excerpt );
			}

			$imageid = $WC_Product->get_image_id();
			if ( $imageid != 0 ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', wp_get_attachment_image_src( $imageid, 'thumbnail' )[0] );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', wp_get_attachment_image_src( $imageid, 'medium' )[0] );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', wp_get_attachment_image_src( $imageid, 'large' )[0] );
			}
		}

		if ( $created ) {
			$cronjob = new atkp_wp_cronjob( array() );
			$cronjob->update_product( $post_id, 0, 0, 0, 0, 0, 1, false );

		}

		//wir sind so mutig.. wir schreiben gleich mal die preise ins woo zurück
		$this->export_product( $post_id );

		return $post_id;
	}

	public function export_product( $productid ) {

		$product         = atkp_product::load( $productid );
		$dontimportimage = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' );

		$woo_product = atkp_product::get_woo_product( $productid );
		$keytype     = get_option( ATKP_PLUGIN_PREFIX . '_woo_keytype', 'ean' );



		$eans = array();

		if ( $keytype == 'id' ) {
			array_push( $eans, $productid );
		} else {
			$eans = explode( ',', $product->ean );

			if ( $product->ean == '' ) {
				return;
			}
		}

		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** export_product woo found ***' );
			ATKPLog::LogDebug( $woo_product == null ? '(null)' : serialize( $woo_product ) );
			ATKPLog::LogDebug( '*** export_product woo found ***' );
		}

		$mode     = get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' );
		$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );


		$result = null;
		if ( $mode != null ) {
			if ( $woo_product == null ) {
				//create
				if ( $mode == 'at-woo' ) {
					//status auf fehler? dann nicht erstellen

					$message = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_message' );

					//anlage nur dann wenn kein fehler im at-produkt vorhanden ist.
					if ( $product->title != '' && $message == '' ) {
						$arr = $this->prepareProductArray( $product, $eans[0], true );

						$result = $this->create_woo_product( $arr );

						if ( isset( $result->ID ) ) {
							if ( $eanfield != '' && $eanfield != 'sku' ) {
								ATKPTools::set_post_setting( $result->ID, $eanfield, $eans[0] );
							}

							ATKPTools::set_post_setting( $result->ID, ATKP_PLUGIN_PREFIX . '_sourceproductid', $productid );
							ATKPTools::set_post_setting( $productid, ATKP_PLUGIN_PREFIX . '_targetproductid', $result->ID );

							$this->updateafter( $result->ID, $product, $arr, $dontimportimage );
						}
					}
				}
			} else {
				//update
				$arr = $this->prepareProductArray( $product, $eans[0], false );

				$result = $this->update_woo_product(
					$woo_product->ID,
					$arr );

				ATKPTools::set_post_setting( $woo_product->ID, ATKP_PLUGIN_PREFIX . '_sourceproductid', $productid );
				ATKPTools::set_post_setting( $productid, ATKP_PLUGIN_PREFIX . '_targetproductid', $woo_product->ID );

				$this->updateafter( $woo_product->ID, $product, $arr, $dontimportimage );

			}
		}

//flag für exported zurücksetzen
		ATKPTools::set_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_isexported', true );

		do_action( 'atkp_product_exported', $productid );

		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** export_product woo export ***' );
			ATKPLog::LogDebug( 'created: ' . ( $woo_product == null ) );
			ATKPLog::LogDebug( 'mode: ' . serialize( $mode ) );
			ATKPLog::LogDebug( 'arr: ' . serialize( $arr ) );

			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** export_product woo export ***' );
		}

	}


	private function create_woo_product( $item ) {
		$title = ! isset( $item['title'] ) || $item['title'] == '' ? 'title empty' : $item['title'];

		if ( $title != '' && strlen( $title ) > 250 ) {
			$title = substr( $title, 0, 250 );
		}

		$post_id = wp_insert_post( array(
			'post_title'   => $title,
			'post_content' => ! isset( $item['description'] ) || $item['description'] == '' ? '&nbsp;' : $item['description'],
			'post_status'  => 'publish',
			'post_type'    => 'product',
		), true );

		wp_set_object_terms( $post_id, 'external', 'product_type' );
		update_post_meta( $post_id, '_visibility', 'visible' );
		update_post_meta( $post_id, '_stock_status', 'instock' );
		update_post_meta( $post_id, 'total_sales', '0' );
		update_post_meta( $post_id, '_downloadable', 'no' );
		update_post_meta( $post_id, '_virtual', 'yes' );
		//if(isset($item['short_description']))
		//	update_post_meta( $post_id, '_short_description', $item['short_description'] );
		update_post_meta( $post_id, '_regular_price', $item['regular_price'] );
		update_post_meta( $post_id, '_sale_price', $item['sale_price'] );
		update_post_meta( $post_id, '_purchase_note', '' );
		update_post_meta( $post_id, '_featured', 'no' );
		update_post_meta( $post_id, '_weight', '' );
		update_post_meta( $post_id, '_length', '' );
		update_post_meta( $post_id, '_width', '' );
		update_post_meta( $post_id, '_height', '' );
		if ( isset( $item['sku'] ) ) {
			update_post_meta( $post_id, '_sku', $item['sku'] );
		}
		if ( isset( $item['product_url'] ) ) {
			update_post_meta( $post_id, '_product_url', $item['product_url'] );
		}


		update_post_meta( $post_id, '_product_attributes', array() );
		update_post_meta( $post_id, '_sale_price_dates_from', '' );
		update_post_meta( $post_id, '_sale_price_dates_to', '' );
		update_post_meta( $post_id, '_price', isset( $item['sale_price'] ) && $item['sale_price'] != '' ? $item['sale_price'] : $item['regular_price'] );
		update_post_meta( $post_id, '_sold_individually', '' );
		update_post_meta( $post_id, '_manage_stock', 'no' );
		update_post_meta( $post_id, '_backorders', 'no' );
		update_post_meta( $post_id, '_stock', '' );

		return get_post( $post_id );
	}

	private function update_woo_product( $post_id, $item ) {


		//if(isset($item['short_description']))
		//	update_post_meta( $post_id, '_short_description', $item['short_description'] );
		update_post_meta( $post_id, '_regular_price', $item['regular_price'] );
		update_post_meta( $post_id, '_sale_price', $item['sale_price'] );

		if ( isset( $item['sku'] ) ) {
			update_post_meta( $post_id, '_sku', $item['sku'] );
		}
		//if ( isset( $item['product_url'] ) ) {
		///		update_post_meta( $post_id, '_product_url', $item['product_url'] );
		//}
		update_post_meta( $post_id, '_price', isset( $item['sale_price'] ) && $item['sale_price'] != '' ? $item['sale_price'] : $item['regular_price'] );

		//$update = array(
		//    'ID' => $post_id,
		//);
		//wp_update_post( $update );

		return ( $post_id );
	}


	private function updateafter( $productid, $product, $arr, $dontimportimage ) {
		//manuelles update der produkturl weil diese falsch encoded wird
		if ( isset( $arr['product_url'] ) && $arr['product_url'] != '' ) {
			ATKPTools::set_post_setting( $productid, '_product_url', $arr['product_url'] );
		}

		$buttontext = get_option( ATKP_PLUGIN_PREFIX . '_woo_buttontext', '' );
		if ( $buttontext != '' ) {
			$shopid = $product->shopid;
			if ( isset( $arr['shop_id'] ) && $arr['shop_id'] != '' ) {
				$shopid = $arr['shop_id'];
			}

			if ( $shopid != '' && atkp_shop::exists( $shopid ) ) {
				$shop       = atkp_shop::load( $shopid );
				$buttontext = sprintf( $buttontext, $shop->get_title() );
			}
			if ( atkp_options::$loader->get_mark_links() == 1 ) {
				$buttontext .= atkp_options::$loader->get_affiliatechar();
			}

			ATKPTools::set_post_setting( $productid, '_button_text', $buttontext );
		}

		$wc_product = wc_get_product( $productid );


		//verify to update html
		if ( isset( $arr['description'] ) && $arr['description'] != '' ) {
			$desc = str_replace( "\'", "'", $arr['description'] );
			$wc_product->set_description( $desc );
		}

		if ( isset( $arr['short_description'] ) && $arr['short_description'] != '' ) {
			$desc = str_replace( "\'", "'", $arr['short_description'] );
			$wc_product->set_short_description( $desc );
		}

		if ( get_option( ATKP_PLUGIN_PREFIX . '_woo_offline_pricenull', 0 ) && (isset( $arr['sale_price'] ) || isset( $arr['regular_price'] )) ) {

			$status = get_post_status( $productid );

			if ( ( $arr['sale_price'] == '' && $arr['regular_price'] == '' ) && $status == 'publish' ) {
				//produkt offline schalten wenn verkaufspreis leer ist
				$wc_product->set_status( 'draft' );

			} else if ( ( $arr['sale_price'] != '' || $arr['regular_price'] != '' ) && $status == 'draft' ) {
				//product wieder online schalten wenn verkaufspreis nicht leer
				$wc_product->set_status( 'publish' );
			}
		}


		$copycategory = get_option( ATKP_PLUGIN_PREFIX . '_woo_export_productcategory', 0 );
		$copyoldfunction = get_option( ATKP_PLUGIN_PREFIX . '_woo_productgroups_oldcopyfunction', 0 );

		if ( get_option( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', false ) && $copycategory ) {

			$category = get_option( ATKP_PLUGIN_PREFIX . '_product_category_taxonomy', strtolower( __( 'Productcategory', ATKP_PLUGIN_PREFIX ) ) );

			if($copyoldfunction) {
				$categories = wp_get_post_terms( $product->productid, $category, array(
					"fields"  => "names",
					'orderby' => 'parent',
					'order'   => 'ASC'
				) );

				ATKPTools::check_taxonomy( $productid, 'product_cat', $categories, false );
			}
			else
				ATKPTools::copy_taxonomy($product->productid, $category, $productid, 'product_cat');
		}

		$wc_product->save();

		ATKPTools::set_post_setting( $productid, ATKP_PLUGIN_PREFIX . '_updatedon', ATKPTools::get_current_utc() );

		if ( $dontimportimage ) {
			return;
		}

		$importimagemode   = get_option( ATKP_PLUGIN_PREFIX . '_woo_importimage', 1 );
		$importgallerymode = get_option( ATKP_PLUGIN_PREFIX . '_woo_imagegallery', 0 );

		switch ( $importimagemode ) {
			case 0:
				//mache nichts
				break;
			case 1:
				//importiert das bild in die bibliothek
				$imageurl = atkp_product::get_mainimage( $product, 'largetosmall' );

				if ( $imageurl != '' && $product->title != '' ) {
					ATKPTools::set_featured_image( $imageurl, $product->title, $productid );
				}
				break;
			case 2:
				//verlinkt das bild mit dem externen bild
				$featuredimage = new atkp_external_featuredimage();
				$featuredimage->set_external_postimage( $productid );
				break;
			default:
				throw new exception( 'unknown imagemode: ' . $importimagemode );
		}

		switch ( $importgallerymode ) {
			case 0:
			case 1:
				//entweder nichts oder external image
				break;
			case 2:
				//importiert die gallerie
				$oldlist_id = get_post_meta( $productid, '_product_image_gallery', true );

				$oldids = array();
				$newids = array();
				if ( isset( $oldlist_id ) && $oldlist_id != '' ) {
					$oldids = array_unique( explode( ',', $oldlist_id ) );
					/*
					foreach($oldids as $oldid)
							ATKPTools::delete_image_attachment($oldid);
							*/
				}

				$list_id = '';
				$idx     = 2;
				if ( is_array( $product->images ) ) {
					foreach ( $product->images as $image ) {
						$image_url = $image->largeimageurl;
						if ( $image_url == '' ) {
							$image_url = $image->mediumimageurl;
						}
						if ( $image_url == '' ) {
							$image_url = $image->smallimageurl;
						}

						$oldattachid = '';
						if ( isset( $oldids[ $idx - 2 ] ) ) {
							$oldattachid = $oldids[ $idx - 2 ];
						}
						$attachmentid = ATKPTools::upload_image( $image_url, $product->title, $productid, $idx );

						array_push( $newids, $attachmentid );
						$idx ++;

						if ( $list_id == '' ) {
							$list_id .= $attachmentid;
						} else {
							$list_id .= ',' . $attachmentid;
						}
					}
				}

				//lösche die alten anhänge
				foreach ( $oldids as $oldid ) {
					if ( ! in_array( $oldid, $newids ) ) {
						ATKPTools::delete_image_attachment( $oldid );
					}

				}
				//delete $oldids[0]

				//echo $list_id; exit;

				//echo serialize($oldids);
				//echo serialize($list_id);
				//exit;

				//sollte die bilder mit der galerie verknüpfen:
				//$list_id = "444,555";
				update_post_meta( $productid, '_product_image_gallery', $list_id );
				break;
			default:
				throw new exception( 'unknown $importgallerymode: ' . $importgallerymode );

		}


	}

	private function sortPrice( $a, $b ) {
		if ( $a->pricefloat == $b->pricefloat ) {
			return 0;
		}

		return ( $a->pricefloat < $b->pricefloat ) ? - 1 : 1;
	}

	private function prepareProductArray( $product, $ean, $creating ) {
		$mode = get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' );
		//$importimagemode = get_option(ATKP_PLUGIN_PREFIX.'_woo_importimage',1);
		$array = array();

		if ( $mode == 'at-woo' ) {

			$array = array(
				'type' => 'external'
			);

			if ( $creating ) {
				$array['title'] = $product->title;
			}

			//_woo_product_template

			switch ( get_option( ATKP_PLUGIN_PREFIX . '_woo_exportdescription', 0 ) ) {
				case 1:
					$array['description'] = $product->description;
					break;
				case 2:
					$array['description'] = get_option( ATKP_PLUGIN_PREFIX . '_woo_product_template', '' );
					break;
				default:
					break;
			}

			switch ( get_option( ATKP_PLUGIN_PREFIX . '_woo_exportshortdescription', 0 ) ) {
				case 1:
					$array['short_description'] = $product->features;
					break;
				case 2:
					$array['short_description'] = get_option( ATKP_PLUGIN_PREFIX . '_woo_product_shorttemplate', '' );
					break;
				default:
					break;
			}

			$imagesarray = array();

			//mainimage
			if ( $product->largeimageurl != '' ) {
				array_push( $imagesarray, array(
						'src'      => $product->largeimageurl,
						'position' => 0,
						'title'    => $product->title
					)
				);
			}

			//if($creating && $importimagemode == 1)
			//    $array['images'] = $imagesarray;

		}

		$eanfield = get_option( ATKP_PLUGIN_PREFIX . '_woo_ean_field', '' );

		if ( $eanfield == '' || $eanfield == 'sku' ) {
			$array['sku'] = $ean;
		}

		$myproduct = $product;

		if ( ! is_array( $myproduct->offers ) ) {
			$offers = array();
		} else {
			$offers = $myproduct->offers;
		}

		if ( $myproduct->shopid != '' ) {
			$offer             = new atkp_product_offer();
			$offer->link       = $myproduct->producturl;
			$offer->price      = $myproduct->saleprice;
			$offer->pricefloat = $myproduct->salepricefloat;
			$offer->shopid     = $myproduct->shopid;

			array_push( $offers, $offer );
		}

		usort( $offers, array( &$this, "sortPrice" ) );

		$offercount = 0;
		$minprice   = null;
		$maxprice   = null;
		foreach ( $offers as $offer ) {
			if ( $offer->pricefloat == (float) 0 || $offer->hideoffer ) {
				continue;
			}

			if ( $offercount == 0 ) {
				$minprice = $offer;
			}

			$maxprice = $offer;

			$offercount ++;
		}

		//wenn keine angebote gefunden wurden, fallback auf hauptprodukt
		if ( $minprice == null ) {
			$minprice = $offer;
		}
		if ( $maxprice == null ) {
			$maxprice = $offer;
		}

		$array['shop_id'] = '';

		switch ( get_option( ATKP_PLUGIN_PREFIX . '_woo_targeturl', '' ) ) {
			case 'min_price':
				$array['product_url'] = $minprice->link;
				$array['shop_id']     = $minprice->shopid;
				break;
			case 'max_price':
				$array['product_url'] = $maxprice->link;
				$array['shop_id']     = $maxprice->shopid;
				break;
			default:
				$array['product_url'] = $product->producturl;
				$array['shop_id']     = $product->shopid;
				break;
		}
		$regularprice = 0;
		switch ( get_option( ATKP_PLUGIN_PREFIX . '_woo_price_field', '' ) ) {
			case 'min_price':
				$array['regular_price'] = $regularprice = $minprice->pricefloat;
				break;
			case 'max_price':
				$array['regular_price'] = $regularprice = $maxprice->pricefloat;
				break;
			default:
				if ( $product->listprice != '' && $product->listpricefloat != 0 && $myproduct->listpricefloat > $myproduct->salepricefloat ) {
					$array['regular_price'] = $regularprice = $product->listpricefloat;
				} else {
					$array['regular_price'] = $regularprice = $product->salepricefloat;
				}
				break;
		}

		switch ( get_option( ATKP_PLUGIN_PREFIX . '_woo_saleprice_field', '' ) ) {
			case 'min_price':
				if($regularprice == 0 || $minprice->pricefloat < $regularprice)
					$array['sale_price'] = $minprice->pricefloat;
				else
					$array['sale_price'] = 0;
				break;
			case 'max_price':
				if($regularprice == 0 || $maxprice->pricefloat < $regularprice)
					$array['sale_price'] = $maxprice->pricefloat;
				else
					$array['sale_price'] = 0;
				break;
			default:
				if($regularprice == 0 || $myproduct->salepricefloat < $regularprice)
					$array['sale_price'] = $product->salepricefloat;
				else
					$array['sale_price'] = 0;
				break;
		}


		if ( isset( $array['sale_price'] ) && $array['sale_price'] == 0 ) {
			$array['sale_price'] = '';
		}
		if ( isset( $array['regular_price'] ) && $array['regular_price'] == 0 ) {
			$array['regular_price'] = '';
		}


		$array = apply_filters( 'atkp_woocommerce_productdata', $array, $myproduct, $minprice, $maxprice );

		return $array;
	}

}