<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 01.04.2018
 * Time: 09:22
 */

/**
 * Diese Klasse aktualisiert die Single-Produkte aus den Providern
 */
class atkp_productservice {

	/**
	 * Exportiert die übergebenen Produkt-IDs
	 *
	 * @param array $post_ids Die Post-Ids des AT-Produktes welches aktualisiert werden soll
	 */
	public function export_products( $post_ids ) {

		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( 'WooCommerce installed: ' . class_exists( 'WooCommerce' ) );
		}

		if ( ! class_exists( 'WooCommerce' ) ) {
			return;
		}

		foreach ( $post_ids as $post_id ) {
			try {
				$message = '';
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_woomessage', $message );

				try {
					$export  = atkp_export_provider_base::get_provider( 'woo' );
					$message = $export->checklogon();
				} catch ( Exception $e ) {
					$message = 'Export Exception: ' . $e->getMessage();
				}

				$mode = get_option( ATKP_PLUGIN_PREFIX . '_woo_mode', '' );

				if ( $mode != '' ) {

					try {
						if ( $message != '' ) {
							ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_woomessage', $message );
						} else {
							$export->export_product( $post_id );
						}
					} catch ( Exception $e ) {
						ATKPLog::LogError( $e->getMessage() );

						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_woomessage', $e->getMessage() );
					}
				}
			} catch ( Exception $e ) {
				//var_dump( $e );
				//array_push( $errors, 'Product ' . $post_id . ': ' . $e->getMessage() );
				ATKPLog::LogError( $e->getMessage() );

			}

		}
	}

	public function mark_asinvalid( $post_ids ) {
		foreach ( $post_ids as $post_id ) {
			$shopid = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shopid' );

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', 'product uses an unknown shop: ' . $shopid );
		}
	}

	/**
	 * Aktualisiert die übergebenen Produkt-Ids
	 *
	 * @param mixed $shop Das Shopobjekt welches das Produkt angehört
	 * @param array $product_ids Die Post-Ids des AT-Produktes welches aktualisiert werden soll
	 * @param string $id_type Der Id-Typ für die $product_ids welcher mit dem jeweiligen AT-Produkt übereinstimmen muss
	 */
	public function update_products( $shop, $post_ids, $id_type, $iscron = true, $refreshproductinfo = false, $refreshpriceinfo = false, $refreshvariations = false, $refreshreviewinfo = false, $refreshimages = false, $refreshproducturl = false, $refreshmoreoffers = false, $dontUpdatetitle = false ) {
		if ( $iscron ) {
			$refreshvariations = true;
		};
		$product_ids  = array();
		$mapping_keys = array();

		foreach ( $post_ids as $post_id ) {
			$asin     = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asin' );
			$asintype = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asintype' );

			if ( $asintype == null || $asintype == '' ) {
				$asintype = 'ASIN';
			}

			if ( $asintype != $id_type ) {
				throw new Exception( 'asintype is not equal: ' . $asintype . ' = ' . $id_type );
			}

			array_push( $product_ids, $asin );
			$mapping_keys[ $post_id ] = $asin;
		}


		try {
			$message = '';

			if ( $shop != null ) {
				if ( ! ( $refreshproductinfo || $refreshpriceinfo || $refreshreviewinfo || $refreshimages || $refreshproducturl || $refreshvariations ) ) {
					return;
				}

				try {
					$message = $shop->provider->checklogon( $shop );
				} catch ( Exception $e ) {
					$message = 'Shop Exception: ' . $e->getMessage();
				}

				$atresponse = null;

				if ( $message == '' ) {
					try {
						$atresponse = $shop->provider->retrieve_products( $product_ids, $id_type );
					} catch ( Exception $e ) {
						$message = 'Request Exception: ' . $e->getMessage();

						//if($this->str_contains( $message, 'RequestThro', false ) || $this->str_contains( $message, 'product not found', false )) {
						sleep( 5 );

						try {
							$atresponse = $shop->provider->retrieve_products( $product_ids, $id_type );
						} catch ( Exception $e ) {
							$message = 'Request Exception (2nd): ' . $e->getMessage();
						}
						//}
					}
				}
			}

			foreach ( $mapping_keys as $post_id => $asin ) {

				$errormessage = '';
				if ( $shop != null ) {
					$responseitem = null;
					if ( $message == '' && $atresponse->errormessage == '' ) {
						foreach ( $atresponse->responseitems as $item ) {

							if ( (string) $asin == (string) $item->uniqueid ) {
								$responseitem = $item;
							}
						}
					}

					if ( $message != '' ) {
						$errormessage = 'Shop error: ' . $message;
					} else if ( $atresponse->errormessage != '' ) {
						$errormessage = 'Request error: ' . $atresponse->errormessage;
					} else if ( $responseitem == null ) {
						$errormessage = 'Product not returned: ' . $asin;
					} else if ( $responseitem->errormessage != '' ) {
						$errormessage = 'Item error: ' . $responseitem->errormessage;
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );

				if ( $errormessage != '' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', $errormessage );

					$this->reset_product_postdata( $post_id, $refreshpriceinfo );
				} else {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', '' );

					$updatemessage = '';

					try {
						if ( $iscron ) {
							$refreshreviewinfo = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' );
							$refreshpriceinfo  = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' );
							$refreshproducturl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' );
							$refreshimages     = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' );
							$refreshmoreoffers = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' );
						}

						if ( ATKPLog::$logenabled ) {
							ATKPLog::LogDebug( '$refreshproductinfo: ' . $refreshproductinfo );
							ATKPLog::LogDebug( '$refreshpriceinfo: ' . $refreshpriceinfo );
							ATKPLog::LogDebug( '$refreshreviewinfo: ' . $refreshreviewinfo );
							ATKPLog::LogDebug( '$refreshimages: ' . $refreshimages );
							ATKPLog::LogDebug( '$refreshproducturl: ' . $refreshproducturl );
							ATKPLog::LogDebug( '$refreshmoreoffers: ' . $refreshmoreoffers );
						}

						if ( $shop != null ) {

							/*echo '<pre>';
							print_r( $responseitem );
							echo '</pre>';
							exit;*/

							if ( $refreshproductinfo || $refreshpriceinfo || $refreshreviewinfo || $refreshimages || $refreshproducturl || $refreshvariations ) {
								$this->update_product_postdata( $post_id, $responseitem->productitem, $asin, $id_type, $refreshproductinfo, $refreshpriceinfo, $refreshvariations, $refreshreviewinfo, $refreshimages, $refreshproducturl, $dontUpdatetitle );
							}
						}

						if ( $refreshmoreoffers ) {
							$product      = atkp_product::load( $post_id );
							$offerservice = new atkp_offerservice();

							//im ersten schritt die angebote löschen, die werden später extra geladen
							$offerservice->clear_offers( $product, '' );
						}

						$this->update_product_taxonomies( $post_id );

						$this->update_product_mainimage( $post_id );


						//Wurde das Produkt bereits exportiert nach der aktualisierung? Flag hier zurücksetzen
						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isexported', false );

						//TODO:
						//product update je nach refresh flag
						//angebote aktualisieren
						//bild importieren
						//wooCommerce exportieren


					} catch ( Exception $e ) {
						$updatemessage = 'Update-Error: ' . $e->getMessage();
					}

					if ( $updatemessage != '' ) {
						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', $updatemessage );

						$this->reset_product_postdata( $post_id, $refreshpriceinfo );
					}
				}
			}

		} catch
		( Exception $e ) {
			//var_dump( $e );
			//array_push( $errors, 'Product ' . $post_id . ': ' . $e->getMessage() );
			ATKPLog::LogError( $e->getMessage() );

			$this->reset_product_postdata( $post_id, $refreshpriceinfo );
		}

		foreach ( $post_ids as $post_id ) {
			do_action( 'atkp_product_updated', $post_id );
		}
	}


	private function str_contains( $string, $array, $caseSensitive = true ) {
		$strfound          = false;
		$containsPosFilter = false;

		foreach ( $array as $txt ) {
			$startswith = substr( $txt, 0, 1 );

			if ( $startswith == '-' ) {
				$txt = substr( $txt, 1 );
			} else {
				$containsPosFilter = true;
			}


			if ( stripos( $string, $txt ) !== false ) {
				$strfound = true;
			}

			if ( $strfound && $startswith == '-' ) {
				return false;
			}
		}

		return $containsPosFilter ? $strfound : true;

		//$stripedString = $caseSensitive ? str_replace($array, '', $string) : str_ireplace($array, '', $string);
		//return strlen($stripedString) !== strlen($string);
	}

	public function update_product_categories( $post_id ) {
		if ( ! atkp_options::$loader->get_productgroups_enabled() ) {
			return;
		}


		$category = get_option( ATKP_PLUGIN_PREFIX . '_product_category_taxonomy', strtolower( __( 'Productcategory', ATKP_PLUGIN_PREFIX ) ) );


		$productgroup = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_productgroup' );

		if ( atkp_options::$loader->get_productgroupascategory() ) {

			if ( atkp_options::$loader->get_productgroupdeleteoldentries() ) {
				//delete existing entries
			}

			if ( atkp_options::$loader->get_productgroupsplitchar() != '' ) {
				//split to sub categories
				$productgroup = explode( atkp_options::$loader->get_productgroupsplitchar(), $productgroup );

			}

			ATKPTools::check_taxonomy( $post_id, $category, $productgroup, false );


		}
	}

	/**
	 * Aktualisiert ein angelegtes Produkt mit dem übergebenen Produkt. Je Nach Refresh-Parameter wird der jeweilige Teil aktualisiert.
	 *
	 * @param int $post_id Die Post-ID des AT-Produktes
	 * @param atkp_product $product Das atkp_product (aus dem Shopprovider)
	 * @param string $asin Die ASIN, ean,title, articlenumber mit welcher das atkp_product geladen wurde
	 * @param string $asintype Der ASIN-Typ welche $asin ist
	 * @param bool $refreshproductinfo
	 * @param bool $refreshpriceinfo
	 * @param bool $refreshreviewinfo
	 * @param bool $refreshimages
	 * @param bool $refreshproducturl
	 * @param bool $refreshmoreoffers
	 * @param bool $dontUpdatetitle Wenn Ein Titel beim erstmaligen Import angegeben wurde, soll dieser nicht überschrieben werden
	 */
	public function update_product_postdata( $post_id, $product, $asin, $asintype, $refreshproductinfo, $refreshpriceinfo, $refreshvariations, $refreshreviewinfo, $refreshimages, $refreshproducturl, $dontUpdatetitle = false ) {
		try {
			$product = apply_filters( 'atkp_retrieve_product', $product, $asin, $asintype );

			if ( ! isset( $product ) || $product == null ) {
				throw new Exception( 'product is null: ' . $post_id );
			}

			//atkp_product_updateproduct

			$updateproduct = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_updateproduct' );

			if ( $updateproduct != '' ) {
				//set update flags
				$refreshproductinfo = true;
				$refreshpriceinfo   = true;
				$refreshvariations  = true;
				$refreshreviewinfo  = true;
				$refreshimages      = true;
				$refreshproducturl  = true;

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_updateproduct', '' );
			}

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asin_caption', $product->title );

			if ( $refreshproductinfo == true ) {
				$post_loaded = get_post( $post_id );


				if ( $post_loaded->post_title == '' ) {
					global $wpdb;
					$wpdb->update( $wpdb->posts, array(
						'post_title' => $product->title,
						'post_name'  => sanitize_title( $product->title )
					), array( 'ID' => $post_id ) );
				}
				if ( ! $dontUpdatetitle ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title', $product->title );
				}
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_description', $product->description );

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_ean', $product->ean );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isbn', $product->isbn );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mpn', $product->mpn );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_brand', $product->brand );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_productgroup', $product->productgroup );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_releasedate', $product->releasedate );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_manufacturer', $product->manufacturer );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_author', $product->author );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_numberofpages', $product->numberofpages );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_features', $product->features );

				$this->update_product_categories( $post_id );
			}

			if ( isset( $product->customfields ) && $product->customfields != null && sizeof( $product->customfields ) > 0 ) {

				$allfields = array();

				$newfields = atkp_udfield::load_fields();

				foreach ( $newfields as $field ) {
					$field->isold = true;
					array_push( $allfields, $field );
				}


				$groups = ATKPTools::get_fieldgroups_by_productid( $post_id );

				foreach ( $groups as $group ) {

					$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

					foreach ( $fields as $newfield ) {

						array_push( $allfields, $newfield );
					}
				}

				foreach ( $product->customfields as $name => $value ) {
					try {
						$udf = null;


						foreach ( $allfields as $field ) {
							if ( $field->name == $name ) {
								$udf = $field;
								break;
							}
						}

						if ( $udf == null ) {
							continue;
						}

						$fieldvalue = sanitize_text_field( $value );

						if ( $udf->type == 6 ) {

							//update taxonomy
							ATKPTools::check_taxonomy( $post_id, $udf->name, $fieldvalue, false );

						} else {
							if ( $field->isold ) {
								$fieldname = 'customfield_' . $udf->name;
							} else {
								$fieldname = 'cf_' . $udf->name;
							}

							if ( $udf->format == 'number' ) {
								//extract number from string

								$fieldvalue = preg_replace( "/[^0-9]/", "", $fieldvalue );

								$fieldvalue = intval( $fieldvalue );
							}

							//$oldval =ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE.'_'.$fieldname);
							//if($oldval == '')
							ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );


						}

					} catch ( Exception $e ) {

					}
				}

			}

			if ( $refreshimages == true ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', $product->smallimageurl );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', $product->mediumimageurl );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', $product->largeimageurl );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_images', $product->images );
			}


			if ( $refreshproducturl == true ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_producturl', $this->shorten_url( $post_id, $product->shopid, $product->producturl ) );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_addtocarturl', $this->shorten_url( $post_id, $product->shopid, $product->addtocarturl ) );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl', $this->shorten_url( $post_id, $product->shopid, $product->customerreviewurl ) );
			}

			if ( $refreshreviewinfo == true ) {
				//ratings werden nur überschrieben wenn welche vorhanden sind
				if ( $product->rating != '' && $product->rating != '0' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_rating', $product->rating );
				}
				if ( $product->reviewcount != '' && $product->reviewcount != '0' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_reviewcount', $product->reviewcount );
				}
			}

			if ( $refreshvariations == true ) {
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_parentasin', $product->parentasin );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_variationname', $product->variationname );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_variations', $product->variations );
			}


			if ( $refreshpriceinfo == true ) {

				if ( $product->salepricefloat > 0 && $product->listpricefloat > 0 ) {
					if ( $product->amountsavedfloat <= 0 ) {
						//calculate $product->amountsavedfloat

						$product->amountsavedfloat = $product->listpricefloat - $product->salepricefloat;

						if ( $product->amountsavedfloat <= 0 ) {
							$product->amountsavedfloat = 0;
						}

						$product->amountsaved = $product->amountsavedfloat;
					}
					if ( $product->percentagesaved <= 0 && $product->amountsavedfloat > 0 ) {
						$product->percentagesaved = round( ( $product->amountsavedfloat / $product->listpricefloat ) * 100, 2 );
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listpricefloat', $product->listpricefloat );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsavedfloat', $product->amountsavedfloat );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_salepricefloat', $product->salepricefloat );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shippingfloat', $product->shippingfloat );

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listprice', $product->listprice );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsaved', $product->amountsaved );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_percentagesaved', $product->percentagesaved );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_saleprice', $product->saleprice );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_availability', $product->availability );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shipping', $product->shipping );
				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isprime', $product->isprime );

				if ( $product->saleprice == '' ) {
					throw new Exception( __( 'sale\'s price is empty', ATKP_PLUGIN_PREFIX ) );
				}

				if ( atkp_options::$loader->get_pricehistory_enabled() ) {
					$history = new atkp_pricehistorytable_helper();
					$history->create_history_entry( $post_id, $product->shopid, $product->saleprice, $product->salepricefloat );
				}
			}

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', null );
		} catch ( Exception $e ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message', 'Error: ' . $e->getMessage() );

			$this->reset_product_postdata( $post_id, $refreshpriceinfo );
		}

	}

	public function reset_product_postdata( $post_id, $refreshpriceinfo ) {
		//den verkaufspreis zurücksetzen wenn ein Fehler aufgetreten ist
		if ( $refreshpriceinfo == true ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listpricefloat', 0 );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsavedfloat', 0 );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_salepricefloat', 0 );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shippingfloat', 0 );

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listprice', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsaved', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_percentagesaved', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_saleprice', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_availability', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shipping', '' );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isprime', false );


			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isexported', false );
		}
	}

	/**
	 * Kürzt eine URL von einem Produkt aufgrund des Shops
	 *
	 * @param int $productid Die AT-Produkt-ID (wird nicht verwendet)
	 * @param int $shopid Die Shop-ID mit welcher die URL gekürzt wird. Ist diese leer, wird die URL einfach zurückgegeben
	 * @param string $url Die URL welche gekürzt werden soll
	 *
	 * @return string
	 */
	public function shorten_url( $productid, $shopid, $url ) {
		//TODO: Wenn ShopId leer ist, dann Shopid vom Produkt laden?
		if ( $shopid == '' ) {
			return $url;
		}

		$redirtype = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_redirectiontype' );

		$apikey   = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_apikey' );
		$apilogin = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_apilogin' );

		switch ( $redirtype ) {
			default:
				//disabled
				break;
			case 3:
			case 4:
			case 5:
			case 6:

				$shortener = new atkp_shortener();

				$url = $shortener->shorten_url( $apikey, $apilogin, $redirtype, $url );

				break;
		}

		return $url;
	}


	/**
	 * Überprüft die Plugineigenen Taxonomien und aktualisiert sie
	 *
	 * @param int $post_id Die AT-Produkt ID welche aktualsiiert werden soll
	 */
	public function update_product_taxonomies( $post_id ) {
		$manufacturer = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_manufacturer' );
		$author       = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_author' );
		$brand        = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_brand' );

		$manufacturerType = get_option( ATKP_PLUGIN_PREFIX . '_product_manufacturer_taxonomy', strtolower( __( 'Manufacturer', ATKP_PLUGIN_PREFIX ) ) );
		$authorType       = get_option( ATKP_PLUGIN_PREFIX . '_product_author_taxonomy', strtolower( __( 'Author', ATKP_PLUGIN_PREFIX ) ) );
		$brandType        = get_option( ATKP_PLUGIN_PREFIX . '_product_brand_taxonomy', strtolower( __( 'Brand', ATKP_PLUGIN_PREFIX ) ) );

		try {
			ATKPTools::check_taxonomy( $post_id, $manufacturerType, $manufacturer, false );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
		try {
			ATKPTools::check_taxonomy( $post_id, $brandType, $brand, false );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
		try {
			ATKPTools::check_taxonomy( $post_id, $authorType, $author, false );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}


	/**
	 * Importiert das jeweilige Hauptbild vom AT-Produkt in die Medienbibliothek oder aktualisiert dieses
	 *
	 * @param int $post_id Die ID des AT-Produktes welches das Hauptbild aktualisiert wird
	 *
	 * @throws Exception Wenn der Import-Imagemode nicht untersützt wird, wird eine Exception erzeugt
	 */
	private function update_product_mainimage( $post_id ) {

		$dontimportimage = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' );

		if ( $dontimportimage ) {
			return;
		}

		$importProductimage = get_option( ATKP_PLUGIN_PREFIX . '_product_importimage', 0 );
		$poststatus         = get_post_status( $post_id );

		if ( $importProductimage != 0 && ( $poststatus == 'publish' || $poststatus == 'draft' ) ) {

			switch ( $importProductimage ) {
				case 1:
					//importiert das bild in die bibliothek
					$product = atkp_product::load( $post_id );

					$imageurl = atkp_product::get_mainimage( $product, 'largetosmall' );
					$title    = $product->title;

					if ( $imageurl != '' && $title != '' ) {
						ATKPTools::set_featured_image( $imageurl, $title, $post_id );
					}
					break;
				case 2:
					//verlinkt das bild mit dem externen bild
					$featuredimage = new atkp_external_featuredimage();
					$featuredimage->set_external_postimage( $post_id );
					break;
				default:
					throw new Exception( 'unknown imagemode: ' . $importProductimage );
			}

		}

	}

}