<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_welcome {

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_action( 'admin_menu', array( &$this, 'admin_menu' ) );
	}

	function admin_menu() {

		add_submenu_page(
			ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
			__( 'Getting Started', ATKP_PLUGIN_PREFIX ),
			__( 'Getting Started', ATKP_PLUGIN_PREFIX ),
			'manage_options',
			ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-welcome',
			array( &$this, 'toolkit_welcome' )
		);

	}


	public function toolkit_welcome() {
		if ( ! is_user_logged_in() ) {
			wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
		}

		ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_welcomepage', true );
		?>


        <div class="atkp-content wrap">
            <h3 class="hndle"><?php _e( 'Getting started', ATKP_PLUGIN_PREFIX ) ?></h3>

            <div class="inner">

                <p>
					<?php _e( 'In order to use this plugin, you have to register as an affiliate at the desired shops. You also need your access data to the respective shop API. If you need help with registration or setup, please refer to the documentation for help.', ATKP_PLUGIN_PREFIX ) ?>
                </p>


                <p>
					<?php _e( 'To make it as easy as possible for you to get started, we have summarized the most important links and steps for you here.', ATKP_PLUGIN_PREFIX ) ?>


                </p>

                <p>
                    <b><?php _e( 'Quick links:', ATKP_PLUGIN_PREFIX ) ?>
                    </b> <a target="_blank"
                            href="https://docs.affiliate-toolkit.com"><?php _e( 'Documentation', ATKP_PLUGIN_PREFIX ) ?></a>
                    | <a target="_blank" href="https://forum.affiliate-toolkit.com">Forum</a> | <a target="_blank"
                                                                                                   href="https://ticket.affiliate-toolkit.com/index.php?lang=">Helpdesk</a>
                    | <a target="_blank" href="https://www.facebook.com/groups/1837786049839465/?ref=bookmarks">Facebook-Community</a>
                    | <a target="_blank" href="https://www.youtube.com/channel/UCWj-kkTKfHyVSbuP48y5ftg">YouTube</a>
                </p>


                <h4>
					<?php _e( '1. Set up shop', ATKP_PLUGIN_PREFIX ) ?>

                </h4>

                <p>
					<?php echo sprintf( __( '
To be able to import products from your affiliate partner, you need to enter your access data. 
You must create a shop for each affiliate network. You can create your first shop %s.', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'add-shop', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ), '<a href="' . admin_url( 'edit.php?post_type=atkp_shop' ) . '">' . __( 'here', ATKP_PLUGIN_PREFIX ) . '</a>' ); ?>
                </p>

                <h4>
					<?php _e( '2. Import product', ATKP_PLUGIN_PREFIX ); ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'After you have created a shop, you can import your first products.  %s <br /> You can import them directly in the post via the short code generator or you can use our %s.', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'product-shop', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ), '<a href="' . admin_url( 'edit.php?post_type=atkp_product&page=atkp_bulkimport' ) . '">' . __( 'product import', ATKP_PLUGIN_PREFIX ) . '</a>' ); ?>
                </p>

                <h4>
					<?php _e( '3. Import lists', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'With a list you can view several products and update them automatically. %s <br /> This allows you to retrieve bestseller lists, new releases and any search lists. You can create your first list %s.', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'list-shop', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ), '<a href="' . admin_url( 'edit.php?post_type=atkp_list' ) . '">' . __( 'here', ATKP_PLUGIN_PREFIX ) . '</a>' ); ?>
                </p>

                <h4>
					<?php _e( '4. Create your own fields', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'In order to save as many comparison values as possible for your products, there are separate fields and field groups. %s <br /> The settings contain the %s and %s that are created for each product category. <br /> You must first activate field groups in the %s.', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'setting-customfield', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ), '<a href="' . admin_url( 'admin.php?page=ATKP_affiliate_toolkit-plugin&tab=4' ) . '">' . __( 'global fields', ATKP_PLUGIN_PREFIX ) . '</a>', '<a href="' . admin_url( 'edit.php?post_type=atkp_fieldgroup' ) . '">' . __( 'field groups', ATKP_PLUGIN_PREFIX ) . '</a>', '<a href="' . admin_url( 'admin.php?page=ATKP_affiliate_toolkit-plugin' ) . '">' . __( 'settings', ATKP_PLUGIN_PREFIX ) . '</a>' ); ?>
                </p>

                <h4>
					<?php _e( '5. Customize templates and create comparison tables', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'If you don\'t want to use our included templates, you can create your own. Here you can create a new %s. <br />As a basis for your new template you can import our standard templates. For comparison tables you can find more information here: %s', ATKP_PLUGIN_PREFIX ), '<a href="' . admin_url( 'edit.php?post_type=atkp_template' ) . '">' . __( 'template', ATKP_PLUGIN_PREFIX ) . '</a>', ATKPHomeLinks::GetHelpIcon( 'import-template', __( 'Help with that', ATKP_PLUGIN_PREFIX ) ) ); ?>

                </p>


                <h4>
					<?php _e( '6. Set up WooCommerce', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'If you want to use WooCommerce as an affiliate shop, all you have to do is activate %s. <br />In our documentation we have summarized the most important points for you: %s', ATKP_PLUGIN_PREFIX ), '<a href="' . admin_url( 'admin.php?page=ATKP_affiliate_toolkit-tools&tab=4' ) . '">' . __( 'our extension', ATKP_PLUGIN_PREFIX ) . '</a>', ATKPHomeLinks::GetHelpIcon( 'setting-woo', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ) ); ?>

                </p>

                <h4>
					<?php _e( 'Extra: Price comparison', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'Our plugin allows an automatic price comparison via EAN. All you have to do is activate the automatic search in the shop. <br />You can read more about this in our documentation: %s', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'setting-moreoffers', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ) ); ?>
                </p>

                <h4>
					<?php _e( 'Extra: replace ASA1 or ASA2', ATKP_PLUGIN_PREFIX ) ?>
                </h4>

                <p>
					<?php echo sprintf( __( 'So far you have used Amazon Simple Amazon 1 or Amazon Simple Affiliate 2 and now want to upgrade? <br />With our plugin you can replace the plugin with just one click and you don\'t have to exchange short codes! %s', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpIcon( 'compatiblity-asa1', __( 'To help with this', ATKP_PLUGIN_PREFIX ) ) ); ?>

                </p>


                <div style="text-align:center;margin:10px">

					<?php
					$url = home_url();

					if ( file_exists( get_home_path() . '/../demo-data.sql' ) ) {

						$nounce = wp_create_nonce( 'atkp-download-log' );
						echo '<a class="atkp-upgrade-button" onclick="return confirm(\'' . __( 'Are you sure (the demo data will be imported!)?', ATKP_PLUGIN_PREFIX ) . '\')" href="' . ATKPTools::get_endpointurl() . '?action=atkp_import_demo&request_nonce=' . $nounce . '">' . __( 'Import demo products and lists', ATKP_PLUGIN_PREFIX ) . '</a>';

					}


					?>
                </div>


            </div>

        </div>

        <div class="atkp-credits">
            <h3 class="hndle"><?php echo __( 'Affiliate Toolkit', ATKP_PLUGIN_PREFIX ) . ' ' . ATKPSettings::plugin_get_version() ?></h3>
            <div class="inside">
                <a href="http://www.affiliate-toolkit.com" target="_blank"
                   title="affiliate-toolkit.com - Affiliate Marketing Plugin"><img
                            style="margin-left:40px; margin-right:40px"
                            src="<?php echo plugins_url( 'images/logo-admin.png', __FILE__ ); ?>"
                            title="affiliate-toolkit.com - Affiliate Marketing Plugin"
                            alt="affiliate-toolkit.com - Affiliate Marketing Plugin"></a>

                <h4 class="inner"><?php _e( 'Do you need any help?', ATKP_PLUGIN_PREFIX ) ?></h4>
                <p class="inner"><?php echo ATKPHomeLinks::ReplaceLinkType( __( 'If you have any problems with our plugin, first take a look at our <a href="%link_help%" target="_blank">Help Center</a>. If you need further assistance, please <a href="%link_support%" target="_blank">contact us</a>.', ATKP_PLUGIN_PREFIX ) ) ?></p>
                <hr>
                <h4 class="inner"><?php _e( 'Do you like the plugin?', ATKP_PLUGIN_PREFIX ) ?></h4>

                <p class="inner">
					<?php echo ATKPHomeLinks::ReplaceLinkType( __( 'Add your review and keep recommending us. As an affiliate you can even make money when ordering! More information is available <a href="%link_affiliate%" target="_blank">here</a>!', ATKP_PLUGIN_PREFIX ) ) ?>
                </p>
                <p class="inner">
					<?php echo ATKPHomeLinks::ReplaceLinkType( __( 'We appreciate any form of feedback to improve the plugin. Send us your praise or your criticism. Simply use the <a href="%link_contact%" target="_blank">contact form</a>.', ATKP_PLUGIN_PREFIX ) ) ?>
                </p>
                <hr>
                <p class="atkp-link inner">Created by <a href="http://www.servit.biz" target="_blank"
                                                         title="servit.biz - Quality plugins for WordPress"><img
                                src="<?php echo plugins_url( 'images/logo_servit-biz.png', __FILE__ ); ?>"
                                title="servit.biz - Quality plugins for WordPress"
                                alt="servit.biz - Quality plugins for WordPress"></a></p>
            </div>
        </div>

		<?php

	}
}


?>