<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 02.04.2018
 * Time: 16:20
 */

class atkp_offerservice {


	public function do_single_offer_update( $productid ) {
		try {
			$offerservice     = $this;
			$offertablehelper = new atkp_offertable_helper();

			$idtypes = array( 'ASIN', 'EAN' );

			$shops = atkp_shop::get_list( null, true );

			foreach ( $idtypes as $idtype ) {
				foreach ( $shops as $shop ) {
					//hier darf nicht auf enablepricecomparison abgefragt werden weil sonst manuelle produkte nicht aktualisiert werden

					$posts_exists = true;
					$page         = 1;

					while ( $posts_exists && $page <= 3 ) {
						$offers = $offertablehelper->get_offers_for_update( $shop->id, $idtype, $page, $productid );

						if ( count( $offers ) > 0 ) {
							$offerservice->update_offers( $shop, $offers, $idtype );
						}

						$posts_exists = count( $offers ) >= 10;
						//$page ++;
					}
				}
			}

			/* Restore original Post Data */
			wp_reset_postdata();

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}


	}


	/**
	 * Aktualisiert die übergebenen Angebote
	 *
	 * @param atkp_shop $shop
	 * @param Array $offers
	 * @param string $id_type
	 */
	public function update_offers( $shop, $offers, $id_type ) {
		$productservice = new atkp_productservice();

		$product_ids = array();

		foreach ( $offers as $offer ) {
			//TODO: if($offer->message == 'Item error: product not found')
			//	continue;

			array_push( $product_ids, $offer->number );
		}

		$helper = new atkp_offertable_helper();


		$message = '';

		if ( $shop != null ) {
			try {
				$message = $shop->provider->checklogon( $shop );
			} catch ( Exception $e ) {
				$message = 'Shop Exception: ' . $e->getMessage();
			}

			$atresponse = null;

			if ( $message == '' ) {
				try {
					$atresponse = $shop->provider->retrieve_products( $product_ids, $id_type );
				} catch ( Exception $e ) {
					$message = 'Request Exception: ' . $e->getMessage();
				}
			}
		}

		foreach ( $offers as $offer ) {

			$responseitem = null;
			$errormessage = '';
			if ( $shop != null ) {
				if ( $message == '' && $atresponse->errormessage == '' ) {
					foreach ( $atresponse->responseitems as $item ) {

						if ( (string) $offer->number == (string) $item->uniqueid ) {
							$responseitem = $item;
						}
					}
				}

				if ( $message != '' ) {
					$errormessage = 'Shop error: ' . $message;
				} else if ( $atresponse->errormessage != '' ) {
					$errormessage = 'Request error: ' . $atresponse->errormessage;
				} else if ( $responseitem == null ) {
					$errormessage = 'Product not returned: ' . $offer->number;
				} else if ( $responseitem->errormessage != '' ) {
					$errormessage = 'Item error: ' . $responseitem->errormessage;
				}
			}
			if ( $responseitem == null ) {
				$errormessage = 'Item error: $responseitem is null';
			}

			$offer->message = $errormessage;

			if ( $responseitem != null ) {
				$offer->shipping      = $responseitem->productitem == null ? '' : $responseitem->productitem->shipping;
				$offer->shippingfloat = $responseitem->productitem == null ? 0 : $responseitem->productitem->shippingfloat;
				$offer->availability  = $responseitem->productitem == null ? '' : $responseitem->productitem->availability;

				$offer->price      = $responseitem->productitem == null ? '' : $responseitem->productitem->saleprice;
				$offer->pricefloat = $responseitem->productitem == null ? 0 : $responseitem->productitem->salepricefloat;


				$offer->link  = $responseitem->productitem == null ? '' : $productservice->shorten_url( '', $shop->id, $responseitem->productitem->producturl );
				$offer->title = $responseitem->productitem == null ? '' : ATKPTools::clear_string( $responseitem->productitem->title );;
			}

			$helper->update_offer( $offer );

			if ( atkp_options::$loader->get_pricehistory_enabled() ) {
				$history = new atkp_pricehistorytable_helper();
				$history->create_history_entry( $offer->productid, $offer->shopid, $offer->price, $offer->pricefloat );
			}

			//Wurde das Produkt bereits exportiert nach der aktualisierung? Flag hier zurücksetzen
			if ( $offer->productid != '' && $offer->productid != 0 ) {
				ATKPTools::set_post_setting( $offer->productid, ATKP_PRODUCT_POSTTYPE . '_isexported', false );
			}
		}
	}

	/**
	 * Löscht alle Angebote zu einem Produkt (oder Liste) und erstellt leere Einträge für die nächste aktualisierung der Angebote
	 *
	 * @param atkp_product $product Das atkp_product welches zurückgesetzt werden soll
	 * @param string $listid Die Listen-ID in dem das Produkt erscheint (wenn eine Liste)
	 */
	public function clear_offers( $product, $listid = '' ) {

		//wir holen uns alle shops + eans und legen dafür eine offer row an
		//danach gehen wir die daten pro shop durch...

		$existing_offers_per_shop = array();

		$atkp_offertable_helper = new atkp_offertable_helper();

		//lade die bisherigen angebote aus der tabelle
		if ( $listid != '' ) {
			$product_offers = $atkp_offertable_helper->get_offers_by_listid( $listid, $product->asin );
		} else {
			$product_offers = $atkp_offertable_helper->get_offers_by_productid( $product->productid );
		}

		//gruppiere die angebote in shopid array
		if ( $product_offers != null && $product_offers != '' ) {
			foreach ( $product_offers as $offer ) {
				if ( ! array_key_exists( $offer->shopid, $existing_offers_per_shop ) || ! is_array( $existing_offers_per_shop[ $offer->shopid ] ) ) {
					$existing_offers_per_shop[ $offer->shopid ] = array();
				}

				array_push( $existing_offers_per_shop[ $offer->shopid ], $offer );
			}
		}

		$all_offers_per_shop = array();

		//ean aus dem Produkt laden und splitten
		$eans = array();

		if ( $product->ean != '' ) {
			$eansex = explode( ',', $product->ean );

			foreach ( $eansex as $ean ) {
				$ean = trim( $ean );
				if ( $ean != '' ) {
					array_push( $eans, $ean );

				}
			}
		}

		//alle shops laden welche angeobte aktualisieren aktiviert hat

		$shops = atkp_shop::get_list( null, true );

		foreach ( $shops as $subshop ) {
			if ( ! $subshop->enablepricecomparison ) {
				continue;
			}

			//wenn kein manuelles produkt, dann den shop überspringen
			if($product != null && $product->shopid == $subshop->id) {
				continue;
			}

			if ( ! array_key_exists( $subshop->id, $all_offers_per_shop ) || ! is_array( $all_offers_per_shop[ $subshop->id ] ) ) {
				$all_offers_per_shop[ $subshop->id ] = array();
			}

			foreach ( $eans as $ean ) {

				$offer         = new atkp_product_offer();
				$offer->id     = random_int( 1, 99999 );
				$offer->type   = atkp_product_offer::OFFER_TXPE_EAN;
				$offer->shopid = $subshop->id;
				$offer->number = $ean;

				array_push( $all_offers_per_shop[ $subshop->id ], $offer );
			}


		}


		$offers_to_add    = array();
		$offers_to_remove = array();
		$offers_to_reset = array();


		foreach ( $all_offers_per_shop as $all_shop_id => $all_offer_array ) {

			$existing_offer_array = null;
			if ( isset( $existing_offers_per_shop[ $all_shop_id ] ) ) {
				$existing_offer_array = $existing_offers_per_shop[ $all_shop_id ];
			} else {
				$existing_offer_array = array();
			}

			foreach ( $all_offer_array as $all_offer ) {
				$existing_offer_found = false;
				foreach ( $existing_offer_array as $existing_offer ) {
					if ( $all_offer->number == $existing_offer->number && $all_offer->shopid == $existing_offer->shopid && $all_offer->type == $existing_offer->type ) {
						$existing_offer_found = true;
						break;
					}
				}

				if ( ! $existing_offer_found ) {

					array_push( $offers_to_add, $all_offer );
				} else {
					if($existing_offer->message != '' && !ATKPTools::str_contains($existing_offer->message, 'product not found', false))
						array_push($offers_to_reset, $existing_offer);
				}
			}
		}

		foreach ( $existing_offers_per_shop as $existing_shop_id => $existing_offer_array ) {
			$all_offer_array = null;
			if ( isset( $all_offers_per_shop[ $existing_shop_id ] ) ) {
				$all_offer_array = $all_offers_per_shop[ $existing_shop_id ];
			} else {
				$all_offer_array = array();
			}

			foreach ( $existing_offer_array as $existing_offer ) {
				if ( intval( $existing_offer->type ) != atkp_product_offer::OFFER_TXPE_EAN ) {
					continue;
				}

				$all_offer_found = false;
				foreach ( $all_offer_array as $all_offer ) {

					if ( $all_offer->number == $existing_offer->number && $all_offer->shopid == $existing_offer->shopid && $all_offer->type == $existing_offer->type ) {
						$all_offer_found = true;
						break;
					}
				}

				if ( ! $all_offer_found ) {

					array_push( $offers_to_remove, $existing_offer );
				}
			}
		}
		/*
			echo '<hr>$all_offers_per_shop: <pre>';
			var_dump( $all_offers_per_shop );
			echo '<hr>$existing_offers_per_shop: <pre>';
			var_dump( $existing_offers_per_shop );


			echo '<hr>$offers_to_add: <pre>';
			var_dump( $offers_to_add );
			echo '<hr>$offers_to_remove: <pre>';
			var_dump( $offers_to_remove );
			exit;
*/


		if ( $listid != '' ) {
			if(count($offers_to_add) > 0)
				$atkp_offertable_helper->add_offers_by_listid( $listid, $product->asin, $offers_to_add );
			if(count($offers_to_remove) > 0)
				$atkp_offertable_helper->delete_offers_by_listid( $listid,  $offers_to_remove );
			if(count($offers_to_reset) > 0)
				$atkp_offertable_helper->reset_offers_by_listid( $listid,  $offers_to_reset );
		} else {
			if(count($offers_to_add) > 0)
				$atkp_offertable_helper->add_offers_by_productid( $product->productid, $offers_to_add );
			if(count($offers_to_remove) > 0)
				$atkp_offertable_helper->delete_offers_by_productid( $product->productid, $offers_to_remove );
			if(count($offers_to_reset) > 0)
				$atkp_offertable_helper->reset_offers_by_productid( $product->productid, $offers_to_reset );
		}
	}

}