<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_global_tools {
	function atkp_import_product( $shopid, $asin, $asintype, $title, $status, $importurl, $brand = '', $mpn = '' ) {
		try {

			if ( $shopid == '' ) {
				throw new Exception( 'shop required' );
			}
			if ( $asin == '' ) {
				throw new Exception( 'asin required' );
			}

			$duplicatecheck = get_option( ATKP_PLUGIN_PREFIX . '_duplicatecheck', 0 );
			$post_id        = 0;

			if ( $duplicatecheck == 1 ) {

				$post_id = apply_filters( 'atkp_post_exists', $post_id, $shopid, $asin, $asintype, $title, $brand, $mpn );

			}

			if ( $post_id <= 0 ) {

				$newfields  = atkp_udfield::load_fields();
				$taxonomies = atkp_udtaxonomy::load_taxonomies();

				$defaultproductstate = get_option( ATKP_PLUGIN_PREFIX . '_defaultproductstate', 'draft' );

				if ( $status == null || $status == '' ) {
					$status = $defaultproductstate;
				}

				$post_id = ATKPTools::create_product( $title, $shopid, $asin, $status, $asintype );

				foreach ( $taxonomies as $taxonomy ) {
					if ( ! $taxonomy->showui || $taxonomy->isnewtax ) {
						continue;
					}

					$parametername = str_replace( '-', '_', 'atkp-tax-' . $taxonomy->name );
					$val           = ATKPTools::get_post_parameter( $parametername, 'string' );

					if ( $val != null && $val != '' ) {
						ATKPTools::check_taxonomy( $post_id, $taxonomy->name, $val, true );
					}
				}

				foreach ( $newfields as $newfield ) {
					//html controls überspringen
					if ( $newfield->type == 5 ) {
						continue;
					}

					$fieldvalue    = null;
					$parametername = str_replace( '-', '_', 'atkp-field-' . $newfield->name );

					switch ( $newfield->type ) {

						case 1:
							//Text
							$type = 'text';
							switch ( $newfield->format ) {
								default:
								case 'text':
									$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'string' );
									break;
								case 'number':
									$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'int' );
									break;
								case 'url':
									$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'url' );
									break;
							}


							break;
						case 2:
							//multiline
							$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'multistring' );
							break;
						case 3:
							//dropdown
							$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'string' );
							break;
						case 4:
							//yesno
							$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'string' );

							switch ( $fieldvalue ) {
								default:
								case '':
									$fieldvalue = null;
									break;
								case '0':
									$fieldvalue = '0';
									break;
								case '1';
									$fieldvalue = '1';
									break;

							}
							break;
						case 5:
							//html
							$fieldvalue = ATKPTools::get_post_parameter( $parametername, 'html' );
							break;
						default:
							throw new exception( 'unknown newfield->type: ' . $newfield->type );
					}

					$fieldname = 'customfield_' . $newfield->name;

					if ( $fieldvalue != null ) {
						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );
					}
				}

				$productservice = new atkp_productservice( array() );

				//lade beim hinzufügen keine preisvergleiche
				$refreshpricecompare = false;

				$shop = $shopid != '' ? atkp_shop::load( $shopid, true ) : null;

				$dontUpdatetitle = $title != '';

				$productservice->update_products( $shop, array( $post_id ), $asintype, false, 1, 1, 1, 1, 1, 1, $refreshpricecompare, $dontUpdatetitle );

				if ( $title == '' && get_the_title( $post_id ) == '' ) {
					$title = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title' );
				}

				//correct post title
				if ( $title != '' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title', $title );

					global $wpdb;

					$querystr = "
		                        SELECT $wpdb->posts.* 
		                        FROM $wpdb->posts
		                        WHERE 
		                         $wpdb->posts.post_type = '" . ATKP_PRODUCT_POSTTYPE . "'
		                        AND $wpdb->posts.post_name = '" . sanitize_title( $title ) . "'
		                        AND $wpdb->posts.ID <> '" . $post_id . "'
		                     ";

					$pageposts = $wpdb->get_results( $querystr, OBJECT );

					if ( $pageposts && count( $pageposts ) > 0 ) {
						$title .= '-' . time();
					}

					$wpdb->update( $wpdb->posts, array(
						'post_title' => $title,
						'post_name'  => sanitize_title( $title )
					), array( 'ID' => $post_id ) );
				}



				if ( $importurl != null ) {
					//parse url and update values...

					$parser = new atkp_url_scraper();
					$parser->import_productdetails( $importurl, $post_id );
				}


				if ( $brand != '' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_brand', $brand );
				}
				if ( $mpn != '' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mpn', $mpn );
				}

				if ( $status == 'woo' ) {
					$productservice->export_products( array( $post_id ) );
				} else if ( $status == 'publish' ) {
					ATKPTools::publish_product( $post_id, $title );
				}
			}

			$gif_data[] = array(
				'postid'   => $post_id,
				'title'    => ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title' ),
				'edit_url' => get_edit_post_link( $post_id ),
			);

			return $gif_data;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			return $gif_data;
		}
	}


}