<?php
/**
 * DO NOT EDIT THIS FILE!
 *
 * This file was automatically generated from external sources.
 *
 * Any manual change here will be lost the next time the SDK
 * is updated. You've been warned!
 */

namespace DTS\eBaySDK\Browse\Services;

class BrowseService extends \DTS\eBaySDK\Browse\Services\BrowseBaseService {
	const API_VERSION = 'v1';

	/**
	 * @property array $operations Associative array of operations provided by the service.
	 */
	protected static $operations = [
		'getItem'        => [
			'method'        => 'GET',
			'resource'      => 'item/{item_id}',
			'responseClass' => '\DTS\eBaySDK\Browse\Types\GetItemRestResponse',
			'params'        => [
				'item_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'getItemFeed'    => [
			'method'        => 'GET',
			'resource'      => 'item_feed',
			'responseClass' => '\DTS\eBaySDK\Browse\Types\GetItemFeedRestResponse',
			'params'        => [
				'category_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'date'        => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'feed_type'   => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'getItemGroup'   => [
			'method'        => 'GET',
			'resource'      => 'item_group/{item_group_id}',
			'responseClass' => '\DTS\eBaySDK\Browse\Types\GetItemGroupRestResponse',
			'params'        => [
				'item_group_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'searchForItems' => [
			'method'        => 'GET',
			'resource'      => 'item_summary/search',
			'responseClass' => '\DTS\eBaySDK\Browse\Types\SearchForItemsRestResponse',
			'params'        => [
				'filter' => [
					'valid' => [ 'string' ]
				],
				'limit'  => [
					'valid' => [ 'string' ]
				],
				'offset' => [
					'valid' => [ 'string' ]
				],
				'q'      => [
					'valid' => [ 'string' ]
				],
				'sort'   => [
					'valid' => [ 'string' ]
				]
			]
		]
	];

	/**
	 * @param array $config Configuration option values.
	 */
	public function __construct( array $config = [] ) {
		parent::__construct( $config );
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Browse\Types\GetItemRestResponse
	 */
	public function getItem( \DTS\eBaySDK\Browse\Types\GetItemRestRequest $request ) {
		return $this->getItemAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getItemAsync( \DTS\eBaySDK\Browse\Types\GetItemRestRequest $request ) {
		return $this->callOperationAsync( 'getItem', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemFeedRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Browse\Types\GetItemFeedRestResponse
	 */
	public function getItemFeed( \DTS\eBaySDK\Browse\Types\GetItemFeedRestRequest $request ) {
		return $this->getItemFeedAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemFeedRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getItemFeedAsync( \DTS\eBaySDK\Browse\Types\GetItemFeedRestRequest $request ) {
		return $this->callOperationAsync( 'getItemFeed', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemGroupRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Browse\Types\GetItemGroupRestResponse
	 */
	public function getItemGroup( \DTS\eBaySDK\Browse\Types\GetItemGroupRestRequest $request ) {
		return $this->getItemGroupAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\GetItemGroupRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getItemGroupAsync( \DTS\eBaySDK\Browse\Types\GetItemGroupRestRequest $request ) {
		return $this->callOperationAsync( 'getItemGroup', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\SearchForItemsRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Browse\Types\SearchForItemsRestResponse
	 */
	public function searchForItems( \DTS\eBaySDK\Browse\Types\SearchForItemsRestRequest $request ) {
		return $this->searchForItemsAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Browse\Types\SearchForItemsRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function searchForItemsAsync( \DTS\eBaySDK\Browse\Types\SearchForItemsRestRequest $request ) {
		return $this->callOperationAsync( 'searchForItems', $request );
	}
}
