<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 01.04.2018
 * Time: 10:18
 */

/**
 * Diese Klasse aktualisiert die Listen aus den Providern
 */
class atkp_listservice {

	public function build_filter( $post_id, &$requestType, &$nodeid, &$keyword, &$asin, &$maxCount, &$sortOrder, &$filter ) {
		$source = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_source' );

		$extendedsearchlimit = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_extendedsearch_limit' );
		$searchlimit         = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_search_limit' );

		$searchdepartment = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_search_department' );
		$searchkeyword    = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_search_keyword' );
		$searchorderby    = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_search_orderby' );

		$nodeid    = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_node_id' );
		$keyword   = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_keyword' );
		$productid = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_productid' );

		$filterfield1 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield1' );
		$filtertext1  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext1' );
		$filterfield2 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield2' );
		$filtertext2  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext2' );
		$filterfield3 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield3' );
		$filtertext3  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext3' );
		$filterfield4 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield4' );
		$filtertext4  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext4' );
		$filterfield5 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield5' );
		$filtertext5  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext5' );

		$filterfield6  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield6' );
		$filtertext6   = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext6' );
		$filterfield7  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield7' );
		$filtertext7   = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext7' );
		$filterfield8  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield8' );
		$filtertext8   = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext8' );
		$filterfield9  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield9' );
		$filtertext9   = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext9' );
		$filterfield10 = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filterfield10' );
		$filtertext10  = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_filtertext10' );


		$requestType = 'Search';
		$sortOrder   = '';
		$keyword     = '';
		$maxCount    = 20;
		$asin        = '';
		$filter      = array();

		switch ( $source ) {
			case 10:
				$requestType = 'TopSellers';
				break;
			case 11:
				$requestType = 'NewReleases';
				break;
			case 20:
				$requestType = 'Search';
				$keyword     = $searchkeyword;;
				$sortOrder = $searchorderby;
				if ( $searchdepartment == '' ) {
					$nodeid = 'All';
				} else {
					$nodeid = $searchdepartment;
				}
				$maxCount = $searchlimit;
				break;
			case 30:
				$requestType = 'ExtendedSearch';
				if ( $filterfield1 != '' ) {
					$filter[ $filterfield1 ] = $filtertext1;
				}
				if ( $filterfield2 != '' ) {
					$filter[ $filterfield2 ] = $filtertext2;
				}
				if ( $filterfield3 != '' ) {
					$filter[ $filterfield3 ] = $filtertext3;
				}
				if ( $filterfield4 != '' ) {
					$filter[ $filterfield4 ] = $filtertext4;
				}
				if ( $filterfield5 != '' ) {
					$filter[ $filterfield5 ] = $filtertext5;
				}


				if ( $filterfield6 != '' ) {
					$filter[ $filterfield6 ] = $filtertext6;
				}
				if ( $filterfield7 != '' ) {
					$filter[ $filterfield7 ] = $filtertext7;
				}
				if ( $filterfield8 != '' ) {
					$filter[ $filterfield8 ] = $filtertext8;
				}
				if ( $filterfield9 != '' ) {
					$filter[ $filterfield9 ] = $filtertext9;
				}
				if ( $filterfield10 != '' ) {
					$filter[ $filterfield10 ] = $filtertext10;
				}

				$maxCount = $extendedsearchlimit;
				$nodeid   = 'All';
				break;
			case 40:
				$requestType = 'Similarity';
				$asin        = $productid;
				break;
		}

		return true;
	}

	public function mark_asinvalid( $post_ids ) {
		foreach ( $post_ids as $post_id ) {
			$shopid = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_shopid' );

			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );

			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', 'list uses an unknown shop: ' . $shopid );
		}
	}

	/**
	 * Aktualisiert die übergebenen Listen
	 *
	 * @param $post_ids
	 */
	public function update_lists( $shop, $post_ids ) {

		foreach ( $post_ids as $post_id ) {
			try {
				$message = '';

				$titlekeywords      = null;
				$searchttitlefilter = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_search_titelfilter' );
				$loadmoreoffers     = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_loadmoreoffers' );
				$autoimportproducts = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_autoimportproducts' );
				$autodeleteproducts = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_autodeleteproducts' );

				if ( $searchttitlefilter != null ) {
					$titlekeywords = array_map( 'strtolower', explode( "\n", $searchttitlefilter ) );
				}

				$atresponse = null;

				if ( $shop != null ) {
					try {
						$message = $shop->provider->checklogon( $shop );
					} catch ( Exception $e ) {
						$message = 'Shop Exception: ' . $e->getMessage();
					}

					if ( $message == '' ) {
						try {
							$requestType = '';
							$sortOrder   = '';
							$keyword     = '';
							$maxCount    = 20;
							$asin        = '';
							$filter      = array();
							$nodeid      = '';

							if ( ! $this->build_filter( $post_id, $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filter ) ) {
								$message = 'filter build error';
							}

							$atresponse = $shop->provider->retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filter );
						} catch ( GuzzleHttp\Exception\ServerException $exception ) {
							$response = $exception->getResponse();
							if ( $response != null && $response->getBody() != null ) {
								$responseBodyAsString = $response->getBody()->getContents();
							} else {
								$responseBodyAsString = $exception->getMessage();
							}

							$message = 'Request ServerException: ' . $responseBodyAsString;

						} catch ( Exception $e ) {

							$message = 'Request Exception: ' . $e->getMessage();

							if ( $this->str_contains( $message, 'RequestThro', false ) ) {
								sleep( 5 );

								//duplikat code sollte weg..

								try {
									$requestType = '';
									$sortOrder   = '';
									$keyword     = '';
									$maxCount    = 20;
									$asin        = '';
									$filter      = array();
									$nodeid      = '';

									if ( ! $this->build_filter( $post_id, $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filter ) ) {
										$message = 'filter build error';
									}

									$atresponse = $shop->provider->retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filter );
								} catch ( Exception $e ) {
									$message = 'Request Exception: ' . $e->getMessage();
								}
							}
						}
					}
				}

				$errormessage = '';

				if ( $message != '' ) {
					$errormessage = $message;
				} else if ( $atresponse != null && $atresponse->message != '' ) {
					$errormessage = 'Request error: ' . $atresponse->message;
				}

				ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );

				if ( $errormessage != '' ) {
					ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', $errormessage );
				} else {
					ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', '' );
					$updatemessage = '';

					try {

						$atkp_offertable_helper = new atkp_offertable_helper();
						//$atkp_offertable_helper->clear_offers_by_listid( $post_id );

						$productlist = array();

						if ( $shop != null ) {
							//wenn shop vorhanden dann listeneinträge schreiben
							$atresponse->listid = $post_id;

							if ( $atresponse->products != null ) {
								$prefiltered = array();

								if ( $titlekeywords != null && count( $titlekeywords ) > 0 ) {
									$deletekeywords = array();
									$addkeywords    = array();

									foreach ( $titlekeywords as $titlekeyword ) {
										if ( $titlekeyword == '' ) {
											continue;
										}

										if ( substr( $titlekeyword, 0, 1 ) == '-' ) {
											array_push( $deletekeywords, substr( $titlekeyword, 1 ) );
										} else {
											array_push( $addkeywords, $titlekeyword );
										}
									}

									foreach ( $atresponse->products as $azproduct ) {
										$title = ATKPTools::clear_string( $azproduct->title );

										$addit = count( $addkeywords ) == 0;

										foreach ( $deletekeywords as $del ) {
											if ( $this->str_contains( $title, $del, false ) ) {
												$addit = false;
												break;
											}
										}

										foreach ( $addkeywords as $add ) {
											if ( $this->str_contains( $title, $add, false ) ) {
												$addit = true;
												break;
											}
										}


										if ( $addit ) {
											array_push( $prefiltered, $azproduct );
										}
									}
								} else {
									$prefiltered = $atresponse->products;
								}

								foreach ( $prefiltered as $azproduct ) {
									$item          = array();
									$item['type']  = 'product';
									$item['value'] = $azproduct;

									$azproduct->producturl        = $this->shorten_url( $post_id, $shop->id, $azproduct->producturl );
									$azproduct->addtocarturl      = $this->shorten_url( $post_id, $shop->id, $azproduct->addtocarturl );
									$azproduct->customerreviewurl = $this->shorten_url( $post_id, $shop->id, $azproduct->customerreviewurl );

									array_push( $productlist, $item );
								}
							}

							$this->update_list_postdata( $post_id, $atresponse );

							if($autodeleteproducts) {
								$this->autodelete_products( $shop, $post_id, $productlist );
							}else if ( $autoimportproducts ) {
								$productlist = $this->autoimport_products( $shop, $post_id, $productlist );
							}

							if ( $loadmoreoffers ) {
								$this->create_offers( $post_id, $productlist );
							}

						} else {
							$products = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_products' );

							foreach ( explode( "\n", $products ) as $productid ) {
								$item          = array();
								$item['type']  = 'productid';
								$item['value'] = $productid;

								array_push( $productlist, $item );
							}
						}

						$this->update_list_entries( $post_id, $productlist );


					} catch ( Exception $e ) {
						$updatemessage = 'Update-Error: ' . $e->getMessage();
					}

					if ( $updatemessage != '' ) {
						ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', $updatemessage );
					}
				}

				do_action( 'atkp_list_updated', $post_id );

			} catch
			( Exception $e ) {

				//var_dump( $e->getMessage() );
				//array_push( $errors, 'Product ' . $post_id . ': ' . $e->getMessage() );
				ATKPLog::LogError( $e->getMessage() );
			}
		}
	}

	private function str_contains( $string, $searchstring, $caseSensitive = true ) {
		return ATKPTools::str_contains( $string, $searchstring, $caseSensitive );
	}

	private function create_offers( $post_id, $productlist ) {

		$offerservice = new atkp_offerservice();

		//im ersten schritt die angebote löschen, die werden später extra geladen
		foreach ( $productlist as $productentry ) {
			$type  = $productentry['type'];
			$value = $productentry['value'];

			switch ( $type ) {
				case "product":
					$offerservice->clear_offers( $value, $post_id );
					break;
				case "productid":
					//lokales produkt? dann diesen preisvergleich laden
					break;
			}
		}
	}

	private function autodelete_products( $shop, $post_id, $productlist ) {
		foreach ( $productlist as $item ) {
			$type  = $item['type'];
			$value = $item['value'];

			switch ( $type ) {
				case "product":
					$prdfound = atkp_product::loadbyasin( $value->asin );

					if ( $prdfound != null ) {
						wp_delete_post($prdfound->productid);
					}

					break;
				case "productid":
					//lokales produkt? dann natürlich nicht anlegen
					break;
			}
		}

	}

	private function autoimport_products( $shop, $post_id, $productlist ) {


		$productservice = new atkp_productservice();

		$productlistnew = array();

		foreach ( $productlist as $item ) {
			$type  = $item['type'];
			$value = $item['value'];

			$added = false;
			switch ( $type ) {
				case "product":
					$prdfound = atkp_product::loadbyasin( $value->asin );

					if ( $prdfound == null ) {
						$status              = '';
						$defaultproductstate = get_option( ATKP_PLUGIN_PREFIX . '_defaultproductstate', 'draft' );

						if ( $status == null || $status == '' ) {
							$status = $defaultproductstate;
						}

						$value->title = ATKPTools::clear_string( $value->title );

						//produkt mit der eindeutigen ID ist nicht in der Datenbank. Also, neu anlegen!
						$product_id = ATKPTools::create_product( $value->title, $shop->id, $value->asin, $status, 'ASIN' );

						$productservice->update_product_postdata( $product_id, $value, $value->asin, 'ASIN', true, true, true, true, true, true );
						ATKPTools::set_post_setting( $product_id, ATKP_PRODUCT_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );
						ATKPTools::set_post_setting( $product_id, ATKP_PRODUCT_POSTTYPE . '_message', '' );

						$prdfound = atkp_product::load( $product_id );

						if ( $status == 'woo' ) {
							$productservice->export_products( array( $product_id ) );
						} else if ( $status == 'publish' ) {
							ATKPTools::publish_product( $product_id );
						}
					}

					if ( $prdfound != null && $prdfound->productid != '' ) {
						$itemnew          = array();
						$itemnew['type']  = 'productid';
						$itemnew['value'] = $prdfound->productid;

						array_push( $productlistnew, $itemnew );
						$added = true;
					}
					break;
				case "productid":
					//lokales produkt? dann natürlich nicht anlegen
					break;
			}
			if ( ! $added ) {
				array_push( $productlistnew, $item );
			}
		}

		return $productlistnew;
	}

	private function update_list_postdata( $post_id, $mylist ) {

		try {
			$mylist = apply_filters( 'atkp_retrieve_list', $mylist );

			if ( ! isset( $mylist ) || $mylist == null ) {
				throw new Exception( 'list is null: ' . $post_id );
			}

			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_listurl', $mylist->listurl );
			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_node_caption', $mylist->browsenodename );


			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', null );
		} catch ( Exception $e ) {
			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', 'Error: ' . $e->getMessage() );
		}
	}

	private function update_list_entries( $post_id, $productlist ) {
		try {
			if ( $productlist == null || count( $productlist ) == 0 ) {
				ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_productlist', null );

				throw new Exception( 'list has no entries' );
			} else {
				ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_productlist', $productlist );
			}

			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', null );
		} catch ( Exception $e ) {
			ATKPTools::set_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_message', 'Error: ' . $e->getMessage() );
		}
	}

	/**
	 * Kürzt eine URL von einem Liste aufgrund des Shops
	 *
	 * @param int $productid Die AT-Produkt-ID (wird nicht verwendet)
	 * @param int $shopid Die Shop-ID mit welcher die URL gekürzt wird. Ist diese leer, wird die URL einfach zurückgegeben
	 * @param string $url Die URL welche gekürzt werden soll
	 *
	 * @return string
	 */
	public function shorten_url( $listid, $shopid, $url ) {
		//TODO: Wenn ShopId leer ist, dann Shopid von der Liste laden?
		if ( $shopid == '' ) {
			return $url;
		}

		$redirtype = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_redirectiontype' );

		$apikey   = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_apikey' );
		$apilogin = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_apilogin' );

		switch ( $redirtype ) {
			default:
				//disabled
				break;
			case 3:
			case 4:
			case 5:
			case 6:

				$shortener = new atkp_shortener();

				$url = $shortener->shorten_url( $apikey, $apilogin, $redirtype, $url );

				break;
		}

		return $url;
	}
}