<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_tools_importlist {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {

	}

	public function importlist_configuration_page() {
		$importing = false;

		if ( ATKPTools::exists_post_parameter( 'saveimportlist' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			$importing = true;
		}


		if ( $importing ) {
			//get list parameters
			//build javascript array for import
			//update ajax list import function

			$shopid         = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_listshop', 'string' );
			$listsource     = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_listsource', 'string' );
			$lists          = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_lists', 'multistring' );
			$loadmoreoffers = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_loadmoreoffers', 'bool' );

			$listarray = (array) explode( "\n", (string) $lists );

			$shop = atkp_shop::load( $shopid );

			if ( $shop == null || $shop->provider == null ) {
				echo 'shop not found: ' . $shopid;
				exit;
			}
			$shop->provider->checklogon( $shop );

			$departments = $shop->provider->retrieve_departments();;

			$jsobject           = '';
			$jsvalidatingerrors = '';

			$count = 0;

			foreach ( $listarray as $list ) {
				$fieldsarray = (array) explode( ';', (string) $list );

				$fieldsarray = array_map( 'trim', $fieldsarray );

				//keyword;name;department;sortby;browsenodeid
				if ( count( $fieldsarray ) == 0 ) {
					continue;
				}

				$keyword = $fieldsarray[0];

				if ( $keyword == '' || $keyword == ' ' ) {
					continue;
				}

				if ( count( $fieldsarray ) > 1 ) {
					$name = $fieldsarray[1];
				} else {
					$name = $keyword;
				}

				$validatingerror = '';
				$departmentfound = '';
				$sortbyfound     = '';

				if ( $listsource == 10 || $listsource == 11 ) {
					if ( ! is_a( $shop->provider, 'atkp_shop_provider_amazon' ) ) {
						$validatingerror .= 'category list only supported by amazon';
					}


					if ( ! is_numeric( $keyword ) ) {
						$validatingerror .= ( $validatingerror == '' ? '' : ' and ' ) . 'browsenodeid is not numeric';
					}


				} else {

					if ( count( $fieldsarray ) > 2 ) {
						$department = $fieldsarray[2];
					} else {
						$department = '';
					}
					if ( count( $fieldsarray ) > 3 ) {
						$sortby = $fieldsarray[3];
					} else {
						$sortby = '';
					}


					if ( $departments != null && $department != '' ) {
						foreach ( $departments as $departmentid => $departmentdetail ) {
							if ( is_array( $departmentdetail ) && isset( $departmentdetail['caption'] ) ) {
								if ( $departmentdetail['caption'] == $department ) {
									$departmentfound = $departmentid;

									if ( $sortby != '' && isset( $departmentdetail['sortvalues'] ) ) {
										foreach ( $departmentdetail['sortvalues'] as $sortid => $sortcaption ) {
											if ( $sortid == $sortby || $sortcaption == $sortby ) {
												$sortbyfound = $sortid;
												break;
											}
										}
									}

									break;
								}
							}
						}
					}

					if ( $department != '' && $departmentfound == '' ) {
						$validatingerror .= 'department not found (' . $department . ')';
					}

					if ( $sortby != '' && $sortbyfound == '' ) {
						$validatingerror .= ( $validatingerror == '' ? '' : ' and ' ) . 'sortby not found (' . $sortby . ')';
					}
				}


				if ( $loadmoreoffers ) {
					$loadmoreoffers = '1';
				} else {
					$loadmoreoffers = '0';
				}

				if ( $validatingerror != '' ) {
					$jsvalidatingerrors .= $list . ';' . $validatingerror . "\n";
				} else {
					$jsobject .= 'lists[lists.length] = {shop: \'' . $shopid . '\', source: \'' . $listsource . '\', loadmoreoffers: \'' . $loadmoreoffers . '\', title: \'' . $name . '\', keyword:\'' . $keyword . '\', department:\'' . $departmentfound . '\', sortby:\'' . $sortbyfound . '\' };' . "\n";
				}
				$count ++;
			}

			if ( $count == 0 ) {
				_e( 'import list is empty' );
				exit;
			}

			?>
            <style>
                #atkp-progressBar {

                    width: 60%;
                    height: 22px;
                }

                #atkp-progressBar div {
                    height: 100%;
                    color: #fff;
                    text-align: right;
                    font-size: 12px;
                    line-height: 22px;
                    width: 0;
                }

                .atkp-progress-default {
                    background: #292929;
                    border: 1px solid #111;
                    border-radius: 5px;
                    overflow: hidden;
                    box-shadow: 0 0 5px #333;
                }

                .atkp-progress-default div {
                    background-color: #1a82f7;
                    background: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#0099FF), to(#1a82f7));
                    background: -webkit-linear-gradient(top, #0099FF, #1a82f7);
                    background: -moz-linear-gradient(top, #0099FF, #1a82f7);
                    background: -ms-linear-gradient(top, #0099FF, #1a82f7);
                    background: -o-linear-gradient(top, #0099FF, #1a82f7);
                }
            </style>
            <script>
                function progressBar(percent, $element) {
                    var progressBarWidth = percent * $element.width() / 100;
                    $element.find('div').animate({width: progressBarWidth}, 500).html(percent + "%&nbsp;");
                }
            </script>

            <div id="atkp-progressText"><?php _e( 'importing...', ATKP_PLUGIN_PREFIX ) ?></div>
            <br/>
            <div id="atkp-progressBar" class="atkp-progress-default">
                <div></div>
            </div><br/>

            <textarea readonly style="width:60%;height:400px"
                      id="atkp-progress-listresult"><?php echo esc_textarea( $jsvalidatingerrors ); ?></textarea>


            <script>

                var $j = jQuery.noConflict();
                jQuery(document).ready(function ($) {
                    var lists = [];
					<?php echo $jsobject; ?>


                    var length = lists.length;
                    var step = 1;
                    lists.forEach(function (entry) {
                        $j("#atkp-progressText").html("<?php _e( 'importing...', ATKP_PLUGIN_PREFIX ) ?> " + entry.title);

                        atkp_createmasslist(entry.shop, entry.source, entry.title, entry.keyword, entry.department, entry.sortby, entry.loadmoreoffers, step, length);

                        sleep(3000);

                        step++;
                    });

                    $('atkp-progressBarBar').hide();
                    $('atkp-progressBarText').hide();

                });

                function sleep(delay) {
                    var start = new Date().getTime();
                    while (new Date().getTime() < start + delay) ;
                }

                function writeline(keyword, title, department, sortby, text) {
                    var newval = $j("#atkp-progress-listresult").val();
                    if (newval != '')
                        newval += "\n";

                    newval += keyword + ";" + title + ";" + department + ";" + sortby + ";" + text;

                    $j("#atkp-progress-listresult").val(newval);
                }

                function atkp_createmasslist(shop, source, title, keyword, department, sortby, loadmoreoffers, step, length) {
                    //atkp_createlist(entry.shop, entry.source, entry.title, entry.keyword, entry.department, entry.sortby, entry.browsenodeid, entry.loadmoreoffers);

					<?php $noncex = wp_create_nonce( 'atkp-import-nonce' ); ?>

                    $j.ajax({
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl();  ?>",
                        data: {
                            action: "atkp_create_list",
                            shop: shop,
                            title: title,
                            department: department,
                            sortby: sortby,
                            searchterm: keyword,
                            listtype: source,
                            loadmoreoffers: loadmoreoffers,
                            request_nonce: "<?php echo $noncex ?>"
                        },

                        dataType: "json",
                        success: function (data) {
                            try {
                                var importerror = '';

                                if (data.length == 0) {
                                    importerror = ('unknown issue');

                                } else if (typeof data[0].error != 'undefined') {
                                    importerror = (data[0].error + ': ' + data[0].message);
                                }

                                if (importerror != '')
                                    writeline(keyword, title, department, sortby, importerror);
                                else
                                    writeline(keyword, title, department, sortby, data[0].postid);

                                progressBar((step / length) * 100, $j('#atkp-progressBar'));


                                return 'ok';

                            } catch (err) {
                                writeline('', '', '', '', err.message);
                                return (err.message);
                            }


                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            writeline('', '', '', '', 'Response-Error: ' + thrownError + ' - ' + xhr.responseText);
                            return (xhr.responseText);
                        }
                    });


                }
            </script>

			<?php

		} else {
			$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

			if ( $mytab != 0 ) {
				$tab = $mytab;
			} else {
				$tab = 1;
			}
			?>
            <div class="atkp-content wrap">
                <div class="inner">
                    <!-- <h2><?php _e( 'Affiliate Toolkit - Import', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                    <form method="POST"
                          action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-tools&tab=' . $tab ?>"
                          enctype="multipart/form-data"><!--_affiliate_toolkit-bestseller-->
						<?php wp_nonce_field( "save", "save" ); ?>
                        <table class="form-table" style="width:100%">
                            <tr valign="top">
                                <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
									<?php _e( 'Import lists', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'import-list' ); ?>
                                </th>
                            </tr>
                            <tr>
                                <th>
                                    <label for=""><?php _e( 'Shop', ATKP_PLUGIN_PREFIX ) ?>:</label>
                                </th>
                                <td>
                                    <select id="<?php echo ATKP_PLUGIN_PREFIX . '_listshop' ?>"
                                            name="<?php echo ATKP_PLUGIN_PREFIX . '_listshop' ?>" style="width:300px">
										<?php


										$shps = atkp_shop::get_list( '' );

										foreach ( $shps as $shp ) {
											if ( $shp->selected == true ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											$datasources = $shp->provider->get_supportedlistsources();

											if ( $datasources != '' ) {
												echo '<option data-sources="' . $datasources . '" value="' . $shp->id . '"' . $sel . ' > ' . esc_attr( $shp->title ) . '</option>';
											}
										}

										?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label for=""><?php _e( 'Source', ATKP_PLUGIN_PREFIX ) ?>:</label>
                                </th>
                                <td>
                                    <select name="<?php echo ATKP_PLUGIN_PREFIX . '_listsource' ?>"
                                            id="<?php echo ATKP_PLUGIN_PREFIX . '_listsource' ?>">
										<?php

										$durations = array(
											10 => __( 'Category - Best Seller', ATKP_PLUGIN_PREFIX ),
											11 => __( 'Category - New Releases', ATKP_PLUGIN_PREFIX ),
											20 => __( 'Search', ATKP_PLUGIN_PREFIX ),

										);

										foreach ( $durations as $value => $name ) {

											echo '<option value="' . $value . '">' . esc_attr( $name ) . '</option>';
										} ?>
                                    </select>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>">
										<?php _e( 'CSV (one list per line)', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </th>
                                <td colspan="2">
                                    keyword or browsenode;name;department;sortby
                                    <textarea style="width:100%;height:400px"
                                              id="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>"
                                              name="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>"></textarea>

                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">

                                </th>
                                <td>
                                    <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_loadmoreoffers' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_loadmoreoffers' ?>">
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_loadmoreoffers' ?>">
										<?php _e( 'Load offers from other shops (slower)', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </td>
                            </tr>

                            <tr>
                                <td>&nbsp;</td>
                            </tr>
                            <tr valign="top">
                                <td>
									<?php submit_button( '', 'primary', 'saveimportlist', false ); ?>
                                </td>
                            </tr>
                        </table>
                    </form>

                </div>
            </div> <?php
		}
	}
}

?>