<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_advanced {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {


	}


	public function advanced_configuration_page() {
		if ( ATKPTools::exists_post_parameter( 'saveadvanced' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			//speichern der einstellungen


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_duplicatecheck', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_duplicatecheck', 'int' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_defaultproductstate', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_defaultproductstate', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_imagetype', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_imagetype', 'int' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_importimage', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_importimage', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_additional_shortcode_button', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_additional_shortcode_button', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_mark_links', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_mark_links', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_disclaimer', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_disclaimer', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disclaimer_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disclaimer_text', 'html' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_add_to_cart', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_add_to_cart', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_open_window', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_open_window', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_link_click_tracking', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_link_click_tracking', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_jslink', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_jslink', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_redirectsearchresult', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_redirectsearchresult', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_redirectsearchresulttarget', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_redirectsearchresulttarget', 'string' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productgroupascategory', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productgroupascategory', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productgroupdeleteoldentries', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productgroupdeleteoldentries', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productgroupsplitchar', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productgroupsplitchar', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disableselect2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disableselect2', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disablelightslider', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disablelightslider', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disablefrontendselect2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disablefrontendselect2', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disablechartjs', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disablechartjs', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_title_link_type', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_title_link_type', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_ignoreoffernotfound', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_ignoreoffernotfound', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disable_sponsored_attribute', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disable_sponsored_attribute', 'bool' ) );




			$args = array(
				'public'   => true,
				'_builtin' => false
			);

			$post_types = get_post_types( $args, 'names', 'and' );

			$post_types_sel = array();

			foreach ( $post_types as $post_type ) {

				if ( ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_posttype_' . $post_type, 'bool' ) ) {
					array_push( $post_types_sel, $post_type );
				}
			}

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_custom_posttypes', $post_types_sel );

		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="atkp-content wrap">
            <div class="inner">
                <!-- <h2><?php _e( 'Affiliate Toolkit - Advanced Settings', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>">
                    <!--_affiliate_toolkit-bestseller-->
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Disclaimer settings', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-disclaimer' ); ?>
                            </th>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_show_disclaimer' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_show_disclaimer' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_show_disclaimer(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_disclaimer' ?>">
									<?php _e( 'Show disclaimer', ATKP_PLUGIN_PREFIX ) ?>
                                </label> <br/>
                                <label for="">
									<?php _e( 'Amazon recommends including a disclaimer additionally to the pricing or availability information.', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="">
									<?php _e( 'Disclaimer', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>

								<?php
								wp_editor( atkp_options::$loader->get_disclaimer_text(), ATKP_PLUGIN_PREFIX . '_dislaimer_text', array(
									'media_buttons' => false,
									'textarea_name' => ATKP_PLUGIN_PREFIX . '_disclaimer_text',
									'textarea_rows' => 7,
								) );
								?>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Links & Buttons', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-links-buttons' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disable_sponsored_attribute' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disable_sponsored_attribute' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_disable_sponsored_attribute(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disable_sponsored_attribute' ?>">
				                    <?php _e( 'Disable "sponsored" link attribute', ATKP_PLUGIN_PREFIX ) ?>
                                </label> <br/>
                                <label for="">
				                    <?php _e( 'The new sponsored attribute can be used to identify links on your site that were created as part of advertisements, sponsorships or other compensation agreements.', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Default button typ', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_add_to_cart' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_add_to_cart' ?>" style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_add_to_cart();

									echo '<option value="addtocart" ' . ( $selected == 'addtocart' || $selected == '1' ? 'selected' : '' ) . ' >' . __( 'add to cart', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="link" ' . ( $selected == '' || $selected == 'link' ? 'selected' : '' ) . '>' . __( 'link', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="product" ' . ( $selected == 'product' ? 'selected' : '' ) . '>' . __( 'product page', ATKP_PLUGIN_PREFIX ) . '</option>';

									if ( class_exists( 'WooCommerce' ) ) {

										$mode = atkp_options::$loader->get_woo_mode();

										if ( $mode != '' ) {
											echo '<option value="woocommerce" ' . ( $selected == 'woocommerce' ? 'selected' : '' ) . '>' . __( 'woocommerce product page', ATKP_PLUGIN_PREFIX ) . '</option>';
										}
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'title link', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_title_link_type' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_title_link_type' ?>"
                                        style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_title_link_type();

									echo '<option value="link" ' . ( $selected == '' || $selected == 'link' ? 'selected' : '' ) . ' >' . __( 'link', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="product" ' . ( $selected == 'product' ? 'selected' : '' ) . '>' . __( 'product page', ATKP_PLUGIN_PREFIX ) . '</option>';

									if ( class_exists( 'WooCommerce' ) ) {

										$mode = atkp_options::$loader->get_woo_mode();

										if ( $mode != '' ) {
											echo '<option value="woocommerce" ' . ( $selected == 'woocommerce' ? 'selected' : '' ) . '>' . __( 'woocommerce product page', ATKP_PLUGIN_PREFIX ) . '</option>';
										}
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_mark_links' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_mark_links' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_mark_links(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_mark_links' ?>">
									<?php _e( 'Mark links (*)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                                <label for=""><?php echo ATKPHomeLinks::ReplaceLinkType( __( '<a href="%link_mark-affiliate-links%" target="_blank">Additional information</a>', ATKP_PLUGIN_PREFIX ) ) ?>
                                </label>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_open_window' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_open_window' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_open_window(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_open_window' ?>">
									<?php _e( 'Open links in new window/tab', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_jslink' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_jslink' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_openlinkswithjs(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_jslink' ?>">
									<?php _e( 'Open affiliate links with javascript (does not display the target link within the browser)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Click tracking', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_link_click_tracking' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_link_click_tracking' ?>"
                                        style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_link_click_tracking();

									echo '<option value="" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'No', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Google Universal Tracking (ga)', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Google Standard Tracking (_gaq)', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Google Tag Manager Tracking (gtag)', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Images', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-images' ); ?>
                            </th>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Post thumbnail', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_product_importimage' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_product_importimage' ?>"
                                        style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_product_importimage();

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'Do not import the image', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Import main image', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Use external main image', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Image redirect', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_product_imagetype' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_product_imagetype' ?>"
                                        style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_product_imagetype();

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'Don´t redirect image', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Redirect image', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Redirect image and main image', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Imports', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-imports' ); ?>
                            </th>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Duplicate check', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_duplicatecheck' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_duplicatecheck' ?>" style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_duplicatecheck();

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'Don´t check duplicates on import', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Check duplicates on import', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Default import state', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_defaultproductstate' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_defaultproductstate' ?>"
                                        style="width:300px">
									<?php
									$selected = atkp_options::$loader->get_defaultproductstate();

									echo '<option value="draft" ' . ( $selected == '' || $selected == 'draft' ? 'selected' : '' ) . ' >' . __( 'Draft', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="publish" ' . ( $selected == 'publish' ? 'selected' : '' ) . '>' . __( 'Publish', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="woo" ' . ( $selected == 'woo' ? 'selected' : '' ) . '>' . __( 'WooCommerce product', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupascategory' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupascategory' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_productgroupascategory(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupascategory' ?>">
									<?php _e( 'Import field "Productgroup" as product category (taxonomy)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupdeleteoldentries' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupdeleteoldentries' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_productgroupdeleteoldentries(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupdeleteoldentries' ?>">
									<?php _e( 'Delete old product categories', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Split product category by character', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupsplitchar' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productgroupsplitchar' ?>"
                                       value="<?php echo atkp_options::$loader->get_productgroupsplitchar(); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_ignoreoffernotfound' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_ignoreoffernotfound' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_ignoreoffernotfound(), true ); ?>>

                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_ignoreoffernotfound' ?>">
									<?php _e( 'Skip bad offers (with "product not found" error)', ATKP_PLUGIN_PREFIX ) ?>
                                    :
                                </label>
                            </td>
                        </tr>


                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Search result page', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-searchresult' ); ?>
                            </th>
                        </tr>
                        <tr valign="top">
                            <th>
                                <label style="font-weight:bold" for="">
									<?php _e( 'Redirect mode', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select style="width:300px"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_redirectsearchresult' ?>"
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_redirectsearchresult' ?>">
									<?php

									$filtertarget = atkp_options::$loader->get_redirectsearchresult();

									echo '<option value="0"' . ( '0' == $filtertarget ? ' selected' : '' ) . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="1"' . ( '1' == $filtertarget ? ' selected' : '' ) . '>' . __( 'Redirect if no results found', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2"' . ( '2' == $filtertarget ? ' selected' : '' ) . '>' . __( 'Redirect always', ATKP_PLUGIN_PREFIX ) . '</option>';


									?>
                                </select>
                            </td>


                        </tr>

                        <tr valign="top">
                            <th>
                                <label style="font-weight:bold" for="">
									<?php _e( 'Target page', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select style="width:300px"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_redirectsearchresulttarget' ?>"
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_redirectsearchresulttarget' ?>">
									<?php

									$filtertarget = atkp_options::$loader->get_redirectsearchresulttarget();

									if ( '' == $filtertarget ) {
										$sel = ' selected';
									} else {
										$sel = '';
									}

									echo '<option value=""' . $sel . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';

									$args = array(
										'post_type'      => array( 'page' ),
										'posts_per_page' => 100,
										'post_status'    => array( 'publish' ),
									);

									$query2 = new WP_Query( $args );

									if ( $query2->have_posts() ) {

										while ( $query2->have_posts() ) {
											$query2->the_post();

											if ( $query2->post->ID == $filtertarget ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . $query2->post->ID . '"' . $sel . '>' . esc_attr( $query2->post->post_title ) . '</option>';

										}


									}
									/* Restore original Post Data */
									wp_reset_postdata();


									?>
                                </select>
                            </td>
                        </tr>


                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Compatibility', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-compatibility' ); ?>
                            </th>
                        </tr>
                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_additional_shortcode_button' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_additional_shortcode_button' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_additional_shortcode_button(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_additional_shortcode_button' ?>">
									<?php _e( 'Show additional shortcode button', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disableselect2' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disableselect2' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_disableselect2_backend(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disableselect2' ?>">
									<?php _e( 'Disable select2 fields', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disablefrontendselect2' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disablefrontendselect2' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_disableselect2_frontend(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disablefrontendselect2' ?>">
									<?php _e( 'Disable frontend select2 fields', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disablelightslider' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disablelightslider' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_disablelightslider(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disablelightslider' ?>">
									<?php _e( 'Disable lightslider', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disablechartjs' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disablechartjs' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_disablechartjs(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disablechartjs' ?>">
									<?php _e( 'Disable Chart.js', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Shortcode-Generator post-types', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <div style="border:1px solid #ccc; width:600px; height: 250px; overflow-y: scroll;padding:5px">
									<?php

									$args = array(
										'public'   => true,
										'_builtin' => false
									);

									$post_types = get_post_types( $args, 'names', 'and' );

									$sel_post_types = atkp_options::$loader->get_custom_posttypes();

									foreach ( $post_types as $post_type ) {
										$found = false;
										if ( $sel_post_types != null && is_array( $sel_post_types ) ) {
											foreach ( $sel_post_types as $pp ) {
												if ( $pp == $post_type ) {
													$found = true;
													break;
												}
											}
										}


										?>

                                        <input type="checkbox"
                                               id="<?php echo ATKP_SHOP_POSTTYPE . '_posttype_' . $post_type ?>"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_posttype_' . $post_type ?>"
                                               value="1" <?php echo checked( 1, $found, true ); ?>>
                                        <label for="<?php echo ATKP_SHOP_POSTTYPE . '_posttype_' . $post_type ?>">
											<?php echo $post_type; ?>
                                        </label><br/>

										<?php
									}

									?>
                                </div>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php submit_button( '', 'primary', 'saveadvanced', false ); ?>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div> <?php
	}
}

?>