<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_belboon extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider


	public function __construct() {
		if ( ! defined( "ATKP_Belboon_WSDL" ) ) {
			define( "ATKP_Belboon_WSDL", "http://smartfeeds.belboon.com/SmartFeedServices.php?wsdl" );
		}
		if ( ! defined( "ATKP_Belboon_API_WSDL" ) ) {
			define( "ATKP_Belboon_API_WSDL", "http://api.belboon.com/?wsdl" );
		}
	}

	public function get_maxproductcount() {
		return 100;
	}

	private $sessionHash = '';

	public function get_caption() {
		return __( 'Belboon API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	public function check_configuration( $post_id ) {
		try {
			$apikey       = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$enable_ssl   = true; // ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

			$message = '';
			if ( $apikey != '' && $apisecretkey != '' ) {


				$this->helper = new SoapClient( ATKP_Belboon_WSDL, array(
					"trace"      => false,
					"exceptions" => true
				) );

				$sessionHash = $this->helper->login( $apikey, $apisecretkey );

				if ( $sessionHash->HasError ) {
					$message = $sessionHash->ErrorMsg;

					return $message;
				}

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration belboon session ***' );
					ATKPLog::LogDebug( serialize( $sessionHash ) );
					ATKPLog::LogDebug( '*** check_configuration belboon session ***' );
				}

				$this->sessionHash = $sessionHash->Records['sessionHash'];

				$platforms = $this->helper->getPlatforms( $this->sessionHash );


				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration belboon ***' );
					ATKPLog::LogDebug( serialize( $platforms ) );
					ATKPLog::LogDebug( '*** check_configuration belboon ***' );
				}

				$config = array(
					'login'      => $apikey,
					'password'   => $apisecretkey,
					'trace'      => true,
					'exceptions' => true
				);


				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

				$subshops = array();


				$client = new SoapClient( ATKP_Belboon_API_WSDL, $config );

				if ( isset( $platforms->Records ) ) {
					foreach ( $platforms->Records as $platform ) {
						if ( $platform['status'] != 'active' ) {
							continue;
						}

						$result = $client->getPrograms(
							intval( $platform['id'] ), // adPlatformId
							null, // programLanguage
							'PARTNERSHIP', // partnershipStatus
							null, // query
							null, // orderBy
							null, // limit
							0 // offset
						);

						if ( isset( $result->handler->programs ) ) {
							foreach ( $result->handler->programs as $program ) {

								$subshop            = new subshop();
								$subshop->title     = $program['programname'];
								$subshop->title2    = $platform['name'];
								$subshop->shopid    = $platform['id'] . '_' . $program['programid'];
								$subshop->programid = $program['programid'];

								$subshop->logourl      = $this->checkimageurl( $program['programlogo'], $enable_ssl );
								$subshop->smalllogourl = $this->checkimageurl( $program['programlogo'], $enable_ssl );

								array_push( $subshops, $subshop );
							}
						}
					}
				}

				$this->helper->logout( $this->sessionHash );

				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );

			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_bel_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_bel_access_secret_key', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_bel_enable_ssl', 'bool' ) );

		// $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		//if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'bel');


		//echo serialize($subshops);exit;

		// ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = '';
		$enablessl    = false;


		if ( $webservice == '5' ) {
			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$enablessl = true ;// ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Publisher-ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'belboon-api' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_bel_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_bel_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Webservice-Password', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="password"
                       id="<?php echo ATKP_SHOP_POSTTYPE . '_bel_access_secret_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_bel_access_secret_key' ?>"
                       value="<?php echo $apisecretkey; ?>">
            </td>
        </tr>
<!--
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_bel_enable_ssl' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_bel_enable_ssl' ?>"
                       value="1" <?php echo checked( 1, $enablessl, true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_bel_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>
-->
        <!--<tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php
		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'bel');
		?>
                           
                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;

					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $helper = null;
	private $shopid = null;
	private $enable_ssl = false;
	private $client = null;
	private $programid = null;

	public function checklogon( $shop ) {
		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$apisecretkey     = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$this->enable_ssl = true; // ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

		if ( $apikey == '' || $apisecretkey == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$this->shopid    = $shop->id;
		$this->programid = $shop->programid;

		$this->helper = new SoapClient( ATKP_Belboon_WSDL );

		$sessionHash       = $this->helper->login( $apikey, $apisecretkey );
		$this->sessionHash = $sessionHash->Records['sessionHash'];

		$config = array(
			'login'    => $apikey,
			'password' => $apisecretkey,
			'trace'    => true
		);

		$this->client = new SoapClient( ATKP_Belboon_API_WSDL, $config );
	}

	private function get_feeds( $programId ) {

		$feeds = $this->helper->getFeeds( $this->sessionHash );

		$filter_feeds = array();
		foreach ( $feeds->Records as $feed ) {

			//um auf die programid zu kommen extrahieren wir jetzt die id aus der logourl (http://ui.belboon.com/images/logos/100/logo_14772.gif)
			//was für eine scheiß aktion wegen belboon
			$url = $feed['logo_url'];

			$pos_logo_prefix     = strpos( $url, 'logo_' );
			$belongs_to_merchant = substr( $url, $pos_logo_prefix + 5 ); //cut it
			$belongs_to_merchant = str_replace( '.gif', '', $belongs_to_merchant ); //replace .gif

			if ( $belongs_to_merchant == $programId ) {
				array_push( $filter_feeds, intval( $feed['id'] ) );
				break;
			}
		}

		return $filter_feeds;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$filter_feeds = $this->get_feeds( $this->programid );

		$products = new atkp_search_resp();

		$maxCount = 10;

        $aConfig = array( 'limit' => $maxCount, 'offset' => $maxCount * $pagination, 'feeds' => $filter_feeds );
        try {
            switch ( $searchType ) {
                case 'asin':
                    $result = $this->helper->getProductById( $this->sessionHash, $keyword );
                    break;
                case 'ean':
                    $result = $this->helper->searchProductsByEan( $this->sessionHash, $keyword, $aConfig );
                    break;
                default:
                    $result = $this->helper->searchProducts( $this->sessionHash, $keyword, $aConfig );
                    break;
            }
        } catch (Exception $e) {
            return $products;
        }

        $products->total = intval($result->NumRecordsTotal);
		$products->currentpage = intval($pagination);
		$products->pagecount = ceil(floatval($result->NumRecordsTotal) / floatval($maxCount));

        if ( isset( $result->Records ) ) {
            foreach ( $result->Records as $result ) {
                $product = array();

                $imageurl = isset( $result['imagesmallurl'] ) ? $result['imagesmallurl'] : '';
                if ( $imageurl == '' ) {
                    $imageurl = isset( $result['imagemediumurl'] ) ? $result['imagemediumurl'] : '';
                }
                if ( $imageurl == '' ) {
                    $imageurl = isset( $result['imagebigurl'] ) ? $result['imagebigurl'] : '';
                }

                $product['imageurl']   = $this->checkimageurl( $imageurl );
                $product['asin']       = $result['belboon_productnumber'];
                $product['producturl'] = ATKPTools::check_sslurl( $result['deeplinkurl'] );
                $product['title']      = $result['productname'];
                $product['ean']        = $result['ean'];

                $product['listprice'] = $result['oldprice'];
                $product['saleprice'] = $result['currentprice'];

                $product['description'] = strlen( $result['productdescriptionshort'] ) > 350 ? substr( $result['productdescriptionshort'], 0, 350 ) : $result['productdescriptionshort'];


                if ( $result['belboon_productnumber'] != '' ) {
                    array_push( $products->products, $product );
                }
            }
        }



		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product belboon ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product belboon ***' );
		}


		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$myproduct->features    = $result['productdescriptionshort'];
		$myproduct->description = $result['productdescriptionlong'];
		$myproduct->title       = $result['productname'];
		$myproduct->asin        = $result['belboon_productnumber'];

		$myproduct->mpn = $result['productnumber'];

		if ( isset( $result['imagesmallurl'] ) ) {
			$myproduct->smallimageurl = urldecode( $this->checkimageurl( $result['imagesmallurl'] ) );
		}
		if ( isset( $result['imagemediumurl'] ) ) {
			$myproduct->mediumimageurl = urldecode( $this->checkimageurl( $result['imagemediumurl'] ) );
		}
		if ( isset( $result['imagebigurl'] ) ) {
			$myproduct->largeimageurl = urldecode( $this->checkimageurl( $result['imagebigurl'] ) );
		}

		$myproduct->producturl = ATKPTools::check_sslurl( urldecode( $result['deeplinkurl'] ) );

		$myproduct->listprice      = $result['oldprice'];
		$myproduct->listpricefloat = $this->price_to_float( $result['oldprice'] );

		$myproduct->saleprice      = $result['currentprice'];
		$myproduct->salepricefloat = $this->price_to_float( $result['currentprice'] );


		$myproduct->shipping      = $result['shipping'];
		$myproduct->shippingfloat = $this->price_to_float( $result['shipping'] );

		$myproduct->availability = $result['availability'];

		$myproduct->productgroup = $result['productcategory'];
		$myproduct->ean          = $result['ean'];
		$myproduct->manufacturer = $result['manufacturername'];
		$myproduct->brand        = $result['brandname'];


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption'    => __( 'All categories', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'Price-Ascending'  => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
				'Price-Descending' => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
				'Title-Ascending'  => __( 'Title ascending', ATKP_PLUGIN_PREFIX ),
				'Title-Descending' => __( 'Title descending', ATKP_PLUGIN_PREFIX ),
			)
		);


		$results = $this->helper->getCategories( $this->sessionHash );


		foreach ( $results->Records as $result ) {

			$departments[ $result['id'] ] = array(
				'caption'    => html_entity_decode( $result['name'] ),
				'sortvalues' => array(
					'Price-Ascending'  => __( 'Price-Ascending', ATKP_PLUGIN_PREFIX ),
					'Price-Descending' => __( 'Price-Descending', ATKP_PLUGIN_PREFIX ),
					'Title-Ascending'  => __( 'Title-Ascending', ATKP_PLUGIN_PREFIX ),
					'Title-Descending' => __( 'Title-Descending', ATKP_PLUGIN_PREFIX ),
				)
			);
		}


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'sort'       => __( 'Sort by', ATKP_PLUGIN_PREFIX ),
			'sort_order' => __( 'Sort Order', ATKP_PLUGIN_PREFIX ),

			'price_max' => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'price_min' => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {
			try {
				switch ( $id_type ) {
					case 'ARTICLENUMBER':
					case 'ASIN':
						$result = $this->helper->getProductById( $this->sessionHash, $asin );
						break;
					case 'EAN':
						$filter_feeds = $this->get_feeds( $this->programid );
						$aConfig      = array( 'limit' => 2, 'feeds' => $filter_feeds );
						$result       = $this->helper->searchProductsByEan( $this->sessionHash, $asin, $aConfig );
						break;
					case 'TITLE':
						$filter_feeds = $this->get_feeds( $this->programid );
						$aConfig      = array( 'limit' => 2, 'feeds' => $filter_feeds );
						$result       = $this->helper->searchProducts( $this->sessionHash, $asin, $aConfig );
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( SoapFault $e ) {
				$titlecheck = $e->getMessage();
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}


			$productfound = false;

			if ( empty( $titlecheck ) && isset( $result->Records ) ) {
				foreach ( $result->Records as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );


		}


		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortByOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		$minPrice = '0';
		$maxPrice = '0';

		$sortBy    = '';
		$sortOrder = '';

		if ( $sortByOrder != '' ) {
			switch ( $sortByOrder ) {
				case 'Price-Ascending':
					$sortBy    = 'currentprice';
					$sortOrder = 'ASC';
					break;
				case 'Price-Descending':
					$sortBy    = 'currentprice';
					$sortOrder = 'DESC';
					break;
				case 'Title-Ascending':
					$sortBy    = 'productname';
					$sortOrder = 'ASC';
					break;
				case 'Title-Descending':
					$sortBy    = 'productname';
					$sortOrder = 'DESC';
					break;
			}

			//TODO: sortierung übernhemen
		}


		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
				case 'sort':
					$sortBy = $value;
					break;
				case 'sort_order':
					$sortOrder = $value;
					break;
				case 'price_min':
					$minPrice = $value;
					break;
				case 'price_max':
					$maxPrice = $value;
					break;
			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':

				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$filter_feeds = $this->get_feeds( $this->programid );

		if ( $minPrice != 0 ) {
			$aConfig['price_min'] = $minPrice;
		}
		if ( $maxPrice != 0 ) {
			$aConfig['price_max'] = $maxPrice;
		}
		if ( $nodeid != '' ) {
			$aConfig['categories'] = array( intval( $nodeid ) );
		}
		if ( $sortBy != '' ) {
			$aConfig['sort'] = array( $sortBy => $sortOrder );
		}

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {

		    $aConfig = array( 'limit' => $itemsperpage, 'offset' => $itemsperpage * $x, 'feeds' => $filter_feeds );
            $result2 = $this->helper->searchProducts( $this->sessionHash, $keyword, $aConfig );

            $results =  isset( $result2->Records ) ?   $result2->Records  : array();

            foreach ( $results as $result ) {
				array_push( $products, $this->fill_product( $result ) );

				if(count($products) >= $maxCount)
					break;
			}

			if(count($results) == 0 || count($products) >= $maxCount)
				break;
        }


		$mylist->products = $products;


		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}