<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! defined( 'ATKP_VERSION_CSV' ) ) {
	define( 'ATKP_VERSION_CSV', 4 );
}

class atkp_shop_provider_csv extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_maxproductcount() {
		return 100;
	}

	public function get_caption() {
		return __( 'CSV API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	function get_table_fields() {
		$fields = array();

		$fields['ProductNumber']        = __( 'Number', ATKP_PLUGIN_PREFIX ) . '*';
		$fields['ProductTitle']         = __( 'Title', ATKP_PLUGIN_PREFIX ) . '*';
		$fields['ProductEAN']           = __( 'EAN', ATKP_PLUGIN_PREFIX );
		$fields['ProductISBN']          = __( 'ISBN', ATKP_PLUGIN_PREFIX );
		$fields['ProductMPN']           = __( 'MPN', ATKP_PLUGIN_PREFIX );
		$fields['ProductGroup']         = __( 'Product group', ATKP_PLUGIN_PREFIX );
		$fields['ProductDescription']   = __( 'Description', ATKP_PLUGIN_PREFIX );
		$fields['ProductFeatures']      = __( 'Features', ATKP_PLUGIN_PREFIX );
		$fields['ProductPrice']         = __( 'Price', ATKP_PLUGIN_PREFIX );
		$fields['ProductLink']          = __( 'Product url', ATKP_PLUGIN_PREFIX );
		$fields['ProductSmallImage']    = __( 'Image small URL', ATKP_PLUGIN_PREFIX );
		$fields['ProductImage']         = __( 'Image large url', ATKP_PLUGIN_PREFIX );
		$fields['ProductAvailability']  = __( 'Availability', ATKP_PLUGIN_PREFIX );
		$fields['ProductShippingCosts'] = __( 'Shipping costs', ATKP_PLUGIN_PREFIX );
		$fields['ProductManufacturer']  = __( 'Manufacturer', ATKP_PLUGIN_PREFIX );
		$fields['ProductBrand']         = __( 'Brand', ATKP_PLUGIN_PREFIX );
		$fields['ProductListPrice']     = __( 'List price', ATKP_PLUGIN_PREFIX );


		//TODO: implement custom fields
		$fields['ProductText1'] = __( 'Custom text 1', ATKP_PLUGIN_PREFIX );
		$fields['ProductText2'] = __( 'Custom text 2', ATKP_PLUGIN_PREFIX );
		$fields['ProductText3'] = __( 'Custom text 3', ATKP_PLUGIN_PREFIX );
		$fields['ProductText4'] = __( 'Custom text 4', ATKP_PLUGIN_PREFIX );

		return $fields;
	}

	function get_csv_tablename() {
		global $wpdb;

		return strtolower( $wpdb->prefix . ATKP_PLUGIN_PREFIX . '_productdata' );;
	}

	function get_db_filesize() {
	    try {
		    global $wpdb;
		    $dbname = $wpdb->dbname;
		    $sql    = "SELECT
                    ROUND(SUM(data_length + index_length) / 1024 / 1024, 1) AS 'dbsize_mb'
                FROM
                    information_schema.tables
                WHERE
                    table_schema = '$dbname'
                GROUP BY
                    table_schema;";

		    $result = $wpdb->get_results( $sql );

		    if ( count( $result ) > 0 ) {
			    return $result[0]->dbsize_mb;
		    }


		    return 0;
	    } catch (Exception $e)
        {
            return 0;
        }
    }

	public function exists_table() {
		global $wpdb;
		$tablename = $this->get_csv_tablename();
		$sql = "SHOW TABLES LIKE '".$tablename."'";

		$result = $wpdb->get_results( $sql );
		return array(count($result) > 0,  $tablename);
    }

	function check_table_structure() {
		global $wpdb;

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' ); //required for dbDelta

		$current_version_db = atkp_options::$loader->get_version_csv();
		//$current_version_db = 0;
		$table_name = $this->get_csv_tablename();

		//older or not even set
		if ( $current_version_db < ATKP_VERSION_CSV || $current_version_db == false ) {
			$sql = "CREATE TABLE $table_name (
    				`ShopId` bigint (50) NOT NULL,
    				`ProductNumber` varchar( 150 ) NOT NULL,
    				`ProductTitle` varchar(700) NULL ,
    				`ProductEAN` varchar( 50 ) NULL ,
    				`ProductISBN` varchar( 20 ) NULL ,
    				`ProductDescription` text NULL ,
    				`ProductFeatures` text NULL ,
    				`ProductPrice` varchar( 60 ) NULL ,
    				`ProductLink` text NULL ,
    				`ProductImage` varchar(700) NULL ,
    				`ProductSmallImage` varchar(700) NULL ,
    				`ProductAvailability` varchar( 100 ) NULL ,
    				`ProductShippingCosts` varchar( 100 ) NULL ,
    				`ProductManufacturer` varchar( 150 ) NULL ,
    				`ProductBrand` varchar( 150 ) NULL ,
    				`ProductText1` text NULL ,
    				`ProductText2` text NULL ,
    				`ProductText3` text NULL ,
    				`ProductText4` text NULL ,
    				`LineNumber` int (50) NULL ,
    				`ImportDate` datetime NULL ,
    				`ProductListPrice` varchar( 60 ) NULL ,
    				`ProductMPN` varchar( 250 ) NULL ,
    				`ProductGroup` varchar( 350 ) NULL ,
    				
    				PRIMARY KEY (`ShopId`,`ProductNumber`)
    				) ENGINE = MYISAM DEFAULT CHARSET = utf8";

			dbDelta( $sql );

			update_option( ATKP_PLUGIN_PREFIX . '_version_csv', ATKP_VERSION_CSV );
		}
	}

	private function get_settings( $post_id ) {

		$separator     = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_delimiter' );
		$endoflineflag = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_endofline' );
		$encapsed      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_textfield' );
		$encoding      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_encoding' );
		$compression   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_compression' );

		$usestream = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream' );

		$titlekeywords = null;


		$searchttitlefilter = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_titelfilter' );


		if ( $searchttitlefilter != null ) {
			$titlekeywords = array_map( 'strtolower', explode( "\n", $searchttitlefilter ) );
		}

		switch ( $separator ) {
			default:
			case 'tab':
				$separator = "\t";
				break;

			case 'comma':
				$separator = ",";
				break;

			case 'semicolon':
				$separator = ";";
				break;

			case 'pipe':
				$separator = "|";
				break;

			case 'carret':
				$separator = "^";
				break;


		}

		switch ( $endoflineflag ) {
			default:
			case 'crlf':
				$endoflineflag_chars = "\r\n";
				break;

			case 'lf':
				$endoflineflag_chars = "\n";
				break;
		}

		switch ( $encapsed ) {

			case 'singlequote':
				$encapsed = "'";
				break;
			default:
			case 'doublequote':
				$encapsed = '"';
				break;
		}

		switch ( $usestream ) {

			case 'download':
				$usestream = false;
				break;
			default:
			case 'filestream':
				if ( $this->is_file_stream_supported() ) {
					$usestream = true;
				} else {
					$usestream = false;
				}
				break;
		}

		return ( array(
			'separator'     => $separator,
			'encapsed'      => $encapsed,
			'endofline'     => $endoflineflag_chars,
			'encoding'      => $encoding,
			'compression'   => $compression,
			'keywordfilter' => $titlekeywords,
			'usestream'     => $usestream
		) );
	}

	//opens a file via wp_remote_get ... very memory consuming and gzip is not supported
	function get_csv_content_get( $url, $settings ) {

		$result = wp_remote_get( $url, array( 'timeout' => 120, 'httpversion' => '1.1' ) );

		if ( is_wp_error( $result ) ) {
			throw new exception( $result->get_error_message() );
		}

		$csv = explode( $settings['endofline'], $result['body'] );

		unset( $result );

		return $csv;

	}

	//this saves a lot of resources if we do it for each line during processing instead of the whole array
	function helper_onthefly_extraction( $csv_line, $settings ) {

		$entry = str_getcsv( $csv_line, $settings['separator'], $settings['encapsed'], '\\' );

		return $entry;

	}


	public function check_configuration( $post_id ) {
		try {
			$this->check_table_structure();

			$csvurl              = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_url' );
			$firstrowcolumheader = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' );

			$usestream = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream' );

			if(!$this->exists_table()[0])
			    return 'sql table does not exists: '. $this->get_csv_tablename();

			$message = '';

			$settings = $this->get_settings( $post_id );

			$columns = $this->get_file_columns( $csvurl, $settings );

			if ( ! $firstrowcolumheader ) {
				//fix column names for reading

				foreach ( $columns as $i => $caption ) {
					$columns[ $i ] = __( 'Column ', ATKP_PLUGIN_PREFIX ) . ( $i + 1 );
				}
			}

			ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_columns', $columns );

			$columns = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_columns' );

			$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );
			if ( $subshops == null ) {
				$subshops = array();

				//add subshop for amazon
				$subshop         = new subshop();
				$subshop->title  = __( 'CSV File', ATKP_PLUGIN_PREFIX );
				$subshop->shopid = $post_id;

				$subshop->enabled = true;

				array_push( $subshops, $subshop );

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );
			}

			if ( $csvurl == '' ) {
				$message = "Url is empty";
			} else if ( ! is_array( $columns ) || count( $columns ) <= 1 ) {
				$message = "Columns not found";
			} else {
				$columnconfig = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );

				if ( isset( $columnconfig ) && $columnconfig != '' && is_array( $columnconfig ) ) {
					foreach ( $columnconfig as $config ) {
						if ( $config->name == 'ProductNumber' || $config->name == 'ProductName' ) {
							$id = $config->field !== '' ? intval( $config->field ) : - 1;
							if ( $id == - 1 ) {
								$message = $config->name . ' is required';
							}
							break;
						}

					}
				}
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	private function encode_array( $line, $settings ) {
		if ( $settings['encoding'] == '' || $settings['encoding'] == 'UTF-8' ) {
			return $line;
		} else {
			//'UTF-8, ISO-8859-1'
			$newline = array();

			foreach ( $line as $col ) {
				array_push( $newline, mb_convert_encoding( $col, 'UTF-8', mb_detect_encoding( $col, $settings['encoding'], true ) ) );
			}

			return $newline;
		}
	}

	function get_fp( $url, $settings ) {

		$compression = isset( $settings['compression'] ) ? $settings['compression'] : 'none';

		switch ( $compression ) {
			default:
				$opts = array(
					'http' => array( 'method' => "GET" )
				);
				break;
			case 'gzip':
				$opts = array(
					'http' => array(
						'method' => "GET",
						'header' => "Accept-Encoding: gzip,deflate,sdchrn" .
						            "Accept-Charset:UTF-8,*;q=0.5rn"
					)
				);
				break;
		}


		$context = stream_context_create( $opts );

		switch ( $compression ) {
			default:
				$fp = fopen( $url, 'r', false, $context );
				break;
			case 'gzip':
				if ( ATKPTools::startsWith( $url, 'https' ) ) {
					$url = str_replace( 'https://', '', $url );
					$url = str_replace( '//', '/%2C/', $url );
					$url = 'https://' . $url;
				}

				$fp = gzopen( $url, 'r', false );
				break;
		}

		return $fp;
	}

	public function get_file_columns( $url, $settings ) {

		//open first line via stream
		if ( $settings['usestream'] ) {//$this->is_file_stream_supported()

			$fp = $this->get_fp( $url, $settings );

			$y = 0;

			while ( $line = fgetcsv( $fp, 0, $settings['separator'], $settings['encapsed'] ) ) {
				return $this->encode_array( $line, $settings );
			}

			fclose( $fp );

		} else {
			//open via get - full csv in memory
			$csv = $this->get_csv_content_get( $url, $settings );

			//wenn das csv nur eine zeile hat, dann passt der linebreak nicht
			if ( count( $csv ) <= 1 ) {
				return strlen( $csv[0] ) > 500 ? substr( $csv[0], 0, 500 ) : $csv[0];
			} else {
				foreach ( $csv as $i => $csv_line ) {
					/* important: we use the on the fly extraction because it saves a LOT of memory during processing */
					$entry = $this->helper_onthefly_extraction( $csv_line, $settings );

					return $this->encode_array( $entry, $settings );
				}
			}

			unset( $csv );
		}

		return null;
	}

	private function is_file_stream_supported() {

		return ini_get( 'allow_url_fopen' ) == 'on' || ini_get( 'allow_url_fopen' ) == 'On' || ini_get( 'allow_url_fopen' ) == '1';
	}

	public function count_imported_rows( $shopid ) {
		global $wpdb;
		$table_name = $this->get_csv_tablename();

		$entry_count = $wpdb->get_var( $wpdb->prepare( "SELECT count(*) FROM $table_name WHERE shopid = '%d'", $shopid ) );

		return $entry_count;
	}

	public function get_lastimport_date( $shopid ) {
		global $wpdb;
		$table_name = $this->get_csv_tablename();
		//max == letztes ältestes importdatum
		$importdate = $wpdb->get_var( $wpdb->prepare( "SELECT max(ImportDate) FROM $table_name WHERE shopid = '%d'", $shopid ) );

		return strtotime( $importdate );
	}

	public function import_csv( $shopid, $iscron, $isresume = false, $update_lastactivity = null, $activityname = null ) {
		global $wpdb;

		$table_name = $this->get_csv_tablename();
		$settings   = $this->get_settings( $shopid );
		$url        = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_url' );

		if ( $url == '' || $url == null ) {
			return;
		}

		$columnconfig        = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );
		$firstrowcolumheader = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' );
		$entry_count         = 0;
		$insert_count        = 0;

		if ( $isresume ) {
			//used for resuming
			$entry_count = $wpdb->get_var( $wpdb->prepare( "SELECT max(linenumber) FROM $table_name WHERE shopid = '%d'", $shopid ) );
		} else {
			//clear existing data
			$wpdb->delete( $table_name, array( 'shopid' => $shopid ), array( '%d' ) );
		}

		try {
			add_filter( 'query', array( $this, 'modifyInsertQuery' ), 10 );

			//approach via stream, fopen ON
			if ( $settings['usestream'] ) {

				$fp = $this->get_fp( $url, $settings );

				$y = 1;

				while ( $line = fgetcsv( $fp, 0, $settings['separator'], $settings['encapsed'] ) ) {
					if ( $firstrowcolumheader && $y == 1 ) {
						//first line is columnheader
					} else if ( $isresume && $y < $entry_count ) {
						//line already imported
					} else {
						//resume marker, save position each 1000 entries to have a resume mark
						if ( $y % 5000 == 0 && $update_lastactivity != null ) {
							call_user_func( $update_lastactivity, $activityname );
						}

						if ( isset( $settings['keywordfilter'] ) && $settings['keywordfilter'] != '' ) {
							if ( ! $this->str_contains( $line, $settings['keywordfilter'], false ) ) {
								continue;
							}
						}

						if ( $this->import_csv_row( $shopid, $columnconfig, $this->encode_array( $line, $settings ), $y ) ) {
							$insert_count ++;
						}
					}

					//unset, important
					unset( $line );
					$y ++;
				}

				fclose( $fp );

			} else {
				//classical approach via get, fopen OFF
				$csv = $this->get_csv_content_get( $url, $settings );

				foreach ( $csv as $i => $csv_line ) {
					$y = $i + 1;
					//check if resume is required
					//if we have to resume rapidly find the position to continue from

					if ( $firstrowcolumheader && $y == 1 ) {
						//first line is columnheader
					} else if ( $isresume && $y < $entry_count ) {
						//line already imported
					} else {

						//each 1000 entries, make an resume marker, this is reset to false if we reach the end of the script
						if ( $i % 5000 == 0 && $update_lastactivity != null ) {
							call_user_func( $update_lastactivity, $activityname );
						}


						/* important: we use the on the fly extraction because it saves a LOT of memory during processing */
						$entry = $this->helper_onthefly_extraction( $csv_line, $settings );

						//last entry has size of 1 ... we dont want to pass it
						if ( sizeof( $entry ) == 1 ) {
							continue;
						}

						if ( isset( $settings['keywordfilter'] ) && $settings['keywordfilter'] != '' ) {
							if ( ! $this->str_contains( $entry, $settings['keywordfilter'], false ) ) {
								continue;
							}
						}

						if ( $this->import_csv_row( $shopid, $columnconfig, $this->encode_array( $entry, $settings ), $y ) ) {
							$insert_count ++;
						}
					}
				}

				unset( $csv );
			}
		} finally {
			remove_filter('query', array($this, 'modifyInsertQuery'), 10);
        }
	}

	public function modifyInsertQuery( $query ){
		$count 	= 0;
		$query 	= preg_replace('/^(INSERT INTO)/i', 'INSERT IGNORE INTO', $query, 1 , $count );

		return $query;
	}

	private function str_contains( $strarray, $array, $caseSensitive = true ) {
		$string = implode( ' ', $strarray );

		$stripedString = $caseSensitive ? str_replace( $array, '', $string ) : str_ireplace( $array, '', $string );

		return strlen( $stripedString ) !== strlen( $string );
	}

	public function import_csv_row( $shopid, $columnconfig, $datarow, $linenumber ) {
		global $wpdb;

		$table_name = $this->get_csv_tablename();

		$data = array(
			'ShopId'               => $shopid,
			'ProductNumber'        => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductNumber' ),
			'ProductTitle'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductTitle' ),
			'ProductEAN'           => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductEAN' ),
			'ProductISBN'          => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductISBN' ),
			'ProductDescription'   => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductDescription' ),
			'ProductFeatures'      => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductFeatures' ),
			'ProductPrice'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductPrice' ),
			'ProductListPrice'     => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductListPrice' ),
			'ProductLink'          => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductLink' ),
			'ProductImage'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductImage' ),
			'ProductSmallImage'    => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductSmallImage' ),
			'ProductAvailability'  => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductAvailability' ),
			'ProductShippingCosts' => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductShippingCosts' ),
			'ProductManufacturer'  => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductManufacturer' ),
			'ProductBrand'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductBrand' ),
			'ProductText1'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductText1' ),
			'ProductText2'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductText2' ),
			'ProductText3'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductText3' ),
			'ProductText4'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductText4' ),
			'ProductMPN'           => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductMPN' ),
			'ProductGroup'         => columnconfig::get_csv_value( $columnconfig, $datarow, 'ProductGroup' ),
			'LineNumber'           => $linenumber,
			'ImportDate'           => date_i18n( 'Y-m-d H:i:s', ATKPTools::get_current_utc() ),
		);

		$data = apply_filters( 'atkp_modify_csv_before_db_write', $data );

		//insert oder update row
		$updated = false;
		$updated = $wpdb->insert(
			$table_name,
			$data
		);

		if ( ! $updated && ATKPLog::$logenabled ) {
			ATKPLog::LogError( 'csv datarow not saved: ' . serialize( $data ) );
		}

		unset( $data );

		$wpdb->flush();

		return $updated;
	}

	public function set_configuration( $post_id ) {
		//var_dump($_POST);exit;
		$selectedcolumns   = array();
		$delimiter         = '';
		$firstlineheader   = false;
		$endofline         = '';
		$textfield         = '';
		$compression       = '';
		$searchtitelfilter = '';
		$usestream         = $this->is_file_stream_supported();

		$predefined = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_predefined', 'string' );

		if ( $predefined != null && $predefined != '' ) {
			switch ( $predefined ) {
				case 'adcell':
					$selectedcolumns = unserialize( 'a:14:{i:0;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:7;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:3;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:4;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:12;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:11;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:22;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:14;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:9;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'semicolon';
					$firstlineheader = true;
					$endofline       = 'lf';
					$textfield       = 'doublequote';
					break;
				case 'webgains':
					$selectedcolumns = unserialize( 'a:14:{i:0;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:11;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:17;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:7;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:15;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:24;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:21;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:22;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'comma';
					$firstlineheader = true;
					$endofline       = 'clrf';
					$textfield       = 'doublequote';
					break;

				case 'awin':
					$selectedcolumns = unserialize( 'a:18:{i:0;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:5;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:14;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:12;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:15;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}i:14;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText1";s:8:"fallback";s:0:"";}}i:15;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText2";s:8:"fallback";s:0:"";}}i:16;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText3";s:8:"fallback";s:0:"";}}i:17;O:12:"columnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText4";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'comma';
					$firstlineheader = true;
					$endofline       = 'clrf';
					$textfield       = 'doublequote';
					$compression     = 'gzip';
					break;
				default:
					throw new exception( 'unknown predefined: ' . $predefined );
			}
			//adcell


		} else {
			$delimiter       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_delimiter', 'string' );
			$firstlineheader = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_firstlineheader', 'bool' );
			$endofline       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_endofline', 'string' );
			$textfield       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_textfield', 'string' );
			$compression     = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_compression', 'string' );

			$usestream = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_usestream', 'string' );


			$searchtitelfilter = implode( "\n", array_map( 'sanitize_text_field', explode( "\n", ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_titelfilter', 'multistring' ) ) ) );


			$fields = $this->get_table_fields();

			$id = 0;
			foreach ( $fields as $field => $caption ) {
				//proforma info: feldname
				$fieldname    = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_column_' . $field, 'string' );
				$toolkitfield = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_atfield_' . $field, 'string' );

				$prefix   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_prefix_' . $field, 'string' );
				$field2   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_field_' . $field, 'int' );
				$suffix   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_suffix_' . $field, 'string' );
				$fallback = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_fallback_' . $field, 'string' );

				$config = new columnconfig();

				$config->prefix       = $prefix;
				$config->field        = $field2;
				$config->suffix       = $suffix;
				$config->toolkitfield = $toolkitfield;
				$config->name         = $fieldname;
				$config->fallback     = $fallback;

				array_push( $selectedcolumns, $config );
			}
		}


		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_titelfilter', $searchtitelfilter );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns', $selectedcolumns );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_encoding', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_encoding', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_url', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_url', 'allhtml' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_delimiter', $delimiter );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader', $firstlineheader );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_endofline', $endofline );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_textfield', $textfield );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_compression', $compression );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream', $usestream );

		$importcsv = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_csv_importnow', 'bool' );

		if ( $importcsv ) {
			$csvprovider = new atkp_shop_provider_csv();
			$csvprovider->import_csv( $post_id, false );

			unset( $csvprovider );
		}
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );


		$csvurl          = '';
		$apisecretkey    = '';
		$customlogo      = '';
		$customlogosmall = '';
		$subshops        = null;

		if ( $webservice == '7' ) {
			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );
		}
		?>
        <tr valign="top">
            <th scope="row">

            </th>
            <td>


				<?php


                if ( $this->is_file_stream_supported() ) {
					echo '<span>' . __( 'The PHP setting "allow_url_fopen" is enabled.', ATKP_PLUGIN_PREFIX ) . '</span>';
				} else {
					echo '<span>' . __( 'The PHP setting "allow_url_fopen" should be enabled. This feature is recommended for reading large files.', ATKP_PLUGIN_PREFIX ) . '</span>';
				}

				?>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'CSV-URL', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'csv-import' ); ?>
            </th>
            <td>
                <input style="width:40%" type="url" id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_url' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_url' ?>"
                       value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_url' ) ); ?>">
                <label for="">
                </label>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'CSV-Encoding', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:20%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_encoding' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_encoding' ?>"
                       value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_encoding' ) ); ?>">
                <label for="">
                </label>
            </td>
        </tr>

		<?php if ( $webservice == '' ) { ?>

            <tr valign="top">
                <th scope="row">
                    <label for="">
						<?php _e( 'Template', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>

                    <select style="width:40%" name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_predefined' ?>"
                            id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_predefined' ?>">
						<?php

						$durations = array(
							'adcell'   => __( 'Adcell', ATKP_PLUGIN_PREFIX ),
							'webgains' => __( 'Webgains', ATKP_PLUGIN_PREFIX ),
							'awin'     => __( 'AWIN', ATKP_PLUGIN_PREFIX ),
							''         => __( 'Manual', ATKP_PLUGIN_PREFIX ),
						);

						foreach ( $durations as $value => $name ) {

							echo '<option value="' . $value . '">' . esc_attr( $name ) . '</option>';
						} ?>
                    </select>


                    <script type="text/javascript">
                        var $j = jQuery.noConflict();
                        /*
												 * Attaches the image uploader to the input field
												 */
                        $j(document).ready(function ($) {


                            $j('#<?php echo ATKP_SHOP_POSTTYPE . '_csv_predefined' ?>').change(function () {

                                if ($j('#<?php echo ATKP_SHOP_POSTTYPE . '_csv_predefined' ?>').val() == '')
                                    $j('.atkp-manualrow').show();
                                else
                                    $j('.atkp-manualrow').hide();
                            });


                            $j('#<?php echo ATKP_SHOP_POSTTYPE . '_csv_predefined' ?>').trigger("change");


                        });

                    </script>
                </td>
            </tr>


		<?php } ?>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Column delimiter', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_delimiter' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_delimiter' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_delimiter' ?>">
					<?php

					$durations = array(
						'tab'       => __( 'Tabstopp', ATKP_PLUGIN_PREFIX ),
						'pipe'      => __( 'Pipe (|)', ATKP_PLUGIN_PREFIX ),
						'carret'    => __( 'Carret (^)', ATKP_PLUGIN_PREFIX ),
						'comma'     => __( 'Comma (,)', ATKP_PLUGIN_PREFIX ),
						'semicolon' => __( 'Semicolon (;)', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>


            </td>
        </tr>


        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_csv_usestream' ?>">
					<?php _e( 'Use file stream', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_usestream' ); ?>


                <select name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_usestream' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_usestream' ?>">
					<?php

					$durations = array(
						''           => __( 'Auto', ATKP_PLUGIN_PREFIX ),
						'filestream' => __( 'Filestream', ATKP_PLUGIN_PREFIX ),
						'download'   => __( 'Download', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' ), true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' ?>">
					<?php _e( 'First line is header', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Compression', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php

				if ( $this->is_file_stream_supported() ) {

					$selectedcompression = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_compression', 'none' ); ?>

                    <select selected-id="<?php echo $selectedcompression ?>"
                            name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_compression' ?>"
                            id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_compression' ?>">
						<?php

						$durations = array(
							'none' => __( 'None', ATKP_PLUGIN_PREFIX ),
							'gzip' => __( 'gzip compression', ATKP_PLUGIN_PREFIX ),
						);

						foreach ( $durations as $value => $name ) {
							if ( $value == $selectedcompression ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							$item_translated = '';

							echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
						}

						?>
                    </select>

				<?php } else {
					_e( 'Not supported', ATKP_PLUGIN_PREFIX );
				} ?>
            </td>
        </tr>


        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'End of line', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_endofline', 'clrf' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_endofline' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_endofline' ?>">
					<?php

					$durations = array(
						'clrf' => __( 'Carriage return/line feed (CR/LF)', ATKP_PLUGIN_PREFIX ),
						'lf'   => __( 'Line feed (LF)', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Character string', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_textfield', 'doublequote' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_textfield' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_textfield' ?>">
					<?php

					$durations = array(
						'doublequote' => __( 'Double quotes', ATKP_PLUGIN_PREFIX ),
						'singlequote' => __( 'Single quotes', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">

            </th>
            <td>
				<?php
				$columns         = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_columns' );
				$selectedcolumns = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );

				if ( $columns != '' ) {
					if ( ! is_array( $columns ) || count( $columns ) <= 1 ) { ?>
                        <div style="white-space:nowrap;    overflow-x: scroll;border:dotted 1px;width:600px">
                            <div style="display:inline-block">


								<?php

								echo var_dump( $columns );

								?>

                            </div>
                        </div>
					<?php } else { ?>

                        <table style="width:100%">
							<?php

							$atfields = array();
							//freitext durch eigene felder combo

							if ( ATKP_PLUGIN_VERSION >= 30 ) {
								require_once ATKP_PLUGIN_DIR . '/includes/atkp_udfield.php';
								$newfields = atkp_udfield::load_fields();

								foreach ( $newfields as $field ) {
									$atfields[ $field->name ] = $field->caption == '' ? $field->name : $field->caption;
								}

								if ( atkp_options::$loader->get_fieldgroups_enabled() ) {

									$groups = ATKPTools::get_fieldgroups();

									foreach ( $groups as $group ) {
										$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

										if ( $fields != null ) {
											foreach ( $fields as $field ) {
												$atfields[ $field->name ] = $field->caption == '' ? $field->name : $field->caption;
											}
										}
									}
								}
							}


							$fields = $this->get_table_fields();
							$id     = 0;
							foreach ( $fields as $field => $caption ) {
								$savedconfig = null;
								if ( isset( $selectedcolumns ) && is_array( $selectedcolumns ) ) {
									foreach ( $selectedcolumns as $selcol ) {
										if ( $selcol->name == $field ) {
											$savedconfig = $selcol;
											break;
										}
									}
								} //var_dump($savedconfig);


								?>
                                <tr>
                                    <td style="padding: 0px 0px;">&nbsp;</td>
                                    <td style="padding: 0px 0px;vertical-align: middle;"> <?php

										if ( $field == 'ProductText1' || $field == 'ProductText2' || $field == 'ProductText3' || $field == 'ProductText4' ) {
											?>

                                            <select style="width:100%"
                                                    name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_atfield_' . $field ?>">
												<?php


												echo '<option value=""' . $sel . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
												foreach ( $atfields as $value => $name ) {
													if ( $savedconfig != null && $value == $savedconfig->toolkitfield ) {
														$sel = ' selected';
													} else {
														$sel = '';
													}

													$item_translated = '';

													echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
												} ?>
                                            </select>

											<?php
										} else {
											echo esc_html( $caption );
										} ?> </td>
                                    <td style="padding: 0px 0px;"> &nbsp;</td>
                                    <td style="padding: 0px 0px;">
                                        <input type="hidden" style="padding: 0px 0px;width:30px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_column_' . $field ?>"
                                               value="<?php echo $field ?>"/>
                                        <input type="text" placeholder="prefix"
                                               style="vertical-align: middle;width:40px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_prefix_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->prefix : '' ); ?>"/>
                                        <select <?php echo( $field == 'ProductNumber' || $field == 'ProductName' ? 'required' : '' ) ?>
                                                style="width:40%"
                                                name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_field_' . $field ?>">
											<?php
											$selectedsourceval = $savedconfig == null ? - 1 : $savedconfig->field;

											echo '<option value="-1">' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
											foreach ( $columns as $value => $name ) {
												if ( $value == $selectedsourceval ) {
													$sel = ' selected';
												} else {
													$sel = '';
												}

												$item_translated = '';

												echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
											} ?>
                                        </select>
                                        <input type="text" placeholder="suffix"
                                               style="vertical-align: middle;width:40px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_suffix_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->suffix : '' ); ?>"/>
                                        <input type="text" placeholder="fallback"
                                               style="vertical-align: middle;width:110px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_fallback_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->fallback : '' ); ?>"/>
                                    </td>
                                </tr>
							<?php } ?>
                        </table>
					<?php }
				} ?>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
                    <strong>
						<?php _e( 'Pre filter (one keyword per line)', ATKP_PLUGIN_PREFIX ) ?>:<br/>
                    </strong>
                </label>
            </th>
            <td>

				<?php

				$searchtitelfilter = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_titelfilter' );

				?>
                <textarea style="width:100%;height:100px" id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_titelfilter' ?>"
                          name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_titelfilter' ?>"><?php echo esc_textarea( $searchtitelfilter ); ?></textarea>

            </td>
        </tr>


		<?php if ( isset( $fields ) && count( $fields ) > 0 ) { ?>
            <tr valign="top">
                <th scope="row">

                </th>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_csv_importnow' ?>"
                           name="<?php echo ATKP_SHOP_POSTTYPE . '_csv_importnow' ?>" value="1">
                    <label for="<?php echo ATKP_SHOP_POSTTYPE . '_csv_importnow' ?>">
						<?php _e( 'Import CSV-files now', ATKP_PLUGIN_PREFIX ) ?>
                    </label><br/><br/>

					<?php
					$rows       = $this->count_imported_rows( $post->ID );
					$lastimport = $this->get_lastimport_date( $post->ID );

					echo sprintf( __( '%s lines imported. Last Import: %s', ATKP_PLUGIN_PREFIX ), $rows, ATKPTools::get_formatted_date( $lastimport ) . ' ' . ATKPTools::get_formatted_time( $lastimport ) );

					?>
                </td>
            </tr>


			<?php
		} ?>


		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {

		$shops = array();

		$subshop = new subshop();

		$subshop->title = __( 'CSV File', ATKP_PLUGIN_PREFIX );

		//TODO:Shoplogo
		$subshop->logourl      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_customlogo' );
		$subshop->smalllogourl = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_customlogosmall' );

		$subshop->shopid    = $post_id;
		$subshop->programid = '';

		$subshop->enabled = true;

		array_push( $shops, $subshop );

		return $shops;
	}

	private $shopid = null;

	private $column_config = null;

	public function checklogon( $shop ) {
		$this->check_table_structure();

		$this->shopid = $shop->settingid;

		$this->column_config = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );


	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {

		global $wpdb;

		$table_name = $this->get_csv_tablename();

		$products = new atkp_search_resp();
		$maxCount = 10;
		$offset   = $maxCount * ( $pagination - 1 );
		$total = 0;

		if ( $keyword == '' ) {
		    $total = $wpdb->get_results( $wpdb->prepare( "SELECT count(*) as cnt FROM $table_name WHERE shopid = %s", $this->shopid, $maxCount, $offset ), ARRAY_A );

			if(isset($total) && is_array($total))
				$total = intval($total[0]['cnt']);

			$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE shopid = %s LIMIT %d OFFSET %d	", $this->shopid, $maxCount, $offset ), ARRAY_A );
		} // specific search
		else {
			//$searchterm = '+'. $keyword .'+';

			switch ( $searchType ) {
				case 'asin':
					$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE ProductNumber = '%s' AND shopid = %s", $keyword, $this->shopid ), ARRAY_A );
					break;
				case 'ean':
					$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE ProductEAN = '%s' AND shopid = %s", $keyword, $this->shopid ), ARRAY_A );
					break;
				default:
					$searchlike = '%' . $wpdb->esc_like( $keyword ) . '%';
					$total = $wpdb->get_results( $wpdb->prepare( "SELECT count(*) as cnt FROM $table_name WHERE (ProductTitle like %s  or ProductEAN like %s or ProductManufacturer like %s) AND shopid = %s", $searchlike, $searchlike, $searchlike, $this->shopid ), ARRAY_A );

					if(isset($total) && is_array($total))
						$total = intval($total[0]['cnt']);

					$result     = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE (ProductTitle like %s  or ProductEAN like %s or ProductManufacturer like %s) AND shopid = %s LIMIT %d OFFSET %d	", $searchlike, $searchlike, $searchlike, $this->shopid, $maxCount, $offset ), ARRAY_A );
					break;
			}
		}

		$products->total = $total;
		$products->currentpage = $total > 0 ? $pagination : 0;
		$products->pagecount = ceil(floatval($total) / floatval($maxCount));

		//var_dump($result);exit;

		if ( $result ) {
			foreach ( $result as $row ) {

				$product = array();
				//info: je nach anbieter wird entweder small oder large zurückgeliefert?!

				$product['imageurl']   = isset( $row['ProductSmallImage'] ) && $row['ProductSmallImage'] != '' ? $row['ProductSmallImage'] : $row['ProductImage'];
				$product['asin']       = $row['ProductNumber'];
				$product['producturl'] = $row['ProductLink'];
				$product['title']      = $row['ProductTitle'];
				$product['ean']        = $row['ProductEAN'];


				$product['saleprice'] = $row['ProductPrice'];
				$product['listprice'] = $row['ProductListPrice'];

				$product['description'] = strlen( $row['ProductDescription'] ) > 350 ? substr( $row['ProductDescription'], 0, 350 ) : $row['ProductDescription'];

				array_push( $products->products, $product );
			}
		}


		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		//if($enable_ssl == null)
		//    $enable_ssl = $this->enable_ssl;

		//if($enable_ssl)
		//   $url = str_replace('http://', 'https://', $url);

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product csv ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product csv ***' );
		}

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$myproduct->features    = $result['ProductFeatures'];
		$myproduct->description = $result['ProductDescription'];

		$myproduct->title = $result['ProductTitle'];
		$myproduct->asin  = $result['ProductNumber'];

		$myproduct->smallimageurl = $result['ProductSmallImage'];
		$myproduct->largeimageurl = $result['ProductImage'];

		$myproduct->producturl   = $result['ProductLink'];
		$myproduct->addtocarturl = $result['ProductLink'];

		$myproduct->availability = $result['ProductAvailability'];

		$myproduct->saleprice      = $result['ProductPrice'];
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		$myproduct->listprice      = $result['ProductListPrice'];
		$myproduct->listpricefloat = $this->price_to_float( $myproduct->listprice );

		$myproduct->shipping = $result['ProductShippingCosts'];;
		$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );

		$myproduct->ean          = $result['ProductEAN'];
		$myproduct->isbn         = $result['ProductISBN'];
		$myproduct->manufacturer = $result['ProductManufacturer'];
		$myproduct->brand        = $result['ProductBrand'];
		$myproduct->mpn          = $result['ProductMPN'];
		$myproduct->productgroup = $result['ProductGroup'];


		//if($field == 'ProductText1' || $field == 'ProductText2'  || $field == 'ProductText3' || $field == 'ProductText4')

		if ( $this->column_config != null && is_array( $this->column_config ) ) {

			foreach ( $this->column_config as $column ) {
				//->toolkitfield
				if ( $column->name == 'ProductText1' ) {
					if ( $column->toolkitfield != '' ) {
						$myproduct->customfields[ $column->toolkitfield ] = $result['ProductText1'];
					}
				} else if ( $column->name == 'ProductText2' ) {
					if ( $column->toolkitfield != '' ) {
						$myproduct->customfields[ $column->toolkitfield ] = $result['ProductText2'];
					}
				} else if ( $column->name == 'ProductText3' ) {
					if ( $column->toolkitfield != '' ) {
						$myproduct->customfields[ $column->toolkitfield ] = $result['ProductText3'];
					}
				} else if ( $column->name == 'ProductText4' ) {
					if ( $column->toolkitfield != '' ) {
						$myproduct->customfields[ $column->toolkitfield ] = $result['ProductText4'];
					}
				}
			}
		}

		return $myproduct;

	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {

		$departments = array();

		$departments['AllCategories'] = array(
			'caption' => __( 'All categories', ATKP_PLUGIN_PREFIX )
		);


		return $departments;
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}


	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		global $wpdb;

		$table_name = $this->get_csv_tablename();

		foreach ( $asins as $asin ) {

			try {
				switch ( $id_type ) {
					case 'ARTICLENUMBER':
					case 'ASIN':
						$results = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE ProductNumber LIKE '%s' AND shopid = %s", $asin, $this->shopid ), ARRAY_A );
						break;
					case 'EAN':
						$results = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE ProductEAN LIKE '%s' AND shopid = %s", $asin, $this->shopid ), ARRAY_A );
						break;
					case 'TITLE':
						$results = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE ProductTitle LIKE '%s' AND shopid = %s", $asin, $this->shopid ), ARRAY_A );
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			$productfound = false;

			if ( empty( $titlecheck ) && $results && is_array( $results ) && count( $results ) > 0 ) {
				foreach ( $results as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found: ' . $asin : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}


		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':
				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		global $wpdb;

		$table_name = $this->get_csv_tablename();

		$results  = null;
		$products = array();

		if ( $keyword == '' ) {
			$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE shopid = %s LIMIT %d OFFSET %d	", $this->shopid, $maxCount, 0 ), ARRAY_A );
		} else {


			$searchlike = '%' . $wpdb->esc_like( $keyword ) . '%';
			$result     = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE (ProductTitle like %s  or ProductEAN like %s or ProductManufacturer like %s) AND shopid = %s LIMIT %d OFFSET %d	", $searchlike, $searchlike, $searchlike, $this->shopid, $maxCount, 0 ), ARRAY_A );

		}

		if ( $result ) {
			foreach ( $result as $row ) {
				array_push( $products, $this->fill_product( $row ) );
			}
		}

		$mylist->products = $products;

		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}

}

class columnconfig {
	public $data = array();

	function __construct() {
		$this->prefix       = '';
		$this->field        = '';
		$this->suffix       = '';
		$this->toolkitfield = '';
		$this->name         = '';
		$this->fallback     = '';
	}

	public static function get_csv_value( $columnconfig, $datarow, $name ) {
		foreach ( $columnconfig as $config ) {
			if ( $config->name == $name ) {
				$id = $config->field !== '' ? intval( $config->field ) : - 1;

				$myvalue = null;

				if ( $id > - 1 && isset( $datarow[ $id ] ) && $datarow[ $id ] != '' ) {
					$myvalue = ( $config->prefix ) . ( $datarow[ $id ] ) . ( $config->suffix );
				}

				if ( $myvalue == null && $config->fallback != '' ) {
					$myvalue = $config->fallback;
				}

				return $myvalue;
			}
		}

		return null;
	}

	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}
}

?>