<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_toolkit {
	private $base = null;

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		$base = $pluginbase;
	}

	private function display_cron_job( $hookParam = ATKP_EVENT, $output = true ) {
		$crontype = get_option( ATKP_PLUGIN_PREFIX . '_crontype', 'wpcron' );

		switch ( $crontype ) {
			default:
			case 'wpcron':
				return ATKPTools::exists_cron_job( $hookParam, $output );
				break;
			case 'external':
			case 'externaloutput':
			case 'external-multi':
			case 'externaloutput-multi':

				break;
		}


	}

	public function toolkit_configuration_page() {
		if ( ATKPTools::exists_post_parameter( 'saveglobal' ) && check_admin_referer( 'save', 'save' ) ) {
			//speichern der einstellungen

			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_access_csv_intervall', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_access_csv_intervall', 'int' ) );

			$oldduration = get_option( ATKP_PLUGIN_PREFIX . '_cache_duration', 1440 );
			$duration    = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_cache_duration', 'int' );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_cache_duration', $duration );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_crontype', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_crontype', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_cron_from', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_cron_from', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_cron_to', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_cron_to', 'string' ) );


			$fieldgroups = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', 'bool' );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', $fieldgroups );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', $fieldgroups == true ? true : ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productgroups_enabled', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_activateacf', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_activateacf', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_gutenberg_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_gutenberg_module_enabled', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customfields_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_customfields_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productpages_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productpages_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_massimport_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_massimport_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_woo_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_woo_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_debug_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_debug_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_shortcodegenerator_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_shortcodegenerator_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productimportmask_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productimportmask_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_asa1_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_asa1_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_asa2_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_asa2_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_livelist_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_livelist_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_searchform_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_searchform_module_enabled', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_widget_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_widget_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_module_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_floatingbar_module_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_pricehistory_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_pricehistory_enabled', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_check_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_check_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_notification_interval', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_notification_interval', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_email_recipient', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_email_recipient', 'string' ) );

			$cronjob = new atkp_wp_cronjob( array() );

			if ( isset( $cronjob ) ) {
				ATKPSettings::load_settings();

				$cronjob->my_update();
			}

			echo '<script>window.location.reload();</script>';
			exit;
			//header("Refresh:0");
			//exit;
		}


		?>
        <div class="atkp-content wrap">
            <div class="inner">


                <form method="POST" action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin' ?>">
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Global settings', ATKP_PLUGIN_PREFIX ) ?>
                            </th>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'cronjob type', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
								<?php echo ATKPHomeLinks::GetHelpIcon( 'cronjob-type' ); ?>
                            </th>
                            <td>
                                <select name="<?php echo ATKP_PLUGIN_PREFIX . '_crontype' ?>">
									<?php
									$crontype  = get_option( ATKP_PLUGIN_PREFIX . '_crontype', 'wpcron' );
									$durations = array(
										'wpcron'               => __( 'Wordpress Cronjob', ATKP_PLUGIN_PREFIX ),
										'external'             => __( 'External Cronjob', ATKP_PLUGIN_PREFIX ),
										'externaloutput'       => __( 'External Cronjob + Output', ATKP_PLUGIN_PREFIX ),
										'external-multi'       => __( 'External Multi Cronjob', ATKP_PLUGIN_PREFIX ),
										'externaloutput-multi' => __( 'External Multi Cronjob + Output', ATKP_PLUGIN_PREFIX ),


									);

									foreach ( $durations as $value => $name ) {
										if ( $value == $crontype ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>

								<?php
								if ( $crontype == 'external' || $crontype == 'externaloutput' ) {
									?><br/><span style="font-weight:bold"><?php
									$lastactivity = get_option( ATKP_PLUGIN_PREFIX . '_cron_lastactivity' );

									if ( $lastactivity != '' ) {
										echo sprintf( __( 'Last activity: %s', ATKP_PLUGIN_PREFIX ), date( 'd.m.y H:i:s', $lastactivity ) );
									}
									?></span><?php
								} else { ?>

                                    <br/>
                                    <span style=" font-weight:bold"><?php $this->display_cron_job( ATKP_EVENT, true ); ?></span>

								<?php } ?>

                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Productdata updates between', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="time" id="<?php echo ATKP_PLUGIN_PREFIX . '_cron_from' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_cron_from' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_cron_from' ); ?>">
                                -
                                <input type="time" id="<?php echo ATKP_PLUGIN_PREFIX . '_cron_to' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_cron_to' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_cron_to' ); ?>">

								<?php _e( 'Current time', ATKP_PLUGIN_PREFIX ) ?>:
								<?php echo date( 'd.m.y H:i:s', time() ); ?>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Available Plugin Modules:', ATKP_PLUGIN_PREFIX ) ?>
                            </th>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <td scope="row">
                                &nbsp;
                            </td>
                        </tr>
                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_customfields_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_customfields_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_customfields_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_customfields_module_enabled' ?>">
									<?php _e( 'Custom fields', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'By using the custom fields, you can extend and enter or import your products with useful fields and entire product groups. These fields can then be displayed in the comparison tables or templates.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input <?php echo function_exists( 'get_fields' ) ? '' : 'disabled'; ?> type="checkbox"
                                                                                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_activateacf' ?>"
                                                                                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_activateacf' ?>"
                                                                                                        value="1" <?php echo checked( 1, atkp_options::$loader->get_acfenabled(), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_activateacf' ?>">
									<?php _e( 'Enable "Advanced Custom Fields" support', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you use the ACF Pro plugin, you can enable this option. This allows you to access the fields with their own placeholders in the templates.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_productpages_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productpages_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_productpages_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_productpages_module_enabled' ?>">
									<?php _e( 'Product pages', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'The product pages allow you to post products on your website to your visitors. The products are published under their own slug. So you can view the products like normal posts.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_massimport_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_massimport_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_massimport_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_massimport_module_enabled' ?>">
									<?php _e( 'Mass import functions', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'The Bulk Import feature allows you to bulk-create products and lists. All you need is a CSV list of product IDs or keywords.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_woo_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_woo_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_woo_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_woo_module_enabled' ?>">
									<?php _e( 'WooCommerce ', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'With the WooCommerce extension, you can import affiliate products into your WooCommerce store and have them automatically updated. The presentation of the product page is entirely up to you.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_debug_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_debug_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_debug_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_debug_module_enabled' ?>">
									<?php _e( 'Debug', ATKP_PLUGIN_PREFIX ) ?>
                                </label>


                                <div class="atkp-description">
									<?php _e( 'If the support needs a logfile, you can create it with this module. In regular operation, this module is not necessary.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_shortcodegenerator_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_shortcodegenerator_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_shortcodegenerator_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_shortcodegenerator_module_enabled' ?>">
									<?php _e( 'Shortcode generator', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'The shortcode generator lets you generate shortcodes for the products and lists in the text editor. By default you will find a button in the tool list.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_gutenberg_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_gutenberg_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_gutenberg_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_gutenberg_module_enabled' ?>">
									<?php _e( 'Gutenberg Shortcode generator', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'With this option you can also display the shortcode generator button in the editor of Gutenberg.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>


                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_productimportmask_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productimportmask_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_productimportmask_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_productimportmask_module_enabled' ?>">
									<?php _e( 'Product import mask', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you want to use the product import mask under "AT Products", you need to enable this option.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_asa1_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_asa1_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_asa1_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_asa1_module_enabled' ?>">
									<?php _e( 'ASA1 support', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you would like to replace Amazon Simple Admin 1, enable this option and configure it in Preferences.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_asa2_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_asa2_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_asa2_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_asa2_module_enabled' ?>">
									<?php _e( 'ASA2 support', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you would like to replace Amazon Simple Affiliate 2, enable this option and configure it in Preferences.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_livelist_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_livelist_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_livelist_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_livelist_module_enabled' ?>">
									<?php _e( 'livelist shortcodes', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you want to submit search queries directly to the Apis using the "livelist" code, you need to activate this module.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_searchform_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_module_enabled' ?>">
									<?php _e( 'searchform shortcodes', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'If you want to make your internal product database searchable, you\'ll need the "searchform" code.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_widget_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_widget_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_widget_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_widget_module_enabled' ?>">
									<?php _e( 'Widgets', ATKP_PLUGIN_PREFIX ) ?>
                                </label>


                                <div class="atkp-description">
									<?php _e( 'Do you want to display AT products or search forms in the widgets? Then you need the special modules which you can activate here.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_module_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_module_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_floatingbar_module_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_module_enabled' ?>">
									<?php _e( 'Floating bar', ATKP_PLUGIN_PREFIX ) ?>
                                </label>

                                <div class="atkp-description">
									<?php _e( 'With the Floatingbar, you can display product information on product pages or posts. These fade in when scrolling.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>


                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_productgroups_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productgroups_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_productgroups_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_productgroups_enabled' ?>">
									<?php _e( 'Enable product groups taxonomy', ATKP_PLUGIN_PREFIX ) ?>
                                </label>


                                <div class="atkp-description">
									<?php _e( 'The product groups are like "categories" in the posts. These are also necessary if you want to use the field groups. These are used to assign the groups to a product.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowb">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_fieldgroups_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled' ?>">
									<?php _e( 'Enable field groups (requires product groups)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>


                                <div class="atkp-description">
									<?php _e( 'You can create your own fields with the field groups. So you can z.b. Create the field group TV and create fields such as "refresh rate" or "screen width". You assign this field group to a product group. All products in this product group will then have these fields under Custom Fields.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_pricehistory_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_pricehistory_enabled' ?>"
                                       value="1" <?php echo checked( 1, atkp_options::$loader->get_pricehistory_enabled(), false ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_pricehistory_enabled' ?>">
									<?php _e( 'Enable price history', ATKP_PLUGIN_PREFIX ) ?>


                                </label>

                                <div class="atkp-description">
									<?php _e( 'With Pricehistory, every changed price is automatically written off into a separate table. Over a longer period of time, you can display the price history graphs.', ATKP_PLUGIN_PREFIX ) ?>
                                </div>
                            </td>
                        </tr>

                        <tr valign="top" class="atkp-modulerowa">
                            <td scope="row">
                                &nbsp;
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Settings for data check', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-datacheck' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_check_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_check_enabled' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_check_enabled' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_check_enabled' ?>">
									<?php _e( 'Enable data check', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Data check interval', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select name="<?php echo ATKP_PLUGIN_PREFIX . '_notification_interval' ?>">
									<?php

									$durations = array(
										360   => __( '6 Hours', ATKP_PLUGIN_PREFIX ),
										720   => __( '12 Hours', ATKP_PLUGIN_PREFIX ),
										1440  => __( '1 Day', ATKP_PLUGIN_PREFIX ),
										4320  => __( '3 Days', ATKP_PLUGIN_PREFIX ),
										10080 => __( '1 Week', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_notification_interval', 4320 ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . $name . '</option>';
									} ?>
                                </select>

                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Recipient of e-mail report', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="email" id="<?php echo ATKP_PLUGIN_PREFIX . '_email_recipient' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_email_recipient' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_email_recipient' ); ?>">

								<?php $nounce = wp_create_nonce( 'atkp-sendmessages' );
								echo '<a class="button" href="' . ATKPTools::get_endpointurl() . '?action=atkp_sendmessages&request_nonce=' . $nounce . '">' . __( 'Send report now', ATKP_PLUGIN_PREFIX ) . '</a>'; ?>


                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" colspan="2">
                                &nbsp;
                            </th>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Settings for data cache', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-datacache' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Cache duration', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select name="<?php echo ATKP_PLUGIN_PREFIX . '_cache_duration' ?>">
									<?php

									$durations = array(
										60    => __( '1 Hour', ATKP_PLUGIN_PREFIX ),
										360   => __( '6 Hours', ATKP_PLUGIN_PREFIX ),
										720   => __( '12 Hours', ATKP_PLUGIN_PREFIX ),
										1440  => __( '1 Day', ATKP_PLUGIN_PREFIX ),
										4320  => __( '3 Days', ATKP_PLUGIN_PREFIX ),
										10080 => __( '1 Week', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_cache_duration', 1440 ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . $name . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'CSV Import intervall', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select name="<?php echo ATKP_PLUGIN_PREFIX . '_access_csv_intervall' ?>">
									<?php

									$durations = array(
										720   => __( '12 Hours', ATKP_PLUGIN_PREFIX ),
										1440  => __( '1 Day', ATKP_PLUGIN_PREFIX ),
										4320  => __( '3 Days', ATKP_PLUGIN_PREFIX ),
										10080 => __( '1 Week', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == get_option( ATKP_PLUGIN_PREFIX . '_access_csv_intervall', 1440 ) ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										$item_translated = '';

										echo '<option value="' . $value . '"' . $sel . '>' . $name . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php submit_button( '', 'primary', 'saveglobal', false ); ?>
                            </td>
                        </tr>

                    </table>
                </form>

            </div>
        </div>


		<?php
	}
}

?>