<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_product {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {


	}

	public function product_configuration_page() {
		if ( ATKPTools::exists_post_parameter( 'saveproduct' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			//speichern der einstellungen


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_importimage', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_importimage', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_enabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_enabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_slug', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_slug', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_commentenabled', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_commentenabled', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_template', 'html' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_archivetemplate', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_archivetemplate', 'html' ) );


		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="atkp-content wrap">
            <div class="inner">
                <!-- <h2><?php _e( 'Affiliate Toolkit - Productpage Settings', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>">
                    <!--_affiliate_toolkit-bestseller-->
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Productpage', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-productpage' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_product_enabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_enabled' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_product_enabled', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_product_enabled' ?>">
									<?php _e( 'Productpage enabled', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th>
                                <label for="">
									<?php _e( 'Product slug', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_product_slug' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_slug' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_product_slug', strtolower( __( 'Products', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Post thumbnail', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_product_importimage' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_product_importimage' ?>"
                                        style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_product_importimage', 0 );

									echo '<option value="0" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'Do not import the image', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . __( 'Import main image', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Use external main image', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_product_commentenabled' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_commentenabled' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_product_commentenabled', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_product_commentenabled' ?>">
									<?php _e( 'Allow comments', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="">
									<?php _e( 'Product template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>


								<?php
								wp_editor( stripslashes( get_option( ATKP_PLUGIN_PREFIX . '_product_template', __( '<div class="atkp-page">
[atkp_product template=\'secondwide\'][/atkp_product][atkp_product field=\'content\'][/atkp_product]
<br />
%content%
<h2>Features</h2>
[atkp_product field=\'info_text\'][/atkp_product]
<br />
<h2>Available offers</h2>
[atkp_product template=\'detailoffers\'][/atkp_product] <br />Last Updated on [atkp_product field=\'refresh_date\'] at [atkp_product field=\'refresh_time\'].</div>', ATKP_PLUGIN_PREFIX ) ) ), ATKP_PLUGIN_PREFIX . '_product_template', array(
									'media_buttons' => false,
									'textarea_name' => ATKP_PLUGIN_PREFIX . '_product_template',
									'textarea_rows' => 15,
								) );
								?>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="">
									<?php _e( 'Product archive template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>


								<?php
								wp_editor( stripslashes( get_option( ATKP_PLUGIN_PREFIX . '_product_archivetemplate', __( '[atkp_product field=\'info_text\'][/atkp_product]%content%', ATKP_PLUGIN_PREFIX ) ) ), ATKP_PLUGIN_PREFIX . '_product_archivetemplate', array(
									'media_buttons' => false,
									'textarea_name' => ATKP_PLUGIN_PREFIX . '_product_archivetemplate',
									'textarea_rows' => 15,
								) );
								?>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php _e( 'Note: After activating the product page or changing the product slugs; re-saving the permalinks is necessary (Settings-> Permalinks-> Save Changes).', ATKP_PLUGIN_PREFIX ); ?>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php
								$xx = new atkp_shortcode_generator2( array() );
								$xx->shortcode_buttons();


								submit_button( '', 'primary', 'saveproduct', false ); ?>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>

        <!--<script type="text/javascript">
            var $j = jQuery.noConflict();
              $j(document).ready(function() {
                         $j('#<?php echo ATKP_PLUGIN_PREFIX . '_product_owntemplate' ?>').change(function () {
                            if($j('#<?php echo ATKP_PLUGIN_PREFIX . '_product_owntemplate' ?>').prop('checked'))
                                $j('#<?php echo ATKP_PLUGIN_PREFIX . '_product_template' ?>').prop('disabled', false);
                            else
                                $j('#<?php echo ATKP_PLUGIN_PREFIX . '_product_template' ?>').prop('disabled', true);
                             
                         });
                    
                      $j('#<?php echo ATKP_PLUGIN_PREFIX . '_product_owntemplate' ?>').trigger("change");
              });
            
            </script>-->


		<?php
	}
}

?>