<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


class atkp_endpoints {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_action( 'wp_ajax_atkp_export_template', array( &$this, 'atkp_export_template' ) );
		add_action( 'wp_ajax_atkp_search_departments', array( &$this, 'atkp_search_departments' ) );
		add_action( 'wp_ajax_atkp_search_products', array( &$this, 'atkp_search_products' ) );
		add_action( 'wp_ajax_atkp_search_browsenodes', array( &$this, 'atkp_search_browsenodes' ) );
		add_action( 'wp_ajax_atkp_search_filters', array( &$this, 'atkp_search_filters' ) );


		add_action( 'wp_ajax_atkp_get_object', array( &$this, 'atkp_get_object' ) );
		add_action( 'wp_ajax_atkp_import_product', array( &$this, 'atkp_import_product' ) );
		add_action( 'wp_ajax_atkp_create_list', array( &$this, 'atkp_create_list' ) );

		add_action( 'wp_ajax_atkp_clear_logfile', array( &$this, 'atkp_clear_logfile' ) );

		add_action( 'wp_ajax_atkp_reset_csvs', array( &$this, 'atkp_reset_csvs' ) );
		add_action( 'wp_ajax_atkp_reset_products', array( &$this, 'atkp_reset_products' ) );
		add_action( 'wp_ajax_atkp_reset_lists', array( &$this, 'atkp_reset_lists' ) );
		add_action( 'wp_ajax_atkp_import_offers', array( &$this, 'atkp_import_offers' ) );


		add_action( 'wp_ajax_atkp_reset_settings', array( &$this, 'atkp_reset_settings' ) );

		add_action( 'wp_ajax_atkp_import_demo', array( &$this, 'atkp_import_demo' ) );


		add_action( 'wp_ajax_atkp_download_logfile', array( &$this, 'atkp_download_logfile' ) );
		add_action( 'wp_ajax_atkp_sendmessages', array( &$this, 'atkp_sendmessages' ) );

		add_action( 'wp_ajax_atkp_clear_transient', array( &$this, 'atkp_clear_transient' ) );


		add_action( 'wp_ajax_atkp_search_local_products', array( &$this, 'atkp_search_local_products' ) );
		add_action( 'wp_ajax_nopriv_atkp_frontend_search_products', array( &$this, 'atkp_frontend_search_products' ) );
		add_action( 'wp_ajax_atkp_frontend_search_products', array( &$this, 'atkp_frontend_search_products' ) );

		add_action( 'wp_ajax_nopriv_atkp_live_search_render', array( &$this, 'atkp_live_search_render' ) );
		add_action( 'wp_ajax_atkp_live_search_render', array( &$this, 'atkp_live_search_render' ) );

		add_action( 'wp_ajax_atkp_live_search_backend', array( &$this, 'atkp_live_search_backend' ) );
		add_action( 'wp_ajax_atkp_live_addean_backend', array( &$this, 'atkp_live_addean_backend' ) );


	}

	function atkp_export_template() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-export-template', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			//if ( !wp_verify_nonce( $nounce, 'atkp-export-template' ) )
			//	throw new Exception('Nonce invalid');

			$templateid = ATKPTools::get_get_parameter( 'templateid', 'int' );

			$atkp_template = atkp_template::load( $templateid );

			$string = serialize( $atkp_template );
			$name   = sanitize_title( $atkp_template->title );

			# send the file to the browser as a download

			header( "Pragma: public" );
			header( "Expires: 0" );
			header( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
			header( "Cache-Control: public" );
			header( "Content-Description: File Transfer" );
			header( "Content-type: application/octet-stream" );
			header( "Content-Disposition: attachment; filename=\"" . $name . ".txt\"" );
			header( "Content-Transfer-Encoding: utf-8" );
			header( "Content-Length: " . strlen( $string ) );

			echo $string;

			exit;
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_reset_csvs() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			global $wpdb;
			$table = $wpdb->prefix . 'postmeta';
			$wpdb->delete( $table, array( 'meta_key' => ATKP_SHOP_POSTTYPE . '_updatedon' ) );


			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_import_demo() {

		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			if ( ! file_exists( get_home_path() . '/../demo-data.sql' ) ) {
				return;
			}

			$democontent = file_get_contents( get_home_path() . '/../demo-data.sql' );

			$demoparts = explode( '-newline-', $democontent );

			global $wpdb;

			foreach ( $demoparts as $demopart ) {
				if ( $demopart == '' ) {
					continue;
				}


				$demoquery = str_replace( '-tblprefix-', $wpdb->prefix, $demopart );

				$wpdb->query( $demoquery );
			}

			header( 'Refresh:5; url=' . $_SERVER['HTTP_REFERER'], true, 303 );
			//header('Location: ' . $_SERVER['HTTP_REFERER']);
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}

	}

	function atkp_reset_products() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			global $wpdb;
			$table = $wpdb->prefix . 'postmeta';
			$wpdb->delete( $table, array( 'meta_key' => ATKP_PRODUCT_POSTTYPE . '_updatedon' ) );


			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}


	function atkp_reset_settings() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			global $wpdb;

			echo $wpdb->query( 'DELETE FROM `' . $wpdb->prefix . 'options` where option_name like \'atkp_%\'' );
			echo $wpdb->query( 'DELETE FROM `' . $wpdb->prefix . 'comments` where comment_post_ID in (select ID FROM `' . $wpdb->prefix . 'posts` where post_type like \'atkp_%\')' );
			echo $wpdb->query( 'DELETE FROM `' . $wpdb->prefix . 'term_relationships` where object_id in (select ID FROM `' . $wpdb->prefix . 'posts` where post_type like \'atkp_%\')' );
			echo $wpdb->query( 'DELETE FROM `' . $wpdb->prefix . 'postmeta` where meta_key like \'atkp_%\'' );
			echo $wpdb->query( 'DELETE FROM `' . $wpdb->prefix . 'posts` where post_type like \'atkp_%\'' );

			echo $wpdb->query( 'DROP TABLE `' . strtolower( $wpdb->prefix . ATKP_PLUGIN_PREFIX . '_productdata' ) . '`' );
			echo $wpdb->query( 'DROP TABLE `' . strtolower( $wpdb->prefix . ATKP_PLUGIN_PREFIX . '_offertable' ) . '`' );

			//header( 'Refresh:5; url='.$_SERVER['HTTP_REFERER'], true, 303);
			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_import_offers() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}
//
//						$atkp_offertable_helper = new atkp_offertable_helper();
//
//						//manuelle angebote in die neue angebote tabelle übertragen
//						$page = 1;
//						$posts_per_page = 50;
//						do{
//
//								$posts_found = array(
//										'posts_per_page' => $posts_per_page,
//										'paged' => $page,
//										'post_status'    => array( 'draft', 'publish' ),
//										'post_type'      => ATKP_PRODUCT_POSTTYPE,
//
//										'meta_query' => array(
//												'relation' => 'AND',
//												array(
//														'key'     => ATKP_PRODUCT_POSTTYPE . '_offers',
//														'compare' => 'EXISTS',
//												),
//												array(
//														'key'     => ATKP_PRODUCT_POSTTYPE . '_offersimported',
//														'compare' => 'NOT EXISTS',
//												)
//										)
//								);
//								$posts = new WP_Query( $posts_found );
//
//								while ( $posts->have_posts() ) {
//										$posts->the_post();
//
//										$post_id = get_the_ID();
//
//										//echo $post_id;exit;
//
//										$offers = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_offers' );
//
//										if ( $offers != null ) {
//												$xx = 1;
//												foreach($offers as $offer)
//														$offer->id = $xx++;
//
//												$atkp_offertable_helper->update_offers_by_productid($post_id, $offers, true);
//										}
//
//										ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_offersimported', true );
//								}
//
//								wp_reset_postdata();
//
//								$page++;
//						}while(count($posts->posts) === $posts_per_page);

			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}


	}

	function atkp_reset_lists() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			global $wpdb;
			$table = $wpdb->prefix . 'postmeta';
			$wpdb->delete( $table, array( 'meta_key' => ATKP_LIST_POSTTYPE . '_updatedon' ) );


			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_clear_transient() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			global $wpdb;

			$result = $wpdb->get_results( "SELECT * FROM $wpdb->options WHERE option_name LIKE '_transient_" . ATKP_PLUGIN_PREFIX . "_%'" );
			foreach ( $result as $row ) {
				delete_transient( str_replace( '_transient_', '', $row->option_name ), true );
			}

			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_clear_logfile() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			if ( file_exists( ATKP_LOGFILE ) ) {
				unlink( ATKP_LOGFILE );
			}

			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_sendmessages() {

		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-sendmessages', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			$cron = new atkp_cronjob_new( array() );

			$cron->send_datamail( true );

			header( 'Location: ' . $_SERVER['HTTP_REFERER'] );
			exit;
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_download_logfile() {
		try {
			$nounce = ATKPTools::get_get_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-download-log', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			$string = '';
			if ( file_exists( ATKP_LOGFILE ) ) {
				$string = file_get_contents( ATKP_LOGFILE );
			}

			$name = sanitize_title( 'affiliate-toolkit-log.txt' );

			# send the file to the browser as a download

			header( "Pragma: public" );
			header( "Expires: 0" );
			header( "Cache-Control: must-revalidate, post-check=0, pre-check=0" );
			header( "Cache-Control: public" );
			header( "Content-Description: File Transfer" );
			header( "Content-type: text/plain" );
			header( "Content-Disposition: attachment; filename=\"" . $name . ".txt\"" );
			header( "Content-Transfer-Encoding: utf-8" );
			header( "Content-Length: " . strlen( $string ) );

			echo $string;

			exit;
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_create_list() {
		try {
			$nounce = ATKPTools::get_post_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-import-nonce', false ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			$shopid     = ATKPTools::get_post_parameter( 'shop', 'string' );
			$searchterm = ATKPTools::get_post_parameter( 'searchterm', 'string' );
			$listtype   = ATKPTools::get_post_parameter( 'listtype', 'string' );
			$title      = ATKPTools::get_post_parameter( 'title', 'string' );

			$department     = ATKPTools::get_post_parameter( 'department', 'string' );
			$sortby         = ATKPTools::get_post_parameter( 'sortby', 'string' );
			$loadmoreoffers = ATKPTools::get_post_parameter( 'loadmoreoffers', 'bool' );

			//shop: shop, title: title, department: department, sortby:sortby, browsenode:browsenodeid, searchterm: keyword, listtype: source, loadmoreoffers: loadmoreoffers

			$post_id = ATKPTools::create_list( $title, $shopid, $listtype, $searchterm, $department, $sortby, $loadmoreoffers );

			$listservice = new atkp_listservice( array() );

			$shop = $shopid != '' ? atkp_shop::load( $shopid, true ) : null;

			$listservice->update_lists( $shop, array( $post_id ) );

			$gif_data[] = array(
				'postid'   => $post_id,
				'title'    => get_the_title( $post_id ),
				'edit_url' => get_edit_post_link( $post_id ),
			);

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_import_product() {
		try {
			$nounce = ATKPTools::get_post_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-import-nonce' ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			$shopid    = ATKPTools::get_post_parameter( 'shop', 'string' );
			$asin      = ATKPTools::get_post_parameter( 'asin', 'string' );
			$asintype  = ATKPTools::get_post_parameter( 'asintype', 'string' );
			$title     = ATKPTools::get_post_parameter( 'title', 'string' );
			$status    = ATKPTools::get_post_parameter( 'status', 'string' );
			$importurl = ATKPTools::get_post_parameter( 'importurl', 'allhtml' );


			$brand = ATKPTools::get_post_parameter( 'brand', 'string' );
			$mpn   = ATKPTools::get_post_parameter( 'mpn', 'string' );

			if ( $shopid == '' ) {
				throw new Exception( 'shop required' );
			}
			if ( $asin == '' ) {
				throw new Exception( 'asin required' );
			}

			$globaltools = new atkp_global_tools();

			$gif_data = $globaltools->atkp_import_product( $shopid, $asin, $asintype, $title, $status, $importurl, $brand, $mpn );

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_get_object() {
		try {
			$nounce = ATKPTools::get_post_parameter( 'request_nonce', 'string' );

			if ( ! wp_verify_nonce( $nounce, 'atkp-get-nonce' ) ) {
				throw new Exception( 'Nonce invalid' );
			}

			$post_type = ATKPTools::get_post_parameter( 'post_type', 'string' );
			$id        = ATKPTools::get_post_parameter( 'post_id', 'string' );

			if ( $post_type == '' ) {
				throw new Exception( 'post_type required' );
			}
			if ( $id == '' ) {
				throw new Exception( 'id required' );
			}

			$gif_data[] = array();

			switch ( $post_type ) {
				case ATKP_PRODUCT_POSTTYPE:
				case ATKP_LIST_POSTTYPE:
					$gif_data['post_id']   = $id;
					$gif_data['post_type'] = $post_type;
					$gif_data['title']     = get_the_title( $id );
					$gif_data['edit_url']  = get_edit_post_link( $id );
					break;
				default:
					throw new exception( 'unknown posttype: ' . $post_type );
			}

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_frontend_search_products() {

		try {
			$azproducts = $this->localSearch( true );

			if ( $azproducts != null ) {
				wp_send_json( $azproducts );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}

	}

	function atkp_live_addean_backend() {

		try {
			$html = $this->addeantoproduct();

			$gif_data[] = array(
				'html' => $html,
			);

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}

	}

	function atkp_live_search_backend() {
		try {
			$html = $this->liveSearchBackend();

			$gif_data[] = array(
				'html' => $html,
			);

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}


	function atkp_live_search_render() {
		try {
			$html = $this->liveSearch();

			$gif_data[] = array(
				'html' => $html,
			);

			wp_send_json( $gif_data );

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_search_local_products() {

		try {
			$azproducts = $this->localSearch();

			if ( $azproducts != null ) {
				wp_send_json( $azproducts );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}

	}

	function atkp_search_products() {
		try {
			$azproducts = $this->quickSearch( 'product' );

			if ( $azproducts != null ) {
				wp_send_json( $azproducts );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_search_filters() {
		try {
			$azproducts = $this->quickSearch( 'filter' );

			if ( $azproducts != null ) {
				wp_send_json( $azproducts );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_search_departments() {
		try {
			$azproducts = $this->quickSearch( 'department' );

			if ( $azproducts != null ) {
				wp_send_json( $azproducts );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function atkp_search_browsenodes() {
		try {
			$aznodes = $this->quickSearch( 'browsenode' );

			if ( $aznodes != null ) {
				wp_send_json( $aznodes );
			}
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );

			$gif_data[] = array(
				'error'   => 'An error has occurred.',
				'message' => $e->getMessage(),
			);

			wp_send_json( $gif_data );
		}
	}

	function addeantoproduct() {
		$productid = ATKPTools::get_post_parameter( 'productid', 'int' );
		$ean       = ATKPTools::get_post_parameter( 'ean', 'string' );

		$eans = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_ean' );

		$eanarray = explode( ',', $eans );


		$neweanarray = explode( ',', $ean );

		foreach ( $neweanarray as $newean ) {
			if ( ! in_array( $newean, $eanarray ) ) {
				array_push( $eanarray, $newean );
			}
		}

		$eanarray = array_filter( $eanarray, function ( $value ) {
			return $value !== '';
		} );

		$eans = implode( ',', $eanarray );
		ATKPTools::set_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_ean', $eans );
	}

	function liveSearchBackend() {
		$shopid       = ATKPTools::get_post_parameter( 'shopid', 'int' );
		$keyword      = ATKPTools::get_post_parameter( 'keyword', 'string' );
		$searchoption = ATKPTools::get_post_parameter( 'searchoption', 'string' );
		$asintype     = ATKPTools::get_post_parameter( 'asintype', 'string' );

		if ( $keyword == '' ) {
			return __( 'Search term is required', ATKP_PLUGIN_PREFIX );
		}

		$shop = atkp_shop::load( $shopid );

		$resultVal = '';

		if ( $shop != null && $shop->provider != null ) {

			$resultVal = '
						<table class="wp-list-table widefat fixed striped" style="width:99%;">
                <thead>
                <tr>
                    <th scope="col" class="manage-column" style="width:20px">
						<input type="checkbox" class="selectAll" />
                    </th>
                    <th scope="col" class="manage-column"
                        style="width: 100px;text-align:center">
								        ' . __( 'Image', ATKP_PLUGIN_PREFIX ) . '
                    </th>

                    <th scope="col" class="manage-column column-primary">
								        ' . __( 'Title', ATKP_PLUGIN_PREFIX ) . '
                    </th>

                    <th scope="col" class="manage-column" style="width:210px"
                    ">
						        ' . __( 'Status', ATKP_PLUGIN_PREFIX ) . '
                    </th>

                </tr>
                </thead>

                <tbody>
						';


			try {
				$shop->provider->checklogon( $shop );
				$result = $shop->provider->quick_search( $keyword, $searchoption == 'asin' || $searchoption == 'ean' || $searchoption == 'articlenumber' ? $searchoption : 'product', 1 );

				if ( isset( $result ) && $result != null) {
					foreach ( $result->products as $product ) {
						$asin2 = '';
						switch ( strtoupper( $asintype ) ) {
							default:
							case 'ASIN':
								$asin2 = $product['asin'];
								break;
							case 'EAN':
								$asin2 = isset( $product['ean'] ) ? $product['ean'] : '';
								break;
							case 'TITLE':
								$asin2 = $product['title'];
								break;
							case 'ARTICLENUMBER':
								$asin2 = isset( $product['articlenumber'] ) ? $product['articlenumber'] : '';
								break;

						}


						$asin      = $product['asin'];
						$resultVal .= '
												<tr>
														<td><input class="atkp-checkboxstyle" type="checkbox" name="atkp_prd_' . $shop->id . '_' . $asin . '" class="atkp-productimport" asintype="' . esc_attr( $asintype ) . '" shopid="' . esc_attr( $shop->id ) . '"  asin="' . esc_attr( $asin ) . '" asinkey="' . esc_attr( $asin2 ) . '"  ean="' . esc_attr( isset( $product['ean'] ) ? $product['ean'] : '' ) . '"   articlenumber="' . esc_attr( isset( $product['articlenumber'] ) ? $product['articlenumber'] : '' ) . '" /> </td>
														<td style="text-align:center">
																' . ( isset( $product['imageurl'] ) ? '<img src="' . $product['imageurl'] . '" style="max-width: 100px;" />' : '' ) . '
														</td>

														<td>
																<span>' . $product['title'] . '</span>
																<br/>
																' . __( 'Unique ID', ATKP_PLUGIN_PREFIX ) . ': ' . $asin . ', EAN: ' . ( isset( $product['ean'] ) ? $product['ean'] : '-' ) . ', ' . __( 'Articlenumber', ATKP_PLUGIN_PREFIX ) . ': ' . ( isset( $product['articlenumber'] ) ? $product['articlenumber'] : '-' ) . ' 
																' . ( isset( $product['saleprice'] ) ? ', ' . sprintf( __( 'Price: %s', ATKP_PLUGIN_PREFIX ), $product['saleprice'] ) : '' ) . '
																<br/>
																<a href="' . $product['producturl'] . '"
																   target="_blank">' . __( 'View product', ATKP_PLUGIN_PREFIX ) . '</a>
														</td>

														<td>
																' . ( $this->get_product_status( $searchoption, $product, $asin2 ) ) . '
														</td>

												</tr>';
					}
				}

			} catch ( Exception $e ) {

				ATKPLog::LogError( $e->getMessage() );

				return $e->getMessage();
			}

			$resultVal .= '</tbody></table>';

		}

		return $resultVal;
	}

	private function get_product_status( $searchoption, $product, $asin ) {

		if ( $asin != '' ) {
			$args     = array(
				'meta_key'       => ATKP_PRODUCT_POSTTYPE . '_asin',
				'meta_value'     => $asin,
				'post_type'      => ATKP_PRODUCT_POSTTYPE,
				'post_status'    => array( 'publish', 'draft' ),
				'posts_per_page' => - 1
			);
			$subposts = get_posts( $args );
		}

		$result = '<div id="atkp-status-' . $product['asin'] . '">';

		if ( isset( $subposts ) && count( $subposts ) > 0 ) {
			$myprd = $subposts[0];

			$result .= '<img style="vertical-align:middle" src="' . plugins_url( 'images/yes.png', ATKP_PLUGIN_FILE ) . '" alt="' . __( 'Imported', ATKP_PLUGIN_PREFIX ) . '"/>';
			$result .= '<a style="margin-left:5px" href="' . get_edit_post_link( $myprd->ID ) . '" target="_blank">' . __( 'Product imported.', ATKP_PLUGIN_PREFIX ) . '</a><br />';

		}

		$result .= '</div>';

		return $result;
	}

	function liveSearch() {

		$shopid       = ATKPTools::get_post_parameter( 'shopid', 'int' );
		$filter       = ATKPTools::get_post_parameter( 'filter', 'string' );
		$template     = ATKPTools::get_post_parameter( 'template', 'string' );
		$elementcss   = ATKPTools::get_post_parameter( 'elementcss', 'string' );
		$containercss = ATKPTools::get_post_parameter( 'containercss', 'string' );
		$limit        = ATKPTools::get_post_parameter( 'limit', 'int' );

		if ( $limit <= 0 ) {
			$limit = 10;
		}

		if ( $filter == '' ) {
			return 'searchtermrequired';
		}

		$filterhelper = new atkp_filter_helper();
		$filterarray  = $filterhelper->parse_params_filter( $filter, false );

		$shop = atkp_shop::load( $shopid );

		if ( $shop != null && $shop->provider != null ) {
			$shop->provider->checklogon( $shop );

			if ( ! isset( $filterarray['search'] ) || $filterarray['search'] == '' ) {
				return 'searchtermrequired';
			}

			try {
				$response = $shop->provider->retrieve_list( count( $filterarray ) > 1 ? 'ExtendedSearch' : 'Search', 'All', $filterarray['search'], '', $limit, null, $filterarray );
			} catch ( Exception $e ) {
				return 'noresultfound';
			}
			if ( count( $response->products ) == 0 ) {
				return 'noresultfound';
			}

			$templatehelper = new atkp_template_helper();
			$resultValue    = $templatehelper->createOutput( $response->products, '', $template, $containercss, $elementcss, '', '', false, 0, '', '', '', 100, 1, null );

			return $resultValue;
		}

		return 'html' . serialize( $filterarray );
	}

	function localSearch( $isfrontend = false ) {
		//$nounce =  ATKPTools::get_post_parameter('request_nonce', 'string');

		//if ( !wp_verify_nonce( $nounce, 'atkp-search-nonce' ) )
		//    throw new Exception('Nonce invalid');

		$type    = ATKPTools::get_post_parameter( 'type', 'string' );
		$keyword = ATKPTools::get_post_parameter( 'keyword', 'string' );

		if ( ! $isfrontend ) {
			if ( $type == '' ) {
				throw new Exception( 'type is required' );
			}
		} else {
			if ( $type != ATKP_PRODUCT_POSTTYPE ) {
				throw new Exception( 'type not supported' );
			}
		}

		$products = array();
		$args     = array(
			'post_type'        => array( $type ),
			'suppress_filters' => true,
			's'                => $keyword,
			'post_status'      => $isfrontend ? array( 'publish' ) : array( 'draft', 'publish' ),
			'paged'            => 1,
			'posts_per_page'   => 50,

			'orderby' => 'relevance',
			'order'   => 'ASC',
		);

		$the_query = new WP_Query( $args );

		while ( $the_query->have_posts() ) {
			try {
				$the_query->the_post();

				$prd = $the_query->post;


				$product = array();
				//info: je nach anbieter wird entweder small oder large zurückgeliefert?!

				$product['id']    = $post_id = $prd->ID;
				$product['title'] = $prd->post_title;
				if ( ! $isfrontend ) {
					$product['editurl'] = get_edit_post_link( $prd->ID );
				}

				switch ( $type ) {
					case ATKP_PRODUCT_POSTTYPE:
						$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', true );
						if ( $imageurl == '' ) {
							$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', true );
						}
						if ( $imageurl == '' ) {
							$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', true );
						}

						$product['imageurl'] = $imageurl;

						$selectedshopid = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shopid', 0 );

						if ( $selectedshopid != '' ) {
							$shps = atkp_shop::load( $selectedshopid, false );
						}

						if ( ! isset( $shps ) || $shps == null ) {
							$product['shop'] = __( 'Manual product', ATKP_PLUGIN_PREFIX );
						} else {
							$product['shop'] = __( 'Shop', ATKP_PLUGIN_PREFIX ) . ': ' . $shps->title;
						}
						break;
					case ATKP_LIST_POSTTYPE:

						$selectedshopid = ATKPTools::get_post_setting( $post_id, ATKP_LIST_POSTTYPE . '_shopid', 0 );

						if ( $selectedshopid != '' ) {
							$shps = atkp_shop::load( $selectedshopid, false );
						}

						if ( ! isset( $shps ) || $shps == null ) {
							$product['shop'] = __( 'Manual list', ATKP_PLUGIN_PREFIX );
						} else {
							$product['shop'] = __( 'Shop', ATKP_PLUGIN_PREFIX ) . ': ' . $shps->title;
						}
						break;
					default:
						throw new exception( 'unknown type: ' . $type );
				}

				array_push( $products, $product );
			} catch ( Exception $e ) {


			}
		}

		wp_reset_postdata();

		return $products;
	}

	function quickSearch( $searchType ) {

		$nounce = ATKPTools::get_post_parameter( 'request_nonce', 'string' );

		if ( ! wp_verify_nonce( $nounce, 'atkp-search-nonce' ) ) {
			throw new Exception( 'Nonce invalid' );
		}

		$shopid  = ATKPTools::get_post_parameter( 'shop', 'string' );
		$keyword = ATKPTools::get_post_parameter( 'keyword', 'string' );

		if ( $shopid == '' ) {
			throw new Exception( 'shop required' );
		}
		if ( $keyword == '' && $searchType != 'department' && $searchType != 'filter' ) {
			throw new Exception( 'keyword required' );
		}

		$shop = atkp_shop::load( $shopid );


		if ( $shop != null && $shop->provider != null ) {
			$shop->provider->checklogon( $shop );

			if ( $searchType == 'department' ) {
				$depar = $shop->provider->retrieve_departments();

				$departments = array();
				foreach ( $depar as $key => $department ) {
					$department['caption'] = $department['caption'] . ' (' . $key . ')';

					$departments[ $key ] = $department;
				}

				return $departments;
			} else if ( $searchType == 'filter' ) {
				return $shop->provider->retrieve_filters();
			} else if ( $searchType == 'browsenode' ) {
				return $shop->provider->retrieve_browsenodes( $keyword );
			} else {
				$products = $shop->provider->quick_search( $keyword, $searchType );

				$newproducts = array();

				if ( isset( $products ) && $products != null && is_array( $products->products ) ) {
					foreach ( $products->products as $product ) {
						if ( isset( $product['asin'] ) ) {
							$id = atkp_product::idbyasin( $product['asin'] );

							if ( $id == null ) {
								$product['productid'] = 'null';
							} else {
								$product['productid'] = $id;
							}
						} else {
							$product['productid'] = 'null';
						}

						array_push( $newproducts, $product );
					}
				}

				return $newproducts;
			}
		}

	}

}

?>