<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_webgains extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_caption() {
		return __( 'Webgains API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function get_maxproductcount() {
		return 100;
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	private $apikey = '';

	public function check_configuration( $post_id ) {
		try {
			$apikey        = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey  = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$apiProgramIds = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_programids' );
			$enable_ssl    = true; // ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

			$programids = explode( "\n", $apiProgramIds );
			$programids = array_map( 'trim', $programids );


			$message = '';
			if ( $apikey != '' && $apisecretkey != '' ) {

				$query = 'https://api.webgains.com/2.0/programs?key=' . $apikey . '&campaignId=' . $apisecretkey;

				$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration webgains ***' );
					ATKPLog::LogDebug( serialize( $result1 ) );
					ATKPLog::LogDebug( '*** check_configuration webgains ***' );
				}

				if ( is_wp_error( $result1 ) ) {
					//TODO: fehler
				} else {
					$results = json_decode( $result1['body'], true );
				}

				$subshops = array();

				foreach ( $results as $program ) {
					if ( in_array( $program['id'], $programids ) ) {

						$subshop        = new subshop();
						$subshop->title = $program['name'];
						//$subshop->title2 = $platform['name'];
						$subshop->shopid    = $apisecretkey;
						$subshop->programid = $program['id'];

						//$subshop->logourl = $this->checkimageurl($program['programlogo'], $enable_ssl);
						//$subshop->smalllogourl = $this->checkimageurl($program['programlogo'], $enable_ssl);

						array_push( $subshops, $subshop );
					}

				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );


			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_programids', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_webgains_access_programids', 'multistring' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_webgains_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_webgains_access_secret_key', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_webgains_enable_ssl', 'bool' ) );

		//  $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		// if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'zanox');

		//echo serialize($subshops);exit;

		// ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey        = '';
		$apisecretkey  = '';
		$subshops      = '';
		$enablessl     = false;
		$apiProgramids = '';


		if ( $webservice == '8' ) {

			$apiProgramids = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_programids' );

			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$enablessl = true; //ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'API Key', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'webgains-api' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Campaign ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="number"
                       id="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_secret_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_secret_key' ?>"
                       value="<?php echo $apisecretkey; ?>">
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Program ID (s)', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <textarea style="width:40%;height:100px"
                          id="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_programids' ?>"
                          name="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_access_programids' ?>"><?php echo esc_textarea( $apiProgramids ); ?></textarea>

            </td>
        </tr>


        <!--
                        <tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_enable_ssl' ?>" name="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_enable_ssl' ?>" value="1" <?php echo checked( 1, $enablessl, true ); ?>>
                                 <label for="<?php echo ATKP_SHOP_POSTTYPE . '_webgains_enable_ssl' ?>">
                                    <?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>
                        
                        <tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php


		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'zanox');
		?>
                            
                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid;


					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $helper = null;
	private $shopid = null;
	private $programid = null;
	private $campaignId = null;
	private $enable_ssl = false;

	public function checklogon( $shop ) {
		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$campaignId       = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$this->enable_ssl = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		$apiProgramIds    = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_programids' );

		if ( $apikey == '' || $campaignId == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$query = 'https://api.webgains.com/2.0/programs?key=' . $apikey . '&campaignId=' . $campaignId;

		$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

		if ( is_wp_error( $result1 ) ) {
			//TODO: fehler
		} else {
			$results = json_decode( $result1['body'], true );
		}

		$this->apikey = $apikey;
		$this->shopid = $shop->id;

		//$shopids = explode('_', $shop->shopid);

		$this->programid  = $shop->programid;
		$this->campaignId = $campaignId;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->apikey == '' ) {
			throw new Exception( 'checklogon required' );
		}


		$products = new atkp_search_resp();

		$maxCount = 10;


        switch ( $searchType ) {
            case 'asin':
            case 'ean':
            default:
                $query = 'https://api.webgains.com/2.0/products?key=' . $this->apikey . '&campaignId=' . $this->campaignId . '&programIds=' . $this->programid . '&offset=' . ( ($pagination-1) * 10 ) . '&keywords=' .urlencode($keyword) ;

                $result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

                if ( is_wp_error( $result1 ) ) {
                    throw new Exception( $result1->get_error_message() );
                } else {
                    $results = json_decode( $result1['body'], true );
                }
                break;
        }

        if ( isset( $results['code'] ) ) {
            throw new Exception( $results['code'] . ': ' . $results['message'] );
        }

		$products->total = intval($results['total_results']);
		$products->currentpage = $products->total > 0 ? $pagination : 0;
		$products->pagecount = ceil(floatval($products->total) / floatval($maxCount));

        foreach ( $results['results'] as $result ) {
            $product = array();
            //info: je nach anbieter wird entweder small oder large zurückgeliefert?!

            if ( array_key_exists( 'image_thumbnail_url', $result ) && $result['image_thumbnail_url'] != '' ) {
                $product['imageurl'] = $this->checkimageurl( $result['image_thumbnail_url'] );
            } else {
                $product['imageurl'] = $this->checkimageurl( $result['image_url'] );
            }
            //image_large_url
            $product['asin']       = $result['product_id'] . '_' . sanitize_title( $result['product_name'] );
            $product['producturl'] = ATKPTools::check_sslurl( $result['deeplink'] );
            $product['title']      = $result['product_name'];
            $product['ean']        = ! array_key_exists( 'european_article_number', $result ) ? '' : $result['european_article_number'];

            $product['description'] = strlen( $result['description'] ) > 350 ? substr( $result['description'], 0, 350 ) : $result['description'];
            $product['saleprice']   = $result['display_price'] == '' ? $result['price'] : $result['display_price'];

            if ( $result['product_id'] != '' ) {
                array_push( $products->products, $product );
            }
        }



		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
		}

//echo serialize($result);exit;

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$myproduct->features    = $result['short_description'];
		$myproduct->description = $result['description'];
		$myproduct->title       = $result['product_name'];;
		$myproduct->asin = $result['product_id'] . '|' . $result['product_name'];

		if ( array_key_exists( 'image_thumbnail_url', $result ) ) {
			$myproduct->smallimageurl = $this->checkimageurl( $result['image_thumbnail_url'] );
		}

		if ( array_key_exists( 'image_url', $result ) ) {
			$myproduct->mediumimageurl = $this->checkimageurl( $result['image_url'] );
		}
		if ( array_key_exists( 'image_large_url', $result ) ) {
			$myproduct->largeimageurl = $this->checkimageurl( $result['image_large_url'] );
		}

		$myproduct->producturl = ATKPTools::check_sslurl( $result['deeplink'] );

		$myproduct->saleprice      = $result['display_price'] == '' ? $result['price'] : $result['display_price'];
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		if ( array_key_exists( 'delivery_cost', $result ) ) {
			$myproduct->shipping      = $result['delivery_cost'];
			$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );
		}

		if ( array_key_exists( 'merchant_category', $result ) ) {
			$myproduct->productgroup = $result['merchant_category'];
		}
		if ( array_key_exists( 'european_article_number', $result ) ) {
			$myproduct->ean = $result['european_article_number'];
		}
		if ( array_key_exists( 'manufacturer', $result ) ) {
			$myproduct->manufacturer = $result['manufacturer'];
		}
		if ( array_key_exists( 'brand', $result ) ) {
			$myproduct->brand = $result['brand'];
		}

		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {

		$departments = array();

		$departments['AllCategories'] = array(
			'caption' => __( 'All categories', ATKP_PLUGIN_PREFIX )
		);

		//TODO: get departments for api


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {

			$keys = explode( '_', $asin );

			try {
				switch ( $id_type ) {
					case 'ARTICLENUMBER':
					case 'ASIN':
					case 'EAN':
					case 'TITLE':
						$query = 'https://api.webgains.com/2.0/products?key=' . $this->apikey . '&campaignId=' . $this->campaignId . '&programIds=' . $this->programid . '&keywords=' . str_replace( '-', ' ', $keys[1] );

						$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

						if ( is_wp_error( $result1 ) ) {
							$titlecheck = $result1->get_error_message();
						} else {
							$results = json_decode( $result1['body'], true );
						}
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( GuzzleHttp\Exception\ClientException $e ) {
				$response = $e->getResponse();
				if ( isset( $response ) ) {
					$titlecheck = $response->getBody();
				} else {
					$titlecheck = $e->getMessage();
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			$productfound = false;

			foreach ( $results['results'] as $result ) {
				if ( $result['product_id'] == $keys[0] ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );
		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		//$shopids = explode('_',$this->shopid);

		$minPrice = null;
		$maxPrice = null;

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
			}
		}


		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':
				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {

			$query = 'https://api.webgains.com/2.0/products?key=' . urlencode( $this->apikey ) . '&campaignId=' . urlencode( $this->campaignId ) . '&programIds=' . urlencode( $this->programid ) . '&keywords=' . urlencode( $keyword );

			$query .= '&limit='.$itemsperpage.'&offset=' . ( ($x-1) * $itemsperpage );

			$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

			if ( is_wp_error( $result1 ) ) {
				$error_string = $result1->get_error_message();
				throw new Exception( $error_string );
			} else {
				$results = json_decode( $result1['body'], true );
			}

			foreach ( $results['results'] as $result ) {
				array_push( $products, $this->fill_product( $result ) );

				if(count($products) >= $maxCount)
					break;
			}

			if(count($results['results']) == 0 || count($products) >= $maxCount)
				break;
		}

		$mylist->products = $products;


		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}