<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_template_helper {

	public function createImagePlaceholderArray( $myproduct, $image, $itemIdx, $listid = '', $templateid = '', $tracking_id = '' ) {
		$placeholders = array();

		$parameters = new atkp_template_parameters( '', '', '', '', false, $tracking_id, $listid, $templateid );
		$formatter  = new atkp_formatter( $this, $parameters );

		if ( $myproduct->shop != null ) {
			$this->add_shop_info( $formatter, $myproduct->shop, $placeholders );
		}
		if ( $parameters->list != null ) {
			$this->add_list_info( $formatter, $parameters->list, $placeholders );
		}

		$placeholders['title']      = $formatter->get_title( $myproduct );
		$placeholders['listid']     = $listid;
		$placeholders['templateid'] = $templateid;
		$placeholders['shopid']     = $myproduct->shopid;
		$placeholders['productid']  = $myproduct->productid;

		$placeholders['smallimage']  = $formatter->get_image_smallimage( $myproduct, $image );
		$placeholders['mediumimage'] = $formatter->get_image_mediumimage( $myproduct, $image );
		$placeholders['image']       = $formatter->get_image_largeimage( $myproduct, $image );

		$placeholders['smallimageurl']  = $formatter->get_image_smallimageurl( $myproduct, $image );
		$placeholders['mediumimageurl'] = $formatter->get_image_mediumimageurl( $myproduct, $image );
		$placeholders['imageurl']       = $formatter->get_image_largeimageurl( $myproduct, $image );

		$placeholders['mark'] = $formatter->get_mark();

		$placeholders['productlink'] = $formatter->get_productlink( $myproduct );

		foreach ( $myproduct->displayfields as $key => $displayfield ) {

			$placeholders[ $key ] = $formatter->get_displayfield( $myproduct, $key );
		}

		$placeholders = apply_filters( 'atkp_modify_image_placeholders', $placeholders );

		return $placeholders;
	}

	public function createOfferPlaceholderArray( $myproduct, $offer, $itemIdx, $listid = '', $templateid = '', $minofferid = 0 ) {
		$placeholders = array();

		$parameters = new atkp_template_parameters( '', '', '', '', false, '', $listid, $templateid );
		$formatter  = new atkp_formatter( $this, $parameters );

		$shop = atkp_shop::load( $offer->shopid, true );

		if ( $shop != null ) {
			$this->add_shop_info( $formatter, $shop, $placeholders );
		}

		$placeholders['listid']     = $listid;
		$placeholders['templateid'] = $templateid;
		$placeholders['shopid']     = $offer->shopid;
		$placeholders['productid']  = $myproduct->productid;

		$placeholders['price']      = $formatter->get_offer_price( $offer, __( '%s', ATKP_PLUGIN_PREFIX ), __( 'Price not available', ATKP_PLUGIN_PREFIX ) );
		$placeholders['price_text'] = $formatter->get_offer_price( $offer, __( 'Price: %s', ATKP_PLUGIN_PREFIX ), __( 'Price not available', ATKP_PLUGIN_PREFIX ) );

		$placeholders['mark']     = $formatter->get_mark();
		$placeholders['linkmark'] = $formatter->get_mark();
		$placeholders['linktext'] = $formatter->get_offer_linktext();


		$placeholders['productlink'] = $placeholders['link'] = $formatter->get_offer_productlink( $offer );

		$placeholders['producturl']   = $formatter->get_offerproducturl( $offer );
		$placeholders['producttitle'] = $offer->title;

		$placeholders['availability'] = $offer->availability;
		$placeholders['shipping']     = $formatter->get_offer_shipping( $offer, '%s' );

		$placeholders['totalprice'] = $formatter->get_offer_total( $offer );


		$placeholders['shipping_text'] = $formatter->get_offer_shipping( $offer, 'Shipping: %s', __( 'Shipping: N/A', ATKP_PLUGIN_PREFIX ) );

		$placeholders['availability_text'] = $formatter->get_offer_availability( $offer );

		$placeholders['bestprice_badget'] = $formatter->get_offer_bestprice( $offer, $myproduct );

		$placeholders['offerindex'] = $itemIdx;

		$placeholders = apply_filters( 'atkp_modify_offer_placeholders', $placeholders );

		return $placeholders;
	}

	public function add_shop_info( atkp_formatter $formatter, atkp_shop $myshop, &$placeholders ) {

		$placeholders['shoplogo']         = $formatter->get_shop_logo( $myshop );
		$placeholders['smallshoplogo']    = $formatter->get_shop_smalllogo( $myshop );
		$placeholders['shoptitle']        = $formatter->get_shop_title( $myshop );
		$placeholders['shoplogourl']      = $formatter->get_shop_logourl( $myshop );
		$placeholders['smallshoplogourl'] = $formatter->get_shop_smalllogourl( $myshop );

		$displayfields = $formatter->get_shop_displayfields( $myshop );

		foreach ( $displayfields as $key => $value ) {
			$placeholders[ $key ] = $value;
		}
	}

	public function add_list_info( atkp_formatter $formatter, atkp_list $mylist, &$placeholders ) {
		$placeholders['listtitle'] = $formatter->get_list_title( $mylist );

		$displayfields = $formatter->get_list_displayfields( $mylist );

		foreach ( $displayfields as $key => $value ) {
			$placeholders[ $key ] = $value;
		}
	}

	public function createPlaceholderArray( $myproduct, $itemIdx, $cssContainerClass, $cssElementClass, $content, $addtocart = 'notset', $listid = '', $templateid = '', $tracking_id = '', $offerstemplate = '', $imagetemplate = '' ) {
		$placeholders = array();
		$shop         = null;
		$myprovider   = null;


		$parameters = new atkp_template_parameters( $content, $cssContainerClass, $cssElementClass, $addtocart, false, $tracking_id, $listid, $templateid, $offerstemplate, $imagetemplate );
		$formatter  = new atkp_formatter( $this, $parameters );

		if ( $myproduct->shop != null ) {
			$this->add_shop_info( $formatter, $myproduct->shop, $placeholders );
		}
		if ( $parameters->list != null ) {
			$this->add_list_info( $formatter, $parameters->list, $placeholders );
		}

		$placeholders['shopid'] = $myproduct->shopid;

		$placeholders['listid']    = $listid;
		$placeholders['listtitle'] = $formatter->get_listtitle( $myproduct );

		$placeholders['templateid'] = $templateid;

		$placeholders['mark'] = $formatter->get_mark();

		$placeholders['title']       = $formatter->get_title( $myproduct );
		$placeholders['short_title'] = $formatter->get_shorttitle( $myproduct );

		$placeholders['detailtext'] = $formatter->get_detailtext();

		$placeholders['detailurl']        = '';
		$placeholders['detaillink']       = '';
		$placeholders['detailvisibility'] = 'visibility: collapse;';

		$placeholders['detailurl']  = $formatter->get_detailurl( $myproduct );
		$placeholders['detaillink'] = $formatter->get_detaillink( $myproduct );

		if ( $placeholders['detaillink'] != '' ) {
			$placeholders['detailvisibility'] = 'visibility: visible;';
		}

		$placeholders['woocommerceproductid']  = '';
		$placeholders['woocommerceurl']        = '';
		$placeholders['woocommercelink']       = '';
		$placeholders['woocommercetext']       = '';
		$placeholders['woocommercevisibility'] = 'visibility: collapse;';

		if ( atkp_options::$loader->get_woo_module_enabled() ) {
			try {
				$woo_product = atkp_product::get_woo_product( $myproduct->productid );

				if ( $woo_product != null ) {
					$placeholders['woocommerceproductid'] = $woo_product->ID;
					$placeholders['woocommercetext']      = $formatter->get_woocommercetitle( $myproduct, $woo_product );

					$placeholders['woocommerceurl']  = $formatter->get_woocommerceurl( $myproduct, $woo_product );
					$placeholders['woocommercelink'] = $formatter->get_woocommercelink( $myproduct, $woo_product );

					$placeholders['woocommercevisibility'] = 'visibility: visible;';
				}
			} catch ( Exception $e ) {
				//TODO: log
			}
		}


		$placeholders['productid'] = $myproduct->productid;

		$placeholders['asin']         = $myproduct->asin;
		$placeholders['ean']          = $myproduct->ean;
		$placeholders['isbn']         = $myproduct->isbn;
		$placeholders['brand']        = $myproduct->brand;
		$placeholders['productgroup'] = $myproduct->productgroup;
		$placeholders['availability'] = $myproduct->availability;
		$placeholders['shipping']     = $formatter->get_shipping( $myproduct, '%s', '' );

		$placeholders['releasedate'] = $myproduct->releasedate;


		$placeholders['manufacturer']    = $myproduct->manufacturer;
		$placeholders['author']          = $myproduct->author;
		$placeholders['brand']           = $myproduct->brand;
		$placeholders['productcategory'] = $myproduct->productgroup;

		//Offers section
		if ( ! is_array( $myproduct->offers ) ) {
			$offers = array();
		} else {
			$offers = $myproduct->offers;
		}

		$alloffers = $formatter->get_offers( $myproduct, true );
		$minoffer  = $formatter->get_minoffer( $myproduct, true, $alloffers );
		$maxoffer  = $formatter->get_maxoffer( $myproduct, true, $alloffers );

		$placeholders['offerscount'] = $formatter->get_offercount( $alloffers );


		$placeholders['totalprice'] = $formatter->get_total( $myproduct );

		$placeholders['minprice']     = $minoffer == null ? '' : $formatter->get_offer_price( $minoffer );
		$placeholders['minprice_url'] = $minoffer == null ? '' : $formatter->get_offer_url( $minoffer );


		$placeholders['minprice_shoptitle']        = $minoffer == null ? '' : $minoffer->shop->get_title();
		$placeholders['minprice_shoplogourl']      = $minoffer == null ? '' : $minoffer->shop->get_logourl();
		$placeholders['minprice_smallshoplogourl'] = $minoffer == null ? '' : $minoffer->shop->get_smalllogourl();


		$placeholders['maxprice']     = $maxoffer == null ? '' : $formatter->get_offer_price( $maxoffer );
		$placeholders['maxprice_url'] = $maxoffer == null ? '' : $formatter->get_offer_url( $maxoffer );


		$placeholders['maxprice_shoptitle']        = $maxoffer == null ? '' : $maxoffer->shop->get_title();
		$placeholders['maxprice_shoplogourl']      = $maxoffer == null ? '' : $maxoffer->shop->get_logourl();
		$placeholders['maxprice_smallshoplogourl'] = $maxoffer == null ? '' : $maxoffer->shop->get_smalllogourl();

		//offers section

		for ( $i = 1; $i <= 5; $i ++ ) {
			$placeholders[ 'thumbimages_' . $i ]  = '';
			$placeholders[ 'mediumimages_' . $i ] = '';
			$placeholders[ 'images_' . $i ]       = '';

			$placeholders[ 'thumbimagesurl_' . $i ]  = '';
			$placeholders[ 'mediumimagesurl_' . $i ] = '';
			$placeholders[ 'imagesurl_' . $i ]       = '';
		}

		$idx = 1;
		if ( is_array( $myproduct->images ) ) {
			foreach ( $myproduct->images as $newimage ) {

				$placeholders[ 'thumbimages_' . $idx ]  = $formatter->get_image_smallimage( $myproduct, $newimage );
				$placeholders[ 'mediumimages_' . $idx ] = $formatter->get_image_mediumimage( $myproduct, $newimage );
				$placeholders[ 'images_' . $idx ]       = $formatter->get_image_largeimage( $myproduct, $newimage );

				$placeholders[ 'thumbimagesurl_' . $idx ]  = $formatter->get_image_smallimageurl( $myproduct, $newimage );
				$placeholders[ 'mediumimagesurl_' . $idx ] = $formatter->get_image_mediumimageurl( $myproduct, $newimage );
				$placeholders[ 'imagesurl_' . $idx ]       = $formatter->get_image_largeimageurl( $myproduct, $newimage );

				$idx += 1;
			}
		}

		$placeholders['smallimageurl']  = $formatter->get_smallimageurl( $myproduct );
		$placeholders['mediumimageurl'] = $formatter->get_mediumnimageurl( $myproduct );
		$placeholders['largeimageurl']  = $formatter->get_largeimageurl( $myproduct );

		$placeholders['smallimage']  = $formatter->get_smallimage( $myproduct );
		$placeholders['mediumimage'] = $formatter->get_mediumnimage( $myproduct );
		$placeholders['largeimage']  = $formatter->get_largeimage( $myproduct );
		$placeholders['by_text']     = $formatter->get_bytext( $myproduct );

		$placeholders['productlink'] = $formatter->get_productlink( $myproduct );
		$placeholders['cartlink']    = $formatter->get_cartlink( $myproduct );


		$placeholders['producturl']         = $formatter->get_producturl( $myproduct );
		$placeholders['customerreviewsurl'] = $formatter->get_customerreviewsurl( $myproduct );

		$listurl = $formatter->get_listurl();

		if ( $listurl != '' ) {
			$placeholders['hidelistlink'] = '';
			$placeholders['listlink']     = $formatter->get_listlink();
			$placeholders['listurl']      = $listurl;
			$placeholders['listlinktext'] = __( 'Show me more products', ATKP_PLUGIN_PREFIX );

		} else {
			$placeholders['hidelistlink'] = 'style="display:none"';
			$placeholders['listurl']      = '';
			$placeholders['listlink']     = '';
			$placeholders['listlinktext'] = '';
		}

		$placeholders['link']     = $formatter->get_button_link( $myproduct );
		$placeholders['linktext'] = $formatter->get_button_text( $myproduct );
		$placeholders['linkmark'] = $formatter->get_button_mark( $myproduct );

		$placeholders['titlelink']     = $formatter->get_title_link( $myproduct );
		$placeholders['titlelinkmark'] = $formatter->get_title_mark( $myproduct );

		$placeholders['bestseller_text']   = $formatter->get_bestseller_text( $itemIdx );
		$placeholders['bestseller_number'] = $formatter->get_bestseller_number( $itemIdx );

		$placeholders['reviewsurl'] = $myproduct->reviewsurl;

		$placeholders['reviewcount2'] = '';

		if ( ATKPSettings::$showstarrating ) {

			if ( $myproduct->rating == '' ) {
				$myproduct->rating = 0;
			}

			if ( $myproduct->rating == 0 && get_option( ATKP_PLUGIN_PREFIX . '_hideemptystars', 0 ) ) {
				$placeholders['rating']      = '';
				$placeholders['star_rating'] = '';
			} else {
				$placeholders['rating']       = $formatter->get_rating_text( $myproduct );
				$placeholders['star_rating']  = $formatter->get_star_rating( $myproduct );
				$placeholders['reviewcount2'] = $placeholders['rating'];
			}
		} else {
			$placeholders['rating']      = '';
			$placeholders['star_rating'] = '';
		}

		if ( $myproduct->reviewcount == '' ) {
			$myproduct->reviewcount = 0;
		}

		if ( $myproduct->isownreview ) {
			$reviewstext = __( 'Show review', ATKP_PLUGIN_PREFIX );

			if ( ATKPSettings::$showrating ) {
				$placeholders['reviewcount'] = $reviewstext;
			}

			if ( $myproduct->reviewsurl != '' && ATKPSettings::$showrating ) {

				$placeholders['reviewslink'] = $formatter->get_reviewslink( $myproduct );
				$placeholders['markrating']  = '';
			} else {
				$placeholders['reviewslink'] = '';
				$placeholders['markrating']  = '';
			}
		} else {
			$reviewstextNull = __( 'Show customer reviews', ATKP_PLUGIN_PREFIX );
			$reviewstext     = __( '%s customer reviews', ATKP_PLUGIN_PREFIX );
			$reviewstext2    = __( '1 customer review', ATKP_PLUGIN_PREFIX );

			$placeholders['reviewcount'] = '';

			if ( ATKPSettings::$showrating ) {
				if ( $myproduct->reviewcount == '' || $myproduct->reviewcount == 0 ) {

					if ( get_option( ATKP_PLUGIN_PREFIX . '_hideemptyrating', 0 ) ) {
						$placeholders['reviewcount'] = $reviewstextNull = '';
					} else {
						$placeholders['reviewcount'] = $reviewstextNull;
					}

				} else {
					$placeholders['reviewcount'] = sprintf( _n( $reviewstext2, $reviewstext, $myproduct->reviewcount, ATKP_PLUGIN_PREFIX ), $myproduct->reviewcount );

				}
			}

			if ( $myproduct->customerreviewurl != '' && ATKPSettings::$showrating && $placeholders['reviewcount'] != '' ) {
				$placeholders['reviewslink'] = $formatter->get_reviewslink( ( $myproduct ) );
				//$this->create_external_link( $myproduct->customerreviewurl, $placeholders['reviewcount'], $myproduct->title, $listid, $templateid, $myproduct->shopid, 4, $tracking_id );
				$placeholders['markrating'] = $placeholders['mark'];
			} else {
				$placeholders['reviewslink'] = '';

				if ( $placeholders['reviewcount'] == $reviewstextNull ) {
					$placeholders['reviewcount'] = '';
				}
				$placeholders['markrating'] = '';
			}

		}

		$placeholders['prime_icon'] = $formatter->get_primelogo( $myproduct );

		if ( ! ATKPSettings::$showpricediscount ) {
			$placeholders['save_percentage']  = '';
			$placeholders['save_percentage_'] = '';
		} else {
			$placeholders['save_percentage']  = $formatter->get_percentagesaved( $myproduct, '-%s%%' );
			$placeholders['save_percentage_'] = $formatter->get_percentagesaved( $myproduct, '(%s)' );
		}

		if ( $myproduct->amountsaved == '' || ! ATKPSettings::$showpricediscount ) {
			$placeholders['save_text']   = '';
			$placeholders['save_amount'] = '';

		} else {
			$placeholders['save_amount'] = $myproduct->amountsaved;

			if ( $myproduct->percentagesaved != '' && $myproduct->percentagesaved != '0' ) {
				$perc = ' (%s%%)';
			} else {
				$perc = '';
			}

			$placeholders['save_text'] = $formatter->get_savetext( $myproduct, __( 'You Save: %s', ATKP_PLUGIN_PREFIX ) ) . $formatter->get_percentagesaved( $myproduct, $perc );
		}
		if ( ! ATKPSettings::$showprice || ! ATKPSettings::$showpricediscount ) {
			$placeholders['listprice_text'] = '';
		} else {
			$placeholders['listprice_text'] = $formatter->get_listpricetext( $myproduct, __( 'List Price: %s', ATKP_PLUGIN_PREFIX ) );
		}

		if ( ! ATKPSettings::$showprice ) {
			$placeholders['listprice'] = '';
		} else {
			$placeholders['listprice'] = $formatter->get_listpricetext( $myproduct, __( '%s', ATKP_PLUGIN_PREFIX ) );
		}

		if ( ! ATKPSettings::$showprice ) {
			$placeholders['price'] = '';
		} else {
			$placeholders['price'] = $formatter->get_pricetext( $myproduct, __( '%s', ATKP_PLUGIN_PREFIX ), __( 'Price not available', ATKP_PLUGIN_PREFIX ) );
		}

		if ( ! ATKPSettings::$showprice ) {
			$placeholders['price_text'] = '';
		} else {
			$placeholders['price_text'] = $formatter->get_pricetext( $myproduct, __( 'Price: %s', ATKP_PLUGIN_PREFIX ), __( 'Price not available', ATKP_PLUGIN_PREFIX ) );
		}

		$placeholders['info_text'] = $formatter->get_infotext( $myproduct );

		$placeholders['predicate_id']          = $formatter->get_predicate_id( $myproduct );
		$placeholders['predicate_text']        = $formatter->get_predicate_text( $myproduct );
		$placeholders['predicate_color']       = $formatter->get_predicate_color( ( $myproduct ) );
		$placeholders['predicate_borderstyle'] = $formatter->get_predicate_borderstyle( ( $myproduct ) );

		$placeholders['testresult'] = $formatter->get_testresult( $myproduct );

		$placeholders['pro']    = $formatter->get_proslist( $myproduct );
		$placeholders['contra'] = $formatter->get_contralist( $myproduct );

		$placeholders['post_list'] = $formatter->get_postlist( $myproduct );

		$placeholders['features_text']    = $formatter->get_featuretext( $myproduct );
		$placeholders['description_text'] = $formatter->get_descriptiontext( $myproduct );

		$placeholders['priceinfo_text'] = $formatter->get_priceinfotext();
		$placeholders['cssclass']       = $cssElementClass;
		$placeholders['content']        = $content;


		if ( ATKPSettings::$show_moreoffers ) {
			if ( $templateid != '' ) {
				$offerstemplate_temp = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template' );
				if ( $offerstemplate_temp != '' ) {
					$offerstemplate = $offerstemplate_temp;
				}
			}


			$moreoffers = $this->createOutput( array( $myproduct ), '', $offerstemplate == '' || $offerstemplate == null ? 'moreoffers' : $offerstemplate, 'atkp-moreoffersinfo', '', '', '', 0, 2 );

			$placeholders['moreoffers'] = $moreoffers;
		} else {
			$placeholders['moreoffers'] = '';
		}

		foreach ( $myproduct->displayfields as $key => $displayfield ) {

			$placeholders[ $key ] = $formatter->get_displayfield( $myproduct, $key );
		}

		$placeholders['total_rating'] = $formatter->get_wp_review_rating( $myproduct );

		$placeholders['refresh_date'] = $formatter->get_refreshdate( $myproduct );
		$placeholders['refresh_time'] = $formatter->get_refreshtime( $myproduct );

		$placeholders['disclaimer'] = $formatter->get_disclaimer( $myproduct );

		$placeholders = apply_filters( 'atkp_modify_placeholders', $placeholders );

		return $placeholders;
	}

	public function getPlaceholders( $fieldtype = '' ) {

		$placeholders = $this->createPlaceholderArray( new atkp_product(), 1, '', '', false );

		$newfields  = array();
		$taxonomies = array();
		if ( ATKP_PLUGIN_VERSION >= 30 ) {
			$newfields = atkp_udfield::load_fields();

			$taxonomies = atkp_udtaxonomy::load_taxonomies();
		}

		$acfgroups = null;

		if ( function_exists( 'get_fields' ) ) {
			$args        = array(
				'posts_per_page' => - 1,
				'post_type'      => 'acf',
			);
			$field_types = apply_filters( 'wcf_acf_field_type', array(
				'text',
				'textarea',
				'select',
				'checkbox',
				'radio',
				'true_false'
			) );

			$acfgroups = get_posts( $args );
		}

		$myplaceholders = array();

		$filterplaceholders = array();

		foreach ( array_keys( $placeholders ) as $placeholder ) {

			switch ( $placeholder ) {
				case 'bestseller_number':
				case 'bestseller_text':
				case 'cartlink':
				case 'content':
				case 'cssclass':
				case 'hidelistlink':
				case 'info_text':
				case 'link':
				case 'linktext':
				case 'mark':
				case 'markrating':
				case 'productid':
				case 'productlink':
				case 'reviewslink':
				case 'listurl':
				case 'listlink':
				case 'listlinktext':
				case 'reviewcount2':
				case 'priceinfo_text':
				case 'shopid':
				case 'listid':
				case 'templateid':
				case 'moreoffers':
				case 'shoplogourl':
				case 'smallshoplogourl':
				case 'listtitle':
				case 'detailtext':
				case 'detailvisibility':
				case 'detaillink':
				case 'linkmark':
				case 'titlelinkmark':
				case 'titlelink':
				case 'predicate_id':
				case 'predicate_color':
				case 'predicate_borderstyle':
					break;
				case 'refresh_date':
					$myplaceholders[ $placeholder ] = __( 'Update date', ATKP_PLUGIN_PREFIX );
					break;
				case 'refresh_time':
					$myplaceholders[ $placeholder ] = __( 'Update time', ATKP_PLUGIN_PREFIX );
					break;
				case 'shipping':
					$myplaceholders[ $placeholder ] = __( 'Shipping', ATKP_PLUGIN_PREFIX );
					break;
				case 'shoptitle':
					$myplaceholders[ $placeholder ] = __( 'Shop title', ATKP_PLUGIN_PREFIX );
					break;
				case 'smallshoplogo':
					$myplaceholders[ $placeholder ] = __( 'Shop logo (small)', ATKP_PLUGIN_PREFIX );
					break;
				case 'shoplogo':
					$myplaceholders[ $placeholder ] = __( 'Shop logo', ATKP_PLUGIN_PREFIX );
					break;
				case 'title':
					$myplaceholders[ $placeholder ] = __( 'Title', ATKP_PLUGIN_PREFIX );
					break;
				case 'short_title':
					$myplaceholders[ $placeholder ] = __( 'Title (short)', ATKP_PLUGIN_PREFIX );
					break;
				case 'asin':
					$myplaceholders[ $placeholder ] = __( 'ASIN', ATKP_PLUGIN_PREFIX );
					break;
				case 'isbn':
					$myplaceholders[ $placeholder ] = __( 'ISBN', ATKP_PLUGIN_PREFIX );
					break;
				case 'ean':
					$myplaceholders[ $placeholder ] = __( 'EAN', ATKP_PLUGIN_PREFIX );
					break;
				case 'brand':
					$myplaceholders[ $placeholder ] = __( 'Brand', ATKP_PLUGIN_PREFIX );
					break;
				case 'productgroup':
					$myplaceholders[ $placeholder ] = __( 'Product group', ATKP_PLUGIN_PREFIX );
					break;
				case 'availability':
					$myplaceholders[ $placeholder ] = __( 'Availability', ATKP_PLUGIN_PREFIX );
					break;
				case 'smallimageurl':
					$myplaceholders[ $placeholder ] = __( 'Image small URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'mediumimageurl':
					$myplaceholders[ $placeholder ] = __( 'Image medium URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'largeimageurl':
					$myplaceholders[ $placeholder ] = __( 'Image large URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'smallimage':
					$myplaceholders[ $placeholder ] = __( 'Image small', ATKP_PLUGIN_PREFIX );
					break;
				case 'mediumimage':
					$myplaceholders[ $placeholder ] = __( 'Image medium', ATKP_PLUGIN_PREFIX );
					break;
				case 'largeimage':
					$myplaceholders[ $placeholder ] = __( 'Image large', ATKP_PLUGIN_PREFIX );
					break;

				case 'thumbimages_1':
				case 'thumbimages_2':
				case 'thumbimages_3':
				case 'thumbimages_4':
				case 'thumbimages_5':
				case 'thumbimages_6':
					$splitted                       = explode( '_', $placeholder );
					$myplaceholders[ $placeholder ] = sprintf( __( 'Image small %s', ATKP_PLUGIN_PREFIX ), $splitted[1] );
					break;
				case 'mediumimages_1':
				case 'mediumimages_2':
				case 'mediumimages_3':
				case 'mediumimages_4':
				case 'mediumimages_5':
				case 'mediumimages_6':
					$splitted                       = explode( '_', $placeholder );
					$myplaceholders[ $placeholder ] = sprintf( __( 'Image medium %s', ATKP_PLUGIN_PREFIX ), $splitted[1] );
					break;
				case 'images_1':
				case 'images_2':
				case 'images_3':
				case 'images_4':
				case 'images_5':
				case 'images_6':
					$splitted                       = explode( '_', $placeholder );
					$myplaceholders[ $placeholder ] = sprintf( __( 'Image large %s', ATKP_PLUGIN_PREFIX ), $splitted[1] );
					break;
				case 'by_text':
					$myplaceholders[ $placeholder ] = __( '"by"-Text', ATKP_PLUGIN_PREFIX );
					break;
				case 'producturl':
					$myplaceholders[ $placeholder ] = __( 'Product page URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'customerreviewsurl':
					$myplaceholders[ $placeholder ] = __( 'Customer Reviews URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'reviewsurl':
					$myplaceholders[ $placeholder ] = __( 'Review URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'rating':
					$myplaceholders[ $placeholder ] = __( 'Rating', ATKP_PLUGIN_PREFIX );
					break;
				case 'star_rating':
					$myplaceholders[ $placeholder ] = __( 'Star Rating', ATKP_PLUGIN_PREFIX );
					break;
				case 'reviewcount':
					$myplaceholders[ $placeholder ] = __( 'Amount of reviews', ATKP_PLUGIN_PREFIX );
					break;
				case 'prime_icon':
					$myplaceholders[ $placeholder ] = __( 'Is prime', ATKP_PLUGIN_PREFIX );
					break;
				case 'save_percentage':
					$myplaceholders[ $placeholder ] = __( 'Percentage saved', ATKP_PLUGIN_PREFIX );
					break;
				case 'save_percentage_':
					$myplaceholders[ $placeholder ] = __( '(Percentage saved)', ATKP_PLUGIN_PREFIX );
					break;
				case 'save_text':
					$myplaceholders[ $placeholder ] = __( 'You Save', ATKP_PLUGIN_PREFIX );
					break;
				case 'save_amount':
					$myplaceholders[ $placeholder ] = __( 'Amount saved', ATKP_PLUGIN_PREFIX );
					break;
				case 'listprice':
					$myplaceholders[ $placeholder ] = __( 'List price', ATKP_PLUGIN_PREFIX );
					break;
				case 'listprice_text':
					$myplaceholders[ $placeholder ] = __( 'List price (Text)', ATKP_PLUGIN_PREFIX );
					break;
				case 'price':
					$myplaceholders[ $placeholder ] = __( 'Price', ATKP_PLUGIN_PREFIX );
					break;
				case 'price_text':
					$myplaceholders[ $placeholder ] = __( 'Price (Text)', ATKP_PLUGIN_PREFIX );
					break;
				case 'features_text':
					$myplaceholders[ $placeholder ] = __( 'Features', ATKP_PLUGIN_PREFIX );
					break;
				case 'description_text':
					$myplaceholders[ $placeholder ] = __( 'Description', ATKP_PLUGIN_PREFIX );
					break;
				case 'shopcustomfield1':
					$myplaceholders[ $placeholder ] = __( 'Shop: Custom field 1', ATKP_PLUGIN_PREFIX );
					break;
				case 'shopcustomfield2':
					$myplaceholders[ $placeholder ] = __( 'Shop: Custom field 2', ATKP_PLUGIN_PREFIX );
					break;
				case 'shopcustomfield3':
					$myplaceholders[ $placeholder ] = __( 'Shop: Custom field 3', ATKP_PLUGIN_PREFIX );
					break;
				case 'detailurl':
					$myplaceholders[ $placeholder ] = __( 'Internal product page URL', ATKP_PLUGIN_PREFIX );
					break;
				case 'testresult':
					$myplaceholders[ $placeholder ] = __( 'Test Badget', ATKP_PLUGIN_PREFIX );
					break;
				case 'pro':
					$myplaceholders[ $placeholder ] = __( 'Pro arguments', ATKP_PLUGIN_PREFIX );
					break;
				case 'contra':
					$myplaceholders[ $placeholder ] = __( 'Contra arguments', ATKP_PLUGIN_PREFIX );
					break;
				case 'post_list':
					$myplaceholders[ $placeholder ] = __( 'List of posts (main product)', ATKP_PLUGIN_PREFIX );
					break;
				case 'total_rating':
					$myplaceholders[ $placeholder ] = __( 'Total rating', ATKP_PLUGIN_PREFIX );
					break;
				default:
					$myplaceholders[ $placeholder ] = $placeholder;

					if ( $newfields != null ) {
						foreach ( $newfields as $newfield ) {
							if ( 'customfield_' . $newfield->name == $placeholder ) {
								$myplaceholders[ $placeholder ] = $newfield->caption . ' (' . $placeholder . ')';

								if ( $fieldtype != '' && $fieldtype == 'html' && $newfield->type == 5 ) {
									$filterplaceholders[ $placeholder ] = $newfield->caption;
								}

								break;
							}
						}
					}

					$taxonomies = atkp_udtaxonomy::load_taxonomies();


					if ( $taxonomies != null ) {
						foreach ( $taxonomies as $taxonomy ) {
							$fieldname = '';

							if ( ! $taxonomy->issystemfield ) {
								$fieldname = 'customtaxonomy_' . $taxonomy->name;
							} else {
								$fieldname = $taxonomy->name;
							}

							if ( $fieldname == $placeholder ) {
								$myplaceholders[ $placeholder ] = $taxonomy->caption == '' ? $taxonomy->name : $taxonomy->caption . ' (' . $taxonomy->name . ')';
							}
						}
					}
					break;
			}
		}

		if ( $fieldtype != '' ) {
			return $filterplaceholders;
		} else {
			return $myplaceholders;
		}
	}

	public function createLiveOutput( $shopids, $templatelive, $template, $filterstr, $elementcss, $containercss, $limit ) {
		$placeholders = array();

		$templatetype = 1;
		$myheader     = '';
		$mytemplate   = '';
		$myfooter     = '';

		if ( is_numeric( $template ) && ATKP_PLUGIN_VERSION >= 30 ) {

			$templatefound = get_post( $template );

			if ( isset( $templatefound ) && $templatefound != null && ( $templatefound->post_status == 'publish' || $templatefound->post_status == 'draft' ) ) {
				$templatetype = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_template_type', true );

				$myheader   = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_header', true ) );
				$myfooter   = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_footer', true ) );
				$mytemplate = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body', true ) );
			} else {
				return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
			}

		} else {
			$templates = atkp_template::get_directories();

			$templatepath = '';

			foreach ( $templates as $temp ) {
				if ( file_exists( $temp . '/' . $template . '.php' ) ) {
					$templatepath = $temp . '/' . $template . '.php';
					break;
				}
			}

			if ( $templatepath == '' ) {
				$template     = 'default_live';
				$templatepath = ATKP_TEMPLATEDIR . '/' . $template . '.php';
			}

			$templateclass = 'atkp_template_' . $template;

			if ( file_exists( $templatepath ) ) {

				require_once $templatepath;

				$defaulttemplate = new $templateclass();
				$myheader        = $defaulttemplate->get_header();
				$mytemplate      = $defaulttemplate->get_detail();
				$myfooter        = $defaulttemplate->get_footer();
			} else {
				return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
			}
		}

		$shops = atkp_shop::get_list( '', true );

		$resultValue = '';

		$endpointurl = ATKPTools::get_endpointurl();

		$resultValue .= $myheader;

		$formatter = new atkp_formatter( $this, null );

		foreach ( $shops as $shop ) {
			if ( count( $shopids ) > 0 && ! in_array( $shop->id, $shopids ) ) {
				continue;
			}

			if ( $shop != null ) {
				$this->add_shop_info( $formatter, $shop, $placeholders );
			}

			$placeholders['shopid']      = esc_attr( $shop->id );
			$placeholders['filterstr']   = esc_attr( $filterstr );
			$placeholders['endpointurl'] = esc_attr( $endpointurl );
			$placeholders['template']    = esc_attr( $templatelive );

			$placeholders['elementcess']  = esc_attr( $elementcss );
			$placeholders['containercss'] = esc_attr( $containercss );
			$placeholders['limit']        = esc_attr( $limit );

			$placeholders['init'] = esc_attr( ! ATKPTools::exists_get_parameter( 'search' ) ? "1" : "0" );

			$mydetail = $this->replace_placeholders( $mytemplate, $placeholders );

			$resultValue .= $mydetail;
		}

		$resultValue .= $myfooter;


		return $resultValue;
	}

	public function createOutput( $products, $content = '', $template = '', $cssContainerClass = '', $cssElementClass = '', $addtocart = '', $listid = '', $hidedisclaimer = 0, $templatetypedefault = 0, $tracking_id = '', $offerstemplate = '', $imagetemplate = '', $itemsPerPage = 0, $max_num_pages = 0, $found_posts = 0 ) {

		$products = apply_filters( 'atkp_modify_products', $products );

		if ( $offerstemplate == '' || $offerstemplate == null ) {
			$offerstemplate = ATKPSettings::$moreoffers_template;
		}
		$imagetemplate = '';

		$myheader         = '';
		$body_header      = '';
		$detail_header    = '';
		$detail_footer    = '';
		$customdisclaimer = null;

		$mytemplate      = '';
		$body_footer     = '';
		$myfooter        = '';
		$disclaimer      = '';
		$disclaimerclass = '';

		$maxoffers        = 0;
		$templatetype     = 1;
		$includemainoffer = false;

		if ( ATKPSettings::$access_show_disclaimer ) {
			$disclaimer = ATKPSettings::$access_disclaimer_text;
		}

		$isblade = false;

		$views = atkp_template::get_blade_directories();

		switch ( $template ) {
			case 'detaillist':
			case 'comparetable':
				$templatetype = 4;
				break;
			case 'datasheet':

				$myheader          = '<table class="atkp-datasheet">';
				$mytemplate        = '';
				$fieldgroupasgroup = 0;

				$showmanufacturer = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer', 1 );

				if ( $showmanufacturer ) {
					$mytemplate .= '<tr><td class="atkp-datasheet-caption">' . __( 'Manufacturer', ATKP_PLUGIN_PREFIX ) . '</td><td class="atkp-datasheet-value">%manufacturer%</td></tr>';
				}

				$maxproducts = 0;


				if ( isset( $products ) && count( $products ) > 0 ) {
					$comparevalues = $this->get_autocomparevalues( $products, $template, $fieldgroupasgroup );

					foreach ( $comparevalues as $comparegroup ) {
						$isgroup = $comparegroup->isgroup == true;

						$comparings = array();

						if ( $isgroup ) {

							$comparings = $comparegroup->values;
							if ( $comparegroup->isvisible ) {
								$mytemplate .= '<tr  class="atkp-producttable-grouprow"><td colspan="' . esc_attr( $maxproducts <= 0 ? 10 : $maxproducts + 1 ) . '"><span class="atkp-producttable-groupheader">' . $comparegroup->caption . '</span><span class="atkp-producttable-groupdescription">' . $comparegroup->description . '</span></td></tr>';
							}
						} else {
							array_push( $comparings, $comparegroup );
						}

						$comparefields = array();

						foreach ( $comparings as $comparerow ) {


							$caption = $comparerow->caption;
							if ( $comparerow->description != '' ) {
								$caption = '<div class="atkp-tooltip">' . $comparerow->caption . '<span class="atkp-tooltiptext">' . $comparerow->description . '</span></div>';
							}


							$mytemplate .= '<tr><td class="atkp-datasheet-caption">' . $caption . '</td><td class="atkp-datasheet-value">' . $comparerow->detail . '</td></tr>';

							array_push( $comparefields, $comparerow->name );


						}
					}
				}


				$myfooter = '</table>';

				break;

			default:
				if ( is_numeric( $template ) && ATKP_PLUGIN_VERSION >= 30 ) {

					$templatefound = get_post( $template );

					if ( isset( $templatefound ) && $templatefound != null && ( $templatefound->post_status == 'publish' || $templatefound->post_status == 'draft' ) ) {
						$templatetype      = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_template_type', true );
						$disabledisclaimer = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer', true );

						$myheader = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_header', true ) );
						$myfooter = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_footer', true ) );

						switch ( $templatetype ) {
							case 4:
								//vergleichstabelle
								break;
							default:

								$detail_header = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_detail_header', true ) );
								$detail_footer = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_detail_footer', true ) );
								$body_header   = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body_header', true ) );
								$mytemplate    = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body', true ) );

								$body_footer = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body_footer', true ) );


								if ( $templatetype == 2 ) {
									$includemainoffer = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_includemainoffer', true );
									$maxoffers        = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_maxoffers', true );
								}

								break;
							case 6:
								$isblade    = true;
								$mytemplate = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body', true ) );

								break;
						}

						$disclaimerclass = 'atkp-disclaimer-' . $templatefound->ID;

						if ( $disabledisclaimer ) {
							$hidedisclaimer = true;
						}
					} else {
						return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
					}

				} else {
					$templates = atkp_template::get_directories();

					$templatepath = '';

					foreach ( $templates as $temp ) {
						if ( file_exists( $temp . '/' . $template . '.php' ) ) {
							$templatepath = $temp . '/' . $template . '.php';
							break;
						}
					}

					//is blade template

					if ( $templatepath == '' ) {
						$templatepath = '';
						foreach ( $views as $view ) {
							if ( file_exists( $view . '/' . $template . '.blade.php' ) ) {
								$templatepath = $view . '/' . $template . '.blade.php';
								break;
							}
						}

						if ( $templatepath != '' ) {
							$isblade = true;
						}
					}


					//is blade template


					//existiert die vorlage auch nicht im atkp-verzeichnis dann fallback auf wide
					if ( $templatepath == '' ) {
						$template     = 'wide';
						$templatepath = ATKP_TEMPLATEDIR . '/' . $template . '.php';
					}


					$templateclass = 'atkp_template_' . $template;

					if ( file_exists( $templatepath ) && ! $isblade ) {

						require_once $templatepath;

						$defaulttemplate = new $templateclass();
						$myheader        = $defaulttemplate->get_header();
						$body_header     = $defaulttemplate->get_body_header();
						$detail_header   = $defaulttemplate->get_detail_header();
						$mytemplate      = $defaulttemplate->get_detail();
						$detail_footer   = $defaulttemplate->get_detail_footer();
						$body_footer     = $defaulttemplate->get_body_footer();
						$myfooter        = $defaulttemplate->get_footer();

						if ( $defaulttemplate->get_hidedisclaimer() != null ) {
							$hidedisclaimer = (bool) $defaulttemplate->get_hidedisclaimer();
						}
						if ( $defaulttemplate->get_includemainoffer() != null ) {
							$includemainoffer = (bool) $defaulttemplate->get_includemainoffer();
						}
						if ( $defaulttemplate->get_templatetype() != null ) {
							$templatetype = intval( $defaulttemplate->get_templatetype() );
						}
						if ( $defaulttemplate->get_customdisclaimer() != null ) {
							$customdisclaimer = $defaulttemplate->get_customdisclaimer();
						}
						if ( $defaulttemplate->get_maxoffercount() != null ) {
							$maxoffers = intval( $defaulttemplate->get_maxoffercount() );
						}


						//special hack für die schmale box
						if ( $template == 'box' ) {
							$disclaimerclass = 'atkp-small-disclaimer';

							if ( strpos( $cssElementClass, 'atkp-widget' ) !== false ) {
								$disclaimerclass .= ' atkp-widget';
							}
						}
					} else if ( file_exists( $templatepath ) && $isblade ) {
						$mytemplate = file_get_contents( $templatepath );
					} else {
						return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
					}
				}
				break;
		}

		if ( $templatetypedefault != 0 ) {
			$templatetype = $templatetypedefault;
		}

		$resultValue = '';

		$hideoutput = false;

		if ( $isblade ) {
			$parameters = new atkp_template_parameters( $content, $cssContainerClass, $cssElementClass, $addtocart, $hidedisclaimer, $tracking_id, $listid, $template, $offerstemplate, $imagetemplate );

			$resultValue = $this->run_blade( $mytemplate, $products, $views, $parameters );

			$resultValue .= $this->generate_pagination( $max_num_pages );
		} else {

			if ( ! ATKPSettings::$disablestyles ) {
				$resultValue = '<div class="atkp-container atkp-container'.$template.' ' . $cssContainerClass . '">';
			} else {
				$resultValue = '';
			}

			$firstproduct      = null;
			$firstplaceholders = null;

			if ( sizeof( $products ) > 0 ) {
				$firstproduct = $products[0];

				//if($templatetype != 2 && $templatetype != 3)
				//schlag mich dafür!!
				$bak                           = ATKPSettings::$show_moreoffers;
				ATKPSettings::$show_moreoffers = false;
				$firstplaceholders             = $this->createPlaceholderArray( $firstproduct, 1, $cssContainerClass, $cssElementClass, $content, $addtocart, $listid, $template, $tracking_id );
				ATKPSettings::$show_moreoffers = $bak;
				//else
				//    $firstplaceholders = array();


				$firstplaceholders['refresh_date'] = $firstproduct->updatedon == '' ? '' : ATKPTools::get_formatted_date( $firstproduct->updatedon );
				$firstplaceholders['refresh_time'] = $firstproduct->updatedon == '' ? '' : ATKPTools::get_formatted_time( $firstproduct->updatedon );

			}


			$productplaceholders = array();


			$count = 1;
			foreach ( $products as $myproduct ) {

				switch ( $templatetype ) {

					case 4:
					case 1:
						//product
						$placeholders = $this->createPlaceholderArray( $myproduct, $count, $cssContainerClass, $cssElementClass, $content, $addtocart, $listid, $template, $tracking_id, $offerstemplate, $imagetemplate );

						array_push( $productplaceholders, $placeholders );
						$count = $count + 1;
						break;
					case 2:
						$formatter = new atkp_formatter( $this, null );

						$offers = $formatter->get_offers( $myproduct, $includemainoffer, $maxoffers );


						$minprice   = - 1;
						$minofferid = 0;
						foreach ( $offers as $offer ) {
							if ( $offer->pricefloat == (float) 0 || $offer->hideoffer ) {
								continue;
							}

							if ( $minprice == - 1 || $minprice > $offer->pricefloat ) {
								$minprice   = $offer->pricefloat;
								$minofferid = $offer->id;
							}
						}

						foreach ( $offers as $offer ) {
							$placeholders = $this->createOfferPlaceholderArray( $myproduct, $offer, $count, $listid, $template, $minofferid );
							if ( $placeholders != null ) {
								array_push( $productplaceholders, $placeholders );
								$count = $count + 1;
							}
						}

						if ( $count <= 1 ) {
							$hideoutput = true;
						}
						break;
					case 3:
						$formatter = new atkp_formatter( $this, null );

						//image
						$images = $formatter->get_images( $myproduct, true, 0 );

						foreach ( $images as $image ) {
							$placeholders = $this->createImagePlaceholderArray( $myproduct, $image, $count, $listid, $template );
							array_push( $productplaceholders, $placeholders );
							$count = $count + 1;
						}

						if ( $count <= 1 ) {
							$hideoutput = true;
						}

						break;
				}
			}

			//*** header ersetzen
			if ( $myheader != '' && $firstplaceholders != null ) {

				$myheader = $this->replace_placeholders( $myheader, $firstplaceholders );

				//foreach(array_keys($firstplaceholders) as $key){
				//        $myheader = str_replace('%'.strtolower($key).'%', $firstplaceholders[$key], $myheader);
				//}

				$resultValue .= $myheader;
			}
			//header ersetzen ***

			switch ( $templatetype ) {
				default:
					//klassische vorlagen ersetzen

					//*** detailheader, detail und detailfooter ersetzen

					$headerrows   = explode( '{SYS_APPEND}', $detail_header );
					$templaterows = explode( '{SYS_APPEND}', $mytemplate );
					$footerrows   = explode( '{SYS_APPEND}', $detail_footer );

					$idx = 0;
					foreach ( $templaterows as $templaterow ) {
						$resultrow = '';
						foreach ( $productplaceholders as $placeholders ) {
							$result = $templaterow;

							$result = $this->replace_placeholders( $result, $placeholders );

							// Search & Replace placeholders
							//foreach(array_keys($placeholders) as $key){
							//    $result = str_replace('%'.strtolower($key).'%', $placeholders[$key], $result);
							//}
							$resultrow .= $result;

						}

						$resultValue .= $body_header . ( isset( $headerrows[ $idx ] ) ? $headerrows[ $idx ] : '' ) . $resultrow . ( isset( $footerrows[ $idx ] ) ? $footerrows[ $idx ] : '' ) . $body_footer;

						$idx = $idx + 1;
					}

					//detailheader, detail und detailfooter ersetzen***

					break;
				case 4:
					//vergleichstabelle generieren
					$resultValue .= $this->generateCompareTable( $template, $productplaceholders, $products );

					break;

			}

			//*** footer ersetzen
			if ( $myfooter != '' && $firstplaceholders != null ) {

				$myfooter = $this->replace_placeholders( $myfooter, $firstplaceholders );

				//foreach(array_keys($firstplaceholders) as $key){
				//        $myfooter = str_replace('%'.strtolower($key).'%', $firstplaceholders[$key], $myfooter);
				//    }
				$resultValue .= $myfooter;
			}
			//footer ersetzen***

			$resultValue .= $this->generate_pagination( $max_num_pages );


			//*** disclaimer ersetzen
			if ( $disclaimer != '' && $firstproduct != null && ! $hidedisclaimer ) {
				if ( $customdisclaimer != null ) {
					$disclaimer = $customdisclaimer;
				}

				$disclaimer = $this->replace_placeholders( $disclaimer, $firstplaceholders );

				//foreach(array_keys($firstplaceholders) as $key){
				//            $disclaimer = str_replace('%'.strtolower($key).'%', $firstplaceholders[$key], $disclaimer);
				//        }

				if ( $customdisclaimer != null ) {
					$resultValue = $disclaimer;
				} else {
					$resultValue .= ATKPSettings::$disablestyles ? $disclaimer : ( '<span class="atkp-disclaimer ' . $disclaimerclass . '">' . $disclaimer . '</span>' );
				}
			}
			//disclaimer ersetzen***

			if ( ! ATKPSettings::$disablestyles ) {
				$resultValue .= '</div>';
			}

			if ( $firstproduct == null ) {
				$resultValue = '';
			}
		}

		//remove empty a tags from output

		//$resultValue=	preg_replace("/<a>(.*?)<\/a>/", "$1", $resultValue);

		if ( is_user_logged_in() && current_user_can( 'administrator' ) && get_option( ATKP_PLUGIN_PREFIX . '_showadminsection', 1 ) && $resultValue != '' && ! $hideoutput ) {

			$adminsection = '';

			if ( is_numeric( $template ) ) {
				$url = admin_url( sprintf( 'post.php?post=%d&action=edit', (int) $template ) );

				$adminsection .= '<a class="' . esc_attr( 'atkp-admin-button' ) . '" href="' . esc_url( $url ) . '">' . __( '[edit template]', ATKP_PLUGIN_PREFIX ) . '</a>';
			}

			if ( is_numeric( $listid ) && $listid > 0 ) {
				$url = admin_url( sprintf( 'post.php?post=%d&action=edit', (int) $listid ) );

				if ( $adminsection != '' ) {
					$adminsection .= "&#124;";
				}
				$adminsection .= '<a class="' . esc_attr( 'atkp-admin-button' ) . '" href="' . esc_url( $url ) . '">' . __( '[edit list]', ATKP_PLUGIN_PREFIX ) . '</a>';

			} else if ( count( $products ) > 0 && $products[0]->productid != '' ) {
				$url = admin_url( sprintf( 'post.php?post=%d&action=edit', (int) $products[0]->productid ) );

				if ( $adminsection != '' ) {
					$adminsection .= "&#124;";
				}
				$adminsection .= '<a class="' . esc_attr( 'atkp-admin-button' ) . '" href="' . esc_url( $url ) . '">' . __( '[edit product]', ATKP_PLUGIN_PREFIX ) . '</a>';
			}

			$resultValue .= '<div class="atkp-admin-actions">' . $adminsection . '</div>';
		}


		if ( $hideoutput == true ) {
			return '';
		} else {
			$tempval = $isblade ? $resultValue : str_replace( array( '<a ></a>', '()' ), '', $resultValue );

			$tempval = do_shortcode( $tempval );

			return $tempval;
		}
	}

	private function generate_pagination( $max_num_pages ) {
		if ( $max_num_pages > 1 ) {
			//add navigation links
			$paging = '';
			$page   = ATKPTools::get_get_parameter( 'tpage', 'int' );

			if ( $page <= 1 ) {
				$page = 1;
			}

			if ( ! ATKPSettings::$disablestyles ) {
				$paging .= '<div class="atkp-navigation">';
			}

			$nextpagelink = get_home_url() . remove_query_arg( 'tpage', $_SERVER['REQUEST_URI'] );

			$addpaging = false;


			if ( $page > 1 ) {
				$paging    .= '<a class="atkp-prevpage-btn atkp-infobutton" href="' . $nextpagelink . ( strpos( $nextpagelink, '?' ) > - 1 ? '&' : '?' ) . 'tpage=' . ( $page - 1 ) . '">' . __( 'Previous page', ATKP_PLUGIN_PREFIX ) . '</a>';
				$addpaging = true;
			}

			//$max_num_pages = 0;
			//$found_posts = 0;

			if ( $page < $max_num_pages ) {
				if ( $addpaging ) {
					$paging .= '&nbsp;';
				}
				$paging    .= '<a class="atkp-nextpage-btn atkp-infobutton" href="' . $nextpagelink . ( strpos( $nextpagelink, '?' ) > - 1 ? '&' : '?' ) . 'tpage=' . ( $page + 1 ) . '">' . __( 'Next page', ATKP_PLUGIN_PREFIX ) . '</a>';
				$addpaging = true;
			}


			if ( ! ATKPSettings::$disablestyles ) {
				$paging .= '</div>';
			}

			if ( $addpaging ) {
				return $paging;
			}

		}

		return '';
	}

	private function run_blade( $bladecontent, $products, $views, $parameters ) {

		require_once ATKP_PLUGIN_DIR . "/lib/bladeone/BladeOne.php"; // you should change it and indicates the correct route.

		// $cache = ATKP_PLUGIN_DIR . '/templates/blade/cache'; // it uses the folder /cache to compile the result.
		$cache = ATKPTools::get_uploaddir();


		$blade = new BladeOne( $views, $cache, BladeOne::MODE_AUTO );

		$current_user = wp_get_current_user();

		if ( isset( $current_user ) && $current_user ) {
			$role = isset( $current_user->roles ) && $current_user->roles && is_array( $current_user->roles ) ? ( array ) $current_user->roles : null;

			$blade->setAuth( $current_user->display_name, $role != null ? $role[0] : '' );
		} else {
			$blade->setAuth( 'guest' );
		}

		$idx = 1;
		foreach ( $products as $product ) {
			$product->item_idx = $idx ++;
		}

		if ( isset( $products[0] ) ) {
			$shop = $products[0]->shop;
		} else {
			$shop = null;
		}

		$formatter  = new atkp_formatter( $this, $parameters );
		$translator = new atkp_translator( $this, $parameters );

		$bladearray = array(
			'products'   => $products,
			'formatter'  => $formatter,
			'shop'       => $shop,
			'parameters' => $parameters,
			'translator' => $translator
		);

		$bladearray = apply_filters( 'atkp_modify_bladedata', $bladearray );

		return $blade->runString( $bladecontent, $bladearray );
	}

	private function sortfieldgroup( $a, $b ) {

		$sortordera = ATKPTools::get_post_setting( $a->ID, ATKP_FIELDGROUP_POSTTYPE . '_sortorder' );
		$sortorderb = ATKPTools::get_post_setting( $b->ID, ATKP_FIELDGROUP_POSTTYPE . '_sortorder' );

		if ( $sortordera == '' ) {
			$sortordera = 0;
		} else {
			$sortordera = intval( $sortordera );
		}

		if ( $sortorderb == '' ) {
			$sortorderb = 0;
		} else {
			$sortorderb = intval( $sortorderb );
		}


		if ( $sortordera == $sortorderb ) {
			return 0;
		}

		return ( $sortordera < $sortorderb ) ? - 1 : 1;
	}

	private function get_autocomparevalues( $products, $templateid, $fieldgroupasgroup = false, $cssclass = '' ) {

		$fieldgroups = array();

		foreach ( $products as $product ) {
			$gg = ATKPTools::get_fieldgroups_by_productid( $product->productid );
			if ( $gg != null ) {
				foreach ( $gg as $g ) {
					array_push( $fieldgroups, $g );
				}
			}
		}

		usort( $fieldgroups, array( $this, "sortfieldgroup" ) );

		$comparefields = array();
		$comparegroups = array();

		foreach ( $fieldgroups as $fieldgroup ) {

			$fields       = ATKPTools::get_post_setting( $fieldgroup->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );
			$comparegroup = null;

			foreach ( $comparegroups as $xx ) {
				if ( $xx->id == $fieldgroup->ID ) {
					$comparegroup = $xx;
					break;
				}
			}
			if ( $comparegroup == null ) {
				$comparegroup = new  atkp_template_comparegroup();
				//$comparefield->id = $field->id;
				$comparegroup->id          = $fieldgroup->ID;
				$comparegroup->caption     = ATKPTools::get_post_setting( $fieldgroup->ID, ATKP_FIELDGROUP_POSTTYPE . '_name' );
				$comparegroup->description = ATKPTools::get_post_setting( $fieldgroup->ID, ATKP_FIELDGROUP_POSTTYPE . '_description' );
				$comparegroup->sortorder   = ATKPTools::get_post_setting( $fieldgroup->ID, ATKP_FIELDGROUP_POSTTYPE . '_sortorder' );
				$comparegroup->isvisible   = $fieldgroupasgroup && $comparegroup->caption != '';
				$vals                      = array();
				array_push( $comparegroups, $comparegroup );
			} else {
				$vals = $comparegroup->values;
			}

			foreach ( $fields as $field ) {

				if ( $templateid == 'detaillist' ) {

					if ( ! $field->showdetaillist ) {
						continue;
					}

				} else if ( $templateid == 'datasheet' ) {

					if ( ! $field->showdatasheet ) {
						continue;
					}

				} else {
					if ( ! $field->showcomparetable && ! $field->showmobilecomparetable ) {
						continue;
					}
				}

				$found = false;
				if ( $fieldgroupasgroup ) {
					foreach ( $vals as $compare ) {
						if ( $compare->id == $field->name ) {
							$found = true;
							break;
						}
					}
				} else {
					foreach ( $comparefields as $compare ) {
						if ( $compare->id == $field->name ) {
							$found = true;
							break;
						}
					}
				}

				if ( $found ) {
					continue;
				}

				$comparefield = new  atkp_template_comparevalue();
				//$comparefield->id = $field->id;
				$comparefield->id          = $field->name;
				$comparefield->caption     = $field->caption;
				$comparefield->description = $field->description;
				$comparefield->detail      = '%cf_' . $field->name . '%';
				$comparefield->align       = 2;
				$comparefield->cssclass    = $cssclass;

				if ( $templateid == 'comparetable' ) {
					if ( $field->showcomparetable && $field->showmobilecomparetable ) {
						$comparefield->viewtype = 1;
					} else if ( $field->showmobilecomparetable ) {
						$comparefield->viewtype = 3;
					} else {
						$comparefield->viewtype = 2;
					}
				}

				array_push( $comparefields, $comparefield );
				array_push( $vals, $comparefield );
			}

			$comparegroup->values = $vals;

		}


		return $comparegroups;
	}

	private function generateCompareTable( $templateid, $productplaceholders, $products ) {


		$showmanufacturer = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer', 1 );
		$showavailability = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_availability', 1 );

		$showtestresult    = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult', 1 );
		$showproductbutton = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton', 1 );
		$showprimarybutton = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton', 1 );
		$showmoreoffers    = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers', 1 );
		$hideemptyfeatures = get_option( ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures', 0 );
		$priceposition     = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_price_position', 1 );
		$fieldgroupasgroup = 0;

		if ( $templateid == 'comparetable' || $templateid == 'detaillist' ) {


			$comparevalues = unserialize( 'a:10:{i:0;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:1:"1";s:7:"caption";s:0:"";s:11:"description";s:0:"";s:6:"detail";s:13:"%mediumimage%";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:22:"atkp-producttable-head";}}i:1;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474187702195";s:7:"caption";s:4:"Link";s:11:"description";s:0:"";s:6:"detail";s:47:"<a %productlink%><b>%short_title%%mark%</b></a>";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}i:2;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474188070754";s:7:"caption";s:12:"Testergebnis";s:11:"description";s:0:"";s:6:"detail";s:12:"%testresult%";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:23:"atkp-producttable-badge";}}i:3;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474312490373";s:7:"caption";s:5:"Preis";s:11:"description";s:0:"";s:6:"detail";s:185:"<span class="atkp-price atkp-listprice">%listprice%</span>             <span class="atkp-price atkp-saleprice"> %price%</span>   <div class="atkp-listpriceinfo">%priceinfo_text%</span> ";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}i:4;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474188429906";s:7:"caption";s:10:"Hersteller";s:11:"description";s:0:"";s:6:"detail";s:14:"%manufacturer%";s:8:"viewtype";s:1:"1";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}i:5;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474191630913";s:7:"caption";s:14:"Verfügbarkeit";s:11:"description";s:0:"";s:6:"detail";s:14:"%availability%";s:8:"viewtype";s:1:"1";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}i:6;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474314849240";s:7:"caption";s:0:"";s:11:"description";s:0:"";s:6:"detail";s:185:"<span class="atkp-price atkp-listprice">%listprice%</span>             <span class="atkp-price atkp-saleprice"> %price%</span>    <div class="atkp-listpriceinfo">%priceinfo_text%</span>";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}i:7;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474191630915";s:7:"caption";s:11:"zum Produkt";s:11:"description";s:0:"";s:6:"detail";s:59:"<a  %detaillink% class="atkp-secondbutton">%detailtext%</a>";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"1";s:8:"cssclass";s:24:"atkp-producttable-button";}}i:8;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474191656309";s:7:"caption";s:12:"zum Anbieter";s:11:"description";s:0:"";s:6:"detail";s:51:"<a  %link% class="atkp-button">%linktext%%mark%</a>";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"1";s:8:"cssclass";s:24:"atkp-producttable-button";}}i:9;O:26:"atkp_template_comparevalue":1:{s:4:"data";a:7:{s:2:"id";s:13:"1474312024756";s:7:"caption";s:16:"weitere Angebote";s:11:"description";s:0:"";s:6:"detail";s:12:"%moreoffers%";s:8:"viewtype";s:1:"2";s:5:"align";s:1:"2";s:8:"cssclass";s:0:"";}}}' );


			$body = '<div class="atkp-box atkp-clearfix atkp-prdmob-wrapper" style="%predicate_borderstyle%">
        <div class="atkp-predicateheadline atkp-predicate-highlight%predicate_id%"><span>%predicate_text%</span></div>
        <div class="atkp-prdmob-title"><a %productlink% title="%title%">%title%%mark%</a></div>
        <div class="atkp-prdmob-image-wrapper">
            %mediumimage%
        </div>
        <div class="atkp-prdmob-table-wrapper">
            %mobiletable%
        </div>

        <div class="atkp-prdmob-price-wrapper">
            <div class="atkp-prdmob-prices">
                <div class="atkp-listprice">%listprice%</div>
                <div class="atkp-price">%price%</div>
                <div class="atkp-listpriceinfo">%priceinfo_text%</div>
            </div>
            <div class="atkp-prdmob-button-wrapper">
                ' . ( $showproductbutton ? '<a  %detaillink% class="atkp-secondbutton">%detailtext%</a>' : '' ) . '
                ' . ( $showprimarybutton ? '<a  %link% class="atkp-button">%linktext%%mark%</a>' : '' ) . '
                ' . ( $showmoreoffers ? '<div class="atkp-moreoffersinfo">%moreoffers%</div>' : '' ) . '
                
            </div>
        </div>
    </div>';


			//image
			//link
			//testergebnis = 1474188070754 (option in einstellungen)
			//Preis = 1474312490373
			//Hersteller = 1474188429906
			//verfügbarkeit = 1474191630913
			//zum product = 1474191630915 (option in einstellungen)
			//zum Anbieter = 1474191656309 (option in einstellungen)
			//weitere angebote = 1474312024756 (option in einstellungen)


			foreach ( $comparevalues as $comparefield ) {
				switch ( $comparefield->id ) {
					case '1474188070754':
						$comparefield->caption = __( 'Test result', ATKP_PLUGIN_PREFIX );

						if ( ! $showtestresult ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474312490373':
						$comparefield->caption = __( 'Price', ATKP_PLUGIN_PREFIX );

						if ( $priceposition == 3 ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474314849240':
						$comparefield->caption = __( 'Price', ATKP_PLUGIN_PREFIX );

						if ( $priceposition == 2 ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474188429906':
						$comparefield->caption = __( 'Manufacturer', ATKP_PLUGIN_PREFIX );

						if ( ! $showmanufacturer ) {
							$comparefield->viewtype = 4;
						}

						break;
					case '1474191630913':
						$comparefield->caption = __( 'Availability', ATKP_PLUGIN_PREFIX );

						if ( ! $showavailability ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474191630915':
						$comparefield->caption = '';

						if ( ! $showproductbutton ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474191656309':
						$comparefield->caption = '';

						if ( ! $showprimarybutton ) {
							$comparefield->viewtype = 4;
						}
						break;
					case '1474312024756':
						$comparefield->caption = __( 'Additional offers', ATKP_PLUGIN_PREFIX );

						if ( ! $showmoreoffers ) {
							$comparefield->viewtype = 4;
						}
						break;

				}

			}

			if ( isset( $products ) && count( $products ) > 0 ) {
				$comparefields = $this->get_autocomparevalues( $products, $templateid );

				array_splice( $comparevalues, 6, 0, $comparefields );
			}

			if ( $templateid == 'detaillist' ) {
				$viewtype          = 3;
				$maxmobileproducts = 0;
			} else {
				$viewtype          = 1;
				$maxmobileproducts = 4;
			}

			$maxproducts          = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_max_products', 4 );
			$horizontalscrollbars = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars', 0 );
			$hideheaders          = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders', 0 );


		} else {

			$fieldgroupasgroup = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup' );

			$comparevalues = atkp_template_comparevalue::load_comparevalues( $templateid );

			$idx = 0;
			foreach ( $comparevalues as $comparevalue ) {
				if ( $comparevalue->detail == '<!-AUTOROW->' ) {
					$comparefields = $this->get_autocomparevalues( $products, $templateid, $fieldgroupasgroup, $comparevalue->cssclass );

					unset( $comparevalues[ $idx ] );

					array_splice( $comparevalues, $idx, 0, $comparefields );
				}
				$idx ++;
			}

			$viewtype = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_viewtype' );

			if ( $viewtype == 1 || $viewtype == 2 ) {
				$maxproducts          = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_maxproducts' );
				$horizontalscrollbars = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' );
				$hideheaders          = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_hideheaders' );


			}
			if ( $viewtype == 1 || $viewtype == 3 ) {
				$maxmobileproducts = ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts' );
				$body              = html_entity_decode( ATKPTools::get_post_setting( $templateid, ATKP_TEMPLATE_POSTTYPE . '_mobilebody' ) );
			}

		}
		//$viewtype 1 == mobile & desktop + responsive | 2 == desktop || 3 == mobile

		$resultValue = '';

		if ( $viewtype == 1 || $viewtype == 2 ) {

			$scrollbarstyle = '';

			//enable horizontal scrollbar
			if ( $horizontalscrollbars ) {
				$scrollbarstyle = 'class="atkp-producttable-wrapper"';
			}


			$hideheaderclass = '';
			if ( $hideheaders ) {
				$hideheaderclass = 'atkp-producttable-leftborder';
			}

			$rowidx      = 0;
			$resultValue .= '<div ' . $scrollbarstyle . '><table class=" atkp-cleartable atkp-producttable ' . ( $viewtype == 1 ? 'atkp-producttable-resp' : '' ) . ' ' . $hideheaderclass . '">';


			$totalfieldcount = 0;

			foreach ( $comparevalues as $comparegroup ) {
				$isgroup = $comparegroup->isgroup == true;

				$comparings = array();

				if ( $isgroup ) {

					$comparings = $comparegroup->values;

				} else {
					array_push( $comparings, $comparegroup );
				}

				foreach ( $comparings as $comparerow ) {
					if ( $comparerow->viewtype == 3 || $comparerow->viewtype == 4 ) {
						continue;
					}
					$totalfieldcount ++;
				}
			}


			foreach ( $comparevalues as $comparegroup ) {
				$isgroup = $comparegroup->isgroup == true;

				$comparings = array();

				if ( $isgroup ) {

					$comparings = $comparegroup->values;
					if ( $comparegroup->isvisible ) {
						$resultValue .= '<tr  class="atkp-producttable-grouprow"><td colspan="' . esc_attr( $maxproducts <= 0 ? 10 : $maxproducts + 1 ) . '"><span class="atkp-producttable-groupheader">' . $comparegroup->caption . '</span><span class="atkp-producttable-groupdescription">' . $comparegroup->description . '</span></td></tr>';
					}
				} else {
					array_push( $comparings, $comparegroup );
				}

				foreach ( $comparings as $comparerow ) {
					if ( $comparerow->viewtype == 3 || $comparerow->viewtype == 4 ) {
						continue;
					}


					$resultrow   = '';
					$borderclass = '';

					if ( $rowidx == 0 ) {
						$borderclass = 'atkp-producttable-lefttop';
					}

					$caption = $comparerow->caption;

					if ( $comparerow->description != '' ) {

						$caption = '<div class="atkp-tooltip">' . $comparerow->caption . '<span class="atkp-tooltiptext">' . $comparerow->description . '</span></div>';
					}

					//enable columnheadercaption oder style class zuweisen die links border zeigt
					if ( ! $hideheaders ) {

						$nextPredicateCaption = '';
						foreach ( $productplaceholders as $placeholdersNext ) {

							if ( $placeholdersNext['predicate_id'] != '' ) {
								$nextPredicateCaption = 'atkp-producttable-nexthighlight' . $placeholdersNext['predicate_id'];
							}
							break;
						}


						$resultrow .= '<td class="atkp-producttable-header ' . $borderclass . ' ' . $nextPredicateCaption . '">' . $caption . '</td>';
					}


					$align = '';

					switch ( $comparerow->align ) {
						case 1:
							//left
							$align = 'atkp-producttable-left';
							break;
						case 2:
							//center
							$align = 'atkp-producttable-center';
							break;
						case 3:
							//right
							$align = 'atkp-producttable-right';
							break;
						case 4:
							//stretch
							$align = 'atkp-producttable-stretch';
							break;
					}

					$containspredicate = false;

					foreach ( $productplaceholders as $placeholders ) {
						if ( $placeholders['predicate_id'] != '' ) {
							$containspredicate = true;
							break;
						}
					}

					$prodIdx = 0;
					foreach ( $productplaceholders as $placeholders ) {
						$result = $comparerow->detail;
						if ( $rowidx == 0 && $containspredicate ) {
							$result = '<div class="atkp-predicateheadline atkp-predicate-highlight%predicate_id%" style="height:35px"><span>%predicate_text%</span></div>' . $result;
						}

						$nextPredicate = '';
						$prodNextIdx   = 0;
						foreach ( $productplaceholders as $placeholdersNext ) {

							if ( $prodNextIdx <= $prodIdx ) {
								$prodNextIdx ++;
								continue;
							}

							if ( $placeholdersNext['predicate_id'] != '' ) {
								$nextPredicate = $placeholdersNext['predicate_id'];
							}
							break;
						}


						$result = $this->replace_placeholders( $result, $placeholders );

						// Search & Replace placeholders
						//foreach(array_keys($placeholders) as $key){
						//    $result = str_replace('%'.strtolower($key).'%', $placeholders[$key], $result);
						//}

						$highlight = '';

						if ( $rowidx + 1 >= $totalfieldcount ) {
							$highlight .= ' atkp-producttable-lastrow';
						}

						if ( $placeholders['predicate_id'] != '' ) {
							$highlight .= ' atkp-producttable-highlight' . $placeholders['predicate_id'];
							if ( $rowidx + 1 >= $totalfieldcount ) {
								$highlight .= ' atkp-producttable-bottom-highlight' . $placeholders['predicate_id'];
							}
						}

						if ( $nextPredicate != '' ) {
							$highlight .= ' atkp-producttable-nexthighlight' . $nextPredicate;
						}


						//TODO: 100 / produkteanzahl + 1 ergibt spaltenbreite
						$comparecellOut = '<td class="atkp-producttable-detail atkp-producttable-col' . ( $prodIdx + 1 ) . ' ' . $align . ' ' . $highlight . ' ' . $comparerow->cssclass . '" >' . $result . '</td>';

						$comparecellOut = apply_filters( 'atkp_modify_comparetable_cell', $comparecellOut, $comparerow, $placeholders );

						$resultrow .= $comparecellOut;

						$prodIdx ++;

						if ( $maxproducts > 0 && $prodIdx >= $maxproducts ) {
							break;
						}
					}

					$specialclass = '';
					if ( $rowidx % 2 != 0 ) {
						$specialclass = 'atkp-producttable-rowa';
					} else {
						$specialclass = 'atkp-producttable-rowb';
					}

					$comparerowOut = '<tr  class="atkp-producttable-row ' . $specialclass . '">' . $resultrow . '</tr>';

					$comparerowOut = apply_filters( 'atkp_modify_comparetable_row', $comparerowOut, $comparerow );

					$resultValue .= $comparerowOut;

					$rowidx = $rowidx + 1;
				}
			}
			$resultValue .= '</table></div>';

		}

		if ( $viewtype == 1 || $viewtype == 3 ) {

			$resultValue .= '<div class="atkp-mobileproducttable ' . ( $viewtype == 1 ? 'atkp-mobileproducttable-resp' : '' ) . '">';

			$prodIdx = 0;
			foreach ( $productplaceholders as $placeholders ) {

				$mobile = '<table class="atkp-cleartable">';

				foreach ( $comparevalues as $comparegroup ) {
					$isgroup = $comparegroup->isgroup == true;

					$comparings = array();

					if ( $isgroup ) {

						$comparings = $comparegroup->values;
						if ( $comparegroup->isvisible ) {
							$mobile .= '<tr  class="atkp-mobileproducttable-grouprow"><td colspan="' . esc_attr( 2 ) . '"><span class="atkp-mobileproducttable-groupheader">' . $comparegroup->caption . '</span><span class="atkp-mobileproducttable-groupdescription">' . $comparegroup->description . '</span></td></tr>';
						}
					} else {
						array_push( $comparings, $comparegroup );
					}

					foreach ( $comparings as $comparerow ) {

						if ( $comparerow->viewtype == 2 || $comparerow->viewtype == 4 ) {
							continue;
						}

						$detail = $this->replace_placeholders( $comparerow->detail, $placeholders );

						if ( $hideemptyfeatures && ( $detail == null || trim( $detail ) == '' ) ) {
							continue;
						}

						$caption = $comparerow->caption;

						if ( $comparerow->description != '' ) {
							$caption = '<div class="atkp-tooltip">' . $comparerow->caption . '<span class="atkp-tooltiptext">' . $comparerow->description . '</span></div>';
						}

						$mobile .= '<tr>';
						$mobile .= '<td class="atkp-mobileproducttable-header">' . $caption . '</td>';

						$align = '';

						switch ( $comparerow->align ) {
							case 1:
								//left
								$align = 'atkp-producttable-left';
								break;
							case 2:
								//center
								$align = 'atkp-producttable-center';
								break;
							case 3:
								//right
								$align = 'atkp-producttable-right';
								break;
							case 4:
								//stretch
								$align = 'atkp-producttable-stretch';
								break;
						}

						$mobile .= '<td class="atkp-mobileproducttable-detail ' . $align . ' ' . $comparerow->cssclass . '" >' . $detail . '</td>';
						$mobile .= '</tr>';
					}
				}

				$mobile .= '</table>';


				$result = $body;

				$result = $this->replace_placeholders( $result, $placeholders );

				$result = str_replace( '%mobiletable%', $mobile, $result );

				// Search & Replace placeholders
				//foreach(array_keys($placeholders) as $key){
				//    $result = str_replace('%'.strtolower($key).'%', $placeholders[$key], $result);
				//}


				//$resultValue .= '<div class="atkp-box">';

				$resultValue .= $result;

				//$resultValue .= '</div>';

				$prodIdx = $prodIdx + 1;
				if ( $maxmobileproducts > 0 && $prodIdx >= $maxmobileproducts ) {
					break;
				}
			}

			$resultValue .= '</div>';
		}

		return $resultValue;
	}

	private function replace_placeholders( $result, $placeholders ) {

		preg_match_all( '/\%([a-zA-Z0-9_-]+)\%/', $result, $matches );

		foreach ( $matches[1] as $placeholder ) {
			if ( $placeholder == 'mobiletable' ) {
				continue;
			}

			$value = '';
			if ( isset( $placeholders[ $placeholder ] ) ) {
				$value = $placeholders[ $placeholder ];
			}

			$result = str_replace( '%' . $placeholder . '%', $value, $result );
		}

		return $result;
	}


}


?>