<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_output {
	public function __construct() {

		add_action( 'wp_footer', array( $this, 'atkp_hoverbox' ) );
	}

	/**
	 * Erstellt die Ausgabe einer Live-Produktsuche direkt auf die APIs aufgrund der Parameter.
	 *
	 * @shop_ids array Die Liste der erlaubten Shops für die Suche. Leer == Alle Shops
	 *
	 * @template string Entweder ein Standardtemplate (wide, box,...) oder die ID der Vorlage (Customposttype).
	 *
	 * @content string Ein benutzerdefinierter Text welcher bis zur Vorlage durchgeschleift wird.
	 *
	 * @return string Gibt das vollständige HTML zurück.
	 */
	public function get_livelist_output( $shop_ids, $template = 'default_live', $livetemplate = 'wide', $content, $buttontype = 'notset', $elementcss = '', $containercss = '', $hidedisclaimer = false, $tracking_id = '', $filter = '', $limit = 10 ) {

		$template = apply_filters( 'atkp_modify_template', $template );

		$filterhelper = new atkp_filter_helper();
		$filterarray  = $filterhelper->parse_params_filter( $filter, true );

		$filterstr = '';
		if ( $filterarray != null ) {
			foreach ( $filterarray as $name => $value ) {
				if ( $filterstr != '' ) {
					$filterstr .= '&';
				}
				$filterstr .= $name . '=' . $value . '';
			}
		}

		$templatehelper = new atkp_template_helper();
		$resultValue    = $templatehelper->createLiveOutput( $shop_ids, $livetemplate, $template, $filterstr, $elementcss, $containercss, $limit );

		return $resultValue;

		$resultValue = apply_filters( 'atkp_modify_output_livelist', $resultValue, $shop_ids, $template );

		return $resultValue;
	}

	/**
	 * Erstellt die Ausgabe einer konfigurierten Liste und aufgrund der Parameter.
	 *
	 * @id int Die eindeutige ID der Liste im Wordpress-Custom-Posttype.
	 *
	 * @template string Entweder ein Standardtemplate (wide, box,...) oder die ID der Vorlage (Customposttype).
	 *
	 * @content string Ein benutzerdefinierter Text welcher bis zur Vorlage durchgeschleift wird.
	 *
	 * @return string Gibt das vollständige HTML zurück.
	 */
	public function get_list_output( $id, $template = 'wide', $content = '', $buttontype = 'notset', $elementcss = '', $containercss = '', $limit = 10, $randomsort = false, $hidedisclaimer = false, $tracking_id = '', $product_ids = array(), $offerstemplate = '', $imagetemplate = '', $parseparams = false, $itemsPerPage = 0, $filter = '' ) {

		$template = apply_filters( 'atkp_modify_template', $template );
		$template = apply_filters( 'atkp_modify_template_list', $template, $id, $content );

		//Ausgabe der Liste vorbereiten

		if ( $itemsPerPage <= 0 ) {
			$itemsPerPage = 25;
		} else {
			//wenn items per page mitgegeben wurde, dann wird das limit übersteuert
			$limit = 999;
		}

		$productlist   = array();
		$max_num_pages = 0;
		$found_posts   = 0;

		if ( $parseparams || $filter != '' ) {
			//TODO: parameter parsen und productids laden

			$filterhelper = new atkp_filter_helper();
			$productlist  = $filterhelper->parse_params_products( $itemsPerPage, $parseparams, $filter );

			$max_num_pages = $filterhelper->max_num_pages;
			$found_posts   = $filterhelper->found_posts;

			if ( $productlist == null || ! is_array( $productlist ) ) {
				return $productlist;
			}

		} else if ( count( $product_ids ) > 0 ) {
			foreach ( $product_ids as $productid ) {
				$item          = array();
				$item['type']  = 'productid';
				$item['value'] = $productid;

				array_push( $productlist, $item );
			}
		} else {
			$productlist = ATKPTools::get_post_setting( $id, ATKP_LIST_POSTTYPE . '_productlist' );

			//abwärtskompatiblität einbauen für noch nicht aktualisierte listen...
			if ( ! isset( $productlist ) || $productlist == null ) {
				$productlist = get_transient( ATKP_PLUGIN_PREFIX . '_' . $id );
			}

			//wenn liste noch nicht im cache ist, dann bau diese jetzt auf... das kann vorkommen wenn das plugin deaktiviert wurde und nach längerem wieder aktiviert wurde.
			//if($productlist == null) {
			//    $cronjob = new atkp_wp_cronjob(array());
			//    $cronjob->update_list($id);
			//    ATKPTools::set_post_setting( $id, ATKP_LIST_POSTTYPE.'_productlist', $productlist);
			//}
		}

		$preferlocalproductinfo = ATKPTools::get_post_setting( $id, ATKP_LIST_POSTTYPE . '_preferlocalproduct' );

		$outputprds = array();
		if ( $productlist != null ) {

			if ( $randomsort ) {
				shuffle( $productlist );
			}

			$counter = 0;
			foreach ( $productlist as $product ) {
				try {
					$type  = $product['type'];
					$value = $product['value'];

					if ( $value == '' ) {
						continue;
					}

					if ( $counter >= $limit ) {
						break;
					}

					$counter = $counter + 1;

					switch ( $type ) {
						case 'product':
							//nur nach lokalen produkten suchen wenn in der
							if ( $preferlocalproductinfo ) {
								$prdfound = atkp_product::loadbyasin( $value->asin );

								if ( $prdfound != null ) {
									$value = $prdfound;
								}
							}

							break;
						case 'productid':
							if ( get_post_status( $value ) == 'publish' || get_post_status( $value ) == 'draft' ) {
								$value = atkp_product::load( $value );
							} else {
								$value = null;
							}

							break;
					}
					if ( $value != null ) {
						$shopid = ATKPTools::get_post_setting( $id, ATKP_LIST_POSTTYPE . '_shopid', 0 );

						$value->init_list( $id, $shopid );
						array_push( $outputprds, $value );
					}
				} catch ( Exception $e ) {
					//TODO: 'Exception: ',  $e->getMessage(), "\n";
				}
			}
		}

		return $this->get_list_output2( $outputprds, $id, $template, $content, $buttontype, $elementcss, $containercss, $hidedisclaimer, $tracking_id, $offerstemplate, $imagetemplate, $itemsPerPage, $max_num_pages, $found_posts );
	}

	public function get_list_output2( $productlist, $listid, $template = 'wide', $content = '', $buttontype = 'notset', $elementcss = '', $containercss = '', $hidedisclaimer = false, $tracking_id = '', $offerstemplate = '', $imagetemplate = '', $itemsPerPage = 0, $max_num_pages, $found_posts ) {


		$templatehelper = new atkp_template_helper();
		$resultValue    = $templatehelper->createOutput( $productlist, $content, $template, $containercss, $elementcss, $buttontype, $listid, $hidedisclaimer, 0, $tracking_id, $offerstemplate, $imagetemplate, $itemsPerPage, $max_num_pages, $found_posts );

		$resultValue = apply_filters( 'atkp_modify_output_list', $resultValue, $productlist, $template );

		return $resultValue;

	}

	public function get_searchform_output( $template = 'default', $targetpage = 0, $content = '' ) {

		$template = apply_filters( 'atkp_modify_template', $template );

		$searchformhelper = new atkp_searchform_helper();

		$resultValue = $searchformhelper->createOutput( $template, $targetpage, $content );

		$resultValue = apply_filters( 'atkp_modify_output_searchform', $resultValue, $template );

		return $resultValue;
	}

	private function override_notavailable_template( $productid, $template, &$isavailable ) {
		$isavailable = true;
		if ( ! atkp_options::$loader->get_show_nota_template() ) {
			return $template;
		}


		$saleprice = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_saleprice' );
		$message   = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_message' );

		$temp = atkp_options::$loader->get_nota_template();

		if ( $saleprice == '' || $message != '' ) {
			$template    = $temp == '' ? 'notavailable' : $temp;
			$isavailable = false;
		}

		return $template;
	}

	public static $hoverbox = '';

	public function get_product_output( $id, $template = 'box', $content = '', $buttontype = 'notset', $field, $link = false, $elementcss = '', $containercss = '', $hidedisclaimer = false, $tracking_id = '', $offerstemplate = '', $imagetemplate = '' ) {
		$isavailable = true;
		$template    = $this->override_notavailable_template( $id, $template, $isavailable );

		$template = apply_filters( 'atkp_modify_template', $template );
		$template = apply_filters( 'atkp_modify_template_product', $template, $id, $content );

		$resultValue = '';

		if ( ( get_post_status( $id ) != 'publish' && get_post_status( $id ) != 'draft' ) ) {
			if ( $content == '' ) {
				$content = __( 'Product', ATKP_PLUGIN_PREFIX );
			}

			return $link == true ? $content : '';
		}

		if ( ! $isavailable && atkp_options::$loader->get_nota_disable_link() && $link ) {
			return $content;
		}

		$prd = atkp_product::load( $id );

		$templatehelper = new atkp_template_helper();

		if ( $field != '' ) {
			$placeholders = $templatehelper->createPlaceholderArray( $prd, 1, $containercss, $elementcss, $content, $buttontype, '', '', $tracking_id );

			foreach ( array_keys( $placeholders ) as $key ) {
				if ( $key == $field ) {
					$resultValue = $placeholders[ $key ];
					break;
				}
			}


			if ( $containercss != '' ) {
				$resultValue = '<div class="' . $containercss . '">' . $resultValue . '</div>';
			}
		} else {

			$resultValue = $templatehelper->createOutput( array( $prd ), $content, $template, $containercss, $elementcss, $buttontype, '', $hidedisclaimer, 0, $tracking_id, $offerstemplate, $imagetemplate );

		}


		if ( $link == true ) {
			$placeholders = $templatehelper->createPlaceholderArray( $prd, 1, $containercss, $elementcss, $content, $buttontype, '', '', $tracking_id );

			$link = $placeholders['productlink'];

			if ( $field != '' ) {
				$content = $resultValue;
			} else if ( $content == '' ) {
				$content = $prd->title;
			}

			if ( atkp_options::$loader->get_mark_links() == 1 && strpos( $content, 'img src' ) == false ) {
				$content .= atkp_options::$loader->get_affiliatechar();
			}

			$isamp = false;
			if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) {
				// do stuff
				$isamp = true;
			}
			//$hovercontent = '';
			if ( ATKPSettings::$show_linkinfo && ! $prd->disablehoverlink && ! is_admin() && ! $isamp ) {
				$link = str_replace( 'title="', 'alt="', $link );

				if ( ATKPSettings::$linkinfo_template == '' ) {
					$template = 'popup';
				} else {
					$template = ATKPSettings::$linkinfo_template;
				}
				//createOutput($products, $content='', $template='', $cssContainerClass = '', $cssElementClass = '', $addtocart = '', $listurl= '', $hidedisclaimer = 0)
				$infobox = $templatehelper->createOutput( array( $prd ), '', $template, 'atkp-clearfix', '', '', '', 1, 0, $tracking_id );

				$name = 'infobox-' . uniqid();

				self::$hoverbox .= '<div id="' . $name . '" style="display:none;"><div class="BoxInnen"><span class="BoxInhalte">' . $infobox . '</span></div></div>';


				$link .= 'onMouseover=\'showAtkpBox(event,"' . $name . '",20,-40);\' onMouseout=\'hideAtkpBox(event,"' . $name . '");\'';

			}

			if ( ATKPSettings::$access_mark_links == 1 && strpos( $content, 'img src' ) == true ) {
				$capt = __( 'Advertising', ATKP_PLUGIN_PREFIX );

				$resultValue = '<div class="' . $containercss . '"><div class="atkp-affiliateimage atkp-clearfix"><a ' . $link . ' >' . $content . '</a><div style="margin-top:3px">' . $capt . '</div></div></div>';
			} else {
				$resultValue = '<a ' . $link . ' >' . $content . '</a>';
			}

			//$resultValue .= $hovercontent;

		}

		$resultValue = apply_filters( 'atkp_modify_output_product', $resultValue, $prd, $template );


		return $resultValue;
	}


	function atkp_hoverbox() {
		if ( self::$hoverbox != '' ) {
			echo self::$hoverbox;
			self::$hoverbox = '';
		}
	}

	public function get_css_url() {
		return plugins_url( '/css/style.css', ATKP_PLUGIN_FILE );
	}

	public function get_js_url() {
		return plugins_url( '/js/library.js', ATKP_PLUGIN_FILE );
	}

	public function get_css_output() {

		$selectedbutton = atkp_options::$loader->get_buttonstyle();

		$custom_css = '';

		switch ( $selectedbutton ) {
			default:
			case 1:
				$custom_css = file_get_contents( ATKP_PLUGIN_DIR . '/css/button_classic.css' );
				break;
			case 2:
				$btn_background_top    = atkp_options::$loader->get_btn_color_background_top();
				$btn_background_bottom = atkp_options::$loader->get_btn_color_background_bottom();
				$btn_foreground        = atkp_options::$loader->get_btn_color_foreground();
				$btn_border            = atkp_options::$loader->get_btn_color_border();

				$btn_background_top_2    = atkp_options::$loader->get_btn_color_background_top_2();
				$btn_background_bottom_2 = atkp_options::$loader->get_btn_color_background_bottom_2();
				$btn_foreground_2        = atkp_options::$loader->get_btn_color_foreground_2();
				$btn_border_2            = atkp_options::$loader->get_btn_color_border_2();


				$custom_css = file_get_contents( ATKP_PLUGIN_DIR . '/css/button_classic_custom.css' );

				$custom_css = str_replace( '%background_color%', $btn_background_top, $custom_css );
				$custom_css = str_replace( '%background2_color%', $btn_background_bottom, $custom_css );
				$custom_css = str_replace( '%foreground_color%', $btn_foreground, $custom_css );
				$custom_css = str_replace( '%border_color%', $btn_border, $custom_css );

				$custom_css = str_replace( '%background_color_2%', $btn_background_top_2, $custom_css );
				$custom_css = str_replace( '%background2_color_2%', $btn_background_bottom_2, $custom_css );
				$custom_css = str_replace( '%foreground_color_2%', $btn_foreground_2, $custom_css );
				$custom_css = str_replace( '%border_color_2%', $btn_border_2, $custom_css );

				break;
			case 3:
				$custom_css = file_get_contents( ATKP_PLUGIN_DIR . '/css/button_amazon.css' );
				break;
			case 10:
				$custom_css = file_get_contents( ATKP_PLUGIN_DIR . '/css/button_flat.css' );
				break;
			case 11:
				$btn_background_top = atkp_options::$loader->get_btn_color_background_top();
				$btn_foreground     = atkp_options::$loader->get_btn_color_foreground();

				$btn_background_top_2 = atkp_options::$loader->get_btn_color_background_top_2();
				$btn_foreground_2     = atkp_options::$loader->get_btn_color_foreground_2();

				$custom_css = file_get_contents( ATKP_PLUGIN_DIR . '/css/button_flat_custom.css' );
				$custom_css = str_replace( '%background_color%', $btn_background_top, $custom_css );
				$custom_css = str_replace( '%foreground_color%', $btn_foreground, $custom_css );

				$custom_css = str_replace( '%background_color_2%', $btn_background_top_2, $custom_css );
				$custom_css = str_replace( '%foreground_color_2%', $btn_foreground_2, $custom_css );
				break;
			case 20:
				break;
		}

		$custom_css2 = '';

		$selectedbox = atkp_options::$loader->get_boxstyle();

		switch ( $selectedbox ) {
			default:
			case 1:
				$custom_css2 = file_get_contents( ATKP_PLUGIN_DIR . '/css/box_classic.css' );
				break;
			case 2:
				$custom_css2 = file_get_contents( ATKP_PLUGIN_DIR . '/css/box_flat.css' );
				break;
			case 3:
				$custom_css2 = file_get_contents( ATKP_PLUGIN_DIR . '/css/box_flat_withoutborder.css' );
				break;


		}

		$custom_css3 = '';

		if ( ATKP_PLUGIN_VERSION >= 30 ) {
			global $post;
			$args        = array(
				'post_type'      => ATKP_TEMPLATE_POSTTYPE,
				'posts_per_page' => 300,
				'post_status'    => array( 'publish', 'draft' )
			);
			$posts_array = get_posts( $args );

			foreach ( $posts_array as $prd ) {
				$css = ATKPTools::get_post_setting( $prd->ID, ATKP_TEMPLATE_POSTTYPE . '_css', true );

				if ( $css != '' ) {
					$custom_css3 .= $css . "\r\n";
				}
			};
		}

		$custom_css4               = '';
		$predicate1_color          = atkp_options::$loader->get_predicate1_color();
		$predicate1_highlightcolor = atkp_options::$loader->get_predicate1_highlightcolor();
		if ( $predicate1_color != '' ) {
			$custom_css4 .= '.atkp-producttable-highlight1 {';
			$custom_css4 .= '        border-right: 1px solid ' . $predicate1_color . ' !important;';
			$custom_css4 .= '        border-left: 1px solid ' . $predicate1_color . ' !important;';
			$custom_css4 .= '        background-color:' . $predicate1_highlightcolor . '; ';
			$custom_css4 .= '}';
			$custom_css4 .= '.atkp-producttable-bottom-highlight1 {';
			$custom_css4 .= '        border-bottom: 1px solid ' . $predicate1_color . ' !important;';
			$custom_css4 .= '}';

			$custom_css4 .= '.atkp-predicate-highlight1 {';
			$custom_css4 .= '        height:35px;background-color:' . $predicate1_color . ';';
			$custom_css4 .= '}';
		}
		$predicate2_color          = atkp_options::$loader->get_predicate2_color();
		$predicate2_highlightcolor = atkp_options::$loader->get_predicate2_highlightcolor();
		if ( $predicate2_color != '' ) {
			$custom_css4 .= '.atkp-producttable-highlight2 {';
			$custom_css4 .= '        border-right: 1px solid ' . $predicate2_color . ' !important;';
			$custom_css4 .= '        border-left: 1px solid ' . $predicate2_color . ' !important;';
			$custom_css4 .= '        background-color:' . $predicate2_highlightcolor . '; ';
			$custom_css4 .= '}';
			$custom_css4 .= '.atkp-producttable-bottom-highlight2 {';
			$custom_css4 .= '        border-bottom: 1px solid ' . $predicate2_color . ' !important;';
			$custom_css4 .= '}';

			$custom_css4 .= '.atkp-predicate-highlight2 {';
			$custom_css4 .= '        height:35px;background-color:' . $predicate2_color . ';';
			$custom_css4 .= '}';
		}
		$predicate3_color          = atkp_options::$loader->get_predicate3_color();
		$predicate3_highlightcolor = atkp_options::$loader->get_predicate3_highlightcolor();
		if ( $predicate3_color != '' ) {
			$custom_css4 .= '.atkp-producttable-highlight3 {';
			$custom_css4 .= '        border-right: 1px solid ' . $predicate3_color . ' !important;';
			$custom_css4 .= '        border-left: 1px solid ' . $predicate3_color . ' !important;';
			$custom_css4 .= '        background-color:' . $predicate3_highlightcolor . '; ';
			$custom_css4 .= '}';
			$custom_css4 .= '.atkp-producttable-bottom-highlight3 {';
			$custom_css4 .= '        border-bottom: 1px solid ' . $predicate3_color . ' !important;';
			$custom_css4 .= '}';

			$custom_css4 .= '.atkp-predicate-highlight3 {';
			$custom_css4 .= '        height:35px;background-color:' . $predicate3_color . ';';
			$custom_css4 .= '}';
		}

		$hidemobilefloatingbar = atkp_options::$loader->get_hide_floatingbar_mobile();

		$custom_css5 = '';

		if ( $hidemobilefloatingbar ) {
			$custom_css5 = '@media all and (max-width: 600px) {';
			$custom_css5 .= '    .atkp-floating-bar {';
			$custom_css5 .= '        display:none !important;';
			$custom_css5 .= '    }';
			$custom_css5 .= '}';
		}

		if ( atkp_options::$loader->get_floatingbar_position() ) {
			$custom_css5 .= "\r\n";
			$custom_css5 .= '.atkp-floating-bar {';
			$custom_css5 .= '    top: 0;';
			$custom_css5 .= '    bottom: initial;';
			$custom_css5 .= '}';
		}


		return $custom_css . "\r\n" . $custom_css2 . "\r\n" . $custom_css3 . "\r\n" . $custom_css4 . "\r\n" . $custom_css5;
	}

	public function get_js_output() {

		$custom_script      = '';
		$disablelightslider = atkp_options::$loader->get_disablelightslider();

		if ( ! $disablelightslider ) {

			$custom_script = '
                var $j = jQuery.noConflict();
                $j(document).ready(function() {
            
                    $j(\'.atkp-imagegallery\').lightSlider({
                        gallery:true,
                        item:1,
                        loop:true,
                        thumbItem:5,
                        
                        slideMargin:0,
                        enableDrag: false,
                        currentPagerPosition:\'left\',
                        onSliderLoad: function(el) {
                            el.lightGallery({
                                selector: \'.atkp-imagegallery .lslide\'
                            });
                        }           
                    });  
                    
                    $j(\'.atkp-imageslider\').lightSlider({                        
                        item:1,
                        slideMargin:0,
                        loop:true
                    });
                    
                    $j(\'.atkp-autoimageslider\').lightSlider({                        
                        item:4,
                        auto:true,
                        loop:true,
                        pauseOnHover: true,                        
                    });
                  });
            
            ';


		}

		$floatingbarminpos = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_minpos', 500 );
		$hideelementid     = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid', '' );

		$custom_js = '';

		if ( $floatingbarminpos > 0 ) {
			$custom_js .= '$j(document).scroll(function() {';

			$custom_js .= '    var scroll = $j(window).scrollTop();';
			$custom_js .= $hideelementid == '' ? '    var positionEnd = null;' : '    var positionEnd = $j(\'' . $hideelementid . '\').position();';

			$custom_js .= '    if (scroll > ' . $floatingbarminpos . ' && (positionEnd == null || scroll <= (positionEnd.top-1000))) { ';
			$custom_js .= '        $j(\'.atkp-floating-bar\').fadeIn();';
			$custom_js .= '    } else {';
			$custom_js .= '        $j(\'.atkp-floating-bar\').fadeOut();';
			$custom_js .= '    }';
			$custom_js .= ' });';
		}

		return $custom_js . "\r\n" . $custom_script;
	}

	function mixColors( $basecolor, $mixcolor, $ratio, $addHash = true ) {
		$baseComponentOffset = strlen( $basecolor ) == 7 ? 1 : 0;
		$baseComponentRed    = hexdec( substr( $basecolor, $baseComponentOffset, 2 ) );
		$baseComponentGreen  = hexdec( substr( $basecolor, $baseComponentOffset + 2, 2 ) );
		$baseComponentBlue   = hexdec( substr( $basecolor, $baseComponentOffset + 4, 2 ) );

		$mixComponentOffset = strlen( $mixcolor ) == 7 ? 1 : 0;
		$mixComponentRed    = hexdec( substr( $mixcolor, $mixComponentOffset, 2 ) );
		$mixComponentGreen  = hexdec( substr( $mixcolor, $mixComponentOffset + 2, 2 ) );
		$mixComponentBlue   = hexdec( substr( $mixcolor, $mixComponentOffset + 4, 2 ) );

		$Rsum = $baseComponentRed + $mixComponentRed;
		$Gsum = $baseComponentGreen + $mixComponentGreen;
		$Bsum = $baseComponentBlue + $mixComponentBlue;

		$R = ( $baseComponentRed * ( 100 - $ratio ) + $mixComponentRed * $ratio ) / 100;
		$G = ( $baseComponentGreen * ( 100 - $ratio ) + $mixComponentGreen * $ratio ) / 100;
		$B = ( $baseComponentBlue * ( 100 - $ratio ) + $mixComponentBlue * $ratio ) / 100;

		$redPercentage   = max( $R, $G, $B ) > 255 ? $R / max( $Rsum, $Gsum, $Bsum ) : $R / 255;
		$greenPercentage = max( $R, $G, $B ) > 255 ? $G / max( $Rsum, $Gsum, $Bsum ) : $G / 255;
		$bluePercentage  = max( $R, $G, $B ) > 255 ? $B / max( $Rsum, $Gsum, $Bsum ) : $B / 255;

		$redRGB   = floor( 255 * $redPercentage );
		$greenRGB = floor( 255 * $greenPercentage );
		$blueRGB  = floor( 255 * $bluePercentage );

		$color = sprintf( "%02X%02X%02X", $redRGB, $greenRGB, $blueRGB );

		return $addHash ? '#' . $color : $color;
	}

}


?>