<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_display {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_action( 'admin_enqueue_scripts', array( &$this, 'add_color_picker' ) );


	}


	function add_color_picker( $hook ) {

		if ( is_admin() ) {

			// Add the color picker css file
			wp_enqueue_style( 'wp-color-picker' );

			// Include our custom jQuery file with WordPress Color Picker dependency
			wp_enqueue_script( 'custom-script-handle', plugins_url( 'custom-script.js', __FILE__ ), array( 'wp-color-picker' ), false, true );
		}
	}

	public function display_configuration_page() {
		if ( ATKPTools::exists_post_parameter( 'savedisplay' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			//speichern der einstellungen

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_searchform_price_prefix', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_searchform_price_prefix', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_searchform_price_suffix', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_searchform_price_suffix', 'string' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_price_position', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_price_position', 'int' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_max_products', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_max_products', 'int' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_availability', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_availability', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_linkinfo', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_linkinfo', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_linkinfo_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_linkinfo_template', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_short_title_length', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_short_title_length', 'int' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_moreoffers', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_moreoffers', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_moreoffers_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_moreoffers_template', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_moreoffers_title', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_moreoffers_title', 'string' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_nota_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_nota_template', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_nota_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_nota_template', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_nota_disable_link', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_nota_disable_link', 'bool' ) );


			if ( atkp_options::$loader->get_floatingbar_module_enabled() ) {

				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid', 'string' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_minpos', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_floatingbar_minpos', 'int' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_position', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_floatingbar_position', 'int' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile', 'bool' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce', 'bool' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage', 'bool' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct', 'bool' ) );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_floatingbar_template', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_floatingbar_template', 'string' ) );
			}

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_productpage_title', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_productpage_title', 'html' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_review_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_review_text', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_review_color', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_review_color', 'string' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate1_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate1_text', 'html' ) );

			$predcolor1 = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate1_color', 'string' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate1_color', $predcolor1 );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate1_highlightcolor', ATKPTools::mix_colors( $predcolor1, "#ffffff", 90.0 ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate2_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate2_text', 'html' ) );

			$predcolor2 = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate2_color', 'string' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate2_color', $predcolor2 );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate2_highlightcolor', ATKPTools::mix_colors( $predcolor2, "#ffffff", 90.0 ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate3_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate3_text', 'html' ) );

			$predcolor3 = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_predicate3_color', 'string' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate3_color', $predcolor3 );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_predicate3_highlightcolor', ATKPTools::mix_colors( $predcolor3, "#ffffff", 90.0 ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_test_score1_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_test_score1_text', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_test_score2_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_test_score2_text', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_test_score3_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_test_score3_text', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_test_score4_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_test_score4_text', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_test_score5_text', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_test_score5_text', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_boxstyle', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_boxstyle', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_bestsellerribbon', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_bestsellerribbon', 'int' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_showadminsection', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_showadminsection', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_showprice', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_showprice', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_linkprime', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_linkprime', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_showpricediscount', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_showpricediscount', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_showstarrating', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_showstarrating', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_showrating', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_showrating', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_hideemptyrating', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_hideemptyrating', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_hideemptystars', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_hideemptystars', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_linkrating', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_linkrating', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_linkimage', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_linkimage', 'bool' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_disablestyles', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_disablestyles', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_hideerrormessages', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_hideerrormessages', 'bool' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops', 'bool' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_affiliatechar', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_affiliatechar', 'html' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_buttonstyle', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_buttonstyle', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_pricecomparisonsort', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_pricecomparisonsort', 'int' ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_list_default_count', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_list_default_count', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_description_length', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_description_length', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_feature_count', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_feature_count', 'int' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_boxcontent', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_boxcontent', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_text_no', ( ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_text_no', 'html' ) ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_text_yes', ( ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_text_yes', 'html' ) ) );


			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_background_top', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_background_top', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_foreground', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_foreground', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_border', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_border', 'string' ) );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_background_top_2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_background_top_2', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom_2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom_2', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_foreground_2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_foreground_2', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_btn_color_border_2', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_btn_color_border_2', 'string' ) );


			ATKPTools::write_global_scripts();
			ATKPTools::write_global_styles();

		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="atkp-content wrap">
            <div class="inner">
                <!-- <h2><?php _e( 'Affiliate Toolkit - Advanced Settings', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>">
                    <!--_affiliate_toolkit-bestseller-->
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Display', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-display' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_showadminsection' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_showadminsection' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_showadminsection', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_showadminsection' ?>">
									<?php _e( 'Show admin section', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_showprice' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_showprice' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_showprice', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_showprice' ?>">
									<?php _e( 'Show price', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_linkprime' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_linkprime' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_linkprime', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_linkprime' ?>">
									<?php _e( 'Link Prime logo', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_showpricediscount' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_showpricediscount' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_showpricediscount', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_showpricediscount' ?>">
									<?php _e( 'Show price discount', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_showstarrating' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_showstarrating' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_showstarrating', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_showstarrating' ?>">
									<?php _e( 'Show star rating', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptystars' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptystars' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_hideemptystars', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptystars' ?>">
									<?php _e( 'Hide star reviews with 0 stars', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_showrating' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_showrating' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_showrating', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_showrating' ?>">
									<?php _e( 'Show rating', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptyrating' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptyrating' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_hideemptyrating', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_hideemptyrating' ?>">
									<?php _e( 'Hide customer reviews with the value 0', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_linkrating' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_linkrating' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_linkrating', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_linkrating' ?>">
									<?php _e( 'Link rating', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_linkimage' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_linkimage' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_linkimage', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_linkimage' ?>">
									<?php _e( 'Link product image', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Bestseller ribbon', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_bestsellerribbon' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_bestsellerribbon' ?>"
                                        style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_bestsellerribbon' );

									echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'First three products', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'All products', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Box style', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_boxstyle' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_boxstyle' ?>" style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_boxstyle' );

									echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Classic Box', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Flat Box with border', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Flat Box without border', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button style', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_buttonstyle' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_buttonstyle' ?>" style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_buttonstyle' );

									echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Classic Button', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Custom Classic Button', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Amazon Button', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="10" ' . ( $selected == 10 ? 'selected' : '' ) . '>' . __( 'Flat Button', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="11" ' . ( $selected == 11 ? 'selected' : '' ) . '>' . __( 'Custom Flat Button', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="20" ' . ( $selected == 20 ? 'selected' : '' ) . '>' . __( 'No style', ATKP_PLUGIN_PREFIX ) . '</option>';
									?>
                                </select>





                                <script type="text/javascript">

                                    var $j = jQuery.noConflict();
                                    $j(document).ready(function () {
                                        if (typeof $j('.color-field').wpColorPicker !== "undefined") {
                                            $j('.color-field').wpColorPicker();
                                        }


                                        $j('#<?php echo ATKP_PLUGIN_PREFIX . '_buttonstyle' ?>').change(function () {
                                            $j('#<?php echo 'colorrow1' ?>').hide();
                                            $j('#<?php echo 'colorrow2' ?>').hide();
                                            $j('#<?php echo 'colorrow3' ?>').hide();
                                            $j('#<?php echo 'colorrow4' ?>').hide();

                                            switch ($j('#<?php echo ATKP_PLUGIN_PREFIX . '_buttonstyle' ?>').val()) {
                                                case '2':
                                                    $j('#<?php echo 'colorrow1' ?>').show();
                                                    $j('#<?php echo 'colorrow2' ?>').show();
                                                    $j('#<?php echo 'colorrow3' ?>').show();
                                                    $j('#<?php echo 'colorrow4' ?>').show();
                                                    break;
                                                case '11':
                                                    $j('#<?php echo 'colorrow1' ?>').show();
                                                    $j('#<?php echo 'colorrow3' ?>').show();
                                                    break;


                                            }


                                        });

                                        $j('#<?php echo ATKP_PLUGIN_PREFIX . '_buttonstyle' ?>').trigger("change");
                                    });


                                </script>
                            </td>
                        </tr>


                        <tr id="colorrow1">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button background color top', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <table style="border:0">
                                    <tr>
                                        <td style="padding:0">Button 1</td>
                                        <td style="padding:0">Button 2</td>
                                    </tr>
                                    <tr>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_top' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_top' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_background_top', '#ffec64' ) ?>">
                                        </td>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_top_2' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_top_2' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_background_top_2', '#ffec64' ) ?>">
                                        </td>
                                    </tr>
                                </table>

                            </td>
                        </tr>

                        <tr id="colorrow2">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button background color bottom', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <table style="border:0">
                                    <tr>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom', '#ffab23' ) ?>">
                                        </td>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom_2' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom_2' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_background_bottom_2', '#ffab23' ) ?>">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>

                        <tr id="colorrow3">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button foreground color', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <table style="border:0">
                                    <tr>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_foreground' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_foreground' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_foreground', '#333333' ) ?>">
                                        </td>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_foreground_2' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_foreground_2' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_foreground_2', '#333333' ) ?>">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>

                        <tr id="colorrow4">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Button border color', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <table style="border:0">
                                    <tr>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_border' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_border' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_border', '#ffaa22' ) ?>">
                                        </td>
                                        <td style="padding:0"><input type="text" class="color-field"
                                                                     id="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_border_2' ?>"
                                                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_btn_color_border_2' ?>"
                                                                     value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_btn_color_border_2', '#ffaa22' ) ?>">
                                        </td>
                                    </tr>
                                </table>




                            </td>
                        </tr>




                        <tr valign="top">
                            <th scope="row">
                                <label for="">
				                    <?php _e( 'Price comparison sort', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_pricecomparisonsort' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_pricecomparisonsort' ?>"
                                        style="width:300px">
				                    <?php
				                    $selected = get_option( ATKP_PLUGIN_PREFIX . '_pricecomparisonsort' );

				                    echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Price + Shipping cost', ATKP_PLUGIN_PREFIX ) . '</option>';
				                    echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Price', ATKP_PLUGIN_PREFIX ) . '</option>';

				                    ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops' ?>">
				                    <?php _e( 'Hide duplicate shops', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_disablestyles' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_disablestyles' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_disablestyles', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_disablestyles' ?>">
									<?php _e( 'Disable all styles from the plugin', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_hideerrormessages' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_hideerrormessages' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_hideerrormessages', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_hideerrormessages' ?>">
									<?php _e( 'Hide error messages on the web page', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_affiliatechar' ?>">
									<?php _e( 'Affiliate char', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </th>
                            <td>

                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_affiliatechar' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_affiliatechar' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_affiliatechar', '*' ) ); ?>">

                            </td>
                        </tr>


                        <tr>

                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Additional offers', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-moreoffers' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_show_moreoffers' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_show_moreoffers' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_moreoffers' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_moreoffers' ?>">
									<?php _e( 'Show additional offers', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( '"Additional Offers" template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
									echo 'disabled';
								} ?> id="<?php echo ATKP_PLUGIN_PREFIX . '_moreoffers_template' ?>"
                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_moreoffers_template' ?>"
                                     style="width:300px">
									<?php
									echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';


									$templates         = atkp_template::get_list( false );
									$moreoffertemplate = get_option( ATKP_PLUGIN_PREFIX . '_moreoffers_template' );

									foreach ( $templates as $template => $caption ) {
										if ( $template == $moreoffertemplate ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										echo '<option value="' . esc_attr( $template ) . '" ' . $sel . '>' . htmlentities( $caption ) . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( '"Additional Offers" text', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_moreoffers_title' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_moreoffers_title' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_moreoffers_title', __( 'Additional offers »', ATKP_PLUGIN_PREFIX ) ); ?>">
                            </td>
                        </tr>


						<?php if ( atkp_options::$loader->get_floatingbar_module_enabled() ) { ?>
                            <tr>
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr valign="top">
                                <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
									<?php _e( 'Floating bar panel', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-floatingbar' ); ?>
                                </th>
                            </tr>

                            <tr valign="top">
                                <th scope="row">

                                </th>
                                <td>
                                    <input type="checkbox"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage' ?>"
                                           value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage' ), true ); ?>>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_productpage' ?>">
										<?php _e( 'Show panel on product pages', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">

                                </th>
                                <td>
                                    <input type="checkbox"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct' ?>"
                                           value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct' ), true ); ?>>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_mainproduct' ?>">
										<?php _e( 'Show panel for main product', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">

                                </th>
                                <td>
                                    <input type="checkbox"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce' ?>"
                                           value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce' ), true ); ?>>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_floatingbar_woocommerce' ?>">
										<?php _e( 'Show panel for woocommerce product', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </td>
                            </tr>


                            <tr valign="top">
                                <th scope="row">
                                    <label for="">
										<?php _e( 'Floating panel template', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <select <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
										echo 'disabled';
									} ?> id="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_template' ?>"
                                         name="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_template' ?>"
                                         style="width:300px">
										<?php
										echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';


										$templates           = atkp_template::get_list( false );
										$floatingbartemplate = get_option( ATKP_PLUGIN_PREFIX . '_floatingbar_template' );

										foreach ( $templates as $template => $caption ) {
											if ( $template == $floatingbartemplate ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . esc_attr( $template ) . '" ' . $sel . '>' . htmlentities( $caption ) . '</option>';
										}
										?>
                                    </select>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">
                                    <label for="">
										<?php _e( 'Floating panel position', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <select id="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_position' ?>"
                                            name="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_position' ?>"
                                            style="width:300px">
										<?php
										echo '<option value="0">' . __( 'bottom', ATKP_PLUGIN_PREFIX ) . '</option>';
										echo '<option value="1" ' . ( get_option( ATKP_PLUGIN_PREFIX . '_floatingbar_position', 0 ) == 1 ? 'selected' : '' ) . '>' . __( 'above', ATKP_PLUGIN_PREFIX ) . '</option>';

										?>

                                    </select>
                                </td>
                            </tr>


                            <tr valign="top">
                                <th scope="row">

                                </th>
                                <td>
                                    <input type="checkbox"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile' ?>"
                                           value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile' ), false ); ?>>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_hide_floatingbar_mobile' ?>">
										<?php _e( 'Hide panel on mobile sites', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </td>
                            </tr>


                            <tr valign="top">
                                <th scope="row">
                                    <label for="">
										<?php _e( 'Show panel at min pixel', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <input type="number" min="1" , max="10000"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_minpos' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_minpos' ?>"
                                           value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_floatingbar_minpos', 500 ) ?>">
                                </td>
                            </tr>

                            <tr valign="top">
                                <th scope="row">
                                    <label for="">
										<?php _e( 'Hide panel after this css element', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <input type="text"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid' ?>"
                                           value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_floatingbar_hideelementid', '' ) ?>">
                                </td>
                            </tr>
						<?php } ?>
                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Hover link info', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-hoverlink' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_show_linkinfo' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_show_linkinfo' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_linkinfo' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_linkinfo' ?>">
									<?php _e( 'Show Hover link Info', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Link info template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
									echo 'disabled';
								} ?> id="<?php echo ATKP_PLUGIN_PREFIX . '_linkinfo_template' ?>"
                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_linkinfo_template' ?>" style="width:300px">
									<?php
									echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';

									if ( ATKP_PLUGIN_VERSION >= 30 ) {
										global $post;
										$args        = array(
											'post_type'      => ATKP_TEMPLATE_POSTTYPE,
											'posts_per_page' => 300,
											'post_status'    => 'publish'
										);
										$posts_array = get_posts( $args );
										foreach ( $posts_array as $prd ) {

											if ( $prd->ID == get_option( ATKP_PLUGIN_PREFIX . '_linkinfo_template' ) ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . $prd->ID . '"' . $sel . '>' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
										};
									} ?>
                                </select>
                            </td>
                        </tr>

                        <!--xx -->

                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Product not available', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-productnotavailable' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_show_nota_template' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_show_nota_template' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_show_nota_template' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_show_nota_template' ?>">
									<?php _e( 'Show template if not available', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Not available template', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
									echo 'disabled';
								} ?> id="<?php echo ATKP_PLUGIN_PREFIX . '_nota_template' ?>"
                                     name="<?php echo ATKP_PLUGIN_PREFIX . '_nota_template' ?>" style="width:300px">
									<?php
									echo '<option value="">' . __( 'default', ATKP_PLUGIN_PREFIX ) . '</option>';

									if ( ATKP_PLUGIN_VERSION >= 30 ) {
										global $post;
										$args        = array(
											'post_type'      => ATKP_TEMPLATE_POSTTYPE,
											'posts_per_page' => 300,
											'post_status'    => 'publish'
										);
										$posts_array = get_posts( $args );
										foreach ( $posts_array as $prd ) {

											if ( $prd->ID == get_option( ATKP_PLUGIN_PREFIX . '_nota_template' ) ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . $prd->ID . '"' . $sel . '>' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
										};
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox" id="<?php echo ATKP_PLUGIN_PREFIX . '_nota_disable_link' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_nota_disable_link' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_nota_disable_link' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_nota_disable_link' ?>">
									<?php _e( 'Disable text link if not available', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>


                        <!-- xx-->

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Text', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-text' ); ?>
                            </th>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Maximum title length', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="number" min="0" max="1000"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_short_title_length' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_short_title_length' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_short_title_length', 0 ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Maximum description length', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="number" min="0" max="1000"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_description_length' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_description_length' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_description_length', 0 ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Maximum feature count', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="number" min="0" max="1000"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_feature_count' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_feature_count' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_feature_count', 0 ); ?>">
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Description & Features', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_boxcontent' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_boxcontent' ?>" style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_boxcontent' );

									echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Features and (if empty) description ', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Features', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Description', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Product page text', ATKP_PLUGIN_PREFIX ) . ' (html)' ?>:
                                </label>
                            </th>
                            <td>
                                <input style="width:100%" type="text"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_productpage_title' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_productpage_title' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_productpage_title', __( 'View Product', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>


                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Yes symbol', ATKP_PLUGIN_PREFIX ) . ' (html)' ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_text_yes' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_text_yes' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_text_yes', '' ) ); ?>">

                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'No symbol', ATKP_PLUGIN_PREFIX ) . ' (html)' ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%" id="<?php echo ATKP_PLUGIN_PREFIX . '_text_no' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_text_no' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_text_no', '' ) ); ?>">
                            </td>
                        </tr>
                        <!--
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
                                <?php _e( 'Own reviews', ATKP_PLUGIN_PREFIX ) ?>
                            </th>
                        </tr> -->

                        <tr valign="top">
                            <td colspan="2">
                                <table style="width:100%">
                                    <tr valign="top">
                                        <th style="text-align:left">
                                            <label for="<?php echo ATKP_PLUGIN_PREFIX . '_predicate1_text' ?>">
												<?php echo __( 'Predicate 1', ATKP_PLUGIN_PREFIX ) ?> (html):
                                            </label>
                                        </th>
                                        <th style="text-align:left">
                                            <label for="<?php echo ATKP_PLUGIN_PREFIX . '_predicate2_text' ?>">
												<?php echo __( 'Predicate 2', ATKP_PLUGIN_PREFIX ) ?> (html):
                                            </label>
                                        </th>
                                        <th style="text-align:left">
                                            <label for="<?php echo ATKP_PLUGIN_PREFIX . '_predicate3_text' ?>">
												<?php echo __( 'Predicate 3', ATKP_PLUGIN_PREFIX ) ?> (html):
                                            </label>
                                        </th>
                                    </tr>

                                    <tr valign="top">

                                        <td>
                                            <input style="width:100%" type="text"
                                                   id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate1_text' ?>"
                                                   name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate1_text' ?>"
                                                   value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_predicate1_text', __( 'Winner', ATKP_PLUGIN_PREFIX ) ) ); ?>">

                                            <br/><input type="text" class="color-field"
                                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate1_color' ?>"
                                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate1_color' ?>"
                                                        value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_predicate1_color', '#67bc45' ) ?>">
                                        </td>
                                        <td>
                                            <input style="width:100%" type="text"
                                                   id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate2_text' ?>"
                                                   name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate2_text' ?>"
                                                   value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_predicate2_text', __( 'Price Tip', ATKP_PLUGIN_PREFIX ) ) ); ?>">

                                            <br/><input type="text" class="color-field"
                                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate2_color' ?>"
                                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate2_color' ?>"
                                                        value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_predicate2_color', '#ffbd11' ) ?>">
                                        </td>
                                        <td>
                                            <input style="width:100%" type="text"
                                                   id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate3_text' ?>"
                                                   name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate3_text' ?>"
                                                   value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_predicate3_text', __( 'Custom', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                                            <br/><input type="text" class="color-field"
                                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_predicate3_color' ?>"
                                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_predicate3_color' ?>"
                                                        value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_predicate3_color', '#1081c5' ) ?>">

                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Review text', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_review_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_review_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_review_text', __( 'Review', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                                <br/><input type="text" class="color-field"
                                            id="<?php echo ATKP_PLUGIN_PREFIX . '_review_color' ?>"
                                            name="<?php echo ATKP_PLUGIN_PREFIX . '_review_color' ?>"
                                            value=" <?php echo get_option( ATKP_PLUGIN_PREFIX . '_review_color', '#9f9f9f' ) ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Test score 1', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_test_score1_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_test_score1_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score1_text', __( 'Very good', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Test score 2', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_test_score2_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_test_score2_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score2_text', __( 'Good', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Test score 3', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_test_score3_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_test_score3_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score3_text', __( 'Satisfying', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Test score 4', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_test_score4_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_test_score4_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score4_text', __( 'Enough', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo __( 'Test score 5', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_test_score5_text' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_test_score5_text' ?>"
                                       value="<?php echo esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score5_text', __( 'Insufficient', ATKP_PLUGIN_PREFIX ) ) ); ?>">
                            </td>
                        </tr>

                        <tr>
                            <td colspan="2">&nbsp;</td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Lists', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-list' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Amount of list entries (standard)', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="number" min="0" max="1000"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_list_default_count' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_list_default_count' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_list_default_count', 0 ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Searchform', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'searchform-setting' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Prefix price', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_price_prefix' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_price_prefix' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_prefix', '&euro;' ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Suffix price', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_price_suffix' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_searchform_price_suffix' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_suffix', '' ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Compare table & detail list', ATKP_PLUGIN_PREFIX ) ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Max products', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_max_products' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_max_products' ?>"
                                       value="<?php echo get_option( ATKP_PLUGIN_PREFIX . '_comparetable_max_products', 4 ); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Price position', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_price_position' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_price_position' ?>"
                                        style="width:300px">
									<?php
									$selected = get_option( ATKP_PLUGIN_PREFIX . '_comparetable_price_position' );

									echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Top and bottom ', ATKP_PLUGIN_PREFIX ) . '</option>';

									echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Top', ATKP_PLUGIN_PREFIX ) . '</option>';
									echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Bottom', ATKP_PLUGIN_PREFIX ) . '</option>';

									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_testresult' ?>">
									<?php _e( 'Show Testresult', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_productbutton' ?>">
									<?php _e( 'Show product button', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_linkbutton' ?>">
									<?php _e( 'Show primary button', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_moreoffers' ?>">
									<?php _e( 'Show Additional offers', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_manufacturer' ?>">
									<?php _e( 'Show manufacturer', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_availability' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_availability' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_show_availability', 1 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_show_availability' ?>">
									<?php _e( 'Show availability', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures' ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_detaillist_hide_emptyfeatures' ?>">
									<?php _e( 'Hide empty rows', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_horizontalscrollbars' ?>">
									<?php _e( 'Horizontal scrollbars (on desktops)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                                <input type="checkbox"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders' ?>"
                                       value="1" <?php echo checked( 1, get_option( ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders', 0 ), true ); ?>>
                                <label for="<?php echo ATKP_PLUGIN_PREFIX . '_comparetable_hideheaders' ?>">
									<?php _e( 'Hide headers (desktop)', ATKP_PLUGIN_PREFIX ) ?>
                                </label>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php submit_button( '', 'primary', 'savedisplay', false ); ?>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div> <?php
	}
}

?>