<?php
/**
 * Affiliate Toolkit
 * Diese Datei stellt eine erweiterte Cronjob-Funktionalität zur Verfügung.
 * Hiermit kan man auch eine große Anzahl an Dateien verarbeiten.
 */

// PHP-Konfiguration optimieren
@error_reporting( E_ALL );
//1 Stunde maximale Ausführungszeit aktivieren (falls erlaubt)
@ini_set( "max_execution_time", 3600 );
@ini_set( "memory_limit", "512M" );
define( 'WP_MAX_MEMORY_LIMIT' , '512M' );

$defaultloadpath = './../../../wp-load.php';

if(defined('WP_LOAD_PATH'))
	$defaultloadpath = WP_LOAD_PATH;

require($defaultloadpath);

$cron = new atkp_external_cron();
$cron->execute();

class atkp_external_cron {

	function execute() {

		$crontype = atkp_options::$loader->get_crontype();
		$mode     = ATKPTools::get_get_parameter( 'mode', 'string' );

		switch ( $crontype ) {
			default:
			case 'wpcron':
				//wp cron? nothing todo...
				throw new exception( 'external cronjob deactivated' );
				exit;
			case 'external':
			case 'externaloutput':
				$cronjob = new atkp_cronjob_new( $crontype == 'externaloutput' );
				$cronjob->do_work( false, $mode );
				break;
			case 'external-multi':
			case 'externaloutput-multi':
				$actual_link = ( isset( $_SERVER['HTTPS'] ) ? "https" : "http" ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$actual_link = explode( "?", $actual_link )[0];

				//aufruf der selben datei mit dem jeweiligen parameter
				//pro shop wird ein import gestartet
				//beim update der weiteren angebote darf das angebot nicht mehr gelöscht werden
				//davor müssen die hauptprodukte aktualisiert werden (erst diese aktualisieren die "weiteren angebote")

				$cronjob = new atkp_cronjob_new( $crontype == 'externaloutput-multi' );

				$shopidget = ATKPTools::get_get_parameter( 'shopid', 'int' );

				if ( $shopidget != '' ) {
					$cronjob->send_message( '### shopid ' . $shopidget . ' ###' );

					$cronjob->do_work( false, $mode );
				} else {
					$cronjob->do_multiwork( false, $actual_link, $mode );
				}


				break;
		}


		//exit the script
		exit;
	}

	function reconstruct_url( $url ) {
		$url_parts       = parse_url( $url );
		$constructed_url = $url_parts['scheme'] . '://' . $url_parts['host'] . ( isset( $url_parts['path'] ) ? $url_parts['path'] : '' );

		return $constructed_url;
	}

}

?>