<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_cj extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {
		if ( ! defined( "ATKP_CJ_Advertiser" ) ) {
			define( "ATKP_CJ_Advertiser", "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup" );
		}

		if ( ! defined( "ATKP_CJ_Product" ) ) {
			define( "ATKP_CJ_Product", "https://product-search.api.cj.com/v2/product-search" );
		}

	}

	public function get_maxproductcount() {
		return 100;
	}

	public function get_caption() {
		return __( 'Conversant (CJ) API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function send_request( $url, $developerkey = '' ) {

		if ( $developerkey == '' ) {
			$developerkey = $this->developerkey;
		}

		$args = array(
			'timeout' => 30,
			'headers' => 'Authorization: Bearer ' . $developerkey
		);
		//."\r\n".'Content-Type: application/xml',

		$result1 = wp_remote_get( $url, $args );

		return $this->check_response( $result1 );
	}

	public function check_response( $result ) {

		if ( is_wp_error( $result ) || ! isset( $result['response']['code'] ) || $result['response']['code'] != 200 ) {
			if ( is_wp_error( $result ) ) {
				$error_string = $result->get_error_message();
			} else {
				$error_string = $result['body'];
			}

			throw new Exception( $error_string );
		} else {
			return new SimpleXMLElement( $result['body'] );
		}
	}


	public function retrieve_browsenodes( $keyword ) {

	}

	public function check_configuration( $post_id ) {
		try {
			$apikey        = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey  = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$requester_cid = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_cj_requester_cid' );

			$message = '';
			if ( $apikey != '' && $apisecretkey != '' ) {

				$response = $this->send_request( ATKP_CJ_Advertiser . '?advertiser-ids=joined&requestor-cid=' . urlencode( $requester_cid ), $apisecretkey );

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration cj ***' );
					ATKPLog::LogDebug( $response->asXML() );
					ATKPLog::LogDebug( '*** check_configuration cj ***' );
				}

				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

				$subshops = array();
				/*
								echo '<pre>';
								var_dump($response->advertisers);
								echo '</pre>';
								exit;
				*/

				foreach ( $response->advertisers->advertiser as $advertiser ) {
					if ( $advertiser->{'relationship-status'} != 'joined' ) {
						continue;
					}

					//echo var_dump( $advertiser);exit;


					$subshop            = new subshop();
					$subshop->title     = (string) $advertiser->{'advertiser-name'};
					$subshop->title2    = (string) $advertiser->{'account-status'};
					$subshop->shopid    = (string) $advertiser->{'advertiser-id'};
					$subshop->programid = '1'; //$advertiser->advertiser->{'advertiser-id'};

					//$subshop->logourl = $this->checkimageurl($program['programlogo'], $enable_ssl);
					//$subshop->smalllogourl = $this->checkimageurl($program['programlogo'], $enable_ssl);

					array_push( $subshops, $subshop );

				}


				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );

			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_access_secret_key', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_enable_ssl', 'bool' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_cj_catalogid', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_catalogid', 'string' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_cj_requester_cid', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_requester_cid', 'string' ) );


		// $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		//if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'aff');

		//echo serialize($subshops);exit;

		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = '';
		$enablessl    = false;
		$requestor    = '';

		if ( $webservice == '9' ) {
			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$catalogid    = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_cj_catalogid' );

			$requestor = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_cj_requester_cid' );


			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$enablessl = true; // ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'PID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'cj-api' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_cj_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Developer-Key', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="password" id="<?php echo ATKP_SHOP_POSTTYPE . '_cj_access_secret_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_access_secret_key' ?>"
                       value="<?php echo $apisecretkey; ?>">
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Company-Code', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" id="<?php echo ATKP_SHOP_POSTTYPE . '_cj_requester_cid' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_requester_cid' ?>" value="<?php echo $requestor; ?>">
            </td>
        </tr>
<!--
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_cj_enable_ssl' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_enable_ssl' ?>"
                       value="1" <?php echo checked( 1, $enablessl, true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_cj_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>
-->
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Catalog-id (optional)', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_cj_catalogid' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_catalogid' ?>" value="<?php echo $catalogid; ?>">
            </td>
        </tr>

        <!--<tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php
		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'aff');
		?>
                            
                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;

					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $shopid = null;
	private $enable_ssl = false;

	private $aff_programId = null;
	private $aff_shopId = null;
	private $aff_catalogId = null;

	private $developerkey = null;
	private $pid = null;

	public function checklogon( $shop ) {
		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$apisecretkey     = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$this->enable_ssl = true; //ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		$aff_catalogId    = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_cj_catalogid' );

		if ( $aff_catalogId != '' ) {
			$this->aff_catalogId = explode( ',', $aff_catalogId );
		}

		if ( $apikey == '' || $apisecretkey == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$this->developerkey = $apisecretkey;
		$this->pid          = $apikey;

		$this->shopid        = $shop->id;
		$this->aff_programId = $shop->programid;
		$this->aff_shopId    = $shop->shopid;


	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->developerkey == null ) {
			throw new Exception( 'checklogon required' );
		}

		$products = new atkp_search_resp();

		$maxCount = 10;

        $requestUrl = ATKP_CJ_Product . '?advertiser-ids=' . urlencode( $this->aff_shopId ) . '&website-id=' . urlencode( $this->pid );


        switch ( $searchType ) {
            case 'ean':
                $requestUrl .= '&upc=' . urlencode( $keyword );

                break;
            case 'asin':
                $requestUrl .= '&advertiser-sku=' . urlencode( $keyword );
                //$requestUrl .= '&catalog-id='.urlencode('cjo:687');
                break;
            default:
                $requestUrl .= '&keywords=' . urlencode( $keyword ) . '&page-number=' . $pagination . '&records-per-page=' . $maxCount;


                break;
        }

        $response = $this->send_request( $requestUrl );

		$products->total = intval($response->products['total-matched']);
		$products->currentpage = intval($response->products['page-number']);
		$products->pagecount = ceil(floatval($products->total ) / floatval($maxCount));

        foreach ( $response->products->product as $productResp ) {

            if ( $this->aff_catalogId != null ) {

                if ( ! in_array( (string) $productResp->{'catalog-id'}, $this->aff_catalogId ) ) {
                    continue;
                }
            }

            $product = array();

            $product['asin']  = (string) $productResp->{'sku'};
            $product['title'] = (string) $productResp->{'name'};

            $product['saleprice']  = (string) $productResp->{'price'};
            $product['listprice']  = (string) $productResp->{'retailprice'};
            $product['producturl'] = ATKPTools::check_sslurl( (string) $productResp->{'buy-url'} );
            $product['ean']        = (string) $productResp->{'upc'};

            $product['imageurl'] = (string) $productResp->{'image-url'};

            $product['info'] = (string) $productResp->{'catalog-id'};

            $product['description'] = strlen( (string) $productResp->{'description'} ) > 350 ? substr( (string) $productResp->{'description'}, 0, 350 ) : (string) $productResp->{'description'};


            if ( $product['asin'] != '' ) {
                array_push( $products->products, $product );
            }
        }

		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product cj ***' );
			ATKPLog::LogDebug( serialize( $result->asXML() ) );
			ATKPLog::LogDebug( '*** fill_product cj ***' );
		}

		$productResp = $result;

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		//$myproduct->features =  $productResponse->getDescriptionShort();
		$myproduct->description = (string) $productResp->{'description'};
		$myproduct->title       = (string) $productResp->{'name'};
		$myproduct->asin        = (string) $productResp->{'sku'};


		//$myproduct->smallimageurl = $this->checkimageurl($result->Image60->ImageUrl);
		//$myproduct->mediumimageurl = $this->checkimageurl($result->Image120->ImageUrl);
		$myproduct->largeimageurl = $this->checkimageurl( (string) $productResp->{'image-url'} );
		$myproduct->producturl    = ATKPTools::check_sslurl( (string) $productResp->{'buy-url'} );

		//$myproduct->addtocarturl = $productResponse->getAlternativeDeeplink(false);


		$myproduct->saleprice      = (string) $productResp->{'price'};
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		$myproduct->listprice      = (string) $productResp->{'retailprice'};
		$myproduct->listpricefloat = $this->price_to_float( $myproduct->listprice );

		//$myproduct->shipping = $price->getDisplayShipping();
		//$myproduct->shippingfloat = $this->price_to_float($price->getDisplayShipping());


		$myproduct->productgroup = (string) $productResp->{'advertiser-category'};
		$myproduct->ean          = (string) $productResp->{'upc'};
		$myproduct->manufacturer = (string) $productResp->{'manufacturer-name'};

		//$myproduct->brand = $productResponse->getBrand();


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->developerkey == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption'    => __( 'All categories', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'Price-Ascending'  => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
				'Price-Descending' => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
				'Title-Ascending'  => __( 'Title ascending', ATKP_PLUGIN_PREFIX ),
				'Title-Descending' => __( 'Title descending', ATKP_PLUGIN_PREFIX ),
			)
		);


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'SortBy'    => __( 'Sort by', ATKP_PLUGIN_PREFIX ),
			'SortOrder' => __( 'Sort Order', ATKP_PLUGIN_PREFIX ),

			'MaximumPrice' => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'MinimumPrice' => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'Manufacturer' => __( 'Manufacturer', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}


	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {
			$requestUrl = ATKP_CJ_Product . '?advertiser-ids=' . urlencode( $this->aff_shopId ) . '&website-id=' . urlencode( $this->pid );

			try {
				switch ( $id_type ) {
					case 'ARTICLENUMBER':
					case 'ASIN':
						$requestUrl .= '&advertiser-sku=' . urlencode( $asin );
						break;
					case 'EAN':
						$requestUrl .= '&upc=' . urlencode( $asin );
						break;
					case 'TITLE':
						// perform a fulltext search
						$requestUrl .= '&keywords=' . urlencode( $asin );
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( GuzzleHttp\Exception\ClientException $e ) {
				$response = $e->getResponse();
				if ( isset( $response ) ) {
					$titlecheck = $response->getBody();
				} else {
					$titlecheck = $e->getMessage();
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			$response = $this->send_request( $requestUrl );

			$productfound = false;

			if ( empty( $titlecheck ) && isset( $response->products->product ) && sizeof( $response->products->product ) > 0 ) {
				foreach ( $response->products->product as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );


		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortByOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' || $nodeid == 'All' ) {
			$nodeid = '';
		}

		$minPrice     = '0';
		$maxPrice     = '0';
		$manufacturer = '';
		$brand        = '';

		$sortBy    = '';
		$sortOrder = '';

		if ( $sortByOrder != '' ) {
			switch ( $sortByOrder ) {
				case 'Price-Ascending':
					$sortBy    = 'Price';
					$sortOrder = 'asc';
					break;
				case 'Price-Descending':
					$sortBy    = 'Price';
					$sortOrder = 'dec';
					break;
				case 'Title-Ascending':
					$sortBy    = 'Name';
					$sortOrder = 'asc';
					break;
				case 'Title-Descending':
					$sortBy    = 'Name';
					$sortOrder = 'dec';
					break;
			}

			//TODO: sortierung übernhemen
		}


		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
				case 'SortBy':
					$sortBy = $value;
					break;
				case 'SortOrder':
					$sortOrder = $value;
					break;
				case 'MinimumPrice':
					$minPrice = $value;
					break;
				case 'MaximumPrice':
					$maxPrice = $value;
					break;
				case 'Manufacturer':
					$manufacturer = $value;
					break;

			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':

				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {

			$requestUrl = ATKP_CJ_Product . '?advertiser-ids=' . urlencode( $this->aff_shopId ) . '&website-id=' . urlencode( $this->pid );

			if ( $minPrice != '' && $minPrice != '0' ) {
				$requestUrl .= '&low-price=' . urlencode( $minPrice );
			}
			if ( $maxPrice != '' && $maxPrice != '0' ) {
				$requestUrl .= '&high-price=' . urlencode( $maxPrice );
			}

			$requestUrl .= '&page-number='.$x.'&records-per-page=' . $itemsperpage;

			//if($nodeid != '')
			//    $productsRequest->onlyFromCategories([$nodeid], false, false);
			if ( $manufacturer != '' ) {
				$requestUrl .= '&manufacturer-name=' . urlencode( $manufacturer );
			}

			if ( $sortBy != '' ) {
				$requestUrl .= '&sort-by=' . urlencode( $sortBy ) . '&sort-order=' . urlencode( $sortOrder );
			}

			if ( $keyword != '' ) {
				$requestUrl .= '&keywords=' . urlencode( $keyword );
			}

			$response = $this->send_request( $requestUrl );

			foreach ( $response->products->product as $productResp ) {
				array_push( $products, $this->fill_product( $productResp ) );

				if(count($products) >= $maxCount)
					break;
			}

			if(count($response->products->product) == 0 || count($products) >= $maxCount)
				break;
		}

		$mylist->products = $products;


		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}