<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_external_featuredimage {

	public function __construct() {
		add_filter( 'post_thumbnail_html', array( $this, 'post_thumbnail_html' ), 10, 5 );

		//return apply_filters( 'woocommerce_product_gallery_attachment_ids', array_filter( array_filter( (array) explode( ',', $this->product_image_gallery ) ), 'wp_attachment_is_image' ), $this );


		$importgallerymode = atkp_options::$loader->get_woo_imagegallerymode();
		switch ( $importgallerymode ) {
			case 0:
				//mache nichts
				break;
			case 1:
				//external image
				add_action( 'woocommerce_product_thumbnails', array( $this, 'custom_links' ) );
				break;
			case 2:
				//importiert die gallerie
				break;
			default:
				throw new exception( 'unknown $importgallerymode: ' . $importgallerymode );

		}

		add_action( 'save_post', array( &$this, 'wooproduct_detail_save' ) );

		//TODO: woocommerce gallerie
		//add_filter( 'woocommerce_product_gallery_attachment_ids', array($this, 'woocommerce_product_gallery_attachment_ids'), 10,2);
		//add_filter( 'woocommerce_single_product_image_thumbnail_html', array($this, 'woocommerce_single_product_image_thumbnail_html'), 10, 4 );
	}

	function wooproduct_detail_save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$posttype = ATKPTools::get_post_parameter( 'post_type', 'string' );

		if ( 'product' != $posttype ) {
			return;
		}

		$importimagemode = atkp_options::$loader->get_woo_importimagemode();

		switch ( $importimagemode ) {
			case 0:
			case 1:
				//mache nichts
				break;
			case 2:
				//verlinkt das bild mit dem externen bild
				$featuredimage = new atkp_external_featuredimage();
				$featuredimage->set_external_postimage( $post_id );
				break;
			default:
				throw new exception( 'unknown imagemode: ' . $importimagemode );
		}
	}

	function custom_links() {

		$prdid = $this->get_productid();

		if ( ! $prdid ) {
			return;
		}

		//TODO: css attribute von woo holen und mitgeben
		$myproduct = atkp_product::load( $prdid );

		if ( is_array( $myproduct->images ) && ! defined( 'ATKP_WOOIMAGES' ) ) {
			define( 'ATKP_WOOIMAGES', 1 );
			$loop    = 0;
			$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
			$html    = '<div class="thumbnails columns-' . $columns . '">';

			foreach ( $myproduct->images as $image ) {
				$thumb_url = $image->mediumimageurl;
				if ( $thumb_url == '' ) {
					$thumb_url = $image->smallimageurl;
				}
				if ( $thumb_url == '' ) {
					$thumb_url = $image->largeimageurl;
				}

				$image_url = $image->largeimageurl;
				if ( $image_url == '' ) {
					$image_url = $image->mediumimageurl;
				}
				if ( $image_url == '' ) {
					$image_url = $image->smallimageurl;
				}

				$title = $myproduct->title;

				$classes = array( 'zoom' );

				if ( $loop === 0 || $loop % $columns === 0 ) {
					$classes[] = 'first';
				}

				if ( ( $loop + 1 ) % $columns === 0 ) {
					$classes[] = 'last';
				}

				$image_class = implode( ' ', $classes );


				$props = array();

				echo apply_filters(
					'woocommerce_single_product_image_thumbnail_html',
					sprintf(
						'<a href="%s" class="%s" title="%s" data-rel="prettyPhoto[product-gallery]">%s</a>',
						esc_url( $image_url ),
						esc_attr( $image_class ),
						esc_attr( $title ),
						$this->get_external_image( $thumb_url, $title, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), false, $props )
					),
					'atkp-' . $loop,
					$prdid,
					esc_attr( $image_class )
				);

				$loop ++;
			}
			$html .= '</div>';
			echo $html;
		}

	}

	function get_external_image( $image_url, $title, $size = 'thumbnail', $icon = false, $attr = '' ) {
		$html = '';

		$width  = 150;
		$height = 150;

		$src = $image_url;
		//list($src, $width, $height) = $image_url;
		$hwstring   = image_hwstring( $width, $height );
		$size_class = $size;
		if ( is_array( $size_class ) ) {
			$size_class = join( 'x', $size_class );
		}

		$default_attr = array(
			'src'   => $src,
			'class' => "attachment-$size_class size-$size_class",
			'alt'   => trim( strip_tags( $title ) ),
			'style' => 'display:initial;width:150px;height:150px'
		);

		$attr = wp_parse_args( $attr, $default_attr );

		/**
		 * Filters the list of attachment image attributes.
		 *
		 * @since 2.8.0
		 *
		 * @param array $attr Attributes for the image markup.
		 * @param WP_Post $attachment Image attachment post.
		 * @param string|array $size Requested size. Image size or array of width and height values
		 *                                 (in that order). Default 'thumbnail'.
		 */
		$attr = apply_filters( 'wp_get_attachment_image_attributes', $attr, 'atkp', $size );
		$attr = array_map( 'esc_attr', $attr );
		$html = rtrim( "<img $hwstring" );
		foreach ( $attr as $name => $value ) {
			$html .= " $name=" . '"' . $value . '"';
		}
		$html .= ' />';


		return $html;
	}

	public function get_external_properties( $attachment_id ) {
		$prdid = $this->get_productid();

		if ( $attachment_id == '_atkp' ) {
			$props['alt'] = $props['caption'] = $props['title'] = ATKPTools::get_post_setting( $prdid, ATKP_PRODUCT_POSTTYPE . '_title' );
			$props['url'] = $this->get_imageurl( '', '', $prdid );
		} else {
			//subimage
			$props['alt'] = $props['caption'] = $props['title'] = ATKPTools::get_post_setting( $prdid, ATKP_PRODUCT_POSTTYPE . '_title' );
			$props['url'] = $this->get_imageurl( '', '', $prdid );

		}

		return $props;
	}

	function woocommerce_single_product_image_thumbnail_html( $sprintf, $attachment_id, $post_id, $attr ) {
		if ( strlen( $attachment_id ) >= 5 && substr( $attachment_id, 0, 5 ) == '_atkp' ) {
			//echo 'xx:'.serialize(substr($attachment_id, 6));

			$html = '<figure data-thumb="' . substr( $attachment_id, 6 ) . '" class="woocommerce-product-gallery__image">';
			//$html .= substr($attachment_id, 6);//wp_get_attachment_image( $attachment_id, 'shop_single', false, $attributes );
			$class = '';
			if ( isset( $attr['class'] ) ) {
				$class .= $attr['class'];
			}

			$style = isset( $attr['style'] ) ? 'style="' . $attr['style'] . '" ' : null;

			$html .= sprintf( '<img src="%s" %s' . 'class="%s " ' . 'alt="%s" />', esc_attr( substr( $attachment_id, 6 ) ), $style, $class, esc_attr( 'xx' ) );


			$html .= '</figure>';

			$sprintf = $html;
		}

		return $sprintf;
	}

	public function woocommerce_product_gallery_attachment_ids( $images, $product ) {

		$prdid = $this->get_productid( $product->id );

		//echo serialize($prdid);exit;

		//TODO: css attribute von woo holen und mitgeben
		$myproduct = atkp_product::load( $prdid );

		$idx = 0;
		if ( is_array( $myproduct->images ) ) {
			foreach ( $myproduct->images as $image ) {

				array_push( $images, '_atkp_' . $idx );

				$idx += 1;
			}
		}

		return $images;
	}

	public function set_external_postimage( $post_id ) {
		$external_thumbnail  = $this->has_external_thumbnail( $post_id );
		$wordpress_thumbnail = get_post_meta( $post_id, '_thumbnail_id', true );

		if ( $external_thumbnail && ! $wordpress_thumbnail ) {
			update_post_meta( $post_id, '_thumbnail_id', '_atkp' );
		}

		if ( ! $external_thumbnail && $wordpress_thumbnail == '_atkp' ) {
			delete_post_meta( $post_id, '_thumbnail_id' );
		}

	}

	public function post_thumbnail_html( $html, $post_id, $post_image_id, $size, $attr ) {
		$wordpress_thumbnail = get_post_meta( $post_id, '_thumbnail_id', true );

		//nur das externe bild anzeigen wenn es auch wirklich eines ist!
		if ( $wordpress_thumbnail != '_atkp' ) {
			return $html;
		} else if ( $this->has_external_thumbnail( $post_id ) ) {
			$html = $this->get_external_thumbnail( $post_id, $size, $attr );
		}

		return $html;
	}

	public function has_external_thumbnail( $post_id = null ) {
		$thumbnail = $this->get_productid( $post_id );

		if ( ! $thumbnail || $thumbnail == '' ) {
			return false;
		} else {
			return true;
		}
	}

	public function get_productid( $post_id = null ) {
		$post_id = ( null === $post_id ) ? get_the_ID() : $post_id;

		//prüfen ob atkp-produkt dann image holen
		//prüfen ob woocommerce-produkt dann image holen
		//prüfen ob hauptprodukt?
		//überprüfen ob aktiviert

		$posttype = get_post_type( $post_id );

		if ( $posttype == ATKP_PRODUCT_POSTTYPE ) {
			//at-product
			$importProductimage = atkp_options::$loader->get_product_importimagemode();

			if ( $importProductimage != 2 ) {
				return false;
			}

		} else if ( $posttype == 'product' ) {

			$productid = ATKPTools::get_post_setting( $post_id, ATKP_PLUGIN_PREFIX . '_sourceproductid' );

			if ( $productid != '' && $productid != 0 ) {
				$post_id = $productid;
			} else {

				//woocommerce
				//INFO: Auch in external_featuredimage in verwendung
				$eanfield = atkp_options::$loader->get_woo_ean_field();
				$keytype  = atkp_options::$loader->get_woo_keytype();

				if ( $eanfield == '' || $eanfield == 'sku' ) {
					$ean = ATKPTools::get_post_setting( $post_id, '_sku' );
				} else {
					$ean = ATKPTools::get_post_setting( $post_id, $eanfield );
				}


				if ( $keytype == 'id' ) {
					$exists = atkp_product::exists( $ean );

					if ( $exists ) {
						$post_id = $ean;
					} else {
						return false;
					}
				} else {
					$post_id = atkp_product::idbyean( $ean );
				}
			}
		}

		return $post_id;
	}

	public function get_external_thumbnail( $post_id = null, $size = false, $attr = array() ) {
		global $_wp_additional_image_sizes;

		$class = '';

		$width  = 0;
		$height = 0;

		if ( is_array( $size ) ) {
			$width  = $size[0];
			$height = $size[1];
		} else if ( isset( $_wp_additional_image_sizes[ $size ] ) ) {
			$width  = $_wp_additional_image_sizes[ $size ]['width'];
			$height = $_wp_additional_image_sizes[ $size ]['height'];
			$class  = 'attachment-' . $size . ' ';
		}

		$imageurl = '';
		$title    = '';

		$prdid = $this->get_productid( $post_id );
		$title = ATKPTools::get_post_setting( $prdid, ATKP_PRODUCT_POSTTYPE . '_title' );

		$imageurl = $this->get_imageurl( $width, $height, $prdid );

		if ( $imageurl == '' ) {
			return false;
		}

		$redirtype = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_product_imagetype', 0 );

		switch ( $redirtype ) {
			default:
				//disabled
				break;
			case 2:
			case 3:
				$outfile = plugins_url( '/tools/atkp_imagereceiver.php', ATKP_PLUGIN_FILE );

				$imageurl = $outfile . '?image=' . rawurlencode( base64_encode( $imageurl ) );
				break;
		}


		if ( isset( $attr['class'] ) ) {
			$class .= $attr['class'];
		}

		$style = isset( $attr['style'] ) ? 'style="' . $attr['style'] . '" ' : null;

		//if (is_feed()) {
		//	$html = sprintf('<img src="%s" %s' . 'class="%s wp-post-image" '. 'alt="%s" />', esc_attr($imageurl), $style, $additional_classes, $title);
		//} else {
		$html = sprintf( '<img src="%s" %s' . 'class="%s wp-post-image" ' . 'alt="%s" />', esc_attr( $imageurl ), $style, $class, esc_attr( $title ) );

		//}

		return $html;
	}

	public function get_imageurl( $width, $height, $prdid ) {
		if ( ( $width == '' || $width == 0 || $width >= 600 ) && ( $height == '' || $height == 0 || $height >= 600 ) ) {
			$imageurl = atkp_product::get_mainimage( $prdid, 'largetosmall' );
		} else {
			$imageurl = atkp_product::get_mainimage( $prdid, 'mediumtolarge' );
		}

		return $imageurl;
	}


}