<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! defined( 'ATKP_VERSION_CSV' ) ) {
	define( 'ATKP_VERSION_CSV', 2 );
}

class atkp_shop_provider_livecsv extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_maxproductcount() {
		return 10;
	}

	public function get_caption() {
		return __( 'Live CSV API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	function get_table_fields() {
		$fields = array();

		$fields[ ATKP_PRODUCT_POSTTYPE . '_asin' ]          = __( 'Unique productid', ATKP_PLUGIN_PREFIX ) . '*';
		$fields[ ATKP_PRODUCT_POSTTYPE . '_title' ]         = __( 'Title', ATKP_PLUGIN_PREFIX ) . '*';
		$fields[ ATKP_PRODUCT_POSTTYPE . '_ean' ]           = __( 'EAN', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_isbn' ]          = __( 'ISBN', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_mpn' ]           = __( 'MPN', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_description' ]   = __( 'Description', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_features' ]      = __( 'Features', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_author' ]        = __( 'Author', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_numberofpages' ] = __( 'Number of pages', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_manufacturer' ]  = __( 'Manufacturer', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_brand' ]         = __( 'Brand', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_productgroup' ]  = __( 'Product group', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_releasedate' ]   = __( 'Release date', ATKP_PLUGIN_PREFIX );


		$fields[ ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ]  = __( 'Small image URL', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ] = __( 'Medium image URL', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ]  = __( 'Large image URL', ATKP_PLUGIN_PREFIX );


		$fields[ ATKP_PRODUCT_POSTTYPE . '_listprice' ]       = __( 'List price', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_saleprice' ]       = __( 'Sale price', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_amountsaved' ]     = __( 'Amount saved', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_percentagesaved' ] = __( 'Percentage saved', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_availability' ]    = __( 'Availability', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_shipping' ]        = __( 'Shipping', ATKP_PLUGIN_PREFIX );

		$fields[ ATKP_PRODUCT_POSTTYPE . '_rating' ]      = __( 'Rating', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_reviewcount' ] = __( 'Amount of reviews', ATKP_PLUGIN_PREFIX );

		$fields[ ATKP_PRODUCT_POSTTYPE . '_producturl' ]         = __( 'Product page URL', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_addtocarturl' ]       = __( 'Add to cart URL', ATKP_PLUGIN_PREFIX );
		$fields[ ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' ] = __( 'Customer Reviews URL', ATKP_PLUGIN_PREFIX );

		if ( ATKP_PLUGIN_VERSION >= 30 ) {
			$customfields = atkp_udfield::load_fields();

			foreach ( $customfields as $customfield ) {
				$fields[ $customfield->name ] = $customfield->caption == '' ? $customfield->name : $customfield->caption;
			}

			if ( atkp_options::$loader->get_fieldgroups_enabled() ) {

				$groups = ATKPTools::get_fieldgroups();

				foreach ( $groups as $group ) {
					$customfields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

					if ( $customfields != null ) {
						foreach ( $customfields as $customfield ) {
							$fields[ $customfield->name ] = $customfield->caption == '' ? $customfield->name : $customfield->caption;
						}
					}
				}
			}
		}

		return $fields;
	}

	private function get_settings( $post_id ) {

		$separator     = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_delimiter' );
		$endoflineflag = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_endofline' );
		$encapsed      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_textfield' );
		$encoding      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_encoding' );
		$compression   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_compression' );

		$usestream = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream' );

		switch ( $separator ) {
			default:
			case 'tab':
				$separator = "\t";
				break;

			case 'comma':
				$separator = ",";
				break;

			case 'semicolon':
				$separator = ";";
				break;

			case 'pipe':
				$separator = "|";
				break;

			case 'carret':
				$separator = "^";
				break;


		}

		switch ( $endoflineflag ) {
			default:
			case 'crlf':
				$endoflineflag_chars = "\r\n";
				break;

			case 'lf':
				$endoflineflag_chars = "\n";
				break;
		}

		switch ( $encapsed ) {

			case 'singlequote':
				$encapsed = "'";
				break;
			default:
			case 'doublequote':
				$encapsed = '"';
				break;
		}

		switch ( $usestream ) {

			case 'download':
				$usestream = false;
				break;
			default:
			case 'filestream':
				if ( $this->is_file_stream_supported() ) {
					$usestream = true;
				} else {
					$usestream = false;
				}
				break;
		}

		return ( array(
			'separator'   => $separator,
			'encapsed'    => $encapsed,
			'endofline'   => $endoflineflag_chars,
			'encoding'    => $encoding,
			'compression' => $compression,
			'usestream'   => $usestream
		) );
	}

	//opens a file via wp_remote_get ... very memory consuming and gzip is not supported
	function get_csv_content_get( $url, $settings, $rawstring = false ) {

		$result = wp_remote_get( $url, array( 'timeout' => 120, 'httpversion' => '1.1' ) );


		if ( is_wp_error( $result ) ) {
			throw new exception( $result->get_error_message() );
		}

		if ( $rawstring ) {
			return $result['body'];
		} else {

			$csv = explode( $settings['endofline'], $result['body'] );

			unset( $result );

			return $csv;
		}
	}

	//this saves a lot of resources if we do it for each line during processing instead of the whole array
	function helper_onthefly_extraction( $csv_line, $settings ) {

		$entry = str_getcsv( $csv_line, $settings['separator'], $settings['encapsed'], '\\' );

		return $entry;

	}


	public function check_configuration( $post_id ) {
		try {

			$csvurl              = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_url' );
			$firstrowcolumheader = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' );
			$usestream           = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream' );

			$message      = '';
			$this->shopid = $post_id;
			$settings     = $this->get_settings( $post_id );

			$columns = $this->get_file_columns( $csvurl, $settings );

			if ( ! $firstrowcolumheader ) {
				//fix column names for reading

				foreach ( $columns as $i => $caption ) {
					$columns[ $i ] = __( 'Column ', ATKP_PLUGIN_PREFIX ) . ( $i + 1 );
				}
			}

			ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_columns', $columns );

			$columns = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_columns' );

			$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );
			if ( $subshops == null ) {
				$subshops = array();

				//add subshop for amazon
				$subshop         = new subshop();
				$subshop->title  = __( 'Live CSV File', ATKP_PLUGIN_PREFIX );
				$subshop->shopid = $post_id;

				$subshop->enabled = true;

				array_push( $subshops, $subshop );

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );
			}

			if ( $csvurl == '' ) {
				$message = "Url is empty";
			} else if ( ! is_array( $columns ) || count( $columns ) <= 1 ) {
				$message = "Columns not found";
			} else {
				$columnconfig = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );

				if ( isset( $columnconfig ) && $columnconfig != '' && is_array( $columnconfig ) ) {
					foreach ( $columnconfig as $config ) {
						if ( $config->name == 'ProductNumber' || $config->name == 'ProductName' ) {
							$id = $config->field !== '' ? intval( $config->field ) : - 1;
							if ( $id == - 1 ) {
								$message = $config->name . ' is required';
							}
							break;
						}

					}
				}
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	private function encode_array( $line, $settings ) {
		if ( $settings['encoding'] == '' || $settings['encoding'] == 'UTF-8' ) {
			return $line;
		} else {
			//'UTF-8, ISO-8859-1'
			$newline = array();

			foreach ( $line as $col ) {
				array_push( $newline, mb_convert_encoding( $col, 'UTF-8', mb_detect_encoding( $col, $settings['encoding'], true ) ) );
			}

			return $newline;
		}
	}

	function get_fp( $url, $settings ) {

		$compression = isset( $settings['compression'] ) ? $settings['compression'] : 'none';

		switch ( $compression ) {
			default:
				$opts = array(
					'http' => array( 'header' => 'Accept-Charset: UTF-8, *;q=0' )
				);
				break;
			case 'gzip':
				$opts = array(
					'http' => array(
						'method' => "GET",
						'header' => "Accept-Encoding: gzip,deflate,sdchrn" .
						            "Accept-Charset:UTF-8,*;q=0.5rn"
					)
				);
				break;
		}

		$context = stream_context_create( $opts );

		switch ( $compression ) {
			default:
				$fp = fopen( $url, 'r', false, $context );
				break;
			case 'gzip':
				if ( ATKPTools::startsWith( $url, 'https' ) ) {
					$url = str_replace( 'https://', '', $url );
					$url = str_replace( '//', '/%2C/', $url );
					$url = 'https://' . $url;
				}

				$fp = gzopen( $url, 'r' );
				break;
		}

		return $fp;
	}

	private function delete_cachefile( $shopid ) {
		$upload_dir = wp_upload_dir(); // Set upload folder
		$filename   = $upload_dir['basedir'] . '/at_csvshop_' . $shopid . '.txt';

		if ( file_exists( $filename ) ) {
			unlink( $filename );
		}


	}

	private function get_cachefile( &$url, &$settings ) {


		$upload_dir = wp_upload_dir(); // Set upload folder

		$filename = $upload_dir['basedir'] . '/at_csvshop_' . $this->shopid . '.txt';
		$fileurl  = $upload_dir['baseurl'] . '/at_csvshop_' . $this->shopid . '.txt';

		try {
//wenn die datei existiert und nicht älter als 2 stunden ist
			if ( file_exists( $filename ) && ! ( time() - filemtime( $filename ) > 2 * 3600 ) ) {


			} else {

				if ( $settings['usestream'] ) {
					$i_handle = $this->get_fp( $url, $settings );
					$o_handle = fopen( $filename, 'wb' );

					$chunksize = 10 * ( 1024 * 1024 ); // 10 Megs

					/**
					 * Start reading in the remote file, and writing it to the
					 * local file one chunk at a time.
					 */
					$cnt = 0;
					while ( ! feof( $i_handle ) ) {
						$buf = '';
						$buf = fread( $i_handle, $chunksize );

						if ( $buf == false ) {
							break;
						}

						$bytes = fwrite( $o_handle, $buf );
						if ( $bytes == false ) {
							return;
						}
						$cnt += $bytes;

					}

					fclose( $i_handle );
					fclose( $o_handle );
				} else {
					$csv = $this->get_csv_content_get( $url, $settings, true );

					file_put_contents( $filename, $csv );
				}

			}

			$url                     = $fileurl;
			$settings['compression'] = 'none';

		} catch ( Exception $e ) {
			//TODO: do nothing..?
		}
	}

	public function get_file_columns( $url, $settings ) {

		$this->get_cachefile( $url, $settings );

		//open first line via stream
		if ( $settings['usestream'] ) {//$this->is_file_stream_supported()

			$fp = $this->get_fp( $url, $settings );

			while ( $line = fgetcsv( $fp, 0, $settings['separator'], $settings['encapsed'] ) ) {
				return $this->encode_array( $line, $settings );
			}

			fclose( $fp );

		} else {
			//open via get - full csv in memory
			$csv = $this->get_csv_content_get( $url, $settings );

			//wenn das csv nur eine zeile hat, dann passt der linebreak nicht
			if ( count( $csv ) <= 1 ) {
				return strlen( $csv[0] ) > 500 ? substr( $csv[0], 0, 500 ) : $csv[0];
			} else {
				foreach ( $csv as $i => $csv_line ) {
					/* important: we use the on the fly extraction because it saves a LOT of memory during processing */
					$entry = $this->helper_onthefly_extraction( $csv_line, $settings );

					return $this->encode_array( $entry, $settings );
				}
			}

			unset( $csv );
		}

		return null;
	}

	private function is_file_stream_supported() {
		//return false;
		return ini_get( 'allow_url_fopen' ) == 'on' || ini_get( 'allow_url_fopen' ) == 'On' || ini_get( 'allow_url_fopen' ) == '1';
	}


	public function search_csv( $shopid, $searchtype, $value, $maxCount, $offset ) {
		if ( $searchtype == 'asin' || $searchtype == 'ean' ) {
			$maxCount = 1;
		}

		$settings = $this->get_settings( $shopid );
		$url      = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_url' );

		//TODO: cache csv file local
		$this->get_cachefile( $url, $settings );

		if ( $url == '' || $url == null ) {
			return;
		}

		ini_set( 'max_execution_time', 300 ); //300 seconds = 5 minutes

		$columnconfig        = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );
		$firstrowcolumheader = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' );
		$insert_count        = 0;
		$ignoredcount        = 0;
		$products            = array();

		//approach via stream, fopen ON
		if ( $settings['usestream'] ) {

			$fp = $this->get_fp( $url, $settings );

			$y = 1;

			while ( $line = fgetcsv( $fp, 0, $settings['separator'], $settings['encapsed'] ) ) {
				if ( $firstrowcolumheader && $y == 1 ) {
					//first line is columnheader
				} else {

					$product = $this->check_csv_row( $shopid, $searchtype, $value, $columnconfig, $this->encode_array( $line, $settings ), $y );
					if ( $product != null ) {
						$insert_count ++;

						if ( $offset > 0 && $ignoredcount < $offset ) {
							$ignoredcount ++;
							continue;
						}

						array_push( $products, $product );
					}

				}

				if ( $maxCount > 0 && count( $products ) >= $maxCount ) {
					break;
				}

				//unset, important
				unset( $line );
				$y ++;
			}

			fclose( $fp );

		} else {
			//classical approach via get, fopen OFF
			$csv = $this->get_csv_content_get( $url, $settings );

			foreach ( $csv as $i => $csv_line ) {
				$y = $i + 1;
				//check if resume is required
				//if we have to resume rapidly find the position to continue from

				if ( $firstrowcolumheader && $y == 1 ) {
					//first line is columnheader
				} else {

					/* important: we use the on the fly extraction because it saves a LOT of memory during processing */
					$entry = $this->helper_onthefly_extraction( $csv_line, $settings );

					//last entry has size of 1 ... we dont want to pass it
					if ( sizeof( $entry ) == 1 ) {
						continue;
					}

					$product = $this->check_csv_row( $shopid, $searchtype, $value, $columnconfig, $this->encode_array( $entry, $settings ), $y );
					if ( $product != null ) {
						$insert_count ++;


						if ( $offset > 0 && $ignoredcount < $offset ) {
							$ignoredcount ++;
							continue;
						}

						array_push( $products, $product );
					}
				}

				if ( $maxCount >= 0 && count( $products ) >= $maxCount ) {
					break;
				}
			}

			unset( $csv );
		}

		return $products;
	}

	private function str_contains( $string, $searchstring, $caseSensitive = true ) {
		return ATKPTools::str_contains( $string, $searchstring, $caseSensitive );
	}

	private function fill_product( $columnconfig, $datarow ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product csv ***' );
			ATKPLog::LogDebug( serialize( $datarow ) );
			ATKPLog::LogDebug( '*** fill_product csv ***' );
		}

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$fields = $this->get_table_fields();

		foreach ( $fields as $field => $value ) {

			switch ( $field ) {
				case ATKP_PRODUCT_POSTTYPE . '_asin':
					$myproduct->asin = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_asin' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_title':
					$myproduct->title = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_title' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_ean':
					$myproduct->ean = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_ean' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_isbn':
					$myproduct->isbn = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_isbn' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_mpn':
					$myproduct->mpn = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_mpn' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_description':
					$myproduct->description = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_description' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_features':
					$myproduct->features = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_features' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_author':
					$myproduct->author = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_author' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_numberofpages':
					$myproduct->numberofpages = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_numberofpages' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_manufacturer':
					$myproduct->manufacturer = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_manufacturer' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_brand':
					$myproduct->brand = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_brand' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_productgroup':
					$myproduct->productgroup = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_productgroup' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_releasedate':
					$myproduct->releasedate = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_releasedate' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_smallimageurl':
					$myproduct->smallimageurl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_smallimageurl' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_mediumimageurl':
					$myproduct->mediumimageurl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_largeimageurl':
					$myproduct->largeimageurl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_largeimageurl' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_listprice':
					$myproduct->listprice      = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_listprice' );
					$myproduct->listpricefloat = $this->price_to_float( $myproduct->listprice );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_saleprice':
					$myproduct->saleprice      = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_saleprice' );
					$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_amountsaved':
					$myproduct->amountsaved = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_amountsaved' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_percentagesaved':
					$myproduct->percentagesaved = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_percentagesaved' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_availability':
					$myproduct->availability = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_availability' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_shipping':
					$myproduct->shipping      = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_shipping' );
					$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_rating':
					$myproduct->rating = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_rating' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_reviewcount':
					$myproduct->reviewcount = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_reviewcount' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_producturl':
					$myproduct->producturl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_producturl' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_addtocarturl':
					$myproduct->addtocarturl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_addtocarturl' );
					break;
				case ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl':
					$myproduct->customerreviewsurl = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' );
					break;
				default:
					$val = livecolumnconfig::get_csv_value( $columnconfig, $datarow, $field );

					if($val != null)
    					$myproduct->customfields[ $field ] = $val;
					break;
			}

		}

		return $myproduct;

	}

	public function check_csv_row( $shopid, $searchtype, $value, $columnconfig, $datarow, $linenumber ) {

		$found = false;

		switch ( $searchtype ) {
			case 'asin':
				$asin = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_asin' );

				if ( $asin == $value ) {
					$found = true;
				}

				break;
			case 'ean':
				$ean = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_ean' );

				if ( $ean == $value ) {
					$found = true;
				}

				break;
			default:
				$title = livecolumnconfig::get_csv_value( $columnconfig, $datarow, ATKP_PRODUCT_POSTTYPE . '_title' );


				if ( $this->str_contains( $title, $value, false ) ) {
					$found = true;
				}
				break;
		}


		if ( $found ) {
			//build the product
			return $this->fill_product( $columnconfig, $datarow );
		}

		return null;
	}

	public function set_configuration( $post_id ) {
		//var_dump($_POST);exit;
		$selectedcolumns = array();
		$delimiter       = '';
		$firstlineheader = false;
		$endofline       = '';
		$textfield       = '';
		$compression     = '';
		$usestream       = $this->is_file_stream_supported();

		$predefined = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_predefined', 'string' );

		if ( $predefined != null && $predefined != '' ) {
			switch ( $predefined ) {
				case 'adcell':
					$selectedcolumns = unserialize( 'a:14:{i:0;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:7;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:3;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:4;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:12;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:11;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:22;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:14;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:9;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'semicolon';
					$firstlineheader = true;
					$endofline       = 'lf';
					$textfield       = 'doublequote';
					break;
				case 'webgains':
					$selectedcolumns = unserialize( 'a:14:{i:0;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:11;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:17;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:7;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:15;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:24;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:21;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:22;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'comma';
					$firstlineheader = true;
					$endofline       = 'clrf';
					$textfield       = 'doublequote';
					break;

				case 'awin':
					$selectedcolumns = unserialize( 'a:18:{i:0;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:2;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:13:"ProductNumber";s:8:"fallback";s:0:"";}}i:1;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductTitle";s:8:"fallback";s:0:"";}}i:2;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:10:"ProductEAN";s:8:"fallback";s:0:"";}}i:3;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductISBN";s:8:"fallback";s:0:"";}}i:4;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:5;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:18:"ProductDescription";s:8:"fallback";s:0:"";}}i:5;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:15:"ProductFeatures";s:8:"fallback";s:0:"";}}i:6;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:14;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductPrice";s:8:"fallback";s:0:"";}}i:7;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:0;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:11:"ProductLink";s:8:"fallback";s:0:"";}}i:8;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:12;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:17:"ProductSmallImage";s:8:"fallback";s:0:"";}}i:9;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductImage";s:8:"fallback";s:0:"";}}i:10;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductAvailability";s:8:"fallback";s:0:"";}}i:11;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:15;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:20:"ProductShippingCosts";s:8:"fallback";s:0:"";}}i:12;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:8;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:19:"ProductManufacturer";s:8:"fallback";s:0:"";}}i:13;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductBrand";s:8:"fallback";s:0:"";}}i:14;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText1";s:8:"fallback";s:0:"";}}i:15;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText2";s:8:"fallback";s:0:"";}}i:16;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText3";s:8:"fallback";s:0:"";}}i:17;O:12:"livecolumnconfig":1:{s:4:"data";a:6:{s:6:"prefix";s:0:"";s:5:"field";i:-1;s:6:"suffix";s:0:"";s:12:"toolkitfield";s:0:"";s:4:"name";s:12:"ProductText4";s:8:"fallback";s:0:"";}}}' );
					$delimiter       = 'comma';
					$firstlineheader = true;
					$endofline       = 'clrf';
					$textfield       = 'doublequote';
					$compression     = 'gzip';
					break;
				default:
					throw new exception( 'unknown predefined: ' . $predefined );
			}
			//adcell


		} else {
			$delimiter       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_delimiter', 'string' );
			$firstlineheader = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_firstlineheader', 'bool' );
			$endofline       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_endofline', 'string' );
			$textfield       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_textfield', 'string' );
			$compression     = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_compression', 'string' );
			$usestream       = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_usestream', 'string' );

			$fields = $this->get_table_fields();

			$id = 0;
			foreach ( $fields as $field => $caption ) {
				//proforma info: feldname
				$fieldname    = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_column_' . $field, 'string' );
				$toolkitfield = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_atfield_' . $field, 'string' );

				$prefix   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_prefix_' . $field, 'string' );
				$field2   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_field_' . $field, 'int' );
				$suffix   = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_suffix_' . $field, 'string' );
				$fallback = ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_fallback_' . $field, 'string' );

				$config = new livecolumnconfig();

				$config->prefix       = $prefix;
				$config->field        = $field2;
				$config->suffix       = $suffix;
				$config->toolkitfield = $toolkitfield;
				$config->name         = $fieldname;
				$config->fallback     = $fallback;

				array_push( $selectedcolumns, $config );
			}
		}


		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns', $selectedcolumns );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_encoding', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_encoding', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_url', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_livecsv_url', 'allhtml' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_delimiter', $delimiter );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader', $firstlineheader );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_endofline', $endofline );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_textfield', $textfield );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_compression', $compression );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_csv_usestream', $usestream );

		$this->delete_cachefile( $post_id );
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$csvurl          = '';
		$apisecretkey    = '';
		$customlogo      = '';
		$customlogosmall = '';
		$subshops        = null;

		if ( $webservice == '11' ) {
			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );
		}
		?>
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
				<?php

				if ( $this->is_file_stream_supported() ) {
					echo '<span>' . __( 'The PHP setting "allow_url_fopen" is enabled. Everything OK.', ATKP_PLUGIN_PREFIX ) . '</span>';
				} else {
					echo '<span style="color:red">' . __( 'The PHP setting "allow_url_fopen" is required. Please enable the feature before using this api.', ATKP_PLUGIN_PREFIX ) . '</span>';
				}

				$upload_dir = wp_upload_dir(); // Set upload folder

				$uploadir = $upload_dir['basedir'];
				if ( ! is_writable( $uploadir ) ) {
					echo '<span style="color:red;display:block">' . __( 'The directory must be writeable: ', ATKP_PLUGIN_PREFIX ) . $uploadir . '</span>';
				}


				?>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'CSV-URL', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'csv-import' ); ?>
            </th>
            <td>
                <input style="width:40%" type="url" id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_url' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_url' ?>"
                       value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_url' ) ); ?>">
                <label for="">
                </label>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'CSV-Encoding', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:20%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_encoding' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_encoding' ?>"
                       value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_encoding' ) ); ?>">
                <label for="">
                </label>
            </td>
        </tr>

		<?php if ( $webservice == '' ) { ?>

            <tr valign="top">
                <th scope="row">
                    <label for="">
						<?php _e( 'Template', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>

                    <select style="width:40%" name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_predefined' ?>"
                            id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_predefined' ?>">
						<?php

						$durations = array(
							'adcell'   => __( 'Adcell', ATKP_PLUGIN_PREFIX ),
							'webgains' => __( 'Webgains', ATKP_PLUGIN_PREFIX ),
							'awin'     => __( 'AWIN', ATKP_PLUGIN_PREFIX ),
							''         => __( 'Manual', ATKP_PLUGIN_PREFIX ),
						);

						foreach ( $durations as $value => $name ) {

							echo '<option value="' . $value . '">' . esc_attr( $name ) . '</option>';
						} ?>
                    </select>


                    <script type="text/javascript">
                        var $j = jQuery.noConflict();
                        /*
												 * Attaches the image uploader to the input field
												 */
                        $j(document).ready(function ($) {


                            $j('#<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_predefined' ?>').change(function () {

                                if ($j('#<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_predefined' ?>').val() == '')
                                    $j('.atkp-manualrow').show();
                                else
                                    $j('.atkp-manualrow').hide();
                            });


                            $j('#<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_predefined' ?>').trigger("change");


                        });

                    </script>
                </td>
            </tr>


		<?php } ?>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Column delimiter', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_delimiter', 'tab' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_delimiter' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_delimiter' ?>">
					<?php

					$durations = array(
						'tab'       => __( 'Tabstopp', ATKP_PLUGIN_PREFIX ),
						'pipe'      => __( 'Pipe (|)', ATKP_PLUGIN_PREFIX ),
						'carret'    => __( 'Carret (^)', ATKP_PLUGIN_PREFIX ),
						'comma'     => __( 'Comma (,)', ATKP_PLUGIN_PREFIX ),
						'semicolon' => __( 'Semicolon (;)', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>


            </td>
        </tr>


        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_usestream' ?>">
					<?php _e( 'Use file stream', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_usestream' ); ?>


                <select name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_usestream' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_usestream' ?>">
					<?php

					$durations = array(
						''           => __( 'Auto', ATKP_PLUGIN_PREFIX ),
						'filestream' => __( 'Filestream', ATKP_PLUGIN_PREFIX ),
						'download'   => __( 'Download', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_firstlineheader' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_firstlineheader' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_firstlineheader' ), true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_firstlineheader' ?>">
					<?php _e( 'First line is header', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Compression', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php

				if ( $this->is_file_stream_supported() ) {

					$selectedcompression = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_compression', 'none' ); ?>

                    <select selected-id="<?php echo $selectedcompression ?>"
                            name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_compression' ?>"
                            id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_compression' ?>">
						<?php

						$durations = array(
							'none' => __( 'None', ATKP_PLUGIN_PREFIX ),
							'gzip' => __( 'gzip compression', ATKP_PLUGIN_PREFIX ),
						);

						foreach ( $durations as $value => $name ) {
							if ( $value == $selectedcompression ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							$item_translated = '';

							echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
						}

						?>
                    </select>

				<?php } else {
					_e( 'Not supported', ATKP_PLUGIN_PREFIX );
				} ?>
            </td>
        </tr>


        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'End of line', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_endofline', 'clrf' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_endofline' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_endofline' ?>">
					<?php

					$durations = array(
						'clrf' => __( 'Carriage return/line feed (CR/LF)', ATKP_PLUGIN_PREFIX ),
						'lf'   => __( 'Line feed (LF)', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>

        <tr valign="top" class="atkp-manualrow">
            <th scope="row">
                <label for="">
					<?php _e( 'Character string', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
				<?php $selectedsourceval = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_textfield', 'doublequote' ); ?>

                <select selected-id="<?php echo $selectedsourceval ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_textfield' ?>"
                        id="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_textfield' ?>">
					<?php

					$durations = array(
						'doublequote' => __( 'Double quotes', ATKP_PLUGIN_PREFIX ),
						'singlequote' => __( 'Single quotes', ATKP_PLUGIN_PREFIX ),
					);

					foreach ( $durations as $value => $name ) {
						if ( $value == $selectedsourceval ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						$item_translated = '';

						echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
					} ?>
                </select>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">

            </th>
            <td>
				<?php
				$columns         = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_columns' );
				$selectedcolumns = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );

				if ( $columns != '' ) {
					if ( ! is_array( $columns ) || count( $columns ) <= 1 ) { ?>
                        <div style="white-space:nowrap;    overflow-x: scroll;border:dotted 1px;width:600px">
                            <div style="display:inline-block">


								<?php

								echo var_dump( $columns );

								?>

                            </div>
                        </div>
					<?php } else { ?>

                        <table style="width:100%">
							<?php

							$atfields = array();


							$fields = $this->get_table_fields();
							$id     = 0;
							foreach ( $fields as $field => $caption ) {
								$savedconfig = null;
								if ( isset( $selectedcolumns ) && is_array( $selectedcolumns ) ) {
									foreach ( $selectedcolumns as $selcol ) {
										if ( $selcol->name == $field ) {
											$savedconfig = $selcol;
											break;
										}
									}
								} //var_dump($savedconfig);


								?>
                                <tr>
                                    <td style="padding: 0px 0px;">&nbsp;</td>
                                    <td style="padding: 0px 0px;vertical-align: middle;"> <?php

										echo esc_html( $caption );
										?> </td>
                                    <td style="padding: 0px 0px;"> &nbsp;</td>
                                    <td style="padding: 0px 0px;">
                                        <input type="hidden" style="padding: 0px 0px;width:30px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_column_' . $field ?>"
                                               value="<?php echo $field ?>"/>
                                        <input type="text" placeholder="prefix"
                                               style="vertical-align: middle;width:40px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_prefix_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->prefix : '' ); ?>"/>
                                        <select <?php echo( $field == 'ProductNumber' || $field == 'ProductName' ? 'required' : '' ) ?>
                                                style="width:40%"
                                                name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_field_' . $field ?>">
											<?php
											$selectedsourceval = $savedconfig == null ? - 1 : $savedconfig->field;

											echo '<option value="-1">' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
											foreach ( $columns as $value => $name ) {
												if ( $value == $selectedsourceval ) {
													$sel = ' selected';
												} else {
													$sel = '';
												}

												$item_translated = '';

												echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
											} ?>
                                        </select>
                                        <input type="text" placeholder="suffix"
                                               style="vertical-align: middle;width:40px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_suffix_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->suffix : '' ); ?>"/>
                                        <input type="text" placeholder="fallback"
                                               style="vertical-align: middle;width:110px"
                                               name="<?php echo ATKP_SHOP_POSTTYPE . '_livecsv_fallback_' . $field ?>"
                                               value="<?php echo esc_attr( $savedconfig != null ? $savedconfig->fallback : '' ); ?>"/>
                                    </td>
                                </tr>
							<?php } ?>
                        </table>
					<?php }
				} ?>
            </td>
        </tr>


		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {

		$shops = array();

		$subshop = new subshop();

		$subshop->title = __( 'CSV File', ATKP_PLUGIN_PREFIX );

		//TODO:Shoplogo
		$subshop->logourl      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_customlogo' );
		$subshop->smalllogourl = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_customlogosmall' );

		$subshop->shopid    = $post_id;
		$subshop->programid = '';

		$subshop->enabled = true;

		array_push( $shops, $subshop );

		return $shops;
	}

	private $shopid = null;

	private $column_config = null;

	public function checklogon( $shop ) {


		$this->shopid = $shop->settingid;

		$this->column_config = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_csv_selectedcolumns' );


	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {


		$products = new atkp_search_resp();
		$maxCount = 10;
		$offset   = $maxCount * ( $pagination - 1 );

		$result = $this->search_csv( $this->shopid, $searchType, $keyword, $maxCount, $offset );

		$products->total = count($result);
		$products->currentpage = $products->total  > 0 ? $pagination : 0;
		$products->pagecount = $products->total >= 10 ? $pagination + 1 : $pagination;

		if ( $result != null ) {
			foreach ( $result as $row ) {

				$product = array();
				//info: je nach anbieter wird entweder small oder large zurückgeliefert?!

				$product['imageurl']   = isset( $row->smallimageurl ) && $row->smallimageurl != '' ? $row->smallimageurl : $row->mediumimageurl;
				$product['asin']       = $row->asin;
				$product['producturl'] = $row->producturl;
				$product['title']      = $row->title;
				$product['ean']        = $row->ean;


				$product['saleprice']   = $row->saleprice;
				$product['listprice']   = $row->listprice;
				$product['description'] = strlen( $row->description ) > 350 ? substr( $row->description, 0, 350 ) : $row->description;

				array_push( $products->products, $product );
			}
		}


		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		//if($enable_ssl == null)
		//    $enable_ssl = $this->enable_ssl;

		//if($enable_ssl)
		//   $url = str_replace('http://', 'https://', $url);

		return $url;
	}


	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {

		$departments = array();

		$departments['AllCategories'] = array(
			'caption' => __( 'All categories', ATKP_PLUGIN_PREFIX )
		);


		return $departments;
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}


		foreach ( $asins as $asin ) {

			try {
				switch ( $id_type ) {
					case 'ARTICLENUMBER':
					case 'ASIN':
						$results = $this->search_csv( $this->shopid, 'asin', $asin, 10, 0 );
						break;
					case 'EAN':
						$results = $this->search_csv( $this->shopid, 'ean', $asin, 10, 0 );
						break;
					case 'TITLE':
						$results = $this->search_csv( $this->shopid, 'title', $asin, 10, 0 );
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			$productfound = false;

			if ( empty( $titlecheck ) && $results && is_array( $results ) && count( $results ) > 0 ) {
				foreach ( $results as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $result;
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found: ' . $asin : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}


		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':
				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}


		$results  = null;
		$products = array();

		if ( $keyword == '' ) {
			$result = $this->search_csv( $this->shopid, 'title', '', $maxCount, 0 );
		} else {
			$result = $this->search_csv( $this->shopid, 'title', $keyword, $maxCount, 0 );

		}

		if ( $result ) {
			foreach ( $result as $row ) {
				//$asin = $row['ProductNumber'];

				//array_push( $mylist->asins, $asin );

				array_push( $products, $row );
			}
		}

		$mylist->products = $products;

		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}

}

class livecolumnconfig {
	public $data = array();

	function __construct() {
		$this->prefix       = '';
		$this->field        = '';
		$this->suffix       = '';
		$this->toolkitfield = '';
		$this->name         = '';
		$this->fallback     = '';
	}

	public static function get_csv_value( $columnconfig, $datarow, $name ) {
		foreach ( $columnconfig as $config ) {
			if ( $config->name == $name ) {
				$id = $config->field !== '' ? intval( $config->field ) : - 1;

				$myvalue = null;

				if ( $id > - 1 && isset( $datarow[ $id ] ) && $datarow[ $id ] != '' ) {
					$myvalue = ( $config->prefix ) . ( $datarow[ $id ] ) . ( $config->suffix );
				}

				if ( $myvalue == null && $config->fallback != '' ) {
					$myvalue = $config->fallback;
				}

				return $myvalue;
			}
		}

		return null;
	}

	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}
}

?>