<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_tools_importproduct {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {

	}

	public function importproduct_configuration_page() {
		$importing = false;

		if ( ATKPTools::exists_post_parameter( 'saveimportproduct' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			$importing = true;
		}


		if ( $importing ) {
			//get list parameters
			//build javascript array for import
			//update ajax list import function

			$shopid = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_listshop', 'string' );
			$lists  = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_lists', 'multistring' );

			$listarray = (array) explode( "\n", (string) $lists );

			$shop = atkp_shop::load( $shopid );

			if ( $shop == null || $shop->provider == null ) {
				echo 'shop not found: ' . $shopid;
				exit;
			}
			$shop->provider->checklogon( $shop );

			$departments = $shop->provider->retrieve_departments();;

			$jsobject           = '';
			$jsvalidatingerrors = '';

			$count = 0;

			foreach ( $listarray as $list ) {
				$fieldsarray = (array) explode( ';', (string) $list );

				$fieldsarray = array_map( 'trim', $fieldsarray );

				//asin;asintype;title,status
				if ( count( $fieldsarray ) == 0 ) {
					continue;
				}

				$asin = $fieldsarray[0];

				if ( $asin == '' || $asin == ' ' ) {
					continue;
				}

				if ( count( $fieldsarray ) > 1 ) {
					$asintype = $fieldsarray[1];
				} else {
					$asintype = 'ASIN';
				}

				if ( count( $fieldsarray ) > 2 ) {
					$title = $fieldsarray[2];
				} else {
					$title = '';
				}

				if ( count( $fieldsarray ) > 3 ) {
					$status = $fieldsarray[3];
				} else {
					$status = '';
				}

				if ( count( $fieldsarray ) > 4 ) {
					$brand = $fieldsarray[4];
				} else {
					$brand = '';
				}

				if ( count( $fieldsarray ) > 5 ) {
					$mpn = $fieldsarray[5];
				} else {
					$mpn = '';
				}

				$validatingerror = '';
				$departmentfound = '';
				$sortbyfound     = '';

				//publish, draft, woo
				if ( $status != '' ) {
					if ( $status != 'publish' && $status != 'draft' && $status != 'woo' ) {
						$validatingerror .= 'status is not valid. allowed: publish, draft and woo';
					}
				}

				if ( $asintype != '' ) {
					if ( $asintype != 'ASIN' && $asintype != 'EAN' && $asintype != 'TITLE' ) {
						$validatingerror .= 'asintype is not valid. allowed: ASIN, EAN; TITLE';
					}
				}

				if ( $validatingerror != '' ) {
					$jsvalidatingerrors .= $list . ';' . $validatingerror . "\n";
				} else {
					$jsobject .= 'lists[lists.length] = {shop: \'' . $shopid . '\', asin: \'' . $asin . '\', asintype: \'' . $asintype . '\', title: \'' . $title . '\', status:\'' . $status . '\', brand:\'' . $brand . '\', mpn:\'' . $mpn . '\' };' . "\n";
				}
				$count ++;
			}

			if ( $count == 0 ) {
				_e( 'import list is empty' );
				exit;
			}

			?>
            <style>
                #atkp-progressBar {

                    width: 60%;
                    height: 22px;
                }

                #atkp-progressBar div {
                    height: 100%;
                    color: #fff;
                    text-align: right;
                    font-size: 12px;
                    line-height: 22px;
                    width: 0;
                }

                .atkp-progress-default {
                    background: #292929;
                    border: 1px solid #111;
                    border-radius: 5px;
                    overflow: hidden;
                    box-shadow: 0 0 5px #333;
                }

                .atkp-progress-default div {
                    background-color: #1a82f7;
                    background: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#0099FF), to(#1a82f7));
                    background: -webkit-linear-gradient(top, #0099FF, #1a82f7);
                    background: -moz-linear-gradient(top, #0099FF, #1a82f7);
                    background: -ms-linear-gradient(top, #0099FF, #1a82f7);
                    background: -o-linear-gradient(top, #0099FF, #1a82f7);
                }
            </style>
            <script>
                function progressBar(percent, $element) {
                    var progressBarWidth = percent * $element.width() / 100;
                    $element.find('div').animate({width: progressBarWidth}, 500).html(percent + "%&nbsp;");
                }
            </script>

            <div id="atkp-progressText"><?php _e( 'importing...', ATKP_PLUGIN_PREFIX ) ?></div>
            <br/>
            <div id="atkp-progressBar" class="atkp-progress-default">
                <div></div>
            </div><br/>

            <textarea readonly style="width:60%;height:400px"
                      id="atkp-progress-listresult"><?php echo esc_textarea( $jsvalidatingerrors ); ?></textarea>


            <script>

                var $j = jQuery.noConflict();
                jQuery(document).ready(function ($j) {
                    var lists = [];
					<?php echo $jsobject; ?>


                    var length = lists.length;
                    var step = 1;
                    lists.forEach(function (entry) {
                        $j("#atkp-progressText").html("<?php _e( 'importing...', ATKP_PLUGIN_PREFIX ) ?> " + entry.title);

                        atkp_import_massproduct(entry.shop, entry.title, entry.asin, entry.asintype, entry.status, entry.brand, entry.mpn, step, length);

                        sleep(3000);

                        step++;
                    });

                    $('atkp-progressBarBar').hide();
                    $('atkp-progressBarText').hide();

                });

                function sleep(delay) {
                    var start = new Date().getTime();
                    while (new Date().getTime() < start + delay) ;
                }

                function writeline(asin, asintype, title, status, brand, mpn, text) {
                    var newval = $j("#atkp-progress-listresult").val();
                    if (newval != '')
                        newval += "\n";

                    newval += asin + ";" + asintype + ";" + title + ";" + status + ";" + brand + ";" + mpn + ";" + text;

                    $j("#atkp-progress-listresult").val(newval);
                }

                function atkp_import_massproduct(shop, title, asin, asintype, status, brand, mpn, step, length) {
                    //atkp_createlist(entry.shop, entry.source, entry.title, entry.keyword, entry.department, entry.sortby, entry.browsenodeid, entry.loadmoreoffers);

					<?php $noncex = wp_create_nonce( 'atkp-import-nonce' ); ?>

                    $j.ajax({
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl();  ?>",
                        data: {
                            action: "atkp_import_product",
                            shop: shop,
                            title: title,
                            asin: asin,
                            asintype: asintype,
                            status: status,
                            brand: brand,
                            mpn: mpn,
                            request_nonce: "<?php echo $noncex ?>"
                        },

                        dataType: "json",
                        success: function (data) {
                            try {
                                var importerror = '';
                                if (data.length == 0) {
                                    importerror = ('unknown issue');
                                } else if (typeof data[0].error != 'undefined') {
                                    importerror = (data[0].error + ': ' + data[0].message);
                                }

                                if (importerror != '')
                                    writeline(asin, asintype, title, status, brand, mpn, importerror);
                                else
                                    writeline(asin, asintype, title, status, brand, mpn, data[0].postid);

                                progressBar((step / length) * 100, $j('#atkp-progressBar'));


                                return 'ok';

                            } catch (err) {
                                writeline('', '', '', '', '', '', 'Error: ' + err.message);
                                return (err.message);
                            }


                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            writeline('', '', '', '', '', '', 'Response-Error: ' + thrownError + ' - ' + xhr.responseText);
                            return xhr.responseText;
                        }
                    });

                }
            </script>

			<?php

		} else {
			$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

			if ( $mytab != 0 ) {
				$tab = $mytab;
			} else {
				$tab = 1;
			}
			?>
            <div class="atkp-content wrap">
                <div class="inner">
                    <!-- <h2><?php _e( 'Affiliate Toolkit - Import', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                    <form method="POST"
                          action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-tools&tab=' . $tab ?>"
                          enctype="multipart/form-data"><!--_affiliate_toolkit-bestseller-->
						<?php wp_nonce_field( "save", "save" ); ?>
                        <table class="form-table" style="width:100%">
                            <tr valign="top">
                                <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
									<?php _e( 'Import products', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'import-product' ); ?>
                                </th>
                            </tr>
                            <tr>
                                <th>
                                    <label for=""><?php _e( 'Shop', ATKP_PLUGIN_PREFIX ) ?>:</label>
                                </th>
                                <td>
                                    <select id="<?php echo ATKP_PLUGIN_PREFIX . '_listshop' ?>"
                                            name="<?php echo ATKP_PLUGIN_PREFIX . '_listshop' ?>" style="width:300px">
										<?php


										$shps = atkp_shop::get_list( '' );

										foreach ( $shps as $shp ) {
											if ( $shp->selected == true ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											$datasources = $shp->provider->get_supportedlistsources();

											if ( $datasources != '' ) {
												echo '<option data-sources="' . $datasources . '" value="' . $shp->id . '"' . $sel . ' > ' . esc_attr( $shp->title ) . '</option>';
											}
										}

										?>
                                    </select>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th>
                                    <label for="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>">
										<?php _e( 'CSV (one list per line)', ATKP_PLUGIN_PREFIX ) ?>
                                    </label>
                                </th>
                                <td colspan="2">
                                    asin;asintype;title;status;brand;mpn
                                    <textarea style="width:100%;height:400px"
                                              id="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>"
                                              name="<?php echo ATKP_PLUGIN_PREFIX . '_lists' ?>"></textarea>

                                </td>
                            </tr>


                            <tr>
                                <td>&nbsp;</td>
                            </tr>
                            <tr valign="top">
                                <td>
									<?php submit_button( '', 'primary', 'saveimportproduct', false ); ?>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>

            </div> <?php
		}
	}
}

?>