<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_posttypes_product {
	/**
	 * Construct the plugin object
	 *
	 * @param $pluginbase
	 */
	public function __construct( $pluginbase ) {

		$this->atkp_posttypes_product_init();

	}

	function atkp_posttypes_product_init() {
		$this->register_productPostType();
		$this->register_filter();

		$enableProductpages = atkp_options::$loader->get_product_enabled();
		if ( $enableProductpages ) {
			add_filter( 'the_content', array( &$this, 'my_the_content_filter' ), 0 );
		}

		if ( is_admin() ) {

			add_action( 'add_meta_boxes', array( &$this, 'product_boxes' ) );
			add_action( 'save_post', array( &$this, 'product_detail_save' ) );

			add_thickbox();

			ATKPTools::add_column( ATKP_PRODUCT_POSTTYPE, __( 'Status', ATKP_PLUGIN_PREFIX ), function ( $post_id ) {

				$selectedshopid = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shopid' );

				try {
					if ( $selectedshopid != '' && atkp_shop::exists( $selectedshopid ) ) {
						$shps = atkp_shop::load( $selectedshopid, false );
					}
				} catch ( Exception $ex ) {
					echo '<span style="color:red">parent shop not found.</span> ';
					$shps = null;
				}

				echo '<span style="font-weight:bold">' . __( 'ID', ATKP_PLUGIN_PREFIX ) . ':</span> <span >' . $post_id . '</span>, ';

				if ( ! isset( $shps ) || $shps == null ) {
					echo '<span>' . __( 'Manual product', ATKP_PLUGIN_PREFIX ) . '</span>';
				} else {
					echo '<span style="font-weight:bold">' . __( 'Shop', ATKP_PLUGIN_PREFIX ) . ':</span> <span>' . $shps->title . '</span>';
				}


				$updatedon = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_updatedon' );

				if ( isset( $updatedon ) && $updatedon != '' ) {
					$infotext = __( '%refresh_date% at %refresh_time%', ATKP_PLUGIN_PREFIX );

					$infotext = str_replace( '%refresh_date%', ATKPTools::get_formatted_date( $updatedon ), $infotext );
					$infotext = str_replace( '%refresh_time%', ATKPTools::get_formatted_time( $updatedon ), $infotext );

					echo '<br /><span style="font-weight:bold">' . __( 'Updated on', ATKP_PLUGIN_PREFIX ) . ':</span> <span>' . $infotext . '</span>';
				}

				$asin     = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asin' );
				$asintype = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asintype' );

				if ( $asin != '' ) {
					echo '<br /><span style="font-weight:bold">' . __( 'Key', ATKP_PLUGIN_PREFIX ) . ':</span> <span>' . $asin . '</span>';
					echo ', <span style="font-weight:bold">' . __( 'Type', ATKP_PLUGIN_PREFIX ) . ': </span> <span>';

					if ( $asintype == 'TITLE' ) {
						echo __( 'Title', ATKP_PLUGIN_PREFIX );
					} else if ( $asintype == 'EAN' ) {
						echo __( 'EAN', ATKP_PLUGIN_PREFIX );
					} else if ( $asintype == 'ARTICLENUMBER' ) {
						echo __( 'Articlenumber', ATKP_PLUGIN_PREFIX );
					} else {
						echo __( 'Unique productid', ATKP_PLUGIN_PREFIX );
					}
					echo '</span>';
				}

				$producturl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_producturl' );


				if ( $producturl != '' ) {
					$title          = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title' );
					$access_website = $selectedshopid != '' ? ATKPTools::get_post_setting( $selectedshopid, ATKP_SHOP_POSTTYPE . '_access_website' ) : '';

					echo '<br /><a href="' . esc_attr( $producturl ) . '" target="_blank">' . __( 'Go to product', ATKP_PLUGIN_PREFIX ) . '</a>';

					if ( $access_website != '' ) {
						echo ' | <a href="' . esc_url( 'https://www.amazon.' . $access_website . '/s?k=' . $title ) . '" target="_blank">' . __( 'Search &#64; Amazon', ATKP_PLUGIN_PREFIX ) . '</a>';
					}
				}

				$message    = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_message' );
				$woomessage = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_woomessage' );

				if ( isset( $message ) && $message != '' ) {
					echo '<br /><span style="font-weight:bold">' . __( 'Message', ATKP_PLUGIN_PREFIX ) . ':</span> <span style="color:red">' . esc_html( $message ) . '</span>';
				}
				if ( isset( $woomessage ) && $woomessage != '' ) {
					echo '<br /> <span style="font-weight:bold">' . __( 'WooCommerce', ATKP_PLUGIN_PREFIX ) . ': </span> <span style="color:red">' . esc_html( $woomessage ) . '</span>';
				}


			}, 3 );

			add_action( 'admin_enqueue_scripts', array( $this, 'image_enqueue' ) );
			add_action( 'admin_head', array( $this, 'hidey_admin_head' ) );


			ATKPTools::add_column( ATKP_PRODUCT_POSTTYPE, __( 'Main image', ATKP_PLUGIN_PREFIX ), function ( $post_id ) {

				$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_smallimageurl' );
				if ( $imageurl == '' ) {
					$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' );
				}
				if ( $imageurl == '' ) {
					$imageurl = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_largeimageurl' );
				}

				if ( $imageurl != '' ) {
					echo '<img src="' . $imageurl . '" style="max-width:60px" />';
				}
			}, 1 );

			add_action( 'before_delete_post', 'atkp_delete_images' );
			function atkp_delete_images( $post_id ) {

				// We check if the global post type isn't ours and just return
				global $post_type;
				if ( $post_type == ATKP_PRODUCT_POSTTYPE ) {

					if ( has_post_thumbnail( $post_id ) ) {
						$attachment_id = get_post_thumbnail_id( $post_id );
						if ( $attachment_id ) {
							wp_delete_attachment( $attachment_id, true );
						}
					}

					//get woocommerce product and delete image

					if ( class_exists( 'WooCommerce' ) ) {
						try {
							$mode = atkp_options::$loader->get_woo_mode();

							if ( $mode != '' ) {

								$woo_product = atkp_product::get_woo_product( $post_id );
								if ( has_post_thumbnail( $woo_product->ID ) ) {
									$attachment_id = get_post_thumbnail_id( $woo_product->ID );
								}

								wp_delete_post( $woo_product->ID, true );
								if ( $attachment_id ) {
									wp_delete_attachment( $attachment_id, true );
								}
							}
						} catch ( Exception $e ) {
							//TODO: log
						}
					}
				}
			}
		}
	}


	function hidey_admin_head() {
		echo '<style type="text/css">';
		echo '.column-' . sanitize_title( __( 'Main image', ATKP_PLUGIN_PREFIX ) ) . ' { width: 70px; }';
		echo '</style>';
	}

	/**
	 * Loads the image management javascript
	 */
	function image_enqueue() {
		global $typenow;
		if ( $typenow == ATKP_PRODUCT_POSTTYPE ) {
			wp_enqueue_media();

			// Registers and enqueues the required javascript.
			wp_register_script( 'meta-box-image', plugin_dir_url( ATKP_PLUGIN_FILE ) . 'js/meta-box-image.js', array( 'jquery' ) );
			wp_localize_script( 'meta-box-image', 'meta_image',
				array(
					'title'  => __( 'Choose or Upload an image', ATKP_PLUGIN_PREFIX ),
					'button' => __( 'Use this image', ATKP_PLUGIN_PREFIX ),
				)
			);
			wp_enqueue_script( 'meta-box-image' );
		}
	}

	function register_filter() {

		add_filter( 'parse_query', array( &$this, 'admin_posts_filter' ) );
		add_action( 'restrict_manage_posts', array( &$this, 'admin_posts_filter_restrict_manage_posts' ) );

	}

	function admin_posts_filter( $query ) {
		$filterfield = ATKPTools::get_get_parameter( ATKP_PLUGIN_PREFIX . '_filterfield', 'string' );
		$posttype    = ATKPTools::get_get_parameter( 'post_type', 'string' );

		if ( $posttype == ATKP_PRODUCT_POSTTYPE && ! atkp_posttypes_product::$overridefilter ) {
			global $pagenow;
			if ( is_admin() && $pagenow == 'edit.php' && isset( $filterfield ) && $filterfield != '' ) {

				if ( $filterfield == 'filter_error' ) {
					$query->query_vars['meta_key']     = ATKP_PRODUCT_POSTTYPE . '_message';
					$query->query_vars['meta_value']   = '';
					$query->query_vars['meta_compare'] = 'EXISTS';
				} else {
					$parts = explode( '_', $filterfield );

					$query->set( 'meta_query', array(
						array(
							'key'     => ATKP_PRODUCT_POSTTYPE . '_shopid',
							'value'   => isset( $parts[1] ) ? $parts[1] : '',
							'compare' => isset( $parts[1] ) && $parts[1] != '' ? '=' : 'NOT EXISTS'
						)
					) );
				}

			}
		}
	}

	private static $overridefilter;

	function admin_posts_filter_restrict_manage_posts() {
		$posttype = ATKPTools::get_get_parameter( 'post_type', 'string' );

		if ( $posttype != ATKP_PRODUCT_POSTTYPE ) {
			return;
		}

		atkp_posttypes_product::$overridefilter = true;
		$shops                                  = atkp_shop::get_list( '', true );

		atkp_posttypes_product::$overridefilter = false;
		?>
        <select name="<?php echo ATKP_PLUGIN_PREFIX . '_filterfield' ?>">
            <option value=""><?php _e( 'Filter products by', ATKP_PLUGIN_PREFIX ); ?></option>
			<?php
			//Alle Listen
			//Fehlerhafte Listen
			//Leere Listen
			//Shop: xx
			$filterfield = ATKPTools::get_get_parameter( ATKP_PLUGIN_PREFIX . '_filterfield', 'string' );

			echo '<option value="' . esc_attr( 'filter_error' ) . '" ' . ( $filterfield == 'filter_error' ? 'selected' : '' ) . '>' . __( 'Products with error', ATKP_PLUGIN_PREFIX ) . '</option>';
			echo '<option value="' . esc_attr( 'shop_' ) . '" ' . ( $filterfield == 'shop_' ? 'selected' : '' ) . '>' . __( 'Manual product', ATKP_PLUGIN_PREFIX ) . '</option>';

			foreach ( $shops as $shop ) {
				echo '<option value="' . esc_attr( 'shop_' . $shop->id ) . '" ' . ( $filterfield == 'shop_' . $shop->id ? 'selected' : '' ) . '>' . sprintf( __( 'Shop: %s (%s)', ATKP_PLUGIN_PREFIX ), $shop->get_title(), $shop->id ) . '</option>';

			}
			?>
        </select>
		<?php
	}

	function register_productPostType() {
		$labels = array(
			'name'               => __( 'Products', ATKP_PLUGIN_PREFIX ),
			'singular_name'      => __( 'Product', ATKP_PLUGIN_PREFIX ),
			'add_new_item'       => __( 'Add new Product', ATKP_PLUGIN_PREFIX ),
			'edit_item'          => __( 'Edit Product', ATKP_PLUGIN_PREFIX ),
			'new_item'           => __( 'New Product', ATKP_PLUGIN_PREFIX ),
			'all_items'          => __( 'Products', ATKP_PLUGIN_PREFIX ),
			'view_item'          => __( 'View Product', ATKP_PLUGIN_PREFIX ),
			'search_items'       => __( 'Search Products', ATKP_PLUGIN_PREFIX ),
			'not_found'          => __( 'No products found', ATKP_PLUGIN_PREFIX ),
			'not_found_in_trash' => __( 'No products found in the Trash', ATKP_PLUGIN_PREFIX ),
			'parent_item_colon'  => '',
			'menu_name'          => __( 'AT Products', ATKP_PLUGIN_PREFIX ),
		);

		$enableProductpages = atkp_options::$loader->get_product_enabled();
		$enableComments     = atkp_options::$loader->get_product_commentenabled();
		$productslug        = atkp_options::$loader->get_product_slug();
		$importProductimage = atkp_options::$loader->get_product_importimage();

		if ( $productslug == '' ) {
			$productslug = 'product';
		}


		$rewrite  = false;
		$supports = array( 'title' );

		if ( $importProductimage ) {
			$supports = array( 'title', 'thumbnail' );
		}

		if ( $enableProductpages ) {
			$rewrite = array(
				'slug'       => $productslug,
				'with_front' => true,
				'pages'      => true,
				'feeds'      => true,
			);

			if ( $enableComments ) {
				$supports = array( 'title', 'comments', 'author', 'trackbacks', 'editor', 'thumbnail' );
			} else {
				$supports = array( 'title', 'author', 'editor', 'thumbnail' );
			}
		}


		$args = array(
			'labels'      => $labels,
			'description' => 'Holds our products and product specific data',

			'public'              => $enableProductpages,
			// it's not public, it shouldn't have it's own permalink, and so on
			'publicly_queriable'  => $enableProductpages,
			// you should be able to query it
			'show_ui'             => true,
			// you should be able to edit it in wp-admin
			'exclude_from_search' => ! $enableProductpages,
			// you should exclude it from search results
			'show_in_nav_menus'   => true,
			// you shouldn't be able to add it to menus
			'has_archive'         => (bool) $enableProductpages,
			// it shouldn't have archive page
			'rewrite'             => $rewrite,
			'taxonomies'          => array(),
			'query_var'           => true,

			'menu_position'   => 20,
			'supports'        => $supports,
			'capability_type' => 'post',
			'menu_icon'       => plugin_dir_url( ATKP_PLUGIN_FILE ) . '/images/affiliate_toolkit_menu.png',
		);

		$args = apply_filters( 'atkp_product_register_post_type', $args );

		register_post_type( ATKP_PRODUCT_POSTTYPE, $args );

		$taxonomies = atkp_udtaxonomy::load_taxonomies();

		if ( $taxonomies != null ) {
			foreach ( $taxonomies as $taxonomy ) {
				//falls taxonomie bereits von anderem plugin installiert wurde
				if ( taxonomy_exists( $taxonomy->name ) || $taxonomy->name == '' ) {
					continue;
				}

				if ( $taxonomy->caption == '' ) {
					$taxonomy->caption = $taxonomy->name;
				}

				if ( $taxonomy->captionplural == '' ) {
					$taxonomy->captionplural = $taxonomy->caption;
				}

				$labels = array(
					'name'          => $taxonomy->captionplural,
					'singular_name' => $taxonomy->caption,
					'search_items'  => sprintf( __( 'Search %s', ATKP_PLUGIN_PREFIX ), $taxonomy->captionplural ),
					'all_items'     => sprintf( __( 'All %s', ATKP_PLUGIN_PREFIX ), $taxonomy->captionplural ),
					'edit_item'     => sprintf( __( 'Edit %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption ),
					'update_item'   => sprintf( __( 'Update %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption ),
					'add_new_item'  => sprintf( __( 'Add New %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption ),
					'new_item_name' => sprintf( __( 'New %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption ),
					'menu_name'     => $taxonomy->captionplural
				);

				// register taxonomy

				if ( $taxonomy->isproductgroup && atkp_options::$loader->get_fieldgroups_enabled() ) {
					$taxs = array( ATKP_PRODUCT_POSTTYPE, ATKP_FIELDGROUP_POSTTYPE );
				} else {
					$taxs = array( ATKP_PRODUCT_POSTTYPE );
				}

				$taxs = apply_filters( 'atkp_taxonomy_posttypes', $taxs, $taxonomy->name );

				$taxargs = array(
					'taxonomies'            => $taxs,
					'hierarchical'          => true,
					'labels'                => $labels,
					'query_var'             => true,
					'show_admin_column'     => false,
					'show_ui'               => $taxonomy->showui,
					'public'                => $enableProductpages,
					'update_count_callback' => '_update_post_term_count',
					'capabilities'          => array(
						'manage_terms' => 'edit_posts',
						'edit_terms'   => 'edit_posts',
						'delete_terms' => 'edit_posts',
						'assign_terms' => 'edit_posts'
					)
				);

				$taxargs = apply_filters( 'atkp_register_taxonomy', $taxargs, $taxonomy->name );


				register_taxonomy( $taxonomy->name, $taxs, $taxargs );
			}
		}


	}

	function my_the_content_filter( $content ) {
		global $post;

		if ( ATKP_PRODUCT_POSTTYPE == get_post_type() ) {

			if ( is_single() ) {

				$producttemplate = stripslashes( atkp_options::$loader->get_product_template() );

				if ( $producttemplate != '' ) {
					$producttemplate = str_replace( '%content%', $content, $producttemplate );

					return html_entity_decode( $producttemplate );
				}

			} else if ( is_archive() ) {
				$producttemplate = stripslashes( atkp_options::$loader->get_product_archivetemplate() );
				if ( $producttemplate != '' ) {
					$producttemplate = str_replace( '%content%', $content, $producttemplate );

					return do_shortcode( html_entity_decode( $producttemplate ) );
				}
			}
		}

		// otherwise returns the database content
		return $content;
	}


	function product_boxes() {

		add_meta_box(
			ATKP_PRODUCT_POSTTYPE . '_shop_box',
			__( 'Shop Information', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'product_shop_box_content' ),
			ATKP_PRODUCT_POSTTYPE,
			'normal',
			'default'
		);

		add_meta_box(
			ATKP_PRODUCT_POSTTYPE . '_detail_box',
			__( 'Detailed information', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'product_detail_box_content' ),
			ATKP_PRODUCT_POSTTYPE,
			'normal',
			'default'
		);

		if ( atkp_options::$loader->get_fieldgroups_enabled() ) {
			add_meta_box(
				ATKP_PRODUCT_POSTTYPE . '_import_box',
				__( 'Import tools', ATKP_PLUGIN_PREFIX ),
				array( &$this, 'product_import_box_content' ),
				ATKP_PRODUCT_POSTTYPE,
				'side',
				'default'
			);
		}

	}

	function product_import_box_content( $post ) {

		?>

        <table class="form-table">
            <tr valign="top">
                <td style="font-weight:600;padding:0">
                    <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_importurl' ?>">
						<?php _e( 'Import data', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
					<?php echo ATKPHomeLinks::GetHelpIcon( 'product-importurl' ); ?>
                </td>
            </tr>
            <tr>
                <td>
                    <!--<input style="width:100%" type="url" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_importurl' ?>" name="<?php echo ATKP_PRODUCT_POSTTYPE . '_importurl' ?>" value="">          -->

                    <textarea style="width:100%;height:100px" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_importurl' ?>"
                              name="<?php echo ATKP_PRODUCT_POSTTYPE . '_importurl' ?>"></textarea>


                </td>
            </tr>
        </table>


		<?php

	}

	function product_shop_box_content( $post ) {
		wp_nonce_field( plugin_basename( __FILE__ ), 'product_shop_box_content_nonce' );


		?>
        <table class="form-table">
            <tr valign="top">
                <th scope="row">
                    <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>">
						<?php _e( 'Shop', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
					<?php echo ATKPHomeLinks::GetHelpIcon( 'product-shop' ); ?>
                </th>
                <td>
                    <select id="<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>"
                            name="<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>" style="width:300px">
						<?php
						echo '<option value="">' . __( 'Manual product', ATKP_PLUGIN_PREFIX ) . '</option>';

						$selectedshopid = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_shopid' );

						$shps = atkp_shop::get_list( $selectedshopid );

						foreach ( $shps as $shp ) {
							if ( $shp->selected == true ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}


							echo '<option value="' . $shp->id . '"' . $sel . ' > ' . esc_attr( $shp->title ) . '</option>';
						}

						?>
                    </select>


                </td>
            </tr>
            <tr valign="top">
                <th scope="row" style="padding: 15px 0px;">
                    <select title="<?php _e( 'select key type', ATKP_PLUGIN_PREFIX ); ?>"
                            name="<?php echo ATKP_PRODUCT_POSTTYPE . '_asintype' ?>"
                            id="<?php echo ATKP_PRODUCT_POSTTYPE . '_asintype' ?>" style="width:100%">
						<?php
						$asintype = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_asintype', true );
						if ( $asintype == '' || $asintype == null ) {
							$asintype = 'ASIN';
						}

						$durations = array(
							'ASIN'          => __( 'Unique productid', ATKP_PLUGIN_PREFIX ),
							'EAN'           => __( 'EAN', ATKP_PLUGIN_PREFIX ),
							'TITLE'         => __( 'Title', ATKP_PLUGIN_PREFIX ),
							'ARTICLENUMBER' => __( 'Articlenumber', ATKP_PLUGIN_PREFIX ),
						);

						foreach ( $durations as $value => $name ) {
							if ( $value == $asintype ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							echo '<option value="' . $value . '" ' . $sel . '>' . esc_attr( $name ) . '</option>';
						} ?>
                    </select>

                    <script type="text/javascript">
                        var $j = jQuery.noConflict();
                        /*
                                     * Attaches the image uploader to the input field
                                     */
                        $j(document).ready(function ($) {


                            $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asintype' ?>').change(function () {

                                if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asintype' ?>').val() == 'ASIN')
                                    $j('#searchproduct-button').show();
                                else
                                    $j('#searchproduct-button').hide();
                            });


                            $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asintype' ?>').trigger("change");


                        });

                    </script>
                </th>
                <td>
                    <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>"
                           name="<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>"
                           value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_asin', true ); ?>">
                    <label id="<?php echo ATKP_PRODUCT_POSTTYPE . '_asin_caption' ?>"><?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_asin_caption', true ); ?></label>
                    <br/>
                    <input type="button" id="searchproduct-button" class="button product-lookup thickbox"
                           title="<?php _e( 'Search unique productid', ATKP_PLUGIN_PREFIX ) ?>"
                           alt="#TB_inline?height=400&amp;width=500&amp;inlineId=modal-asin-lookup"
                           value="<?php _e( 'Search unique productid', ATKP_PLUGIN_PREFIX ) ?>"/>

                </td>
            </tr>


			<?php

			$updatedon  = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_updatedon', true );
			$message    = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_message', true );
			$woomessage = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_woomessage' );


			?>

            <tr valign="top">
                <th scope="row">
                </th>
                <td><i>
						<?php
						if ( isset( $updatedon ) && $updatedon != '' ) {
							$infotext = __( 'Product updated on %refresh_date% at %refresh_time%', ATKP_PLUGIN_PREFIX );

							$infotext = str_replace( '%refresh_date%', ATKPTools::get_formatted_date( $updatedon ), $infotext );
							$infotext = str_replace( '%refresh_time%', ATKPTools::get_formatted_time( $updatedon ), $infotext );


							echo $infotext; ?><br/><?php } ?>
						<?php echo '<div style="color:red; overflow-wrap: break-word; max-width: 500px;">' . esc_html( $message ) . '</div>'; ?>

						<?php if ( $woomessage != '' ) {
							echo '<div style="color:red;overflow-wrap: break-word; max-width: 500px;">WooCommerce: ' . esc_html( $woomessage ) . '</div>';
						} ?>

                    </i></td>
            </tr>
        </table>

        <div id="modal-asin-lookup" style="display:none;">

            <div class="atkp-lookupbox">
                <div><label for=""><?php _e( 'Keyword:', ATKP_PLUGIN_PREFIX ) ?></label> <input type="text"
                                                                                                id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearch' ?>"
                                                                                                name="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearch' ?>"
                                                                                                value=""> <input
                            type="submit" class="button"
                            id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupbtnsearch' ?>"
                            value="<?php _e( 'Search', ATKP_PLUGIN_PREFIX ) ?>">
                    <div id="LoadingImage" style="display: none;text-align:center"><img
                                src="<?php echo plugin_dir_url( ATKP_PLUGIN_FILE ) ?>/images/spin.gif"
                                style="width:32px" alt="loading"/></div>
                </div>

                <div id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>"
                     class="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>">

                </div>


            </div>
        </div>

        <div id="modal-asin-lookupoffer" style="display:none;">

            <div class="atkp-lookupbox">
                <div><label for=""><?php _e( 'Keyword:', ATKP_PLUGIN_PREFIX ) ?></label> <input type="text"
                                                                                                id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearchoffer' ?>"
                                                                                                name="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearchoffer' ?>"
                                                                                                value=""> <input
                            type="submit" class="button"
                            id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupbtnsearchoffer' ?>"
                            value="<?php _e( 'Search', ATKP_PLUGIN_PREFIX ) ?>">
                    <div id="LoadingImageoffer" style="display: none;text-align:center"><img
                                src="<?php echo plugin_dir_url( ATKP_PLUGIN_FILE ) ?>/images/spin.gif"
                                style="width:32px" alt="loading"/></div>
                </div>

                <div id="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>"
                     class="<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>">

                </div>


            </div>
        </div>


        <script type="text/javascript">
            var reviewinforefresh = false;
            var $j = jQuery.noConflict();
            $j(document).ready(function () {
                reviewinforefresh = $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').is(":checked");


                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupbtnsearch' ?>").click(function (e) {

                    $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>").html('');
                    $j("#LoadingImage").show();

                    $j.ajax({
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                        data: {
                            action: "atkp_search_products",
                            shop: $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>').val(),
                            keyword: $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearch' ?>').val(),
                            request_nonce: "<?php echo wp_create_nonce( 'atkp-search-nonce' ) ?>"
                        },

                        dataType: "json",
                        success: function (data) {
                            try {
                                var count = 0;
                                $j.each(data, function (key, value) {
                                    count++;
                                });

                                if (count > 0) {

                                    if (typeof data[0].error != 'undefined') {
                                        $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>").html('<span style="color:red">' + data[0].error + '<br /> ' + data[0].message + '</span>');
                                    } else {

                                        var outputresult = '<ul class="product-link">';

                                        $j.each(data, function (index, value) {

                                            outputresult += '<li>';
                                            if (typeof value.imageurl != 'undefined' && value.imageurl != null)
                                                outputresult += '<img src="' + value.imageurl + '" />';
                                            outputresult += '<h3 data-id=' + value.asin + '>' + value.title + '</h3>';
                                            outputresult += '<p>ID: ' + value.asin + ' <br /><a href="' + value.producturl + '" target="_blank"><?php _e( 'View product', ATKP_PLUGIN_PREFIX ) ?></a></p>';
                                            outputresult += '</li>';
                                        });

                                        outputresult += '</ul>';
                                        $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>").html(outputresult);
                                    }
                                }
                            } catch (err) {
                                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>").html('<span style="color:red">' + err.message + '</span>');
                                $j("#LoadingImage").hide();
                            }

                            $j('ul.product-link li h3').click(function (e) {
                                var id = $j(this).attr("data-id");
                                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>").val(id);
                                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>").trigger('change');
                                tb_remove();
                            });

                            $j("#LoadingImage").hide();
                        },
                        error: function (xhr, status) {
                            $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresult' ?>").html('<span style="color:red">' + xhr.responseText + '</span>');
                            $j("#LoadingImage").hide();
                        }
                    });
                });

                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupbtnsearchoffer' ?>").click(function (e) {

                    $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>").html('');
                    $j("#LoadingImageoffer").show();

                    $j.ajax({
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                        data: {
                            action: "atkp_search_products",
                            shop: $j('#addoffer_shopid').val(),
                            keyword: $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupsearchoffer' ?>').val(),
                            request_nonce: "<?php echo wp_create_nonce( 'atkp-search-nonce' ) ?>"
                        },

                        dataType: "json",
                        success: function (data) {
                            try {
                                var count = 0;
                                $j.each(data, function (key, value) {
                                    count++;
                                });

                                if (count > 0) {

                                    if (typeof data[0].error != 'undefined') {
                                        $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>").html('<span style="color:red">' + data[0].error + '<br /> ' + data[0].message + '</span>');
                                    } else {

                                        var outputresult = '<ul class="product-link">';

                                        $j.each(data, function (index, value) {

                                            outputresult += '<li>';
                                            if (typeof value.imageurl != 'undefined' && value.imageurl != null)
                                                outputresult += '<img src="' + value.imageurl + '" />';
                                            outputresult += '<h3 data-id=' + value.asin + '>' + value.title + '</h3>';
                                            outputresult += '<p>ID: ' + value.asin + ' <br /><a href="' + value.producturl + '" target="_blank"><?php _e( 'View product', ATKP_PLUGIN_PREFIX ) ?></a></p>';
                                            outputresult += '</li>';
                                        });

                                        outputresult += '</ul>';
                                        $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>").html(outputresult);
                                    }
                                }
                            } catch (err) {
                                $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>").html('<span style="color:red">' + err.message + '</span>');
                                $j("#LoadingImageoffer").hide();
                            }


                            $j('ul.product-link li h3').click(function (e) {
                                var id = $j(this).attr("data-id");
                                var deletebtncaption = '<?php  _e( 'Delete', ATKP_PLUGIN_PREFIX ) ?>';
                                var uid = idGen.getId();

                                $j('#prices .mainrow:last').after('<tr><td>&nbsp;</td></tr><tr style="border-top:1px gray solid"><td colspan="5">&nbsp;</td></tr><tr valign="top"><td >' + $j('#addoffer_shopid option:selected').text() + ': ' + id + '<input type="hidden" name="atkp_product_offer_id_' + uid + '" value="' + uid + '" /><input type="hidden" name="atkp_product_offer_shopid_' + uid + '" value="' + $j('#addoffer_shopid option:selected').val() + '" /><input type="hidden" name="atkp_product_offer_number_' + uid + '" value="' + id + '" /></td><td></td><td></td><td></td><td><input type="button" id="removeoffer-button_' + uid + '" class="button remove-offer" value="' + deletebtncaption + '" /></td></tr>');
                                $j('#atkp_offerschanged').val('1');

                                $j('#removeoffer-button_' + uid).click(function (e) {

                                    if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                        $j(this).parent().parent().prev().remove();
                                        $j(this).parent().parent().prev().remove();
                                        $j(this).parent().parent().remove();
                                        $j('#atkp_offerschanged').val('1');
                                    }

                                });

                                tb_remove();
                            });

                            $j("#LoadingImageoffer").hide();
                        },
                        error: function (xhr, status) {
                            $j("#<?php echo ATKP_PRODUCT_POSTTYPE . '_prdlookupresultoffer' ?>").html('<span style="color:red">' + xhr.responseText + '</span>');
                            $j("#LoadingImageoffer").hide();
                        }
                    });
                });

                $j('.hideoffer').change(function () {
                    $j('#atkp_offerschanged').val('1');
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>').change(function () {

                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>').val() === '') {
                        //manuelles produkt

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>').prop('required', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>').prop('checked', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').prop('checked', false);


                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>').prop('checked', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>').prop('checked', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').prop('checked', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>').prop('checked', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>').prop('checked', false);


                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').prop('checked', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>').prop('checked', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').prop('checked', false);


                    } else {
                        //shop product

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>').prop('required', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').prop('disabled', false);


                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>').prop('disabled', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').prop('disabled', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>').prop('disabled', false);


                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>').prop('disabled', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').prop('disabled', false);


                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>').trigger("change");
                    }

                    $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').trigger("change");
                    $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').trigger("change");
                    $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').trigger("change");
                    $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').trigger("change");
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>').trigger("change");

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>').change(function () {


                    $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin_caption' ?>').empty();

                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_asin' ?>').val() !== '' && $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shopid' ?>').val() !== '') {
                        //asin wurde geändertt

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>').prop('checked', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>').prop('checked', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').prop('checked', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').prop('checked', true);


                        //was ist, wenn er manuelle bewertung eingetragen hat? dann sollte das nicht gesetzt werden!!
                        //if(reviewinforefresh) {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').prop('checked', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>').prop('checked', true);
                        //}

                    }

                });


                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').change(function () {
                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').prop('checked') == true) {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_rating' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewcount' ?>').prop('disabled', true);


                    } else {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_rating' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewcount' ?>').prop('disabled', false);

                    }
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>').trigger("change");

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').change(function () {
                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').prop('checked') == true) {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ?>').prop('disabled', true);

                        $j('#smallimage-button').prop('disabled', true);
                        $j('#mediumimage-button').prop('disabled', true);
                        $j('#largeimage-button').prop('disabled', true);

                        $j('.atkp-galleryitem').prop('disabled', true);

                        $j('#addimage-button').prop('disabled', true);


                    } else {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ?>').prop('disabled', false);

                        $j('#smallimage-button').prop('disabled', false);
                        $j('#mediumimage-button').prop('disabled', false);
                        $j('#largeimage-button').prop('disabled', false);


                        $j('.atkp-galleryitem').prop('disabled', false);

                        $j('#addimage-button').prop('disabled', false);

                    }
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>').trigger("change");


                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').change(function () {
                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').prop('checked') == true) {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_producturl' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_addtocarturl' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' ?>').prop('disabled', true);


                    } else {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_producturl' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_addtocarturl' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' ?>').prop('disabled', false);
                    }
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>').trigger("change");

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').change(function () {
                    if ($j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').prop('checked') == true) {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_listprice' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_amountsaved' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_percentagesaved' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_saleprice' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_availability' ?>').prop('disabled', true);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_isprime' ?>').prop('disabled', true);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shipping' ?>').prop('disabled', true);
                    } else {
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_listprice' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_amountsaved' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_percentagesaved' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_saleprice' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_availability' ?>').prop('disabled', false);
                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_isprime' ?>').prop('disabled', false);

                        $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_shipping' ?>').prop('disabled', false);

                    }
                });

                $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>').trigger("change");


            });
        </script>


		<?php

	}

	function product_detail_box_content( $post ) {
		wp_nonce_field( plugin_basename( __FILE__ ), 'product_detail_box_content_nonce' );


		?>

        <ul class='atkp-tabs'>
            <li><a href='#atkp-tab1'><?php _e( 'Product Information', ATKP_PLUGIN_PREFIX ); ?></a></li>
            <li><a href='#atkp-tab2'><?php _e( 'Link Information', ATKP_PLUGIN_PREFIX ) ?></a></li>
            <li><a href='#atkp-tab3'><?php _e( 'Review Information', ATKP_PLUGIN_PREFIX ) ?></a></li>
            <li><a href='#atkp-tab4'><?php _e( 'Images', ATKP_PLUGIN_PREFIX ) ?></a></li>
            <li><a href='#atkp-tab5'><?php _e( 'Price Information', ATKP_PLUGIN_PREFIX ) ?></a></li>
            <li><a href='#atkp-tab8'><?php _e( 'Variations', ATKP_PLUGIN_PREFIX ) ?></a></li>
            <li><a href='#atkp-tab7'><?php _e( 'Additional offers', ATKP_PLUGIN_PREFIX ) ?></a></li>
			<?php if ( ATKP_PLUGIN_VERSION >= 30 ) { ?>
                <li><a href='#atkp-tab6'><?php _e( 'Custom Fields', ATKP_PLUGIN_PREFIX ) ?></a></li>
			<?php } ?>
        </ul>
        <div id='atkp-tab1'>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo' ?>">
							<?php _e( 'Update product information upon saving (overwrites existing data)', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>


                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Title', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:100%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_title' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_title' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_title', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'EAN', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_ean' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_ean' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_ean', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'ISBN', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_isbn' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_isbn' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_isbn', true ) ); ?>">
                    </td>
                </tr>


                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Manufacturer Part Number', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_mpn' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_mpn' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_mpn', true ) ); ?>">
                    </td>
                </tr>


                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Product group', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:50%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_productgroup' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_productgroup' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_productgroup', true ) ); ?>">
                    </td>
                </tr>


                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Manufacturer', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:50%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_manufacturer' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_manufacturer' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_manufacturer', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Author', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:50%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_author' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_author' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_author', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Number of pages', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="number" min="0" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_numberofpages' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_numberofpages' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_numberofpages', true ) ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Brand', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:50%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_brand' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_brand' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_brand', true ) ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Release date', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:50%" type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_releasedate' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_releasedate' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_releasedate', true ) ); ?>">
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="">
							<?php _e( 'Description', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
						<?php
						wp_editor( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_description', true ), ATKP_PRODUCT_POSTTYPE . '_description', array(
							'media_buttons' => false,
							'textarea_name' => ATKP_PRODUCT_POSTTYPE . '_description',
							'textarea_rows' => 10,
						) );
						?>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="">
							<?php _e( 'Features', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
						<?php
						wp_editor( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_features', true ), ATKP_PRODUCT_POSTTYPE . '_features', array(
							'media_buttons' => false,
							'textarea_name' => ATKP_PRODUCT_POSTTYPE . '_features',
							'textarea_rows' => 10,
						) );
						?>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="">
							<?php _e( 'Post', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
						<?php
						$postid = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_postid' );

						if ( $postid != null ) {
							if ( is_array( $postid ) ) {
								foreach ( $postid as $p ) {
									$title = get_the_title( $p );
									if ( ! isset( $title ) || $title == '' ) {
										$title = __( 'edit post', ATKP_PLUGIN_PREFIX );
									}

									echo sprintf( __( '<a href="%s" target="_blank">%s</a> ', ATKP_PLUGIN_PREFIX ), get_edit_post_link( $p ), $title );
								}
							} else {
								$title = get_the_title( $postid );
								if ( ! isset( $title ) || $title == '' ) {
									$title = __( 'edit post', ATKP_PLUGIN_PREFIX );
								}
								echo sprintf( __( '<a href="%s" target="_blank">%s</a>', ATKP_PLUGIN_PREFIX ), get_edit_post_link( $postid ), $title );
							}
						} else {
							_e( 'This Product is not used as a main product in any contribution.', ATKP_PLUGIN_PREFIX );
						}
						?>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_disablehoverlink' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_disablehoverlink' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_disablehoverlink' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_disablehoverlink' ?>">
							<?php _e( 'Disable Hover-Link', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

				<?php
				$wooenabled = atkp_options::$loader->get_woo_enabled();
				if ( $wooenabled ) {
					?>
                    <tr valign="top">
                        <th scope="row">

                        </th>
                        <td>
                            <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_iswoocommerce' ?>"
                                   name="<?php echo ATKP_PRODUCT_POSTTYPE . '_iswoocommerce' ?>"
                                   value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_iswoocommerce' ), true ); ?>>
                            <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_iswoocommerce' ?>">
								<?php _e( 'Is WooCommerce product', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </td>
                    </tr>


				<?php }


				$importProductimage = atkp_options::$loader->get_product_importimage();
				if ( $importProductimage || $wooenabled != '' ) {
					?>

                    <tr valign="top">
                        <th scope="row">

                        </th>
                        <td>
                            <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' ?>"
                                   name="<?php echo ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' ?>"
                                   value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' ), false ); ?>>
                            <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage' ?>">
								<?php _e( 'Do not import the main image of this product', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </td>
                    </tr>
				<?php } ?>

                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_outputashtml' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_outputashtml' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_outputashtml' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_outputashtml' ?>">
							<?php _e( 'Output description and features as html. Overwrites substring settings.', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>


            </table>
        </div>
        <div id='atkp-tab2'>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturl' ?>">
							<?php _e( 'Update "product url", "customer reviews url" and "add to cart url" upon saving (overwrites existing data)', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary' ?>">
							<?php _e( 'Constantly update "product url", "customer reviews url" and "add to cart url"', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Product page URL', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="url" style="width:100%" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_producturl' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_producturl' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_producturl', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Add to cart URL', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="url" style="width:100%" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_addtocarturl' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_addtocarturl' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_addtocarturl', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Customer Reviews URL', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="url" style="width:100%"
                               id="<?php echo ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl', true ) ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_isownreview' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_isownreview' ?>"
                               value="1" <?php checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_isownreview' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_isownreview' ?>">
							<?php _e( 'Override customer reviews', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Review URL', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="url" style="width:100%" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewsurl' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewsurl' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_reviewsurl', true ) ); ?>">
                    </td>
                </tr>


            </table>
        </div>
        <div id='atkp-tab3'>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo' ?>">
							<?php _e( 'Update review information upon saving', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary' ?>">
							<?php _e( 'Continuously update review information', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Rating', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="number" step="0.01" min="0" max="5"
                               id="<?php echo ATKP_PRODUCT_POSTTYPE . '_rating' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_rating' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_rating', true ); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Amount of reviews', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="number" min="0" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewcount' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_reviewcount' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_reviewcount', true ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Predicate', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>

                        <select id="<?php echo ATKP_PRODUCT_POSTTYPE . '_predicate' ?>"
                                name="<?php echo ATKP_PRODUCT_POSTTYPE . '_predicate' ?>" style="width:300px">
							<?php
							$selected = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_predicate', true );

							echo '<option value="" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';

							echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . esc_attr( wp_strip_all_tags( atkp_options::$loader->get_predicate1_text() ) ) . '</option>';
							echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . esc_attr( wp_strip_all_tags( atkp_options::$loader->get_predicate2_text() ) ) . '</option>';
							echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . esc_attr( wp_strip_all_tags( atkp_options::$loader->get_predicate3_text() ) ) . '</option>';

							?>
                        </select>

                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Test result', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>

                        <select id="<?php echo ATKP_PRODUCT_POSTTYPE . '_testresult' ?>"
                                name="<?php echo ATKP_PRODUCT_POSTTYPE . '_testresult' ?>" style="width:300px">
							<?php
							$selected = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_testresult', true );

							echo '<option value="" ' . ( $selected == '' || $selected == 0 ? 'selected' : '' ) . ' >' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';

							echo '<option value="1" ' . ( $selected == 1 ? 'selected' : '' ) . '>' . esc_attr( atkp_options::$loader->get_test_score1_text() ) . '</option>';
							echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . esc_attr( atkp_options::$loader->get_test_score2_text() ) . '</option>';
							echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . esc_attr( atkp_options::$loader->get_test_score3_text() ) . '</option>';
							echo '<option value="4" ' . ( $selected == 4 ? 'selected' : '' ) . '>' . esc_attr( atkp_options::$loader->get_test_score4_text() ) . '</option>';
							echo '<option value="5" ' . ( $selected == 5 ? 'selected' : '' ) . '>' . esc_attr( atkp_options::$loader->get_test_score5_text() ) . '</option>';

							?>
                        </select>

                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Rating of test', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_testrating' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_testrating' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_testrating', true ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Date of test', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_testdate' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_testdate' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_testdate', true ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Pro (per line)', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <textarea style="width:100%;height:100px" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_pro' ?>"
                                  name="<?php echo ATKP_PRODUCT_POSTTYPE . '_pro' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_pro', true ) ); ?></textarea>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Contra (per line)', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <textarea style="width:100%;height:100px" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_contra' ?>"
                                  name="<?php echo ATKP_PRODUCT_POSTTYPE . '_contra' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_contra', true ) ); ?></textarea>
                    </td>
                </tr>

            </table>
        </div>

        <div id='atkp-tab4'>
            <table class="form-table">
                <tr valign="top">

                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimages' ?>">
							<?php _e( 'Update images upon saving', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">

                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary' ?>">
							<?php _e( 'Continuously update images', ATKP_PLUGIN_PREFIX ) ?>
                        </label>

                    </td>
                </tr>

				<?php


				$newimages = atkp_product_image::load_images( $post->ID );


				?>

                <tr valign="top">
                    <td scope="row">
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_overridemainimage' ?>">
							<?php _e( 'Override main image', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>

                        <select id="<?php echo ATKP_PRODUCT_POSTTYPE . '_overridemainimage' ?>"
                                name="<?php echo ATKP_PRODUCT_POSTTYPE . '_overridemainimage' ?>" style="width:300px">
							<?php
							echo '<option value="">' . __( 'Default', ATKP_PLUGIN_PREFIX ) . '</option>';

							$selectedmainimage = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_overridemainimage' );

							$idx = 1;
							foreach ( $newimages as $newimage ) {
								if ( $idx == $selectedmainimage ) {
									$sel = ' selected';
								} else {
									$sel = '';
								}


								echo '<option value="' . $idx . '"' . $sel . ' > ' . esc_attr( sprintf( __( 'Image %s', ATKP_PLUGIN_PREFIX ), $idx ) ) . '</option>';
								$idx ++;
							}

							?>
                        </select>


                    </td>
                </tr>

                <tr valign="top">

                    <td>

                        <table style="width:100%">

                            <tr class="mainrow">
                                <td style="width:80px;text-align:center;"><?php _e( 'Main image', ATKP_PLUGIN_PREFIX ) ?></td>
                                <td style="vertical-align:middle; text-align:center; width:120px">

									<?php
									$imageurl = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', true );

									if ( $imageurl == '' ) {
										$imageurl = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', true );
									}


									if ( $imageurl == '' ) {
										$imageurl = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', true );
									}

									?>


                                    <img style="max-width:250px" src="<?php echo $imageurl; ?>"/>

                                </td>
                                <td>
                                    <table style="width:100%;margin:1px">
                                        <tr valign="top">
                                            <th>
                                                <label for="">
													<?php _e( 'Small image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                </label>
                                            </th>
                                            <td>
                                                <input type="url" style="width:100%"
                                                       id="<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ?>"
                                                       name="<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ?>"
                                                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', true ); ?>">
                                            </td>
                                            <td style="    width: 50px;"><input type="button" id="smallimage-button"
                                                                                class="button meta-image-button"
                                                                                value="<?php _e( 'Choose or Upload an image', ATKP_PLUGIN_PREFIX ) ?>"/>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <th>
                                                <label for="">
													<?php _e( 'Medium image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                </label>
                                            </th>
                                            <td>
                                                <input type="url" style="width:100%"
                                                       id="<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ?>"
                                                       name="<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ?>"
                                                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', true ); ?>">

                                            </td>
                                            <td><input type="button" id="mediumimage-button"
                                                       class="button meta-image-button"
                                                       value="<?php _e( 'Choose or Upload an image', ATKP_PLUGIN_PREFIX ) ?>"/>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <th>
                                                <label for="">
													<?php _e( 'Large image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                </label>
                                            </th>
                                            <td>
                                                <input type="url" style="width:100%"
                                                       id="<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ?>"
                                                       name="<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ?>"
                                                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', true ); ?>">

                                            </td>
                                            <td><input type="button" id="largeimage-button"
                                                       class="button meta-image-button"
                                                       value="<?php _e( 'Choose or Upload an image', ATKP_PLUGIN_PREFIX ) ?>"/>
                                            </td>
                                        </tr>

                                    </table>
                                </td>
                        </table>

                    </td>
                </tr>


                <tr valign="top">

                    <td>
                        <input type="button" id="addimage-button" class="button add-image"
                               title="<?php _e( 'Add Image', ATKP_PLUGIN_PREFIX ) ?>"
                               value="<?php _e( 'Add Image', ATKP_PLUGIN_PREFIX ) ?>"/>

                    </td>
                </tr>
                <tr>
                    <td>
                        <table style="width:100%;border-collapse:collapse" id="images">
							<?php
							$idx = 1;
							foreach ( $newimages as $newimage ) {

								?>
                                <tr style="border-top:1px solid gainsboro;" class="mainrow">
                                    <td style="width:80px;text-align:center;">
										<?php echo '#' . $idx; ?>

                                        <input type="button" id="removeimage-button_<?php echo $newimage->id ?>"
                                               class="button remove-image atkp-galleryitem"
                                               value="<?php _e( 'Delete', ATKP_PLUGIN_PREFIX ) ?>"/>
                                    </td>
                                    <td style="vertical-align:middle; text-align:center; width:120px">
                                        <img id="image-preview_<?php echo $newimage->id ?>"
                                             src="<?php echo $newimage->mediumimageurl; ?>" style="max-width:250px"/>
                                    </td>
                                    <td>
                                        <table style="width:100%">
                                            <tr valign="top">
                                                <th>
                                                    <label for="">
														<?php _e( 'Small image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="url" class="galleryimage atkp-galleryitem"
                                                           style="width:100%"
                                                           id="<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl_gallery_' . $newimage->id ?>"
                                                           name="<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl_gallery_' . $newimage->id ?>"
                                                           value="<?php echo $newimage->smallimageurl; ?>">
                                                </td>
                                            </tr>
                                            <tr valign="top">
                                                <th>
                                                    <label for="">
														<?php _e( 'Medium image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="url" class="galleryimage atkp-galleryitem"
                                                           style="width:100%"
                                                           id="<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl_gallery_' . $newimage->id ?>"
                                                           name="<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl_gallery_' . $newimage->id ?>"
                                                           value="<?php echo $newimage->mediumimageurl; ?>">
                                                </td>
                                            </tr>
                                            <tr valign="top">
                                                <th>
                                                    <label for="">
														<?php _e( 'Large image URL', ATKP_PLUGIN_PREFIX ) ?>:
                                                    </label>
                                                </th>
                                                <td>
                                                    <input type="url" class="atkp-galleryitem" style="width:100%"
                                                           id="<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl_gallery_' . $newimage->id ?>"
                                                           name="<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl_gallery_' . $newimage->id ?>"
                                                           value="<?php echo $newimage->largeimageurl; ?>">
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>


								<?php
								$idx ++;
							}
							?>
                            <tr class="mainrow"></tr>
                        </table>

                    </td>
                </tr>
            </table>

            <script type="text/javascript">

                function Generator() {
                };
                Generator.prototype.rand = Math.floor(Math.random() * 50000);

                Generator.prototype.getId = function () {
                    return this.rand++;
                };
                var idGen = new Generator();
                var mediumimagecaption = '<?php  _e( 'Medium image URL', ATKP_PLUGIN_PREFIX ) ?>';
                var smallimagecaption = '<?php  _e( 'Small image URL', ATKP_PLUGIN_PREFIX ) ?>';
                var largeimagecaption = '<?php  _e( 'Large image URL', ATKP_PLUGIN_PREFIX ) ?>';
                var deletebtncaption = '<?php  _e( 'Delete', ATKP_PLUGIN_PREFIX ) ?>';

                var $j = jQuery.noConflict();
                /*
             * Attaches the add field to the input field
             */
                $j(document).ready(function ($) {

                    // Runs when the image button is clicked.
                    $j('#addimage-button').click(function (e) {
                        var id = idGen.getId();

                        $j('#images .mainrow:last').after('<tr style="border-top:1px solid gainsboro;" class="mainrow"><td style="width:80px;text-align:center;"><input type="button" id="removeimage-button_' + id + '" class="button remove-image atkp-galleryitem" value="' + deletebtncaption + '" /></td><td style="vertical-align:middle; text-align:center; width:120px"></td><td><table style="width:100%"><tr valign="top"><th><label for="">' + smallimagecaption + ':</label></th><td><input type="url" style="width:100%" class="galleryimage atkp-galleryitem" id="atkp_product_smallimageurl_gallery_' + id + '" name="atkp_product_mediumimageurl_gallery_' + id + '" value=""></td></tr><tr valign="top"><th><label for="">' + mediumimagecaption + ':</label></th><td><input type="url" style="width:100%" class="galleryimage atkp-galleryitem" id="atkp_product_mediumimageurl_gallery_' + id + '" name="atkp_product_mediumimageurl_gallery_' + id + '" value=""></td></tr><tr valign="top"><th ><label for="">' + largeimagecaption + ':</label></th><td><input type="url" style="width:100%" id="atkp_product_largeimageurl_gallery_' + id + '" class= "atkp-galleryitem" name="atkp_product_largeimageurl_gallery_' + id + '" value=""></td></tr></table></td></tr>');


                        $j('#removeimage-button_' + id).click(function (e) {

                            if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                $j(this).parent().parent().remove();
                            }

                        });
                    });

                    $j('.remove-image').click(function (e) {

                        if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                            $j(this).parent().parent().remove();
                        }
                    });


                    $j('.remove-offer').click(function (e) {

                        if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                            $j(this).parent().parent().prev().remove();
                            $j(this).parent().parent().prev().remove();
                            $j(this).parent().parent().remove();
                            $j('#atkp_offerschanged').val('1');
                        }
                    });

                });

            </script>
        </div>
        <div id='atkp-tab5'>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo' ?>">
							<?php _e( 'Update price information upon saving', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary' ?>">
							<?php _e( 'Continuously update price information', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'List price', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_listprice' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_listprice' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_listprice', true ); ?>">

						<?php if ( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_listprice', true ) != '' ) { ?>
                            (<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_listpricefloat', true ); ?>)<?php } ?>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Amount saved', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_amountsaved' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_amountsaved' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_amountsaved', true ); ?>">

						<?php if ( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_amountsaved', true ) != '' ) { ?>
                            (<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_amountsavedfloat', true ); ?>) <?php } ?>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Percentage saved', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="number" min="0" max="100" step="0.01"
                               id="<?php echo ATKP_PRODUCT_POSTTYPE . '_percentagesaved' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_percentagesaved' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_percentagesaved', true ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Sale price', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_saleprice' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_saleprice' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_saleprice', true ); ?>">
						<?php if ( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_saleprice', true ) != '' ) { ?>
                            (<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_salepricefloat', true ); ?>) <?php } ?>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Availability', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" style="width:50%" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_availability' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_availability' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_availability', true ); ?>">
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Shipping', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="text" style="width:50%" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_shipping' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_shipping' ?>"
                               value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_shipping', true ); ?>">
						<?php if ( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_shipping', true ) != '' ) { ?>
                            (<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_shippingfloat', true ); ?>)<?php } ?>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Is prime', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_isprime' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_isprime' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_isprime' ), true ); ?>>
                    </td>
                </tr>

            </table>
        </div>
		<?php if ( ATKP_PLUGIN_VERSION >= 30 ) { ?>
            <div id='atkp-tab6'>

                <table class="form-table">

					<?php

					$newfields = atkp_udfield::load_fields();
					$helper    = new atkp_control_helper();

					foreach ( $newfields as $newfield ) {
						$fieldname = 'customfield_' . $newfield->name;


						?>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php echo $newfield->caption == '' ? $newfield->name : $newfield->caption ?>:
                                </label>
                            </th>
                            <td>

								<?php


								$helper->create_control( $newfield, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname ) );
								?>
                            </td>
                        </tr>
					<?php }


					$groups = ATKPTools::get_fieldgroups_by_productid( $post->ID );

					foreach ( $groups as $group ) {

						?>

                        <tr valign="top">
                            <th scope="row" colspan="2">
                    <span style="font-size:16px;    font-weight: bold;">
                        <?php echo $group->post_title ?>
                    </span>
                                <hr/>
                            </th>

                        </tr>

						<?php

						$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

						foreach ( $fields as $field ) {
							if ( $field->type != 6 ) {
								?>

                                <tr valign="top">
                                    <th scope="row">
                                        <label for="">
											<?php echo $field->caption == '' ? $field->name : $field->caption ?>:
                                        </label>
                                    </th>
                                    <td>

										<?php


										$helper->create_control( $field, ATKP_PRODUCT_POSTTYPE . '_cf_' . $field->name, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_cf_' . $field->name ), true );
										?>
                                    </td>
                                </tr>

								<?php
							}
						}
					}

					?>


                </table>
            </div>
		<?php } ?>

        <div id='atkp-tab7'>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffers' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffers' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffers' ?>">
							<?php _e( 'Update additional offers for this product', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_forceofferupdate' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_forceofferupdate' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_forceofferupdate' ?>">
							<?php _e( 'Force offers update now (not recommended)', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">

                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' ?>"
                               value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' ), true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary' ?>">
							<?php _e( 'Continously load additional offers', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row" colspan="2">
						<?php _e( 'Note: Offers are either loaded in cronjob (background) or when clicking "Load additional offers upon saving".".', ATKP_PLUGIN_PREFIX ) ?>

                    </th>

                </tr>

                <tr>
                    <td colspan="7">
                        <table class="form-table" style="width:60%">
                            <tr>
                                <th scope="row">
                                    <label for="">
										<?php _e( 'Shop', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <select id="addoffer_shopid" name="addoffer_shopid" style="width:250px">
										<?php

										$selectedshopid = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_shopid' );

										$shps = atkp_shop::get_list( $selectedshopid );

										foreach ( $shps as $shp ) {
											if ( $shp->selected == true ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}


											echo '<option value="' . $shp->id . '"' . $sel . ' > ' . esc_attr( $shp->title ) . '</option>';
										}


										?>
                                    </select>


                                </td>

                                <th scope="row">
                                    <label id="searchcaption" for="">
										<?php _e( 'Unique productid', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <input type="button" id="addoffer-button" class="button product-lookup thickbox"
                                           title="<?php _e( 'Search unique product id and add it', ATKP_PLUGIN_PREFIX ) ?>"
                                           alt="#TB_inline?height=400&amp;width=500&amp;inlineId=modal-asin-lookupoffer"
                                           value="<?php _e( 'Search unique product id and add it', ATKP_PLUGIN_PREFIX ) ?>"/>

                                </td>
                            </tr>

                        </table>
                    </td>
                </tr>

            </table>


            <table style="width:100%;border-collapse:collapse" id="prices" width="100%">
                <tr valign="top">
                    <td style="width:40%">

						<?php echo '<input type="hidden" id="atkp_offerschanged" name="atkp_offerschanged" value="0">'; ?>

                        <b><?php _e( 'Title', ATKP_PLUGIN_PREFIX ) ?></b><br/><b><?php _e( 'Shop: Number', ATKP_PLUGIN_PREFIX ) ?></b>


                    </td>

                    <td style="width:20%">
                        <b><?php _e( 'Price <br />Shipping <br /> Availability', ATKP_PLUGIN_PREFIX ) ?></b>
                    </td>
                    <td>
                        <b><?php _e( 'Hide offer', ATKP_PLUGIN_PREFIX ) ?></b>
                    </td>
                    <td>
                        <b><?php _e( 'Message', ATKP_PLUGIN_PREFIX ) ?></b>
                    </td>

                    <td>

                    </td>
                </tr>

				<?php

				$offers = atkp_product_offer::load_offers( $post->ID );

				usort( $offers, array( $this, "atkp_offercompare" ) );

				if ( is_array( $offers ) ) {
					foreach ( $offers as $offer ) {
                        $xshop = null;
                        foreach ( $shps as $shop ) {
                            if ( $offer->shopid == $shop->id || $offer->oldid == $shop->id ) {
                                $xshop = $shop;
                                break;
                            }
                        }

                        if($xshop == null)
                            continue;
                        ?>

                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr style="border-top:1px gray solid">
                            <td colspan="6">&nbsp;</td>
                        </tr>

                        <tr valign="top">
                            <td>
                                <a href="<?php echo $offer->link; ?>" target="_blank"><?php echo $offer->title; ?></a>

                                <br/>
								<?php
								//type1 == autload / 2 == manuell
								echo '<input type="hidden" id="' . ATKP_PRODUCT_POSTTYPE . '_offer_id_' . $offer->id . '" name="' . ATKP_PRODUCT_POSTTYPE . '_offer_id_' . $offer->id . '" value="' . $offer->id . '">';

								if($xshop != null)
    								echo esc_attr( $xshop->title );


								?>:

								<?php echo $offer->number; ?>


                            </td>
                            <td>
								<?php echo $offer->price; ?>  <?php if ( $offer->price != '' ) { ?> (<?php echo $offer->pricefloat; ?>) <?php } ?>
                                <br/>
								<?php echo $offer->shipping; ?> <?php if ( $offer->shipping != '' ) { ?> (<?php echo $offer->shippingfloat; ?>)<?php } ?>
                                <br/>
								<?php echo $offer->availability; ?>
                            </td>
                            <td>
								<?php
								if ( $offer->type == 1 ) { ?>
                                    <input type="checkbox" name="atkp_product_offer_hide_<?php echo $offer->id ?>"
                                           id="hideoffer-<?php echo $offer->id ?>"
                                           class="hideoffer" <?php echo checked( 1, $offer->hideoffer ) ?> />
								<?php } ?>
                            </td>
                            <td>
								<?php echo ( $offer->updatedon == null ? __( 'marked for price update', ATKP_PLUGIN_PREFIX ) : 'last update: ' . $offer->updatedon ) . '<br />';
								echo( $offer->message != '' && strlen( $offer->message ) > 183 ? substr( $offer->message, 0, 180 ) . '...' : $offer->message ); ?>
                            </td>
                            <td style="width: 90px;">

                                <input type="button" <?php echo( $offer->type == 1 ? 'disabled' : '' ); ?>
                                       id="removeoffer-button_<?php echo $offer->id ?>" class="button remove-offer"
                                       value="<?php _e( 'Delete', ATKP_PLUGIN_PREFIX ) ?>"/>

                            </td>
                        </tr>


					<?php }
				} ?>
                <tr class="mainrow"></tr>

            </table>

        </div>

        <div id='atkp-tab8'>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                    </th>
                    <td>
                        <input type="checkbox" id="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>"
                               value="1" <?php echo checked( 1, 0, true ); ?>>
                        <label for="<?php echo ATKP_PRODUCT_POSTTYPE . '_refreshvariations' ?>">
							<?php _e( 'Update variations upon saving', ATKP_PLUGIN_PREFIX ) ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">
                        <label for="">
							<?php _e( 'Parent ASIN', ATKP_PLUGIN_PREFIX ) ?>:
                        </label>
                    </th>
                    <td>
                        <input style="width:100%" readonly type="text"
                               id="<?php echo ATKP_PRODUCT_POSTTYPE . '_parentasin' ?>"
                               name="<?php echo ATKP_PRODUCT_POSTTYPE . '_parentasin' ?>"
                               value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_parentasin' ) ); ?>">
                    </td>
                </tr>

                <tr valign="top">

                    <td>
                    </td>
                    <td>
                        <table style="width:100%">
							<?php
							$variations    = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_variations' );
							$variationname = ATKPTools::get_post_setting( $post->ID, ATKP_PRODUCT_POSTTYPE . '_variationname' );


							if ( isset( $variations ) && is_array( $variations ) ) {

								?>
                                <tr>
                                    <th><?php
										_e( 'ASIN', ATKP_PLUGIN_PREFIX );
										?> </th>
                                    <th><?php
										$displaylist = array();
										foreach ( $variationname as $key => $value ) {
											array_push( $displaylist, htmlentities( $value ) );
										}

										echo implode( ' &#8594; ', $displaylist );
										?> </th>
                                    <th><?php
										_e( 'Product page URL', ATKP_PLUGIN_PREFIX );


										?> </th>
                                </tr> <?php
								foreach ( $variations as $variation ) {
									?>
                                    <tr>
                                        <td style="padding:0"><?php
											echo $variation->asin;
											?> </td>
                                        <td style="padding:0"><?php

											$displaylist = array();
											foreach ( $variation->variationname as $key => $value ) {
												array_push( $displaylist, htmlentities( $value ) );
											}

											echo implode( ' &#8594; ', $displaylist );
											?> </td>
                                        <td style="padding:0"><?php
											echo '<a href="' . $variation->producturl . '" target="blank">' . $variation->title . '</a>';


											?> </td>
                                    </tr> <?php
								}
							}

							?>
                        </table>
                    </td>
                </tr>

            </table>


        </div>


        <style>
            .atkp-tabs li {
                list-style: none;
                display: inline;
            }

            .atkp-tabs a {
                padding: 5px 10px;
                margin-left: -5px;
                display: inline-block;
                background: #666;
                border: 1px solid #666;
                color: #fff;
                text-decoration: none;
                line-height: 1.3;
                font-weight: 600;
                font-size: 14px;
            }

            .atkp-tabs .active {
                background: #fff;
                color: #000;
            }

        </style>

        <script type="text/javascript">
            var $j = jQuery.noConflict();
            /*
 * Attaches the image uploader to the input field
 */
            $j(document).ready(function ($) {

//tabs

                $j('ul.atkp-tabs').each(function () {
                    // For each set of tabs, we want to keep track of
                    // which tab is active and its associated content
                    var $active, $content, $links = $(this).find('a');

                    // If the location.hash matches one of the links, use that as the active tab.
                    // If no match is found, use the first link as the initial active tab.
                    $active = $($links.filter('[href="' + location.hash + '"]')[0] || $links[0]);
                    $active.addClass('active');

                    $content = $($active[0].hash);

                    // Hide the remaining content
                    $links.not($active).each(function () {
                        $(this.hash).hide();
                    });

                    // Bind the click event handler
                    $j(this).on('click', 'a', function (e) {
                        // Make the old tab inactive.
                        $active.removeClass('active');
                        $content.hide();

                        // Update the variables with the new link and content
                        $active = $(this);
                        $content = $(this.hash);

                        // Make the tab active.
                        $active.addClass('active');
                        $content.show();

                        // Prevent the anchor's default click action
                        e.preventDefault();
                    });
                });

//tabs

                // Instantiates the variable that holds the media library frame.
                var meta_image_frame;
                var image_button;
                // Runs when the image button is clicked.
                $j('.meta-image-button').click(function (e) {

                    // Prevents the default action from occuring.
                    e.preventDefault();

                    // If the frame already exists, re-open it.
                    //if ( meta_image_frame ) {
                    //    meta_image_frame.open();
                    //    return;
                    //}

                    // Sets up the media library frame
                    meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
                        title: meta_image.title,
                        button: {text: meta_image.button},
                        library: {type: 'image'}
                    });

                    image_button = $j(this).attr('id');

                    // Runs when an image is selected.
                    meta_image_frame.on('select', function () {

                        // Grabs the attachment selection and creates a JSON representation of the model.
                        var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

                        // Sends the attachment URL to our custom image input field.
                        if (image_button == $j('#smallimage-button').attr('id'))
                            $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_smallimageurl' ?>').val(media_attachment.url);
                        else if (image_button == $j('#mediumimage-button').attr('id'))
                            $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_mediumimageurl' ?>').val(media_attachment.url);
                        else if (image_button == $j('#largeimage-button').attr('id'))
                            $j('#<?php echo ATKP_PRODUCT_POSTTYPE . '_largeimageurl' ?>').val(media_attachment.url);
                    });

                    // Opens the media library frame.
                    meta_image_frame.open();
                });
            });

        </script>

		<?php
	}

	function atkp_offercompare( $a, $b ) {
		if ( $a == null ) {
			return - 1;
		}
		if ( $b == null ) {
			return 1;
		}

		if ( $a->id == $b->id ) {
			return 0;
		}

		return ( $a->id < $b->id ) ? - 1 : 1;
	}

	function substr_startswith( $haystack, $needle ) {
		return substr( $haystack, 0, strlen( $needle ) ) === $needle;
	}


	function product_detail_save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$nounce = ATKPTools::get_post_parameter( 'product_detail_box_content_nonce', 'string' );

		if ( ! wp_verify_nonce( $nounce, plugin_basename( __FILE__ ) ) ) {
			return;
		}


		$post = get_post( $post_id );

		$posttype = $post->post_type; //ATKPTools::get_post_parameter('post_type', 'string');

		if ( ATKP_PRODUCT_POSTTYPE != $posttype ) {
			return;
		}

		$shopid = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_shopid', 'string' );

		$title = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_title', 'string' );

		$description = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_description', 'html' );

		$disablehoverlink = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_disablehoverlink', 'bool' );

		$refreshproductinfo = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshproductinfo', 'bool' );
		$refreshpriceinfo   = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshpriceinfo', 'bool' );
		$refreshreviewinfo  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshreviewinfo', 'bool' );

		$refreshimages     = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshimages', 'bool' );
		$refreshproducturl = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshproducturl', 'bool' );

		$refreshvariations = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshvariations', 'bool' );

		$refreshimagesregulary = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary', 'bool' );

		$refreshreviewinforegulary = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary', 'bool' );
		$refreshpriceinforegulary  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary', 'bool' );
		$refreshproducturlregulary = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary', 'bool' );

		$outputashtml = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_outputashtml', 'bool' );

		$asin     = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_asin', 'string' );
		$asintype = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_asintype', 'string' );

		$ean = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_ean', 'string' );

		$isbn         = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_isbn', 'string' );
		$mpn          = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_mpn', 'string' );
		$brand        = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_brand', 'string' );
		$productgroup = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_productgroup', 'string' );

		$releasedate = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_releasedate', 'string' );


		$producturl        = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_producturl', 'url' );
		$addtocarturl      = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_addtocarturl', 'url' );
		$customerreviewurl = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl', 'url' );


		$overridemainimage = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_overridemainimage', 'string' );

		$smallimageurl  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_smallimageurl', 'url' );
		$mediumimageurl = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', 'url' );
		$largeimageurl  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_largeimageurl', 'url' );

		$manufacturer  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_manufacturer', 'string' );
		$author        = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_author', 'string' );
		$numberofpages = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_numberofpages', 'int' );
		$features      = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_features', 'html' );

		$isownreview = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_isownreview', 'bool' );

		$rating      = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_rating', 'double' );
		$reviewcount = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_reviewcount', 'int' );
		$reviewsurl  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_reviewsurl', 'url' );

		$listprice       = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_listprice', 'string' );
		$amountsaved     = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_amountsaved', 'string' );
		$percentagesaved = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_percentagesaved', 'string' );
		$saleprice       = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_saleprice', 'string' );
		$availability    = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_availability', 'string' );
		$shipping        = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_shipping', 'string' );
		$isprime         = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_isprime', 'bool' );


		$predicate  = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_predicate', 'string' );
		$testdate   = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_testdate', 'string' );
		$testrating = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_testrating', 'string' );
		$testresult = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_testresult', 'string' );

		$reviewtext = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_reviewtext', 'string' );

		$pro    = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_pro', 'multistring' );
		$contra = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_contra', 'multistring' );

		$iswoocommerce = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_iswoocommerce', 'bool' );

		$dontimportmainimage = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage', 'bool' );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_overridemainimage', $overridemainimage );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_dontimportmainimage', $dontimportmainimage );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_iswoocommerce', $iswoocommerce );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_pro', $pro );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_contra', $contra );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_predicate', $predicate );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_testdate', $testdate );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_testrating', $testrating );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_testresult', $testresult );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_reviewtext', $reviewtext );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_outputashtml', $outputashtml );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shopid', $shopid );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_title', $title );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_description', $description );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asin', $asin );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_asintype', $asintype );


		$eanchanged = false;
		$eanold     = ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_ean' );

		if ( $eanold != $ean ) {
			$eanchanged = true;
		}

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_ean', $ean );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isbn', $isbn );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mpn', $mpn );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_brand', $brand );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_productgroup', $productgroup );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_releasedate', $releasedate );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_manufacturer', $manufacturer );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_author', $author );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_numberofpages', $numberofpages );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_features', $features );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_disablehoverlink', $disablehoverlink );

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshreviewinforegulary', $refreshreviewinforegulary );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshpriceinforegulary', $refreshpriceinforegulary );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshproducturlregulary', $refreshproducturlregulary );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshimagesregulary', $refreshimagesregulary );

		if ( ! $refreshproducturlregulary ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_producturl', $producturl );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_addtocarturl', $addtocarturl );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_customerreviewsurl', $customerreviewurl );
		}

		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isownreview', $isownreview );
		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_reviewsurl', $reviewsurl );

		if ( ! $refreshimagesregulary ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_smallimageurl', $smallimageurl );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_mediumimageurl', $mediumimageurl );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_largeimageurl', $largeimageurl );
		}

		if ( ! $refreshreviewinforegulary ) {
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_rating', $rating );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_reviewcount', $reviewcount );
		}

		if ( ! $refreshpriceinforegulary ) {

			$salepricefloat = ATKPTools::price_to_float( $saleprice );

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listprice', $listprice );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsaved', $amountsaved );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_percentagesaved', $percentagesaved );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_saleprice', $saleprice );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_availability', $availability );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shipping', $shipping );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_isprime', $isprime );

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_listpricefloat', ATKPTools::price_to_float( $listprice ) );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_amountsavedfloat', ATKPTools::price_to_float( $amountsaved ) );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_salepricefloat', $salepricefloat );
			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_shippingfloat', ATKPTools::price_to_float( $shipping ) );

			if ( atkp_options::$loader->get_pricehistory_enabled() ) {
				$history = new atkp_pricehistorytable_helper();
				$history->create_history_entry( $post_id, $shopid, $saleprice, $salepricefloat );
			}

		}


		//offers

		$refreshmoreoffersregulary = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary', 'bool' );
		$refreshmoreoffers         = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffers', 'bool' );
		$forceofferupdate          = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_forceofferupdate', 'bool' );


		ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffersregulary', $refreshmoreoffersregulary );
		//ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_refreshmoreoffers', $refreshmoreoffers );

		$offerschanged = ATKPTools::get_post_parameter( 'atkp_offerschanged', 'bool' );

		if ( $offerschanged != '0' ) {

			$offers    = atkp_product_offer::load_offers( $post_id );
			$offersnew = array();

			//TODO: wie änderung mitbekommen? hidden feld setzen? und nur dann überschreiben...

			foreach ( $_POST as $key => $value ) {
				$key   = sanitize_text_field( $key );
				$value = sanitize_text_field( $value );

				$id = str_replace( 'atkp_product_offer_id_', '', $key );
				$id = str_replace( 'atkp_product_offer_hide_', '', $id );

				$id = str_replace( 'atkp_product_offer_shopid_', '', $id );
				$id = str_replace( 'atkp_product_offer_number_', '', $id );


				$udf       = new atkp_product_offer();
				$udf->type = 2;
				$udf->id   = $id;
				$checkit   = 0;
				$add       = 1;

				foreach ( $offersnew as $offer ) {
					if ( $offer->id == $udf->id ) {
						$udf = $offer;
						$add = 0;
						break;
					}
				}

				if ( $this->substr_startswith( $key, 'atkp_product_offer_id_' ) ) {
					$checkit = 1;
					$udf->id = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_product_offer_shopid_' ) ) {
					$checkit     = 1;
					$udf->shopid = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_product_offer_number_' ) ) {
					$checkit     = 1;
					$udf->number = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_product_offer_hide_' ) ) {
					$checkit        = 1;
					$udf->hideoffer = ATKPTools::get_post_parameter( $key, 'bool' );
				}

				if ( $checkit && $add ) {
					array_push( $offersnew, $udf );
				}
			}

			$mergedoffers = array();
			foreach ( $offersnew as $udf ) {
				$mergedoffer = $udf;
				foreach ( $offers as $offer ) {
					if ( $offer->id == $udf->id ) {
						$mergedoffer            = $offer;
						$mergedoffer->hideoffer = $udf->hideoffer;
						break;
					}
				}
				array_push( $mergedoffers, $mergedoffer );
			}


			$offertablehelper = new atkp_offertable_helper();

			$offertablehelper->update_offers_by_productid( $post_id, $mergedoffers, true );

			//ATKPTools::set_post_setting($post_id, ATKP_PRODUCT_POSTTYPE.'_offers', $mergedoffers);
			$refreshmoreoffers = 1;
		}


		//offers


		//imagegallery

		if ( ! $refreshimagesregulary ) {
			$images = array();

			//echo serialize($_POST);

			foreach ( $_POST as $key => $value ) {
				$key   = sanitize_text_field( $key );
				$value = sanitize_text_field( $value );

				$id = str_replace( 'atkp_product_largeimageurl_gallery_', '', $key );
				$id = str_replace( 'atkp_product_smallimageurl_gallery_', '', $id );
				$id = str_replace( 'atkp_product_mediumimageurl_gallery_', '', $id );

				$checkit = 0;
				$add     = 1;
				$udf     = new atkp_product_image();
				$udf->id = $id;

				foreach ( $images as $image ) {
					if ( $image->id == $udf->id ) {
						$udf = $image;
						$add = 0;
						break;
					}
				}


				if ( $this->substr_startswith( $key, 'atkp_product_largeimageurl_gallery' ) ) {
					$checkit            = 1;
					$udf->largeimageurl = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_product_smallimageurl_gallery' ) ) {
					$checkit            = 1;
					$udf->smallimageurl = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_product_mediumimageurl_gallery' ) ) {
					$checkit             = 1;
					$udf->mediumimageurl = $value;
				}

				if ( $checkit && $add ) {
					array_push( $images, $udf );
				}
			}

			ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_images', $images );
		}

		//imagegallery

		//benutzerdefinierte felder speichern
		if ( ATKP_PLUGIN_VERSION >= 30 ) {

			$newfields = atkp_udfield::load_fields();
			$helper    = new atkp_control_helper();
			$allfields = array();

			foreach ( $newfields as $newfield ) {
				$fieldname = 'customfield_' . $newfield->name;

				$fieldvalue = $helper->read_control_value( $newfield, $fieldname );

				ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );

				//array_push($allfields, $newfield);
			}

			$groups = ATKPTools::get_fieldgroups_by_productid( $post_id );

			foreach ( $groups as $group ) {

				$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

				foreach ( $fields as $newfield ) {
					if ( $newfield->type != 6 ) {
						$fieldname = 'cf_' . $newfield->name;

						$fieldvalue = $helper->read_control_value( $newfield, $fieldname );

						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );

					}

					array_push( $allfields, $newfield );
				}
			}

			$importurl = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_importurl', 'html' );

			if ( $importurl != null ) {
				//parse url and update values...

				$parser    = new atkp_url_scraper();
				$newfields = $parser->get_rows( $importurl );

				foreach ( $newfields as $nfield ) {
					try {
						$udf = null;

						foreach ( $allfields as $field ) {
							if ( $field->caption == sanitize_text_field( $nfield['name'] ) ) {
								$udf = $field;
								break;
							}
						}

						if ( $udf == null ) {
							continue;
						}

						$fieldvalue = sanitize_text_field( $nfield['caption'] );

						if ( $udf->type == 6 ) {

							//update taxonomy
							ATKPTools::check_taxonomy( $post_id, $udf->name, $fieldvalue, false );

						} else {
							$fieldname = 'cf_' . $udf->name;

							if ( $udf->format == 'number' ) {
								//extract number from string

								$fieldvalue = preg_replace( "/[^0-9]/", "", $fieldvalue );

								$fieldvalue = intval( $fieldvalue );
							}

							//$oldval =ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE.'_'.$fieldname);
							//if($oldval == '')
							ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );
						}

					} catch ( Exception $e ) {

					}
				}

			}
		}


		$productservice = new atkp_productservice( array() );

		$productservice->update_product_categories( $post_id );

		$productservice->update_product_taxonomies( $post_id );

		$shop = $shopid != '' ? atkp_shop::load( $shopid, true ) : null;

		//erzweingt das update falls ean oder ähnliches geändert wurde
		if ( $eanchanged ) {
			$refreshmoreoffers = true;
		}

		$productservice->update_products( $shop, array( $post_id ), $asintype, false, $refreshproductinfo, $refreshpriceinfo, $refreshvariations, $refreshreviewinfo, $refreshimages, $refreshproducturl, $refreshmoreoffers );

		if ( $iswoocommerce ) {
			$productservice->export_products( array( $post_id ) );
		}

		if ( $forceofferupdate ) {
			$offerservice = new atkp_offerservice( array() );

			$atkpprod = atkp_product::load( $post_id );
			$offerservice->clear_offers( $atkpprod, '' );


			$offerservice->do_single_offer_update( $post_id );
		}

	}

}

?>