<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shortcodes_searchform {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_shortcode( ATKP_SEARCHFORM_SHORTCODE, array( &$this, 'shortcode' ) );
	}


	function shortcode( $atts, $content = "" ) {
		try {

			$a = shortcode_atts( array(
				'template'   => '',
				'targetpage' => 0,
			), $atts );

			$template   = 'searchform';
			$targetpage = 0;

			if ( isset( $a['targetpage'] ) ) {
				$targetpage = intval( $a['targetpage'] );
			}
			if ( isset( $a['template'] ) && ! empty( $a['template'] ) ) {
				$template = $a['template'];
			}

			$output = new atkp_output();

			return $output->get_searchform_output( $template, $targetpage, $content );

		} catch ( Exception $e ) {
			if ( ATKPSettings::$hideerrormessages ) {
				return '';
			} else {
				return 'Exception: ' . $e->getMessage();
			}
		}
	}
}


?>