<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_customfield {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
	}

	function substr_startswith( $haystack, $needle ) {
		return substr( $haystack, 0, strlen( $needle ) ) === $needle;
	}


	public function customfield_configuration_page() {
		if ( ATKPTools::exists_post_parameter( 'savecustomfields' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			//speichern der einstellungen

			$fields = array();

			foreach ( $_POST as $key => $value ) {
				$key   = sanitize_text_field( $key );
				$value = sanitize_text_field( $value );

				$id = str_replace( 'atkp_caption_', '', $key );
				$id = str_replace( 'atkp_name_', '', $id );
				$id = str_replace( 'atkp_type_', '', $id );
				$id = str_replace( 'atkp_format_', '', $id );

				$checkit = 0;
				$add     = 1;
				$udf     = new atkp_udfield();
				$udf->id = $id;

				foreach ( $fields as $field ) {
					if ( $field->id == $udf->id ) {
						$udf = $field;
						$add = 0;
						break;
					}
				}


				if ( $this->substr_startswith( $key, 'atkp_caption' ) ) {
					$checkit      = 1;
					$udf->caption = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_name' ) ) {
					$checkit   = 1;
					$udf->name = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_type' ) ) {
					$checkit   = 1;
					$udf->type = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_format' ) ) {
					$checkit     = 1;
					$udf->format = $value;
				}

				if ( $checkit && $add ) {
					array_push( $fields, $udf );
				}
			}

			foreach ( $fields as $field ) {
				$field->name = sanitize_title( $field->name, $field->id );
			}

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_udf_product', $fields );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_manufacturer_taxonomy', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_manufacturer_taxonomy', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_brand_taxonomy', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_brand_taxonomy', 'string' ) );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_author_taxonomy', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_author_taxonomy', 'string' ) );
			if ( atkp_options::$loader->get_productgroups_enabled() ) {
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_product_category_taxonomy', ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_product_category_taxonomy', 'string' ) );
			}

			$taxonomies = array();

			foreach ( $_POST as $key => $value ) {
				$key   = sanitize_text_field( $key );
				$value = sanitize_text_field( $value );

				$id = str_replace( 'atkp_tax_caption_', '', $key );
				$id = str_replace( 'atkp_tax_name_', '', $id );
				$id = str_replace( 'atkp_tax_plural_', '', $id );

				$checkit = 0;
				$add     = 1;
				$udf     = new atkp_udtaxonomy();
				$udf->id = $id;

				foreach ( $taxonomies as $field ) {
					if ( $field->id == $udf->id ) {
						$udf = $field;
						$add = 0;
						break;
					}
				}


				if ( $this->substr_startswith( $key, 'atkp_tax_caption' ) ) {
					$checkit      = 1;
					$udf->caption = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_tax_name' ) ) {
					$checkit   = 1;
					$udf->name = $value;
				} else if ( $this->substr_startswith( $key, 'atkp_tax_plural' ) ) {
					$checkit            = 1;
					$udf->captionplural = $value;
				}

				if ( $checkit && $add ) {
					array_push( $taxonomies, $udf );
				}
			}

			foreach ( $taxonomies as $field ) {
				$field->name = sanitize_title( $field->name, $field->id );
			}

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_udt_product', $taxonomies );


		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="atkp-content wrap">
            <div class="inner">
                <!-- <h2><?php _e( 'Affiliate Toolkit - User defined Fields', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>">
                    <!--_affiliate_toolkit-bestseller-->
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Create custom fields for product', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-customfield' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">

                            <td colspan="2">
                                &nbsp;
                            </td>

                        </tr>


                        <tr valign="top">

                            <td colspan="2">
                                <input type="button" id="addfield-button" class="button add-field"
                                       title="<?php _e( 'Add Field', ATKP_PLUGIN_PREFIX ) ?>"
                                       value="<?php _e( 'Add Field', ATKP_PLUGIN_PREFIX ) ?>"/>

                            </td>
                        </tr>

                        <tr valign="top">

                            <td colspan="2">

								<?php

								$newfields = atkp_udfield::load_fields();

								?>

                                <table id="fields" style="width:100%">
                                    <tr>
                                        <th>
											<?php _e( 'Caption', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
											<?php _e( 'Name', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
											<?php _e( 'Type', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
											<?php _e( 'Format', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
                                            &nbsp;
                                        </th>
                                    </tr>

									<?php

									foreach ( $newfields as $newfield ) {

										?>

                                        <tr>

                                            <td><input type="text" id="<?php echo 'atkp_caption_' . $newfield->id ?>"
                                                       name="<?php echo 'atkp_caption_' . $newfield->id ?>"
                                                       value="<?php echo esc_attr( $newfield->caption ); ?>"></td>
                                            <td><input type="text" id="<?php echo 'atkp_name_' . $newfield->id ?>"
                                                       name="<?php echo 'atkp_name_' . $newfield->id ?>"
                                                       value="<?php echo esc_attr( $newfield->name ); ?>"></td>

                                            <td>
                                                <select id="<?php echo 'atkp_type_' . $newfield->id ?>"
                                                        name="<?php echo 'atkp_type_' . $newfield->id ?>">
													<?php


													echo '<option value="1" ' . ( $newfield->type == 1 ? 'selected' : '' ) . '>' . __( 'Text', ATKP_PLUGIN_PREFIX ) . '</option>';
													echo '<option value="2" ' . ( $newfield->type == 2 ? 'selected' : '' ) . '>' . __( 'Multiline', ATKP_PLUGIN_PREFIX ) . '</option>';
													echo '<option value="3" ' . ( $newfield->type == 3 ? 'selected' : '' ) . '>' . __( 'Dropdown', ATKP_PLUGIN_PREFIX ) . '</option>';
													echo '<option value="4" ' . ( $newfield->type == 4 ? 'selected' : '' ) . '>' . __( 'Yes/No', ATKP_PLUGIN_PREFIX ) . '</option>';
													echo '<option value="5" ' . ( $newfield->type == 5 ? 'selected' : '' ) . '>' . __( 'Html', ATKP_PLUGIN_PREFIX ) . '</option>';
													?>
                                                </select>
                                            </td>
                                            <td><input type="text" id="<?php 'atkp_format_' . $newfield->id ?>"
                                                       name="<?php echo 'atkp_format_' . $newfield->id ?>"
                                                       value="<?php echo esc_attr( $newfield->format ); ?>"></td>

                                            <td>
                                                <input type="button" id="removefield-button" class="button remove-field"
                                                       title="<?php _e( 'Delete field', ATKP_PLUGIN_PREFIX ) ?>"
                                                       value="<?php _e( 'Delete field', ATKP_PLUGIN_PREFIX ) ?>"/>

                                            </td>
                                        </tr>

									<?php } ?>

                                </table>

                            </td>
                        </tr>

                        <tr>
                            <td>&nbsp;</td>
                        </tr>


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'Create custom taxonomies for product', ATKP_PLUGIN_PREFIX ) ?><?php echo ATKPHomeLinks::GetHelpIcon( 'setting-customtaxonomy' ); ?>
                            </th>
                        </tr>

                        <tr valign="top">

                            <td colspan="2">
                                &nbsp;
                            </td>

                        </tr>

                        <tr valign="top">
                            <th>
                                <label for="">
									<?php _e( 'manufacturer taxonomy', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_product_manufacturer_taxonomy' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_manufacturer_taxonomy' ?>"
                                       value="<?php echo atkp_options::$loader->get_product_manufacturer_taxonomy(); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th>
                                <label for="">
									<?php _e( 'author taxonomy', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_product_author_taxonomy' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_author_taxonomy' ?>"
                                       value="<?php echo atkp_options::$loader->get_product_author_taxonomy(); ?>">
                            </td>
                        </tr>

                        <tr valign="top">
                            <th>
                                <label for="">
									<?php _e( 'brand taxonomy', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input type="text" style="width:100%"
                                       id="<?php echo ATKP_PLUGIN_PREFIX . '_product_brand_taxonomy' ?>"
                                       name="<?php echo ATKP_PLUGIN_PREFIX . '_product_brand_taxonomy' ?>"
                                       value="<?php echo atkp_options::$loader->get_product_brand_taxonomy(); ?>">
                            </td>
                        </tr>

						<?php if ( atkp_options::$loader->get_productgroups_enabled() ) { ?>

                            <tr valign="top">
                                <th>
                                    <label for="">
										<?php _e( 'productcategory taxonomy', ATKP_PLUGIN_PREFIX ) ?>:
                                    </label>
                                </th>
                                <td>
                                    <input type="text" style="width:100%"
                                           id="<?php echo ATKP_PLUGIN_PREFIX . '_product_category_taxonomy' ?>"
                                           name="<?php echo ATKP_PLUGIN_PREFIX . '_product_category_taxonomy' ?>"
                                           value="<?php echo atkp_options::$loader->get_product_category_taxonomy(); ?>">
                                </td>
                            </tr>

						<?php } ?>


                        <tr valign="top">

                            <td colspan="2">
                                <input type="button" id="addtaxonomy-button" class="button add-taxonomy"
                                       title="<?php _e( 'Add taxonomy', ATKP_PLUGIN_PREFIX ) ?>"
                                       value="<?php _e( 'Add Taxonomy', ATKP_PLUGIN_PREFIX ) ?>"/>

                            </td>
                        </tr>

                        <tr valign="top">
							<?php $taxonomies = atkp_udtaxonomy::load_taxonomies(); ?>
                            <td colspan="2">
                                <table id="taxonomies" style="width:100%">
                                    <tr>
                                        <th>
											<?php _e( 'Caption', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
											<?php _e( 'Caption (plural)', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>
                                        <th>
											<?php _e( 'Name', ATKP_PLUGIN_PREFIX ) ?>
                                        </th>

                                        <th>
                                            &nbsp;
                                        </th>
                                    </tr>

									<?php

									foreach ( $taxonomies as $taxonomy ) {
										if ( $taxonomy->issystemfield ) {
											continue;
										}
										?>

                                        <tr>

                                            <td><input type="text"
                                                       id="<?php echo 'atkp_tax_caption_' . $taxonomy->id ?>"
                                                       name="<?php echo 'atkp_tax_caption_' . $taxonomy->id ?>"
                                                       value="<?php echo esc_attr( $taxonomy->caption ); ?>"></td>
                                            <td><input type="text" id="<?php echo 'atkp_tax_plural_' . $taxonomy->id ?>"
                                                       name="<?php echo 'atkp_tax_plural_' . $taxonomy->id ?>"
                                                       value="<?php echo esc_attr( $taxonomy->captionplural ); ?>"></td>

                                            <td><input type="text" id="<?php echo 'atkp_tax_name_' . $taxonomy->id ?>"
                                                       name="<?php echo 'atkp_tax_name_' . $taxonomy->id ?>"
                                                       value="<?php echo esc_attr( $taxonomy->name ); ?>"></td>

                                            <td>
                                                <input type="button" id="removetaxonomy-button"
                                                       class="button remove-taxonomy"
                                                       title="<?php _e( 'Delete taxonomy', ATKP_PLUGIN_PREFIX ) ?>"
                                                       value="<?php _e( 'Delete taxonomy', ATKP_PLUGIN_PREFIX ) ?>"/>

                                            </td>

                                        </tr>

									<?php } ?>

                                </table>
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr valign="top">

                            <td colspan="2">
								<?php _e( 'Note: Subsequent renaming taxonomy is not supported. After changing the taxonomies re-saving the permalinks is necessary (Settings-> Permalinks-> Save Changes).', ATKP_PLUGIN_PREFIX ); ?>
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr valign="top">

                            <td>
								<?php submit_button( '', 'primary', 'savecustomfields', false ); ?>
                            </td>
                        </tr>
                    </table>
                </form>
                <style type="text/css">
                    .form-table td {
                        padding: 0;

                    }
                </style>

                <script type="text/javascript">

                    function Generator() {
                    };
                    Generator.prototype.rand = Math.floor(Math.random() * 26) + Date.now();

                    Generator.prototype.getId = function () {
                        return this.rand++;
                    };
                    var idGen = new Generator();
                    var txtcaption = '<?php  _e( 'Text', ATKP_PLUGIN_PREFIX ) ?>';
                    var multicaption = '<?php  _e( 'Multiline', ATKP_PLUGIN_PREFIX ) ?>';
                    var dropdowncaption = '<?php  _e( 'Dropdown', ATKP_PLUGIN_PREFIX ) ?>';
                    var yesnocaption = '<?php  _e( 'Yes/No', ATKP_PLUGIN_PREFIX ) ?>';
                    var htmlcaption = '<?php  _e( 'Html', ATKP_PLUGIN_PREFIX ) ?>';

                    var btncaption = '<?php  _e( 'Delete field', ATKP_PLUGIN_PREFIX ) ?>';
                    var btncaption2 = '<?php  _e( 'Delete taxonomy', ATKP_PLUGIN_PREFIX ) ?>';

                    var $j = jQuery.noConflict();
                    /*
					 * Attaches the add field to the input field
					 */
                    $j(document).ready(function ($) {

                        // Runs when the image button is clicked.
                        $j('#addfield-button').click(function (e) {
                            var $id = idGen.getId();

                            $('#fields tr:last').after('<tr><td> <input type="text" id="atkp_caption_' + $id + '" name="atkp_caption_' + $id + '" value=""> </td><td><input type="text" id="atkp_name_' + $id + '" name="atkp_name_' + $id + '" value=""> </td><td> <select id="atkp_type_' + $id + '" name="atkp_type_' + $id + '"><option value="1">' + txtcaption + '</option><option value="2">' + multicaption + '</option><option value="3">' + dropdowncaption + '</option><option value="4">' + yesnocaption + '</option><option value="5">' + htmlcaption + '</option></select></td><td> <input type="text" id="atkp_format_' + $id + '" name="atkp_format_' + $id + '" value=""> </td><td><input type="button" id="removefield-button_' + $id + '" class="button remove-field" title="' + btncaption + '" value="' + btncaption + '" /></td></tr>');

                            $j('#removefield-button_' + $id).click(function (e) {

                                if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                    $(this).parent().parent().remove();
                                }

                            });
                        });

                        $j('.remove-field').click(function (e) {

                            if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                $(this).parent().parent().remove();
                            }
                        });


                        $j('#addtaxonomy-button').click(function (e) {
                            var $id = idGen.getId();

                            $('#taxonomies tr:last').after('<tr><td> <input type="text" id="atkp_tax_caption_' + $id + '" name="atkp_tax_caption_' + $id + '" value=""> </td><td> <input type="text" id="atkp_tax_plural_' + $id + '" name="atkp_tax_plural_' + $id + '" value=""> </td><td><input type="text" id="atkp_tax_name_' + $id + '" name="atkp_tax_name_' + $id + '" value=""> </td><td><input type="button" id="removetaxonomy-button_' + $id + '" class="button remove-taxonomy" title="' + btncaption2 + '" value="' + btncaption2 + '" /></td></tr>');

                            $j('#removetaxonomy-button_' + $id).click(function (e) {

                                if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                    $(this).parent().parent().remove();
                                }

                            });
                        });

                        $j('.remove-taxonomy').click(function (e) {

                            if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                                $(this).parent().parent().remove();
                            }
                        });


                    });
                </script>
            </div>
        </div> <?php
	}
}

?>