<?php
/**
 * DO NOT EDIT THIS FILE!
 *
 * This file was automatically generated from external sources.
 *
 * Any manual change here will be lost the next time the SDK
 * is updated. You've been warned!
 */

namespace DTS\eBaySDK\Fulfillment\Services;

class FulfillmentService extends \DTS\eBaySDK\Fulfillment\Services\FulfillmentBaseService {
	const API_VERSION = 'v1';

	/**
	 * @property array $operations Associative array of operations provided by the service.
	 */
	protected static $operations = [
		'GetOrders'                  => [
			'method'        => 'GET',
			'resource'      => 'order',
			'responseClass' => '\DTS\eBaySDK\Fulfillment\Types\GetOrdersRestResponse',
			'params'        => [
				'filter'   => [
					'valid' => [ 'string' ]
				],
				'limit'    => [
					'valid' => [ 'string' ]
				],
				'offset'   => [
					'valid' => [ 'string' ]
				],
				'orderIds' => [
					'valid' => [ 'string' ]
				]
			]
		],
		'GetAnOrder'                 => [
			'method'        => 'GET',
			'resource'      => 'order/{orderId}',
			'responseClass' => '\DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestResponse',
			'params'        => [
				'orderId' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CreateAShippingFulfillment' => [
			'method'        => 'POST',
			'resource'      => 'order/{orderId}/shipping_fulfillment',
			'responseClass' => '\DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestResponse',
			'params'        => [
				'orderId' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetShippingFulfillments'    => [
			'method'        => 'GET',
			'resource'      => 'order/{orderId}/shipping_fulfillment',
			'responseClass' => '\DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestResponse',
			'params'        => [
				'orderId' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetAShippingFulfillment'    => [
			'method'        => 'GET',
			'resource'      => 'order/{orderId}/shipping_fulfillment/{fulfillmentId}',
			'responseClass' => '\DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestResponse',
			'params'        => [
				'fulfillmentId' => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'orderId'       => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		]
	];

	/**
	 * @param array $config Configuration option values.
	 */
	public function __construct( array $config = [] ) {
		parent::__construct( $config );
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetOrdersRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Fulfillment\Types\GetOrdersRestResponse
	 */
	public function getOrders( \DTS\eBaySDK\Fulfillment\Types\GetOrdersRestRequest $request ) {
		return $this->getOrdersAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetOrdersRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getOrdersAsync( \DTS\eBaySDK\Fulfillment\Types\GetOrdersRestRequest $request ) {
		return $this->callOperationAsync( 'GetOrders', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestResponse
	 */
	public function getAnOrder( \DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestRequest $request ) {
		return $this->getAnOrderAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAnOrderAsync( \DTS\eBaySDK\Fulfillment\Types\GetAnOrderRestRequest $request ) {
		return $this->callOperationAsync( 'GetAnOrder', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestResponse
	 */
	public function createAShippingFulfillment( \DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestRequest $request ) {
		return $this->createAShippingFulfillmentAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function createAShippingFulfillmentAsync( \DTS\eBaySDK\Fulfillment\Types\CreateAShippingFulfillmentRestRequest $request ) {
		return $this->callOperationAsync( 'CreateAShippingFulfillment', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestResponse
	 */
	public function getShippingFulfillments( \DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestRequest $request ) {
		return $this->getShippingFulfillmentsAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getShippingFulfillmentsAsync( \DTS\eBaySDK\Fulfillment\Types\GetShippingFulfillmentsRestRequest $request ) {
		return $this->callOperationAsync( 'GetShippingFulfillments', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestResponse
	 */
	public function getAShippingFulfillment( \DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestRequest $request ) {
		return $this->getAShippingFulfillmentAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAShippingFulfillmentAsync( \DTS\eBaySDK\Fulfillment\Types\GetAShippingFulfillmentRestRequest $request ) {
		return $this->callOperationAsync( 'GetAShippingFulfillment', $request );
	}
}
