<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shortener {

	public function shorten_url( $apikey, $apilogin, $shortenerId, $url ) {
		if ( $apikey != '' )
			switch ( $shortenerId ) {
				case 3:

					require_once ATKP_PLUGIN_DIR . '/lib/bitlyhelper.php';

					$bitlyhelper = new bitlyhelper();

					$params                 = array();
					$params['access_token'] = $apikey;
					$params['longUrl']      = $url;
					$results                = $bitlyhelper->bitly_get( 'shorten', $params );

					if ( isset( $results['status_code'] ) && (int) $results['status_code'] == 200 ) {

						$url = $results['data']['url'];
					}

					unset( $bitlyhelper );

					break;
				case 4:
					//google
					require_once ATKP_PLUGIN_DIR . '/lib/Googlhelper.php';

					$googl = new Googlhelper( $apikey );

					// Shorten URL
					$shorturl = (string) $googl->shorten( $url );

					if ( $shorturl != '' ) {
						$url = $shorturl;
					}

					unset( $googl );


					break;
			}

		return $url;
	}

}


?>