<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 12.07.2018
 * Time: 19:59
 */

class atkp_floatingbar {
	private $show_floatingbar_productpage;
	private $show_floatingbar_mainproduct;
	private $show_floatingbar_woocommerce;
	private $floatingbar_template;

	public function __construct( $pluginbase ) {

		$this->show_floatingbar_productpage = (bool) atkp_options::$loader->get_show_floatingbar_productpage();
		$this->show_floatingbar_mainproduct = (bool) atkp_options::$loader->get_show_floatingbar_mainproduct();
		$this->show_floatingbar_woocommerce = (bool) atkp_options::$loader->get_show_floatingbar_woocommerce();

		$this->floatingbar_template = atkp_options::$loader->get_floatingbar_template();

		$post_types = array();
		$post_types = apply_filters( 'atkp_floatingbar_posttypes', $post_types );

		if ( $this->show_floatingbar_productpage || $this->show_floatingbar_mainproduct || $this->show_floatingbar_woocommerce || count( $post_types ) > 0 ) {
			if ( ! is_admin() ) {
				add_action( 'wp_footer', array( &$this, 'atkp_floating_bar' ) );
			}


		}
	}


	function atkp_floating_bar() {
		try {
			echo '<!-- Start of floating bar output -->';
			if ( ! ( is_single() || is_page() ) ) {
				return;
			}

			$post = get_post();
			if ( $post ) {
				$typenow = $post->post_type;
			} else {
				$typenow = '';
			}

			$post_types = array();
			$post_types = apply_filters( 'atkp_floatingbar_posttypes', $post_types );

			if ( $this->show_floatingbar_mainproduct ) {
				array_push( $post_types, 'post' );
				array_push( $post_types, 'page' );
			}
			if ( $this->show_floatingbar_productpage ) {
				array_push( $post_types, ATKP_PRODUCT_POSTTYPE );
			}
			if ( $this->show_floatingbar_woocommerce ) {
				array_push( $post_types, 'product' );
			}

			if ( ! in_array( $typenow, $post_types ) ) {
				return;
			}

			$productid = get_the_ID();;

			if ( get_post_type() == 'product' ) {
				$queried_object = get_queried_object();

				if ( $queried_object ) {

					$post_id    = $queried_object->ID;
					$productid2 = atkp_product::get_product_from_woo( $post_id );

					if ( $productid2 != null ) {
						$productid = $productid2;

					}
				}

			} else if ( $typenow != ATKP_PRODUCT_POSTTYPE ) {
				$queried_object = get_queried_object();

				if ( $queried_object ) {
					$post_id   = $queried_object->ID;
					$productid = ATKPTools::get_post_setting( $post_id, ATKP_PLUGIN_PREFIX . '_product' );
				}
			}

			$template = $this->floatingbar_template;

			if ( $template == '' ) {
				$template = 'floatingpanel';
			}

			$template    = apply_filters( 'atkp_floatingbar_template', $template );
			$productid   = apply_filters( 'atkp_floatingbar_product', $productid );
			$productlist = apply_filters( 'atkp_floatingbar_list', null );

			if ( $productid == '' && ( ! isset( $productlist ) || $productlist == null ) ) {
				return;
			}

			$output = new atkp_output();
			$html   = '';
			try {
				if ( isset( $productlist ) && count( $productlist ) > 0 ) {
					$html = $output->get_list_output2( $productlist, '', $template, '', 'notset', '', '', true, '', '', '', 3, 1, 0 );

				} else {
					$html = $output->get_product_output( $productid, $template, '', 'notset', '', false, '', '', true );
				}
			} catch ( Exception $e ) {
				$html = 'Exception: ' . $e->getMessage();
			}


			?>

            <div class="atkp-floating-bar">
                <div class="inner"><?php echo $html; ?></div>
            </div>

			<?php
		} finally {
			echo '<!-- End of floating bar output -->';
		}
	}

}