<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shortcodes_asa2 {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		$isactive = get_option( ATKP_PLUGIN_PREFIX . '_asa2_activate', 0 );

		if ( $isactive ) {
			add_shortcode( 'asa2', array( &$this, 'shortcode_product' ) );
			add_shortcode( 'asa2_textlink', array( &$this, 'shortcode_productlink' ) );
			add_shortcode( 'asa2_collection', array( &$this, 'shortcode_list' ) );
		}
	}

	function shortcode_productlink( $atts, $content = null, $code = "" ) {
		try {
			$tracking_id = '';
			$asin        = '';

			//[asa2_textlink asin="B00CMV3NWC" country_code="DE"]Amazon page[/asa2_textlink]

			$a = shortcode_atts( array(
				'asin'        => '',
				'tracking_id' => '',
				'disabled'    => 0,
			), $atts );

			if ( isset( $a['asin'] ) && ! empty( $a['asin'] ) ) {
				$asin = $a['asin'];
			}
			if ( isset( $a['tracking_id'] ) && ! empty( $a['tracking_id'] ) ) {
				$tracking_id = $a['tracking_id'];
			}

			if ( isset( $a['disabled'] ) && intval( $a['disabled'] ) == 1 ) {
				return '';
			}


			$prd = atkp_product::loadbyasin( $asin );

			if ( $prd == null ) {
				return 'product not found: ' . $asin;
			}


			$output = new atkp_output();

			return $output->get_product_output( $prd->productid, '', $content, 'notset', '', true, '', '', false, $tracking_id );

		} catch ( Exception $e ) {
			if ( ATKPSettings::$hideerrormessages ) {
				return '';
			} else {
				return 'Exception: ' . $e->getMessage();
			}
		}
	}

	function shortcode_product( $atts, $content = null, $code = "" ) {
		try {
			$template = '';//sidebar_item

			$asin = trim( $content );

			$containercss = '';
			$comment      = '';
			$tracking_id  = '';
			$template     = '';

			//[asa2 tplid="1" align="center"]B004GNFCK0[/asa2]

			$a = shortcode_atts( array(
				'align'          => '',
				'tpl'            => '',
				'tplid'          => '',
				'my_custom_text' => '',
				'tracking_id'    => '',
				'disabled'       => 0,
			), $atts );

			if ( isset( $a['disabled'] ) && intval( $a['disabled'] ) == 1 ) {
				return '';
			}

			if ( isset( $a['tracking_id'] ) && ! empty( $a['tracking_id'] ) ) {
				$tracking_id = $a['tracking_id'];
			}

			if ( isset( $a['align'] ) && ! empty( $a['align'] ) ) {
				$containercss = 'atkp-' . $a['align'];
			}

			if ( isset( $a['tpl'] ) && ! empty( $a['tpl'] ) ) {
				$template = $a['tpl'];
			} else if ( isset( $a['tplid'] ) && ! empty( $a['tplid'] ) ) {
				$template = $a['tplid'];
			}

			if ( isset( $a['my_custom_text'] ) && ! empty( $a['my_custom_text'] ) ) {
				$comment = $a['my_custom_text'];
			}

			$template = $this->modifyasatemplate( $template );


			$prd = atkp_product::loadbyasin( $asin );

			if ( $prd == null ) {
				return 'product not found: ' . $asin;
			}


			$output = new atkp_output();

			return $output->get_product_output( $prd->productid, $template, $comment, 'notset', '', false, '', $containercss, false, $tracking_id );

		} catch ( Exception $e ) {
			if ( ATKPSettings::$hideerrormessages ) {
				return '';
			} else {
				return 'Exception: ' . $e->getMessage();
			}
		}
	}

	function modifyasatemplate( $template ) {
		$found = false;

		for ( $i = 1; $i <= 5; $i ++ ) {
			$asatemplate     = get_option( ATKP_PLUGIN_PREFIX . '_asa2_templatename' . $i );
			$toolkittemplate = get_option( ATKP_PLUGIN_PREFIX . '_asa2_templateid' . $i );

			if ( $template == $asatemplate ) {
				$template = $toolkittemplate;
				$found    = true;
				break;
			}
		}

		//wenn das template numerisch ist, dann versucht er es aus den eigenen vorlagne zu laden und zeigt ggf. nichts an
		if ( ! $found && is_numeric( $template ) ) {
			$template = '';
		}

		return $template;
	}

	function shortcode_list( $atts, $content = null, $code = "" ) {
		try {
			$template    = '';//sidebar_item
			$itemsCount  = 10;
			$type        = '';
			$randomsort  = false;
			$comment     = '';
			$tracking_id = '';

			$a = shortcode_atts( array(
				'orderby'        => '',
				'tpl'            => '',
				'tplid'          => '',
				'my_custom_text' => '',
				'tracking_id'    => '',
				'disabled'       => 0,
			), $atts );

			if ( isset( $a['disabled'] ) && intval( $a['disabled'] ) == 1 ) {
				return '';
			}

			if ( isset( $a['tracking_id'] ) && ! empty( $a['tracking_id'] ) ) {
				$tracking_id = $a['tracking_id'];
			}

			if ( isset( $a['tpl'] ) && ! empty( $a['tpl'] ) ) {
				$template = $a['tpl'];
			} else if ( isset( $a['tplid'] ) && ! empty( $a['tplid'] ) ) {
				$template = $a['tplid'];
			}

			if ( isset( $a['limit'] ) && ! empty( $a['limit'] ) ) {
				$itemsCount = intval( $a['limit'] );
			}

			if ( isset( $a['orderby'] ) && ! empty( $a['orderby'] ) ) {
				$randomsort = $a['orderby'] == 'rand';
			}

			if ( isset( $a['my_custom_text'] ) && ! empty( $a['my_custom_text'] ) ) {
				$comment = $a['my_custom_text'];
			}

			$template = $this->modifyasatemplate( $template );


			$list = atkp_list::loadbyname( 'ASA2:' . trim( $content ) );

			if ( $list == null ) {
				return 'list not found: ' . $content;
			}


			$output = new atkp_output();

			return $output->get_list_output( $list->listid, $template, $comment, 'notset', '', '', $itemsCount, $randomsort, false, $tracking_id );

		} catch ( Exception $e ) {
			if ( ATKPSettings::$hideerrormessages ) {
				return '';
			} else {
				return 'Exception: ' . $e->getMessage();
			}
		}
	}

	private function parseParams( $atts ) {
		$params_text = '';

		if ( $atts != null ) {
			foreach ( $atts as $att => $value ) {
				if ( $att == '' || is_numeric( $att ) ) {
					$params_text .= ' ' . $value;
				} else {
					$params_text .= ',' . $att . '=' . $value;
				}
			}

			$params_text = str_replace( ',,', ',', $params_text );

			$parse_params = array();
		}

		$params = array();
		$params = explode( ',', $params_text );
		$params = array_map( 'trim', $params );

		return $params;
	}


}


?>