<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_template {
	public $data = array();

	function __construct() {
		$this->title              = '';
		$this->template_type      = '';
		$this->header             = '';
		$this->body               = '';
		$this->footer             = '';
		$this->disableddisclaimer = 0;
		$this->extendedview       = 0;
		$this->bodyheader         = '';
		$this->bodyfooter         = '';

		$this->detailheader = '';
		$this->detailfooter = '';

		$this->comparevalues = array();

		$this->css = '';

	}

	public static function get_directories( $add_systemdir = true ) {
		$views = array();
		array_push( $views, get_stylesheet_directory() . '/atkp-templates' );
		array_push( $views, get_template_directory() . '/atkp-templates' );
		if ( $add_systemdir ) {
			array_push( $views, ATKP_TEMPLATEDIR );
		}

		$views = apply_filters( 'atkp_template_directories', $views );

		$filtered = array();
		foreach ( $views as $view ) {
			if ( is_dir( $view ) ) {
				array_push( $filtered, $view );
			}
		}

		return $filtered;
	}

	public static function get_blade_directories( $add_systemdir = true ) {
		$views = array();
		array_push( $views, get_stylesheet_directory() . '/atkp-templates/blade' );
		array_push( $views, get_template_directory() . '/atkp-templates/blade' );
		if ( $add_systemdir ) {
			array_push( $views, ATKP_TEMPLATEDIR . '/blade' );
		}

		$views = apply_filters( 'atkp_blade_directories', $views );

		$filtered = array();
		foreach ( $views as $view ) {
			if ( is_dir( $view ) ) {
				array_push( $filtered, $view );
			}
		}

		return $filtered;
	}

	public static function get_list( $add_systemdir = true, $is_searchform = false ) {
		$templates = array();

		if ( $is_searchform ) {
			$templates['compareproduct'] = __( 'compare product', ATKP_PLUGIN_PREFIX );
			$templates['searchtext']     = __( 'search text', ATKP_PLUGIN_PREFIX );
			$templates['comparebox']     = __( 'Compare box', ATKP_PLUGIN_PREFIX );

		} else {

			$templates['moreoffers']  = __( 'Additional offers', ATKP_PLUGIN_PREFIX );
			$templates['moreoffers2'] = __( 'Additional offers 2', ATKP_PLUGIN_PREFIX );


			$templates['bestseller']       = __( 'bestseller', ATKP_PLUGIN_PREFIX );
			$templates['wide']             = __( 'productbox wide (description)', ATKP_PLUGIN_PREFIX );
			$templates['secondwide']       = __( 'productbox wide', ATKP_PLUGIN_PREFIX );
			$templates['box']              = __( 'productbox narrow', ATKP_PLUGIN_PREFIX );
			$templates['detailoffers']     = __( 'price compare', ATKP_PLUGIN_PREFIX );
			$templates['grid_2_columns']   = __( 'Grid with 2 columns', ATKP_PLUGIN_PREFIX );
			$templates['grid_3_columns']   = __( 'Grid with 3 columns', ATKP_PLUGIN_PREFIX );
			$templates['image_gallery']    = __( 'Image Gallery', ATKP_PLUGIN_PREFIX );
			$templates['image_slider']     = __( 'Image Slider', ATKP_PLUGIN_PREFIX );
			$templates['image_autoslider'] = __( 'Image Autoslider', ATKP_PLUGIN_PREFIX );
			$templates['comparetable']     = __( 'Compare table (automatic)', ATKP_PLUGIN_PREFIX );
			$templates['detaillist']       = __( 'Detail list (automatic)', ATKP_PLUGIN_PREFIX );
			$templates['datasheet']        = __( 'Data sheet (automatic)', ATKP_PLUGIN_PREFIX );

			$templates['carousel']   = __( 'Product carousel', ATKP_PLUGIN_PREFIX );
			$templates['productbox'] = __( 'Productbox (variations)', ATKP_PLUGIN_PREFIX );

			$templates['pricehistory_lastxdays'] = __( 'Pricehistory last 30 days', ATKP_PLUGIN_PREFIX );
			$templates['pricehistory_month']     = __( 'Pricehistory monthly', ATKP_PLUGIN_PREFIX );
		}


		if ( ATKP_PLUGIN_VERSION >= 30 ) {
			global $post;
			$args        = array(
				'post_type'      => ATKP_TEMPLATE_POSTTYPE,
				'posts_per_page' => 300,
				'post_status'    => array( 'publish', 'draft' )
			);
			$posts_array = get_posts( $args );
			foreach ( $posts_array as $prd ) {
				$type = ATKPTools::get_post_setting( $prd->ID, ATKP_TEMPLATE_POSTTYPE . '_template_type' );

				if ( $is_searchform ) {
					if ( $type == 5 ) {
						$templates[ $prd->ID . '' ] = $prd->post_title;
					}
				} else {
					if ( $type != 5 ) {
						$templates[ $prd->ID . '' ] = $prd->post_title;
					}
				}
			};
		}

		$templatedirs = atkp_template::get_directories( $add_systemdir );

		foreach ( $templatedirs as $dir ) {

			$files = scandir( $dir );
			foreach ( $files as $file ) {
				if ( $file == '.' || $file == '..' ) {
					continue;
				}

				$path_parts = pathinfo( $file );
				$tempname   = $path_parts['filename'];


				if ( ! isset( $templates[ $tempname ] ) ) {
					$templates[ $tempname ] = $tempname . __( ' (filesystem)', ATKP_PLUGIN_PREFIX );
				}
			}

		}

		$bladedirs = atkp_template::get_blade_directories( $add_systemdir );

		foreach ( $bladedirs as $dir ) {

			$files = scandir( $dir );
			foreach ( $files as $file ) {
				if ( $file == '.' || $file == '..' ) {
					continue;
				}

				$path_parts = pathinfo( $file );
				$tempname   = str_replace( '.blade', '', $path_parts['filename'] );

				if ( ! isset( $templates[ $tempname ] ) ) {
					$templates[ $tempname ] = $tempname . __( ' (filesystem)', ATKP_PLUGIN_PREFIX );
				}
			}

		}

		asort( $templates );

		return $templates;
	}

	public static function load( $post_id ) {


		$product = get_post( $post_id );

		if ( ! isset( $product ) || $product == null ) {
			throw new Exception( 'template not found: ' . $post_id );
		}
		if ( $product->post_type != ATKP_TEMPLATE_POSTTYPE ) {
			throw new Exception( 'invalid post_type: ' . $product->post_type . ', $post_id: ' . $post_id );
		}

		$prd = new atkp_template();

		$prd->title              = $product->post_title;
		$prd->template_type      = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_template_type' );
		$prd->header             = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_header' );
		$prd->body               = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body' );
		$prd->footer             = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_footer' );
		$prd->disableddisclaimer = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer' );
		$prd->extendedview       = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_extendedview' );
		$prd->bodyheader         = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_header' );
		$prd->bodyfooter         = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_footer' );

		$prd->detailheader = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_header' );
		$prd->detailfooter = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_footer' );

		$prd->css = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_css' );

		$prd->comparevalues = atkp_template_comparevalue::load_comparevalues( $post_id );

		$prd->horizontalscrollbars = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' );
		$prd->hideheaders          = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_hideheaders' );
		$prd->maxmobileproducts    = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts' );
		$prd->maxproducts          = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxproducts' );
		$prd->viewtype             = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_viewtype' );
		$prd->mobilebody           = ATKPTools::get_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_mobilebody' );


		return $prd;
	}

	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}
}


?>