@if(count($products) == 1)
    @include('secondwide',['formatter' => $formatter, 'translator' => $translator, 'products' => $products])
@else
    <div class="atkp-container {{$parameters->cssContainerClass}}">

        <div class="atkp-clearfix atkp-box-2-cols {{$parameters->cssElementClass}}">
            @foreach ($products as $product)
                <div class="atkp-box atkp-smallbox atkp-box-2-cols-item atkp-clearfix ">
                    <div class="atkp-thumb">
                        @if(atkp_options::$loader->get_linkimage() )
                            <a {!! $formatter->get_title_link($product) !!}><img class="atkp-image"
                                                                                 src="{{$formatter->get_mediumnimageurl($product)}}"
                                                                                 alt="{{$formatter->get_title($product)}}"/></a>
                        @else
                            <img class="atkp-image" src="{{$formatter->get_mediumnimageurl($product)}}"
                                 alt="{{$formatter->get_title($product)}}"/>
                        @endif
                    </div>
                    <div class="atkp-content">
                        <a class="atkp-title" {!! $formatter->get_title_link($product) !!}>{{$formatter->get_shorttitle($product)}}{!! $formatter->get_title_mark($product) !!}</a>
                        <div class="atkp-author">{{$formatter->get_bytext($product)}}</div>
                    </div>
                    <div class="atkp-bottom">
                        <div class="atkp-ratingbar">
                            @if(atkp_options::$loader->get_showstarrating() && (!atkp_options::$loader->get_hideemptystars() || $product->reviewcount > 0))
                                <div class="atkp-rating">{!!$formatter->get_star_rating($product)!!}</div>
                            @endif
                            <div class="atkp-primelogo">{!! $formatter->get_primelogo($product) !!}</div>
                            <div class="atkp-clearfix"></div>
                        </div>
                        <span class="atkp-price atkp-saleprice">{{$formatter->get_pricetext($product, $translator->get_price(), $translator->get_pricenotavailable())}}</span>
                        <a {!! $formatter->get_button_link($product) !!} class="atkp-button">{!! $formatter->get_button_text($product)!!}{!! $formatter->get_button_mark($product) !!}</a>


                        <span class="atkp-priceinfo">{{$formatter->get_priceinfotext($product)}}</span>
                        <div class="atkp-shoplogo">{!! $formatter->get_shop_logo($product->shop) !!}</div>
                    </div>
                </div>
            @endforeach
        </div>
        @if(count($products) > 0 && atkp_options::$loader->get_show_disclaimer() && !$parameters->hidedisclaimer)
            <span class="atkp-disclaimer">{!! $formatter->get_disclaimer($products[0]) !!}</span>
        @endif
    </div>
@endif