<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_zanox extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_caption() {
		return __( 'Zanox API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	public function get_maxproductcount() {
		return 100;
	}

	private $apikey = '';

	public function check_configuration( $post_id ) {
		try {
			$apikey       = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$enable_ssl   = true; // ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

			$message = '';
			if ( $apikey != '' && $apisecretkey != '' ) {

				if ( ! class_exists( 'ApiClient' ) ) {
					require_once ATKP_PLUGIN_DIR . '/lib/zanox/ApiClient.php';
				}

				$api = ApiClient::factory( PROTOCOL_JSON, VERSION_DEFAULT );

				$api->setConnectId( $apikey );
				$api->setSecretKey( $apisecretkey );

				$this->apikey = $apikey;

				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );


				$subshops = array();

				$pagination = 0;
				$pageItems  = 10;

				while ( true ) {
					$result = json_decode( $api->GetProgramApplications( null, null, 'confirmed', $pagination, $pageItems ), true );

					if ( ATKPLog::$logenabled ) {
						ATKPLog::LogDebug( '*** check_configuration zanox ***' );
						ATKPLog::LogDebug( serialize( $result ) );
						ATKPLog::LogDebug( '*** check_configuration zanox ***' );
					}


					$counter = 0;

					if ( isset( $result['programApplicationItems']['programApplicationItem'] ) && count( $result['programApplicationItems']['programApplicationItem'] ) > 0 ) {
						foreach ( $result['programApplicationItems']['programApplicationItem'] as $shop ) {

							//if($shop['program']['@active'] != 'true') {
							//   continue;
							//}


							$subshop            = new subshop();
							$subshop->title     = $shop['program']['$'];
							$subshop->title2    = $shop['adspace']['$'] . ', ' . ( $shop['program']['@active'] == 'true' ? __( 'active', ATKP_PLUGIN_PREFIX ) : __( 'inactive', ATKP_PLUGIN_PREFIX ) );
							$subshop->shopid    = $shop['adspace']['@id'] . '_' . $shop['program']['@id'];
							$subshop->programid = $shop['program']['@id'];

							$result2 = json_decode( $api->GetProgram( $subshop->programid ), true );

							if ( isset( $result2['programItem'] ) ) {
								$subshop->logourl      = $this->checkimageurl( $result2['programItem'][0]['image'], $enable_ssl );
								$subshop->smalllogourl = $this->checkimageurl( $result2['programItem'][0]['image'], $enable_ssl );
							}

							array_push( $subshops, $subshop );
							$counter ++;
						}
					}


					if ( $counter < $pageItems ) {
						break;
					}

					$pagination ++;

				}

				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );


			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_zanox_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_zanox_access_secret_key', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_zanox_enable_ssl', 'bool' ) );

		//  $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		// if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'zanox');

		//echo serialize($subshops);exit;

		// ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = '';
		$enablessl    = false;


		if ( $webservice == '3' ) {
			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$enablessl = true; // ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		}
		?>
		<tr valign="top">
			<th scope="row">
				<label for="">
					<?php _e( 'Connect ID', ATKP_PLUGIN_PREFIX ) ?>:
				</label>
			</th>
			<td>
				<input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_access_key' ?>"
				       name="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_access_key' ?>" value="<?php echo $apikey; ?>">
				<label for="">
				</label>
			</td>
		</tr>
		<tr valign="top">
			<th scope="row">
				<label for="">
					<?php _e( 'Secret Key', ATKP_PLUGIN_PREFIX ) ?>:
				</label>
			</th>
			<td>
				<input style="width:40%" type="password"
				       id="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_access_secret_key' ?>"
				       name="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_access_secret_key' ?>"
				       value="<?php echo $apisecretkey; ?>">
			</td>
		</tr>
<!--
		<tr valign="top">
			<th scope="row">

			</th>
			<td>
				<input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_enable_ssl' ?>"
				       name="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_enable_ssl' ?>"
				       value="1" <?php echo checked( 1, $enablessl, true ); ?>>
				<label for="<?php echo ATKP_SHOP_POSTTYPE . '_zanox_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
				</label>
			</td>
		</tr>
->
		<!--<tr valign="top">
                            <th scope="row">

                            </th>
                            <td>
                            <?php


		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'zanox');
		?>

                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;


					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $helper = null;
	private $shopid = null;
	private $programid = null;
	private $adspaceId = null;
	private $enable_ssl = false;

	public function checklogon( $shop ) {
		if ( ! class_exists( 'ApiClient' ) ) {
			require_once ATKP_PLUGIN_DIR . '/lib/zanox/ApiClient.php';
		}

		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$apisecretkey     = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$this->enable_ssl = true; //ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

		if ( $apikey == '' || $apisecretkey == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$this->helper = ApiClient::factory( PROTOCOL_JSON, VERSION_DEFAULT );

		$this->apikey = $apikey;

		$this->helper->setConnectId( $apikey );
		$this->helper->setSecretKey( $apisecretkey );
		$this->shopid = $shop->id;

		$shopids = explode( '_', $shop->shopid );

		$this->programid = $shopids[1];
		$this->adspaceid = $shopids[0];
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$products = new atkp_search_resp();
		$maxCount = 10;

		$pagination --;

        switch ( $searchType ) {
            case 'asin':
                $results = json_decode( $this->helper->getProduct( $keyword, $this->adspaceid ), true );

                break;
            case 'ean':
                $query = 'http://api.zanox.com/json/2011-03-01/products?connectid=' . $this->apikey . '&programs=' . $this->programid . '&ean=' . $keyword;

                $result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

                if ( is_wp_error( $result1 ) ) {
                    //TODO: fehler
                } else {
                    $results = json_decode( $result1['body'], true );
                }
                break;
            default:
                /**
                 * done
                 *
                 * Search for products.
                 *
                 * @param      string $query search string
                 * @param      string $searchType search type (optional)
                 *                                         (contextual or phrase)
                 * @param      string $region limit search to region (optional)
                 * @param      int $categoryId limit search to categorys (optional)
                 * @param      array $programId limit search to program list of
                 *                                         programs (optional)
                 * @param      boolean $hasImages products with images (optional)
                 * @param      float $minPrice minimum price (optional)
                 * @param      float $maxPrice maximum price (optional)
                 * @param      int $adspaceId adspace id (optional)
                 * @param      int $page page of result set (optional)
                 * @param      int $items items per page (optional)
                 *
                 * @access     public
                 * @category   nosignature
                 *
                 * @return     object or string            list of products or false
                 */
                $results = json_decode( $this->helper->searchProducts( $keyword, 'contextual', null, null, array( $this->programid ), false, null, null, $this->adspaceid, $pagination, $maxCount ), true );

                break;
        }

        if ( isset( $results['productItems'] ) && is_array( $results['productItems'] ) ) {
            $resultlist = $results['productItems']['productItem'];
        } else if ( isset( $results['productItem'] ) ) {
            $resultlist = $results['productItem'];
        }

        if ( isset( $resultlist ) ) {
            foreach ( $resultlist as $result ) {
                $product = array();
                //info: je nach anbieter wird entweder small oder large zurückgeliefert?!

                if ( array_key_exists( 'small', $result['image'] ) ) {
                    $product['imageurl'] = $this->checkimageurl( $result['image']['small'] );
                } else {
                    $product['imageurl'] = $this->checkimageurl( $result['image']['large'] );
                }
                $product['asin']       = $result['@id'];
                $product['producturl'] = ATKPTools::check_sslurl( $result['trackingLinks']['trackingLink'][0]['ppc'] );
                $product['title']      = $result['name'];
                $product['ean']        = isset( $result['ean'] ) ? $result['ean'] : '';
                //$product['articlenumber'] = isset($result['merchantProductId']) ? $result['merchantProductId'] : '';

                $product['saleprice'] = $result['price'];
                if ( array_key_exists( 'descriptionLong', $result ) ) {
                    $product['description'] = strlen( $result['descriptionLong'] ) > 350 ? substr( $result['descriptionLong'], 0, 350 ) : $result['descriptionLong'];
                }

                if ( $result['@id'] != '' ) {
                    array_push( $products->products, $product );
                }

                if ( count( $products->products ) >= $maxCount ) {
                    break;
                }
            }
        }

		$products->pagecount = count($products->products) >= $maxCount ? $pagination+2 : $pagination+1;
		$products->currentpage = $pagination+1;
		$products->total = count($products->products);

		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
		}

//echo serialize($result);exit;

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$myproduct->features = $result['description'];
		if ( array_key_exists( 'descriptionLong', $result ) ) {
			$myproduct->description = $result['descriptionLong'];
		}
		$myproduct->title = $result['name'];;
		$myproduct->asin = $result['@id'];

		if ( array_key_exists( 'image', $result ) && $result['image'] != null ) {
			if ( array_key_exists( 'small', $result['image'] ) ) {
				$myproduct->smallimageurl = $this->checkimageurl( $result['image']['small'] );
			}
			if ( array_key_exists( 'medium', $result['image'] ) ) {
				$myproduct->mediumimageurl = $this->checkimageurl( $result['image']['medium'] );
			}
			if ( array_key_exists( 'large', $result['image'] ) ) {
				$myproduct->largeimageurl = $this->checkimageurl( $result['image']['large'] );
			}
		}

		$myproduct->producturl = ATKPTools::check_sslurl( $result['trackingLinks']['trackingLink'][0]['ppc'] );
		//$myproduct->addtocarturl = $result['trackingLinks']['trackingLink'][0]['ppv'];

		if ( array_key_exists( 'deliveryTime', $result ) ) {
			if ( is_numeric( $result['deliveryTime'] ) ) {
				$myproduct->availability = sprintf( __( 'Delivery in %s business days', ATKP_PLUGIN_PREFIX ), $result['deliveryTime'] );
			} else {
				$myproduct->availability = $result['deliveryTime'];
			}
		}

		$myproduct->saleprice      = $result['price'];
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		if ( array_key_exists( 'shippingCosts', $result ) ) {
			$myproduct->shipping      = $result['shippingCosts'];
			$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );
		}

		if ( array_key_exists( 'merchantCategory', $result ) ) {
			$myproduct->productgroup = $result['merchantCategory'];
		}
		if ( array_key_exists( 'ean', $result ) ) {
			$myproduct->ean = $result['ean'];
		}
		if ( array_key_exists( 'manufacturer', $result ) ) {
			$myproduct->manufacturer = $result['manufacturer'];
		}


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption' => __( 'All categories', ATKP_PLUGIN_PREFIX )
		);

		$query = 'http://api.zanox.com/json/2011-03-01/products/merchantcategories?connectid=' . $this->apikey . '&program=' . $this->programid;

		$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );
		$results = null;
		if ( is_wp_error( $result1 ) ) {
			//TODO: fehler
		} else {
			$results = json_decode( $result1['body'], true );

		}

		$cats = $results['categories'][0]['category'];


		foreach ( $cats as $result ) {

			$departments[ $result ] = array(
				'caption' => html_entity_decode( $result ),

			);
		}


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'MaximumPrice' => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'MinimumPrice' => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_product( $asin, $id_type = 'ASIN' ) {
		//info: asin entspricht der productid
		//EAN der ean

		switch ( $id_type ) {
			case 'ASIN':
				/**
				 * done
				 *
				 * Get a single product.
				 *
				 * @param      string $productId product id hash
				 * @param      int $adspaceId adspace id (optional)
				 *
				 * @access     public
				 * @category   nosignature
				 *
				 * @return     object or string            single product item or false
				 */
				$results = json_decode( $this->helper->getProduct( $asin, $this->adspaceid ), true );
				break;
			case 'EAN':
				$query = 'http://api.zanox.com/json/2011-03-01/products?connectid=' . $this->apikey . '&programs=' . $this->programid . '&ean=' . $asin;

				$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

				if ( is_wp_error( $result1 ) ) {
					//TODO: fehler
				} else {
					$results = json_decode( $result1['body'], true );
				}
				break;
			case 'TITLE':
				/**
				 * done
				 *
				 * Search for products.
				 *
				 * @param      string $query search string
				 * @param      string $searchType search type (optional)
				 *                                         (contextual or phrase)
				 * @param      string $region limit search to region (optional)
				 * @param      int $categoryId limit search to categorys (optional)
				 * @param      array $programId limit search to program list of
				 *                                         programs (optional)
				 * @param      boolean $hasImages products with images (optional)
				 * @param      float $minPrice minimum price (optional)
				 * @param      float $maxPrice maximum price (optional)
				 * @param      int $adspaceId adspace id (optional)
				 * @param      int $page page of result set (optional)
				 * @param      int $items items per page (optional)
				 *
				 * @access     public
				 * @category   nosignature
				 *
				 * @return     object or string            list of products or false
				 */
				$results = json_decode( $this->helper->searchProducts( $asin, 'phrase', null, null, array( $this->programid ), true, null, null, $this->adspaceid, 0, 2 ), true );

				break;
			default:
				throw new exception( 'unknown id_type:' . $id_type );
		}

		if ( isset( $results['productItems'] ) && is_array( $results['productItems'] ) ) {
			$resultlist = $results['productItems']['productItem'];
		} else if ( isset( $results['productItem'] ) ) {
			$resultlist = $results['productItem'];
		}

		if ( isset( $resultlist ) ) {
			foreach ( $resultlist as $result2 ) {
				return $this->fill_product( $result2 );
			}
		}

		throw new Exception( 'product not found: ' . $asin );

	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {
			$resultlist = null;
			try {
				switch ( $id_type ) {
					case 'ASIN':
						/**
						 * done
						 *
						 * Get a single product.
						 *
						 * @param      string $productId product id hash
						 * @param      int $adspaceId adspace id (optional)
						 *
						 * @access     public
						 * @category   nosignature
						 *
						 * @return     object or string            single product item or false
						 */
						$results = json_decode( $this->helper->getProduct( $asin, $this->adspaceid ), true );
						break;
					case 'EAN':
						$query = 'http://api.zanox.com/json/2011-03-01/products?connectid=' . $this->apikey . '&programs=' . $this->programid . '&ean=' . $asin;

						$result1 = wp_remote_get( $query, array( 'timeout' => 30, 'httpversion' => '1.1' ) );

						if ( is_wp_error( $result1 ) ) {
							$titlecheck = $result1->get_error_message();
						} else {
							$results = json_decode( $result1['body'], true );
						}
						break;
					case 'TITLE':
						/**
						 * done
						 *
						 * Search for products.
						 *
						 * @param      string $query search string
						 * @param      string $searchType search type (optional)
						 *                                         (contextual or phrase)
						 * @param      string $region limit search to region (optional)
						 * @param      int $categoryId limit search to categorys (optional)
						 * @param      array $programId limit search to program list of
						 *                                         programs (optional)
						 * @param      boolean $hasImages products with images (optional)
						 * @param      float $minPrice minimum price (optional)
						 * @param      float $maxPrice maximum price (optional)
						 * @param      int $adspaceId adspace id (optional)
						 * @param      int $page page of result set (optional)
						 * @param      int $items items per page (optional)
						 *
						 * @access     public
						 * @category   nosignature
						 *
						 * @return     object or string            list of products or false
						 */
						$results = json_decode( $this->helper->searchProducts( $asin, 'phrase', null, null, array( $this->programid ), true, null, null, $this->adspaceid, 0, 2 ), true );

						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( GuzzleHttp\Exception\ClientException $e ) {
				$response = $e->getResponse();
				if ( isset( $response ) ) {
					$titlecheck = $response->getBody();
				} else {
					$titlecheck = $e->getMessage();
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			if ( isset( $results['productItems'] ) && is_array( $results['productItems'] ) ) {
				$resultlist = $results['productItems']['productItem'];
			} else if ( isset( $results['productItem'] ) ) {
				$resultlist = $results['productItem'];
			}

			$productfound = false;

			if ( empty( $titlecheck ) && isset( $resultlist ) ) {
				foreach ( $resultlist as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );
		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		//$shopids = explode('_',$this->shopid);

		$minPrice = null;
		$maxPrice = null;

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
				case 'MinimumPrice':
					$minPrice = floatval( $value );
					break;
				case 'MaximumPrice':
					$maxPrice = floatval( $value );
					break;
			}
		}


		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':
				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$entriesperpage = 20;
		$pagination     = 0;
		do {

			/**
			 * done
			 *
			 * Search for products.
			 *
			 * @param      string $query search string
			 * @param      string $searchType search type (optional)
			 *                                         (contextual or phrase)
			 * @param      string $region limit search to region (optional)
			 * @param      int $categoryId limit search to categorys (optional)
			 * @param      array $programId limit search to program list of
			 *                                         programs (optional)
			 * @param      boolean $hasImages products with images (optional)
			 * @param      float $minPrice minimum price (optional)
			 * @param      float $maxPrice maximum price (optional)
			 * @param      int $adspaceId adspace id (optional)
			 * @param      int $page page of result set (optional)
			 * @param      int $items items per page (optional)
			 *
			 * @access     public
			 * @category   nosignature
			 *
			 * @return     object or string            list of products or false
			 */
			$results = json_decode( $this->helper->searchProducts( $keyword, 'phrase', null, $nodeid, array( $this->programid ), true, $minPrice, $maxPrice, $this->adspaceid, $pagination, $entriesperpage ), true );

			//searchProducts ( $query, $searchType = 'phrase',
			//$region = NULL, $categoryId = NULL, $programs = array(),
			//$hasImages = true, $minPrice = 0, $maxPrice = NULL, $adspaceId = NULL,
			//$page = 0, $items = 10 )

			if ( is_array( $results['productItems'] ) ) {
				foreach ( $results['productItems']['productItem'] as $result ) {
					//array_push($mylist->asins, $result['@id']);

					array_push( $products, $this->fill_product( $result ) );

					if ( count( $products ) >= $maxCount ) {
						break;
					}
				}
			}

			$pagination ++; //increment

			if ( count( $products ) >= $maxCount ) {
				break;
			}

		} while ( ( $pagination * $entriesperpage ) <= $maxCount );

		$mylist->products = $products;

		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}