<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_affilinet extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_caption() {
		return __( 'Affili.net API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function get_maxproductcount() {
		return 100;
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	public function check_response( $response ) {
		$responseArray = $response->toArray();

		if ( isset( $responseArray['ErrorMessages'] ) && isset( $responseArray['ErrorMessages'][0] ) ) {
			$message = $responseArray['ErrorMessages'][0]['Key'] . ': ' . $responseArray['ErrorMessages'][0]['Value'];
			throw new Exception( $message );
		}

	}

	public function check_configuration( $post_id ) {
		try {
			$apikey       = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
			$enable_ssl   = true; // ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

			$message = '';
			if ( $apikey != '' && $apisecretkey != '' ) {

				require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

				$config = [
					'publisher_id'                => $apikey,
					'product_webservice_password' => $apisecretkey
				];

				$affilinet = new \Affilinet\ProductData\AffilinetClient( $config );

				$shopsRequest = new \Affilinet\ProductData\Requests\ShopsRequest( $affilinet );

				$shopsRequest->addShopLogoWithSize90px();

				$shopsRequest->page( 1 ); // show the second result page page (page parameter starts counting at 1)
				$shopsRequest->pageSize( 500 ); // 20 results per page

				$shopsResponse = $shopsRequest->send();

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration affilinet ***' );
					ATKPLog::LogDebug( serialize( $shopsResponse ) );
					ATKPLog::LogDebug( '*** check_configuration affilinet ***' );
				}

				$this->check_response( $shopsResponse );


				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

				$subshops = array();

				$shops = $shopsResponse->getShops();


				foreach ( $shops as $shop ) {


					$subshop        = new subshop();
					$subshop->title = $shop->getName();

					$subshop->title2 = sprintf( __( '%s products', ATKP_PLUGIN_PREFIX ), $shop->getProductCount() );

					$subshop->shopid    = $shop->getId();
					$subshop->programid = $shop->getProgramId();

					$subshop->logourl      = $this->checkimageurl( $shop->getLogo()->getUrl(), $enable_ssl );
					$subshop->smalllogourl = $this->checkimageurl( str_replace( '/90/', '/50/', $shop->getLogo()->getUrl() ), $enable_ssl );

					array_push( $subshops, $subshop );

				}


				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );

			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_aff_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_aff_access_secret_key', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_aff_enable_ssl', 'bool' ) );

		// $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		//if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'aff');

		//echo serialize($subshops);exit;

		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = '';
		$enablessl    = false;


		if ( $webservice == '2' ) {
			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$enablessl = true; // ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Publisher-ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'affilinet-api' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_aff_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_aff_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Webservice-Password', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="password"
                       id="<?php echo ATKP_SHOP_POSTTYPE . '_aff_access_secret_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_aff_access_secret_key' ?>"
                       value="<?php echo $apisecretkey; ?>">
            </td>
        </tr>
        <!--
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_aff_enable_ssl' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_aff_enable_ssl' ?>"
                       value="1" <?php echo checked( 1, $enablessl, true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_aff_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>

        <tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php
		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'aff');
		?>
                            
                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;

					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $helper = null;
	private $shopid = null;
	private $enable_ssl = false;

	private $aff_programId = null;
	private $aff_shopId = null;


	public function checklogon( $shop ) {
		require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$apisecretkey     = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$this->enable_ssl = true; // ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

		if ( $apikey == '' || $apisecretkey == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$config = [
			'publisher_id'                => $apikey,
			'product_webservice_password' => $apisecretkey
		];

		$this->helper = new \Affilinet\ProductData\AffilinetClient( $config );

		$this->shopid        = $shop->id;
		$this->aff_programId = $shop->programid;
		$this->aff_shopId    = $shop->shopid;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}


		$products = new atkp_search_resp();
		$maxCount = 10;

        $productsRequest = new \Affilinet\ProductData\Requests\ProductsRequest( $this->helper );
        $productsRequest->onlyFromShopIds( [ $this->aff_shopId ] );
        $productsRequest->addAllProductImages();

        switch ( $searchType ) {
            case 'articlenumber':
                $productsRequest->addFilterQuery( 'ArticleNumber', $keyword );
                $results = $productsRequest->send();
                break;
            case 'ean':

                $productsRequest->addFilterQuery( 'EAN', '0' . $keyword );

                $results = $productsRequest->send();

                break;
            case 'asin':
                $results = $productsRequest->find( [ $keyword ] );

                break;
            default:
                // perform a fulltext search
                $productsRequest->page( $pagination ); // show the second result page page (page parameter starts counting at 1)
                $productsRequest->pageSize( $maxCount ); // 20 results per page
                $productsRequest->addRawQuery( $keyword );

                // send the query and get the response
                $results = $productsRequest->send();

                break;
        }

        $this->check_response( $results );

        // get the array of Product objects
        $productResponses = $results->getProducts();

        $products->pagecount =$results->totalPages();
        $products->currentpage = $results->pageNumber();
        $products->total = $results->totalRecords();

        foreach ( $productResponses as $productResponse ) {
            $product = array();

            $product['asin']  = $productResponse->getProductId();
            $product['title'] = $productResponse->getProductName();

            $price = $productResponse->getPriceInformation();
            if ( isset( $price ) ) {

                $product['saleprice'] = $price->getPrice();
                $product['listprice'] = $price->getPriceOld();
            } else {
                $product['saleprice'] = '';
                $product['listprice'] = '';
            }

            $product['description'] = strlen( $productResponse->getDescription() ) > 350 ? substr( $productResponse->getDescription(), 0, 350 ) : $productResponse->getDescription();

            $product['producturl'] = ATKPTools::check_sslurl( $productResponse->getDeeplink() );

            $product['ean'] = $productResponse->getEAN() != '' ? substr( $productResponse->getEAN(), 1 ) : $productResponse->getEAN();


            $product['articlenumber'] = $productResponse->getArticleNumber();

            if ( is_array( $productResponse->getImages() ) ) {
                foreach ( $productResponse->getImages() as $image ) {
                    if ( $image->getScaleName() == 'Image60' ) {

                        $product['imageurl'] = $image->getUrl();
                        break;
                    }
                }
            }

            if ( $product['asin'] != '' ) {
                array_push( $products->products, $product );
            }

        }


		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {
		//var_dump($url);exit;
		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}


		//$url = str_replace('https://prdimg.affili.net/img/size/60/src/', 'https://', $url);
		//$url = str_replace('https://prdimg.affili.net/img/size/180/src/', 'https://', $url);
		//$url = str_replace('https://prdimg.affili.net/img/src/', 'https://', $url);

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product affilinet ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product affilinet ***' );
		}

		//$result = unserialize('O:56:"Affilinet\ProductData\Responses\ResponseElements\Product":28:{s:71:" Affilinet\ProductData\Responses\ResponseElements\Product articleNumber";s:17:"TOP101988-42980-0";s:72:" Affilinet\ProductData\Responses\ResponseElements\Product lastShopUpdate";O:8:"DateTime":3:{s:4:"date";s:26:"2018-01-22 00:23:06.007000";s:13:"timezone_type";i:1;s:8:"timezone";s:6:"+01:00";}s:75:" Affilinet\ProductData\Responses\ResponseElements\Product lastProductChange";O:8:"DateTime":3:{s:4:"date";s:26:"2018-01-13 00:22:45.000000";s:13:"timezone_type";i:1;s:8:"timezone";s:6:"+01:00";}s:63:" Affilinet\ProductData\Responses\ResponseElements\Product score";d:0;s:67:" Affilinet\ProductData\Responses\ResponseElements\Product productId";i:604257725;s:64:" Affilinet\ProductData\Responses\ResponseElements\Product shopId";i:193;s:67:" Affilinet\ProductData\Responses\ResponseElements\Product shopTitle";s:6:"Bike24";s:69:" Affilinet\ProductData\Responses\ResponseElements\Product productName";s:40:"Topeak Mini 20 Pro Miniwerkzeug - silber";s:69:" Affilinet\ProductData\Responses\ResponseElements\Product description";s:683:"bike 05/2015 - Testsieger! (Urteil: Sehr Gut!) tour 08/2013 - Note: 1,9! 20 Profitools aus gehärtetem Werkzeugstahl. Minimale 7,5g pro Funktion. Integrierter Cromoly-Stahl-Guss Kettennieter (separat abnehmbar). Die hochfest geschmiedete Metalllegierung des Körpers ist optimal für höchste Drehmomente geeignet. Funktionen: Innensechskant: 2-L/2,5/3(2x)/4/5/6/8/10mm Torx: T10/T25 Speichenschlüssel: 14g/15g/Mavic M7/Shimano kompatibel Kettennieter: Cromoly-Stahl-Guss (separat abnehmbar) Kettenhaken: Stahldraht Reifenheber: superhartes, eloxiertes Aluminium Schraubendreher: Kreuzschlitz + Flachkopf Flaschenöffner: Stahl/mit Speichenhalter Ketten-Stift-Tool: Nietstiftkürzer";s:74:" Affilinet\ProductData\Responses\ResponseElements\Product descriptionShort";s:211:"bike 05/2015 - Testsieger! 20 Profitools aus gehärtetem Werkzeugstahl. Minimale 7,5g pro Funktion. Integrierter Cromoly-Stahl-Guss Kettennieter. Hochfeste geschmiedete Metalllegierung für höchste Drehmomente.";s:72:" Affilinet\ProductData\Responses\ResponseElements\Product shopCategoryId";i:73182;s:77:" Affilinet\ProductData\Responses\ResponseElements\Product affilinetCategoryId";i:38;s:74:" Affilinet\ProductData\Responses\ResponseElements\Product shopCategoryPath";s:31:"Fahrradzubehör > Miniwerkzeuge";s:79:" Affilinet\ProductData\Responses\ResponseElements\Product affilinetCategoryPath";s:26:"Sport & Fitness > Radsport";s:76:" Affilinet\ProductData\Responses\ResponseElements\Product shopCategoryIdPath";s:13:"73120 > 73182";s:81:" Affilinet\ProductData\Responses\ResponseElements\Product affilinetCategoryIdPath";s:7:"18 > 38";s:67:" Affilinet\ProductData\Responses\ResponseElements\Product deeplink1";s:120:"https://partners.webmasterplan.com/click.asp?ref=55122&site=2287&type=text&tnb=8&diurl=https://www.bike24.de/p12076.html";s:67:" Affilinet\ProductData\Responses\ResponseElements\Product deeplink2";N;s:63:" Affilinet\ProductData\Responses\ResponseElements\Product brand";s:6:"Topeak";s:70:" Affilinet\ProductData\Responses\ResponseElements\Product manufacturer";s:6:"Topeak";s:69:" Affilinet\ProductData\Responses\ResponseElements\Product distributor";N;s:61:" Affilinet\ProductData\Responses\ResponseElements\Product EAN";s:14:"04712511824889";s:66:" Affilinet\ProductData\Responses\ResponseElements\Product keywords";N;s:74:" Affilinet\ProductData\Responses\ResponseElements\Product priceInformation";O:54:"Affilinet\ProductData\Responses\ResponseElements\Price":14:{s:64:" Affilinet\ProductData\Responses\ResponseElements\Price currency";s:3:"EUR";s:68:" Affilinet\ProductData\Responses\ResponseElements\Price displayPrice";s:59:" 27.90 EUR Preisangabe inkl. MwSt. ggf. zzgl. Versandkosten";s:71:" Affilinet\ProductData\Responses\ResponseElements\Price displayShipping";s:43:" 3.99 EUR Für Lieferungen nach Deutschland";s:72:" Affilinet\ProductData\Responses\ResponseElements\Price displayBasePrice";N;s:64:" Affilinet\ProductData\Responses\ResponseElements\Price priceOld";d:34.950000000000003;s:67:" Affilinet\ProductData\Responses\ResponseElements\Price pricePrefix";N;s:61:" Affilinet\ProductData\Responses\ResponseElements\Price price";d:27.899999999999999;s:67:" Affilinet\ProductData\Responses\ResponseElements\Price priceSuffix";s:48:"Preisangabe inkl. MwSt. ggf. zzgl. Versandkosten";s:75:" Affilinet\ProductData\Responses\ResponseElements\Price shippingPricePrefix";N;s:69:" Affilinet\ProductData\Responses\ResponseElements\Price shippingPrice";d:3.9900000000000002;s:75:" Affilinet\ProductData\Responses\ResponseElements\Price shippingPriceSuffix";s:33:"Für Lieferungen nach Deutschland";s:71:" Affilinet\ProductData\Responses\ResponseElements\Price basePricePrefix";N;s:65:" Affilinet\ProductData\Responses\ResponseElements\Price basePrice";N;s:71:" Affilinet\ProductData\Responses\ResponseElements\Price basePriceSuffix";N;}s:64:" Affilinet\ProductData\Responses\ResponseElements\Product images";a:5:{i:0;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:7:"Image30";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:96:"https://prdimg.affili.net/img/size/30/src/https/static-external.bike24.com/i/p/6/7/2076_00_c.jpg";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:30;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:30;}i:1;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:7:"Image60";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:96:"https://prdimg.affili.net/img/size/60/src/https/static-external.bike24.com/i/p/6/7/2076_00_c.jpg";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:60;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:60;}i:2;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:7:"Image90";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:96:"https://prdimg.affili.net/img/size/90/src/https/static-external.bike24.com/i/p/6/7/2076_00_c.jpg";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:90;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:90;}i:3;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:8:"Image120";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:97:"https://prdimg.affili.net/img/size/120/src/https/static-external.bike24.com/i/p/6/7/2076_00_c.jpg";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:120;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:120;}i:4;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:8:"Image180";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:97:"https://prdimg.affili.net/img/size/180/src/https/static-external.bike24.com/i/p/6/7/2076_00_c.jpg";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:180;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:180;}}s:63:" Affilinet\ProductData\Responses\ResponseElements\Product logos";a:4:{i:0;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:6:"Logo50";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:35:"https://logos.affili.net/50/193.gif";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:50;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:18;}i:1;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:6:"Logo90";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:35:"https://logos.affili.net/90/193.gif";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:88;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:31;}i:2;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:7:"Logo150";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:36:"https://logos.affili.net/150/193.gif";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:150;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:50;}i:3;O:54:"Affilinet\ProductData\Responses\ResponseElements\Image":4:{s:65:" Affilinet\ProductData\Responses\ResponseElements\Image scaleName";s:7:"Logo468";s:59:" Affilinet\ProductData\Responses\ResponseElements\Image url";s:36:"https://logos.affili.net/468/193.gif";s:61:" Affilinet\ProductData\Responses\ResponseElements\Image width";i:468;s:62:" Affilinet\ProductData\Responses\ResponseElements\Image height";i:60;}}s:68:" Affilinet\ProductData\Responses\ResponseElements\Product properties";a:6:{s:7:"CF_GTIN";s:13:"4712511824889";s:6:"CF_HAN";s:0:"";s:10:"CF_ImgUrl2";s:56:"https://static-external.bike24.com/i/p/6/7/2076_01_d.jpg";s:10:"CF_ImgUrl3";s:56:"https://static-external.bike24.com/i/p/6/7/2076_02_d.jpg";s:10:"CF_ImgUrl4";s:56:"https://static-external.bike24.com/i/p/6/7/2076_03_d.jpg";s:10:"CF_ImgUrl5";s:56:"https://static-external.bike24.com/i/p/6/7/2076_04_d.jpg";}s:67:" Affilinet\ProductData\Responses\ResponseElements\Product programId";i:2287;}');
		$productResponse = $result;


		$myproduct = new atkp_product();

		$myproduct->updatedon = current_time( 'timestamp' );
		$myproduct->shopid    = $this->shopid;

		$myproduct->features    = $productResponse->getDescriptionShort();
		$myproduct->description = $productResponse->getDescription();
		$myproduct->title       = $productResponse->getProductName();
		$myproduct->asin        = $productResponse->getProductId();

		if ( is_array( $productResponse->getImages() ) ) {
			foreach ( $productResponse->getImages() as $image ) {
				if ( $image->getScaleName() == 'Image60' ) {
					$myproduct->smallimageurl = $this->checkimageurl( $image->getUrl() );
				} else if ( $image->getScaleName() == 'Image180' ) {
					$myproduct->mediumimageurl = $this->checkimageurl( $image->getUrl() );
					$myproduct->largeimageurl  = $this->checkimageurl( str_replace( '/size/180', '', $image->getUrl() ) );
				}
			}
		}


		//$myproduct->smallimageurl = $this->checkimageurl($result->Image60->ImageUrl);
		//$myproduct->mediumimageurl = $this->checkimageurl($result->Image120->ImageUrl);
		//$myproduct->largeimageurl = $this->checkimageurl($result->Image->ImageUrl);
		$myproduct->producturl = ATKPTools::check_sslurl( $productResponse->getDeeplink() );

		//$myproduct->addtocarturl = $productResponse->getAlternativeDeeplink(false);


		$price = $productResponse->getPriceInformation();

		if ( isset( $price ) ) {

			$myproduct->saleprice      = $price->getPrice();
			$myproduct->salepricefloat = $this->price_to_float( $price->getPrice() );

			$myproduct->listprice      = $price->getPriceOld();
			$myproduct->listpricefloat = $this->price_to_float( $price->getPriceOld() );

			$myproduct->shipping      = $price->getDisplayShipping();
			$myproduct->shippingfloat = $this->price_to_float( $price->getDisplayShipping() );
		}


		$myproduct->productgroup = $productResponse->getShopCategoryPath();
		$myproduct->ean          = $productResponse->getEAN() != '' ? substr( $productResponse->getEAN(), 1 ) : $productResponse->getEAN();
		$myproduct->manufacturer = $productResponse->getManufacturer();
		$myproduct->brand        = $productResponse->getBrand();


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption'    => __( 'All categories', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'Price-Ascending'  => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
				'Price-Descending' => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
				'Title-Ascending'  => __( 'Title ascending', ATKP_PLUGIN_PREFIX ),
				'Title-Descending' => __( 'Title descending', ATKP_PLUGIN_PREFIX ),
				'Rank-Ascending'   => __( 'Rank ascending', ATKP_PLUGIN_PREFIX ),
				'Rank-Descending'  => __( 'Rank descending', ATKP_PLUGIN_PREFIX ),
			)
		);

		$categoriesRequest = new \Affilinet\ProductData\Requests\CategoriesRequest( $this->helper );

		$categoriesRequest->setShopId( intval( $this->aff_shopId ) ); // where '123456' has to be the valid shopId of course

		$categoriesResponse = $categoriesRequest->send();

		$this->check_response( $categoriesResponse );

		// iterate over the categories
		foreach ( $categoriesResponse->getCategories() as $category ) {

			$departments[ $category->getId() ] = array(
				'caption'    => html_entity_decode( $category->getName() ),
				'sortvalues' => array(
					'Price-Ascending'  => __( 'Price-Ascending', ATKP_PLUGIN_PREFIX ),
					'Price-Descending' => __( 'Price-Descending', ATKP_PLUGIN_PREFIX ),
					'Title-Ascending'  => __( 'Title-Ascending', ATKP_PLUGIN_PREFIX ),
					'Title-Descending' => __( 'Title-Descending', ATKP_PLUGIN_PREFIX ),
					'Rank-Ascending'   => __( 'Rank-Ascending', ATKP_PLUGIN_PREFIX ),
					'Rank-Descending'  => __( 'Rank-Descending', ATKP_PLUGIN_PREFIX ),
				)
			);
		}


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'SortBy'    => __( 'Sort by', ATKP_PLUGIN_PREFIX ),
			'SortOrder' => __( 'Sort Order', ATKP_PLUGIN_PREFIX ),

			'MaximumPrice' => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'MinimumPrice' => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'Brand'        => __( 'Brand', ATKP_PLUGIN_PREFIX ),
			'Manufacturer' => __( 'Manufacturer', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		switch ( $id_type ) {
			case 'ASIN':

				$productsRequest = new \Affilinet\ProductData\Requests\ProductsRequest( $this->helper );
				$productsRequest->onlyFromShopIds( [ $this->aff_shopId ] );
				$productsRequest->addAllProductImages();

				$results = $productsRequest->find( $asins );

				$this->check_response( $results );

				// get the array of Product objects
				$productResponses = $results->getProducts();

				if ( isset( $productResponses ) ) {
					foreach ( $productResponses as $productResponse ) {

						$product              = new atkp_response_item();
						$product->productitem = $this->fill_product( $productResponse );
						$product->uniquetype  = $id_type;
						$product->uniqueid    = $this->findinput( $asins, $product->productitem->asin );

						array_push( $atkpresponse->responseitems, $product );
					}
				}

				foreach ( $asins as $asin ) {
					$found = false;
					foreach ( $atkpresponse->responseitems as $resp ) {
						if ( $resp->uniqueid == $asin ) {
							$found = true;
							break;
						}
					}
					if ( $found ) {
						continue;
					}

					$responseitem               = new atkp_response_item();
					$responseitem->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;

					$responseitem->uniqueid   = $asin;
					$responseitem->uniquetype = $id_type;

					array_push( $atkpresponse->responseitems, $responseitem );
				}

				break;
			case 'EAN':
			case 'TITLE':
			case 'ARTICLENUMBER':

				foreach ( $asins as $asin ) {

					$productsRequest = new \Affilinet\ProductData\Requests\ProductsRequest( $this->helper );
					$productsRequest->onlyFromShopIds( [ $this->aff_shopId ] );
					$productsRequest->addAllProductImages();

					switch ( $id_type ) {
						case 'EAN':
							$productsRequest->addFilterQuery( 'EAN', strlen( $asin ) == 13 ? '0' . $asin : $asin );

							$results = $productsRequest->send();
							break;
						case 'TITLE':
							// perform a fulltext search
							$productsRequest->addRawQuery( $asin );

							// send the query and get the response
							$results = $productsRequest->send();
							break;
						case 'ARTICLENUMBER':
							$productsRequest->addFilterQuery( 'ArticleNumber', $asin );
							$results = $productsRequest->send();
							break;
						default:
							throw new exception( 'unknown id_type:' . $id_type );
					}

					$this->check_response( $results );

					// get the array of Product objects
					$productResponses = $results->getProducts();
					$productfound     = false;
					if ( isset( $productResponses ) ) {
						foreach ( $productResponses as $productResponse ) {

							$product              = new atkp_response_item();
							$product->productitem = $this->fill_product( $productResponse );
							$product->uniquetype  = $id_type;
							$product->uniqueid    = $asin;

							array_push( $atkpresponse->responseitems, $product );
							$productfound = true;
							break;
						}
					}

					if ( ! $productfound ) {
						$product               = new atkp_response_item();
						$product->errormessage = 'product not found';
						$product->uniqueid     = $asin;
						$product->uniquetype   = $id_type;

						array_push( $atkpresponse->responseitems, $product );
					}
					sleep( 1 );
				}


				break;
			default:
				throw new exception( 'unknown id_type:' . $id_type );
		}


		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortByOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' || $nodeid == 'All' ) {
			$nodeid = '';
		}

		$minPrice     = '0';
		$maxPrice     = '0';
		$manufacturer = '';
		$brand        = '';

		$sortBy    = 'ProductName';
		$sortOrder = false;

		if ( $sortByOrder != '' ) {
			switch ( $sortByOrder ) {
				case 'Price-Ascending':
					$sortBy    = 'Price';
					$sortOrder = false;
					break;
				case 'Price-Descending':
					$sortBy    = 'Price';
					$sortOrder = true;
					break;
				case 'Title-Ascending':
					$sortBy    = 'ProductName';
					$sortOrder = false;
					break;
				case 'Title-Descending':
					$sortBy    = 'ProductName';
					$sortOrder = true;
					break;
				case 'Rank-Ascending':
					$sortBy    = 'Score';
					$sortOrder = false;
					break;
				case 'Rank-Descending':
					$sortBy    = 'Score';
					$sortOrder = true;
					break;
			}

			//TODO: sortierung übernhemen
		}


		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'search':
				case 'Keywords':
					$keyword = $value;
					break;
				case 'orderby':
				case 'SortBy':
					$sortBy = $value;
					break;
				case 'SortOrder':
					$sortOrder = $value;
					break;
				case 'MinPrice':
				case 'MinimumPrice':
					$minPrice = $value;
					break;
				case 'MaxPrice':
				case 'MaximumPrice':
					$maxPrice = $value;
					break;
				case 'Manufacturer':
					$manufacturer = $value;
					break;
				case 'Brand':
					$brand = $value;
					break;

			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':

				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$productsRequest = new \Affilinet\ProductData\Requests\ProductsRequest( $this->helper );
		$productsRequest->onlyFromShopIds( [ $this->aff_shopId ] );
		$productsRequest->addAllProductImages();

		if ( $minPrice != '' ) {
			$productsRequest->minPrice( floatval( $minPrice ) );
		}
		if ( $maxPrice != '' ) {
			$productsRequest->maxPrice( floatval( $maxPrice ) );
		}

		if ( $nodeid != '' ) {
			$productsRequest->onlyFromCategories( [ $nodeid ], false, false );
		}
		if ( $manufacturer != '' ) {
			$productsRequest->addFilterQuery( 'Manufacturer', $manufacturer );
		}
		if ( $brand != '' ) {
			$productsRequest->addFilterQuery( 'Brand', $brand );
		}

		if ( $sortBy != '' ) {
			$productsRequest->sort( $sortBy, $sortOrder );
		}

		$productsRequest->addRawQuery( $keyword );

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		$productsRequest->pageSize( $itemsperpage );

		for ($x = 1; $x <= $pages; $x++) {
		    $productsRequest->page( $x );

		    // send the query and get the response
            $results = $productsRequest->send();

            $this->check_response( $results );

            // get the array of Product objects
            $productResponses = $results->getProducts();

            foreach ( $productResponses as $productResponse ) {
                array_push( $products, $this->fill_product( $productResponse ) );

                if(count($products) >= $maxCount)
                    break;
            }

            if(count($productResponses) == 0 || count($products) >= $maxCount)
                break;
		}

		$mylist->products = $products;


		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}

}