<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_product_offer {
	public $data = array();

	const OFFER_TXPE_EAN = 1;
	const OFFER_TYPE_PRODUCTID = 2;


	function __construct() {
		$this->id           = '';
		$this->shipping     = '';
		$this->availability = '';
		$this->shipping     = '';
		$this->price        = '';
		$this->pricefloat   = (float) 0;

		$this->shopid      = '';
		$this->type        = '';
		$this->number      = '';
		$this->link        = '';
		$this->hideoffer   = false;
		$this->holdontop   = false;
		$this->ismainoffer = false;

		$this->title = '';
	}

	/**
	 * Lädt die Angebote zu der übergebenen Produkt-ID aus der offertable
	 *
	 * @param int $productid Die AT-Produkt-ID
	 *
	 * @return array Ein Array von Angeboten
	 */
	public static function load_offers( $productid ) {


		$tablehelper = new atkp_offertable_helper();

		//$offers = ATKPTools::get_post_setting($productid, ATKP_PRODUCT_POSTTYPE.'_offers');

		$offers = $tablehelper->get_offers_by_productid( $productid );

		if ( ! is_array( $offers ) ) {
			$offers = array();
		}

		return $offers;
	}

	public static function load_offers_by_listid( $list_id, $asin ) {

		$tablehelper = new atkp_offertable_helper();

		$offers = $tablehelper->get_offers_by_listid( $list_id, $asin );

		if ( ! is_array( $offers ) ) {
			$offers = array();
		}

		return $offers;
	}

	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}
}


?>