<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_searchform_helper {
	public function createOutput( $template = '', $targetpage = 0, $content = '' ) {

		$mytemplate        = null;
		$filtertarget      = null;
		$filtertargetblank = false;

		if ( is_numeric( $template ) && ATKP_PLUGIN_VERSION >= 30 ) {

			$templatefound = get_post( $template );

			if ( isset( $templatefound ) && $templatefound != null && ( $templatefound->post_status == 'publish' || $templatefound->post_status == 'draft' ) ) {
				$templatetype = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_template_type', true );

				if ( $templatetype != 5 ) {
					throw new Exception( 'template not supported: ' . $templatefound->ID );
				}

				$mytemplate        = html_entity_decode( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_body', true ) );
				$filtertarget      = get_page_uri( ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_filtertarget' ) );
				$filtertargetblank = ATKPTools::get_post_setting( $templatefound->ID, ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank' );


			} else {
				return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
			}

		} else {

			$templatepath = get_template_directory() . '/atkp-templates/' . $template . '.php';
			//wenn die datei im aktuellen theme directory nicht vorhanden ist, greifen wir auf das at-verzeichnis zu
			if ( ! file_exists( $templatepath ) ) {
				$templatepath = ATKP_TEMPLATEDIR . '/' . $template . '.php';
			}
			//existiert die vorlage auch nicht im atkp-verzeichnis dann fallback auf wide
			if ( ! file_exists( $templatepath ) && file_exists( ATKP_TEMPLATEDIR . '/wide.php' ) ) {
				$template     = 'wide';
				$templatepath = ATKP_TEMPLATEDIR . '/' . $template . '.php';
			}

			$templateclass = 'atkp_template_' . $template;

			if ( file_exists( $templatepath ) ) {

				require_once $templatepath;

				$defaulttemplate = new $templateclass();
				$mytemplate      = $defaulttemplate->get_detail();

				if ( $defaulttemplate->get_templatetype() != null ) {
					$templatetype = intval( $defaulttemplate->get_templatetype() );
				}
				if ( $defaulttemplate->get_filtertarget() != null ) {
					$filtertarget = get_page_uri( intval( $defaulttemplate->get_filtertarget() ) );
				}


			} else {
				return ATKPSettings::$hideerrormessages ? '' : ( 'template not found: ' . $template );
			}
		}

		wp_reset_postdata();

		if ( $targetpage > 0 ) {
			$filtertarget = get_permalink( $targetpage );
		} else {
			$filtertarget = get_permalink();
		}

		$placeholders = $this->createFilterPlaceholderArray( '' );

		if ( ! ATKPSettings::$disablestyles ) {
			$resultValue = '<div class="atkp-searchcontainer">';
		} else {
			$resultValue = '';
		}
		$xx = '';

		if ( $filtertargetblank ) {
			$xx = 'target="_blank"';
		}

		$result = '<form action="' . $filtertarget . '" ' . $xx . ' method="get">' . $mytemplate . '</form>';

		foreach ( array_keys( $placeholders ) as $key ) {
			$result = str_replace( '%' . strtolower( $key ) . '%', $placeholders[ $key ], $result );
		}

		$resultValue .= $result;


		if ( ! ATKPSettings::$disablestyles ) {
			$resultValue .= '</div>';
		}


		return $resultValue;
	}

	public function createBackendFilterArray() {

		$placeholders = array();

		$newfields = atkp_udfield::load_fields();

		$helper = new atkp_control_helper();

		//combo mit dropdown
		$placeholders['product1'] = array( 'Product #1', $helper->create_backendcontrol( null, null, 'product1', '' ) );
		$placeholders['product2'] = array( 'Product #2', $helper->create_backendcontrol( null, null, 'product2', '' ) );
		$placeholders['product3'] = array( 'Product #3', $helper->create_backendcontrol( null, null, 'product3', '' ) );
		$placeholders['product4'] = array( 'Product #4', $helper->create_backendcontrol( null, null, 'product4', '' ) );

		//$placeholders['submit'] = '<input type="submit" class="atkp-submitbutton" value="Senden" />';

		//range
		$pricefield          = new atkp_udfield();
		$pricefield->id      = uniqid();
		$pricefield->caption = 'Price';
		$pricefield->name    = 'price';
		$pricefield->type    = 1;
		$pricefield->format  = 'number';

		$pricefield->prefix = get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_prefix', '&euro;' );
		$pricefield->suffix = get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_suffix', '' );


		$placeholders['price'] = array( 'Price', $helper->create_backendcontrol( $pricefield, null, 'price', '' ) );

		foreach ( $newfields as $newfield ) {
			$fieldname = 'customfield_' . $newfield->name;

			switch ( $newfield->type ) {
				case 3:
				case 4:
					//dropdown & yes no
					$placeholders[ $fieldname ] = array(
						$newfield->caption,
						$helper->create_backendcontrol( $newfield, null, $fieldname, '' )
					);
					break;
				case 1:
					//range
					if ( $newfield->format == 'number' ) {
						$placeholders[ $fieldname ] = array(
							$newfield->caption,
							$helper->create_backendcontrol( $newfield, null, $fieldname, '' )
						);
					}
					break;
			}
		}

		if ( get_option( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', false ) ) {


			$groups = ATKPTools::get_fieldgroups();

			foreach ( $groups as $group ) {

				$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );
				if ( $fields != null ) {
					foreach ( $fields as $field ) {
						$fieldname = 'cf_' . $field->name;

						switch ( $field->type ) {
							case 3:
							case 4:
								//dropdown & yes no
								$placeholders[ $fieldname ] = array(
									$field->caption,
									$helper->create_backendcontrol( $field, null, $fieldname, '', true )
								);
								break;
							case 1:
								//range
								if ( $field->format == 'number' ) {
									$placeholders[ $fieldname ] = array(
										$field->caption,
										$helper->create_backendcontrol( $field, null, $fieldname, '', true )
									);
								}
								break;
						}
					}
				}
			}
		}
		$taxonomies = atkp_udtaxonomy::load_taxonomies();

		if ( $taxonomies != null ) {
			foreach ( $taxonomies as $taxonomy ) {
				if ( ! $taxonomy->issystemfield ) {
					if ( $taxonomy->isnewtax ) {
						$fieldname = 'ct_' . $taxonomy->name;
					} else {
						$fieldname = 'customtaxonomy_' . $taxonomy->name;
					}
				} else {

					if ( $taxonomy->ismanufacturer ) {
						$fieldname = 'manufacturer';
					} else if ( $taxonomy->isauthor ) {
						$fieldname = 'author';
					} else if ( $taxonomy->isbrand ) {
						$fieldname = 'brand';
					} else if ( $taxonomy->isproductcategory ) {
						$fieldname = 'productcategory';
					} else {
						$fieldname = $taxonomy->name;
					}
				}

				//combo mit dropdown
				$placeholders[ $fieldname ] = array(
					$taxonomy->caption,
					$helper->create_backendcontrol( null, $taxonomy, $fieldname, '' )
				);
			}
		}


		$placeholders['orderby'] = array( 'Order by', $helper->create_backendcontrol( null, null, 'orderby', '' ) );

		return $placeholders;
	}

	public function createFilterPlaceholderArray( $submitText = '' ) {
		$placeholders = array();

		$newfields = atkp_udfield::load_fields();

		//echo '<option value="1">' . __('Text', ATKP_PLUGIN_PREFIX) . '</option>';
		//echo '<option value="2">' . __('Multiline', ATKP_PLUGIN_PREFIX) . '</option>';
		//echo '<option value="3">' . __('Dropdown', ATKP_PLUGIN_PREFIX) . '</option>';
		//echo '<option value="4">' . __('Yes/No', ATKP_PLUGIN_PREFIX) . '</option>';
		//echo '<option value="5">' . __('Html', ATKP_PLUGIN_PREFIX) . '</option>';

		$helper = new atkp_control_helper();

		$placeholders['orderby'] = $helper->create_frontendcontrol( null, null, 'orderby', '' );
		$placeholders['search']  = $helper->create_frontendcontrol( null, null, 'search', '' );
		$placeholders['submit']  = $helper->create_frontendcontrol( null, null, 'submit', '' );

		//combo mit dropdown
		$placeholders['product1'] = $helper->create_frontendcontrol( null, null, 'product1', '' );
		$placeholders['product2'] = $helper->create_frontendcontrol( null, null, 'product2', '' );
		$placeholders['product3'] = $helper->create_frontendcontrol( null, null, 'product3', '' );
		$placeholders['product4'] = $helper->create_frontendcontrol( null, null, 'product4', '' );

		//$placeholders['submit'] = '<input type="submit" class="atkp-submitbutton" value="Senden" />';

		//range
		$pricefield          = new atkp_udfield();
		$pricefield->id      = uniqid();
		$pricefield->caption = 'Price';
		$pricefield->name    = 'price';
		$pricefield->type    = 1;
		$pricefield->format  = 'number';

		$pricefield->prefix = get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_prefix', '&euro;' );
		$pricefield->suffix = get_option( ATKP_PLUGIN_PREFIX . '_searchform_price_suffix', '' );


		$placeholders['price'] = $helper->create_frontendcontrol( $pricefield, null, 'price', '' );;

		foreach ( $newfields as $newfield ) {
			$fieldname = 'customfield_' . $newfield->name;

			switch ( $newfield->type ) {
				case 3:
				case 4:
					//dropdown & yes no
					$placeholders[ $fieldname ] = $helper->create_frontendcontrol( $newfield, null, $fieldname, '' );
					break;
				case 1:
					//range
					if ( $newfield->format == 'number' ) {
						$placeholders[ $fieldname ] = $helper->create_frontendcontrol( $newfield, null, $fieldname, '' );
					}
					break;
			}
		}

		if ( get_option( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', false ) ) {


			$groups = ATKPTools::get_fieldgroups();

			foreach ( $groups as $group ) {

				$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );
				if ( $fields != null ) {
					foreach ( $fields as $field ) {
						$fieldname = 'cf_' . $field->name;

						switch ( $field->type ) {
							case 3:
							case 4:
								//dropdown & yes no
								$placeholders[ $fieldname ] = $helper->create_frontendcontrol( $field, null, $fieldname, '', true );
								break;
							case 1:
								//range
								if ( $field->format == 'number' ) {
									$placeholders[ $fieldname ] = $helper->create_frontendcontrol( $field, null, $fieldname, '', true );
								}
								break;
						}
					}
				}
			}
		}
		$taxonomies = atkp_udtaxonomy::load_taxonomies();

		if ( $taxonomies != null ) {
			foreach ( $taxonomies as $taxonomy ) {
				$fieldname = $taxonomy->get_fieldname();

				//combo mit dropdown
				$placeholders[ $fieldname ] = $helper->create_frontendcontrol( null, $taxonomy, $fieldname, '' );
			}
		}

		$placeholders = apply_filters( 'atkp_modify_searchform_placeholders', $placeholders );

		return $placeholders;
	}

}


?>