<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

define('ATKP_AMZ_WAIT', 3);

class atkp_shop_provider_amazon extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider


	public function __construct() {

	}

	public function get_maxproductcount() {
		return 10;
	}

	public function get_caption() {
		return __( 'Amazon Product Advertising API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {

	}

	public function get_defaultbtn1_text() {
		return __( 'Buy now at Amazon', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultbtn2_text() {
		return __( 'Add to Amazon Cart', ATKP_PLUGIN_PREFIX );
	}

	public function replace_trackingid( $shopId, $url, $trackingId ) {
		//$associateTag = ATKPTools::get_post_setting($shopId, ATKP_SHOP_POSTTYPE.'_access_tracking_id');

		if ( $url == '' ) {
			return $url;
		}

		$startpos = strrpos( $url, '&AssociateTag=' );

		if ( ! $startpos ) {
			$startpos = strrpos( $url, '&tag=' );

			if ( ! $startpos ) {
				$startpos = strrpos( $url, '?tag=' );

				if ( ! $startpos ) {
					throw new exception( 'trackingcode not found: ' . $url );
				} else {
					$startpos = $startpos + 5;
				}
			} else {
				$startpos = $startpos + 5;
			}
		} else {
			$startpos = $startpos + 14;
		}

		$endofstring = substr( $url, $startpos );

		$endpos = stripos( $endofstring, '&' );

		if ( ! $endpos ) {
			$endpos = strlen( $endofstring );
		}

		//echo $url .'<br /><br />';
		//echo $startpos.'<br /><br />';
		//echo $endpos.'<br /><br />';
		//echo $endofstring.'<br /><br />';
		//echo substr($url, 0, $startpos).'<br /><br />';
		//echo  substr($url, $endpos, strlen($url) - $endpos).'<br /><br />';


		$url = substr( $url, 0, $startpos ) . $trackingId . substr( $endofstring, $endpos, strlen( $endofstring ) - $endpos );
		//echo $url;
		//exit;

		//$url =  str_replace('&AssociateTag='.$associateTag, '&AssociateTag='.$trackingId, $url);
		//$url =  str_replace('&tag='.$associateTag, '&tag='.$trackingId, $url);
		//$url =  str_replace('?tag='.$associateTag, '?tag='.$trackingId, $url);

		return $url;
	}


    private function validate_request_v5($searchItemsRequest) {
        $invalidPropertyList = $searchItemsRequest->listInvalidProperties();
        $length = count($invalidPropertyList);
        if ($length > 0) {
            $txt = "Error forming the request". PHP_EOL;
            foreach ($invalidPropertyList as $invalidProperty) {
                $txt .= $invalidProperty. PHP_EOL;
            }
            throw new Exception($txt);
        }
    }

	private function validate_response_v5($getItemsResponse) {

		if ($getItemsResponse->getErrors() != null) {
			throw new Exception( $getItemsResponse->getErrors()[0]->getCode() .': '. $getItemsResponse->getErrors()[0]->getMessage());
		}
	}


	private function check_configuration_v4( $post_id, $apikey, $apisecretkey, $website, $usessl, $trackingid ) {

		require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

		$client  = new \GuzzleHttp\Client();
		$request = new \ApaiIO\Request\GuzzleRequest( $client );

		$request->setScheme( $usessl ? 'https' : 'http' );

		$conf = new \ApaiIO\Configuration\GenericConfiguration();
		$conf
			->setCountry( $website )
			->setAccessKey( $apikey )
			->setSecretKey( $apisecretkey )
			->setAssociateTag( $trackingid )
			//->setRequest('\ApaiIO\Request\Rest\Request')
			//->setResponseTransformer('\ApaiIO\ResponseTransformer\XmlToDomDocument');
			//->setRequest('\ApaiIO\Request\Soap\Request')
			//->setResponseTransformer('\ApaiIO\ResponseTransformer\ObjectToArray');
			->setRequest( $request );


		$api = new \ApaiIO\ApaiIO( $conf );

		$search = new ApaiIO\Operations\Search();
		$search->setKeywords( 'Harry Potter' );

		$error = '';

		try {
			$test = $api->runOperation( $search );
		} catch ( GuzzleHttp\Exception\ClientException $e ) {
			$response = $e->getResponse();
			if ( isset( $response ) ) {
				$error = $response->getBody();
			} else {
				$error = $e->getMessage();
			}
			//error contains: Website Temporarily Unavailable
			//You are submitting requests too quickly. Please retry your requests at a slower rate. For more information, see <a href="http://docs.aws.amazon.com/AWSECommerceService/latest/DG/TroubleshootingApplications.html#efficiency-guidelines" target="_blank">Efficiency Guidelines</a>.
		} catch ( GuzzleHttp\Exception\ServerException $exception ) {
			$response = $exception->getResponse();
			if ( $response != null && $response->getBody() != null ) {
				$responseBodyAsString = $response->getBody()->getContents();
			} else {
				$responseBodyAsString = $exception->getMessage();
			}

			$error = 'Request ServerException: ' . $responseBodyAsString;
		}

		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** check_configuration amazon ***' );
			ATKPLog::LogDebug( serialize( $test ) );
			ATKPLog::LogDebug( '*** check_configuration amazon ***' );
		}

		if($error == '') {
			$test = $this->convert_response( $test );

			if ( ! empty ( $test->Error->Code ) ) {
				return $test->Error->Message;
				// Fallback for any other issue
			}else {
				$this->set_default_shop($post_id);
				return'';
            }

		}else {
		    return $error;
        }
	}

	private function set_default_shop($post_id) {
		$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );
		$subshops    = array();

		//add subshop for amazon
		$subshop         = new subshop();
		$subshop->title  = __( 'Amazon', ATKP_PLUGIN_PREFIX );
		$subshop->shopid = $post_id;

		$website = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_website' );

		switch ( $website ) {
			case 'de':
				$subshop->logourl      = plugins_url( 'images/logo-normal-amazon-de.jpg', ATKP_PLUGIN_FILE );
				$subshop->smalllogourl = plugins_url( 'images/logo-small-amazon-de.jpg', ATKP_PLUGIN_FILE );
				break;
			case 'com':
				$subshop->logourl      = plugins_url( 'images/logo-normal-amazon-com.png', ATKP_PLUGIN_FILE );
				$subshop->smalllogourl = plugins_url( 'images/logo-small-amazon-com.png', ATKP_PLUGIN_FILE );
				break;
		}

		$subshop->enabled = true;

		array_push( $subshops, $subshop );

		//für bestehende alte subshops ist dieser teil noch drinnen
		if ( is_array( $subshopsold ) ) {
			foreach ( $subshopsold as $shopold ) {
				if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
					$subshop->enabled            = $shopold->enabled;
					$subshop->customtitle        = $shopold->customtitle;
					$subshop->customsmalllogourl = $shopold->customsmalllogourl;
					$subshop->customlogourl      = $shopold->customlogourl;
					$subshop->customfield1       = $shopold->customfield1;
					$subshop->customfield2       = $shopold->customfield2;
					$subshop->customfield3       = $shopold->customfield3;
				}
			}
		}

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );
    }

	private function get_config($apikey, $apisecretkey, $country) {
		$config = new Amazon\ProductAdvertisingAPI\v1\Configuration();

		$config->setAccessKey($apikey);
		$config->setSecretKey($apisecretkey);

	    $host = '';
	    $region = '';

	    switch($country) {
	        default;
            case 'de':
                $host ='webservices.amazon.de';
                $region = 'eu-west-1';
                break;
		    case 'com':
			    $host = 'webservices.amazon.com';
			    $region = 'us-east-1';
			    break;
		    case 'co.uk':
			    $host = 'webservices.amazon.co.uk';
			    $region = 'eu-west-1';
			    break;
		    case 'ca':
		        $host = 'webservices.amazon.ca';
		        $region = 'us-east-1';
		        break;
		    case 'fr':
			    $host = 'webservices.amazon.fr';
			    $region = 'eu-west-1';
		        break;
		    case 'co.jp':
			    $host = 'webservices.amazon.co.jp';
			    $region = 'us-west-2';
			    break;
		    case 'it':
                $host = 'webservices.amazon.it';
                $region = 'eu-west-1';
                break;
		    case 'cn':
		    case 'es':
                $host = 'webservices.amazon.es';
                $region = 'eu-west-1';
                break;
		    case 'in':
                $host = 'webservices.amazon.in';
                $region = 'eu-west-1';
		        break;
            case 'au':
                $host = 'webservices.amazon.com.au';
                $region = 'us-west-2';
                break;
		    case 'com.br':
		        $host = 'webservices.amazon.com.br';
		        $region = 'us-east-1';
                break;
            case 'com.mx':
	            $host = 'webservices.amazon.com.mx';
	            $region = 'us-east-1';
                break;
            case 'com.tr':
	            $host = 'webservices.amazon.com.tr';
	            $region = 'eu-west-1';
                break;
		    case 'ae':
			    $host = 'webservices.amazon.ae';
			    $region = 'eu-west-1';
			    break;
        }


		$config->setHost($host);
		$config->setRegion($region);

		return $config;
    }

    private function get_api_instance($apikey, $apisecretkey, $website) {
	    require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

	    $config = $this->get_config($apikey, $apisecretkey, $website);

	    $apiInstance = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\api\DefaultApi(new \GuzzleHttp\Client(), $config);

	    return $apiInstance;
    }

	private function check_configuration_v5( $post_id, $apikey, $apisecretkey, $website, $usessl, $trackingid ) {
		//require_once ATKP_PLUGIN_DIR . '/lib/paapi5-sdk/vendor/autoload.php';

		$apiInstance = $this->get_api_instance($apikey, $apisecretkey, $website);

		$searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
		$searchItemsRequest->setSearchIndex('All');
		$searchItemsRequest->setKeywords('Harry Potter');
		$searchItemsRequest->setItemCount(1);
		$searchItemsRequest->setPartnerTag($trackingid);
		$searchItemsRequest->setPartnerType(Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES);

 		$this->validate_request_v5($searchItemsRequest);

		$test = '';

		try {
			$searchItemsResponse = $apiInstance->searchItems( $searchItemsRequest );

			$itemcount = $searchItemsResponse->getSearchResult()->getTotalResultCount();
			if($itemcount == 0)
			    $test = 'item count is null';

		} catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
			$test = "API-Error: ". $exception->getCode() . " ". $exception->getMessage();

			if ($exception->getResponseObject() instanceof Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\ProductAdvertisingAPIClientException) {
				$errors = $exception->getResponseObject()->getErrors();
				foreach ($errors as $error) {
					$test =  "Response-Error: ". $error->getCode() ." ". $error->getMessage();
				}
			} else {
				$test .= "Error response body: ". $exception->getResponseBody();
			}
		} catch (Exception $exception) {
			$test = "Error Message: ". $exception->getMessage(). ' ' . $exception->getTraceAsString();
		}

		if($test == '')
			$this->set_default_shop($post_id);
		else
		    return $test;
	}

    public function check_configuration( $post_id ) {
    try {
        $apikey       = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
        $apisecretkey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
        $website      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_website' );
        $trackingid   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_tracking_id' );
        $usessl       = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_tracking_id' );
        $sitestripe   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_sitestripe' );

        $apiversion   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_apiversion' );

        if($apiversion == 'v4')
	        $v5api = false;
        else
            $v5api = true;

        if ( $sitestripe == 2 || $sitestripe == 3 ) {
            return '';
        }

        $message = '';
        if ( $apikey != '' && $apisecretkey != '' ) {

            if($v5api)
                return $this->check_configuration_v5( $post_id, $apikey, $apisecretkey, $website, $usessl, $trackingid ).'';
            else
                return $this->check_configuration_v4( $post_id, $apikey, $apisecretkey, $website, $usessl, $trackingid ).'';


        } else {
            //wenn zugangscodes gelöscht werden muss message auch geleert werden
            $message = 'Credientials are empty';
        }

        return $message;
    } catch ( Exception $e ) {
        if ( ATKPLog::$logenabled ) {
            ATKPLog::LogError( $e->getMessage() );
        }

        return $e->getMessage();
    }
}

	private function convert_response( $response ) {

		//return json_decode(json_encode($response), false);
		return json_decode( json_encode( (array) simplexml_load_string( $response ) ), 0 );
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_amz_medium_image_size', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_medium_image_size', 'int' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_amz_small_image_size', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_small_image_size', 'int' ) );


		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_website', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_access_website', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_tracking_id', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_access_tracking_id', 'string' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_load_customer_reviews', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_load_customer_reviews', 'bool' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_enable_ssl', 'bool' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_secret_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_access_secret_key', 'string' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_sitestripe', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_sitestripe', 'int' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_apiversion', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_amz_apiversion', 'string' ) );


	}

	private function get_defaultshops( $post_id ) {
		$subshops = array();

		$website = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_website' );

		$subshop = new subshop();

		$subshop->title = __( 'Amazon', ATKP_PLUGIN_PREFIX );

		switch ( $website ) {
			case 'de':
				$subshop->logourl      = plugins_url( 'images/logo-normal-amazon-de.jpg', ATKP_PLUGIN_FILE );
				$subshop->smalllogourl = plugins_url( 'images/logo-small-amazon-de.jpg', ATKP_PLUGIN_FILE );
				break;
			case 'com':
				$subshop->logourl      = plugins_url( 'images/logo-normal-amazon-com.png', ATKP_PLUGIN_FILE );
				$subshop->smalllogourl = plugins_url( 'images/logo-small-amazon-com.png', ATKP_PLUGIN_FILE );
				break;
		}

		$subshop->shopid    = $post_id;
		$subshop->programid = '';

		$subshop->enabled = true;

		array_push( $subshops, $subshop );

		return $subshops;
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = null;

		if ( $webservice == '1' ) {
			$apikey       = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$apisecretkey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_key' ?>">
					<?php _e( 'Amazon Access Key ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'amazon-getkey' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">

                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_secret_key' ?>">
					<?php _e( 'Amazon Secret Access Key', ATKP_PLUGIN_PREFIX ) ?>:
                </label>

            </th>
            <td>
                <input style="width:40%" type="password"
                       id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_secret_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_secret_key' ?>"
                       value="<?php echo $apisecretkey; ?>">
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_website' ?>">
					<?php _e( 'Amazon Website', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <select name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_website' ?>">
					<?php
					//        public static $locations = array('de', 'com', 'co.uk', 'ca', 'fr', 'co.jp', 'it', 'cn', 'es', 'in', 'com.br');

					$locations = array(
						'de'     => __( 'Amazon Germany', ATKP_PLUGIN_PREFIX ),
						'com'    => __( 'Amazon United States', ATKP_PLUGIN_PREFIX ),
						'co.uk'  => __( 'Amazon United Kingdom', ATKP_PLUGIN_PREFIX ),
						'ca'     => __( 'Amazon Canada', ATKP_PLUGIN_PREFIX ),
						'fr'     => __( 'Amazon France', ATKP_PLUGIN_PREFIX ),
						'co.jp'  => __( 'Amazon Japan', ATKP_PLUGIN_PREFIX ),
						'it'     => __( 'Amazon Italy', ATKP_PLUGIN_PREFIX ),

						'es'     => __( 'Amazon Spain', ATKP_PLUGIN_PREFIX ),
						'in'     => __( 'Amazon India', ATKP_PLUGIN_PREFIX ),
						'com.br' => __( 'Amazon Brazil', ATKP_PLUGIN_PREFIX ),
						'au'     => __( 'Amazon Australia', ATKP_PLUGIN_PREFIX ),
						'com.mx' => __( 'Amazon Mexico', ATKP_PLUGIN_PREFIX ),
						'com.tr' => __( 'Amazon Turkey', ATKP_PLUGIN_PREFIX ),
						'ae' => __( 'Amazon United Arab Emirates', ATKP_PLUGIN_PREFIX ),
					);
//'cn'     => __( 'Amazon China', ATKP_PLUGIN_PREFIX ),

					foreach ( $locations as $value => $name ) {
						if ( $value == ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_website' ) ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}


						echo '<option value="' . $value . '"' . $sel . '>' . $name . '</option>';
					} ?>
                </select>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_tracking_id' ?>">
					<?php _e( 'Amazon Tracking ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_tracking_id' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_access_tracking_id' ?>"
                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_tracking_id' ); ?>">
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_small_image_size' ?>">
					<?php _e( 'Small image size', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input type="number" min="0" max="1000" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_small_image_size' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_small_image_size' ?>"
                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_amz_small_image_size' ); ?>">
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_medium_image_size' ?>">
					<?php _e( 'Medium image size', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input type="number" min="0" max="1000" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_medium_image_size' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_medium_image_size' ?>"
                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_amz_medium_image_size' ); ?>">
            </td>
        </tr>

<!--
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_enable_ssl' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_enable_ssl' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' ), true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>
-->
        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_apiversion' ?>">
		            <?php _e( 'api version', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </th>
            <td>


                <select id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_apiversion' ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_apiversion' ?>" style="width:300px">
		            <?php
		            $selected = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_apiversion' );

		            echo '<option value="" ' . ( $selected == '' || $selected == 'auto' ? 'selected' : '' ) . ' >' . __( 'Auto', ATKP_PLUGIN_PREFIX ) . '</option>';

		            echo '<option value="v5" ' . ( $selected == 'v5' ? 'selected' : '' ) . '>' . __( 'API v5', ATKP_PLUGIN_PREFIX ) . '</option>';

		            echo '<option value="v4" ' . ( $selected == 'v4' ? 'selected' : '' ) . '>' . __( 'API v4', ATKP_PLUGIN_PREFIX ) . '</option>';


		            ?>

                </select>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Site Stripe mode (beta)', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <select id="<?php echo ATKP_SHOP_POSTTYPE . '_sitestripe' ?>"
                        name="<?php echo ATKP_SHOP_POSTTYPE . '_sitestripe' ?>" style="width:300px">
					<?php
					$selected = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_sitestripe' );

					echo '<option value="1" ' . ( $selected == '' || $selected == 1 ? 'selected' : '' ) . ' >' . __( 'Disabled', ATKP_PLUGIN_PREFIX ) . '</option>';

					echo '<option value="2" ' . ( $selected == 2 ? 'selected' : '' ) . '>' . __( 'Preferably use', ATKP_PLUGIN_PREFIX ) . '</option>';

					echo '<option value="3" ' . ( $selected == 3 ? 'selected' : '' ) . '>' . __( 'Use in case of error', ATKP_PLUGIN_PREFIX ) . '</option>';


					?>

                </select>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_amz_load_customer_reviews' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_amz_load_customer_reviews' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_load_customer_reviews' ), true ); ?>>
                <!-- ATKPTools::get_post_setting($post->ID, ATKP_SHOP_POSTTYPE.'_load_customer_reviews') -->
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_amz_load_customer_reviews' ?>">
					<?php _e( 'Scrape star ratings from website (not recommended)', ATKP_PLUGIN_PREFIX ) ?>
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'amazon-customerreview' ); ?>
            </td>
        </tr>
		<?php

	}

	public function get_shops( $post_id, $allshops = false ) {

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( $subshops == null || count( $subshops ) > 1 ) {
			$subshops = $this->get_defaultshops( $post_id );
		}

		foreach ( $subshops as $subshop ) {
			$subshop->shopid    = $post_id;
			$subshop->programid = '';

			$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
			$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
			$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

			$subshop->enabled = true;
		}

		return $subshops;
	}

	/* @var Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\api\DefaultApi $helper */
	private $helper = null;
	private $enable_ssl = false;
	private $country = '';
	private $load_customer_reviews = false;
	private $associateTag = '';
	private $accessKey = '';
	private $shopid = '';

	private $smallimagesize = 0;
	private $mediumimagesize = 0;

	private $sitetripemode = 0;
	private $usev5 = 0;

	private function checklogon_v4( $access_website, $access_key, $access_secret_key, $access_tracking_id ) {
		require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

		$client  = new \GuzzleHttp\Client();
		$request = new \ApaiIO\Request\GuzzleRequest( $client );

		$request->setScheme( $this->enable_ssl ? 'https' : 'http' );

		$conf = new \ApaiIO\Configuration\GenericConfiguration();
		$conf
			->setCountry( $access_website )
			->setAccessKey( $access_key )
			->setSecretKey( $access_secret_key )
			->setAssociateTag( $access_tracking_id )
			->setRequest( $request );


		$this->helper = new \ApaiIO\ApaiIO( $conf );
	}

	private function checklogon_v5( $access_website, $access_key, $access_secret_key, $access_tracking_id ) {

		$this->helper = $this->get_api_instance($access_key,$access_secret_key,$access_website);
	}

	public function checklogon( $shop ) {
		$this->shopid                = $shop->id;
		$this->accessKey             = $access_key = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$access_secret_key           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_secret_key' );
		$access_message              = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_message' );
		$this->country               = $access_website = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_website' );
		$this->associateTag          = $access_tracking_id = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_tracking_id' );
		$this->load_customer_reviews = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_load_customer_reviews' );
		$this->enable_ssl            = true; // ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );

		$this->sitetripemode = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_sitestripe' );
		$apiversion   = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_apiversion' );

		if($apiversion == 'v4')
			$this->usev5 = false;
		else
			$this->usev5 = true;

		$this->smallimagesize  = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_amz_small_image_size' );
		$this->mediumimagesize = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_amz_medium_image_size' );

		//http://ws-eu.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&OneJS=1&Operation=GetAdHtml&MarketPlace=DE&source=ss&ref=as_ss_li_til&ad_type=product_link&tracking_id=werbeanzeige1-21&language=de_DE&marketplace=amazon&region=DE&placement=B01MR8IST0&asins=B01MR8IST0&linkId=2b2c154e99d12d52b2eeedaca502173f&show_border=true&link_opens_in_new_window=true
		//http://ws-eu.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&OneJS=1&Operation=GetAdHtml&MarketPlace=DE&source=ss&ref=as_ss_li_til&ad_type=product_link&tracking_id=werbeanzeige1-21&language=de_DE&marketplace=amazon&region=DE&placement=B01MR8IST0&asins=B01MR8IST0&linkId=f9c12eaff04df7a156ab2470af8795b6&show_border=false&link_opens_in_new_window=true
		//https://www.amazon.de/Anbernic-Handheld-Spielkonsole-Konsole-Retro/dp/B079KC8Y4Z/ref=as_li_ss_il?pf_rd_p=bf2f9e9c-e5d5-4935-a04d-fda59481ccaa&pd_rd_wg=o3sJU&pf_rd_r=2XY13YPN803RR4ST4DQ6&ref_=pd_gw_cr_cartx&pd_rd_w=VtV3b&pd_rd_r=9a23560a-0d57-4b39-bb61-6df20e25109c&linkCode=li3&tag=werbeanzeige1-21&linkId=3ece46f52aef6db73c170a5784594205&language=de_DE" target="_blank"><img border="0" src="//ws-eu.amazon-adsystem.com/widgets/q?_encoding=UTF8&ASIN=B079KC8Y4Z&Format=_SL250_&ID=AsinImage&MarketPlace=DE&ServiceVersion=20070822&WS=1&tag=werbeanzeige1-21&language=de_DE" ></a><img src="https://ir-de.amazon-adsystem.com/e/ir?t=werbeanzeige1-21&language=de_DE&l=li3&o=3&a=B079KC8Y4Z
		//<a href="https://www.amazon.de/Anbernic-Handheld-Spielkonsole-Konsole-Retro/dp/B079KC8Y4Z/ref=as_li_ss_il?pf_rd_p=bf2f9e9c-e5d5-4935-a04d-fda59481ccaa&pd_rd_wg=o3sJU&pf_rd_r=2XY13YPN803RR4ST4DQ6&ref_=pd_gw_cr_cartx&pd_rd_w=VtV3b&pd_rd_r=9a23560a-0d57-4b39-bb61-6df20e25109c&linkCode=li3&tag=werbeanzeige1-21&linkId=3ece46f52aef6db73c170a5784594205&language=de_DE" target="_blank"><img border="0" src="//ws-eu.amazon-adsystem.com/widgets/q?_encoding=UTF8&ASIN=B079KC8Y4Z&Format=_SL250_&ID=AsinImage&MarketPlace=DE&ServiceVersion=20070822&WS=1&tag=werbeanzeige1-21&language=de_DE" ></a><img src="https://ir-de.amazon-adsystem.com/e/ir?t=werbeanzeige1-21&language=de_DE&l=li3&o=3&a=B079KC8Y4Z" width="1" height="1" border="0" alt="" style="border:none !important; margin:0px !important;" />

		if ( $access_tracking_id == '' ) {
			$access_tracking_id = 'empty';
		}

		if($this->usev5)
		    $this->checklogon_v5($access_website, $access_key,$access_secret_key, $access_tracking_id);
		else
    		$this->checklogon_v4( $access_website, $access_key, $access_secret_key, $access_tracking_id );
	}

	/**
	 * Sets itemIdType
	 *
	 * @param \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\BrowseNodeAncestor $browsenodeancestor
	 *
	 * @return string $result
	 */
	private function getBrowseNodeTreeRec($browsenodeancestor, &$nodes) {
		if($browsenodeancestor == null)
			return '';

		$nodes[ $browsenodeancestor->getId() ] = $browsenodeancestor->getDisplayName();

		if($browsenodeancestor->getAncestor() != null)
			$this->getBrowseNodeTreeRec($browsenodeancestor->getAncestor(), $nodes);
	}

	private function retrieve_browsenodes_v5( $keyword ) {

		$nodes = array();
        $items = null;
		try {
			$searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
			$searchItemsRequest->setSearchIndex( 'All' );
			$searchItemsRequest->setKeywords( $keyword );
			$searchItemsRequest->setItemCount( 10 );
			$searchItemsRequest->setPartnerTag( $this->associateTag );
			$searchItemsRequest->setPartnerType( Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
			$searchItemsRequest->setResources(
				\Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsResource::getAllowableEnumValues()
			);
			$searchItemsRequest->setItemPage( 1 );

			$searchItemsResponse = $this->sendSearchRequest( $searchItemsRequest );

			if($searchItemsResponse->getSearchResult() != null && $searchItemsResponse->getSearchResult()->getItems() != null)
				$items = $searchItemsResponse->getSearchResult()->getItems();

		} catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
			$check = "API-Error: ". $exception->getCode() . " ". $exception->getMessage();

			if ($exception->getResponseObject() instanceof Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\ProductAdvertisingAPIClientException) {
				$errors = $exception->getResponseObject()->getErrors();
				foreach ($errors as $error) {
					$check =  "Response-Error: ". $error->getCode() ." ". $error->getMessage();
				}
			} else {
				$check .= "Error response body: ". $exception->getResponseBody();
			}
		} catch (Exception $exception) {
			$check = "Error Message: ". $exception->getMessage(). ' ' . $exception->getTraceAsString();
		}

		if($items != null)
            foreach($items as $item) {
                foreach($item->getBrowseNodeInfo()->getBrowseNodes() as $bnw) {
                    $this->getBrowseNodeTreeRec( $bnw->getAncestor(), $nodes);
                }
            }

		return $nodes;
	}

	private function retrieve_browsenodes_v4( $keyword ) {
		$search = new ApaiIO\Operations\Search();
		$search->setPage( 1 );
		$search->setCategory( 'All' );
		//$search->setCondition('New');
		$search->setKeywords( $keyword );
		$search->setResponseGroup( array( 'BrowseNodes' ) );

		$nodes = array();

		$pagination = 0;
		do {
			$pagination ++; //increment

			$search->setPage( $pagination );

			try {
				$response = $this->helper->runOperation( $search );
				$response = $this->convert_response( $response );

				$check = $this->checkResponse( $response );
			} catch ( GuzzleHttp\Exception\ClientException $e ) {
				$response = $e->getResponse();
				if ( isset( $response ) ) {
					$check = $response->getBody();
				} else {
					$check = $e->getMessage();
				}
			} catch ( Exception $e ) {
				$check = $e->getMessage();
			}

			//falls fehler aufgetreten ist, 2. versuch
			if ( ! empty( $check ) ) {
				sleep( 3 );
				$response = $this->helper->runOperation( $search );
				$response = $this->convert_response( $response );

				$check = $this->checkResponse( $response );
			}

			if ( ! empty( $check ) ) {
				throw new Exception( $check );
			}

			if ( isset( $response->Items->Item ) ) {
				foreach ( $response->Items->Item as $result ) {
					if ( isset( $result->BrowseNodes->BrowseNode ) ) {

						if ( isset( $result->BrowseNodes->BrowseNode->Name ) ) {
							$nodes[ $result->BrowseNodes->BrowseNode->BrowseNodeId ] = $result->BrowseNodes->BrowseNode->Name;
						}

						foreach ( $result->BrowseNodes->BrowseNode as $browsenode ) {
							foreach ( $this->retrieve_recursive_browsenodes( $browsenode ) as $node => $value ) {
								$nodes[ $node ] = $value;
							}
						}

					}
				}
			}
		} while ( $pagination <= 2 );

		return $nodes;

	}

	public function retrieve_browsenodes( $keyword ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		if($this->usev5)
		    $nodes = $this->retrieve_browsenodes_v5($keyword);
		else
    		$nodes = $this->retrieve_browsenodes_v4( $keyword );

		$newNodes = array();

		foreach ( $nodes as $node => $value ) {
			if ( ! array_key_exists( $node, $newNodes ) ) {
				$newNodes[ $node ] = $value;
			}
		}

		return $newNodes;
	}

	private function retrieve_recursive_browsenodes( $parentBrowseNode ) {
		$nodes = array();
		if ( isset( $parentBrowseNode->Ancestors ) ) {
			foreach ( $parentBrowseNode->Ancestors as $browsenode ) {
				if ( ! isset( $browsenode->Name ) || ! is_string( $browsenode->Name ) ) {
					continue;
				}

				$nodes[ $browsenode->BrowseNodeId ] = $browsenode->Name;

				foreach ( $this->retrieve_recursive_browsenodes( $browsenode ) as $node => $value ) {
					$nodes[ $node ] = $value;
				}

				//array_push($nodes, $this->RecursiveBrowseNodes($browsenode));
			}
		}

		return $nodes;
	}

	private function quick_search_v4( $keyword, $searchType, $pagination ) {
		$products = new atkp_search_resp();
		$maxCount = 10;

		if ( $searchType == 'asin' || $searchType == 'ean' || $searchType == 'articlenumber' ) {

			$search = new ApaiIO\Operations\Lookup();

			$search->setCategory( 'All' );

			if ( $searchType == 'ean' ) {
				$search->setIdType( 'EAN' );
			}

			$search->setItemId( explode( ',', $keyword ) );


		} else {

			$search = new ApaiIO\Operations\Search();

			$search->setCategory( 'All' );
			//$search->setCondition('New');
			$search->setKeywords( $keyword );

		}
		$search->setResponseGroup( array( 'ItemAttributes', 'Images', 'OfferFull', 'Variations' ) );
		$search->setPage( $pagination );

		try {
			$response = $this->helper->runOperation( $search );
			$response = $this->convert_response( $response );

			if ( isset( $response->Items ) ) {
				$products->pagecount = intval( $response->Items->TotalPages );
				$products->total     = intval( $response->Items->TotalResults );
			}
			$products->currentpage = intval( $pagination );

			$check = $this->checkResponse( $response );
		} catch ( GuzzleHttp\Exception\ClientException $e ) {
			$response = $e->getResponse();
			if ( isset( $response ) ) {
				$check = $response->getBody();
			} else {
				$check = $e->getMessage();
			}
		} catch ( Exception $e ) {
			$check = $e->getMessage();
		}

		//falls fehler aufgetreten ist, 2. versuch
		if ( ! empty( $check ) ) {
			sleep( 3 );
			$response = $this->helper->runOperation( $search );
			$response = $this->convert_response( $response );

			$check = $this->checkResponse( $response );
		}

		if ( ! empty( $check ) ) {
			throw new Exception( $check );
		}

		$items = array();

		if ( isset( $response->Items->Item ) ) {
			if ( ! is_array( $response->Items->Item ) ) {
				$items = array( $response->Items->Item );
			} else
				$items = $response->Items->Item;
		}


        foreach ($items as $result ) {
            if ( isset( $result->ASIN ) ) {
                $product = array();

                if ( isset( $result->SmallImage->URL ) ) {
                    $product['imageurl'] = $this->checkimageurl( $result->SmallImage->URL, 'small' );
                }
                $product['articlenumber'] = $product['asin'] = $result->ASIN;
                if ( isset( $result->ItemAttributes->EAN ) ) {
                    $product['ean'] = $result->ItemAttributes->EAN;
                }
                $product['producturl'] = $result->DetailPageURL;
                $product['title']      = htmlspecialchars( $result->ItemAttributes->Title );
                if ( isset( $result->Offers->Offer->OfferListing->Availability ) ) {
                    $product['availability'] = $result->Offers->Offer->OfferListing->Availability;
                }

                //TODO: lowest new price liefert völlig sinnfreie Preise aus dem marketplace zurück
                if ( isset( $result->ItemAttributes->ListPrice->FormattedPrice ) ) {
                    $product['listprice'] = $result->ItemAttributes->ListPrice->FormattedPrice;
                }

                if ( $product['listprice'] == '' && isset( $result->Offers->Offer->OfferListing->Price->FormattedPrice ) ) {
                    $product['listprice'] = $result->Offers->Offer->OfferListing->Price->FormattedPrice;
                }

                if ( isset( $result->Offers->Offer->OfferListing->Price->FormattedPrice ) ) {
                    $product['saleprice'] = $result->Offers->Offer->OfferListing->Price->FormattedPrice;
                }

                if ( isset( $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice ) ) {
                    $product['saleprice'] = $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice;
                }


                if ( isset( $result->OfferSummary->LowestNewPrice ) && $product['price'] == '' ) {

                    $product['saleprice'] = $result->OfferSummary->LowestNewPrice->FormattedPrice;
                    $product['listprice'] = '';
                }

                $description = '';
                if ( isset( $result->EditorialReviews->EditorialReview ) ) {
                    if ( isset( $result->EditorialReviews->EditorialReview->Content ) ) {
                        $description = $result->EditorialReviews->EditorialReview->Content;
                    } elseif ( sizeof( $result->EditorialReviews->EditorialReview ) > 0 ) {
                        foreach ( $result->EditorialReviews->EditorialReview as $tmp ) {
                            if ( isset( $description ) && strlen( $description ) < strlen( $tmp->Content ) ) {
                                $description = $tmp->Content;
                            }
                        }
                    }
                }

                $product['description'] = $description != '' && strlen( $description ) > 350 ? substr( $description, 0, 350 ) : $description;


                //$product['availability'] = $result->Offers->Offer->OfferListing->Availability;

                array_push( $products->products, $product );
            }
        }



		return $products;
	}

	private function quick_search_v5( $keyword, $searchType, $pagination ) {
		$products = new atkp_search_resp();
		$maxCount = 10;

		$items = array();
        try {
            //$searchType == 'ean'
            if ( $searchType == 'asin' || $searchType == 'articlenumber' ) {
                $getItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsRequest();
                $getItemsRequest->setItemIds( explode( ',', $keyword ) );
                $getItemsRequest->setItemIdType( ( $searchType == 'ean' ? 'EAN' : 'ASIN' ) );
                $getItemsRequest->setPartnerTag( $this->associateTag );
                $getItemsRequest->setPartnerType( \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
                $getItemsRequest->setResources(
	                \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsResource::getAllowableEnumValues()
                );

	            $getItemsResponse = $this->sendGetItemsRequest($getItemsRequest);

	            if($getItemsResponse->getItemsResult() != null && $getItemsResponse->getItemsResult()->getItems() != null)
    	            $items = $getItemsResponse->getItemsResult()->getItems();


            } else {
                $searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
                $searchItemsRequest->setSearchIndex( 'All' );
                $searchItemsRequest->setKeywords( $keyword );
                $searchItemsRequest->setItemCount( $maxCount );
                $searchItemsRequest->setPartnerTag( $this->associateTag );
                $searchItemsRequest->setPartnerType( Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
	            $searchItemsRequest->setResources(
		            \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsResource::getAllowableEnumValues()
                );
                $searchItemsRequest->setItemPage( $pagination );

	            $searchItemsResponse = $this->sendSearchRequest( $searchItemsRequest );

	            if ( $searchItemsResponse->getSearchResult() != null ) {
		            $products->pagecount =  ceil(floatval($searchItemsResponse->getSearchResult()->getTotalResultCount() ) / floatval($maxCount));
		            $products->total     = intval( $searchItemsResponse->getSearchResult()->getTotalResultCount() );
	            }
	            $products->currentpage = intval( $pagination );


	            if($searchItemsResponse->getSearchResult() != null && $searchItemsResponse->getSearchResult()->getItems() != null)
                    $items = $searchItemsResponse->getSearchResult()->getItems();
            }
        } catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
            $check = "API-Error: ". $exception->getCode() . " ". $exception->getMessage();

            if ($exception->getResponseObject() instanceof Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\ProductAdvertisingAPIClientException) {
                $errors = $exception->getResponseObject()->getErrors();
                foreach ($errors as $error) {
                    $check =  "Response-Error: ". $error->getCode() ." ". $error->getMessage();
                }
            } else {
                $check .= "Error response body: ". $exception->getResponseBody();
            }
        } catch (Exception $exception) {
            $check = "Error Message: ". $exception->getMessage(). ' ' . $exception->getTraceAsString();
        }

		if ( ! empty( $check ) ) {
			throw new Exception( $check );
		}


		foreach ($items as $result ) {
			if ( $result->getASIN() != null) {
				$product = array();

				if($result->getImages() != null && $result->getImages()->getPrimary() !=null) {
				    $product['imageurl'] = $this->checkimageurl($result->getImages()->getPrimary()->getSmall()->getURL(), 'small' );
                }

				$product['articlenumber'] = $product['asin'] = $result->getASIN();
				//var_dump($result->getExternalIds());exit;

                $ean_full = '';
                if($result->getItemInfo()->getExternalIds() != null && $result->getItemInfo()->getExternalIds()->getEANs() != null)
                    foreach($result->getItemInfo()->getExternalIds()->getEANs()->getDisplayValues() as $ean) {
                        if($ean_full != '')
	                        $ean_full .= ',';

	                    $ean_full .= $ean;
                    }
				$product['ean'] = $ean_full;

				if ($result->getDetailPageURL() != null) {
					$product['producturl'] = $result->getDetailPageURL();
				}
				if ($result->getItemInfo() != null && $result->getItemInfo()->getTitle() != null && $result->getItemInfo()->getTitle()->getDisplayValue() != null) {
					$product['title'] = htmlspecialchars( $result->getItemInfo()->getTitle()->getDisplayValue() );
				}
				foreach($result->getOffers()->getListings() as $listing) {
					$product['availability'] = $listing->getAvailability();

					if($listing->getPrice() != null) {
						$product['listprice'] = $listing->getPrice()->getSavings() == null ? '' : $listing->getPrice()->getSavings()->getDisplayAmount();
						$product['saleprice'] = $listing->getPrice()->getDisplayAmount();
                    	break;
					}
                }


				if ( $result->getOffers()->getSummaries() != null && $product['price'] == '' ) {
				    foreach($result->getOffers()->getSummaries() as $summary) {
					    $product['saleprice'] = $summary->getLowestPrice()->getDisplayAmount();
					    $product['listprice'] = '';
				        break;
				    }
				}



				$description = '';
				if($result->getItemInfo()->getFeatures() != null && $result->getItemInfo()->getFeatures()->getDisplayValues() != null)
				    $description = implode('<br />', $result->getItemInfo()->getFeatures()->getDisplayValues());

				$product['description'] = $description != '' && strlen( $description ) > 350 ? substr( $description, 0, 350 ) : $description;


				//$product['availability'] = $result->Offers->Offer->OfferListing->Availability;

				array_push( $products->products, $product );
			}
		}



		return $products;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		if($this->usev5) {
            try {
                $products = $this->quick_search_v5( $keyword, $searchType, $pagination );
            } catch  (Exception $exception) {

                if(ATKPTools::str_contains($exception->getMessage(), 'The request was denied due to request throttling.', false)) {
                    sleep(ATKP_AMZ_WAIT);
	                $products = $this->quick_search_v5( $keyword, $searchType, $pagination );
                } else
                    throw $exception;
            }
		}
        else
		    $products = $this->quick_search_v4( $keyword, $searchType, $pagination );

		return $products;
	}

	private function checkurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function checkimageurl( $url, $size ) {

		//if ( $this->enable_ssl ) {
		//	$url = str_replace( 'http://ecx.images-amazon.com', 'https://images-na.ssl-images-amazon.com', $url );
		//}

		if ( $size == 'small' && $this->smallimagesize > 0 ) {
			$url = str_replace( 'SL75', 'SL' . $this->smallimagesize, $url );
		}
		if ( $size == 'medium' && $this->mediumimagesize > 0 ) {
			$url = str_replace( 'SL160', 'SL' . $this->mediumimagesize, $url );
		}

		return $url;
	}


	private function checkResponse( $response ) {
		$requestHelp = null;
		if ( isset( $response->BrowseNodes->Request ) ) {
			$requestHelp = $response->BrowseNodes->Request;
		} else if ( isset( $response->Items->Request ) ) {
			$requestHelp = $response->Items->Request;
		}

		//echo('$response: ' .serialize($response));

		$message = '';

		if ( isset( $requestHelp->IsValid ) && $requestHelp->IsValid != 'True' ) {

			$message .= 'Invalid Request. IsValid: ' . $requestHelp->IsValid;

			//echo('xx '.serialize($requestHelp->Errors->Error));

		}

		if ( isset( $requestHelp->Errors->Error ) ) {

			if ( isset( $requestHelp->Errors->Error->Code ) && $requestHelp->Errors->Error->Code != '' ) {
				$error = $requestHelp->Errors->Error;
				if ( $message != '' ) {
					$message .= ' ';
				}
				$message .= 'ErrorCode: ' . $error->Code;
				if ( $message != '' ) {
					$message .= ' ';
				}
				$message .= 'Message: ' . $error->Message;
			} else {
				foreach ( $requestHelp->Errors->Error as $error ) {
					if ( $message != '' ) {
						$message .= ' ';
					}
					$message .= 'ErrorCode: ' . $error->Code;
					if ( $message != '' ) {
						$message .= ' ';
					}
					$message .= 'Message: ' . $error->Message;
				}
			}
		}

		return $message;
	}

	private function parse_department_file($filename)  {
		$departments = array();

		if (($handle = fopen(ATKP_PLUGIN_DIR . '/includes/shopproviders/amazon/'.$filename, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {

				$departments[$data[0]]                = array(
					'caption' => $data[1],
					'sortvalues' => array(
						'AvgCustomerReviews'  => __( 'Sorts results according to average customer reviews', ATKP_PLUGIN_PREFIX ),
						'Featured' => __( 'Sorts results with featured items having higher rank', ATKP_PLUGIN_PREFIX ),
						'NewestArrivals'  => __( 'Sorts results with according to newest arrivals', ATKP_PLUGIN_PREFIX ),
						'Price:HighToLow' => __( 'Sorts results according to most expensive to least expensive', ATKP_PLUGIN_PREFIX ),
						'Price:LowToHigh'   => __( 'Sorts results according to least expensive to most expensive', ATKP_PLUGIN_PREFIX ),
						'Relevance'     => __( 'Sorts results with relevant items having higher rank', ATKP_PLUGIN_PREFIX ),
					)
				);

			}
			fclose($handle);
		}
		return $departments;
    }

	private function retrieve_departments_v5() {
		switch ( $this->country ) {
			case 'de':
                return $this->parse_department_file('germany.csv');
				break;
			default:
			case 'en':
			    return $this->parse_department_file('unitedstates.csv');
				break;
			case 'co.uk':
				return $this->parse_department_file('unitedkingdom.csv');
				break;
			case 'ca':
				return $this->parse_department_file('canada.csv');
				break;
			case 'fr':
				return $this->parse_department_file('france.csv');
				break;
			case 'co.jp':
				return $this->parse_department_file('japan.csv');
				break;
			case 'it':
				return $this->parse_department_file('italy.csv');
				break;
			case 'cn':
			case 'es':
			    return $this->parse_department_file('spain.csv');
				break;
			case 'in':
				return $this->parse_department_file('india.csv');
				break;
			case 'au':
				return $this->parse_department_file('australia.csv');
				break;
			case 'com.br':
				return $this->parse_department_file('brazil.csv');
				break;
			case 'com.mx':
				return $this->parse_department_file('mexico.csv');
				break;
			case 'com.tr':
				return $this->parse_department_file('turkey.csv');
				break;
			case 'ae':
				return $this->parse_department_file('emirates.csv');
				break;
		}
	}


	private function retrieve_departments_v4() {
		$departments = array();

		switch ( $this->country ) {
			case 'de':
				require_once ATKP_PLUGIN_DIR . '/includes/helper/atkp_amazon_helper_de.php';

				$helper      = new atkp_amazon_helper_de();
				$departments = $helper->get_departments();

				break;
			default:
			case 'en':
				require_once ATKP_PLUGIN_DIR . '/includes/helper/atkp_amazon_helper_en.php';

				$helper      = new atkp_amazon_helper_en();
				$departments = $helper->get_departments();

				break;

		}

		return $departments;
	}

	public function retrieve_departments() {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		if($this->usev5)
		    $departments = $this->retrieve_departments_v5();
		else
    		$departments = $this->retrieve_departments_v4();

		return $departments;
	}

	private function retrieve_filters_v4() {
		$durations = array(
			''            => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords'    => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
			'SearchIndex' => __( 'SearchIndex', ATKP_PLUGIN_PREFIX ),
			'Sort'        => __( 'Sort', ATKP_PLUGIN_PREFIX ),
			'BrowseNode'  => __( 'BrowseNode', ATKP_PLUGIN_PREFIX ),

			'Availability' => __( 'Availability', ATKP_PLUGIN_PREFIX ),

			'Power' => __( 'Power', ATKP_PLUGIN_PREFIX ),

			'Actor'  => __( 'Actor', ATKP_PLUGIN_PREFIX ),
			'Artist' => __( 'Artist', ATKP_PLUGIN_PREFIX ),
			'Author' => __( 'Author', ATKP_PLUGIN_PREFIX ),
			'Brand'  => __( 'Brand', ATKP_PLUGIN_PREFIX ),

			'Composer'  => __( 'Composer', ATKP_PLUGIN_PREFIX ),
			'Conductor' => __( 'Conductor', ATKP_PLUGIN_PREFIX ),
			'Director'  => __( 'Director', ATKP_PLUGIN_PREFIX ),

			'Manufacturer'     => __( 'Manufacturer', ATKP_PLUGIN_PREFIX ),
			'MaximumPrice'     => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'MinimumPrice'     => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'MinPercentageOff' => __( 'Min percentage off', ATKP_PLUGIN_PREFIX ),

			'Orchestra' => __( 'Orchestra', ATKP_PLUGIN_PREFIX ),
			'Publisher' => __( 'Publisher', ATKP_PLUGIN_PREFIX ),

			'Condition'  => __( 'Condition', ATKP_PLUGIN_PREFIX ),
			'MerchantId' => __( 'Merchant Id', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	private function retrieve_filters_v5() {
		$durations = array(
			''            => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords'    => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
			'SearchIndex' => __( 'SearchIndex', ATKP_PLUGIN_PREFIX ),
			'Sort'        => __( 'Sort', ATKP_PLUGIN_PREFIX ),
			'BrowseNode'  => __( 'BrowseNode', ATKP_PLUGIN_PREFIX ),

			'Actor'  => __( 'Actor', ATKP_PLUGIN_PREFIX ),
			'Artist' => __( 'Artist', ATKP_PLUGIN_PREFIX ),
			'Author' => __( 'Author', ATKP_PLUGIN_PREFIX ),
			'Availability' => __( 'Availability', ATKP_PLUGIN_PREFIX ),
			'Brand'  => __( 'Brand', ATKP_PLUGIN_PREFIX ),
			'Condition'  => __( 'Condition', ATKP_PLUGIN_PREFIX ),

			'DeliveryFlags'  => __( 'DeliveryFlags', ATKP_PLUGIN_PREFIX ),
			'CurrencyOfPreference'  => __( 'Currency Of Preference', ATKP_PLUGIN_PREFIX ),
			'LanguagesOfPreference'  => __( 'Languages Of Preference', ATKP_PLUGIN_PREFIX ),
			'Marketplace'  => __( 'Marketplace', ATKP_PLUGIN_PREFIX ),
			'MaximumPrice'     => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'MinimumPrice'     => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'MerchantId' => __( 'Merchant Id', ATKP_PLUGIN_PREFIX ),
			'MinPercentageOff' => __( 'Min percentage off', ATKP_PLUGIN_PREFIX ),

			'MinReviewsRating' => __( 'Min Reviews Rating', ATKP_PLUGIN_PREFIX ),
			'Title' => __( 'Title', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
    }

	public function retrieve_filters() {

		if($this->usev5)
			$durations = $this->retrieve_filters_v5();
		else
    		$durations = $this->retrieve_filters_v4();

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		if($this->usev5) {
            try {
                return $this->retrieve_products_v5( $asins, $id_type );
            } catch  (Exception $exception) {

                if(ATKPTools::str_contains($exception->getMessage(), 'The request was denied due to request throttling.', false)) {
                    sleep(ATKP_AMZ_WAIT);
	                return $this->retrieve_products_v5( $asins, $id_type );
                } else
                    throw $exception;
            }
		}
		else
			return $this->retrieve_products_v4( $asins, $id_type );
	}

	private function load_sitestripeproduct( $asins ) {
		$atkpresponse = new atkp_response();

		//https://ws-eu.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&OneJS=1&Operation=GetAdHtml&MarketPlace=DE&ad_type=product_link&tracking_id=werbeanzeige1-21&marketplace=amazon&region=DE&asins=B07H2BRGPS


		foreach ( $asins as $asin ) {

			try {
				$url  = 'https://ws-eu.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&OneJS=1&Operation=GetAdHtml&MarketPlace=' . strtoupper( $this->country ) . '&ad_type=product_link&tracking_id=' . $this->associateTag . '&marketplace=amazon&region=' . strtoupper( $this->country ) . '&asins=' . $asin;
				$page = '';


				if ( function_exists( 'wp_remote_get' ) ) {

					$response   = wp_remote_get( $url, array(
						'timeout'    => 20,
						'user-agent' => 'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'
					) );
					$statusCode = null;

					if ( function_exists( 'is_wp_error' ) && ! is_wp_error( $response ) ) {

						// Success
						if ( isset( $response['response']['code'] ) ) {
							$statusCode = $response['response']['code'];
						}

						if ( '200' == $statusCode ) {
							$page = $response['body'];
						}
					}
				}


				if ( ! class_exists( 'simple_html_dom' ) ) {
					require_once ATKP_PLUGIN_DIR . '/lib/simple_html_dom.php';
				}

				$html = new simple_html_dom();

				$html->load( $page );

				if ( ! $html ) {
					throw new exception( 'html not received: ' . $asin );
				}

				// Reviews
				$imagehtml = $html->find( 'img[id=prod-image]' );
				$linkhtml  = $html->find( 'a[id=titlehref]' );

				if ( isset( $imagehtml[0] ) ) {
					$imageurl = $imagehtml[0]->src;
				}
				if ( isset( $linkhtml[0] ) ) {
					$linkurl      = $linkhtml[0]->href;
					$producttitle = $linkhtml[0]->plaintext;
				}

				$pricehtml = $html->find( 'span.price' );

				if ( isset( $pricehtml[0] ) ) {
					$price = $pricehtml[0]->plaintext;
				}

				$myproduct            = new atkp_product();
				$myproduct->updatedon = ATKPTools::get_currenttime();
				$myproduct->shopid    = $this->shopid;

				//store the ASIN code in case we need it
				$myproduct->asin          = $asin;
				$myproduct->smallimageurl = $this->checkimageurl( $imageurl, 'small' );
				//$myproduct->mediumimageurl = $this->checkimageurl( $imageurl, 'medium' );
				//$myproduct->largeimageurl = $this->checkimageurl( $imageurl, 'large' );

				$myproduct->customerreviewurl = $this->checkurl( 'http://www.amazon.' . $this->country . '/product-reviews/' . $myproduct->asin . '/?tag=' . $this->associateTag );
				$myproduct->title             = $producttitle;
				$myproduct->saleprice         = $price;

				$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

				$myproduct->producturl = str_replace( '%', '%25', $linkurl );

				$myproduct->addtocarturl = $this->checkurl( 'http://www.amazon.' . $this->country . '/gp/aws/cart/add.html?AWSAccessKeyId=' . $this->accessKey . '&AssociateTag=' . $this->associateTag . '&ASIN.1=' . $myproduct->asin . '&Quantity.1=1' );

				$product              = new atkp_response_item();
				$product->productitem = $myproduct;
				$product->uniquetype  = 'ASIN';
				$product->uniqueid    = $asin;

				array_push( $atkpresponse->responseitems, $product );
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();

				$product               = new atkp_response_item();
				$product->errormessage = 'product error: ' . $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = 'ASIN';

				array_push( $atkpresponse->responseitems, $product );
			}
		}
		//$responseitem              = new atkp_response_item();
		//$responseitem->productitem = $this->fill_product( $result );

		//$responseitem->uniqueid   = $title;
		//$responseitem->uniquetype = $id_type;

		//array_push( $atkpresponse->responseitems, $responseitem );


		return $atkpresponse;
	}

	public function retrieve_products_v5( $asins, $id_type ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		switch ( $id_type ) {
			case 'TITLE':
			case "EAN":

				foreach ( $asins as $title ) {
					$items = null;
					try {
						$searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
						$searchItemsRequest->setSearchIndex( 'All' );
						$searchItemsRequest->setKeywords( $title );
						$searchItemsRequest->setItemCount( 2 );
						$searchItemsRequest->setPartnerTag( $this->associateTag );
						$searchItemsRequest->setPartnerType( Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
						$searchItemsRequest->setResources(
							\Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsResource::getAllowableEnumValues()
						);
						$searchItemsRequest->setItemPage( 1 );

						$searchItemsResponse = $this->sendSearchRequest( $searchItemsRequest );

						if ( $searchItemsResponse->getSearchResult() != null && $searchItemsResponse->getSearchResult()->getItems() != null ) {
							$items = $searchItemsResponse->getSearchResult()->getItems();
						}

					} catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
						$titlecheck = "API-Error: ". $exception->getCode() . " ". $exception->getMessage();

						if ($exception->getResponseObject() instanceof Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\ProductAdvertisingAPIClientException) {
							$errors = $exception->getResponseObject()->getErrors();
							foreach ($errors as $error) {
								$titlecheck =  "Response-Error: ". $error->getCode() ." ". $error->getMessage();
							}
						} else {
							$titlecheck .= "Error response body: ". $exception->getResponseBody();
						}
					} catch (Exception $exception) {
						$titlecheck = "Error Message: ". $exception->getMessage(). ' ' . $exception->getTraceAsString();
					}


					$added = false;

					if ( $titlecheck != '' || $items == null ) {

						$responseitem               = new atkp_response_item();
						$responseitem->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;

						$responseitem->uniqueid   = $title;
						$responseitem->uniquetype = $id_type;

						array_push( $atkpresponse->responseitems, $responseitem );
						$added = true;

					} else {

						if ( $items != null ) {
							foreach ( $items as $result2 ) {
								if ( $result2->getASIN() == null || $added ) {
									continue;
								}

								$result = $result2;
								break;
							}


							if($result != null) {
								$responseitem              = new atkp_response_item();
								$responseitem->productitem = $this->fill_product_v5( $result );

								$responseitem->uniqueid   = $title;
								$responseitem->uniquetype = $id_type;

								array_push( $atkpresponse->responseitems, $responseitem );
								$added = true;
							}
						}

					}

					if ( ! $added ) {
						$product               = new atkp_response_item();
						$product->errormessage = 'product not found';
						$product->uniqueid     = $title;
						$product->uniquetype   = $id_type;

						array_push( $atkpresponse->responseitems, $product );
					}
					sleep( 1 );
				}

				break;
			case 'ARTICLENUMBER':
			case 'ASIN':

				if ( $this->sitetripemode == 2 && $id_type == 'ASIN' ) {
					//bevorzugte nutzung
					$atkpresponse = $this->load_sitestripeproduct( $asins );

					return $atkpresponse;
				}

    			$items = array();
                try {
                    $getItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsRequest();
                    $getItemsRequest->setItemIds( $asins );
                    $getItemsRequest->setItemIdType( ( 'ASIN' ) );
                    $getItemsRequest->setPartnerTag( $this->associateTag );
                    $getItemsRequest->setPartnerType( \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
                    $getItemsRequest->setResources(
                        \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsResource::getAllowableEnumValues()
                    );

                    $getItemsResponse = $this->sendGetItemsRequest( $getItemsRequest );

                    if($getItemsResponse->getItemsResult() != null && $getItemsResponse->getItemsResult()->getItems() != null)
                        $items = $getItemsResponse->getItemsResult()->getItems();
                } catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
	                $check = "API-Error: ". $exception->getCode() . " ". $exception->getMessage();

                    if ($exception->getResponseObject() instanceof Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\ProductAdvertisingAPIClientException) {
                        $errors = $exception->getResponseObject()->getErrors();
                        foreach ($errors as $error) {
	                        $check =  "Response-Error: ". $error->getCode() ." ". $error->getMessage();
                        }
                    } else {
	                    $check .= "Error response body: ". $exception->getResponseBody();
                    }
                } catch (Exception $exception) {
	                $check = "Error Message: ". $exception->getMessage(). ' ' . $exception->getTraceAsString();
                }



				if ( ! empty( $check ) && $this->sitetripemode == 3 && $id_type == 'ASIN' ) {
					$atkpresponse = $this->load_sitestripeproduct( $asins );

					return $atkpresponse;
				}

				if ( ! empty( $check ) ) {
					$atkpresponse->errormessage = $check;

					return $atkpresponse;
				}
/*
				if ( isset( $response->Items->Request->Errors->Error ) ) {
					foreach ( $response->Items->Request->Errors->Error as $error ) {
						foreach ( $asins as $asin ) {
							$emessage = isset( $error->Message ) ? $error->Message : (string) $error;
							if ( stripos( $emessage, $asin ) !== false ) {
								$product               = new atkp_response_item();
								$product->errormessage = $emessage;
								$product->uniqueid     = $asin;
								$product->uniquetype   = $id_type;

								array_push( $atkpresponse->responseitems, $product );
							}
						}
					}
				}
*/

				foreach ( $items as $result ) {
					if ( $result->getASIN() == null ) {
						continue;
					}

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product_v5( $result );
					$product->uniquetype  = $id_type;

					switch ( $id_type ) {
						case 'ASIN':
						case 'ARTICLENUMBER':
							$product->uniqueid = $this->findinput( $asins, $product->productitem->asin );
							break;
						case 'EAN':
							$product->uniqueid = $this->findinput( $asins, $product->productitem->ean );
							break;
						default:
							throw new exception( 'unknown id_type:' . $id_type );
					}

					array_push( $atkpresponse->responseitems, $product );
				}


				break;
			default:
				throw new Exception( 'unknown id_type: ' . $id_type );
				break;
		}

		return $atkpresponse;

	}

	public function retrieve_products_v4( $asins, $id_type ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		switch ( $id_type ) {
			case 'TITLE':

				foreach ( $asins as $title ) {

					$search = new ApaiIO\Operations\Search();
					$search->setCategory( 'All' );
					$search->setResponseGroup( array( 'Large', 'Variations', 'OfferFull', 'Variations' ) );

					$search->setKeywords( $title );

					try {
						$response = $this->helper->runOperation( $search );
						$response = $this->convert_response( $response );

						$titlecheck = $this->checkResponse( $response );

					} catch ( GuzzleHttp\Exception\ClientException $e ) {
						$response = $e->getResponse();
						if ( isset( $response ) ) {
							$titlecheck = $response->getBody();
						} else {
							$titlecheck = $e->getMessage();
						}
					} catch ( Exception $e ) {
						$titlecheck = $e->getMessage();
					}

					$added = false;

					if ( ! empty( $titlecheck ) || ! isset( $response->Items->Item ) ) {

						$responseitem               = new atkp_response_item();
						$responseitem->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;

						$responseitem->uniqueid   = $title;
						$responseitem->uniquetype = $id_type;

						array_push( $atkpresponse->responseitems, $responseitem );
						$added = true;

					} else {

						if ( is_array( $response->Items->Item ) ) {
							foreach ( $response->Items->Item as $result2 ) {
								if ( ! isset( $result2->ASIN ) || $added ) {
									continue;
								}

								$result = $result2;
								break;
							}
						} else {
							$result = $response->Items->Item;
						}

						$responseitem              = new atkp_response_item();
						$responseitem->productitem = $this->fill_product_v4( $result );

						$responseitem->uniqueid   = $title;
						$responseitem->uniquetype = $id_type;

						array_push( $atkpresponse->responseitems, $responseitem );
						$added = true;

					}

					if ( ! $added ) {
						$product               = new atkp_response_item();
						$product->errormessage = 'product not found';
						$product->uniqueid     = $title;
						$product->uniquetype   = $id_type;

						array_push( $atkpresponse->responseitems, $product );
					}
					sleep( 1 );
				}

				break;
			case 'ARTICLENUMBER':
			case 'ASIN':
			case "EAN":

				if ( $this->sitetripemode == 2 && $id_type == 'ASIN' ) {
					//bevorzugte nutzung
					$atkpresponse = $this->load_sitestripeproduct( $asins );

					return $atkpresponse;
				}


				$search = new ApaiIO\Operations\Lookup();
				$search->setPage( 1 );
				$search->setCategory( 'All' );
				$search->setResponseGroup( array( 'Large', 'Variations', 'OfferFull', 'Variations' ) );
				if ( $id_type == 'EAN' ) {
					$search->setIdType( ApaiIO\Operations\Lookup::TYPE_EAN );
				}

				$search->setItemId( $asins );

				try {
					$response = $this->helper->runOperation( $search );
					$response = $this->convert_response( $response );

				} catch ( GuzzleHttp\Exception\ServerException $exception ) {
					$response = $exception->getResponse();
					if ( $response != null && $response->getBody() != null ) {
						$responseBodyAsString = $response->getBody()->getContents();
					} else {
						$responseBodyAsString = $exception->getMessage();
					}

					$check = 'Request ServerException: ' . $responseBodyAsString;

				} catch ( GuzzleHttp\Exception\ClientException $e ) {
					$response = $e->getResponse();
					if ( isset( $response ) ) {
						$check = $response->getBody();
					} else {
						$check = $e->getMessage();
					}
				} catch ( Exception $e ) {
					$check = $e->getMessage();
				}

				if ( ! empty( $check ) && $this->sitetripemode == 3 && $id_type == 'ASIN' ) {
					$atkpresponse = $this->load_sitestripeproduct( $asins );

					return $atkpresponse;
				}

				if ( ! empty( $check ) ) {
					$atkpresponse->errormessage = $check;

					return $atkpresponse;
				}

				if ( isset( $response->Items->Request->Errors->Error ) ) {
					foreach ( $response->Items->Request->Errors->Error as $error ) {
						foreach ( $asins as $asin ) {
							$emessage = isset( $error->Message ) ? $error->Message : (string) $error;
							if ( stripos( $emessage, $asin ) !== false ) {
								$product               = new atkp_response_item();
								$product->errormessage = $emessage;
								$product->uniqueid     = $asin;
								$product->uniquetype   = $id_type;

								array_push( $atkpresponse->responseitems, $product );
							}
						}
					}
				}

				$results = array();

				if ( isset( $response->Items->Item ) ) {
					if ( is_array( $response->Items->Item ) ) {
						foreach ( $response->Items->Item as $result2 ) {
							array_push( $results, $result2 );
						}
					} else {
						array_push( $results, $response->Items->Item );
					}
				}

				foreach ( $results as $result ) {
					if ( ! isset( $result->ASIN ) ) {
						continue;
					}

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product_v4( $result );
					$product->uniquetype  = $id_type;

					switch ( $id_type ) {
						case 'ASIN':
						case 'ARTICLENUMBER':
							$product->uniqueid = $this->findinput( $asins, $product->productitem->asin );
							break;
						case 'EAN':
							$product->uniqueid = $this->findinput( $asins, $product->productitem->ean );
							break;
						default:
							throw new exception( 'unknown id_type:' . $id_type );
					}

					array_push( $atkpresponse->responseitems, $product );
				}


				break;
			default:
				throw new Exception( 'unknown id_type: ' . $id_type );
				break;
		}

		return $atkpresponse;
	}

	/**
	 * Sets itemIdType
	 *
	 * @param \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\Item $result
	 *
	 * @return $myproduct atkp_product
	 */
	private function fill_product_v5($result, $parentResult = null) {
		$myproduct            = new atkp_product();
		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		//store the ASIN code in case we need it
		$myproduct->asin       = $result->getASIN();
		$myproduct->parentasin = $result->getParentASIN();

		//TODO: Variationen einbauen mit optionsfeld im shop
		//TODO: v4 und v5 mit dropdown und "Auto" umschalten

		if ( $result->getDetailPageURL() != null  ) {
			$myproduct->producturl = urldecode( $result->getDetailPageURL() );
			//für 100% im titel - replace muss geklärt werden..
			$myproduct->producturl = str_replace( '%', '%25', $myproduct->producturl );

			$myproduct->addtocarturl = $this->checkurl( 'http://www.amazon.' . $this->country . '/gp/aws/cart/add.html?AWSAccessKeyId=' . $this->accessKey . '&AssociateTag=' . $this->associateTag . '&ASIN.1=' . $myproduct->asin . '&Quantity.1=1' );
		} else if ( $parentResult != null && $parentResult->getDetailPageURL() != null ) {

			$myproduct->producturl = urldecode( $parentResult->getDetailPageURL() );
			//für 100% im titel - replace muss geklärt werden..
			$myproduct->producturl = str_replace( '%', '%25', $myproduct->producturl );

			$myproduct->producturl   = $this->checkurl( 'https://www.amazon.' . $this->country . '/dp/' . $myproduct->asin . '?tag=' . $this->associateTag );
			$myproduct->addtocarturl = $this->checkurl( 'https://www.amazon.' . $this->country . '/gp/aws/cart/add.html?AWSAccessKeyId=' . $this->accessKey . '&AssociateTag=' . $this->associateTag . '&ASIN.1=' . $parentResult->ASIN . '&Quantity.1=1' );

		} else {
			$myproduct->producturl   = '';
			$myproduct->addtocarturl = '';
		}


		$images = array();
		if($result->getImages() != null) {
		    if($result->getImages()->getPrimary() != null) {
			    $myproduct->smallimageurl = $this->checkimageurl( $result->getImages()->getPrimary()->getSmall()->getURL(), 'small' );
			    $myproduct->mediumimageurl = $this->checkimageurl( $result->getImages()->getPrimary()->getMedium()->getURL(), 'medium' );
			    $myproduct->largeimageurl = $this->checkimageurl( $result->getImages()->getPrimary()->getLarge()->getURL(), 'large' );
            }

		    if($result->getImages()->getVariants() != null)
                foreach($result->getImages()->getVariants() as $variant) {
                    if($variant->getLarge() == null && $variant->getMedium() == null && $variant->getSmall() == null)
                        continue;

	                $udf     = new atkp_product_image();
	                $udf->id = uniqid();
	                if ($variant->getSmall() != null ) {
		                $udf->smallimageurl = $this->checkimageurl( $variant->getSmall()->getURL(), 'small' );
	                }
	                if (  $variant->getMedium()  != null ) {
		                $udf->mediumimageurl = $this->checkimageurl(  $variant->getMedium() ->getURL(), 'medium' );
	                }
	                if (  $variant->getLarge() != null ) {
		                $udf->largeimageurl = $this->checkimageurl( $variant->getLarge()->getURL(), 'large' );
	                }

	                array_push( $images, $udf );
                }
        }
		$myproduct->images = $images;

		if ( $this->load_customer_reviews ) {

            $averageRating = 0;
            $totalReviews  = 0;

            $this->get_customer_rating( $myproduct->asin, $averageRating, $totalReviews );

            $myproduct->rating      = $averageRating;
            $myproduct->reviewcount = $totalReviews;

		}

		$myproduct->customerreviewurl = $this->checkurl( 'http://www.amazon.' . $this->country . '/product-reviews/' . $myproduct->asin . '/?tag=' . $this->associateTag );

		$description = '';
		//TODO: load description
		$description = ( isset( $description ) ) ? $description : '';


		$features    = '';

		if($result->getItemInfo()->getFeatures() != null && $result->getItemInfo()->getFeatures()->getDisplayValues() != null) {
		    foreach($result->getItemInfo()->getFeatures()->getDisplayValues() as $feature) {
			    $features .= '<li>' . $feature . '</li>';
            }
		}

		$myproduct->features    = $features == '' ? '' : '<ul>' . $features . '</ul>';
		$myproduct->description = $description;
		if ($result->getItemInfo() != null && $result->getItemInfo()->getTitle() != null && $result->getItemInfo()->getTitle()->getDisplayValue() != null)
			$myproduct->title       = htmlentities( $result->getItemInfo()->getTitle()->getDisplayValue() );
        else
            $myproduct->title = '';

		//preise laden

		if($result->getOffers() != null) {
		    $offerlisting = null;
			foreach ( $result->getOffers()->getListings() as $listing ) {
			    if($listing->getIsBuyBoxWinner()) {
				    $offerlisting = $listing;
			        break;
			    }
			}
			if($offerlisting == null && $result->getOffers()->getListings() != null) {
			    $listings = $result->getOffers()->getListings();
				$offerlisting = reset( $listings );
			}


			if($offerlisting != null) {
				if ( $offerlisting->getAvailability() != null ) {
					$myproduct->availability = $offerlisting->getAvailability()->getMessage();
				}
				$myproduct->isprime = $offerlisting->getDeliveryInfo()->getIsPrimeEligible();
				if ( $offerlisting->getDeliveryInfo()->getShippingCharges() != null ) {
					$myproduct->shipping = $offerlisting->getDeliveryInfo()->getShippingCharges()[0]->getDisplayAmount();
				}

				$myproduct->saleprice = $offerlisting->getPrice()->getDisplayAmount();
				$myproduct->salepricefloat = $offerlisting->getPrice()->getAmount();

				if ( $offerlisting->getPrice()->getSavings() != null ) {
					$myproduct->percentagesaved = $offerlisting->getPrice()->getSavings()->getPercentage();
					$myproduct->amountsaved     = $offerlisting->getPrice()->getSavings()->getDisplayAmount();
					$myproduct->amountsavedfloat =  $offerlisting->getPrice()->getSavings()->getAmount();
				}

				if($offerlisting->getSavingBasis() != null) {
					$myproduct->listprice      = $offerlisting->getSavingBasis()->getDisplayAmount();
					$myproduct->listpricefloat = $offerlisting->getSavingBasis()->getAmount();
				}

			}
		}


		//$myproduct->salepricefloat   = $this->price_to_float( $myproduct->saleprice );
		//$myproduct->amountsavedfloat = $this->price_to_float( $myproduct->amountsaved );
		//$myproduct->listpricefloat   = $this->price_to_float( $myproduct->listprice );
		$myproduct->shippingfloat    = (float) 0;


		if ( $result->getItemInfo() != null && $result->getItemInfo()->getByLineInfo() != null && $result->getItemInfo()->getByLineInfo()->getManufacturer() != null  ) {
			$myproduct->manufacturer = $result->getItemInfo()->getByLineInfo()->getManufacturer()->getDisplayValue();
		}
		if ( $result->getItemInfo() != null && $result->getItemInfo()->getByLineInfo() != null && $result->getItemInfo()->getByLineInfo()->getBrand() != null  ) {
			$myproduct->brand = $result->getItemInfo()->getByLineInfo()->getBrand()->getDisplayValue();
		}

		$isbn_full = '';
		if($result->getItemInfo()->getExternalIds() != null && $result->getItemInfo()->getExternalIds()->getISBNs() != null)
			foreach($result->getItemInfo()->getExternalIds()->getISBNs()->getDisplayValues() as $ean) {
				if($isbn_full != '')
					$isbn_full .= ',';

				$isbn_full .= $ean;
			}
		$myproduct->isbn = $isbn_full;

		$ean_full = '';
		if($result->getItemInfo()->getExternalIds() != null && $result->getItemInfo()->getExternalIds()->getEANs() != null)
			foreach($result->getItemInfo()->getExternalIds()->getEANs()->getDisplayValues() as $ean) {
				if($ean_full != '')
					$ean_full .= ',';

				$ean_full .= $ean;
			}
		$myproduct->ean = $ean_full;

		$category = '';
        foreach($result->getBrowseNodeInfo()->getBrowseNodes() as $bnw) {
	            $category .= $this->getBrowseNodeTree( $bnw->getAncestor() );
	            break;
            }

		$myproduct->productgroup = $category;

		if (   $result->getItemInfo()->getProductInfo() &&  $result->getItemInfo()->getProductInfo()->getReleaseDate()) {
			$myproduct->releasedate =substr($result->getItemInfo()->getProductInfo()->getReleaseDate()->getDisplayValue(), 0, 10);
		}
		if($result->getItemInfo()->getByLineInfo() != null && $result->getItemInfo()->getByLineInfo()->getContributors() != null) {
			foreach ( $result->getItemInfo()->getByLineInfo()->getContributors() as $const ) {
				if ( $const->getRole() == 'Autor' ) {
					$myproduct->author = $const->getName();
					break;
				}
			}
		}

		if ( $result->getItemInfo()->getContentInfo() != null && $result->getItemInfo()->getContentInfo()->getPagesCount() != null ) {
			$myproduct->numberofpages = $result->getItemInfo()->getContentInfo()->getPagesCount()->getDisplayValue();
		}

		$myproduct->mpn = '';
		if ( $result->getItemInfo()->getManufactureInfo() != null && $result->getItemInfo()->getManufactureInfo()->getItemPartNumber() != null) {
			$myproduct->mpn = $result->getItemInfo()->getManufactureInfo()->getItemPartNumber()->getDisplayValue();
		}


		if ( count( $myproduct->variations ) > 0 && $myproduct->salepricefloat == 0 ) {
			foreach ( $myproduct->variations as $variation ) {

				if ( $variation->salepricefloat > 0 ) {

					$myproduct->listprice   = $variation->listprice;
					$myproduct->amountsaved = $variation->amountsaved;
					$myproduct->saleprice   = $variation->saleprice;

					$myproduct->listpricefloat   = $variation->listpricefloat;
					$myproduct->amountsavedfloat = $variation->amountsavedfloat;
					$myproduct->percentagesaved  = $variation->percentagesaved;
					$myproduct->salepricefloat   = $variation->salepricefloat;
					$myproduct->shippingfloat    = $variation->shippingfloat;

					$myproduct->availability = $variation->availability;
					$myproduct->shipping     = $variation->shipping;
					$myproduct->isprime      = $variation->isprime;

					$myproduct->smallimageurl  = $variation->smallimageurl;
					$myproduct->mediumimageurl = $variation->mediumimageurl;
					$myproduct->largeimageurl  = $variation->largeimageurl;
					break;
				}
			}
		}


		//xx



		if ( count( $myproduct->variations ) > 0 && $myproduct->salepricefloat == 0 ) {
			foreach ( $myproduct->variations as $variation ) {

				if ( $variation->salepricefloat > 0 ) {

					$myproduct->listprice   = $variation->listprice;
					$myproduct->amountsaved = $variation->amountsaved;
					$myproduct->saleprice   = $variation->saleprice;

					$myproduct->listpricefloat   = $variation->listpricefloat;
					$myproduct->amountsavedfloat = $variation->amountsavedfloat;
					$myproduct->percentagesaved  = $variation->percentagesaved;
					$myproduct->salepricefloat   = $variation->salepricefloat;
					$myproduct->shippingfloat    = $variation->shippingfloat;

					$myproduct->availability = $variation->availability;
					$myproduct->shipping     = $variation->shipping;
					$myproduct->isprime      = $variation->isprime;

					$myproduct->smallimageurl  = $variation->smallimageurl;
					$myproduct->mediumimageurl = $variation->mediumimageurl;
					$myproduct->largeimageurl  = $variation->largeimageurl;
					break;
				}
			}
		}


		//echo serialize($result);exit;
		//echo serialize($myproduct);exit;
		return $myproduct;
    }

	/**
	 * Sets itemIdType
	 *
	 * @param \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\BrowseNodeAncestor $browsenodeinfo
	 *
	 * @return string $result
	 */
    private function getBrowseNodeTree($browsenodeancestor) {
        if($browsenodeancestor == null)
            return '';
	    $result ='';

	    if($browsenodeancestor->getAncestor() != null)
                $result .=  ($this->getBrowseNodeTree($browsenodeancestor->getAncestor())).' > ';

	    $result .= $browsenodeancestor->getDisplayName();

	    return $result;
    }

	private function fill_product_v4( $result, $parentResult = null ) {
		$myproduct            = new atkp_product();
		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		//store the ASIN code in case we need it
		$myproduct->asin       = $result->ASIN;
		$myproduct->parentasin = $result->ParentASIN;
		$variations            = array();
		$dimmension            = array();

		if ( isset( $result->Variations->Item ) ) {
			$vars = array();
			if ( is_array( $result->Variations->Item ) ) {
				$vars = $result->Variations->Item;
			} else {
				array_push( $vars, $result->Variations->Item );
			}


			if ( is_array( $result->Variations->VariationDimensions->VariationDimension ) ) {
				foreach ( $result->Variations->VariationDimensions->VariationDimension as $tmp ) {
					$dimmension[ $tmp ] = apply_filters( 'atkp_variation_name', $tmp );
				}
			} else {
				$tmp                = $result->Variations->VariationDimensions->VariationDimension;
				$dimmension[ $tmp ] = apply_filters( 'atkp_variation_name', $tmp );
			}

			foreach ( $vars as $varationItem ) {

				$myprd        = $this->fill_product_v4( $varationItem, $result );
				$dimmfullname = array();
				foreach ( $dimmension as $dimmy => $caption ) {
					if ( isset( $varationItem->ItemAttributes->$dimmy ) ) {
						$dimmfullname[ $dimmy ] = $varationItem->ItemAttributes->$dimmy;
					} else {
						$dimmfullname[ $dimmy ] = '';
					}
				}

				$myprd->variationname = $dimmfullname;
				array_push( $variations, $myprd );
			}
		}
		$myproduct->variationname = $dimmension;
		$myproduct->variations    = $variations;

		if ( isset( $result->DetailPageURL ) ) {
			$myproduct->producturl = urldecode( $result->DetailPageURL );
			//für 100% im titel - replace muss geklärt werden..
			$myproduct->producturl = str_replace( '%', '%25', $myproduct->producturl );

			$myproduct->addtocarturl = $this->checkurl( 'http://www.amazon.' . $this->country . '/gp/aws/cart/add.html?AWSAccessKeyId=' . $this->accessKey . '&AssociateTag=' . $this->associateTag . '&ASIN.1=' . $myproduct->asin . '&Quantity.1=1' );
		} else if ( $parentResult != null && isset( $parentResult->DetailPageURL ) ) {

			$myproduct->producturl = urldecode( $parentResult->DetailPageURL );
			//für 100% im titel - replace muss geklärt werden..
			$myproduct->producturl = str_replace( '%', '%25', $myproduct->producturl );

			$myproduct->producturl   = $this->checkurl( 'https://www.amazon.' . $this->country . '/dp/' . $myproduct->asin . '?tag=' . $this->associateTag );
			$myproduct->addtocarturl = $this->checkurl( 'https://www.amazon.' . $this->country . '/gp/aws/cart/add.html?AWSAccessKeyId=' . $this->accessKey . '&AssociateTag=' . $this->associateTag . '&ASIN.1=' . $parentResult->ASIN . '&Quantity.1=1' );

		} else {
			$myproduct->producturl   = '';
			$myproduct->addtocarturl = '';
		}

		//TODO: ssl untersützung der bilder implementieren: https://images-na.ssl-images-amazon.com statt http://ecx.images-amazon.com
		if ( isset( $result->SmallImage->URL ) ) {
			$myproduct->smallimageurl = $this->checkimageurl( $result->SmallImage->URL, 'small' );
		}
		if ( isset( $result->MediumImage->URL ) ) {
			$myproduct->mediumimageurl = $this->checkimageurl( $result->MediumImage->URL, 'medium' );
		}
		if ( isset( $result->LargeImage->URL ) ) {
			$myproduct->largeimageurl = $this->checkimageurl( $result->LargeImage->URL, 'large' );
		}

		if ( $this->load_customer_reviews ) {
			if ( $result->CustomerReviews->HasReviews ) {
				$averageRating = 0;
				$totalReviews  = 0;

				$this->get_customer_rating( $myproduct->asin, $averageRating, $totalReviews );

				$myproduct->rating      = $averageRating;
				$myproduct->reviewcount = $totalReviews;

			} else {
				$myproduct->rating      = 0;
				$myproduct->reviewcount = 0;
			}
		}

		$myproduct->customerreviewurl = $this->checkurl( 'http://www.amazon.' . $this->country . '/product-reviews/' . $myproduct->asin . '/?tag=' . $this->associateTag );

		//$myproduct->reviewsurl = $result->CustomerReviews->IFrameURL;

		$description = '';
		if ( isset( $result->EditorialReviews->EditorialReview ) ) {
			if ( isset( $result->EditorialReviews->EditorialReview->Content ) ) {
				$description = $result->EditorialReviews->EditorialReview->Content;
			} elseif ( sizeof( $result->EditorialReviews->EditorialReview ) > 0 ) {
				foreach ( $result->EditorialReviews->EditorialReview as $tmp ) {
					if ( isset( $description ) && strlen( $description ) < strlen( $tmp->Content ) ) {
						$description = $tmp->Content;
					}
				}
			}
		}

		$description = ( isset( $description ) ) ? $description : '';
		$features    = '';
		if ( isset( $result->ItemAttributes->Feature ) ) {
			if ( is_array( $result->ItemAttributes->Feature ) && sizeof( $result->ItemAttributes->Feature ) > 0 ) {
				foreach ( $result->ItemAttributes->Feature as $feature ) {
					$features .= '<li>' . $feature . '</li>';
				}
			}
		}

		$myproduct->features    = $features == '' ? '' : '<ul>' . $features . '</ul>';
		$myproduct->description = $description;
		$myproduct->title       = isset( $result->ItemAttributes ) ? htmlentities( $result->ItemAttributes->Title ) : '';

		//preise laden
		if ( isset( $result->ItemAttributes->ListPrice->FormattedPrice ) ) {
			$myproduct->listprice = $result->ItemAttributes->ListPrice->FormattedPrice;
		}

		if ( $myproduct->listprice == '' && isset( $result->Offers->Offer->OfferListing->Price->FormattedPrice ) ) {
			$myproduct->listprice = $result->Offers->Offer->OfferListing->Price->FormattedPrice;
		}

		if ( isset( $result->Offers->Offer->OfferListing->Price->FormattedPrice ) ) {
			$myproduct->saleprice = $result->Offers->Offer->OfferListing->Price->FormattedPrice;
		}

		$infosset = false;
		if ( isset( $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice ) ) {
			$myproduct->saleprice = $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice;
		}


		//http://docs.aws.amazon.com/AWSECommerceService/latest/DG/RG_VariationOffers.html#RG_VariationOffers-rest
		if ( isset( $result->Variations->Item->Offers ) ) {
			foreach ( $result->Variations->Item->Offers as $offerVariation ) {

				if ( isset( $offerVariation->OfferListing->Price->FormattedPrice ) ) {
					$myproduct->listprice = '';
					$myproduct->saleprice = $offerVariation->OfferListing->Price->FormattedPrice;

					if ( isset( $offerVariation->OfferListing->IsEligibleForPrime ) ) {
						$myproduct->isprime = $offerVariation->OfferListing->IsEligibleForPrime;
					}

					if ( isset( $offerVariation->OfferListing->Availability ) ) {
						$myproduct->availability = $offerVariation->OfferListing->Availability;
					}

					if ( isset( $offerVariation->OfferListing->PercentageSaved ) ) {
						$myproduct->percentagesaved = $offerVariation->OfferListing->PercentageSaved;
					}

					if ( isset( $offerVariation->OfferListing->AmountSaved->FormattedPrice ) ) {
						$myproduct->amountsaved = $offerVariation->OfferListing->AmountSaved->FormattedPrice;
					}

					$infosset = true;
					break;
				}
			}
		}

		if ( ! $infosset ) {
			if ( isset( $result->Offers->Offer->OfferListing->AmountSaved->FormattedPrice ) ) {
				$myproduct->amountsaved = $result->Offers->Offer->OfferListing->AmountSaved->FormattedPrice;
			}
			if ( isset( $result->Offers->Offer->OfferListing->PercentageSaved ) ) {
				$myproduct->percentagesaved = $result->Offers->Offer->OfferListing->PercentageSaved;
			}

			if ( isset( $result->Offers->Offer->OfferListing->Availability ) ) {
				$myproduct->availability = $result->Offers->Offer->OfferListing->Availability;
			}
			if ( isset( $result->Offers->Offer->OfferListing->IsEligibleForPrime ) ) {
				$myproduct->isprime = $result->Offers->Offer->OfferListing->IsEligibleForPrime;
			}
		}

		if ( isset( $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice ) && $myproduct->saleprice == '' ) {

			$myproduct->saleprice       = $result->Offers->Offer->OfferListing->SalePrice->FormattedPrice;
			$myproduct->listprice       = '';
			$myproduct->percentagesaved = '';
		}


		if ( isset( $result->Offers->Offer->OfferListing->Price->FormattedPrice ) && $myproduct->saleprice == '' ) {

			$myproduct->saleprice       = $result->Offers->Offer->OfferListing->Price->FormattedPrice;
			$myproduct->listprice       = '';
			$myproduct->percentagesaved = '';
		}


		//TODO: lowestnew liefert völlig sinnlose preise welche keinerlei gütligtkeit haben
		if ( isset( $result->OfferSummary->LowestNewPrice ) && $myproduct->saleprice == '' ) {

			$myproduct->saleprice       = $result->OfferSummary->LowestNewPrice->FormattedPrice;
			$myproduct->listprice       = '';
			$myproduct->percentagesaved = '';
		}
		if ( isset( $result->OfferSummary->LowestNewPrice->FormattedPrice ) ) {
			$myproduct->lowestnewprice = $result->OfferSummary->LowestNewPrice->FormattedPrice;
		}
		if ( isset( $result->OfferSummary->TotalNew ) ) {
			$myproduct->totalnew = $result->OfferSummary->TotalNew;
		}

		if ( $myproduct->listprice == '' ) {
			$myproduct->amountsaved = '';
		}

		$myproduct->salepricefloat   = $this->price_to_float( $myproduct->saleprice );
		$myproduct->amountsavedfloat = $this->price_to_float( $myproduct->amountsaved );
		$myproduct->listpricefloat   = $this->price_to_float( $myproduct->listprice );
		$myproduct->shippingfloat    = (float) 0;


		if ( isset( $result->ItemAttributes->Manufacturer ) ) {
			$myproduct->manufacturer = $result->ItemAttributes->Manufacturer;
		}
		if ( isset( $result->ItemAttributes->Brand ) ) {
			$myproduct->brand = $result->ItemAttributes->Brand;
		}

		if ( isset( $result->ItemAttributes->ISBN ) ) {
			$myproduct->isbn = $result->ItemAttributes->ISBN;
		}

		if ( isset( $result->ItemAttributes->ProductGroup ) ) {
			$myproduct->productgroup = $result->ItemAttributes->ProductGroup;
		}

		if ( isset( $result->ItemAttributes->ReleaseDate ) ) {
			$myproduct->releasedate = $result->ItemAttributes->ReleaseDate;
		}


		if ( isset( $result->ItemAttributes->Author ) ) {
			if ( is_array( $result->ItemAttributes->Author ) ) {
				$myproduct->author = implode( ', ', $result->ItemAttributes->Author );
			} else {
				$myproduct->author = $result->ItemAttributes->Author;
			}
		}
		if ( isset( $result->ItemAttributes->NumberOfPages ) ) {
			$myproduct->numberofpages = $result->ItemAttributes->NumberOfPages;
		}

		$myproduct->mpn = '';
		if ( isset( $result->ItemAttributes->ItemPartNumber ) ) {
			$myproduct->mpn = $result->ItemAttributes->ItemPartNumber;
		}

		$myproduct->ean = '';
		if ( isset( $result->ItemAttributes->EAN ) ) {
			$myproduct->ean = $result->ItemAttributes->EAN;
		}

		if ( isset( $result->ItemAttributes->EANList ) && isset( $result->ItemAttributes->EANList->EANListElement ) ) {
			$newean = '';
			if ( is_array( $result->ItemAttributes->EANList->EANListElement ) || is_object( $result->ItemAttributes->EANList->EANListElement ) ) {
				foreach ( $result->ItemAttributes->EANList->EANListElement as $eanitem ) {

					if ( $newean == '' ) {
						$newean = $eanitem;
					} else {
						$newean .= ',' . $eanitem;
					}
				}
			}

			if ( $newean != '' ) {
				$myproduct->ean = $newean;
			}
		}

		$myproduct->imagesurl      = '';
		$myproduct->thumbimagesurl = '';

		$images = array();

		//if(is_array($result->ImageSets->ImageSet))

		//echo serialize($result->ImageSets->ImageSet);
		if ( isset( $result->ImageSets->ImageSet ) ) {
			foreach ( $result->ImageSets->ImageSet as $i => $image ) {
				if ( ! isset( $image->SmallImage->URL ) && ! isset( $image->MediumImage->URL ) && ! isset( $image->LargeImage->URL ) ) {
					continue;
				}
				$udf     = new atkp_product_image();
				$udf->id = uniqid();
				if ( isset( $image->SmallImage->URL ) ) {
					$udf->smallimageurl = $this->checkimageurl( $image->SmallImage->URL, 'small' );
				}
				if ( isset( $image->MediumImage->URL ) ) {
					$udf->mediumimageurl = $this->checkimageurl( $image->MediumImage->URL, 'medium' );
				}
				if ( isset( $image->LargeImage->URL ) ) {
					$udf->largeimageurl = $this->checkimageurl( $image->LargeImage->URL, 'large' );
				}

				array_push( $images, $udf );
			}
		}


		$myproduct->images = $images;

		if ( count( $myproduct->variations ) > 0 && $myproduct->salepricefloat == 0 ) {
			foreach ( $myproduct->variations as $variation ) {

				if ( $variation->salepricefloat > 0 ) {

					$myproduct->listprice   = $variation->listprice;
					$myproduct->amountsaved = $variation->amountsaved;
					$myproduct->saleprice   = $variation->saleprice;

					$myproduct->listpricefloat   = $variation->listpricefloat;
					$myproduct->amountsavedfloat = $variation->amountsavedfloat;
					$myproduct->percentagesaved  = $variation->percentagesaved;
					$myproduct->salepricefloat   = $variation->salepricefloat;
					$myproduct->shippingfloat    = $variation->shippingfloat;

					$myproduct->availability = $variation->availability;
					$myproduct->shipping     = $variation->shipping;
					$myproduct->isprime      = $variation->isprime;

					$myproduct->smallimageurl  = $variation->smallimageurl;
					$myproduct->mediumimageurl = $variation->mediumimageurl;
					$myproduct->largeimageurl  = $variation->largeimageurl;
					break;
				}
			}
		}


		//echo serialize($result);exit;
		//echo serialize($myproduct);exit;
		return $myproduct;

	}


	private function get_customer_rating( $asin, &$averageRating, &$totalReviews ) {
		try {

			$url    = 'https://www.amazon.' . $this->country . '/product-reviews/' . $asin;
			$rating = false;

			if ( function_exists( 'wp_remote_get' ) ) {

				$response   = wp_remote_get( $url, array(
					'timeout'    => 20,
					'user-agent' => ATKPTools::get_user_agent()
				) );
				$statusCode = null;

				if ( function_exists( 'is_wp_error' ) && ! is_wp_error( $response ) ) {

					// Success
					if ( isset( $response['response']['code'] ) ) {
						$statusCode = $response['response']['code'];
					}

					if ( '200' == $statusCode ) {
						$page = $response['body'];
					}
				}
			}

			if ( ! empty ( $page ) ) {
				$rating = $this->scrape_customer_rating( $page, $averageRating, $totalReviews );
			}

			if ( $rating === false ) {

				//echo '2nd try!<br>';

				if ( ini_get( 'allow_url_fopen' ) ) {

					try {
						// Trying to use file_get_contents
						$opts    = array(
							'http' => array(
								'header'        => 'Connection: close',
								'ignore_errors' => true
							)
						);
						$context = stream_context_create( $opts );
						@$page = file_get_contents( $url, false, $context );

						$rating = $this->scrape_customer_rating( $page, $averageRating, $totalReviews );

					} catch ( Exception $ex ) {
						// Do nothing
					}
				}
			}

		} catch ( Exception $e ) {
//			echo 'Error: ' .$e->getMessage();
		}
	}

	public function scrape_customer_rating( $page, &$averageRating, &$totalReviews ) {
		if ( ! class_exists( 'simple_html_dom' ) ) {
			require_once ATKP_PLUGIN_DIR . '/lib/simple_html_dom.php';
		}

		$html = new simple_html_dom();

		$html->load( $page );

		if ( ! $html ) {
			return false;
		}

		// Reviews
		$label_reviews = $html->find( 'span.totalReviewCount', 0 );
		$label_reviews = ( isset( $label_reviews->plaintext ) ) ? $label_reviews->plaintext : 0;
		$label_reviews = preg_replace( "/[^0-9]/", "", $label_reviews );

		if ( '0' == $label_reviews ) {
			$averageRating = 0;
			$totalReviews  = 0;

			return true;
		}

		if ( is_numeric( $label_reviews ) ) {
			$totalReviews = intval( $label_reviews );
		}

		// Rating
		$label_rating = $html->find( 'div.averageStarRatingNumerical', 0 );
		$label_rating = ( isset( $label_rating->plaintext ) ) ? $label_rating->plaintext : 0;

		if ( ! empty( $label_rating ) ) {

			$label_rating_parts = explode( ' ', $label_rating );

			if ( ! empty( $label_rating_parts[0] ) ) {
				$label_rating  = str_replace( ',', '.', $label_rating_parts[0] );
				$averageRating = $label_rating;

				return true;
			}
		}

		// Return
		return false;
	}


	public function get_supportedlistsources() {
        if($this->usev5)
            return '10,11,20,30';
        else
	    	return '10,11,20,30,40';
	}

	private function retrieve_list_v4( $requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters ) {

		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();
		$mylist->products  = null;

		switch ( $requestType ) {
			case 'Similarity':
				$search = new ApaiIO\Operations\SimilarityLookup();
				$search->setPage( 1 );
				if ( $rootCategory == '' ) {
					$search->setCategory( 'All' );
				} else {
					$search->setCategory( $rootCategory );
				}

				$search->setItemId( $asin );

				try {
					$response = $this->helper->runOperation( $search );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				} catch ( GuzzleHttp\Exception\ClientException $e ) {
					$response = $e->getResponse();
					if ( isset( $response ) ) {
						$check = $response->getBody();
					} else {
						$check = $e->getMessage();
					}
				} catch ( Exception $e ) {
					$check = $e->getMessage();
				}

				//falls fehler aufgetreten ist, 2. versuch
				if ( ! empty( $check ) ) {
					sleep( 3 );
					$response = $this->helper->runOperation( $search );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				}

				if ( ! empty( $check ) ) {
					throw new Exception( $check );
				}

				if ( isset( $response->Items->Item ) ) {

					if ( isset( $response->Items->MoreSearchResultsUrl ) ) {
						$mylist->listurl = $response->Items->MoreSearchResultsUrl;
					}

					//loop through each item
					foreach ( $response->Items->Item as $result ) {

						//check that there is a ASIN code - for some reason, some items are not
						//correctly listed. Im sure there is a reason for it, need to check.
						if ( isset( $result->ASIN ) ) {
							array_push( $mylist->asins, $result->ASIN );
						}
					}
				}
				break;
			case 'TopSellers':
				$browseNodeLookup = new ApaiIO\Operations\BrowseNodeLookup();
				$browseNodeLookup->setNodeId( intval( $rootCategory ) );
				$browseNodeLookup->setResponseGroup( array( 'TopSellers' ) );

				try {
					$response = $this->helper->runOperation( $browseNodeLookup );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				} catch ( GuzzleHttp\Exception\ClientException $e ) {
					$response = $e->getResponse();
					if ( isset( $response ) ) {
						$check = $response->getBody();
					} else {
						$check = $e->getMessage();
					}
				} catch ( Exception $e ) {
					$check = $e->getMessage();
				}

				//falls fehler aufgetreten ist, 2. versuch
				if ( ! empty( $check ) ) {
					sleep( 3 );
					$response = $this->helper->runOperation( $browseNodeLookup );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				}

				if ( ! empty( $check ) ) {
					throw new Exception( $check );
				}

				if ( isset( $response->BrowseNodes ) && isset( $response->BrowseNodes->BrowseNode ) ) {

					$mylist->browsenodename = $response->BrowseNodes->BrowseNode->Name;
					if ( isset( $response->BrowseNodes->BrowseNode->TopSellers ) ) {
						$response = $response->BrowseNodes->BrowseNode->TopSellers->TopSeller;

						if ( is_array( $response ) ) {
							foreach ( $response as $item ) {
								array_push( $mylist->asins, $item->ASIN );
							}
						}
					}

				}
				break;
			case 'NewReleases':
				$browseNodeLookup = new ApaiIO\Operations\BrowseNodeLookup();
				$browseNodeLookup->setNodeId( intval( $rootCategory ) );
				$browseNodeLookup->setResponseGroup( array( 'NewReleases' ) );

				try {
					$response = $this->helper->runOperation( $browseNodeLookup );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				} catch ( GuzzleHttp\Exception\ClientException $e ) {
					$response = $e->getResponse();
					if ( isset( $response ) ) {
						$check = $response->getBody();
					} else {
						$check = $e->getMessage();
					}
				} catch ( Exception $e ) {
					$check = $e->getMessage();
				}

				//falls fehler aufgetreten ist, 2. versuch
				if ( ! empty( $check ) ) {
					sleep( 3 );
					$response = $this->helper->runOperation( $browseNodeLookup );
					$response = $this->convert_response( $response );

					$check = $this->checkResponse( $response );
				}

				if ( ! empty( $check ) ) {
					throw new Exception( $check );
				}

				if ( isset( $response->BrowseNodes ) && isset( $response->BrowseNodes->BrowseNode ) ) {

					$mylist->browsenodename = $response->BrowseNodes->BrowseNode->Name;

					if ( isset( $response->BrowseNodes->BrowseNode->NewReleases->NewRelease ) ) {
						$response = $response->BrowseNodes->BrowseNode->NewReleases->NewRelease;

						if ( is_array( $response ) ) {
							foreach ( $response as $item ) {
								array_push( $mylist->asins, $item->ASIN );
							}
						}
					}
				}
				break;
			case 'ExtendedSearch':
			case 'Search':
				$search = new ApaiIO\Operations\Search();
				if ( $rootCategory == '' ) {
					$search->setCategory( 'All' );
				} else {
					$search->setCategory( $rootCategory );
				}

				//Page: Valid values: 1 to 10 (1 to 5 when search index is All)
				//if ( $rootCategory == '' || $rootCategory == 'All' ) {
                //	if ( $maxCount > 50 ) {
                //			$maxCount = 50;
                //		}
                //	}

				$search->setResponseGroup( array( 'Large', 'Variations', 'OfferFull', 'Variations' ) );

				if ( $rootCategory != '' && $rootCategory != 'All' && $sortorder != '' ) {
					$search->setSort( $sortorder );
				}

				if ( $filters != null ) {
					foreach ( $filters as $field => $value ) {
						if ( $field == 'Keywords' ) {
							$keyword = $value;
						} else if ( $field == 'SearchIndex' ) {
							$search->setCategory( $value );
						} else {
							$search->setOperationParameter( $field, $value );
						}
					}
				}

				$keywords = explode(',', $keyword);
				if($keywords !=null && count($keywords) > 1)
                    $search->setKeywords( $keywords );
                else
                    $search->setKeywords( $keyword );


				$products = array();

                $itemsperpage = 10;
                $itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

                $pages = ceil($maxCount / $itemsperpage);

                for ($x = 1; $x <= $pages; $x++) {

	                $search->setPage( $x );

	                try {
		                $response = $this->helper->runOperation( $search );
		                $response = $this->convert_response( $response );

		                $check = $this->checkResponse( $response );
	                } catch ( GuzzleHttp\Exception\ClientException $e ) {
		                $response = $e->getResponse();
		                if ( isset( $response ) ) {
			                $check = $response->getBody();
		                } else {
			                $check = $e->getMessage();
		                }
	                } catch ( Exception $e ) {
		                $check = $e->getMessage();
	                }

	                //falls fehler aufgetreten ist, 2. versuch
	                if ( ! empty( $check ) ) {
		                sleep( 3 );
		                $response = $this->helper->runOperation( $search );
		                $response = $this->convert_response( $response );

		                $check = $this->checkResponse( $response );
	                }

	                if ( ! empty( $check ) ) {
		                throw new Exception( $check );
	                }


	                //check that there are items in the response

                    if(isset($response->Items))
                        $mylist->listurl = $response->Items->MoreSearchResultsUrl;

                    $items = array();
                    if( isset( $response->Items->Item )) {
                        if ( is_array( $response->Items->Item ) ) {
                            $items = $response->Items->Item;
                        } else {
                            array_push( $items, $response->Items->Item );
                        }
                    }

                    //loop through each item
                    foreach ( $items as $result ) {
                        //check that there is a ASIN code - for some reason, some items are not
                        //correctly listed. Im sure there is a reason for it, need to check.
                        if ( isset( $result->ASIN ) ) {
                            array_push( $mylist->asins, $result->ASIN );

                            $myproduct = $this->fill_product_v4( $result );

                            array_push( $products, $myproduct );
                        }

                        if ( count( $products ) >= $maxCount ) {
                            break;
                        }
                    }

                    if(count($items) == 0 || count($products) >= $maxCount)
                        break;

                }

				$mylist->products = $products;
				break;
			default:
				throw new Exception( 'unknown requestType: ' . $requestType );
				break;
		}

		if ( $mylist->products == null && count( $mylist->asins ) > 0 ) {
			//wenn produkte nicht direkt geladen, dann nachladen
			$response = $this->retrieve_products( $mylist->asins, 'ASIN' );

			$products = array();
			foreach ( $response->responseitems as $responseitem ) {
				array_push( $products, $responseitem->productitem );
			}
			$mylist->products = $products;
		}

		return $mylist;
	}

	private function sendSearchRequest($searchItemsRequest) {
		$this->validate_request_v5( $searchItemsRequest );

		try {
			$searchItemsResponse = $this->helper->searchItems( $searchItemsRequest );
		} catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
		    if(ATKPTools::str_contains($exception->getMessage(), '429 Too Many Requests', false)) {

		        sleep(5);
			    $searchItemsResponse = $this->helper->searchItems( $searchItemsRequest );
		    } else {
			    throw $exception;
		    }
        }

		$this->validate_response_v5( $searchItemsResponse );

		return $searchItemsResponse;
    }


	private function sendGetItemsRequest($getItemsRequest) {
		$this->validate_request_v5( $getItemsRequest );

        try {
                $getItemsResponse = $this->helper->getItems( $getItemsRequest );
        } catch (Amazon\ProductAdvertisingAPI\v1\ApiException $exception) {
            if(ATKPTools::str_contains($exception->getMessage(), '429 Too Many Requests', false)) {
                sleep(5);
	            $getItemsResponse = $this->helper->getItems( $getItemsRequest );
            } else {
	            throw $exception;
            }
        }

		$this->validate_response_v5( $getItemsResponse );

		return $getItemsResponse;
	}

	private function retrieve_list_v5($requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();
		$mylist->products  = null;

		switch ( $requestType ) {
			case 'TopSellers':
			case 'NewReleases':

                $searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
                //$searchItemsRequest->setSearchIndex( 'All' );
                $searchItemsRequest->setSortBy($requestType == 'TopSellers' ? 'Featured' : 'NewestArrivals');

    			$searchItemsRequest->setBrowseNodeId( $rootCategory );
			    $searchItemsRequest->setKeywords("*");

                $searchItemsRequest->setPartnerTag( $this->associateTag );
                $searchItemsRequest->setPartnerType( Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
                $searchItemsRequest->setResources(
                    \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsResource::getAllowableEnumValues()
                );

                $searchItemsRequest->setItemCount( 10 );
                $searchItemsRequest->setItemPage( 1 );

			    $searchItemsResponse = $this->sendSearchRequest( $searchItemsRequest );

			    $products = array();
                if ( $searchItemsResponse->getSearchResult() != null && $searchItemsResponse->getSearchResult()->getItems() != null ) {
                    $items = $searchItemsResponse->getSearchResult()->getItems();

                    foreach($items as $item) {
                        if($item->getASIN() != null) {
                            $myproduct = $this->fill_product_v5( $item );
                            array_push( $products, $myproduct );
                        }
                    }
                }

                $mylist->products = $products;
			    break;
			case 'ExtendedSearch':
			case 'Search':

                $searchItemsRequest = new Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsRequest();
                if ( $rootCategory == '' ) {
                    $searchItemsRequest->setSearchIndex( 'All' );
                } else {
                    $searchItemsRequest->setSearchIndex( $rootCategory );
                }

                if ( $rootCategory != '' && $rootCategory != 'All' && $sortorder != '' ) {
                    //AvgCustomerReviews', 'Featured', 'NewestArrivals', 'Price:HighToLow', 'Price:LowToHigh', 'Relevance

                    switch($sortorder) {
	                    case '-pubdate':
	                    case '-publication_date':
                        case 'date-desc-rank':
	                    case 'launch_date':
	                        $sortorder= 'NewestArrivals';
                            break;
	                    case 'popularity-rank':
	                    case 'relevancerank':
	                    case 'salesrank':
	                    case 'psrank':
	                    case 'titlerank':
	                    case '-titlerank':
	                    case '-unit-sales':
                        default:
	                        $sortorder= 'Relevance';
	                        break;
	                    case 'reviewrank':
	                    case 'pmrank':
	                    case 'reviewrank_authority':
	                    case 'review-rank':
		                    $sortorder= 'AvgCustomerReviews';
	                        break;
	                    case 'price':
	                    case 'price-asc-rank':
	                    case 'pricerank':
		                    $sortorder= 'Price:LowToHigh';
	                        break;
	                    case '-price':
	                    case 'price-desc-rank':
	                    case 'inverse-pricerank':
		                    $sortorder= 'Price:HighToLow';
		                    break;
	                    case 'featured':
		                    $sortorder= 'Featured';
	                        break;
	                    case 'AvgCustomerReviews':
	                    case 'Featured':
	                    case 'NewestArrivals':
	                    case 'Price:HighToLow':
	                    case 'Price:LowToHigh':
	                    case 'Relevance':
                            break;
                    }


                    $searchItemsRequest->setSortBy($sortorder);
                }
                //TODO: Filterfelder ergänzen
                if ( $filters != null ) {
                    foreach ( $filters as $field => $value ) {
                        switch($field) {
                            case 'Keywords':
	                            $keyword =$value;
                                break;
	                        case 'SearchIndex':
		                        $searchItemsRequest->setSearchIndex($value);
		                        break;
	                        case 'Sort':
		                        $searchItemsRequest->setSortBy($value);
		                        break;
	                        case 'Actor':
		                        $searchItemsRequest->setActor($value);
		                        break;
	                        case 'Artist':
		                        $searchItemsRequest->setArtist($value);
		                        break;
	                        case 'Author':
		                        $searchItemsRequest->setAuthor($value);
		                        break;
	                        case 'Availability':
		                        $searchItemsRequest->setAvailability($value);
		                        break;
	                        case 'Brand':
		                        $searchItemsRequest->setBrand($value);
		                        break;
	                        case 'Condition':
		                        $searchItemsRequest->setCondition($value);
		                        break;
	                        case 'DeliveryFlags':
		                        $searchItemsRequest->setDeliveryFlags($value);
		                        break;
	                        case 'CurrencyOfPreference':
		                        $searchItemsRequest->setCurrencyOfPreference($value);
		                        break;
	                        case 'LanguagesOfPreference':
		                        $searchItemsRequest->setLanguagesOfPreference($value);
		                        break;
	                        case 'Marketplace':
		                        $searchItemsRequest->setMarketplace($value);
		                        break;
	                        case 'MaximumPrice':
		                        $searchItemsRequest->setMaxPrice($value);
		                        break;
	                        case 'MinimumPrice':
		                        $searchItemsRequest->setMinPrice($value);
		                        break;
	                        case 'MerchantId':
		                        $searchItemsRequest->setMerchant($value);
		                        break;
	                        case 'MinPercentageOff':
		                        $searchItemsRequest->setMinSavingPercent($value);
		                        break;
	                        case 'MinReviewsRating':
		                        $searchItemsRequest->setMinReviewsRating($value);
		                        break;
	                        case 'Title':
		                        $searchItemsRequest->setTitle($value);
		                        break;
                        }
                    }
                }

                if($keyword != '') {
	                $keywords = explode( ',', $keyword );
	                if ( $keywords != null && count( $keywords ) > 1 ) {
		                $searchItemsRequest->setKeywords( $keywords );
	                } else {
		                $searchItemsRequest->setKeywords( $keyword );
	                }
                }

                $searchItemsRequest->setPartnerTag( $this->associateTag );
                $searchItemsRequest->setPartnerType( Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType::ASSOCIATES );
                $searchItemsRequest->setResources(
                    \Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\SearchItemsResource::getAllowableEnumValues()
                );

                $itemsperpage = 10;
                $itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;
			    $pages = ceil($maxCount / $itemsperpage);

			    $searchItemsRequest->setItemCount( $itemsperpage );

			    $products = array();
                for ($x = 1; $x <= $pages; $x++) {
                    $searchItemsRequest->setItemPage( $x );

	                $searchItemsResponse = $this->sendSearchRequest( $searchItemsRequest );

                    if ( $searchItemsResponse->getSearchResult() != null && $searchItemsResponse->getSearchResult()->getItems() != null ) {
                        $items = $searchItemsResponse->getSearchResult()->getItems();

                        foreach($items as $item) {
                            if($item->getASIN() != null) {
	                            $myproduct = $this->fill_product_v5( $item );
	                            array_push( $products, $myproduct );
                            }
                        }
                    }
                }

			    $mylist->products = $products;

			    break;
			case 'Similarity':
			default:
				throw new Exception( 'unknown requestType: ' . $requestType );
				break;
		}


		if ( $mylist->products == null && count( $mylist->asins ) > 0 ) {
			//wenn produkte nicht direkt geladen, dann nachladen
			$response = $this->retrieve_products( $mylist->asins, 'ASIN' );

			$products = array();
			foreach ( $response->responseitems as $responseitem ) {
				array_push( $products, $responseitem->productitem );
			}
			$mylist->products = $products;
		}

		return $mylist;
    }

	public function retrieve_list( $requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		if($this->usev5) {
            try {
                $mylist = $this->retrieve_list_v5( $requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters );

            } catch  (Exception $exception) {

                if(ATKPTools::str_contains($exception->getMessage(), 'The request was denied due to request throttling.', false)) {
                    sleep(ATKP_AMZ_WAIT);
	                $mylist = $this->retrieve_list_v5( $requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters );

                } else
                    throw $exception;
            }
		}
		else
    		$mylist = $this->retrieve_list_v4( $requestType, $rootCategory, $keyword, $asin, $maxCount, $sortorder, $filters );

		return $mylist;
	}

}


?>