<?php

/*
 * This file is part of the affilinet Product Data PHP SDK.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Affilinet\ProductData\HttpClient;

use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

interface HttpClientInterface {

	/**
	 * Send an HTTP request.
	 *
	 * @param RequestInterface $request Request to send
	 * @param array $options Request options to apply to the given
	 *                                  request and to the transfer.
	 *
	 * @return ResponseInterface
	 * @throws \Exception
	 */
	public function send( RequestInterface $request, array $options = [] );

}
