<?php
/**
 * DO NOT EDIT THIS FILE!
 *
 * This file was automatically generated from external sources.
 *
 * Any manual change here will be lost the next time the SDK
 * is updated. You've been warned!
 */

namespace DTS\eBaySDK\Marketing\Services;

class MarketingService extends \DTS\eBaySDK\Marketing\Services\MarketingBaseService {
	const API_VERSION = 'v1';

	/**
	 * @property array $operations Associative array of operations provided by the service.
	 */
	protected static $operations = [
		'BulkCreateAdsByInventoryReference'    => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/bulk_create_ads_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'BulkCreateAdsByListingID'             => [
			'method'        => 'POST',
			'resource'      => 'campaign/{campaign_id}/bulk_create_ads_by_listing_id',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'BulkDeleteAdsByInventoryReference'    => [
			'method'        => 'POST',
			'resource'      => 'campaign/{campaign_id}/bulk_delete_ads_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'BulkDeleteAdsByListingID'             => [
			'method'        => 'POST',
			'resource'      => 'campaign/{campaign_id}/bulk_delete_ads_by_listing_id',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'BulkUpdateAdBidsByInventoryReference' => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/bulk_update_ads_bid_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'BulkUpdateAdBidsByListingID'          => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/bulk_update_ads_bid_by_listing_id',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CreateAdByListingID'                  => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/ad',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CreateAdsByInventoryReference'        => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/create_ads_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'DeleteAdByID'                         => [
			'method'        => 'DELETE',
			'resource'      => 'ad_campaign/{campaign_id}/ad/{ad_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestResponse',
			'params'        => [
				'ad_id'       => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'DeleteAdsByInventoryReference'        => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/delete_ads_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetAdByID'                            => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/{campaign_id}/ad/{ad_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetAdByIDRestResponse',
			'params'        => [
				'ad_id'       => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetAds'                               => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/{campaign_id}/ad',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetAdsRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'limit'       => [
					'valid' => [ 'string' ]
				],
				'listing_ids' => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'offset'      => [
					'valid' => [ 'string' ]
				]
			]
		],
		'GetAdsByInventoryReference'           => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/{campaign_id}/get_ads_by_inventory_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestResponse',
			'params'        => [
				'campaign_id'              => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'inventory_reference_id'   => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'inventory_reference_type' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'UpdateBid'                            => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/ad/{ad_id}/update_bid',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\UpdateBidRestResponse',
			'params'        => [
				'ad_id'       => [
					'valid'    => [ 'string' ],
					'required' => true
				],
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CloneCampaign'                        => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/clone',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\CloneCampaignRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CreateCampaign'                       => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\CreateCampaignRestResponse',
			'params'        => [
			]
		],
		'DeleteCampaign'                       => [
			'method'        => 'DELETE',
			'resource'      => 'ad_campaign/{campaign_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\DeleteCampaignRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'EndCampaign'                          => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/end',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\EndCampaignRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'FindCampaignByAdReference'            => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/find_campaign_by_ad_reference',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestResponse',
			'params'        => [
				'inventory_reference_id'   => [
					'valid' => [ 'string' ]
				],
				'inventory_reference_type' => [
					'valid' => [ 'string' ]
				],
				'listing_id'               => [
					'valid' => [ 'string' ]
				]
			]
		],
		'GetAllCampaigns'                      => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestResponse',
			'params'        => [
				'campaign_name'    => [
					'valid' => [ 'string' ]
				],
				'campaign_status'  => [
					'valid' => [ 'string' ]
				],
				'end_date_range'   => [
					'valid' => [ 'string' ]
				],
				'limit'            => [
					'valid' => [ 'string' ]
				],
				'offset'           => [
					'valid' => [ 'string' ]
				],
				'start_date_range' => [
					'valid' => [ 'string' ]
				]
			]
		],
		'GetCampaignByName'                    => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/get_campaign_by_name',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestResponse',
			'params'        => [
				'campaign_name' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetCampaignByID'                      => [
			'method'        => 'GET',
			'resource'      => 'ad_campaign/{campaign_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'PauseCampaign'                        => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/pause',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\PauseCampaignRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'ResumeCampaign'                       => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/resume',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\ResumeCampaignRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'UpdateCampaignIDentification'         => [
			'method'        => 'POST',
			'resource'      => 'ad_campaign/{campaign_id}/update_campaign_identification',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestResponse',
			'params'        => [
				'campaign_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'CreateItemPromotion'                  => [
			'method'        => 'POST',
			'resource'      => 'item_promotion',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestResponse',
			'params'        => [
			]
		],
		'DeleteItemPromotion'                  => [
			'method'        => 'DELETE',
			'resource'      => 'item_promotion/{promotion_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetItemPromotion'                     => [
			'method'        => 'GET',
			'resource'      => 'item_promotion/{promotion_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetItemPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'UpdateItemPromotion'                  => [
			'method'        => 'PUT',
			'resource'      => 'item_promotion/{promotion_id}',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetListingsInSpecificPromotion'       => [
			'method'        => 'GET',
			'resource'      => 'promotion/{promotion_id}/get_listing_set',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid' => [ 'string' ]
				],
				'limit'        => [
					'valid' => [ 'string' ]
				],
				'offset'       => [
					'valid' => [ 'string' ]
				],
				'q'            => [
					'valid' => [ 'string' ]
				],
				'sort'         => [
					'valid' => [ 'string' ]
				]
			]
		],
		'GetPromotions'                        => [
			'method'        => 'GET',
			'resource'      => 'promotion',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetPromotionsRestResponse',
			'params'        => [
				'limit'            => [
					'valid' => [ 'string' ]
				],
				'marketplace_id'   => [
					'valid' => [ 'string' ]
				],
				'offset'           => [
					'valid' => [ 'string' ]
				],
				'promotion_status' => [
					'valid' => [ 'string' ]
				],
				'q'                => [
					'valid' => [ 'string' ]
				],
				'sort'             => [
					'valid' => [ 'string' ]
				]
			]
		],
		'PauseAPromotion'                      => [
			'method'        => 'POST',
			'resource'      => 'promotion/{promotion_id}/pause',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\PauseAPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'ResumeAPromotion'                     => [
			'method'        => 'POST',
			'resource'      => 'promotion/{promotion_id}/resume',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestResponse',
			'params'        => [
				'promotion_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		],
		'GetPromotionSummaryReport'            => [
			'method'        => 'GET',
			'resource'      => 'promotion_summary_report',
			'responseClass' => '\DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestResponse',
			'params'        => [
				'marketplace_id' => [
					'valid'    => [ 'string' ],
					'required' => true
				]
			]
		]
	];

	/**
	 * @param array $config Configuration option values.
	 */
	public function __construct( array $config = [] ) {
		parent::__construct( $config );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestResponse
	 */
	public function bulkCreateAdsByInventoryReference( \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestRequest $request ) {
		return $this->bulkCreateAdsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkCreateAdsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'BulkCreateAdsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestResponse
	 */
	public function bulkCreateAdsByListingID( \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestRequest $request ) {
		return $this->bulkCreateAdsByListingIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkCreateAdsByListingIDAsync( \DTS\eBaySDK\Marketing\Types\BulkCreateAdsByListingIDRestRequest $request ) {
		return $this->callOperationAsync( 'BulkCreateAdsByListingID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestResponse
	 */
	public function bulkDeleteAdsByInventoryReference( \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestRequest $request ) {
		return $this->bulkDeleteAdsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkDeleteAdsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'BulkDeleteAdsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestResponse
	 */
	public function bulkDeleteAdsByListingID( \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestRequest $request ) {
		return $this->bulkDeleteAdsByListingIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkDeleteAdsByListingIDAsync( \DTS\eBaySDK\Marketing\Types\BulkDeleteAdsByListingIDRestRequest $request ) {
		return $this->callOperationAsync( 'BulkDeleteAdsByListingID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestResponse
	 */
	public function bulkUpdateAdBidsByInventoryReference( \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestRequest $request ) {
		return $this->bulkUpdateAdBidsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkUpdateAdBidsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'BulkUpdateAdBidsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestResponse
	 */
	public function bulkUpdateAdBidsByListingID( \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestRequest $request ) {
		return $this->bulkUpdateAdBidsByListingIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function bulkUpdateAdBidsByListingIDAsync( \DTS\eBaySDK\Marketing\Types\BulkUpdateAdBidsByListingIDRestRequest $request ) {
		return $this->callOperationAsync( 'BulkUpdateAdBidsByListingID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestResponse
	 */
	public function createAdByListingID( \DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestRequest $request ) {
		return $this->createAdByListingIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function createAdByListingIDAsync( \DTS\eBaySDK\Marketing\Types\CreateAdByListingIDRestRequest $request ) {
		return $this->callOperationAsync( 'CreateAdByListingID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestResponse
	 */
	public function createAdsByInventoryReference( \DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestRequest $request ) {
		return $this->createAdsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function createAdsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\CreateAdsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'CreateAdsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestResponse
	 */
	public function deleteAdByID( \DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestRequest $request ) {
		return $this->deleteAdByIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function deleteAdByIDAsync( \DTS\eBaySDK\Marketing\Types\DeleteAdByIDRestRequest $request ) {
		return $this->callOperationAsync( 'DeleteAdByID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestResponse
	 */
	public function deleteAdsByInventoryReference( \DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestRequest $request ) {
		return $this->deleteAdsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function deleteAdsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\DeleteAdsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'DeleteAdsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdByIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetAdByIDRestResponse
	 */
	public function getAdByID( \DTS\eBaySDK\Marketing\Types\GetAdByIDRestRequest $request ) {
		return $this->getAdByIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdByIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAdByIDAsync( \DTS\eBaySDK\Marketing\Types\GetAdByIDRestRequest $request ) {
		return $this->callOperationAsync( 'GetAdByID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdsRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetAdsRestResponse
	 */
	public function getAds( \DTS\eBaySDK\Marketing\Types\GetAdsRestRequest $request ) {
		return $this->getAdsAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdsRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAdsAsync( \DTS\eBaySDK\Marketing\Types\GetAdsRestRequest $request ) {
		return $this->callOperationAsync( 'GetAds', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestResponse
	 */
	public function getAdsByInventoryReference( \DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestRequest $request ) {
		return $this->getAdsByInventoryReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAdsByInventoryReferenceAsync( \DTS\eBaySDK\Marketing\Types\GetAdsByInventoryReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'GetAdsByInventoryReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateBidRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\UpdateBidRestResponse
	 */
	public function updateBid( \DTS\eBaySDK\Marketing\Types\UpdateBidRestRequest $request ) {
		return $this->updateBidAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateBidRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function updateBidAsync( \DTS\eBaySDK\Marketing\Types\UpdateBidRestRequest $request ) {
		return $this->callOperationAsync( 'UpdateBid', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CloneCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\CloneCampaignRestResponse
	 */
	public function cloneCampaign( \DTS\eBaySDK\Marketing\Types\CloneCampaignRestRequest $request ) {
		return $this->cloneCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CloneCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function cloneCampaignAsync( \DTS\eBaySDK\Marketing\Types\CloneCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'CloneCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\CreateCampaignRestResponse
	 */
	public function createCampaign( \DTS\eBaySDK\Marketing\Types\CreateCampaignRestRequest $request ) {
		return $this->createCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function createCampaignAsync( \DTS\eBaySDK\Marketing\Types\CreateCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'CreateCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\DeleteCampaignRestResponse
	 */
	public function deleteCampaign( \DTS\eBaySDK\Marketing\Types\DeleteCampaignRestRequest $request ) {
		return $this->deleteCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function deleteCampaignAsync( \DTS\eBaySDK\Marketing\Types\DeleteCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'DeleteCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\EndCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\EndCampaignRestResponse
	 */
	public function endCampaign( \DTS\eBaySDK\Marketing\Types\EndCampaignRestRequest $request ) {
		return $this->endCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\EndCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function endCampaignAsync( \DTS\eBaySDK\Marketing\Types\EndCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'EndCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestResponse
	 */
	public function findCampaignByAdReference( \DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestRequest $request ) {
		return $this->findCampaignByAdReferenceAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function findCampaignByAdReferenceAsync( \DTS\eBaySDK\Marketing\Types\FindCampaignByAdReferenceRestRequest $request ) {
		return $this->callOperationAsync( 'FindCampaignByAdReference', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestResponse
	 */
	public function getAllCampaigns( \DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestRequest $request ) {
		return $this->getAllCampaignsAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getAllCampaignsAsync( \DTS\eBaySDK\Marketing\Types\GetAllCampaignsRestRequest $request ) {
		return $this->callOperationAsync( 'GetAllCampaigns', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestResponse
	 */
	public function getCampaignByName( \DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestRequest $request ) {
		return $this->getCampaignByNameAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getCampaignByNameAsync( \DTS\eBaySDK\Marketing\Types\GetCampaignByNameRestRequest $request ) {
		return $this->callOperationAsync( 'GetCampaignByName', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestResponse
	 */
	public function getCampaignByID( \DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestRequest $request ) {
		return $this->getCampaignByIDAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getCampaignByIDAsync( \DTS\eBaySDK\Marketing\Types\GetCampaignByIDRestRequest $request ) {
		return $this->callOperationAsync( 'GetCampaignByID', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\PauseCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\PauseCampaignRestResponse
	 */
	public function pauseCampaign( \DTS\eBaySDK\Marketing\Types\PauseCampaignRestRequest $request ) {
		return $this->pauseCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\PauseCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function pauseCampaignAsync( \DTS\eBaySDK\Marketing\Types\PauseCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'PauseCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\ResumeCampaignRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\ResumeCampaignRestResponse
	 */
	public function resumeCampaign( \DTS\eBaySDK\Marketing\Types\ResumeCampaignRestRequest $request ) {
		return $this->resumeCampaignAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\ResumeCampaignRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function resumeCampaignAsync( \DTS\eBaySDK\Marketing\Types\ResumeCampaignRestRequest $request ) {
		return $this->callOperationAsync( 'ResumeCampaign', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestResponse
	 */
	public function updateCampaignIDentification( \DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestRequest $request ) {
		return $this->updateCampaignIDentificationAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function updateCampaignIDentificationAsync( \DTS\eBaySDK\Marketing\Types\UpdateCampaignIDentificationRestRequest $request ) {
		return $this->callOperationAsync( 'UpdateCampaignIDentification', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestResponse
	 */
	public function createItemPromotion( \DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestRequest $request ) {
		return $this->createItemPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function createItemPromotionAsync( \DTS\eBaySDK\Marketing\Types\CreateItemPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'CreateItemPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestResponse
	 */
	public function deleteItemPromotion( \DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestRequest $request ) {
		return $this->deleteItemPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function deleteItemPromotionAsync( \DTS\eBaySDK\Marketing\Types\DeleteItemPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'DeleteItemPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetItemPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetItemPromotionRestResponse
	 */
	public function getItemPromotion( \DTS\eBaySDK\Marketing\Types\GetItemPromotionRestRequest $request ) {
		return $this->getItemPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetItemPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getItemPromotionAsync( \DTS\eBaySDK\Marketing\Types\GetItemPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'GetItemPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestResponse
	 */
	public function updateItemPromotion( \DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestRequest $request ) {
		return $this->updateItemPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function updateItemPromotionAsync( \DTS\eBaySDK\Marketing\Types\UpdateItemPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'UpdateItemPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestResponse
	 */
	public function getListingsInSpecificPromotion( \DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestRequest $request ) {
		return $this->getListingsInSpecificPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getListingsInSpecificPromotionAsync( \DTS\eBaySDK\Marketing\Types\GetListingsInSpecificPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'GetListingsInSpecificPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetPromotionsRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetPromotionsRestResponse
	 */
	public function getPromotions( \DTS\eBaySDK\Marketing\Types\GetPromotionsRestRequest $request ) {
		return $this->getPromotionsAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetPromotionsRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getPromotionsAsync( \DTS\eBaySDK\Marketing\Types\GetPromotionsRestRequest $request ) {
		return $this->callOperationAsync( 'GetPromotions', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\PauseAPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\PauseAPromotionRestResponse
	 */
	public function pauseAPromotion( \DTS\eBaySDK\Marketing\Types\PauseAPromotionRestRequest $request ) {
		return $this->pauseAPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\PauseAPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function pauseAPromotionAsync( \DTS\eBaySDK\Marketing\Types\PauseAPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'PauseAPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestResponse
	 */
	public function resumeAPromotion( \DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestRequest $request ) {
		return $this->resumeAPromotionAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function resumeAPromotionAsync( \DTS\eBaySDK\Marketing\Types\ResumeAPromotionRestRequest $request ) {
		return $this->callOperationAsync( 'ResumeAPromotion', $request );
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestRequest $request
	 *
	 * @return \DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestResponse
	 */
	public function getPromotionSummaryReport( \DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestRequest $request ) {
		return $this->getPromotionSummaryReportAsync( $request )->wait();
	}

	/**
	 * @param \DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestRequest $request
	 *
	 * @return \GuzzleHttp\Promise\PromiseInterface
	 */
	public function getPromotionSummaryReportAsync( \DTS\eBaySDK\Marketing\Types\GetPromotionSummaryReportRestRequest $request ) {
		return $this->callOperationAsync( 'GetPromotionSummaryReport', $request );
	}
}
