<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_cronjob_new {
	/**
	 * Construct the cron
	 */
	public function __construct( $echo_messages ) {
		//load required settings for cronjob
		$this->echo_messages = $echo_messages;

		$this->dataupdate_interval = atkp_options::$loader->get_cache_duration();

		$this->datacheck_enabled  = atkp_options::$loader->get_check_enabled();
		$this->datacheck_interval = atkp_options::$loader->get_notification_interval();

		$this->csvupdate_interval = atkp_options::$loader->get_access_csv_intervall();
	}

	private $echo_messages = false;
	private $datacheck_enabled = false;
	private $datacheck_interval = 4320;

	private $dataupdate_interval = 1440;
	private $csvupdate_interval = 1440;

	private $minutes = 0;

	public function do_multiwork( $iswpcronjob, $actual_link, $mode = '' ) {
		$this->send_message( '### multi cronjob started ###' );

		//todo: angebote unabhängig vom shop für jedes produkt generieren und danach die shops aktualsiieren

		$activityname = ATKP_PLUGIN_PREFIX . '_cron_lastactivity';

		$shops = atkp_shop::get_list( null, true );

		$blankshop     = new atkp_shop();
		$blankshop->id = - 1;
		array_push( $shops, $blankshop );

		foreach ( $shops as $shop ) {
			$params           = array();
			$params['shopid'] = $shop->id;
			$params['mode']   = $mode;

			$this->send_message( 'shop reload: ' . $actual_link . '?shopid=' . $shop->id . '&mode=' . $mode );

			$this->curl_request_async( $actual_link . '?shopid=' . $shop->id . '&mode=' . $mode );
		}

		if ( $this->datacheck_enabled ) {
			$this->do_data_check( $activityname );
		}


		$this->send_message( '### multi cronjob finished ###' );

		if ( ! $iswpcronjob ) {
			echo 'OK';
			exit;
		}
	}

	public function do_work( $iswpcronjob = false, $mode = '' ) {
		$this->send_message( '### cronjob started ###' );

		$shopidget   = ATKPTools::get_get_parameter( 'shopid', 'int' );
		$shopidarray = null;
		if ( $shopidget == null || $shopidget == '0' ) {
			$shopidget = '';
		} else {
			$shopidarray = array( $shopidget );
		}

		$activityname = ATKP_PLUGIN_PREFIX . '_cron_lastactivity' . $shopidget . $mode;

		$meessage = '';
		if ( ! self::allow_lastactivity( $activityname, $iswpcronjob, $meessage ) ) {
			$this->send_message( $meessage );
			exit;
		}

		self::update_lastactivity( $activityname );


		$this->do_license_check();


		$csvimported = true;
		//zuerst werden notwendige CSV-Dateien importiert
		if ( ( $mode == '' || $mode == 'csvimport' || $mode == 'regular' ) && $shopidget != - 1 ) {
			$csvimported = $this->do_csv_import( $activityname, $shopidarray );
		}

		if ( ! $csvimported ) {
			$this->send_message( 'csv is not imported' );
			exit;
		}

		//danach werden die Produkte aktualisiert
		if ( $mode == '' || $mode == 'productupdate' || $mode == 'regular' ) {
			$this->do_product_update( $activityname, $shopidarray );
		}

		//und dann die Listen
		if ( $mode == '' || $mode == 'listupdate' || $mode == 'regular' ) {
			$this->do_list_update( $activityname, $shopidarray );
		}

		//angebote aktualsiieren
		if ( ( $mode == '' || $mode == 'offerupdate' ) && $shopidget != - 1 ) {
			$this->do_offer_update( $activityname, $shopidarray );
		}

		//produkte exportieren
		if ( $shopidarray == null ) {
			if ( $mode == '' || $mode == 'productupdate' || $mode == 'productexport' ) {
				$this->do_product_export( $activityname );
			}
		}


		//datenüberprüfung machen
		if ( $shopidarray == null ) {
			if ( $mode == '' || $mode == 'productupdate' || $mode == 'regular' ) {
				if ( $this->datacheck_enabled ) {
					$this->do_data_check( $activityname );
				}
			}
		}


		self::update_lastactivity( $activityname, true );

		$this->send_message( '### cronjob finished ###' );

		if ( ! $iswpcronjob ) {
			echo 'OK';
			exit;
		}
	}

	public function do_license_check() {
		try {
			$this->send_message( '*** license update started ***' );


			$lastimport = atkp_options::$loader->get_cron_lastlicensecheck();

			if ( $lastimport != '' ) {
				$diff_lastimport = round( abs( time() - $lastimport ) / 60, 2 );

				//wenn keine fortsetzung, dann prüfen
				if ( $diff_lastimport <= 1440 ) {

					$this->send_message( 'next check (hours): ' . round( ( 1440 - $diff_lastimport ) / 60, 2 ) );

					return;
				} else {
					$this->send_message( 'check now' );
				}
			}

			atkp_check_license();

			update_option( ATKP_PLUGIN_PREFIX . '_cron_lastlicensecheck', time() );

			$this->send_message( '*** license update cronjob finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
			$this->send_message( 'LICENSE-ERROR: ' . $e->getMessage() );
		}
	}

	function curl_request_async( $url ) {

		$opts = array(
			'http' =>
				array(
					'method'  => 'GET',
					'header'  => "Content-Type: text/html\r\n",
					'content' => '',
					'timeout' => 1
				)
		);

		$context = stream_context_create( $opts );
		$result  = file_get_contents( $url, false, $context, - 1, 40000 );
	}

	public static function allow_lastactivity( $activityname, $iswpcronjob, &$message ) {
		$lastactivity = get_option( $activityname );

		$override = ATKPTools::get_get_parameter( 'override', 'string' );

		if ( $override != '' ) {
			$lastactivity = null;
		}

		$from = atkp_options::$loader->get_cron_from();
		$to   = atkp_options::$loader->get_cron_to();

		if ( $from != '' && $to != '' && ( $from != '00:00' || $to != '00:00' ) ) {
			$begin = strtotime( $from );
			$end   = strtotime( $to );
			$now   = time();

			if ( $begin > $end ) {
				$end = $end + 86400;
			}

			if ( $now >= $begin && $now <= $end ) {
				//echo 'time ' . date( 'd.m.y H:i:s', $now ) . ' is okay (' . date( 'd.m.y H:i:s', $begin ) . ' and ' . date( 'd.m.y H:i:s', $end ) . ')... lets do the work';
				$message = 'time ' . date( 'd.m.y H:i:s', $now ) . ' is okay (' . date( 'd.m.y H:i:s', $begin ) . ' and ' . date( 'd.m.y H:i:s', $end ) . ')... lets do the work';
			} else {
				$message = 'time ' . date( 'd.m.y H:i:s', $now ) . ' is NOT between ' . date( 'd.m.y H:i:s', $begin ) . ' and ' . date( 'd.m.y H:i:s', $end ) . ' - blocking';

				return false;
			}
		}


		if ( ! isset( $lastactivity ) || $lastactivity == null || $lastactivity == '' ) {
			$message = 'lastactivity is null - lets do the work';

			return true;
		} else {
			$message = 'last activity: ' . date( 'd.m.y H:i:s', $lastactivity );

			$diff_lastactivity = round( abs( time() - $lastactivity ) / 60, 2 );

			if ( $diff_lastactivity <= 5 ) {
				$message = '5 minutes blocking (a task is already active): ' . ( 5 - $diff_lastactivity );

				return false;
			} else {
				$message = 'no activity the last minutes - that is great... lets do the work';

				return true;
			}
		}
	}

	public static function update_lastactivity( $activityname, $clear = false ) {
		$now = time();

		if ( $clear ) {
			delete_option( $activityname );
		} else {
			update_option( $activityname, $now );
		}

		//echo date('H:i:s').' - '. 'lastactivity updated: '.date('H:i:s', $now).'<br />'.PHP_EOL;

		return $now;
	}


	private function do_csv_import( $activityname, $shopids = null ) {
		try {
			$this->send_message( '*** csv cronjob for datacheck started ***' );
			$lastimport          = atkp_options::$loader->get_cron_csv_lastimport();
			$lastimport_finished = atkp_options::$loader->get_cron_csv_lastimportfinished();
			$isresume            = $lastimport_finished != 1;

			update_option( ATKP_PLUGIN_PREFIX . '_cron_csv_lastimportfinished', 0 );

			$shopidfilter = null;
			if ( $shopids != null ) {
				$shopidfilter = array(
					'post__in' => $shopids
				);
			}

			$updatetime = $this->get_csvtime();


			$csvsperpage = 50;

			if ( defined( "ATKP_CSVS_PER_PAGE" ) ) {
				$csvsperpage = intval( ATKP_CSVS_PER_PAGE );
			}

			global $wpdb;

			$posttype       = ATKP_SHOP_POSTTYPE;
			$shoptypefield  = ATKP_SHOP_POSTTYPE . '_access_webservice';
			$updatedonfield = ATKP_SHOP_POSTTYPE . '_updatedon';

			$sql = "
										  	SELECT SQL_CALC_FOUND_ROWS {$wpdb->posts}.ID 
												FROM {$wpdb->posts} 
												
												INNER JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id AND {$wpdb->postmeta}.meta_key = '$shoptypefield' and {$wpdb->postmeta}.meta_value = '7')
												LEFT JOIN {$wpdb->postmeta} AS mt3 ON ( {$wpdb->posts}.ID = mt3.post_id AND mt3.meta_key = '$updatedonfield') 
												
												WHERE 
												{$wpdb->posts}.post_type = '$posttype' and ({$wpdb->posts}.post_status = 'publish' OR {$wpdb->posts}.post_status = 'draft')
												
												 
												AND ( mt3.post_id IS NULL OR ( mt3.meta_value = '' ) OR ( CAST(mt3.meta_value AS SIGNED) < $updatetime ) )
												
												GROUP BY {$wpdb->posts}.ID 
												ORDER BY CAST(mt3.meta_value AS SIGNED) ASC 
												LIMIT 0, " . $csvsperpage;


			$posts_found = $wpdb->get_results( $sql, OBJECT );


			$this->send_message( 'csv posts found: ' . count( $posts_found ) );

			//wenn csv feeds vorhanden sind, dann initialisiere den csv cronjob.
			if ( $posts_found && count( $posts_found ) > 0 ) {

				$postcount = 0;
				foreach ( $posts_found as $xx ) {
					try {
						$csvimport = get_post( (int) $xx->ID );

						$this->send_message( 'import csv: ' . $csvimport->ID . ' - ' . $csvimport->post_title );


						$csvprovider = new atkp_shop_provider_csv();
						$csvprovider->import_csv( $csvimport->ID, true, $isresume, array(
							'atkp_cronjob_new',
							'update_lastactivity'
						), $activityname );


						unset( $csvprovider );

						ATKPTools::set_post_setting( $csvimport->ID, ATKP_SHOP_POSTTYPE . '_updatedon', ATKPTools::get_current_utc() );
						ATKPTools::set_post_setting( $csvimport->ID, ATKP_SHOP_POSTTYPE . '_access_message', null );

						$this->send_message( 'import finished csv: ' . $csvimport->ID );
						$postcount ++;

					} catch ( Exception $e ) {
						$this->send_message( 'import csv error (' . $csvimport->ID . ') ' . $e->getMessage() );

						ATKPTools::set_post_setting( $csvimport->ID, ATKP_SHOP_POSTTYPE . '_access_message', 'last import: ' . $e->getMessage() );

					}
				}


				//wenn noch eine csv-liste da ist, dann soll das script beendet werden
				if ( count( $posts_found ) == $csvsperpage ) {
					$this->send_message( 'count difference: ' . count( $posts_found ) . ' != ' . $postcount );

					return false;
				}
			}

			self::update_lastactivity( $activityname );

			update_option( ATKP_PLUGIN_PREFIX . '_cron_csv_lastimportfinished', 1 );
			update_option( ATKP_PLUGIN_PREFIX . '_cron_csv_lastimport', ATKPTools::get_current_utc() );

			$this->send_message( '*** csv cronjob finished ***' );

			return true;

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}


	private function get_offertime( $datetimeformat = false ) {
		$updatetime = time();

		$this->send_message( 'cnt: ' . $updatetime );


		$dataupdateinterval = $this->dataupdate_interval;

		if ( defined( "ATKP_OFFERS_INTERVAL" ) ) {
			$dataupdateinterval = intval( ATKP_OFFERS_INTERVAL );
		}


		if ( $dataupdateinterval > 60 ) {
			$updatetime = strtotime( '-' . ( $dataupdateinterval / 60 ) . ' hours' );
		} else {
			$updatetime = strtotime( '-' . ( $dataupdateinterval ) . ' min' );
		}

		if ( $datetimeformat ) {
			return date( 'd.m.y H:m:s', $updatetime );
		}

		$this->send_message( 'cnt: ' . $updatetime );

		$updatetime = $this->get_time( $updatetime, 'timestamp' );

		$this->send_message( 'timestamp: ' . date( 'd.m.y H:m:s', $updatetime ) );

		return $updatetime;
	}

	private function get_datatime( $datetimeformat = false ) {
		$updatetime = time();

		$this->send_message( 'cnt: ' . $updatetime );


		$dataupdateinterval = $this->dataupdate_interval;

		if ( defined( "ATKP_PRODUCTS_INTERVAL" ) ) {
			$dataupdateinterval = intval( ATKP_PRODUCTS_INTERVAL );
		}


		if ( $dataupdateinterval > 60 ) {
			$updatetime = strtotime( '-' . ( $dataupdateinterval / 60 ) . ' hours' );
		} else {
			$updatetime = strtotime( '-' . ( $dataupdateinterval ) . ' min' );
		}

		if ( $datetimeformat ) {
			return date( 'd.m.y H:m:s', $updatetime );
		}

		$this->send_message( 'cnt: ' . $updatetime );

		$updatetime = $this->get_time( $updatetime, 'timestamp' );

		$this->send_message( 'timestamp: ' . date( 'd.m.y H:m:s', $updatetime ) );

		return $updatetime;
	}

	private function get_csvtime() {
		$updatetime = time();

		$this->send_message( 'cnt: ' . $updatetime );

		$csvupdateinterval = $this->csvupdate_interval;

		if ( defined( "ATKP_CSV_INTERVAL" ) ) {
			$csvupdateinterval = intval( ATKP_CSV_INTERVAL );
		}

		if ( $csvupdateinterval > 60 ) {
			$updatetime = strtotime( '-' . ( $csvupdateinterval / 60 ) . ' hours' );
		} else {
			$updatetime = strtotime( '-' . ( $csvupdateinterval ) . ' min' );
		}

		$this->send_message( 'cnt: ' . $updatetime );

		$updatetime = $this->get_time( $updatetime, 'timestamp' );

		$this->send_message( 'timestamp: ' . date( 'd.m.y H:m:s', $updatetime ) );

		return $updatetime;
	}


	/**
	 * Aktualisiert die AT-Angebote welche vorher von do_product_update zurückgesetzt wurden
	 *
	 * @param bool $isresume Gibt an, ob der Cronjob nach einem Abbruch wieder ausgeführt wird
	 */
	public function do_offer_update( $activityname, $shopids ) {
		try {
			$this->send_message( '*** offer update started ***' );
			$lastimport = atkp_options::$loader->get_cron_offer_lastimport();

			$offerservice     = new atkp_offerservice();
			$offertablehelper = new atkp_offertable_helper();

			$idtypes = array( 'ASIN', 'EAN' );

			$shops = atkp_shop::get_list( null, true );
			$y     = 1;

			$offersperpage = 100;

			if ( defined( "ATKP_OFFERS_PER_PAGE" ) ) {
				$offersperpage = intval( ATKP_OFFERS_PER_PAGE );
			}

			foreach ( $idtypes as $idtype ) {
				$shopcount      = 0;
				$totalshopcount = count( $shops );

				foreach ( $shops as $shop ) {
					$shopcount ++;
					//hier darf nicht auf enablepricecomparison abgefragt werden weil sonst manuelle produkte nicht aktualisiert werden

					if ( $shopids != null ) {
						if ( $shop == null || ! in_array( $shop->id, $shopids ) ) {
							continue;
						}
					}

					$posts_exists = true;
					$page         = 1;

					while ( $posts_exists ) {

						$offers = $offertablehelper->get_offers_for_update( $shop->id, $idtype, $page, 0, $this->get_offertime(), $offersperpage );

						$this->send_message( 'offer shopid: ' . $shop->id . ' (' . $shop->get_title() . ' - ' . $shopcount . '/' . $totalshopcount . '), key: ' . $idtype . ', products found: ' . count( $offers ) );

						if ( count( $offers ) > 0 ) {
							$size = $shop->provider->get_maxproductcount();
							if ( $size <= 0 ) {
								$size = 10;
							}

							$chunks = array_chunk( $offers, $size, true );

							foreach ( $chunks as $chunk ) {
								$offerservice->update_offers( $shop, $chunk, $idtype );
							}
						}

						$posts_exists = count( $offers ) >= $offersperpage;
						//$page ++;

						//resume marker, save position each 50 entries to have a resume mark
						if ( $y % 10 == 0 ) {
							self::update_lastactivity( $activityname );
						}

						$y ++;
					}
				}
			}

			self::update_lastactivity( $activityname );

			/* Restore original Post Data */
			wp_reset_postdata();

			//der zweite teil aktualisiert die Angeobte

			update_option( ATKP_PLUGIN_PREFIX . '_cron_offer_lastimport', time() );

			$this->send_message( '*** offer update cronjob finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}

	/**
	 * Kopiert die AT-Produkte nach WooCommerce (oder anderen Export-Provider), wenn das flag _isexported auf false oder null steht
	 *
	 * @param $isresume
	 */
	public
	function do_product_export(
		$activityname
	) {
		try {
			$this->send_message( '*** product export started ***' );
			$lastimport = atkp_options::$loader->get_cron_product_lastexport();

			$y = 1;

			$exportsperpage = 100;

			if ( defined( "ATKP_EXPORTS_PER_PAGE" ) ) {
				$exportsperpage = intval( ATKP_EXPORTS_PER_PAGE );
			}


			//TODO: nur produkte laden die noch nicht aktualisiert wurden

			$productservice = new atkp_productservice();

			$posts_exists = true;

			while ( $posts_exists ) {

				global $wpdb;

				$posttype      = ATKP_PRODUCT_POSTTYPE;
				$iswoocommerce = ATKP_PRODUCT_POSTTYPE . '_iswoocommerce';
				$isexported    = ATKP_PRODUCT_POSTTYPE . '_isexported';


				$sql = "SELECT SQL_CALC_FOUND_ROWS {$wpdb->posts}.ID 
									FROM {$wpdb->posts} 
									
									LEFT JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id AND {$wpdb->postmeta}.meta_key = '$iswoocommerce')
									LEFT JOIN {$wpdb->postmeta} AS mt1 ON ( {$wpdb->posts}.ID = mt1.post_id AND mt1.meta_key = '$isexported') 
									
									WHERE {$wpdb->posts}.post_type = '$posttype' and ({$wpdb->posts}.post_status = 'publish' OR {$wpdb->posts}.post_status = 'draft')
									
									AND ( {$wpdb->postmeta}.meta_value = '1'  )
									AND ( mt1.post_id IS NULL OR ( mt1.meta_value = '' ) OR (mt1.meta_value = '0' ) )
									
									GROUP BY {$wpdb->posts}.ID 
									ORDER BY {$wpdb->posts}.ID ASC 
									LIMIT 0, " . $exportsperpage;


				$posts_found = $wpdb->get_results( $sql, OBJECT );

				//$this->send_message( 'woo export, products found: ' . count($posts_found) );

				$productids = array();

				foreach ( $posts_found as $xx ) {
					array_push( $productids, (int) $xx->ID );
				}

				if ( count( $productids ) > 0 ) {
					$this->send_message( 'woo export (' . count( $posts_found ) . ' products): ' . implode( ', ', $productids ) );

					$productservice->export_products( $productids );

					$this->send_message( 'woo export (' . count( $posts_found ) . ' products) finished' );
				}

				//resume marker, save position each 50 entries to have a resume mark
				if ( $y % 5 == 0 ) {
					self::update_lastactivity( $activityname );
				}

				$y ++;

				//$posts_exists = $posts->max_num_pages > 1;
				$posts_exists = count( $posts_found ) >= $exportsperpage;
			}

			self::update_lastactivity( $activityname );

			/* Restore original Post Data */
			wp_reset_postdata();

			update_option( ATKP_PLUGIN_PREFIX . '_cron_product_lastexport', time() );

			$this->send_message( '*** product export finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
			$this->send_message( 'EXPORT-ERROR: ' . $e->getMessage() );
		}
	}

	/**
	 * Aktualisiert die AT-Produktdaten und setzt die Angebote für das Update zurück
	 *
	 * @param bool $isresume Gibt an, ob der Cronjob nach einem Abbruch wieder ausgeführt wird
	 */
	public
	function do_product_update(
		$activityname, $shopids
	) {
		try {
			$this->send_message( '*** product update started ***' );
			$lastimport = atkp_options::$loader->get_cron_product_lastimport();

			//TODO: nur produkte laden die noch nicht aktualisiert wurden

			//tabelle für die angebote anlegen
			$atkp_offertable_helper = new atkp_offertable_helper();


			$productservice = new atkp_productservice();

			$updatetime = $this->get_datatime();

			$errors = array();

			//der erste teil aktualisiert die Produkte

			$idtypes = array( 'ASIN', 'EAN', 'TITLE', 'ARTICLENUMBER' );

			$shops = atkp_shop::get_list( null, true );
			$y     = 1;


			array_push( $shops, null );


			$productsperpage = 100;

			if ( defined( "ATKP_PRODUCTS_PER_PAGE" ) ) {
				$productsperpage = intval( ATKP_PRODUCTS_PER_PAGE );
			}

			foreach ( $idtypes as $idtype ) {
				$shopcount      = 0;
				$totalshopcount = count( $shops );

				foreach ( $shops as $shop ) {
					$shopcount ++;
					$posts_exists = true;

					if ( $shopids != null ) {

						if ( in_array( - 1, $shopids ) && $shop == null ) {
							//manuelles produkt
						} else {
							if ( $shop == null || ! in_array( $shop->id, $shopids ) ) {
								continue;
							}
						}
					}

					while ( $posts_exists ) {

						global $wpdb;

						$posttype       = ATKP_PRODUCT_POSTTYPE;
						$shopfield      = ATKP_PRODUCT_POSTTYPE . '_shopid';
						$asintypefield  = ATKP_PRODUCT_POSTTYPE . '_asintype';
						$updatedonfield = ATKP_PRODUCT_POSTTYPE . '_updatedon';

						if ( $shop == null ) {
							$fieldjoin = " AND ({$wpdb->postmeta}.post_id IS NULL OR (  {$wpdb->postmeta}.meta_value = '' ))";
						} else {
							$fieldjoin = " AND ( {$wpdb->postmeta}.meta_value = '{$shop->id}'  )";
						}

						$sql = "
										  	SELECT SQL_CALC_FOUND_ROWS {$wpdb->posts}.ID 
												FROM {$wpdb->posts} 
												
												LEFT JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id AND {$wpdb->postmeta}.meta_key = '$shopfield')
												LEFT JOIN {$wpdb->postmeta} AS mt1 ON ( {$wpdb->posts}.ID = mt1.post_id AND mt1.meta_key = '$asintypefield') 
												LEFT JOIN {$wpdb->postmeta} AS mt3 ON ( {$wpdb->posts}.ID = mt3.post_id AND mt3.meta_key = '$updatedonfield') 
												
												WHERE 
												{$wpdb->posts}.post_type = '$posttype' and ({$wpdb->posts}.post_status = 'publish' OR {$wpdb->posts}.post_status = 'draft')
												
												$fieldjoin
												AND ( mt1.post_id IS NULL OR ( mt1.meta_value = '' ) OR (mt1.meta_value = '$idtype' ) )
												AND ( mt3.post_id IS NULL OR ( mt3.meta_value = '' ) OR ( CAST(mt3.meta_value AS SIGNED) < $updatetime ) )
												
												GROUP BY {$wpdb->posts}.ID 
												ORDER BY CAST(mt3.meta_value AS SIGNED) ASC 
												LIMIT 0, " . $productsperpage;


						$posts_found = $wpdb->get_results( $sql, OBJECT );

						if ( $shop == null ) {
							$this->send_message( 'manual products, key: ' . $idtype . ', products found: ' . count( $posts_found ) );
						} else {
							$this->send_message( 'shopid: ' . $shop->id . ' (' . $shop->get_title() . ' - ' . $shopcount . '/' . $totalshopcount . '), key: ' . $idtype . ', products found: ' . count( $posts_found ) );
						}

						$productids = array();

						foreach ( $posts_found as $xx ) {
							array_push( $productids, (int) $xx->ID );
						}

						if ( count( $productids ) > 0 ) {
							$size = $shop->provider != null ? $shop->provider->get_maxproductcount() : 0;
							if ( $size <= 0 ) {
								$size = 10;
							}

							$chunks = array_chunk( $productids, $size, true );

							foreach ( $chunks as $chunk ) {
								$productservice->update_products( $shop, $chunk, $idtype );
							}
						}

						//resume marker, save position each 50 entries to have a resume mark
						if ( $y % 10 == 0 ) {
							self::update_lastactivity( $activityname );
						}

						$y ++;

						$posts_exists = count( $posts_found ) >= $productsperpage;
					}
				}
			}
			/* Restore original Post Data */
			wp_reset_postdata();

			self::update_lastactivity( $activityname );

			//check invalid shopids
			$allshopids = array();

			foreach ( $shops as $shop ) {
				array_push( $allshopids, $shop == null ? '' : $shop->id );
			}

			$posts_exists = true;

			while ( $posts_exists ) {

				$posts_found = array(
					'posts_per_page' => 10,
					'post_status'    => array( 'draft', 'publish' ),
					'post_type'      => ATKP_PRODUCT_POSTTYPE,
					'meta_query'     => array(
						'relation' => 'AND',
						array(
							'key'     => ATKP_PRODUCT_POSTTYPE . '_shopid',
							'compare' => 'NOT IN',
							'value'   => $allshopids,
						),
						array(
							'relation' => 'OR',
							array(
								'key'     => ATKP_PRODUCT_POSTTYPE . '_updatedon',
								'type'    => 'numeric',
								'compare' => '<',
								'value'   => $updatetime,
							),
							array(
								'key'     => ATKP_PRODUCT_POSTTYPE . '_updatedon',
								'compare' => '==',
								'value'   => '',
							),
							array(
								'key'     => ATKP_PRODUCT_POSTTYPE . '_updatedon',
								'compare' => 'NOT EXISTS',
							)
						)
					)
				);


				$posts      = new WP_Query( $posts_found );
				$post_count = $posts->found_posts;

				$productids = array();

				while ( $posts->have_posts() ) {
					$posts->the_post();

					$post_id = get_the_ID();

					array_push( $productids, $post_id );
				}

				if ( count( $productids ) > 0 ) {
					$productservice->mark_asinvalid( $productids );
				}

				//resume marker, save position each 50 entries to have a resume mark
				if ( $y % 25 == 0 ) {
					self::update_lastactivity( $activityname );
				}

				$y ++;

				$posts_exists = $posts->max_num_pages > 1;

				/* Restore original Post Data */
				wp_reset_postdata();
			}

			self::update_lastactivity( $activityname );

			//der zweite teil aktualisiert die Angeobte

			update_option( ATKP_PLUGIN_PREFIX . '_cron_product_lastimport', time() );

			$this->send_message( '*** product update cronjob finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
			$this->send_message( 'UPDATE-ERROR: ' . $e->getMessage() );
		}
	}

	function get_time( $time, $type, $gmt = 0 ) {
		switch ( $type ) {
			case 'mysql':
				return ( $gmt ) ? gmdate( $time, 'Y-m-d H:i:s' ) : gmdate( $time, 'Y-m-d H:i:s', ( time() + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ) );
			case 'timestamp':
				return ( $gmt ) ? $time : $time + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
			default:
				return ( $gmt ) ? date( $time, $type ) : date( $time, $type, $time + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) );
		}
	}

	public
	function do_list_update(
		$activityname,
		$shopids
	) {
		try {
			$this->send_message( '*** list update cronjob started ***' );
			$lastimport = atkp_options::$loader->get_cron_list_lastimport();

			if ( $lastimport != '' ) {
				$diff_lastimport = round( abs( time() - $lastimport ) / 60, 2 );

				//wenn keine fortsetzung, dann prüfen
				if ( $diff_lastimport <= $this->dataupdate_interval ) {

					//$this->send_message('next import (hours): '.  round(($this->dataupdate_interval- $diff_lastimport) / 60,2));
					//return;
				} else {
					$this->send_message( 'import now' );
				}
			}

			//TODO: nur listen laden die noch nicht aktualisiert wurden

			$listservice = new atkp_listservice();

			$cron = new atkp_wp_cronjob( array() );

			$updatetime = $this->get_datatime();

			$shops = atkp_shop::get_list( null, true );
			$y     = 1;


			array_push( $shops, null );

			$shopcount      = 0;
			$totalshopcount = count( $shops );

			$listsperpage = 100;

			if ( defined( "ATKP_LISTS_PER_PAGE" ) ) {
				$listsperpage = intval( ATKP_LISTS_PER_PAGE );
			}

			foreach ( $shops as $shop ) {
				$shopcount ++;

				if ( $shopids != null ) {
					if ( in_array( - 1, $shopids ) && $shop == null ) {
						//manuelles produkt
					} else {
						if ( $shop == null || ! in_array( $shop->id, $shopids ) ) {
							continue;
						}
					}
				}


				$errors = array();

				$posts_exists = true;

				while ( $posts_exists ) {

					global $wpdb;

					$posttype       = ATKP_LIST_POSTTYPE;
					$shopfield      = ATKP_LIST_POSTTYPE . '_shopid';
					$updatedonfield = ATKP_LIST_POSTTYPE . '_updatedon';

					if ( $shop == null ) {
						$fieldjoin = " AND ({$wpdb->postmeta}.post_id IS NULL OR (  {$wpdb->postmeta}.meta_value = '' ))";
					} else {
						$fieldjoin = " AND ( {$wpdb->postmeta}.meta_value = '{$shop->id}'  )";
					}

					$sql = "
										  	SELECT SQL_CALC_FOUND_ROWS {$wpdb->posts}.ID 
												FROM {$wpdb->posts} 
												
												LEFT JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id AND {$wpdb->postmeta}.meta_key = '$shopfield')
												LEFT JOIN {$wpdb->postmeta} AS mt3 ON ( {$wpdb->posts}.ID = mt3.post_id AND mt3.meta_key = '$updatedonfield') 
												
												WHERE 
												{$wpdb->posts}.post_type = '$posttype' and ({$wpdb->posts}.post_status = 'publish' OR {$wpdb->posts}.post_status = 'draft')
												
												$fieldjoin
												AND ( mt3.post_id IS NULL OR ( mt3.meta_value = '' ) OR ( CAST(mt3.meta_value AS SIGNED) < $updatetime ) )
												
												GROUP BY {$wpdb->posts}.ID 
												ORDER BY CAST(mt3.meta_value AS SIGNED) ASC 
												LIMIT 0, " . $listsperpage;


					$posts_found = $wpdb->get_results( $sql, OBJECT );

					if ( $shop == null ) {
						$this->send_message( 'manual list, lists found: ' . count( $posts_found ) );
					} else {
						$this->send_message( 'shopid: ' . $shop->id . ' (' . $shop->get_title() . ' - ' . $shopcount . '/' . $totalshopcount . '), lists found: ' . count( $posts_found ) );
					}

					$listids = array();

					foreach ( $posts_found as $xx ) {
						array_push( $listids, $xx->ID );
					}

					if ( count( $listids ) > 0 ) {
						$chunks = array_chunk( $listids, 10, true );

						foreach ( $chunks as $chunk ) {
							$listservice->update_lists( $shop, $chunk );
						}
					}

					//resume marker, save position each 50 entries to have a resume mark
					if ( $y % 25 == 0 ) {
						self::update_lastactivity( $activityname );
					}

					$y ++;

					$posts_exists = count( $posts_found ) >= $listsperpage;

					/* Restore original Post Data */
					wp_reset_postdata();
				}
			}

			self::update_lastactivity( $activityname );


			//check invalid shopids
			$allshopids = array();

			foreach ( $shops as $shop ) {
				array_push( $allshopids, $shop == null ? '' : $shop->id );
			}

			$posts_exists = true;

			while ( $posts_exists ) {

				$posts_found = array(
					'posts_per_page' => 10,
					'post_status'    => array( 'draft', 'publish' ),
					'post_type'      => ATKP_LIST_POSTTYPE,
					'meta_query'     => array(
						'relation' => 'AND',
						array(
							'key'     => ATKP_LIST_POSTTYPE . '_shopid',
							'compare' => 'NOT IN',
							'value'   => $allshopids,
						),
						array(
							'relation' => 'OR',
							array(
								'key'     => ATKP_LIST_POSTTYPE . '_updatedon',
								'type'    => 'numeric',
								'compare' => '<',
								'value'   => $updatetime,
							),
							array(
								'key'     => ATKP_LIST_POSTTYPE . '_updatedon',
								'compare' => '==',
								'value'   => '',
							),
							array(
								'key'     => ATKP_LIST_POSTTYPE . '_updatedon',
								'compare' => 'NOT EXISTS',
							)
						)
					)
				);


				$posts      = new WP_Query( $posts_found );
				$post_count = $posts->found_posts;

				$listids = array();

				while ( $posts->have_posts() ) {
					$posts->the_post();

					$post_id = get_the_ID();

					array_push( $listids, $post_id );
				}

				if ( count( $listids ) > 0 ) {
					$listservice->mark_asinvalid( $listids );
				}

				//resume marker, save position each 50 entries to have a resume mark
				if ( $y % 25 == 0 ) {
					self::update_lastactivity( $activityname );
				}

				$y ++;

				$posts_exists = $posts->max_num_pages > 1;

				/* Restore original Post Data */
				wp_reset_postdata();
			}

			self::update_lastactivity( $activityname );

			update_option( ATKP_PLUGIN_PREFIX . '_cron_list_lastimport', time() );

			$this->send_message( '*** list update cronjob finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}

	private
	function do_data_check(
		$activityname
	) {
		try {
			$this->send_message( '*** data check cronjob started ***' );

			if ( ! $this->datacheck_enabled ) {
				$this->send_message( 'data check disabled' );

				return;
			}

			$lastimport = atkp_options::$loader->get_cron_lastdatacheck();

			if ( $lastimport != '' ) {
				$diff_lastimport = round( abs( time() - $lastimport ) / 60, 2 );

				//wenn keine fortsetzung, dann prüfen
				if ( $diff_lastimport <= $this->datacheck_interval ) {

					$this->send_message( 'next check (hours): ' . round( ( $this->datacheck_interval - $diff_lastimport ) / 60, 2 ) );

					return;
				} else {
					$this->send_message( 'import now' );
				}
			}

			try {
				$this->send_datamail( false );

			} catch ( Exception $e ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			update_option( ATKP_PLUGIN_PREFIX . '_cron_lastdatacheck', time() );

			$this->send_message( '*** data check cronjob finished ***' );
		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}


	public function send_datamail( $overrideSending = false ) {
		try {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogDebug( '*** cronjob for datacheck started ***' );
			}

			//prüfe auf shop-warnung
			//prüfe auf listen und produktwarnung
			//prüfe ob dynamische listen leer sind

			if ( ! $overrideSending ) {
				if ( ! ATKPSettings::$check_enabled ) {
					return;
				}
			}

			$recipient = ATKPSettings::$email_recipient;

			if ( $recipient == '' ) {
				$recipient = get_bloginfo( 'admin_email' );
			}

			$errors = array();

			$posts_found = get_posts( array(
				'posts_per_page'   => 250,
				'post_status'      => array( 'publish', 'draft' ),
				'post_type'        => ATKP_SHOP_POSTTYPE,
				'suppress_filters' => true,

				'meta_query' => array(
					//comparison between the inner meta fields conditionals
					'relation' => 'OR',
					//meta field condition one
					array(
						'key' => ATKP_SHOP_POSTTYPE . '_access_message',

						'compare' => 'EXISTS',
					)

				),
			) );

			foreach ( $posts_found as $prdpost ) {
				try {
					$selwebservice = ATKPTools::get_post_setting( $prdpost->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

					if ( $selwebservice != ATKP_SUBSHOPTYPE ) {
						$access_test = ATKPTools::get_post_setting( $prdpost->ID, ATKP_SHOP_POSTTYPE . '_access_message' );

						if ( $access_test != '' ) {
							$link = '<a href="' . esc_url( get_edit_post_link( (int) $prdpost->ID ) ) . '">' . $prdpost->ID . '</a>';

							array_push( $errors, 'Shop ' . $prdpost->post_title . ' (' . $link . '): ' . "<br />" . $access_test );
						}
					}

				} catch ( Exception $e ) {
					array_push( $errors, 'Shop ' . $prdpost->post_title . ' (' . $prdpost->ID . '): ' . "<br />" . 'Exception ' . $e->getMessage() );
				}
			}


			$posts_found = get_posts( array(
				'posts_per_page'   => 250,
				'post_status'      => array( 'draft', 'publish' ),
				'post_type'        => ATKP_PRODUCT_POSTTYPE,
				'suppress_filters' => true,

				'meta_query' => array(
					//comparison between the inner meta fields conditionals
					'relation' => 'OR',
					//meta field condition one
					array(
						'key' => ATKP_PRODUCT_POSTTYPE . '_message',

						'compare' => 'EXISTS',
					),
					//meta field condition one
					array(
						'key' => ATKP_PRODUCT_POSTTYPE . '_woomessage',

						'compare' => 'EXISTS',
					)
				),
			) );

			foreach ( $posts_found as $prdpost ) {
				try {

					$message    = ATKPTools::get_post_setting( $prdpost->ID, ATKP_PRODUCT_POSTTYPE . '_message' );
					$woomessage = ATKPTools::get_post_setting( $prdpost->ID, ATKP_PRODUCT_POSTTYPE . '_woomessage' );

					if ( $message != '' ) {
						$link = '<a href="' . esc_url( get_edit_post_link( (int) $prdpost->ID ) ) . '">' . $prdpost->ID . '</a>';

						array_push( $errors, 'Product ' . $prdpost->post_title . ' (' . $link . '): ' . "<br />" . $message );
					}
					if ( $woomessage != '' ) {
						$link = '<a href="' . esc_url( get_edit_post_link( (int) $prdpost->ID ) ) . '">' . $prdpost->ID . '</a>';

						array_push( $errors, 'Product ' . $prdpost->post_title . ' (' . $link . '), WooCommerce: ' . "<br />" . $woomessage );
					}

				} catch ( Exception $e ) {

					array_push( $errors, 'Product ' . $prdpost->post_title . ' (' . $prdpost->ID . '): ' . "<br />" . 'Exception ' . $e->getMessage() );
				}
			}

			$posts_found = get_posts( array(
				'posts_per_page'   => 250,
				'post_status'      => array( 'publish', 'draft' ),
				'post_type'        => ATKP_LIST_POSTTYPE,
				'suppress_filters' => true,

				'meta_query' => array(
					//comparison between the inner meta fields conditionals
					'relation' => 'OR',
					//meta field condition one
					array(
						'key' => ATKP_LIST_POSTTYPE . '_message',

						'compare' => 'EXISTS',
					)
				),
			) );

			foreach ( $posts_found as $prdpost ) {
				try {
					$message = ATKPTools::get_post_setting( $prdpost->ID, ATKP_LIST_POSTTYPE . '_message' );

					if ( $message != '' ) {
						$link = '<a href="' . esc_url( get_edit_post_link( (int) $prdpost->ID ) ) . '">' . $prdpost->ID . '</a>';

						array_push( $errors, 'List ' . $prdpost->post_title . ' (' . $link . '): ' . "<br />" . $message );
					}

				} catch ( Exception $e ) {
					array_push( $errors, 'List ' . $prdpost->post_title . ' (' . $prdpost->ID . '): ' . "<br />" . 'Exception ' . $e->getMessage() );
				}
			}


			$headers = array(
				'From: ' . get_bloginfo( 'name' ) . ' <' . get_bloginfo( 'admin_email' ) . '>',
				'Content-Type: text/html; charset=UTF-8'
			);

			//TODO: einschalten
			//TODO: empfänger
			//TODO: Betreff
			if ( sizeof( $errors ) > 0 || $overrideSending ) {
				wp_mail( $recipient, __( 'Affiliate Toolkit Report', ATKP_PLUGIN_PREFIX ), __( 'Following messages are currently stored in your records:  ', ATKP_PLUGIN_PREFIX ) . "<br />" . implode( "<br /><br />", $errors ), $headers );
			};


			ATKPLog::LogDebug( 'mail sent: ' . ( sizeof( $errors ) > 0 ) );

			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogDebug( '*** cronjob for datacheck finished ***' );
			}

		} catch ( Exception $e ) {
			ATKPLog::LogError( $e->getMessage() );
		}
	}

	public
	function send_message(
		$message
	) {
		$linebreak = '';

		if ( defined( 'ATKP_CLI' ) ) {
			$linebreak = PHP_EOL;
		} else {
			$linebreak = '<br />' . PHP_EOL;
		}

		if ( $this->echo_messages ) {
			echo date( 'H:i:s' ) . ' - ' . $message . $linebreak;
		}

		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( $message );
		}
	}


}


?>
