<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_bulkimport {
	public static $settings;

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_action( 'admin_menu', array( &$this, 'admin_menu' ) );
	}

	function admin_menu() {

		add_submenu_page(
			'edit.php?post_type=' . ATKP_PRODUCT_POSTTYPE,
			__( 'Product import', ATKP_PLUGIN_PREFIX ),
			__( 'Product import', ATKP_PLUGIN_PREFIX ),
			'edit_posts',
			'atkp_bulkimport',
			array( &$this, 'toolkit_bulkimport' )
		);

	}


	public function toolkit_bulkimport() {
		if ( ! is_user_logged_in() ) {
			wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
		}

		$selectedshopid = '';
		$keyword        = '';
		$page           = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_page', 'int' );;
		$searched     = false;
		$searchoption = 'keyword';

		$asintype = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_asintype', 'string' );;

		if ( ATKPTools::exists_post_parameter( 'nextpage' ) ) {
			$page ++;
		}

		if ( ATKPTools::exists_post_parameter( 'lastpage' ) ) {
			$page --;
		}

		if ( $page < 0 || ATKPTools::exists_post_parameter( 'searchbulk' ) ) {
			$page = 1;
		}

		if ( ATKPTools::exists_post_parameter( 'searchbulk' ) || ATKPTools::exists_post_parameter( 'nextpage' ) || ATKPTools::exists_post_parameter( 'lastpage' ) ) {

			$searched = true;
		}

		if ( $searched ) {
			if ( ! is_user_logged_in() ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			//wenn die seiten durchgeblättert werden dann wurde keine neue suche ausgeführt
			if ( ATKPTools::exists_post_parameter( 'nextpage' ) || ATKPTools::exists_post_parameter( 'lastpage' ) ) {
				$keyword        = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_keyword_search', 'string' );
				$selectedshopid = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_shop_search', 'string' );
				$searchoption   = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_option_search', 'string' );
			} else {
				$selectedshopid = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_shopid', 'string' );
				$keyword        = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_keyword', 'string' );
				$searchoption   = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_searchoption', 'string' );
			}

		}
		?>

        <form method="POST" action="?post_type=atkp_product&page=atkp_bulkimport">

            <div class="atkp-content wrap" style="margin-bottom:30px;float:none !important">
                <h3 class="hndle"><?php _e( 'Product import', ATKP_PLUGIN_PREFIX ); ?></h3>

                <div class="inner">

                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Shop', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select id="<?php echo ATKP_PLUGIN_PREFIX . '_shopid' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_shopid' ?>" style="width:300px">
									<?php

									echo '<option value=""> ' . __( 'All Shops', ATKP_PLUGIN_PREFIX ) . '</option>';

									$shps = atkp_shop::get_list( $selectedshopid );

									foreach ( $shps as $shp ) {

										$hasarticlesearch = ATKPTools::has_articlenumbersearch( $shp->webservice );

										if ( $shp->selected == true ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										echo '<option article_number="' . ( $hasarticlesearch ? 'true' : 'false' ) . '" value="' . $shp->id . '"' . $sel . ' > ' . esc_attr( $shp->title ) . '</option>';
									}

									?>
                                </select>


                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label id="searchcaption" for="">
									<?php _e( 'Create with this key', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select name="<?php echo ATKP_PLUGIN_PREFIX . '_asintype' ?>"
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_asintype' ?>" style="width:150px">
									<?php

									if ( $asintype == '' || $asintype == null ) {
										$asintype = 'ASIN';
									}

									$durations = array(
										'ASIN'          => __( 'Unique productid', ATKP_PLUGIN_PREFIX ),
										'EAN'           => __( 'EAN', ATKP_PLUGIN_PREFIX ),
										'TITLE'         => __( 'Title', ATKP_PLUGIN_PREFIX ),
										'ARTICLENUMBER' => __( 'Articlenumber', ATKP_PLUGIN_PREFIX ),
									);

									foreach ( $durations as $value => $name ) {
										if ( $value == $asintype ) {
											$sel = ' selected';
										} else {
											$sel = '';
										}

										echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
									} ?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label id="searchcaption" for="">
									<?php _e( 'Keyword', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input required type="text" style="width:300px" id="keyword"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_keyword" value="<?php echo $keyword ?>">
                                <br/> <br/>

                                <input type="radio" id="searchoption1"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_searchoption" <?php if ( $searchoption == 'keyword' ) {
									echo 'checked="checked"';
								} ?> value="keyword"/> <label
                                        for="searchoption1"><?php _e( 'Keyword', ATKP_PLUGIN_PREFIX ) ?></label>
                                <input type="radio" id="searchoption2"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_searchoption" <?php if ( $searchoption == 'asin' ) {
									echo 'checked="checked"';
								} ?> value="asin"/> <label
                                        for="searchoption2"><?php _e( 'ASIN(s)', ATKP_PLUGIN_PREFIX ) ?></label>
                                <input type="radio" id="searchoption3"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_searchoption" <?php if ( $searchoption == 'ean' ) {
									echo 'checked="checked"';
								} ?> value="ean"/> <label
                                        for="searchoption3"><?php _e( 'EAN(s)', ATKP_PLUGIN_PREFIX ) ?></label>
                                <input type="radio" id="searchoption4"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_searchoption" <?php if ( $searchoption == 'articlenumber' ) {
									echo 'checked="checked"';
								} ?> value="articlenumber"/> <label
                                        for="searchoption4"><?php _e( 'Articlenumber', ATKP_PLUGIN_PREFIX ) ?></label>

                                <br/> <br/>

                                <input type="submit" style="margin-top:5px" name="searchbulk" id="searchproduct-button"
                                       class="button primary-button" title="<?php _e( 'Search', ATKP_PLUGIN_PREFIX ) ?>"
                                       value="<?php _e( 'Search', ATKP_PLUGIN_PREFIX ) ?>"/>


                                <input type="hidden" id="page" name="<?php echo ATKP_PLUGIN_PREFIX ?>_page"
                                       value="<?php echo $page ?>">
                                <input type="hidden" id="keyword_search"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_keyword_search"
                                       value="<?php echo $keyword ?>">
                                <input type="hidden" id="shop_search"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_shop_search"
                                       value="<?php echo $selectedshopid ?>">
                                <input type="hidden" id="option_search"
                                       name="<?php echo ATKP_PLUGIN_PREFIX ?>_option_search"
                                       value="<?php echo $searchoption ?>">
                            </td>
                        </tr>


                    </table>


                </div>
            </div>

            <script type="text/javascript">
                var $j = jQuery.noConflict();
                $j(document).ready(function () {

                    $j("#<?php echo ATKP_PLUGIN_PREFIX . '_shopid' ?>").change(function () {

                        var hasarticlenumber = $j('option:selected', $j("#<?php echo ATKP_PLUGIN_PREFIX . '_shopid' ?>")).attr('article_number') == 'true';

                        $j('#searchoption4').prop('disabled', !hasarticlenumber);

                        if (!hasarticlenumber && $j('#searchoption4').is(':checked')) {
                            $j('#searchoption1').prop('checked', true);
                        }

                        if (!hasarticlenumber)
                            $j("#<?php echo ATKP_PLUGIN_PREFIX . '_asintype' ?> option[value='ARTICLENUMBER']").remove();
                        else {
                            if ($j("#<?php echo ATKP_PLUGIN_PREFIX . '_asintype' ?> option[value='ARTICLENUMBER']").length == 0)
                                $j("#<?php echo ATKP_PLUGIN_PREFIX . '_asintype' ?>").append('<option value="ARTICLENUMBER"><?php echo esc_attr( __( 'Articlenumber', ATKP_PLUGIN_PREFIX ) ) ?></option>');
                        }


                    });

                    $j("#<?php echo ATKP_PLUGIN_PREFIX . '_shopid' ?>").trigger('change');
                });

            </script>


			<?php
			$result = null;
			if ( $searched ) {

				if ( $selectedshopid == '' ) {

					$shops = atkp_shop::get_list( '', true );

					foreach ( $shops as $shop ) {
						echo '<h2>' . $shop->get_title() . ' (' . $shop->id . ')</h2>';

						echo '<div  class="atkp-backend-livesearch" init="' . esc_attr( ! $searched ? "1" : "0" ) . '" shopid="' . $shop->id . '" keyword="' . esc_attr( $keyword ) . '" searchoption="' . esc_attr( $searchoption ) . '" asintype="' . esc_attr( $asintype ) . '" endpointurl="' . esc_attr( ATKPTools::get_endpointurl() ) . '" ></div>';
					}


				} else {

					$shop = atkp_shop::load( $selectedshopid );

					if ( $shop != null && $shop->provider != null ) {
						$shop->provider->checklogon( $shop );
						$result = null;
						try {
							//$result = $shop->provider->retrieve_departments();

							$result = $shop->provider->quick_search( $keyword, $searchoption == 'asin' || $searchoption == 'ean' || $searchoption == 'articlenumber' ? $searchoption : 'product', $page );
						} catch ( Exception $e ) {

							ATKPLog::LogError( $e->getMessage() );

							echo $e->getMessage();

							$searched = false;
						}

						try {
							?>
                            <table class="wp-list-table widefat fixed striped" style="width:99%;">
                                <thead>
                                <tr>
                                    <th scope="col" class="manage-column"
                                        style="width: 100px;text-align:center">
										<?php _e( 'Image', ATKP_PLUGIN_PREFIX ) ?>
                                    </th>

                                    <th scope="col" class="manage-column column-primary">
										<?php _e( 'Title', ATKP_PLUGIN_PREFIX ) ?>
                                    </th>

                                    <th scope="col" class="manage-column">
										<?php _e( 'Custom Fields', ATKP_PLUGIN_PREFIX ) ?>
                                    </th>

                                    <th scope="col" class="manage-column" style="width:210px"
                                    ">
									<?php _e( 'Status', ATKP_PLUGIN_PREFIX ) ?>
                                    </th>

                                </tr>
                                </thead>

                                <tbody>

								<?php
								$newfields  = atkp_udfield::load_fields();
								$taxonomies = atkp_udtaxonomy::load_taxonomies();
								$helper     = new atkp_control_helper();


								$list = array();
								foreach ( $taxonomies as $taxonomy ) {
									if ( ! $taxonomy->showui || $taxonomy->isnewtax ) {
										continue;
									}

									array_push( $list, str_replace( '-', '_', 'atkp-tax-' . $taxonomy->name ) . ': getfieldvalue(\'#atkp-tax-' . $taxonomy->name . '-\'+$asin)' );
								}

								foreach ( $newfields as $newfield ) {
									//html controls überspringen
									if ( $newfield->type == 5 ) {
										continue;
									}

									array_push( $list, str_replace( '-', '_', 'atkp-field-' . $newfield->name ) . ': $j(\'#atkp-field-' . $newfield->name . '-\'+$asin).val()' );
								}

								$wooenabled = atkp_options::$loader->get_woo_enabled();

								if ( isset( $result ) && $result != null ) {
									foreach ( $result->products as $product ) {
										$asin = $product['asin'];
										?>

                                        <tr>
                                            <td style="text-align:center">
												<?php if ( isset( $product['imageurl'] ) ) {
													echo '<img src="' . $product['imageurl'] . '" style="max-width: 100px;" />';
												} ?>
                                            </td>

                                            <td>
                                                <input type="text" style="width:100%"
                                                       id="atkp-title-<?php echo $product['asin'] ?>"
                                                       value="<?php echo esc_attr( $product['title'] ) ?>"/>
                                                <br/>
												<?php _e( 'Unique ID', ATKP_PLUGIN_PREFIX ); ?>
                                                : <?php echo $asin; ?>,
                                                EAN: <?php if ( isset( $product['ean'] ) ) {
													echo $product['ean'];
												} else {
													echo '-';
												} ?>, <?php _e( 'Articlenumber', ATKP_PLUGIN_PREFIX ); ?>
                                                : <?php if ( isset( $product['articlenumber'] ) ) {
													echo $product['articlenumber'];
												} else {
													echo '-';
												}
												echo( isset( $product['saleprice'] ) ? ', ' . sprintf( __( 'Price: %s', ATKP_PLUGIN_PREFIX ), $product['saleprice'] ) : '-' );
												echo( isset( $product['info'] ) ? ', Information: ' . esc_html( $product['info'] ) : '' ) ?>
                                                <br/>
                                                <a href="<?php echo $product['producturl']; ?>"
                                                   target="_blank"><?php echo __( 'View product', ATKP_PLUGIN_PREFIX ); ?></a>
                                            </td>

                                            <td>
                                                <table class="form-table">

                                            <tr valign="top" <?php echo !get_option(ATKP_PLUGIN_PREFIX.'_fieldgroups_enabled', false) ? 'style="display:none"' : '' ?>>
                                                <td style="padding: 0;">
                                                     <label for="">
                                                        <?php _e('Import url', ATKP_PLUGIN_PREFIX) ?>:
                                                    </label>
                                                    <?php echo ATKPHomeLinks::GetHelpIcon('product-importurl'); ?>
                                                </td>
                                                <td style="padding: 0;">
                                                    <textarea style="width:100%" type="url" id="atkp-importurl-<?php echo $product['asin'] ?>" name="<?php echo ATKP_PRODUCT_POSTTYPE.'_importurl' ?>"> </textarea>
                                                </td>
                                            </tr>
                                    <?php

													$disable_select2 = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disableselect2', false );

													foreach ( $taxonomies as $taxonomy ) {
														if ( ! $taxonomy->showui ) {
															continue;
														} ?>

                                                        <tr valign="top">
                                                            <td style="padding: 0;">
                                                                <label for="">
																	<?php echo $taxonomy->caption == '' ? $taxonomy->name : $taxonomy->caption ?>
                                                                    :
                                                                </label>
                                                            </td>
                                                            <td style="padding: 0;">

																<?php


																?>

                                                                <select id="<?php echo 'atkp-tax-' . $taxonomy->name . '-' . $product['asin'] ?>"
                                                                        style="width:300px"
                                                                        multiple="multiple"
                                                                        class="atkp-taxonomy-select">

																	<?php
																	$categories = get_categories( 'orderby=name&hide_empty=0&taxonomy=' . $taxonomy->name );
																	foreach ( $categories as $category ) {
																		$option = '<option value="' . $category->cat_name . '">';
																		$option .= $category->cat_name;
																		//$option .= ' ('.$category->category_count.')';
																		$option .= '</option>';
																		echo $option;
																	}
																	?>
                                                                </select>
                                                            </td>
                                                        </tr>
														<?php
													}

													foreach ( $newfields as $newfield ) {
														//html controls überspringen
														if ( $newfield->type == 5 ) {
															continue;
														}
														$fieldname = $newfield->name;

														?>

                                                        <tr valign="top">
                                                            <td style="padding: 0;">
                                                                <label for="">
																	<?php echo $newfield->caption == '' ? $newfield->name : $newfield->caption ?>
                                                                    :
                                                                </label>
                                                            </td>
                                                            <td style="padding: 0;">

																<?php

																$helper->create_control( $newfield, 'atkp-field-' . $fieldname . '-' . $product['asin'], null );
																?>
                                                            </td>
                                                        </tr>
													<?php }
													?>

                                                </table>
                                            </td>

                                            <td>
												<?php

												$asin = '';
												switch ( $asintype ) {
													default:
													case 'ASIN':
														$asin = $product['asin'];
														break;
													case 'EAN':
														$asin = $product['ean'];
														break;
													case 'TITLE':
														$asin = $product['title'];
														break;
													case 'ARTICLENUMBER':
														$asin = $product['articlenumber'];
														break;

												}
												if ( $asin != '' ) {
													$args     = array(
														'meta_key'       => ATKP_PRODUCT_POSTTYPE . '_asin',
														'meta_value'     => $asin,
														'post_type'      => ATKP_PRODUCT_POSTTYPE,
														'post_status'    => array( 'publish', 'draft' ),
														'posts_per_page' => - 1
													);
													$subposts = get_posts( $args );
												}

												echo '<div id="atkp-status-' . $product['asin'] . '">';

												if ( isset( $subposts ) && count( $subposts ) > 0 ) {
													$myprd = $subposts[0];

													echo '<img style="vertical-align:middle" src="' . plugins_url( 'images/yes.png', ATKP_PLUGIN_FILE ) . '" alt="' . __( 'Imported', ATKP_PLUGIN_PREFIX ) . '"/>';
													echo '<a style="margin-left:5px" href="' . get_edit_post_link( $myprd->ID ) . '" target="_blank">' . __( 'Product imported.', ATKP_PLUGIN_PREFIX ) . '</a><br />';

												}

												echo '</div>';


												?>

                                                <input <?php echo $asin == '' ? 'disabled' : '' ?>
                                                        type="button"
                                                        style="margin-top:5px"
                                                        id="atkp-draft-<?php echo $product['asin'] ?>"
                                                        name="importdraft-<?php echo $product['asin'] ?>"
                                                        data-shop="<?php echo $selectedshopid ?>"
                                                        data-asin="<?php echo $product['asin'] ?>"
                                                        data-asin2="<?php echo $asin ?>"
                                                        data-asintype="<?php echo $asintype ?>"
                                                        data-status="draft"
                                                        class="import-button button"
                                                        title="<?php _e( 'Import as draft', ATKP_PLUGIN_PREFIX ) ?>"
                                                        value="<?php _e( 'Import as draft', ATKP_PLUGIN_PREFIX ) ?>"/><br/>
                                                <input <?php echo $asin == '' ? 'disabled' : '' ?>
                                                        type="button"
                                                        style="margin-top:5px"
                                                        id="atkp-publish-<?php echo $product['asin'] ?>"
                                                        name="importpublish-<?php echo $product['asin'] ?>"
                                                        data-shop="<?php echo $selectedshopid ?>"
                                                        data-asin="<?php echo $product['asin'] ?>"
                                                        data-asin2="<?php echo $asin ?>"
                                                        data-asintype="<?php echo $asintype ?>"
                                                        data-status="publish"
                                                        class="import-button button"
                                                        title="<?php _e( 'Import and publish', ATKP_PLUGIN_PREFIX ) ?>"
                                                        value="<?php _e( 'Import and publish', ATKP_PLUGIN_PREFIX ) ?>"/>
												<?php if ( $wooenabled ) ?>
                                                <input <?php echo $asin == '' ? 'disabled' : '' ?>
                                                        type="button"
                                                        style="margin-top:5px"
                                                        id="atkp-woo-<?php echo $product['asin'] ?>"
                                                        name="importwoo-<?php echo $product['asin'] ?>"
                                                        data-shop="<?php echo $selectedshopid ?>"
                                                        data-asin="<?php echo $product['asin'] ?>"
                                                        data-asin2="<?php echo $asin ?>"
                                                        data-asintype="<?php echo $asintype ?>"
                                                        data-status="woo"
                                                        class="import-button button"
                                                        title="<?php _e( 'Import for WooCommerce', ATKP_PLUGIN_PREFIX ) ?>"
                                                        value="<?php _e( 'Import for WooCommerce', ATKP_PLUGIN_PREFIX ) ?>"/>
												<?php ?>
                                            </td>

                                        </tr>

										<?php

									}
								}

								//TODO: wenn results < 10 dann nextpage ausblenden
								?>
                                </tbody>
                            </table>
							<?php
						} catch ( Exception $e ) {
							echo '<span style="color:red">';
							var_dump( $e );
							echo '</span>';
							$searched = false;
						}
					}
				}
			}

			if ( $selectedshopid != '' && $searched) {
				?>

                <div style="margin:10px">
					<?php
						if ( $result->currentpage > 1 ) { ?>
                            <input style="vertical-align:middle" type="submit" style="margin-top:5px" name="lastpage"
                                   class="button primary-button" title="<?php _e( 'Last page', ATKP_PLUGIN_PREFIX ) ?>"
                                   value="<?php _e( 'Previous page', ATKP_PLUGIN_PREFIX ) ?>"/>
						<?php }
					?>

                    <span style="margin-left:5px;margin-right:5px">
                        Seite <?php echo $result->currentpage; ?> von <?php echo $result->pagecount ?> (<?php echo $result->total ?> Ergebnisse)
                    </span>

					<?php if (  $result->currentpage < $result->pagecount ) { ?>
                        <input style="vertical-align:middle" type="submit" style="margin-top:5px" name="nextpage"
                               class="button primary-button" title="<?php _e( 'Next page', ATKP_PLUGIN_PREFIX ) ?>"
                               value="<?php _e( 'Next page', ATKP_PLUGIN_PREFIX ) ?>"/>
					<?php }
					?>
                </div>
			<?php } else if ( $searched ) {


				?>
                <div style="height:150px">&nbsp;</div>
                <div class="atkp-importoptions">

                <table style="border:0px">
                    <tr>
                        <td>
                            <input type="button" style="text-align:center;width:200px" name="atkp-importdraft"
                                   id="atkp-importdraft"
                                   class="button primary-button totalimportbutton"
                                   title="<?php _e( 'Import as draft', ATKP_PLUGIN_PREFIX ) ?>"
                                   data-asintype="<?php echo $asintype ?>"
                                   data-status="draft"
                                   value="<?php _e( 'Import as draft', ATKP_PLUGIN_PREFIX ) ?>"/>
                        </td>
                        <td>
                            <input type="button" style="text-align:center;width:200px" name="atkp-importpublish"
                                   id="atkp-importpublish"
                                   class="button primary-button totalimportbutton"
                                   title="<?php _e( 'Import and publish', ATKP_PLUGIN_PREFIX ) ?>"
                                   data-asintype="<?php echo $asintype ?>"
                                   data-status="publish"
                                   value="<?php _e( 'Import and publish', ATKP_PLUGIN_PREFIX ) ?>"/>
                        </td>
                        <td>
							<?php
							$wooenabled = atkp_options::$loader->get_woo_enabled();
							if ( $wooenabled ) { ?>
                                <input type="button" style="text-align:center;width:200px" name="atkp-importwoo"
                                       id="atkp-importwoo"
                                       class="button primary-button totalimportbutton"
                                       title="<?php _e( 'Import for WooCommerce', ATKP_PLUGIN_PREFIX ) ?>"
                                       data-asintype="<?php echo $asintype ?>"
                                       data-status="woo"
                                       value="<?php _e( 'Import for WooCommerce', ATKP_PLUGIN_PREFIX ) ?>"/>
							<?php } ?>
                        </td>
                    </tr>

                    <tr>
                        <td colspan="2">
                            <select style="width:100%" class="widefat" id="atkp-attachproduct"
                                    name="atkp-attachproduct">
								<?php

								echo '<option value="">' . __( 'no product', ATKP_PLUGIN_PREFIX ) . '</option>';

								$args        = array(
									'post_type'      => ATKP_PRODUCT_POSTTYPE,
									'posts_per_page' => 500,
									'post_status'    => array( 'publish', 'draft' )
								);
								$posts_array = get_posts( $args );
								foreach ( $posts_array as $prd ) {

									echo '<option value="' . $prd->ID . '">' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
								};

								?>
                            </select>
                        </td>
                        <td>
                            <input style="width:100%" type="button" style="text-align:center" name="atkp-importmerged"
                                   id="atkp-importmerged"
                                   class="button primary-button"
                                   title="<?php _e( 'Attach to product', ATKP_PLUGIN_PREFIX ) ?>"
                                   value="<?php _e( 'Add EAN to existing product', ATKP_PLUGIN_PREFIX ) ?>"/>
                        </td>
                    </tr>
                </table>
                </div><?php
			} ?>


        </form>

        <script type="text/javascript">
            var $j = jQuery.noConflict();

            $j(document).ready(function () {


                $j('.totalimportbutton').click(function (e) {
                    $j('.totalimportbutton').prop('disabled', true);

                    var asintype = $j(this).attr('data-asintype');
                    var status = $j(this).attr('data-status');

                    if ($j('input.atkp-checkboxstyle:checkbox:checked').length == 0) {
                        $j('.totalimportbutton').prop('disabled', false);
                    } else {
                        $j('input.atkp-checkboxstyle:checkbox:checked').each(function () {
                            var asin = $j(this).attr('asin');

                            $j('#atkp-status-' + asin).addClass('atkp-spinloader');
                        });


                        $j('input.atkp-checkboxstyle:checkbox:checked').each(function () {


                            var shopid = $j(this).attr('shopid');
                            var asin = $j(this).attr('asin');
                            var asinkey = $j(this).attr('asinkey');
                            var ean = $j(this).attr('ean');
                            var articlenumber = $j(this).attr('articlenumber');

                            var checkbox = $j(this);

                            $j.ajax({
                                type: "POST",
                                url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                                data: {
                                    action: "atkp_import_product",
                                    shop: shopid,
                                    asin: asinkey,
                                    asintype: asintype,
                                    status: status,
                                    request_nonce: "<?php echo wp_create_nonce( 'atkp-import-nonce' ) ?>"
                                },

                                dataType: "json",
                                success: function (data) {
                                    try {
                                        if (data.length == 0) {
                                            alert('unknown issue');
                                            return;
                                        } else if (typeof data[0].error != 'undefined') {
                                            alert(data[0].error + ': ' + data[0].message);
                                        }

                                        var posturl = data[0].edit_url;

                                        $j('#atkp-status-' + asin).removeClass('atkp-spinloader');
                                        $j('#atkp-status-' + asin).html('<img style="vertical-align:middle" src="<?php echo plugins_url( 'images/yes.png', ATKP_PLUGIN_FILE ) ?>" alt="<?php echo __( 'Imported', ATKP_PLUGIN_PREFIX ) ?>"/><a style="margin-left:5px" href="' + posturl + '" target="_blank"><?php echo __( 'Product imported.', ATKP_PLUGIN_PREFIX ) ?></a><br />');

                                        if ($j("#atkp-attachproduct option[value='" + data[0].postid + "']").length == 0)
                                            $j('#atkp-attachproduct').append('<option value="' + data[0].postid + '">' + data[0].title + '</option>');
                                        $j('#atkp-attachproduct').val(data[0].postid);

                                    } catch (err) {
                                        alert(err.message);
                                    }

                                    $j(checkbox).prop("checked", false);
                                    $j('.totalimportbutton').prop('disabled', false);

                                },
                                error: function (xhr, status) {
                                    alert(xhr.responseText);
                                    $j('#atkp-status-' + asin).removeClass('atkp-spinloader');
                                    $j('.totalimportbutton').prop('disabled', false);
                                }
                            });
                        });
                    }

                });

                $j('#atkp-importmerged').click(function (e) {
                    $j('#atkp-importmerged').prop('disabled', true);

                    var productid = $j('#atkp-attachproduct').val();

                    if ($j('input.atkp-checkboxstyle:checkbox:checked').length == 0) {
                        $j('.atkp-importmerged').prop('disabled', false);
                    } else {
                        $j('input.atkp-checkboxstyle:checkbox:checked').each(function () {
                            var asin = $j(this).attr('asin');

                            $j('#atkp-status-' + asin).addClass('atkp-spinloader');
                        });
                        $j('input.atkp-checkboxstyle:checkbox:checked').each(function () {

                            var asin = $j(this).attr('asin');
                            var ean = $j(this).attr('ean');

                            var checkbox = $j(this);

                            $j.ajax({
                                type: "POST",
                                url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                                data: {
                                    action: "atkp_live_addean_backend",
                                    productid: productid,
                                    ean: ean,
                                    request_nonce: "<?php echo wp_create_nonce( 'atkp-import-nonce' ) ?>"
                                },

                                dataType: "json",
                                success: function (data) {
                                    try {
                                        if (data.length == 0) {
                                            alert('unknown issue');
                                            return;
                                        } else if (typeof data[0].error != 'undefined') {
                                            alert(data[0].error + ': ' + data[0].message);
                                        }

                                        $j('#atkp-status-' + asin).removeClass('atkp-spinloader');


                                    } catch (err) {
                                        alert(err.message);
                                    }

                                    $j(checkbox).prop("checked", false);
                                    $j('#atkp-importmerged').prop('disabled', false);

                                },
                                error: function (xhr, status) {
                                    alert(xhr.responseText);
                                    $j('#atkp-status-' + asin).removeClass('atkp-spinloader');
                                    $j('#atkp-importmerged').prop('disabled', false);
                                }
                            });
                        });
                    }

                    $j(this).prop('disabled', false);

                });

                $j(".atkp-backend-livesearch").each(function (i, obj) {

                    var shopid = $j(obj).attr("shopid");
                    var keyword = $j(obj).attr("keyword");
                    var searchoption = $j(obj).attr("searchoption");
                    var endpointurl = $j(obj).attr('endpointurl');
                    var asintype = $j(obj).attr('asintype');
                    var init = $j(obj).attr('init');

                    if (init == "1") {
                        return;
                    }

                    $j(obj).addClass('atkp-spinloader');
                    $j('.atkp-livesearch-searching').show();

                    $j.post(endpointurl,
                        {
                            action: 'atkp_live_search_backend',
                            shopid: shopid,
                            keyword: keyword,
                            asintype: asintype,
                            searchoption: searchoption,
                        },
                        function (data, status) {
                            //alert("Data: " + data + "\nStatus: " + status);
                            if (status == 'success') {
                                $j('.atkp-livesearch-searching').hide();

                                if (data[0].html == 'noresultfound')
                                    $j('.atkp-livesearch-noresult').show();
                                else if (data[0].html == 'searchtermrequired')
                                    $j('.atkp-livesearch-searchtermrequired').show();
                                else
                                    $j(obj).html(data[0].html);

                                $j('.selectAll').click(function (e) {
                                    var table = $j(e.target).closest('table');
                                    $j('td input:checkbox', table).prop('checked', this.checked);
                                });
                            } else if (typeof data[0].error != 'undefined')
                                $j(obj).html("error on loading: " + data[0].error);
                            else
                                $j(obj).html("error on loading");

                            $j(obj).removeClass('atkp-spinloader');
                        });


                });
            });


            function getfieldvalue(fieldname) {

                if ($j(fieldname).val() == null)
                    return '';
                else
                    return ('' + $j(fieldname).val());
            }


            $j(document).ready(function () {

				<?php
				$disable_select2 = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disableselect2', false );

				if(! $disable_select2) { ?>

                $j('.atkp-taxonomy-select').each(function (i, obj) {
                    if (!$j(obj).data('select2')) {
                        var placeholder = $j(obj).attr('placeholder');

						<?php

						$placeholder = __( 'select value', ATKP_PLUGIN_PREFIX );
						?>

                        $j(obj).select2({
                            placeholder: "<?php echo $placeholder; ?>",
                            tags: true,
                            tokenSeparators: [',', ' ']
                        });
                    }
                });
				<?php } ?>

                $j(".import-button").click(function (e) {
                    var $asin = $j(this).attr('data-asin');
                    var $asin2 = $j(this).attr('data-asin2');
                    var $asintype = $j(this).attr('data-asintype');
                    $j('#atkp-draft-' + $asin).prop('disabled', true);
                    $j('#atkp-publish-' + $asin).prop('disabled', true);
                    if ($j('#atkp-woo-' + $asin).length)
                        $j('#atkp-woo-' + $asin).prop('disabled', true);

                    $j.ajax({
                        type: "POST",
                        url: "<?php echo ATKPTools::get_endpointurl(); ?>",
                        data: {
                            action: "atkp_import_product",
                            shop: $j(this).attr('data-shop'),
                            asin: $asin2,
                            asintype: $asintype,
                            title: $j('#atkp-title-' + $asin).val(),
                            status: $j(this).attr('data-status'),
                            importurl: $j('#atkp-importurl-' + $asin).val() <?php if ( isset( $list ) ) {
								foreach ( $list as $entry ) {
									echo ', ' . $entry;
								}
							} ?>    ,
                            request_nonce: "<?php echo wp_create_nonce( 'atkp-import-nonce' ) ?>"
                        },

                        dataType: "json",
                        success: function (data) {
                            try {
                                if (data.length == 0) {
                                    alert('unknown issue');
                                    return;
                                } else if (typeof data[0].error != 'undefined') {
                                    alert(data[0].error + ': ' + data[0].message);
                                }

                                var $posturl = data[0].edit_url;

                                $j('#atkp-status-' + $asin).html('<img style="vertical-align:middle" src="<?php echo plugins_url( 'images/yes.png', ATKP_PLUGIN_FILE ) ?>" alt="<?php echo __( 'Imported', ATKP_PLUGIN_PREFIX ) ?>"/><a style="margin-left:5px" href="' + $posturl + '" target="_blank"><?php echo __( 'Product imported.', ATKP_PLUGIN_PREFIX ) ?></a><br />');

                            } catch (err) {
                                alert(err.message);
                            }

                            $j('#atkp-draft-' + $asin).prop('disabled', false);
                            $j('#atkp-publish-' + $asin).prop('disabled', false);
                            if ($j('#atkp-woo-' + $asin).length)
                                $j('#atkp-woo-' + $asin).prop('disabled', false);
                        },
                        error: function (xhr, status) {
                            alert(xhr.responseText);
                            $j('#atkp-draft-' + $asin).prop('disabled', false);
                            $j('#atkp-publish-' + $asin).prop('disabled', false);
                            if ($j('#atkp-woo-' + $asin).length)
                                $j('#atkp-woo-' + $asin).prop('disabled', false);
                        }
                    });
                });
            });

        </script>

		<?php

	}
}


?>