<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_product_pricehistory {
	public $data = array();

	function __construct() {
		$this->id         = '';
		$this->productid  = '';
		$this->shopid     = '';
		$this->price      = '';
		$this->pricefloat = (float) 0;

		$this->createdon = '';
	}

	/**
	 * Lädt die Angebote zu der übergebenen Produkt-ID aus der offertable
	 *
	 * @param int $productid Die AT-Produkt-ID
	 *
	 * @return array Ein Array von Angeboten
	 */
	public static function load_history( $productid ) {


		$tablehelper = new atkp_pricehistorytable_helper();

		$pricehistory = $tablehelper->get_pricehistory_by_productid( $productid );

		if ( ! is_array( $pricehistory ) ) {
			$pricehistory = array();
		}

		return $pricehistory;
	}

	public static function get_lastxdays_history( $productid, $minifier_shops, $lastxdays ) {
		$tablehelper = new atkp_pricehistorytable_helper();

		$pricehistory = $tablehelper->get_pricehistory_by_productid_lastxdays( $productid, $minifier_shops, $lastxdays );

		if ( ! is_array( $pricehistory ) ) {
			$pricehistory = array();
		}

		return $pricehistory;
	}

	public static function get_monthly_history( $productid, $minifier_shops ) {

		$tablehelper = new atkp_pricehistorytable_helper();

		$pricehistory = $tablehelper->get_pricehistory_by_productid_monthly( $productid, $minifier_shops );

		if ( ! is_array( $pricehistory ) ) {
			$pricehistory = array();
		}

		return $pricehistory;

	}

	public function __get( $member ) {
		if ( isset( $this->data[ $member ] ) ) {
			return $this->data[ $member ];
		}
	}

	public function __set( $member, $value ) {
		// if (isset($this->data[$member])) {
		$this->data[ $member ] = $value;
		//}
	}
}


?>