<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_posttypes_template {
	private $nounce = '';

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		$this->register_templatePostType();

		add_action( 'add_meta_boxes', array( &$this, 'template_boxes' ) );
		add_action( 'save_post', array( &$this, 'template_detail_save' ) );

		$this->nounce = wp_create_nonce( 'atkp-export-template' );

		ATKPTools::add_column( ATKP_TEMPLATE_POSTTYPE, __( 'Action', ATKP_PLUGIN_PREFIX ), function ( $post_id ) {

			echo '<span style="font-weight:bold">' . __( 'ID', ATKP_PLUGIN_PREFIX ) . ':</span> <span >' . $post_id . '</span> ';

			echo '<br /><a href="' . ATKPTools::get_endpointurl() . '?action=atkp_export_template&templateid=' . $post_id . '&request_nonce=' . $this->nounce . '">' . __( 'Export', ATKP_PLUGIN_PREFIX ) . '</a>';
		}, 2 );


	}


	function register_templatePostType() {
		$labels = array(
			'name'               => __( 'Templates', ATKP_PLUGIN_PREFIX ),
			'singular_name'      => __( 'Template', ATKP_PLUGIN_PREFIX ),
			'add_new_item'       => __( 'Add new Template', ATKP_PLUGIN_PREFIX ),
			'edit_item'          => __( 'Edit Template', ATKP_PLUGIN_PREFIX ),
			'new_item'           => __( 'New Template', ATKP_PLUGIN_PREFIX ),
			'all_items'          => __( 'Templates', ATKP_PLUGIN_PREFIX ),
			'view_item'          => __( 'View Template', ATKP_PLUGIN_PREFIX ),
			'search_items'       => __( 'Search Templates', ATKP_PLUGIN_PREFIX ),
			'not_found'          => __( 'No lists found', ATKP_PLUGIN_PREFIX ),
			'not_found_in_trash' => __( 'No lists found in the Trash', ATKP_PLUGIN_PREFIX ),
			'parent_item_colon'  => '',
			'menu_name'          => __( 'Templates', ATKP_PLUGIN_PREFIX ),
		);
		$args   = array(
			'labels'      => $labels,
			'description' => 'Holds our templates',

			'public'              => false,  // it's not public, it shouldn't have it's own permalink, and so on
			'publicly_queriable'  => true,  // you should be able to query it
			'show_ui'             => true,  // you should be able to edit it in wp-admin
			'exclude_from_search' => true,  // you should exclude it from search results
			'show_in_nav_menus'   => false,  // you shouldn't be able to add it to menus
			'has_archive'         => false,  // it shouldn't have archive page
			'rewrite'             => false,  // it shouldn't have rewrite rules

			'capability_type' => 'page',

			'menu_position' => 200,
			'supports'      => array( 'title' ),
			'show_in_menu'  => ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
		);


		$args = apply_filters( 'atkp_template_register_post_type', $args );

		register_post_type( ATKP_TEMPLATE_POSTTYPE, $args );


	}

	function template_boxes() {

		add_meta_box(
			ATKP_TEMPLATE_POSTTYPE . '_detail_box',
			__( 'Template information', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'template_detail_box_content' ),
			ATKP_TEMPLATE_POSTTYPE,
			'normal',
			'default'
		);

		add_meta_box(
			ATKP_TEMPLATE_POSTTYPE . '_placeholder_box',
			__( 'Template placeholdes', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'template_placeholder_box_content' ),
			ATKP_TEMPLATE_POSTTYPE,
			'normal',
			'default'
		);


	}

	function template_detail_box_content( $post ) {
		wp_nonce_field( plugin_basename( __FILE__ ), 'template_detail_box_content_nonce' );

		?>
        <table class="form-table">

            <tr valign="top">
                <th scope="row">
                    <label for="">
						<?php _e( 'Type', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
					<?php echo ATKPHomeLinks::GetHelpIcon( 'templates-help' ); ?>
                </th>
                <td>
                    <select name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_template_type' ?>"
                            id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_template_type' ?>">
						<?php

						$durations = array(
							1 => __( 'Product template', ATKP_PLUGIN_PREFIX ),
							2 => __( 'Offer template', ATKP_PLUGIN_PREFIX ),
							3 => __( 'Images template', ATKP_PLUGIN_PREFIX ),
							4 => __( 'Compare tables', ATKP_PLUGIN_PREFIX ),
							5 => __( 'Search form template', ATKP_PLUGIN_PREFIX ),
							6 => __( 'Blade engine', ATKP_PLUGIN_PREFIX ),
						);


						foreach ( $durations as $value => $name ) {
							if ( $value == ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_template_type', 10 ) ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							$item_translated = '';

							echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
						} ?>
                    </select>

                    <br/><?php echo sprintf( __( 'You can find templates for the import in our %s', ATKP_PLUGIN_PREFIX ), ATKPHomeLinks::GetHelpLink( 'templates', __( 'documentation', ATKP_PLUGIN_PREFIX ) ) ) ?>
                    .
                </td>
            </tr>

            <tr class="comparetablerow">
				<?php
				$comparevalues = atkp_template_comparevalue::load_comparevalues( $post->ID ); ?>

                <td colspan="2">
                    <table style="width:100%" id="comparevalues">

                        <tr id="comparevalue-head">
                            <td style="width:160px;"><b><?php _e( 'Caption', ATKP_PLUGIN_PREFIX ) ?></b></td>
                            <td style="width:190px;"><b><?php _e( 'Description', ATKP_PLUGIN_PREFIX ) ?></b></td>
                            <td style="width:120px;"><b><?php _e( 'View', ATKP_PLUGIN_PREFIX ) ?></b></td>
                            <td style="width:120px;"><b><?php _e( 'CSS Class', ATKP_PLUGIN_PREFIX ) ?></b></td>
                            <td style="vertical-align:top"><b><?php _e( 'Detail', ATKP_PLUGIN_PREFIX ) ?></b></td>

                        </tr>


						<?php foreach ( $comparevalues as $comparevalue ) { ?>
                            <tr>
                                <td style="vertical-align:top">
                                    <input type="text"
                                           id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_caption_' . $comparevalue->id ?>"
                                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_caption_' . $comparevalue->id ?>"
                                           style="width:100%" value="<?php echo esc_attr( $comparevalue->caption ) ?>"/>
                                </td>
                                <td style="vertical-align:top">
                                    <input type="text"
                                           id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_description_' . $comparevalue->id ?>"
                                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_description_' . $comparevalue->id ?>"
                                           style="width:100%"
                                           value="<?php echo esc_attr( $comparevalue->description ) ?>"/>
                                </td>
                                <td style="vertical-align:top">
                                    <select style="width:100%"
                                            name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_viewtype_' . $comparevalue->id ?>"
                                            id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_viewtype_' . $comparevalue->id ?>">
										<?php

										$durations = array(
											1 => __( 'Desktop and mobile', ATKP_PLUGIN_PREFIX ),
											2 => __( 'Desktop', ATKP_PLUGIN_PREFIX ),
											3 => __( 'Mobile', ATKP_PLUGIN_PREFIX ),
										);

										foreach ( $durations as $value => $name ) {
											if ( $value == $comparevalue->viewtype ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
										} ?>
                                    </select>
                                    <br/>
                                    <select style="width:100%"
                                            name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_align_' . $comparevalue->id ?>"
                                            id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_align_' . $comparevalue->id ?>">
										<?php

										$durations = array(
											1 => __( 'Flush left', ATKP_PLUGIN_PREFIX ),
											2 => __( 'Centered', ATKP_PLUGIN_PREFIX ),
											3 => __( 'Flush right', ATKP_PLUGIN_PREFIX ),
										);

										foreach ( $durations as $value => $name ) {
											if ( $value == $comparevalue->align ) {
												$sel = ' selected';
											} else {
												$sel = '';
											}

											echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
										} ?>
                                    </select>
                                </td>
                                <td style="vertical-align:top">

                                    <input type="text"
                                           id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_cssclass_' . $comparevalue->id ?>"
                                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_cssclass_' . $comparevalue->id ?>"
                                           style="width:100%"
                                           value="<?php echo esc_attr( $comparevalue->cssclass ) ?>"/>
                                </td>
                                <td style="vertical-align:top">
                                    <input type="text"
                                           id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_detail_' . $comparevalue->id ?>"
                                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_compare_detail_' . $comparevalue->id ?>"
                                           style="width:100%"
                                           value="<?php echo htmlspecialchars( $comparevalue->detail ) ?>"/>
                                    <br/>
                                    <div style="text-align:right">
                                        <input type="button"
                                               id="removecomparevalue-button_<?php echo $comparevalue->id ?>"
                                               class="button remove-comparevalue"
                                               title="<?php _e( 'Remove', ATKP_PLUGIN_PREFIX ) ?>"
                                               value="<?php _e( 'Remove', ATKP_PLUGIN_PREFIX ) ?>"/>
                                        <input type="button" id="upcomparevalue-button_<?php echo $comparevalue->id ?>"
                                               class="button up-comparevalue"
                                               title="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>"
                                               value="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>"/>
                                        <input type="button"
                                               id="downcomparevalue-button_<?php echo $comparevalue->id ?>"
                                               class="button down-comparevalue"
                                               title="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>"
                                               value="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>"/>
                                    </div>

                                </td>
                            </tr>

						<?php } ?>
                    </table>
                </td>
            </tr>

            <tr valign="top" class="comparetablerow">

                <td colspan="2">
                    <input type="button" id="addcomparevalue-button" class="button add-comparevalue"
                           title="<?php _e( 'Add comparative value', ATKP_PLUGIN_PREFIX ) ?>"
                           value="<?php _e( 'Add comparative value', ATKP_PLUGIN_PREFIX ) ?>"/>
					<?php echo ATKPHomeLinks::GetHelpIcon( 'templates-compare' ); ?>
                </td>
            </tr>

            <tr valign="top" class="comparetablerow">
                <td>
                    <label style="font-weight:bold" for="">
						<?php _e( 'Type of display', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </td>
                <td>
                    <select style="width:100%" name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_viewtype' ?>"
                            id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_viewtype' ?>">
						<?php

						$durations = array(
							1 => __( 'desktop and mobile', ATKP_PLUGIN_PREFIX ),
							2 => __( 'desktop', ATKP_PLUGIN_PREFIX ),
							3 => __( 'mobile', ATKP_PLUGIN_PREFIX ),
						);

						$viewtype = ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_viewtype' );

						foreach ( $durations as $value => $name ) {
							if ( $value == $viewtype ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							echo '<option value="' . $value . '"' . $sel . '>' . esc_attr( $name ) . '</option>';
						} ?>
                    </select>
                </td>
            </tr>

            <tr valign="top" class="comparetablerow">
                <td>
                    <label style="font-weight:bold" for="">
						<?php _e( 'Max products', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </td>
                <td>
                    <input type="number" min="0" max="30" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxproducts' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxproducts' ?>"
                           value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_maxproducts' ) ); ?>">
                </td>
            </tr>

            <tr valign="top" class="comparetablerow">
                <td>
                    <label style="font-weight:bold" for="">
						<?php _e( 'Max products (mobile)', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </td>
                <td>
                    <input type="number" min="0" max="30"
                           id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts' ?>"
                           value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts' ) ); ?>">
                </td>
            </tr>


            <tr valign="top" class="comparetablerow">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' ), false ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars' ?>">
						<?php _e( 'Horizontal scrollbars (on desktops)', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>
            <tr valign="top" class="comparetablerow">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_hideheaders' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_hideheaders' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_hideheaders' ), true ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_hideheaders' ?>">
						<?php _e( 'Hide headers (desktop)', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>

            <tr valign="top" class="comparetablerow">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup' ), true ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup' ?>">
						<?php _e( 'Handle fieldgroup as group', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>


            <tr valign="top" class="comparetablerow">
                <td colspan="2">
                    <label style="font-weight:bold" for="">
						<?php _e( 'Mobile template', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:220px" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_mobilebody' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_mobilebody' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_mobilebody', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_extendedview' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_extendedview' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_extendedview' ), true ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_extendedview' ?>">
						<?php _e( 'Extended view', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow comparetablerow">
                <td colspan="2">
                    <label style="font-weight:bold" for="">
						<?php _e( 'Header', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>

                    <textarea style="width:100%;height:100px" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_header' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_header' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_header', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow">
                <td colspan="2">
                    <label style="font-weight:bold" for="" class="optional">
						<?php _e( 'Row Header', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:100px" class="optional"
                              id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body_header' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body_header' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_body_header', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow">
                <td colspan="2">
                    <label style="font-weight:bold" for="" class="optional">
						<?php _e( 'Header details', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:100px" class="optional"
                              id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_detail_header' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_detail_header' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_detail_header', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrowdetail filterrowdetail bladerow">
                <td colspan="2">
                    <label style="font-weight:bold" for="">
						<?php _e( 'Detail', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:220px" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_body', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow">
                <td colspan="2">
                    <label style="font-weight:bold" for="" class="optional">
						<?php _e( 'Footer details', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:100px" class="optional"
                              id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_detail_footer' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_detail_footer' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_detail_footer', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow">
                <td colspan="2">
                    <label style="font-weight:bold" for="" class="optional">
						<?php _e( 'Row Footer', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:100px" class="optional"
                              id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body_footer' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_body_footer' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_body_footer', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="placeholderrow comparetablerow">
                <td colspan="2">
                    <label style="font-weight:bold" for="">
						<?php _e( 'Footer', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:100px" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_footer' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_footer' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_footer' ) ); ?></textarea>

                </td>
            </tr>


            <tr valign="top" class="placeholderrow bladerow">
                <td colspan="2">
                    <label style="font-weight:bold" for="">
						<?php _e( 'CSS-Style', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                    <textarea style="width:100%;height:160px" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_css' ?>"
                              name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_css' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_css', true ) ); ?></textarea>
                </td>
            </tr>

            <tr valign="top" class="disclaimerrow">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer' ), true ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer' ?>">
						<?php _e( 'Disable disclaimer', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>

            <tr valign="top" class="offer">
                <td></td>
                <td>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_includemainoffer' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_includemainoffer' ?>"
                           value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_includemainoffer' ), true ); ?>>
                    <label class="offer" for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_includemainoffer' ?>">
						<?php _e( 'Additionally include main offer', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>

            <tr valign="top" class="offerstemplaterow">
                <th scope="row">
                    <label for="">
						<?php _e( '"Additional Offers" template', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>
                    <select <?php if ( ATKP_PLUGIN_VERSION < 30 ) {
						echo 'disabled';
					} ?> id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template' ?>"
                         name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template' ?>" style="width:300px">
						<?php
						$moreoffers_template = ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template' );

						echo '<option value="">' . __( 'website default', ATKP_PLUGIN_PREFIX ) . '</option>';

						echo '<option value="moreoffers" ' . ( $moreoffers_template == 'moreoffers' ? 'selected' : '' ) . '>' . __( 'Additional offers', ATKP_PLUGIN_PREFIX ) . '</option>';
						echo '<option value="moreoffers2" ' . ( $moreoffers_template == 'moreoffers2' ? 'selected' : '' ) . '>' . __( 'Additional offers 2', ATKP_PLUGIN_PREFIX ) . '</option>';

						if ( ATKP_PLUGIN_VERSION >= 30 ) {
							global $post;
							$args        = array(
								'post_type'      => ATKP_TEMPLATE_POSTTYPE,
								'posts_per_page' => 300,
								'post_status'    => array( 'publish', 'draft' )
							);
							$posts_array = get_posts( $args );
							foreach ( $posts_array as $prd ) {

								if ( $prd->ID == $moreoffers_template ) {
									$sel = ' selected';
								} else {
									$sel = '';
								}

								echo '<option value="' . $prd->ID . '"' . $sel . '>' . $prd->post_title . ' (' . $prd->ID . ')' . '</option>';
							};
						} ?>
                    </select>
                </td>
            </tr>

            <tr valign="top" class="offer">
                <td>
                    <label style="font-weight:bold" for="">
						<?php _e( 'Maximum amount of offers', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </td>
                <td>
                    <input type="number" min="0" max="50" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxoffers' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_maxoffers' ?>"
                           value="<?php echo esc_attr( ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_maxoffers' ) ); ?>">
                </td>
            </tr>


            <tr valign="top" class="filterrowdetail">
                <td>
                    <label style="font-weight:bold" for="">
						<?php _e( 'Filter target page', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </td>
                <td>
                    <select style="width:100%" name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_filtertarget' ?>"
                            id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_filtertarget' ?>">
						<?php

						$filtertarget = ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_filtertarget' );

						if ( '' == $filtertarget ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}

						echo '<option value=""' . $sel . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';

						$args = array(
							'post_type'      => array( 'page' ),
							'posts_per_page' => 100,
							'post_status'    => array( 'publish' ),
						);

						$posts = get_posts( $args );

						foreach ( $posts as $posttarget ) {

							if ( $posttarget->ID == $filtertarget ) {
								$sel = ' selected';
							} else {
								$sel = '';
							}

							echo '<option value="' . $posttarget->ID . '"' . $sel . '>' . esc_attr( $posttarget->post_title ) . '</option>';

						}


						?>
                    </select>
                </td>
            </tr>

            <tr valign="top" class="filterrowdetail">
                <td></td>
                <td>
					<?php

					$filtertargetblank = ATKPTools::get_post_setting( $post->ID, ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank' );


					?>
                    <input type="checkbox" id="<?php echo ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank' ?>"
                           name="<?php echo ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank' ?>"
                           value="1" <?php echo checked( 1, $filtertargetblank, true ); ?>>
                    <label for="<?php echo ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank' ?>">
						<?php _e( 'Open result page in new tab', ATKP_PLUGIN_PREFIX ) ?>
                    </label>
                </td>
            </tr>

        </table>


        <script type="text/javascript">
            var htmlelements = ["atkp_template_body", "atkp_template_mobilebody"];

            htmlelements.forEach(function (element) {
                var editor = CodeMirror.fromTextArea(document.getElementById(element), {
                    lineNumbers: true,
                    mode: "htmlmixed",
                });


            });


            editor = CodeMirror.fromTextArea(document.getElementById("atkp_template_css"), {
                lineNumbers: true,
                mode: "css"
            });


        </script>

        <style>
            .CodeMirror {
                max-width: 1024px;
                width: 100%;
                height: 500px;
                border: 1px solid gray;
            }


        </style>


        <script type="text/javascript">

            var $j = jQuery.noConflict();
            $j(document).ready(function () {

                $j('#<?php echo ATKP_TEMPLATE_POSTTYPE . '_extendedview' ?>').change(function () {

                    if ($j(this).prop('checked')) {
                        $j('.optional').show();
                    }
                    else {
                        $j('.optional').hide();
                    }
                });
                $j('#<?php echo ATKP_TEMPLATE_POSTTYPE . '_extendedview' ?>').trigger("change");

                $j('#<?php echo ATKP_TEMPLATE_POSTTYPE . '_template_type' ?>').change(function () {

                    $j('.filterrowdetail').hide();
                    $j('.offer').hide();
                    $j('.comparetablerow').hide();
                    $j('.placeholderrow').show();
                    $j('.placeholderrowdetail').show();


                    $j('.offerstemplaterow').hide();
                    $j('#filterplaceholder').hide();
                    $j('#productplaceholder').hide();
                    $j('#imagesplaceholder').hide();
                    $j('#offersplaceholder').hide();
                    $j('.disclaimerrow').show();
                    var templatetype = $j('#<?php echo ATKP_TEMPLATE_POSTTYPE . '_template_type' ?>').val();

                    switch (templatetype) {
                        case '1':
                            //produkte
                            $j('#productplaceholder').show();
                            $j('.offerstemplaterow').show();
                            break;
                        case '2':
                            //angebote
                            $j('.offer').show();
                            $j('#offersplaceholder').show();
                            break;
                        case '3':
                            //bildergalerie
                            $j('#imagesplaceholder').show();
                            break;
                        case '4':
                            //comparetable
                            $j('.placeholderrow').hide();
                            $j('.placeholderrowdetail').hide();
                            $j('.comparetablerow').show();
                            $j('#productplaceholder').show();
                            $j('.offerstemplaterow').show();
                            break;
                        case '5':
                            //filterbox
                            $j('.placeholderrow').hide();
                            $j('.filterrowdetail').show();
                            $j('#filterplaceholder').show();

                            $j('.disclaimerrow').hide();
                            break;
                        case '6':
                            $j('.placeholderrow').hide();
                            $j('.filterrowdetail').hide();
                            $j('#productplaceholder').hide();
                            $j('#filterplaceholder').hide();

                            $j('.disclaimerrow').hide();
                            $j('.bladerow').show();

                            break;
                    }

                });
                $j('#<?php echo ATKP_TEMPLATE_POSTTYPE . '_template_type' ?>').trigger("change");


                //comparetable functions

                function Generator() {
                };
                Generator.prototype.rand = Math.floor(Math.random() * 26) + Date.now();

                Generator.prototype.getId = function () {
                    return this.rand++;
                };
                var idGen = new Generator();

                $j('#addcomparevalue-button').click(function (e) {
                    var $id = idGen.getId();

                    $j('#comparevalues tr:last').after('<tr> <td style="vertical-align:top"> <input type="text" id="atkp_template_compare_caption_' + $id + '" name="atkp_template_compare_caption_' + $id + '" style="width:100%" value=""> </td> <td style="vertical-align:top"> <input type="text" id="atkp_template_compare_description_' + $id + '" name="atkp_template_compare_description_' + $id + '" style="width:100%" value=""> </td> <td style="vertical-align:top"> <select style="width:100%" name="atkp_template_compare_viewtype_' + $id + '" id="atkp_template_compare_viewtype_' + $id + '"> <option value="1"><?php _e( 'desktop and mobile', ATKP_PLUGIN_PREFIX ) ?></option><option value="2"><?php _e( 'desktop', ATKP_PLUGIN_PREFIX ); ?></option><option value="3"><?php _e( 'mobile', ATKP_PLUGIN_PREFIX ) ?></option></select> <br /> <select style="width:100%" name="atkp_template_compare_align_' + $id + '" id="atkp_template_compare_align_' + $id + '"> <option value="1"><?php _e( 'left', ATKP_PLUGIN_PREFIX ) ?></option><option value="2"><?php _e( 'center', ATKP_PLUGIN_PREFIX ) ?></option><option value="3"><?php _e( 'right', ATKP_PLUGIN_PREFIX ) ?></option></select> </td> <td style="vertical-align:top"><input type="text" id="atkp_template_compare_cssclass_' + $id + '" name="atkp_template_compare_cssclass_' + $id + '" style="width:100%" value=""></td><td style="vertical-align:top"> <input type="text" id="atkp_template_compare_detail_' + $id + '" name="atkp_template_compare_detail_' + $id + '" style="width:100%" value=""> <br /><div style="text-align:right"> <input type="button" id="removecomparevalue-button_' + $id + '" class="button remove-comparevalue" title="<?php _e( 'Remove', ATKP_PLUGIN_PREFIX ) ?>" value="<?php _e( 'Remove', ATKP_PLUGIN_PREFIX ) ?>"> <input type="button" id="upcomparevalue-button_' + $id + '" class="button up-comparevalue" title="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>" value="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>"><input type="button" id="downcomparevalue-button_' + $id + '" class="button down-comparevalue" title="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>" value="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>"></div></td> </tr>');


                    $j('#upcomparevalue-button_' + $id).click(moveup);
                    $j('#downcomparevalue-button_' + $id).click(movedown);
                    $j('#removecomparevalue-button_' + $id).click(deleterow);
                });

                $j('.remove-comparevalue').click(deleterow);

                function deleterow(e) {

                    if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                        $j(this).parent().parent().parent().remove();
                    }
                }

                $j('.up-comparevalue').click(moveup);

                function moveup(e) {
                    var row = $j(this).parent().parent().parent().prev();


                    if (row.length && row.attr('id') != 'comparevalue-head') {
                        var thisrow = $j(this).parent().parent().parent();

                        thisrow.remove();
                        thisrow.insertBefore(row);

                        thisrow.find('.up-comparevalue').click(moveup);
                        thisrow.find('.down-comparevalue').click(movedown);
                        thisrow.find('.remove-comparevalue').click(deleterow);
                    }
                }

                $j('.down-comparevalue').click(movedown);

                function movedown(e) {
                    var row = $j(this).parent().parent().parent().next();
                    if (row.length) {
                        var thisrow = $j(this).parent().parent().parent();

                        thisrow.remove();
                        thisrow.insertAfter(row);

                        thisrow.find('.down-comparevalue').click(movedown);
                        thisrow.find('.up-comparevalue').click(moveup);
                        thisrow.find('.remove-comparevalue').click(deleterow);
                    }
                }

                //comparetable functions
            });


        </script>

		<?php


	}

	function template_placeholder_box_content( $post ) {

		$posts_found = get_posts( array(
			'posts_per_page' => 1,
			'post_status'    => array( 'publish', 'draft' ),
			'post_type'      => ATKP_PRODUCT_POSTTYPE,
			'orderby'        => 'date',
			'order'          => 'desc',
		) );

		if ( sizeof( $posts_found ) == 0 ) {
			_e( 'Please create a product.', ATKP_PLUGIN_PREFIX );
		}

		$templatehelper = new atkp_template_helper();
		$captions       = $templatehelper->getPlaceholders();

		?>
        <table class="form-table" id="productplaceholder" style="table-layout: fixed;">
			<?php

			foreach ( $posts_found as $product ) {
				$prd          = atkp_product::load( $product->ID );
				$placeholders = $templatehelper->createPlaceholderArray( $prd, 1, '', '', '', 0 );
				ksort( $placeholders );
				// Search & Replace placeholders


				foreach ( array_keys( $placeholders ) as $key ) {
					?>
                    <tr valign="top">
                        <td scope="row" style="width:30%"><?php
							if ( isset( $captions[ $key ] ) ) {
								echo '<b>' . $captions[ $key ] . '</b><br />';
							}


							echo( '%' . strtolower( $key ) . '%' ) ?>
                        </td>
                        <td style="width:70%; word-wrap: break-word;overflow-wrap: break-word;"><?php echo( htmlspecialchars( $placeholders[ $key ] ) ) ?></td>
                    </tr>

					<?php


				}

			}

			?> </table>
        <table class="form-table" id="filterplaceholder" style="table-layout: fixed;">
			<?php
			$searchhelper = new atkp_searchform_helper();

			$placeholders = $searchhelper->createFilterPlaceholderArray();
			ksort( $placeholders );
			// Search & Replace placeholders


			foreach ( array_keys( $placeholders ) as $key ) {
				?>
                <tr valign="top">
                    <td scope="row" style="width:30%"><?php

						if ( isset( $captions[ $key ] ) ) {
							echo '<b>' . $captions[ $key ] . '</b><br />';
						}

						echo( '%' . strtolower( $key ) . '%' ) ?>
                    </td>
                    <td style="width:70%; word-wrap: break-word;overflow-wrap: break-word;"><?php echo( htmlspecialchars( $placeholders[ $key ] ) ) ?></td>
                </tr>

				<?php


			}

			?>

        </table>


        <table class="form-table" id="imagesplaceholder" style="table-layout: fixed;">
			<?php

			foreach ( $posts_found as $product ) {
				$prd = atkp_product::load( $product->ID );
				if ( is_array( $prd->images ) ) {
					foreach ( $prd->images as $newimage ) {
						$placeholders = $templatehelper->createImagePlaceholderArray( $prd, $newimage, 1, '', '' );
						ksort( $placeholders );

						// Search & Replace placeholders
						foreach ( array_keys( $placeholders ) as $key ) {
							?>
                            <tr valign="top">
                                <td scope="row" style="width:30%"><?php
									if ( isset( $captions[ $key ] ) ) {
										echo '<b>' . $captions[ $key ] . '</b><br />';
									}

									echo( '%' . strtolower( $key ) . '%' ) ?>
                                </td>
                                <td style="width:70%; word-wrap: break-word;overflow-wrap: break-word;"><?php echo( htmlspecialchars( $placeholders[ $key ] ) ) ?></td>
                            </tr>

							<?php


						}
						break;
					}
				}

			}

			?> </table>
        <table class="form-table" id="offersplaceholder" style="table-layout: fixed;">
		<?php

		foreach ( $posts_found as $product ) {
			$prd = atkp_product::load( $product->ID );
			if ( is_array( $prd->offers ) ) {
				foreach ( $prd->offers as $offer ) {
					if ( $offer->message != '' ) {
						continue;
					}

					$placeholders = $templatehelper->createOfferPlaceholderArray( $prd, $offer, 1, '', '' );
					ksort( $placeholders );
					// Search & Replace placeholders


					foreach ( array_keys( $placeholders ) as $key ) {
						?>
                        <tr valign="top">
                            <th scope="row" style="width:30%"><?php echo( '%' . strtolower( $key ) . '%' ) ?>
                            </th>
                            <td style="width:70%; word-wrap: break-word;overflow-wrap: break-word;"><?php echo( htmlspecialchars( $placeholders[ $key ] ) ) ?></td>
                        </tr>

						<?php


					}
					break;
				}
			}

		}

		?> </table><?php


	}


	function template_detail_save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$nounce = ATKPTools::get_post_parameter( 'template_detail_box_content_nonce', 'string' );

		if ( ! wp_verify_nonce( $nounce, plugin_basename( __FILE__ ) ) ) {
			return;
		}

		$post = get_post( $post_id );

		$posttype = $post->post_type; //ATKPTools::get_post_parameter('post_type', 'string');

		if ( ATKP_TEMPLATE_POSTTYPE != $posttype ) {
			return;
		}


		$templatetype = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_template_type', 'int' );

		$header = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_header', 'allhtml' );
		$body   = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_body', 'allhtml' );
		$footer = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_footer', 'allhtml' );

		$disabledisclaimer = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer', 'bool' );
		$extendedview      = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_extendedview', 'bool' );

		$bodyheader = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_body_header', 'allhtml' );
		$bodyfooter = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_body_footer', 'allhtml' );

		$detailheader = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_detail_header', 'allhtml' );
		$detailfooter = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_detail_footer', 'allhtml' );

		$includemainoffer = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_includemainoffer', 'bool' );
		$maxoffer         = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_maxoffers', 'int' );

		$css = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_css', 'allhtml' );

		$horizontalscrollbars = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars', 'bool' );

		$hideheaders       = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_hideheaders', 'bool' );
		$fieldgroupasgroup = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup', 'bool' );

		$maxmobileproducts = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts', 'int' );
		$maxproducts       = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_maxproducts', 'int' );

		$viewtype   = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_viewtype', 'int' );
		$mobilebody = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_mobilebody', 'allhtml' );

		$filtertarget        = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_filtertarget', 'string' );
		$filtertargetNewpage = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank', 'bool' );

		$moreoffers_template = ATKPTools::get_post_parameter( ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template', 'string' );


		// 1 => __('product template', ATKP_PLUGIN_PREFIX),
		// 2 => __('offer template', ATKP_PLUGIN_PREFIX),
		// 3 => __('images template', ATKP_PLUGIN_PREFIX),
		// 4 => __('compare table', ATKP_PLUGIN_PREFIX),
		// 5 => __('filter template', ATKP_PLUGIN_PREFIX),

		//global template settings
		ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_template_type', $templatetype );
		ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer', $disabledisclaimer );

		ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_header', $header );
		ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_footer', $footer );

		ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_moreoffers_template', $moreoffers_template );

		switch ( $templatetype ) {
			case 1:
			case 2:
			case 3:
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_extendedview', $extendedview );


				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_header', $bodyheader );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_header', $detailheader );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_footer', $detailfooter );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body', $body );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_footer', $bodyfooter );


				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_css', $css );

				if ( $templatetype == 2 ) {
					ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_includemainoffer', $includemainoffer );
					ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxoffers', $maxoffer );

				}
				break;
			case 4:

				$comparevalues = array();

				foreach ( $_POST as $key => $value ) {
					$rawvalue = $value;
					$key      = sanitize_text_field( $key );
					$value    = sanitize_text_field( $value );

					$id = str_replace( 'atkp_template_compare_caption_', '', $key );
					$id = str_replace( 'atkp_template_compare_description_', '', $id );
					$id = str_replace( 'atkp_template_compare_viewtype_', '', $id );
					$id = str_replace( 'atkp_template_compare_align_', '', $id );
					$id = str_replace( 'atkp_template_compare_detail_', '', $id );
					$id = str_replace( 'atkp_template_compare_cssclass_', '', $id );


					$udf     = new atkp_template_comparevalue();
					$udf->id = $id;

					//wert gültig
					$checkit = 0;
					//wert existiert noch nicht in der liste
					$add = 1;

					foreach ( $comparevalues as $comparevalue ) {
						if ( $comparevalue->id == $udf->id ) {
							$udf = $comparevalue;
							$add = 0;
							break;
						}
					}

					if ( $this->substr_startswith( $key, 'atkp_template_compare_caption_' ) ) {
						$checkit      = 1;
						$udf->caption = $value;
					} else if ( $this->substr_startswith( $key, 'atkp_template_compare_description_' ) ) {
						$checkit          = 1;
						$udf->description = $value;
					} else if ( $this->substr_startswith( $key, 'atkp_template_compare_viewtype_' ) ) {
						$checkit       = 1;
						$udf->viewtype = $value;
					} else if ( $this->substr_startswith( $key, 'atkp_template_compare_align_' ) ) {
						$checkit    = 1;
						$udf->align = $value;
					} else if ( $this->substr_startswith( $key, 'atkp_template_compare_detail_' ) ) {
						$checkit     = 1;
						$udf->detail = $rawvalue;
					} else if ( $this->substr_startswith( $key, 'atkp_template_compare_cssclass_' ) ) {
						$checkit       = 1;
						$udf->cssclass = $rawvalue;
					}

					if ( $checkit && $add ) {
						array_push( $comparevalues, $udf );
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_comparevalues', $comparevalues );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars', $horizontalscrollbars );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_hideheaders', $hideheaders );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_fieldgroupasgroup', $fieldgroupasgroup );


				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts', $maxmobileproducts );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxproducts', $maxproducts );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_viewtype', $viewtype );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_mobilebody', $mobilebody );


				break;
			case 5:
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body', $body );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_filtertarget', $filtertarget );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_filtertargetblank', $filtertargetNewpage );


				break;
			case 6:
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body', $body );
				ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_css', $css );

				break;
			default:
				throw new exception( 'templatetype unknown: ' . $templatetype );
		}


		ATKPTools::write_global_styles();
	}

	function substr_startswith( $haystack, $needle ) {
		return substr( $haystack, 0, strlen( $needle ) ) === $needle;
	}
}