<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_url_scraper {

	public function import_productdetails( $importurl, $post_id ) {
		try {
			if ( $importurl == null ) {
				return;
			}
			//parse url and update values...
			$allfields = array();

			$groups = ATKPTools::get_fieldgroups_by_productid( $post_id );

			foreach ( $groups as $group ) {

				$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );

				foreach ( $fields as $newfield ) {

					array_push( $allfields, $newfield );
				}
			}

			$newfields = $this->get_rows( $importurl );

			foreach ( $newfields as $nfield ) {
				try {
					$udf = null;

					foreach ( $allfields as $field ) {
						if ( $field->caption == sanitize_text_field( $nfield['name'] ) ) {
							$udf = $field;
							break;
						}
					}

					if ( $udf == null ) {
						continue;
					}

					$fieldvalue = sanitize_text_field( $nfield['caption'] );

					if ( $udf->type == 6 ) {

						//update taxonomy
						ATKPTools::check_taxonomy( $post_id, $udf->name, $fieldvalue, false );

					} else {
						$fieldname = 'cf_' . $udf->name;

						if ( $udf->format == 'number' ) {
							//extract number from string

							$fieldvalue = preg_replace( "/[^0-9]/", "", $fieldvalue );

							$fieldvalue = intval( $fieldvalue );
						}

						//$oldval =ATKPTools::get_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE.'_'.$fieldname);
						//if($oldval == '')
						ATKPTools::set_post_setting( $post_id, ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, $fieldvalue );
					}

				} catch ( Exception $e ) {

				}
			}


		} catch ( Exception $e ) {

		}

	}

	public function get_rows( $url ) {
		$fields = array();
		if($url != '')
			$url = trim($url);

		if ( ATKPTools::startsWith( $url, 'https://www.billiger.de/' ) ) {
			require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

			$dom = new \PHPHtmlParser\Dom;
			$dom->loadFromUrl($url,  [
				'enforceEncoding' => 'UTF-8',
				'htmlSpecialCharsDecode' => true, // Only applies to this load.
			]);


			$sections = $dom->getElementsByClass('key-value-pairs');

			foreach ($sections as $section) {

				$keys = $dom->load($section)->getElementsByClass('key');
				$values = $dom->load($section)->getElementsByClass('value');

				if(count($keys) == 0)
					continue;

				$idx = 0;
				foreach($keys as $key) {

					$field         = array();
					$field['name'] = trim( $key->innerHtml );
					$field['caption'] = trim( $values[$idx]->innerHtml );

					if ($field['name'] != '' ) {
						array_push( $fields, $field );
					}

					$idx++;
				}
			}


		}  else if ( ATKPTools::startsWith( $url, '<ul class="datasheet-list">' ) ) {
			require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

			$dom = new \PHPHtmlParser\Dom;
			$dom->loadStr($url);


			$sections = $dom->getElementsByClass('datasheet-listItem');

			foreach ($sections as $section) {

				$keys = $dom->load($section)->getElementsByClass('datasheet-listItemKey');
				$values = $dom->load($section)->getElementsByClass('datasheet-listItemValue');

				if(count($keys) == 0)
					continue;

				$idx = 0;
				foreach($keys as $key) {

					$field         = array();
					$field['name'] = trim( $key->innerHtml );
					$field['caption'] = trim( $values[$idx]->innerHtml );

					if ($field['name'] != '' ) {
						array_push( $fields, $field );
					}

					$idx++;
				}
			}




		}else {
			$arr = explode( "\n", $url );
			foreach ( $arr as $line ) {

				$parts = explode( "\t", $line );

				if ( count( $parts ) == 1 ) {
					//wenn kein tabulator dazwischen, trennen mittels leerzeichen

					$parts = explode( " ", $line );
				}

				$field         = array();
				$field['name'] = trim( $parts[0] );

				array_shift( $parts );

				$field['caption'] = trim( implode( " ", $parts ) );

				array_push( $fields, $field );

			}
		}

		//$udf = new atkp_udfield();

		return $fields;
	}
}

?>