<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_importtools {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {

	}

	public function importtools_configuration_page() {
		$imported = false;

		if ( ATKPTools::exists_post_parameter( 'saveimporttemplate' ) && check_admin_referer( 'save', 'save' ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}


			//reads the name of the file the user submitted for uploading
			$templatefile = $_FILES[ ATKP_PLUGIN_PREFIX . '_filetemplate' ]['name'];
			//if it is not empty
			if ( $templatefile ) {
				$importmessage = '';

				//get the original name of the file from the clients machine
				$filename = stripslashes( $_FILES[ ATKP_PLUGIN_PREFIX . '_filetemplate' ]['name'] );
				//get the extension of the file in a lower case format
				$extension = pathinfo( $filename, PATHINFO_EXTENSION );
				$extension = strtolower( $extension );
				//if it is not a known extension, we will suppose it is an error and will not upload the file,
				//we will only allow .ttf and .otf file extensions
				//otherwise we will do more tests
				if ( $extension != "txt" ) {
					//print error message
					$importmessage = 'Unknown fileextension!';
					$errors        = 1;
				} else {

					$contents = file_get_contents( $_FILES[ ATKP_PLUGIN_PREFIX . '_filetemplate' ]['tmp_name'] );

					try {

						$mytemplate = unserialize( $contents );

						if ( $mytemplate == null || $mytemplate->template_type == '' || $mytemplate->template_type == null ) {
							$importmessage = 'Unknown template type!';
						} else {
							$my_post = array(
								'post_title'  => $mytemplate->title,
								'post_type'   => ATKP_TEMPLATE_POSTTYPE,
								'post_status' => 'publish',
							);

							// Insert the post into the database
							$post_id = wp_insert_post( $my_post );

							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_disabledisclaimer', $mytemplate->disableddisclaimer );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_extendedview', $mytemplate->extendedview );

							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_template_type', $mytemplate->template_type );

							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_header', $mytemplate->header );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_header', $mytemplate->bodyheader );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_header', $mytemplate->detailheader );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_detail_footer', $mytemplate->detailfooter );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body', $mytemplate->body );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_body_footer', $mytemplate->bodyfooter );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_footer', $mytemplate->footer );

							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_css', $mytemplate->css );


							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_comparevalues', $mytemplate->comparevalues );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_horizontalscrollbars', $mytemplate->horizontalscrollbars );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_hideheaders', $mytemplate->hideheaders );

							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxmobileproducts', $mytemplate->maxmobileproducts );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_maxproducts', $mytemplate->maxproducts );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_viewtype', $mytemplate->viewtype );
							ATKPTools::set_post_setting( $post_id, ATKP_TEMPLATE_POSTTYPE . '_mobilebody', $mytemplate->mobilebody );

							$imported = true;
						}
					} catch ( Exception $e ) {
						$importmessage = 'Unknown content!<br />' . 'Fehler: ' . $e->getMessage();
					}

				}


			} else {
				$importmessage = '<b>file not found</b>';
			}
		}
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}
		?>
        <div class="wrap">
            <!-- <h2><?php _e( 'Affiliate Toolkit - Import', ATKP_PLUGIN_PREFIX ) ?></h2>      -->

            <form method="POST"
                  action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>"
                  enctype="multipart/form-data"><!--_affiliate_toolkit-bestseller-->
				<?php wp_nonce_field( "save", "save" ); ?>
                <table class="form-table" style="width:1024px">
                    <tr valign="top">
                        <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
							<?php _e( 'Select template for import', ATKP_PLUGIN_PREFIX ) ?>
                        </th>
                    </tr>

                    <tr valign="top">

                        <td colspan="2">
                            &nbsp;
                        </td>

                    </tr>


                    <tr valign="top">
                        <th>
                            <label for="<?php echo ATKP_PLUGIN_PREFIX . '_filetemplate' ?>">
								<?php _e( 'Select template file', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </th>
                        <td colspan="2">
                            <input type="file" name="<?php echo ATKP_PLUGIN_PREFIX . '_filetemplate' ?>">
                        </td>
                    </tr>

					<?php

					if ( $imported ) {
						?>

                        <tr valign="top">

                            <td colspan="2">

								<?php

								echo sprintf( __( '<a href="%s">open imported template</a>', ATKP_PLUGIN_PREFIX ), admin_url( '/post.php?post=' . $post_id . '&action=edit' ) );
								?>

                            </td>
                        </tr>
						<?php
					} else if ( isset( $importmessage ) && $importmessage != '' ) {
						echo '<tr><td colspan="2"><span style="color:red;font-weight:bold">' . $importmessage . '</span></td></tr>';
					}
					?>


                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                    <tr valign="top">

                        <td>
							<?php submit_button( '', 'primary', 'saveimporttemplate', false ); ?>
                        </td>
                    </tr>
                </table>
            </form>


        </div> <?php
	}
}

?>